/*
 * Decompiled with CFR 0.152.
 */
package com.goide.project.migration;

import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdk;
import com.goide.statistics.GoProjectModelMigrationUsageCollector;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectConverter;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

final class GoSdkModelConverter
extends ConverterProvider {
    private static final String PROJECT_ROOT_MANAGER = "ProjectRootManager";

    private GoSdkModelConverter() {
    }

    @NotNull
    public String getConversionDescription() {
        String string = GoBundle.message((String)"go.converter.sdk.description", (Object[])new Object[0]);
        if (string == null) {
            GoSdkModelConverter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public ProjectConverter createConverter(final @NotNull ConversionContext context) {
        if (context == null) {
            GoSdkModelConverter.$$$reportNull$$$0(1);
        }
        return new ProjectConverter(){

            @NotNull
            public ConversionProcessor<ComponentManagerSettings> createProjectFileConverter() {
                return new ProjectFileConverter(context);
            }

            @NotNull
            public ConversionProcessor<ModuleSettings> createModuleFileConverter() {
                return new ModuleFileConverter(context);
            }

            public boolean isConversionNeeded() {
                return context.getStorageScheme() == StorageScheme.DIRECTORY_BASED && GoSdkModelConverter.isProjectSdkHasGoType(context);
            }

            public void processingFinished() throws CannotConvertException {
                Element component2 = GoSdkModelConverter.getProjectRootManager(context);
                if (component2 != null) {
                    String oldSdkName = GoSdkModelConverter.removeSdkReference(GoSdkModelConverter.miscFile(context), component2);
                    GoSdkModelConverter.migrateJdkToSdk(context, oldSdkName);
                }
            }
        };
    }

    private static boolean isProjectSdkHasGoType(@NotNull ConversionContext context) {
        Element component2;
        if (context == null) {
            GoSdkModelConverter.$$$reportNull$$$0(2);
        }
        return (component2 = GoSdkModelConverter.getProjectRootManager(context)) != null && GoSdkModelConverter.isGoSdkType(component2.getAttributeValue("project-jdk-type"));
    }

    @NotNull
    private static Element rootElement(@NotNull Path path) throws CannotConvertException {
        if (path == null) {
            GoSdkModelConverter.$$$reportNull$$$0(3);
        }
        Element element = JDomConvertingUtil.load((Path)path);
        if (element == null) {
            GoSdkModelConverter.$$$reportNull$$$0(4);
        }
        return element;
    }

    private static void migrateJdkToSdk(@NotNull ConversionContext context, @Nullable String oldSdkName) {
        ProjectJdkTable sdkTable;
        Sdk jdk;
        if (context == null) {
            GoSdkModelConverter.$$$reportNull$$$0(5);
        }
        if (oldSdkName != null && (jdk = (sdkTable = ProjectJdkTable.getInstance()).findJdk(oldSdkName)) != null) {
            GoSdkModelConverter.setSdkPath(context, jdk.getHomePath());
        }
    }

    private static void setSdkPath(@NotNull ConversionContext context, @Nullable String sdkPath) {
        GoSdk sdk;
        if (context == null) {
            GoSdkModelConverter.$$$reportNull$$$0(6);
        }
        if ((sdk = GoSdk.fromHomePath(sdkPath)) != GoSdk.NULL) {
            try {
                Path workspaceXml = GoSdkModelConverter.getOrCreateWorkspaceXml(context);
                Element workspaceRootElement = context.getWorkspaceSettings().getRootElement();
                Element goRoot = JDomSerializationUtil.findOrCreateComponentElement((Element)workspaceRootElement, (String)"GOROOT");
                goRoot.setAttribute("url", sdk.getHomeUrl());
                JDOMUtil.writeDocument((Document)workspaceRootElement.getDocument(), (File)workspaceXml.toFile(), (String)System.lineSeparator());
            }
            catch (CannotConvertException | IOException throwable) {
                // empty catch block
            }
        }
    }

    @NotNull
    private static Path getOrCreateWorkspaceXml(@NotNull ConversionContext context) {
        Path workspaceXml;
        if (context == null) {
            GoSdkModelConverter.$$$reportNull$$$0(7);
        }
        if (!Files.exists(workspaceXml = Objects.requireNonNull(context.getSettingsBaseDir()).resolve("workspace.xml"), new LinkOption[0])) {
            PathKt.write((Path)workspaceXml, (CharSequence)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<project version=\"4\"/>"));
        }
        Path path = workspaceXml;
        if (path == null) {
            GoSdkModelConverter.$$$reportNull$$$0(8);
        }
        return path;
    }

    @NotNull
    private static Path sdkLibraryFile(@NotNull ConversionContext context) {
        if (context == null) {
            GoSdkModelConverter.$$$reportNull$$$0(9);
        }
        Path path = GoSdkModelConverter.getLibrariesDir(context).resolve("Go_SDK.xml");
        if (path == null) {
            GoSdkModelConverter.$$$reportNull$$$0(10);
        }
        return path;
    }

    @NotNull
    private static Path getLibrariesDir(@NotNull ConversionContext context) {
        if (context == null) {
            GoSdkModelConverter.$$$reportNull$$$0(11);
        }
        Path path = Objects.requireNonNull(context.getSettingsBaseDir()).resolve("libraries");
        if (path == null) {
            GoSdkModelConverter.$$$reportNull$$$0(12);
        }
        return path;
    }

    private static Element getProjectRootManager(@NotNull ConversionContext context) {
        if (context == null) {
            GoSdkModelConverter.$$$reportNull$$$0(13);
        }
        Path miscFile = GoSdkModelConverter.miscFile(context);
        try {
            if (miscFile.toFile().exists()) {
                return GoSdkModelConverter.getProjectRootManager(GoSdkModelConverter.rootElement(miscFile));
            }
        }
        catch (CannotConvertException e) {
            return null;
        }
        return null;
    }

    @Nullable
    private static Element getProjectRootManager(@Nullable Element rootElement) {
        return rootElement != null ? JDomSerializationUtil.findComponent((Element)rootElement, (String)PROJECT_ROOT_MANAGER) : null;
    }

    @Nullable
    private static String removeSdkReference(@NotNull Path path, @NotNull Element projectRootManager) throws CannotConvertException {
        if (path == null) {
            GoSdkModelConverter.$$$reportNull$$$0(14);
        }
        if (projectRootManager == null) {
            GoSdkModelConverter.$$$reportNull$$$0(15);
        }
        GoProjectModelMigrationUsageCollector.triggerSdkReference();
        String oldSdkName = projectRootManager.getAttributeValue("project-jdk-name");
        try {
            Document document = projectRootManager.getDocument();
            projectRootManager.detach();
            if (document != null) {
                JDOMUtil.writeDocument((Document)document, (String)path.toString(), (String)System.lineSeparator());
            }
        }
        catch (IOException e) {
            throw new CannotConvertException("Cannot remove SDK", (Throwable)e);
        }
        return oldSdkName;
    }

    @NotNull
    private static Path miscFile(@NotNull ConversionContext context) {
        if (context == null) {
            GoSdkModelConverter.$$$reportNull$$$0(16);
        }
        Path path = Objects.requireNonNull(context.getSettingsBaseDir()).resolve("misc.xml");
        if (path == null) {
            GoSdkModelConverter.$$$reportNull$$$0(17);
        }
        return path;
    }

    private static boolean isGoSdkType(String sdkTypeName) {
        return "Go SDK".equals(sdkTypeName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7, 9, 11, 13, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/project/migration/GoSdkModelConverter";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConversionDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/project/migration/GoSdkModelConverter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "rootElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateWorkspaceXml";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sdkLibraryFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrariesDir";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "miscFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConverter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isProjectSdkHasGoType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "rootElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "migrateJdkToSdk";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSdkPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateWorkspaceXml";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sdkLibraryFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLibrariesDir";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRootManager";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeSdkReference";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "miscFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7, 9, 11, 13, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }

    private static final class ModuleFileConverter
    extends ConversionProcessor<ModuleSettings> {
        private final ConversionContext myContext;

        private ModuleFileConverter(ConversionContext context) {
            this.myContext = context;
        }

        public boolean isConversionNeeded(@NotNull ModuleSettings settings) {
            if (settings == null) {
                ModuleFileConverter.$$$reportNull$$$0(0);
            }
            if (this.myContext.getStorageScheme() != StorageScheme.DIRECTORY_BASED) {
                return false;
            }
            if ("GO_MODULE".equals(settings.getModuleType())) {
                return true;
            }
            for (Element element : settings.getOrderEntries()) {
                if (!ModuleFileConverter.isGoOrderEntry(element, this.myContext) && !ModuleFileConverter.isGoPathOrderEntry(element) && !ModuleFileConverter.isGoSdkOrderEntry(element)) continue;
                return true;
            }
            return false;
        }

        public void process(@NotNull ModuleSettings settings) throws CannotConvertException {
            if (settings == null) {
                ModuleFileConverter.$$$reportNull$$$0(1);
            }
            if ("GO_MODULE".equals(settings.getModuleType())) {
                GoProjectModelMigrationUsageCollector.triggerModule();
                settings.setModuleType("WEB_MODULE");
            }
            boolean jdkTypeLibraryRemoved = false;
            boolean goPathLibraryRemoved = false;
            boolean goSdkLibraryRemoved = false;
            ArrayList<Element> entriesToDelete = new ArrayList<Element>();
            for (Element element : settings.getOrderEntries()) {
                if (ModuleFileConverter.isGoOrderEntry(element, this.myContext)) {
                    jdkTypeLibraryRemoved = true;
                    String oldJdkName = element.getAttributeValue("jdkName");
                    GoSdkModelConverter.migrateJdkToSdk(this.myContext, oldJdkName);
                    entriesToDelete.add(element);
                    continue;
                }
                if (ModuleFileConverter.isGoPathOrderEntry(element)) {
                    goPathLibraryRemoved = true;
                    entriesToDelete.add(element);
                    String library = StringUtil.notNullize((String)element.getAttributeValue("name"));
                    try {
                        Files.deleteIfExists(GoSdkModelConverter.getLibrariesDir(this.myContext).resolve(FileUtil.sanitizeFileName((String)library) + ".xml"));
                        continue;
                    }
                    catch (IOException e) {
                        throw new CannotConvertException((Throwable)e);
                    }
                }
                if (!ModuleFileConverter.isGoSdkOrderEntry(element)) continue;
                goSdkLibraryRemoved = true;
                Path sdkLibrary = GoSdkModelConverter.sdkLibraryFile(this.myContext);
                if (Files.exists(sdkLibrary, new LinkOption[0])) {
                    String url = ModuleFileConverter.getUrl(sdkLibrary);
                    if (url != null) {
                        String sdkPath = ModuleFileConverter.convertToPath(url);
                        GoSdkModelConverter.setSdkPath(this.myContext, sdkPath);
                    }
                    try {
                        Files.deleteIfExists(GoSdkModelConverter.sdkLibraryFile(this.myContext));
                    }
                    catch (IOException e) {
                        throw new CannotConvertException((Throwable)e);
                    }
                }
                entriesToDelete.add(element);
            }
            ModuleFileConverter.enableGoSupport((ComponentManagerSettings)settings);
            if (jdkTypeLibraryRemoved || goPathLibraryRemoved || goSdkLibraryRemoved) {
                File librariesDir;
                for (Element element : entriesToDelete) {
                    element.detach();
                }
                if (jdkTypeLibraryRemoved) {
                    GoProjectModelMigrationUsageCollector.triggerJdkType();
                }
                if (goPathLibraryRemoved) {
                    GoProjectModelMigrationUsageCollector.triggerGoPath();
                }
                if (goSdkLibraryRemoved) {
                    GoProjectModelMigrationUsageCollector.triggerGoSdk();
                    try {
                        Files.deleteIfExists(GoSdkModelConverter.sdkLibraryFile(this.myContext));
                    }
                    catch (IOException e) {
                        throw new CannotConvertException((Throwable)e);
                    }
                }
                if (ArrayUtil.isEmpty((Object[])(librariesDir = GoSdkModelConverter.getLibrariesDir(this.myContext).toFile()).list())) {
                    FileUtil.delete((File)librariesDir);
                }
            }
        }

        private static boolean isGoOrderEntry(Element element, ConversionContext context) {
            return GoSdkModelConverter.isGoSdkType(element.getAttributeValue("jdkType")) || GoSdkModelConverter.isProjectSdkHasGoType(context) && "inheritedJdk".equals(element.getAttributeValue("type"));
        }

        private static boolean isGoPathOrderEntry(Element element) {
            return "library".equals(element.getAttributeValue("type")) && StringUtil.notNullize((String)element.getAttributeValue("name")).startsWith("GOPATH");
        }

        private static boolean isGoSdkOrderEntry(Element element) {
            return "library".equals(element.getAttributeValue("type")) && GoSdkModelConverter.isGoSdkType(element.getAttributeValue("name"));
        }

        @Nullable
        private static String getUrl(@NotNull Path sdkLibrary) throws CannotConvertException {
            Element library;
            if (sdkLibrary == null) {
                ModuleFileConverter.$$$reportNull$$$0(2);
            }
            if ((library = JDomConvertingUtil.load((Path)sdkLibrary).getChild("library")) == null) {
                return null;
            }
            Element classes = library.getChild("CLASSES");
            if (classes == null) {
                return null;
            }
            Element root = classes.getChild("root");
            if (root == null) {
                return null;
            }
            return root.getAttributeValue("url");
        }

        @NotNull
        private static String convertToPath(@NotNull String url) {
            if (url == null) {
                ModuleFileConverter.$$$reportNull$$$0(3);
            }
            String string = VfsUtilCore.urlToPath((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)url, (String)"src/pkg"), (String)"src"), (String)"/"));
            if (string == null) {
                ModuleFileConverter.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static void enableGoSupport(@NotNull ComponentManagerSettings settings) {
            if (settings == null) {
                ModuleFileConverter.$$$reportNull$$$0(5);
            }
            Element rootElement = settings.getRootElement();
            Element goComponent = JDomSerializationUtil.findOrCreateComponentElement((Element)rootElement, (String)"Go");
            goComponent.setAttribute("enabled", "true");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkLibrary";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/project/migration/GoSdkModelConverter$ModuleFileConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/project/migration/GoSdkModelConverter$ModuleFileConverter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isConversionNeeded";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getUrl";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToPath";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "enableGoSupport";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ProjectFileConverter
    extends ConversionProcessor<ComponentManagerSettings> {
        private final ConversionContext myContext;

        private ProjectFileConverter(ConversionContext context) {
            this.myContext = context;
        }

        public boolean isConversionNeeded(@NotNull ComponentManagerSettings settings) {
            Element projectRootManager;
            if (settings == null) {
                ProjectFileConverter.$$$reportNull$$$0(0);
            }
            return (projectRootManager = GoSdkModelConverter.getProjectRootManager(settings.getRootElement())) != null && GoSdkModelConverter.isGoSdkType(projectRootManager.getAttributeValue("project-jdk-type"));
        }

        public void process(@NotNull ComponentManagerSettings settings) throws CannotConvertException {
            Element projectRootManager;
            if (settings == null) {
                ProjectFileConverter.$$$reportNull$$$0(1);
            }
            if ((projectRootManager = GoSdkModelConverter.getProjectRootManager(settings.getRootElement())) != null) {
                String oldSdkName = GoSdkModelConverter.removeSdkReference(settings.getPath(), projectRootManager);
                GoSdkModelConverter.migrateJdkToSdk(this.myContext, oldSdkName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "settings";
            objectArray2[1] = "com/goide/project/migration/GoSdkModelConverter$ProjectFileConverter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isConversionNeeded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

