/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi;

import com.goide.GoFileType;
import com.goide.GoLanguage;
import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoConstDeclaration;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportList;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoResolveCache;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.properties.GoFileProperties;
import com.goide.psi.properties.GoFilePropertiesGist;
import com.goide.psi.properties.GoFilePropertiesParser;
import com.goide.stubs.GoConstSpecStub;
import com.goide.stubs.GoFileStub;
import com.goide.stubs.GoVarSpecStub;
import com.goide.stubs.types.GoConstDeclarationStubElementType;
import com.goide.stubs.types.GoConstDefinitionStubElementType;
import com.goide.stubs.types.GoConstSpecStubElementType;
import com.goide.stubs.types.GoFunctionDeclarationStubElementType;
import com.goide.stubs.types.GoImportSpecStubElementType;
import com.goide.stubs.types.GoMethodDeclarationStubElementType;
import com.goide.stubs.types.GoTypeSpecStubElementType;
import com.goide.stubs.types.GoVarDeclarationStubElementType;
import com.goide.stubs.types.GoVarDefinitionStubElementType;
import com.goide.stubs.types.GoVarSpecStubElementType;
import com.goide.util.GoCacheUtilKt;
import com.goide.util.GoUtil;
import com.goide.vendor.GoDirectoryStructureModificationTracker;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.EmptyStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GoFile
extends PsiFileBase {
    private volatile GoFileProperties myProperties;

    public GoFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            GoFile.$$$reportNull$$$0(0);
        }
        super(viewProvider, GoLanguage.INSTANCE);
    }

    public void clearCaches() {
        this.myProperties = null;
        super.clearCaches();
    }

    @Nullable
    public String getImportPath(boolean withVendoring) {
        GoPackage aPackage = GoPackage.of(this);
        return aPackage != null ? aPackage.getImportPath(withVendoring) : null;
    }

    @NotNull
    public Collection<String> getAllImportPaths(boolean withVendoring) {
        GoPackage aPackage = GoPackage.of(this);
        Collection<String> collection = aPackage != null ? aPackage.getAllImportPaths(withVendoring) : Collections.emptyList();
        if (collection == null) {
            GoFile.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = GoUtil.goPathResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            GoFile.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GoUtil.goPathUseScope((PsiElement)this);
        if (globalSearchScope == null) {
            GoFile.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    @Nullable
    public GoPackageClause getPackage() {
        return (GoPackageClause)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            GoFileStub stub = this.getStub();
            if (stub != null) {
                StubElement<GoPackageClause> packageClauseStub = stub.getPackageClauseStub();
                return CachedValueProvider.Result.create((Object)(packageClauseStub != null ? (GoPackageClause)packageClauseStub.getPsi() : null), (Object[])new Object[]{this});
            }
            return CachedValueProvider.Result.create((Object)((GoPackageClause)this.findChildByClass(GoPackageClause.class)), (Object[])new Object[]{this});
        });
    }

    @Nullable
    public GoResolveCache getUnqualifiedResolveCache() {
        if (this.getStub() != null) {
            return null;
        }
        if (!Registry.is((String)"go.unqualified.cache.enabled")) {
            return null;
        }
        return (GoResolveCache)CachedValuesManager.getCachedValue((PsiElement)this, () -> GoCacheUtilKt.createResolveDependentResult(this.getProject(), new GoResolveCache(), new Object[]{this}));
    }

    @Nullable
    public GoResolveCache getQualifiedResolveCache() {
        if (!Registry.is((String)"go.qualified.cache.enabled")) {
            return null;
        }
        return (GoResolveCache)CachedValuesManager.getCachedValue((PsiElement)this, () -> GoCacheUtilKt.createResolveDependentResult(this.getProject(), new GoResolveCache(), new Object[]{this}));
    }

    @Nullable
    public GoImportList getImportList() {
        return (GoImportList)this.findChildByClass(GoImportList.class);
    }

    @Nullable
    public String getBuildFlags() {
        GoFileProperties properties = this.getFileProperties();
        return properties != null ? properties.buildFlags : null;
    }

    public boolean isGenerated() {
        GoFileProperties properties = this.getFileProperties();
        return properties != null && properties.isGenerated;
    }

    public boolean isPhysicalCopy() {
        return this.isPhysical() && this.getOriginalFile() != this;
    }

    @NotNull
    public Collection<? extends GoFunctionDeclaration> getFunctions() {
        Collection collection = this.getFunctionsMap().values();
        if (collection == null) {
            GoFile.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends GoFunctionDeclaration> getFunctions(@Nullable String name) {
        if (name != null) {
            Collection collection = this.getFunctionsMap().get((Object)name);
            if (collection == null) {
                GoFile.$$$reportNull$$$0(5);
            }
            return collection;
        }
        Collection collection = this.getFunctionsMap().values();
        if (collection == null) {
            GoFile.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends GoMethodDeclaration> getMethods(@Nullable String name) {
        List<GoMethodDeclaration> methods = this.getMethods();
        if (name == null) {
            List<GoMethodDeclaration> list = methods;
            if (list == null) {
                GoFile.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<GoMethodDeclaration> list = methods.stream().filter(method -> name.equals(method.getName())).toList();
        if (list == null) {
            GoFile.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private MultiMap<String, GoFunctionDeclaration> getFunctionsMap() {
        MultiMap multiMap = (MultiMap)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            GoFileStub stub = this.getStub();
            List functions = stub != null ? GoFile.getChildrenByType((StubElement<? extends PsiElement>)stub, GoTypes.FUNCTION_DECLARATION, GoFunctionDeclarationStubElementType.ARRAY_FACTORY) : GoPsiTreeUtil.goTraverser().children((Object)this).filter(GoFunctionDeclaration.class).toList();
            return CachedValueProvider.Result.create(GoPsiUtil.toMultiMap(functions, PsiNamedElement::getName), (Object[])new Object[]{this});
        });
        if (multiMap == null) {
            GoFile.$$$reportNull$$$0(9);
        }
        return multiMap;
    }

    @NotNull
    public List<GoMethodDeclaration> getMethods() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            GoFileStub stub = this.getStub();
            List calc = stub != null ? GoFile.getChildrenByType((StubElement<? extends PsiElement>)stub, GoTypes.METHOD_DECLARATION, GoMethodDeclarationStubElementType.ARRAY_FACTORY) : GoPsiTreeUtil.goTraverser().children((Object)this).filter(GoMethodDeclaration.class).toList();
            return CachedValueProvider.Result.create((Object)calc, (Object[])new Object[]{this});
        });
        if (list == null) {
            GoFile.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public Collection<? extends GoTypeSpec> getTypes() {
        Collection collection = this.getTypesMap().values();
        if (collection == null) {
            GoFile.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends GoTypeSpec> getTypes(@Nullable String name) {
        if (name != null) {
            Collection collection = this.getTypesMap().get((Object)name);
            if (collection == null) {
                GoFile.$$$reportNull$$$0(12);
            }
            return collection;
        }
        Collection collection = this.getTypesMap().values();
        if (collection == null) {
            GoFile.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    private MultiMap<String, GoTypeSpec> getTypesMap() {
        MultiMap multiMap = (MultiMap)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            GoFileStub stub = this.getStub();
            List<GoTypeSpec> types = stub != null ? GoFile.getChildrenByType((StubElement<? extends PsiElement>)stub, GoTypes.TYPE_SPEC, GoTypeSpecStubElementType.ARRAY_FACTORY) : this.calcTypes();
            return CachedValueProvider.Result.create(GoPsiUtil.toMultiMap(types, PsiNamedElement::getName), (Object[])new Object[]{this});
        });
        if (multiMap == null) {
            GoFile.$$$reportNull$$$0(14);
        }
        return multiMap;
    }

    @NotNull
    public List<GoImportSpec> getImports() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            GoFileStub stub = this.getStub();
            List<GoImportSpec> imports = stub != null ? GoFile.getChildrenByType((StubElement<? extends PsiElement>)stub, GoTypes.IMPORT_SPEC, GoImportSpecStubElementType.ARRAY_FACTORY) : this.calcImports();
            return CachedValueProvider.Result.create(imports, (Object[])new Object[]{this});
        });
        if (list == null) {
            GoFile.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Nullable
    public GoImportSpec addImport(@NotNull String path, @Nullable String alias) {
        GoImportList importList;
        if (path == null) {
            GoFile.$$$reportNull$$$0(16);
        }
        if ((importList = this.getImportList()) != null) {
            return importList.addImport(path, alias);
        }
        return null;
    }

    @NotNull
    public Map<String, GoImportSpec> getImportedPackagesMap() {
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcImportedPackagesMap(this.getImports()), (Object[])new Object[]{this}));
        if (map == null) {
            GoFile.$$$reportNull$$$0(17);
        }
        return map;
    }

    @NotNull
    protected Map<String, GoImportSpec> calcImportedPackagesMap(@NotNull List<GoImportSpec> imports) {
        if (imports == null) {
            GoFile.$$$reportNull$$$0(18);
        }
        HashMap<String, GoImportSpec> map = new HashMap<String, GoImportSpec>();
        for (GoImportSpec spec : imports) {
            String importPath;
            if (spec.isForSideEffects() || !StringUtil.isNotEmpty((String)(importPath = spec.getPath()))) continue;
            map.put(importPath, spec);
        }
        HashMap<String, GoImportSpec> hashMap = map;
        if (hashMap == null) {
            GoFile.$$$reportNull$$$0(19);
        }
        return hashMap;
    }

    @NotNull
    public MultiMap<String, GoImportSpec> getImportMap() {
        MultiMap multiMap = (MultiMap)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            Pair<MultiMap<String, GoImportSpec>, List<Object>> result = this.calcImportMap(this.getImports());
            return CachedValueProvider.Result.create((Object)((MultiMap)result.first), (Object[])ArrayUtil.toObjectArray((Collection)((Collection)result.second)));
        });
        if (multiMap == null) {
            GoFile.$$$reportNull$$$0(20);
        }
        return multiMap;
    }

    @NotNull
    protected Pair<MultiMap<String, GoImportSpec>, List<Object>> calcImportMap(@NotNull List<GoImportSpec> imports) {
        if (imports == null) {
            GoFile.$$$reportNull$$$0(21);
        }
        MultiMap map = MultiMap.createLinked();
        SmartList dependencies = new SmartList((Object)this);
        for (GoImportSpec spec : imports) {
            String alias = spec.getAlias();
            if (alias != null) {
                map.putValue((Object)alias, (Object)spec);
                continue;
            }
            if (spec.isDot()) {
                map.putValue((Object)".", (Object)spec);
                continue;
            }
            Collection<GoPackage> packages = spec.resolve(ResolveState.initial());
            if (packages.isEmpty()) {
                map.putValue((Object)GoPsiImplUtil.sanitizePackageName(spec.getPath()), (Object)spec);
                dependencies.add(GoDirectoryStructureModificationTracker.getInstance());
            }
            for (GoPackage aPackage : packages) {
                map.putValue((Object)aPackage.getName(), (Object)spec);
                dependencies.add(aPackage.getModificationTracker());
            }
            dependencies.add(GoCacheUtilKt.getStubIndexModificationTracker());
        }
        Pair pair = Pair.create((Object)map, (Object)dependencies);
        if (pair == null) {
            GoFile.$$$reportNull$$$0(22);
        }
        return pair;
    }

    @NotNull
    public Collection<? extends GoVarDefinition> getVars() {
        Collection collection = this.getVarsMap().values();
        if (collection == null) {
            GoFile.$$$reportNull$$$0(23);
        }
        return collection;
    }

    public Collection<? extends GoVarDefinition> getVars(@Nullable String name) {
        if (name != null) {
            return this.getVarsMap().get((Object)name);
        }
        return this.getVarsMap().values();
    }

    @NotNull
    private MultiMap<String, GoVarDefinition> getVarsMap() {
        MultiMap multiMap = (MultiMap)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            List<GoVarDefinition> result;
            GoFileStub stub = this.getStub();
            if (stub != null) {
                result = new ArrayList<GoVarDefinition>();
                List<GoVarDeclaration> varDeclarations = GoFile.getChildrenByType((StubElement<? extends PsiElement>)stub, GoTypes.VAR_DECLARATION, GoVarDeclarationStubElementType.ARRAY_FACTORY);
                for (GoVarDeclaration vd : varDeclarations) {
                    EmptyStub vdStub = (EmptyStub)vd.getStub();
                    if (vdStub == null) continue;
                    List<GoVarSpec> varSpecs = GoFile.getChildrenByType((StubElement<? extends PsiElement>)vdStub, GoTypes.VAR_SPEC, GoVarSpecStubElementType.ARRAY_FACTORY);
                    for (GoVarSpec spec : varSpecs) {
                        GoVarSpecStub specStub = (GoVarSpecStub)spec.getStub();
                        if (specStub == null) continue;
                        result.addAll(GoFile.getChildrenByType((StubElement<? extends PsiElement>)specStub, GoTypes.VAR_DEFINITION, GoVarDefinitionStubElementType.ARRAY_FACTORY));
                    }
                }
            } else {
                result = this.calcVars();
            }
            return CachedValueProvider.Result.create(GoPsiUtil.toMultiMap(result, PsiNamedElement::getName), (Object[])new Object[]{this});
        });
        if (multiMap == null) {
            GoFile.$$$reportNull$$$0(24);
        }
        return multiMap;
    }

    @NotNull
    public Collection<? extends GoConstDefinition> getConstants() {
        Collection collection = this.getConstantsMap().values();
        if (collection == null) {
            GoFile.$$$reportNull$$$0(25);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends GoConstDefinition> getConstants(@Nullable String name) {
        if (name != null) {
            Collection collection = this.getConstantsMap().get((Object)name);
            if (collection == null) {
                GoFile.$$$reportNull$$$0(26);
            }
            return collection;
        }
        Collection collection = this.getConstantsMap().values();
        if (collection == null) {
            GoFile.$$$reportNull$$$0(27);
        }
        return collection;
    }

    @NotNull
    private MultiMap<String, GoConstDefinition> getConstantsMap() {
        MultiMap multiMap = (MultiMap)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            List<GoConstDefinition> result;
            GoFileStub stub = this.getStub();
            if (stub != null) {
                result = new ArrayList<GoConstDefinition>();
                List<GoConstDeclaration> constDeclarations = GoFile.getChildrenByType((StubElement<? extends PsiElement>)stub, GoTypes.CONST_DECLARATION, GoConstDeclarationStubElementType.ARRAY_FACTORY);
                for (GoConstDeclaration cd : constDeclarations) {
                    EmptyStub cdStub = (EmptyStub)cd.getStub();
                    if (cdStub == null) continue;
                    List<GoConstSpec> constSpecs = GoFile.getChildrenByType((StubElement<? extends PsiElement>)cdStub, GoTypes.CONST_SPEC, GoConstSpecStubElementType.ARRAY_FACTORY);
                    for (GoConstSpec spec : constSpecs) {
                        GoConstSpecStub specStub = (GoConstSpecStub)spec.getStub();
                        if (specStub == null) continue;
                        result.addAll(GoFile.getChildrenByType((StubElement<? extends PsiElement>)specStub, GoTypes.CONST_DEFINITION, GoConstDefinitionStubElementType.ARRAY_FACTORY));
                    }
                }
            } else {
                result = this.calcConsts();
            }
            return CachedValueProvider.Result.create(GoPsiUtil.toMultiMap(result, PsiNamedElement::getName), (Object[])new Object[]{this});
        });
        if (multiMap == null) {
            GoFile.$$$reportNull$$$0(28);
        }
        return multiMap;
    }

    @NotNull
    private List<GoTypeSpec> calcTypes() {
        List list = GoPsiTreeUtil.goTraverser().children((Object)this).filter(GoTypeDeclaration.class).flatten(GoTypeDeclaration::getTypeSpecList).toList();
        if (list == null) {
            GoFile.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    protected List<GoImportSpec> calcImports() {
        GoImportList list = this.getImportList();
        if (list == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                GoFile.$$$reportNull$$$0(30);
            }
            return list2;
        }
        ArrayList<GoImportSpec> result = new ArrayList<GoImportSpec>();
        for (GoImportDeclaration declaration : list.getImportDeclarationList()) {
            result.addAll(declaration.getImportSpecList());
        }
        ArrayList<GoImportSpec> arrayList = result;
        if (arrayList == null) {
            GoFile.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    private List<GoVarDefinition> calcVars() {
        List list = GoPsiTreeUtil.goTraverser().children((Object)this).filter(GoVarDeclaration.class).flatten(GoVarDeclaration::getVarSpecList).flatten(GoVarSpec::getVarDefinitionList).toList();
        if (list == null) {
            GoFile.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    private List<GoConstDefinition> calcConsts() {
        List list = GoPsiTreeUtil.goTraverser().children((Object)this).filter(GoConstDeclaration.class).flatten(GoConstDeclaration::getConstSpecList).flatten(GoConstSpec::getConstDefinitionList).toList();
        if (list == null) {
            GoFile.$$$reportNull$$$0(33);
        }
        return list;
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = GoFileType.INSTANCE;
        if (languageFileType == null) {
            GoFile.$$$reportNull$$$0(34);
        }
        return languageFileType;
    }

    public boolean hasMainFunction() {
        return this.getFunctionsMap().containsKey((Object)"main");
    }

    @Nullable
    public String getPackageName() {
        GoFileProperties properties = this.getFileProperties();
        return properties != null ? properties.packageName : null;
    }

    @Deprecated
    @Nullable
    public String getCanonicalPackageName() {
        GoFileProperties properties = this.getFileProperties();
        return properties != null ? properties.getCanonicalPackageName(this.getViewProvider().getVirtualFile()) : null;
    }

    @Nullable
    public GoFileStub getStub() {
        return (GoFileStub)super.getStub();
    }

    public void deleteImport(@NotNull GoImportSpec importSpec) {
        if (importSpec == null) {
            GoFile.$$$reportNull$$$0(35);
        }
        GoImportDeclaration importDeclaration = (GoImportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)importSpec, GoImportDeclaration.class);
        assert (importDeclaration != null);
        GoCompositeElement elementToDelete = importDeclaration.getImportSpecList().size() == 1 ? importDeclaration : importSpec;
        elementToDelete.delete();
    }

    @NotNull
    private static <E extends PsiElement> List<E> getChildrenByType(@NotNull StubElement<? extends PsiElement> stub, IElementType elementType, ArrayFactory<E> f) {
        if (stub == null) {
            GoFile.$$$reportNull$$$0(36);
        }
        List<PsiElement> list = Arrays.asList(stub.getChildrenByType(elementType, f));
        if (list == null) {
            GoFile.$$$reportNull$$$0(37);
        }
        return list;
    }

    @NotNull
    private @Unmodifiable Collection<PsiComment> getTopLineComments() {
        SmartList commentsToConsider = new SmartList();
        int lastEmptyLineOffset = 0;
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiComment && ((PsiComment)child).getTokenType() == GoParserDefinition.Lazy.LINE_COMMENT) {
                commentsToConsider.add((PsiComment)child);
                continue;
            }
            if (!(child instanceof PsiWhiteSpace)) break;
            if (StringUtil.countChars((CharSequence)child.getText(), (char)'\n') <= 1) continue;
            lastEmptyLineOffset = child.getTextRange().getStartOffset();
        }
        int finalLastEmptyLineOffset = lastEmptyLineOffset;
        List list = ContainerUtil.filter((Collection)commentsToConsider, comment -> comment.getTextRange().getStartOffset() < finalLastEmptyLineOffset);
        if (list == null) {
            GoFile.$$$reportNull$$$0(38);
        }
        return list;
    }

    @Nullable
    public GoFileProperties getFileProperties() {
        GoFileProperties properties = this.myProperties;
        if (properties != null) {
            return properties;
        }
        PsiFile originalFile = this.getOriginalFile();
        VirtualFile virtualFile = originalFile.getViewProvider().getVirtualFile();
        this.myProperties = FileDocumentManager.getInstance().isFileModified(virtualFile) ? new GoFilePropertiesParser().parse(this.getText()) : (GoFileProperties)GoFilePropertiesGist.getInstance().getGist().getFileData(this.getProject(), virtualFile);
        return this.myProperties;
    }

    @NotNull
    public List<PsiComment> getBuildFlagElements() {
        SmartList result = new SmartList();
        for (PsiComment comment : this.getTopLineComments()) {
            String commentText = StringUtil.trimStart((String)comment.getText(), (String)"//").trim();
            if (!GoPsiUtil.isBuildTagComment(commentText)) continue;
            result.add(comment);
        }
        SmartList smartList = result;
        if (smartList == null) {
            GoFile.$$$reportNull$$$0(39);
        }
        return smartList;
    }

    @Nullable
    public PsiComment getGoBuildDirectiveElement() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (GoPsiUtil.isGoBuildDirective(child)) {
                return (PsiComment)child;
            }
            if (!(child instanceof PsiWhiteSpace) && !(child instanceof PsiComment)) break;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/GoFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/GoFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllImportPaths";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctions";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionsMap";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getImports";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedPackagesMap";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "calcImportedPackagesMap";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportMap";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "calcImportMap";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getVars";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarsMap";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstants";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantsMap";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTypes";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "calcImports";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "calcVars";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "calcConsts";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenByType";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLineComments";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFlagElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "calcImportedPackagesMap";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "calcImportMap";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "deleteImport";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenByType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39 -> new IllegalStateException(string);
        };
    }
}

