/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl;

import com.goide.GoLanguage;
import com.goide.GoParserDefinition;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoConstDeclaration;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoConstraintTerm;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoGoStatement;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoKey;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoRecvStatement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSelectStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoSwitchStatement;
import com.goide.psi.GoTag;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeCaseClause;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.manipulator.GoStringManipulator;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoElementFactory {
    private static final Logger LOG = Logger.getInstance(GoElementFactory.class);

    private GoElementFactory() {
    }

    @NotNull
    public static GoFile createFileFromText(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(0);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(1);
        }
        return GoElementFactory.createFileFromText(project, "elementFactory.go", text, false, null, null);
    }

    @NotNull
    public static GoFile createFileFromText(@NotNull Project project, @NonNls @NotNull String fileName, @NonNls @NotNull String text, boolean eventSystemEnabled, @Nullable PsiElement context, @Nullable VirtualFile original) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(2);
        }
        if (fileName == null) {
            GoElementFactory.$$$reportNull$$$0(3);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(4);
        }
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, GoLanguage.INSTANCE, (CharSequence)text, eventSystemEnabled, true, false, original);
        if (context != null) {
            file.putUserData(GoReferenceBase.SUBSTITUTION_CONTEXT, (Object)context);
        }
        GoFile goFile = (GoFile)file;
        if (goFile == null) {
            GoElementFactory.$$$reportNull$$$0(5);
        }
        return goFile;
    }

    @NotNull
    private static GoFile createFileFromTextCheap(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(6);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(7);
        }
        GoFile goFile = (GoFile)PsiFileFactory.getInstance((Project)project).createFileFromText("elementFactory.go", GoLanguage.INSTANCE, (CharSequence)text, false, false);
        if (goFile == null) {
            GoElementFactory.$$$reportNull$$$0(8);
        }
        return goFile;
    }

    @Nullable
    public static <T extends PsiElement> T createElement(@NotNull Project project, @NonNls @NotNull String text, @NotNull Class<T> aClass) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(9);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(10);
        }
        if (aClass == null) {
            GoElementFactory.$$$reportNull$$$0(11);
        }
        return GoElementFactory.createElement(project, text, aClass, null);
    }

    @Nullable
    public static <T extends PsiElement> T createElement(@NotNull Project project, @NonNls @NotNull String text, @NotNull Class<T> aClass, @Nullable PsiElement context) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(12);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(13);
        }
        if (aClass == null) {
            GoElementFactory.$$$reportNull$$$0(14);
        }
        GoFile file = GoElementFactory.createFileFromText(project, text);
        if (context != null) {
            file.putUserData(GoReferenceBase.SUBSTITUTION_CONTEXT, context);
        }
        return (T)PsiTreeUtil.findChildOfType((PsiElement)file, aClass);
    }

    @NotNull
    public static GoReturnStatement createReturnStatement(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(15);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(16);
        }
        GoReturnStatement goReturnStatement = GoElementFactory.createElement(project, "package main\nfunc _() { return " + text + "; }", GoReturnStatement.class);
        if (goReturnStatement == null) {
            GoElementFactory.$$$reportNull$$$0(17);
        }
        return goReturnStatement;
    }

    @NotNull
    public static GoSelectStatement createSelectStatement(@NotNull Project project) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(18);
        }
        GoSelectStatement goSelectStatement = GoElementFactory.createElement(project, "package main\nfunc _() { select {\n} }", GoSelectStatement.class);
        if (goSelectStatement == null) {
            GoElementFactory.$$$reportNull$$$0(19);
        }
        return goSelectStatement;
    }

    @NotNull
    public static PsiElement createIdentifierFromText(@NotNull Project project, String text) {
        GoFile file;
        PsiElement identifier;
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(20);
        }
        if ((identifier = (file = GoElementFactory.createFileFromText(project, "package " + text)).getPackage().getIdentifier()) == null) {
            LOG.error("package name should be not null. Given '" + text + "'");
        }
        PsiElement psiElement = identifier;
        if (psiElement == null) {
            GoElementFactory.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    @NotNull
    public static GoIfStatement createIfStatement(@NotNull Project project, @NonNls @NotNull String condition, @NonNls @NotNull String thenBranch, @Nullable String elseBranch) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(22);
        }
        if (condition == null) {
            GoElementFactory.$$$reportNull$$$0(23);
        }
        if (thenBranch == null) {
            GoElementFactory.$$$reportNull$$$0(24);
        }
        @NonNls Object elseText = elseBranch != null ? " else {\n" + elseBranch + "\n}" : "";
        GoIfStatement goIfStatement = GoElementFactory.createElement(project, "package a; func _() {\nif " + condition + " {\n" + thenBranch + "\n}" + (String)elseText + "\n}", GoIfStatement.class);
        if (goIfStatement == null) {
            GoElementFactory.$$$reportNull$$$0(25);
        }
        return goIfStatement;
    }

    @NotNull
    public static GoIfStatement createIfElseIfStatement(@NotNull Project project, @NonNls @NotNull String condition, @NonNls @NotNull String thenBranch, @NonNls @NotNull String elseIfBranch) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(26);
        }
        if (condition == null) {
            GoElementFactory.$$$reportNull$$$0(27);
        }
        if (thenBranch == null) {
            GoElementFactory.$$$reportNull$$$0(28);
        }
        if (elseIfBranch == null) {
            GoElementFactory.$$$reportNull$$$0(29);
        }
        GoIfStatement goIfStatement = GoElementFactory.createElement(project, "package a; func _() {\nif " + condition + " {\n" + thenBranch + "\n}" + elseIfBranch + "\n}", GoIfStatement.class);
        if (goIfStatement == null) {
            GoElementFactory.$$$reportNull$$$0(30);
        }
        return goIfStatement;
    }

    @NotNull
    public static GoSwitchStatement createSwitchStatement(@NotNull Project project, @Nullable @NonNls String initStmt, @NonNls @Nullable String condition, @NotNull Map<@NonNls String, String> clauses, @Nullable @NonNls String defaultCase) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(31);
        }
        if (clauses == null) {
            GoElementFactory.$$$reportNull$$$0(32);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : clauses.entrySet()) {
            sb.append("case ");
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        GoSwitchStatement goSwitchStatement = GoElementFactory.createElement(project, "package a; func _() {\nswitch " + (String)(initStmt == null ? "" : initStmt + "; ") + (condition == null ? "" : condition) + " {\n" + String.valueOf(sb) + (String)(defaultCase != null ? "default: " + defaultCase : "") + "}\n", GoSwitchStatement.class);
        if (goSwitchStatement == null) {
            GoElementFactory.$$$reportNull$$$0(33);
        }
        return goSwitchStatement;
    }

    @NotNull
    public static GoImportDeclaration createImportDeclaration(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(34);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(35);
        }
        GoImportDeclaration goImportDeclaration = GoElementFactory.createElement(project, "package main\nimport " + text, GoImportDeclaration.class);
        if (goImportDeclaration == null) {
            GoElementFactory.$$$reportNull$$$0(36);
        }
        return goImportDeclaration;
    }

    @NotNull
    public static GoImportDeclaration createImportDeclaration(@NotNull PsiFile file, @NonNls @NotNull String importString, @Nullable String alias, boolean withParens) {
        if (file == null) {
            GoElementFactory.$$$reportNull$$$0(37);
        }
        if (importString == null) {
            GoElementFactory.$$$reportNull$$$0(38);
        }
        importString = GoStringManipulator.isQuotedImportString(importString) ? GoElementFactory.wrapImportPathWithQuotes(file, importString.substring(1, importString.length() - 1)) : GoElementFactory.wrapImportPathWithQuotes(file, importString);
        alias = alias != null ? (String)alias + " " : "";
        return GoElementFactory.createImportDeclaration(file.getProject(), withParens ? "(\n" + (String)alias + importString + "\n)" : (String)alias + importString);
    }

    private static String wrapImportPathWithQuotes(@NotNull PsiFile file, @NonNls @NotNull String importPath) {
        if (file == null) {
            GoElementFactory.$$$reportNull$$$0(39);
        }
        if (importPath == null) {
            GoElementFactory.$$$reportNull$$$0(40);
        }
        return ((GoCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, GoCodeStyleSettings.class)).USE_BACK_QUOTES_FOR_IMPORTS ? "`" + importPath + "`" : StringUtil.wrapWithDoubleQuote((String)importPath);
    }

    @NotNull
    public static GoImportSpec createImportSpec(@NotNull PsiFile file, @NonNls @NotNull String importString, @Nullable String alias) {
        if (file == null) {
            GoElementFactory.$$$reportNull$$$0(41);
        }
        if (importString == null) {
            GoElementFactory.$$$reportNull$$$0(42);
        }
        GoImportDeclaration importDeclaration = GoElementFactory.createImportDeclaration(file, importString, alias, true);
        GoImportSpec goImportSpec = (GoImportSpec)ContainerUtil.getFirstItem(importDeclaration.getImportSpecList());
        if (goImportSpec == null) {
            GoElementFactory.$$$reportNull$$$0(43);
        }
        return goImportSpec;
    }

    @NotNull
    public static PsiElement createImportSpecIdentifierOrDot(@NotNull GoFile file, @NonNls @NotNull String identifier) {
        if (file == null) {
            GoElementFactory.$$$reportNull$$$0(44);
        }
        if (identifier == null) {
            GoElementFactory.$$$reportNull$$$0(45);
        }
        if (!".".equals(identifier)) {
            return GoElementFactory.createIdentifierFromText(file.getProject(), identifier);
        }
        GoImportSpec spec = GoElementFactory.createImportSpec((PsiFile)file, "a", ".");
        PsiElement psiElement = Objects.requireNonNull(spec.getDot());
        if (psiElement == null) {
            GoElementFactory.$$$reportNull$$$0(46);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createNewLine(@NotNull Project project) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(47);
        }
        return GoElementFactory.createNewLine(project, 1);
    }

    @NotNull
    public static PsiElement createNewLine(@NotNull Project project, int count2) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(48);
        }
        PsiElement psiElement = PsiParserFacade.getInstance((Project)project).createWhiteSpaceFromText(StringUtil.repeatSymbol((char)'\n', (int)count2));
        if (psiElement == null) {
            GoElementFactory.$$$reportNull$$$0(49);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createComma(@NotNull Project project) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(50);
        }
        PsiElement psiElement = GoElementFactory.createFileFromText(project, "package foo; var a,b = 1,2").getVars().iterator().next().getNextSibling();
        if (psiElement == null) {
            GoElementFactory.$$$reportNull$$$0(51);
        }
        return psiElement;
    }

    @NotNull
    public static GoBlock createBlock(@NotNull Project project) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(52);
        }
        return GoElementFactory.createBlock(project, "\n");
    }

    @NotNull
    public static GoBlock createBlock(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(53);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(54);
        }
        GoFunctionDeclaration function = (GoFunctionDeclaration)ContainerUtil.getFirstItem(GoElementFactory.createFileFromText(project, "package a; func t() {" + text + "}").getFunctions());
        assert (function != null) : "Impossible situation! Parser is broken.";
        GoBlock goBlock = function.getBlock();
        if (goBlock == null) {
            GoElementFactory.$$$reportNull$$$0(55);
        }
        return goBlock;
    }

    @NotNull
    public static GoStringLiteral createStringLiteral(@NotNull Project project, @NonNls @NotNull String stringLiteral) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(56);
        }
        if (stringLiteral == null) {
            GoElementFactory.$$$reportNull$$$0(57);
        }
        GoFile f = GoElementFactory.createFileFromText(project, "package a; var b = " + stringLiteral);
        GoStringLiteral goStringLiteral = (GoStringLiteral)PsiTreeUtil.getNextSiblingOfType((PsiElement)((PsiElement)ContainerUtil.getFirstItem(f.getVars())), GoStringLiteral.class);
        if (goStringLiteral == null) {
            GoElementFactory.$$$reportNull$$$0(58);
        }
        return goStringLiteral;
    }

    @NotNull
    public static GoSignature createFunctionSignatureFromText(@NotNull Project project, @NonNls @NotNull String typeParams, @NonNls @NotNull String params) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(59);
        }
        if (typeParams == null) {
            GoElementFactory.$$$reportNull$$$0(60);
        }
        if (params == null) {
            GoElementFactory.$$$reportNull$$$0(61);
        }
        return GoElementFactory.createFunctionSignatureFromText(project, typeParams, params, "", null);
    }

    @NotNull
    public static GoSignature createFunctionSignature(@NotNull Project project, @NonNls @NotNull List<String> typeParams, @NonNls @NotNull List<String> params, @NonNls @NotNull String result, @Nullable PsiElement context) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(62);
        }
        if (typeParams == null) {
            GoElementFactory.$$$reportNull$$$0(63);
        }
        if (params == null) {
            GoElementFactory.$$$reportNull$$$0(64);
        }
        if (result == null) {
            GoElementFactory.$$$reportNull$$$0(65);
        }
        return GoElementFactory.createFunctionSignatureFromText(project, typeParams.isEmpty() ? "" : StringUtil.join(typeParams, (String)", "), StringUtil.join(params, (String)", "), result, context);
    }

    @NotNull
    public static GoSignature createFunctionSignatureFromText(@NotNull Project project, @NonNls @NotNull String typeParams, @NonNls @NotNull String params, @NonNls @NotNull String result) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(66);
        }
        if (typeParams == null) {
            GoElementFactory.$$$reportNull$$$0(67);
        }
        if (params == null) {
            GoElementFactory.$$$reportNull$$$0(68);
        }
        if (result == null) {
            GoElementFactory.$$$reportNull$$$0(69);
        }
        return GoElementFactory.createFunctionSignatureFromText(project, typeParams, params, result, null);
    }

    @NotNull
    public static GoSignature createFunctionSignatureFromText(@NotNull Project project, @NonNls @NotNull String typeParams, @NonNls @NotNull String params, @NonNls @NotNull String result, @Nullable PsiElement context) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(70);
        }
        if (typeParams == null) {
            GoElementFactory.$$$reportNull$$$0(71);
        }
        if (params == null) {
            GoElementFactory.$$$reportNull$$$0(72);
        }
        if (result == null) {
            GoElementFactory.$$$reportNull$$$0(73);
        }
        return GoElementFactory.createFunctionSignatureFromText(project, typeParams, params, result, context, true);
    }

    @NotNull
    public static GoSignature createFunctionSignatureFromText(@NotNull Project project, @NonNls @NotNull String typeParams, @NonNls @NotNull String params, @NonNls @NotNull String result, @Nullable PsiElement context, boolean markAsGenerated) {
        GoFile file;
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(74);
        }
        if (typeParams == null) {
            GoElementFactory.$$$reportNull$$$0(75);
        }
        if (params == null) {
            GoElementFactory.$$$reportNull$$$0(76);
        }
        if (result == null) {
            GoElementFactory.$$$reportNull$$$0(77);
        }
        typeParams = ((String)typeParams).isEmpty() ? "" : "[" + (String)typeParams + "]";
        result = !result.startsWith("func") && StringUtil.containsAnyChar((String)result, (String)", ") ? " (" + result + ")" : result;
        @NonNls String text = "package a; func t" + (String)typeParams + "(" + params + ") " + result + " {\n}";
        GoFile goFile = file = markAsGenerated ? GoElementFactory.createFileFromText(project, text) : GoElementFactory.createFileFromTextCheap(project, text);
        if (context != null) {
            file.putUserData(GoReferenceBase.SUBSTITUTION_CONTEXT, context);
        }
        GoSignature goSignature = ((GoFunctionDeclaration)ContainerUtil.getFirstItem(file.getFunctions())).getSignature();
        if (goSignature == null) {
            GoElementFactory.$$$reportNull$$$0(78);
        }
        return goSignature;
    }

    @NotNull
    public static GoStatement createShortVarDeclarationStatement(@NotNull Project project, @NonNls @NotNull String name, @NotNull GoExpression initializer) {
        GoFile file;
        GoSimpleStatement statement;
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(79);
        }
        if (name == null) {
            GoElementFactory.$$$reportNull$$$0(80);
        }
        if (initializer == null) {
            GoElementFactory.$$$reportNull$$$0(81);
        }
        if ((statement = (GoSimpleStatement)PsiTreeUtil.findChildOfType((PsiElement)(file = GoElementFactory.createFileFromText(project, "package a; func a() {\n " + name + " := " + initializer.getText() + "}")), GoSimpleStatement.class)) == null) {
            LOG.error("statement should be not null + '" + initializer.getText() + "'");
        }
        GoSimpleStatement goSimpleStatement = statement;
        if (goSimpleStatement == null) {
            GoElementFactory.$$$reportNull$$$0(82);
        }
        return goSimpleStatement;
    }

    @NotNull
    public static GoStatement createConstDeclarationStatement(@NotNull Project project, @NonNls @NotNull String name, @NotNull GoExpression initializer) {
        GoFile file;
        GoStatement statement;
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(83);
        }
        if (name == null) {
            GoElementFactory.$$$reportNull$$$0(84);
        }
        if (initializer == null) {
            GoElementFactory.$$$reportNull$$$0(85);
        }
        if ((statement = (GoStatement)PsiTreeUtil.findChildOfType((PsiElement)(file = GoElementFactory.createFileFromText(project, "package a; func a() {\n const " + name + " = " + initializer.getText() + "}")), GoStatement.class)) == null) {
            LOG.error("statement should be not null + '" + initializer.getText() + "'");
        }
        GoStatement goStatement = statement;
        if (goStatement == null) {
            GoElementFactory.$$$reportNull$$$0(86);
        }
        return goStatement;
    }

    @NotNull
    public static GoStatement createShortVarDeclarationStatement(@NotNull Project project, @NonNls @NotNull String leftSide, @NonNls @NotNull String rightSide) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(87);
        }
        if (leftSide == null) {
            GoElementFactory.$$$reportNull$$$0(88);
        }
        if (rightSide == null) {
            GoElementFactory.$$$reportNull$$$0(89);
        }
        GoStatement goStatement = GoElementFactory.createElement(project, "package a; func a() {\n " + leftSide + " := " + rightSide + "}", GoSimpleStatement.class);
        if (goStatement == null) {
            GoElementFactory.$$$reportNull$$$0(90);
        }
        return goStatement;
    }

    @NotNull
    public static GoRangeClause createRangeClause(@NotNull Project project, @NonNls @NotNull String leftSide, @NonNls @NotNull String rightSide) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(91);
        }
        if (leftSide == null) {
            GoElementFactory.$$$reportNull$$$0(92);
        }
        if (rightSide == null) {
            GoElementFactory.$$$reportNull$$$0(93);
        }
        GoRangeClause goRangeClause = GoElementFactory.createElement(project, "package a; func a() {\n for " + leftSide + " := range " + rightSide + "{\n}\n}", GoRangeClause.class);
        if (goRangeClause == null) {
            GoElementFactory.$$$reportNull$$$0(94);
        }
        return goRangeClause;
    }

    @NotNull
    public static GoRangeClause createRangeClauseAssignment(@NotNull Project project, @NonNls @NotNull String leftSide, @NonNls @NotNull String rightSide) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(95);
        }
        if (leftSide == null) {
            GoElementFactory.$$$reportNull$$$0(96);
        }
        if (rightSide == null) {
            GoElementFactory.$$$reportNull$$$0(97);
        }
        GoRangeClause goRangeClause = GoElementFactory.createElement(project, "package a; func a() {\n for " + leftSide + " = range " + rightSide + "{\n}\n}", GoRangeClause.class);
        if (goRangeClause == null) {
            GoElementFactory.$$$reportNull$$$0(98);
        }
        return goRangeClause;
    }

    @NotNull
    public static GoRecvStatement createRecvStatement(@NotNull Project project, @NonNls @NotNull String leftSide, @NonNls @NotNull String rightSide) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(99);
        }
        if (leftSide == null) {
            GoElementFactory.$$$reportNull$$$0(100);
        }
        if (rightSide == null) {
            GoElementFactory.$$$reportNull$$$0(101);
        }
        GoRecvStatement goRecvStatement = GoElementFactory.createElement(project, "package a; func a() {\n select { case " + leftSide + " := " + rightSide + ":\n}\n}", GoRecvStatement.class);
        if (goRecvStatement == null) {
            GoElementFactory.$$$reportNull$$$0(102);
        }
        return goRecvStatement;
    }

    @NotNull
    public static GoRecvStatement createRecvStatementAssignment(@NotNull Project project, @NonNls @NotNull String left, @NonNls @NotNull String right) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(103);
        }
        if (left == null) {
            GoElementFactory.$$$reportNull$$$0(104);
        }
        if (right == null) {
            GoElementFactory.$$$reportNull$$$0(105);
        }
        GoRecvStatement goRecvStatement = GoElementFactory.createElement(project, "package a; func a() {\n select { case " + left + " = " + right + ":\n}\n}", GoRecvStatement.class);
        if (goRecvStatement == null) {
            GoElementFactory.$$$reportNull$$$0(106);
        }
        return goRecvStatement;
    }

    @NotNull
    public static GoAssignmentStatement createAssignmentStatement(@NotNull Project project, @NonNls @NotNull String left, @NonNls @NotNull String right) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(107);
        }
        if (left == null) {
            GoElementFactory.$$$reportNull$$$0(108);
        }
        if (right == null) {
            GoElementFactory.$$$reportNull$$$0(109);
        }
        GoAssignmentStatement goAssignmentStatement = GoElementFactory.createElement(project, "package a; func a() {\n " + left + " = " + right + "}", GoAssignmentStatement.class);
        if (goAssignmentStatement == null) {
            GoElementFactory.$$$reportNull$$$0(110);
        }
        return goAssignmentStatement;
    }

    @NotNull
    public static GoDeferStatement createDeferStatement(@NotNull Project project, @NonNls @NotNull String expressionText) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(111);
        }
        if (expressionText == null) {
            GoElementFactory.$$$reportNull$$$0(112);
        }
        GoDeferStatement goDeferStatement = GoElementFactory.createElement(project, "package a; func a() {\n  defer " + expressionText + "}", GoDeferStatement.class);
        if (goDeferStatement == null) {
            GoElementFactory.$$$reportNull$$$0(113);
        }
        return goDeferStatement;
    }

    @NotNull
    public static GoGoStatement createGoStatement(@NotNull Project project, @NonNls @NotNull String expressionText) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(114);
        }
        if (expressionText == null) {
            GoElementFactory.$$$reportNull$$$0(115);
        }
        GoGoStatement goGoStatement = GoElementFactory.createElement(project, "package a; func a() {\n  go " + expressionText + "}", GoGoStatement.class);
        if (goGoStatement == null) {
            GoElementFactory.$$$reportNull$$$0(116);
        }
        return goGoStatement;
    }

    @NotNull
    public static GoForStatement createForStatement(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(117);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(118);
        }
        GoForStatement goForStatement = GoElementFactory.createElement(project, "package a; func a() {\n for {\n" + text + "\n}\n}", GoForStatement.class);
        if (goForStatement == null) {
            GoElementFactory.$$$reportNull$$$0(119);
        }
        return goForStatement;
    }

    @NotNull
    public static GoExpression createExpression(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(120);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(121);
        }
        return GoElementFactory.createExpression(project, text, null);
    }

    @NotNull
    public static GoExpression createExpression(@NotNull Project project, @NonNls @NotNull String text, @Nullable PsiElement context) {
        GoExpression expression;
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(122);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(123);
        }
        GoFile file = GoElementFactory.createFileFromText(project, "package a; func a() {\n " + text + "}");
        if (context != null) {
            file.putUserData(GoReferenceBase.SUBSTITUTION_CONTEXT, context);
        }
        if ((expression = (GoExpression)PsiTreeUtil.findChildOfType((PsiElement)file, GoExpression.class)) == null) {
            LOG.error("expression should be not null + '" + text + "'");
        }
        GoExpression goExpression = expression;
        if (goExpression == null) {
            GoElementFactory.$$$reportNull$$$0(124);
        }
        return goExpression;
    }

    @NotNull
    public static GoReferenceExpression createReferenceExpression(@NotNull Project project, @NonNls @NotNull String name) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(125);
        }
        if (name == null) {
            GoElementFactory.$$$reportNull$$$0(126);
        }
        GoReferenceExpression goReferenceExpression = GoElementFactory.createElement(project, "package a; var a = " + name, GoReferenceExpression.class);
        if (goReferenceExpression == null) {
            GoElementFactory.$$$reportNull$$$0(127);
        }
        return goReferenceExpression;
    }

    @NotNull
    public static GoTypeReferenceExpression createTypeReferenceExpression(@NotNull Project project, @NonNls @NotNull String name, @Nullable PsiElement context) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(128);
        }
        if (name == null) {
            GoElementFactory.$$$reportNull$$$0(129);
        }
        GoTypeReferenceExpression goTypeReferenceExpression = GoElementFactory.tryCreateTypeReferenceExpression(project, name, context);
        if (goTypeReferenceExpression == null) {
            GoElementFactory.$$$reportNull$$$0(130);
        }
        return goTypeReferenceExpression;
    }

    @Nullable
    public static GoTypeReferenceExpression tryCreateTypeReferenceExpression(@NotNull Project project, @NonNls @NotNull String name, @Nullable PsiElement context) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(131);
        }
        if (name == null) {
            GoElementFactory.$$$reportNull$$$0(132);
        }
        return GoElementFactory.createElement(project, "package a; var a = " + name + "{}", GoTypeReferenceExpression.class, context);
    }

    @NotNull
    public static GoSimpleStatement createComparison(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(133);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(134);
        }
        GoSimpleStatement goSimpleStatement = GoElementFactory.createElement(project, "package a; func a() {\n " + text + "}", GoSimpleStatement.class);
        if (goSimpleStatement == null) {
            GoElementFactory.$$$reportNull$$$0(135);
        }
        return goSimpleStatement;
    }

    @NotNull
    public static GoConstDeclaration createConstDeclaration(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(136);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(137);
        }
        GoConstDeclaration goConstDeclaration = GoElementFactory.createElement(project, "package a; const " + text, GoConstDeclaration.class);
        if (goConstDeclaration == null) {
            GoElementFactory.$$$reportNull$$$0(138);
        }
        return goConstDeclaration;
    }

    @NotNull
    public static GoConstSpec createConstSpec(@NotNull Project project, @NonNls @NotNull String name, @Nullable String type, @Nullable String value) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(139);
        }
        if (name == null) {
            GoElementFactory.$$$reportNull$$$0(140);
        }
        GoConstDeclaration constDeclaration = GoElementFactory.createConstDeclaration(project, GoElementFactory.prepareVarOrConstDeclarationText(name, type, value));
        GoConstSpec goConstSpec = (GoConstSpec)ContainerUtil.getFirstItem(constDeclaration.getConstSpecList());
        if (goConstSpec == null) {
            GoElementFactory.$$$reportNull$$$0(141);
        }
        return goConstSpec;
    }

    @NotNull
    public static List<GoExpression> createConstExpressions(@NotNull Project project, @NonNls @NotNull String text, @Nullable PsiElement context) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(142);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(143);
        }
        GoFile file = GoElementFactory.createFileFromTextCheap(project, "package a; const " + GoElementFactory.prepareVarOrConstDeclarationText("a", null, text));
        if (context != null) {
            file.putUserData(GoReferenceBase.SUBSTITUTION_CONTEXT, context);
        }
        List<GoExpression> list = ((GoConstSpec)PsiTreeUtil.findChildOfType((PsiElement)file, GoConstSpec.class)).getExpressionList();
        if (list == null) {
            GoElementFactory.$$$reportNull$$$0(144);
        }
        return list;
    }

    @NotNull
    public static GoVarDeclaration createVarDeclaration(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(145);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(146);
        }
        GoVarDeclaration goVarDeclaration = GoElementFactory.createElement(project, "package a; func _() { var " + text + " }", GoVarDeclaration.class);
        if (goVarDeclaration == null) {
            GoElementFactory.$$$reportNull$$$0(147);
        }
        return goVarDeclaration;
    }

    @NotNull
    public static GoVarSpec createVarSpec(@NotNull Project project, @NonNls @NotNull String name, @Nullable String type, @Nullable String value) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(148);
        }
        if (name == null) {
            GoElementFactory.$$$reportNull$$$0(149);
        }
        GoVarDeclaration varDeclaration = GoElementFactory.createVarDeclaration(project, GoElementFactory.prepareVarOrConstDeclarationText(name, type, value));
        GoVarSpec goVarSpec = (GoVarSpec)ContainerUtil.getFirstItem(varDeclaration.getVarSpecList());
        if (goVarSpec == null) {
            GoElementFactory.$$$reportNull$$$0(150);
        }
        return goVarSpec;
    }

    @NotNull
    private static String prepareVarOrConstDeclarationText(@NonNls @NotNull String name, @Nullable String type, @Nullable String value) {
        if (name == null) {
            GoElementFactory.$$$reportNull$$$0(151);
        }
        type = StringUtil.trim((String)type);
        value = StringUtil.trim((String)value);
        type = StringUtil.isNotEmpty((String)type) ? " " + (String)type : "";
        value = StringUtil.isNotEmpty((String)value) ? " = " + (String)value : "";
        String string = name + (String)type + (String)value;
        if (string == null) {
            GoElementFactory.$$$reportNull$$$0(152);
        }
        return string;
    }

    public static GoType createTypeCheap(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(153);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(154);
        }
        return GoElementFactory.createTypeCheap(project, text, null);
    }

    public static GoType createTypeCheap(@NotNull Project project, @NonNls @NotNull String text, @Nullable PsiElement context) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(155);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(156);
        }
        GoFile file = GoElementFactory.createFileFromTextCheap(project, "package a; var a " + text);
        if (context != null) {
            file.putUserData(GoReferenceBase.SUBSTITUTION_CONTEXT, context);
        }
        return (GoType)PsiTreeUtil.findChildOfType((PsiElement)file, GoType.class);
    }

    public static GoType createType(@NotNull Project project, @NonNls @NotNull String text, @Nullable PsiElement context) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(157);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(158);
        }
        GoFile file = GoElementFactory.createFileFromText(project, "package a; var a " + text);
        if (context != null) {
            file.putUserData(GoReferenceBase.SUBSTITUTION_CONTEXT, context);
        }
        return (GoType)PsiTreeUtil.findChildOfType((PsiElement)file, GoType.class);
    }

    @Nullable
    public static GoTypeCaseClause createTypeCaseClause(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(159);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(160);
        }
        return GoElementFactory.createElement(project, "package a; func _() { switch _ := a.(type) { case " + text + ":} }", GoTypeCaseClause.class);
    }

    public static PsiElement createLiteralValueElement(@NotNull Project project, @NonNls @NotNull String key, @NonNls @NotNull String value) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(161);
        }
        if (key == null) {
            GoElementFactory.$$$reportNull$$$0(162);
        }
        if (value == null) {
            GoElementFactory.$$$reportNull$$$0(163);
        }
        return GoElementFactory.createElement(project, "package a; var _ = struct { a string } { " + key + ": " + value + " }", GoElement.class);
    }

    @NotNull
    public static GoTypeDeclaration createTypeDeclaration(@NotNull Project project, @NonNls @NotNull String name, @NotNull GoType type) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(164);
        }
        if (name == null) {
            GoElementFactory.$$$reportNull$$$0(165);
        }
        if (type == null) {
            GoElementFactory.$$$reportNull$$$0(166);
        }
        return GoElementFactory.createTypeDeclaration(project, name, type.getText(), null);
    }

    @NotNull
    public static GoTypeDeclaration createTypeDeclaration(@NotNull Project project, @NonNls @NotNull String name, @NonNls @NotNull String type, @Nullable String body) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(167);
        }
        if (name == null) {
            GoElementFactory.$$$reportNull$$$0(168);
        }
        if (type == null) {
            GoElementFactory.$$$reportNull$$$0(169);
        }
        Object block = body != null ? "{\n" + body + "\n}" : "";
        GoTypeDeclaration goTypeDeclaration = GoElementFactory.createElement(project, "package a; type " + name + " " + type + (String)block, GoTypeDeclaration.class);
        if (goTypeDeclaration == null) {
            GoElementFactory.$$$reportNull$$$0(170);
        }
        return goTypeDeclaration;
    }

    @NotNull
    public static GoKey createKey(@NotNull Project project, @NonNls @NotNull String name) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(171);
        }
        if (name == null) {
            GoElementFactory.$$$reportNull$$$0(172);
        }
        GoKey goKey = GoElementFactory.createElement(project, "package a; var a = struct{int}{" + name + ":1}", GoKey.class);
        if (goKey == null) {
            GoElementFactory.$$$reportNull$$$0(173);
        }
        return goKey;
    }

    @NotNull
    public static GoTag createTag(@NotNull Project project, @Nullable String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(174);
        }
        GoTag goTag = GoElementFactory.createElement(project, "package a; type a struct { name string `" + text + "` }", GoTag.class);
        if (goTag == null) {
            GoElementFactory.$$$reportNull$$$0(175);
        }
        return goTag;
    }

    @NotNull
    public static PsiElement createUnaryOperatorFromText(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(176);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(177);
        }
        GoFile file = GoElementFactory.createFileFromText(project, "package a; var a = " + text + "b");
        GoExpression expression = (GoExpression)PsiTreeUtil.findChildOfType((PsiElement)file, GoExpression.class);
        PsiElement psiElement = expression.getFirstChild();
        if (psiElement == null) {
            GoElementFactory.$$$reportNull$$$0(178);
        }
        return psiElement;
    }

    @NotNull
    public static PsiComment createLineCommentFromText(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(179);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(180);
        }
        PsiComment psiComment = PsiParserFacade.getInstance((Project)project).createLineCommentFromText(GoLanguage.INSTANCE, text);
        if (psiComment == null) {
            GoElementFactory.$$$reportNull$$$0(181);
        }
        return psiComment;
    }

    @NotNull
    public static PsiComment createComment(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(182);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(183);
        }
        PsiComment psiComment = GoElementFactory.createElement(project, text + "\npackage main", PsiComment.class);
        if (psiComment == null) {
            GoElementFactory.$$$reportNull$$$0(184);
        }
        return psiComment;
    }

    @NotNull
    public static Collection<PsiComment> createComments(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(185);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(186);
        }
        GoFile file = GoElementFactory.createFileFromText(project, text + "\npackage main");
        List<PsiComment> list = PsiTreeUtil.findChildrenOfType((PsiElement)file, PsiComment.class).stream().toList();
        if (list == null) {
            GoElementFactory.$$$reportNull$$$0(187);
        }
        return list;
    }

    @NotNull
    public static GoCallExpr createCallExpression(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(188);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(189);
        }
        GoCallExpr goCallExpr = GoElementFactory.createElement(project, "package a; func _() { " + text + " }", GoCallExpr.class);
        if (goCallExpr == null) {
            GoElementFactory.$$$reportNull$$$0(190);
        }
        return goCallExpr;
    }

    @NotNull
    public static GoCallExpr createCallExpression(@NotNull Project project, @NonNls @NotNull String expression, @NonNls @NotNull List<String> arguments) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(191);
        }
        if (expression == null) {
            GoElementFactory.$$$reportNull$$$0(192);
        }
        if (arguments == null) {
            GoElementFactory.$$$reportNull$$$0(193);
        }
        return GoElementFactory.createCallExpression(project, expression + "(" + StringUtil.join(arguments, (String)" ,") + ")");
    }

    @NotNull
    public static GoStatement createStatement(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(194);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(195);
        }
        GoStatement goStatement = GoElementFactory.createElement(project, "package a; func _() { " + text + " }", GoStatement.class);
        if (goStatement == null) {
            GoElementFactory.$$$reportNull$$$0(196);
        }
        return goStatement;
    }

    @NotNull
    public static GoInterfaceType createInterfaceType(@NotNull Project project, @NotNull List<@NonNls GoMethodSpec> methodSpecs) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(197);
        }
        if (methodSpecs == null) {
            GoElementFactory.$$$reportNull$$$0(198);
        }
        String methods = methodSpecs.stream().map(s -> s.getText()).collect(Collectors.joining("\n"));
        GoInterfaceType goInterfaceType = GoElementFactory.createElement(project, "package a; type _ interface { " + methods + " }", GoInterfaceType.class);
        if (goInterfaceType == null) {
            GoElementFactory.$$$reportNull$$$0(199);
        }
        return goInterfaceType;
    }

    @NotNull
    public static GoMethodSpec createMethodSpec(@NotNull Project project, @NonNls @NotNull String name, @NonNls @NotNull String parameters, @NonNls @NotNull String resultType) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(200);
        }
        if (name == null) {
            GoElementFactory.$$$reportNull$$$0(201);
        }
        if (parameters == null) {
            GoElementFactory.$$$reportNull$$$0(202);
        }
        if (resultType == null) {
            GoElementFactory.$$$reportNull$$$0(203);
        }
        String methodSpec = name + "(" + parameters + ") " + resultType;
        return GoElementFactory.createMethodSpec(project, methodSpec);
    }

    @NotNull
    public static GoMethodSpec createMethodSpec(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(204);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(205);
        }
        GoMethodSpec goMethodSpec = GoElementFactory.createElement(project, "package a; type _ interface { " + text + " }", GoMethodSpec.class);
        if (goMethodSpec == null) {
            GoElementFactory.$$$reportNull$$$0(206);
        }
        return goMethodSpec;
    }

    @NotNull
    public static PsiElement createTripleDot(@NotNull Project project) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(207);
        }
        GoCallExpr call = GoElementFactory.createCallExpression(project, "a(b...)");
        PsiElement psiElement = Objects.requireNonNull(call.getArgumentList().getTripleDot());
        if (psiElement == null) {
            GoElementFactory.$$$reportNull$$$0(208);
        }
        return psiElement;
    }

    @NotNull
    public static GoMethodDeclaration createMethodDeclaration(@NotNull Project project, @NonNls @Nullable String receiverParamName, @NonNls @NotNull String receiverBaseType, @NonNls @NotNull String identifier, @NonNls @NotNull String signature, @NonNls @NotNull String block, @Nullable PsiElement context) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(209);
        }
        if (receiverBaseType == null) {
            GoElementFactory.$$$reportNull$$$0(210);
        }
        if (identifier == null) {
            GoElementFactory.$$$reportNull$$$0(211);
        }
        if (signature == null) {
            GoElementFactory.$$$reportNull$$$0(212);
        }
        if (block == null) {
            GoElementFactory.$$$reportNull$$$0(213);
        }
        String sb = "func (" + (String)(receiverParamName == null ? "" : receiverParamName + " ") + receiverBaseType + ") " + identifier + signature + " " + block;
        return (GoMethodDeclaration)GoElementFactory.createFunctionOrMethodDeclaration(project, sb, context);
    }

    @NotNull
    public static GoFunctionDeclaration createFunctionDeclaration(@NotNull Project project, @NonNls @NotNull String identifier, @NonNls @NotNull String signature, @NonNls @NotNull String block, @Nullable PsiElement context) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(214);
        }
        if (identifier == null) {
            GoElementFactory.$$$reportNull$$$0(215);
        }
        if (signature == null) {
            GoElementFactory.$$$reportNull$$$0(216);
        }
        if (block == null) {
            GoElementFactory.$$$reportNull$$$0(217);
        }
        String sb = "func " + identifier + signature + " " + block;
        return (GoFunctionDeclaration)GoElementFactory.createFunctionOrMethodDeclaration(project, sb, context);
    }

    @NotNull
    public static GoFunctionOrMethodDeclaration createFunctionOrMethodDeclaration(@NotNull Project project, @NonNls @NotNull String text, @Nullable PsiElement context) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(218);
        }
        if (text == null) {
            GoElementFactory.$$$reportNull$$$0(219);
        }
        GoFunctionOrMethodDeclaration goFunctionOrMethodDeclaration = GoElementFactory.createElement(project, "package a; " + text, GoFunctionOrMethodDeclaration.class, context);
        if (goFunctionOrMethodDeclaration == null) {
            GoElementFactory.$$$reportNull$$$0(220);
        }
        return goFunctionOrMethodDeclaration;
    }

    @Nullable
    public static PsiElement createKeywordElement(@NotNull Project project, final @NotNull String keyword) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(221);
        }
        if (keyword == null) {
            GoElementFactory.$$$reportNull$$$0(222);
        }
        String text = "package a; " + keyword;
        GoFile file = GoElementFactory.createFileFromText(project, text);
        final Ref keywordElement = new Ref();
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (GoParserDefinition.Lazy.KEYWORDS.contains(PsiUtilCore.getElementType((PsiElement)element)) && element instanceof LeafPsiElement && element.getText().equals(keyword)) {
                    keywordElement.set((Object)element);
                } else {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/psi/impl/GoElementFactory$1", "visitElement"));
            }
        });
        return (PsiElement)keywordElement.get();
    }

    @Nullable
    public static GoConstraintTerm createConstraintTerm(@NotNull Project project, @NotNull String term, @Nullable PsiElement context) {
        if (project == null) {
            GoElementFactory.$$$reportNull$$$0(223);
        }
        if (term == null) {
            GoElementFactory.$$$reportNull$$$0(224);
        }
        return GoElementFactory.createElement(project, "package a; type _ interface { " + term + " | int }", GoConstraintTerm.class, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 17, 19, 21, 25, 30, 33, 36, 43, 46, 49, 51, 55, 58, 78, 82, 86, 90, 94, 98, 102, 106, 110, 113, 116, 119, 124, 127, 130, 135, 138, 141, 144, 147, 150, 152, 170, 173, 175, 178, 181, 184, 187, 190, 196, 199, 206, 208, 220 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 35: 
            case 54: 
            case 118: 
            case 121: 
            case 123: 
            case 134: 
            case 137: 
            case 143: 
            case 146: 
            case 154: 
            case 156: 
            case 158: 
            case 160: 
            case 177: 
            case 180: 
            case 183: 
            case 186: 
            case 189: 
            case 195: 
            case 205: 
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: 
            case 8: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 30: 
            case 33: 
            case 36: 
            case 43: 
            case 46: 
            case 49: 
            case 51: 
            case 55: 
            case 58: 
            case 78: 
            case 82: 
            case 86: 
            case 90: 
            case 94: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 113: 
            case 116: 
            case 119: 
            case 124: 
            case 127: 
            case 130: 
            case 135: 
            case 138: 
            case 141: 
            case 144: 
            case 147: 
            case 150: 
            case 152: 
            case 170: 
            case 173: 
            case 175: 
            case 178: 
            case 181: 
            case 184: 
            case 187: 
            case 190: 
            case 196: 
            case 199: 
            case 206: 
            case 208: 
            case 220: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/GoElementFactory";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenBranch";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseIfBranch";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clauses";
                break;
            }
            case 37: 
            case 39: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importString";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 45: 
            case 211: 
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteral";
                break;
            }
            case 60: 
            case 63: 
            case 67: 
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParams";
                break;
            }
            case 61: 
            case 64: 
            case 68: 
            case 72: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 65: 
            case 69: 
            case 73: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 80: 
            case 84: 
            case 126: 
            case 129: 
            case 132: 
            case 140: 
            case 149: 
            case 151: 
            case 165: 
            case 168: 
            case 172: 
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 81: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 88: 
            case 92: 
            case 96: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftSide";
                break;
            }
            case 89: 
            case 93: 
            case 97: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightSide";
                break;
            }
            case 104: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 105: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 112: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionText";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 166: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSpecs";
                break;
            }
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 210: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverBaseType";
                break;
            }
            case 212: 
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 213: 
            case 217: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/GoElementFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFromText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFromTextCheap";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createReturnStatement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectStatement";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createIdentifierFromText";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createIfStatement";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createIfElseIfStatement";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createSwitchStatement";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportDeclaration";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportSpec";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportSpecIdentifierOrDot";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewLine";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createComma";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlock";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringLiteral";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionSignatureFromText";
                break;
            }
            case 82: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "createShortVarDeclarationStatement";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstDeclarationStatement";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeClause";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeClauseAssignment";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecvStatement";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecvStatementAssignment";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "createAssignmentStatement";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeferStatement";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "createGoStatement";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "createForStatement";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpression";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceExpression";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeReferenceExpression";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "createComparison";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstDeclaration";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstSpec";
                break;
            }
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstExpressions";
                break;
            }
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "createVarDeclaration";
                break;
            }
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "createVarSpec";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareVarOrConstDeclarationText";
                break;
            }
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeDeclaration";
                break;
            }
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "createKey";
                break;
            }
            case 175: {
                objectArray = objectArray2;
                objectArray2[1] = "createTag";
                break;
            }
            case 178: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnaryOperatorFromText";
                break;
            }
            case 181: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineCommentFromText";
                break;
            }
            case 184: {
                objectArray = objectArray2;
                objectArray2[1] = "createComment";
                break;
            }
            case 187: {
                objectArray = objectArray2;
                objectArray2[1] = "createComments";
                break;
            }
            case 190: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallExpression";
                break;
            }
            case 196: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatement";
                break;
            }
            case 199: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterfaceType";
                break;
            }
            case 206: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodSpec";
                break;
            }
            case 208: {
                objectArray = objectArray2;
                objectArray2[1] = "createTripleDot";
                break;
            }
            case 220: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionOrMethodDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 5: 
            case 8: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 30: 
            case 33: 
            case 36: 
            case 43: 
            case 46: 
            case 49: 
            case 51: 
            case 55: 
            case 58: 
            case 78: 
            case 82: 
            case 86: 
            case 90: 
            case 94: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 113: 
            case 116: 
            case 119: 
            case 124: 
            case 127: 
            case 130: 
            case 135: 
            case 138: 
            case 141: 
            case 144: 
            case 147: 
            case 150: 
            case 152: 
            case 170: 
            case 173: 
            case 175: 
            case 178: 
            case 181: 
            case 184: 
            case 187: 
            case 190: 
            case 196: 
            case 199: 
            case 206: 
            case 208: 
            case 220: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromTextCheap";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createReturnStatement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSelectStatement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createIdentifierFromText";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createIfStatement";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createIfElseIfStatement";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createSwitchStatement";
                break;
            }
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createImportDeclaration";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "wrapImportPathWithQuotes";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createImportSpec";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createImportSpecIdentifierOrDot";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createNewLine";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createComma";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createBlock";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createStringLiteral";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionSignatureFromText";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionSignature";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "createShortVarDeclarationStatement";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "createConstDeclarationStatement";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "createRangeClause";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "createRangeClauseAssignment";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "createRecvStatement";
                break;
            }
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "createRecvStatementAssignment";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "createAssignmentStatement";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "createDeferStatement";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "createGoStatement";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "createForStatement";
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "createExpression";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceExpression";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "createTypeReferenceExpression";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateTypeReferenceExpression";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "createComparison";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "createConstDeclaration";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "createConstSpec";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "createConstExpressions";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "createVarDeclaration";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "createVarSpec";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "prepareVarOrConstDeclarationText";
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "createTypeCheap";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "createTypeCaseClause";
                break;
            }
            case 161: 
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralValueElement";
                break;
            }
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "createTypeDeclaration";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "createKey";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "createTag";
                break;
            }
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "createUnaryOperatorFromText";
                break;
            }
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "createLineCommentFromText";
                break;
            }
            case 182: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "createComment";
                break;
            }
            case 185: 
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "createComments";
                break;
            }
            case 188: 
            case 189: 
            case 191: 
            case 192: 
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "createCallExpression";
                break;
            }
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "createStatement";
                break;
            }
            case 197: 
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "createInterfaceType";
                break;
            }
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "createMethodSpec";
                break;
            }
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "createTripleDot";
                break;
            }
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "createMethodDeclaration";
                break;
            }
            case 214: 
            case 215: 
            case 216: 
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionDeclaration";
                break;
            }
            case 218: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionOrMethodDeclaration";
                break;
            }
            case 221: 
            case 222: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordElement";
                break;
            }
            case 223: 
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "createConstraintTerm";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 17, 19, 21, 25, 30, 33, 36, 43, 46, 49, 51, 55, 58, 78, 82, 86, 90, 94, 98, 102, 106, 110, 113, 116, 119, 124, 127, 130, 135, 138, 141, 144, 147, 150, 152, 170, 173, 175, 178, 181, 184, 187, 190, 196, 199, 206, 208, 220 -> new IllegalStateException(string);
        };
    }
}

