/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl;

import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.completion.GoCompletionUtil;
import com.goide.highlighting.legacyErrorInspections.GoInvalidExpressionConversionInspection;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoUniqueIdentifier;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoBuiltinArgumentList;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCallLikeExpr;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoCompositeType;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoConversionExpr;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoElement;
import com.goide.psi.GoExprCaseClause;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoForClause;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoKey;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMapType;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParType;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoRecvStatement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResult;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSendStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeArguments;
import com.goide.psi.GoTypeList;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameter;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoValue;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoCType;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoElementWithSubst;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoIdenticalTypesMatcher;
import com.goide.psi.impl.GoLightMethodDeclaration;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReceiverUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeImpl;
import com.goide.psi.impl.expectedTypes.GoAnyComplexExpectedType;
import com.goide.psi.impl.expectedTypes.GoAnyFloatExpectedType;
import com.goide.psi.impl.expectedTypes.GoAnyIntegerExpectedType;
import com.goide.psi.impl.expectedTypes.GoAnyPointerExpectedType;
import com.goide.psi.impl.expectedTypes.GoAnySendChannelExpectedType;
import com.goide.psi.impl.expectedTypes.GoConditionExpectedType;
import com.goide.psi.impl.expectedTypes.GoConversionExpectedType;
import com.goide.psi.impl.expectedTypes.GoCoreIdenticalExpectedType;
import com.goide.psi.impl.expectedTypes.GoCoreStringExpectedType;
import com.goide.psi.impl.expectedTypes.GoExpectedTypeImpl;
import com.goide.psi.impl.expectedTypes.GoExpectedTypes;
import com.goide.psi.impl.expectedTypes.GoExprCaseClauseExpectedType;
import com.goide.psi.impl.expectedTypes.GoFunctionExpectedType;
import com.goide.psi.impl.expectedTypes.GoIdenticalExpectedType;
import com.goide.psi.impl.expectedTypes.GoIterableExpectedType;
import com.goide.psi.impl.expectedTypes.GoNotNilExpectedType;
import com.goide.psi.impl.expectedTypes.GoNotTypeParameterExpectedType;
import com.goide.psi.impl.expectedTypes.GoTypedSliceExpectedType;
import com.goide.psi.impl.expectedTypes.GoUntypedFloatExpectedType;
import com.goide.psi.impl.generics.GoAbstractConstraintTerm;
import com.goide.psi.impl.generics.GoGenericsUtilKt;
import com.goide.psi.impl.generics.GoPossiblyIdenticalTypesMatcher;
import com.goide.psi.impl.generics.GoTypeArgument;
import com.goide.psi.impl.generics.GoTypeInstantiationKt;
import com.goide.psi.impl.generics.GoTypeSet;
import com.goide.psi.impl.generics.GoTypeSetKt;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedType;
import com.goide.psi.impl.typesCompatibility.GoAmbiguousMethods;
import com.goide.psi.impl.typesCompatibility.GoCannotBeNil;
import com.goide.psi.impl.typesCompatibility.GoCannotUsePointerReceiverMethod;
import com.goide.psi.impl.typesCompatibility.GoDoesNotImplementInterface;
import com.goide.psi.impl.typesCompatibility.GoInterfaceWithNonExportedMethodInDifferentPackage;
import com.goide.psi.impl.typesCompatibility.GoMethodsMissing;
import com.goide.psi.impl.typesCompatibility.GoNonStrictComparabilityUnsupported;
import com.goide.psi.impl.typesCompatibility.GoNotInTypeSet;
import com.goide.psi.impl.typesCompatibility.GoNotRepresentable;
import com.goide.psi.impl.typesCompatibility.GoRangeExpressionWithoutCoreType;
import com.goide.psi.impl.typesCompatibility.GoSignatureDiffers;
import com.goide.psi.impl.typesCompatibility.GoTypeCheckResult;
import com.goide.psi.impl.typesCompatibility.GoTypesCompatible;
import com.goide.psi.impl.typesCompatibility.GoTypesNotCompatible;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.goide.stubs.GoTypeSpecStub;
import com.goide.stubs.GoTypeStub;
import com.goide.stubs.index.GoIdFilter;
import com.goide.stubs.index.GoTypesIndex;
import com.goide.util.GoStdlibUtil;
import com.goide.util.GoUtil;
import com.goide.utils.GoStringUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class GoTypeUtil {
    private static final Comparator<GoNamedElement> BY_NAME = (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
    private static final String INT = "int";
    private static final String INT8 = "int8";
    private static final String INT16 = "int16";
    private static final String INT32 = "int32";
    private static final String INT64 = "int64";
    private static final String UINT = "uint";
    public static final String UINT8 = "uint8";
    private static final String UINT16 = "uint16";
    private static final String UINT32 = "uint32";
    private static final String UINT64 = "uint64";
    private static final String FLOAT32 = "float32";
    private static final String FLOAT64 = "float64";
    public static final String COMPLEX64 = "complex64";
    public static final String COMPLEX128 = "complex128";
    private static final String RUNE = "rune";
    public static final String BYTE = "byte";
    private static final String UINTPTR = "uintptr";
    private static final Set<String> NUMERIC_TYPES = Set.of("int", "int8", "int16", "int32", "int64", "uint", "uint8", "uint16", "uint32", "uint64", "float32", "float64", "complex64", "complex128", "rune", "byte", "uintptr");
    private static final Set<String> INTEGER_TYPES = Set.of("int", "int8", "int16", "int32", "int64", "uint", "uint8", "uint16", "uint32", "uint64", "rune", "byte", "uintptr");
    private static final Set<String> UINT_TYPES = Set.of("uint", "uint8", "uint16", "uint32", "uint64", "byte", "uintptr");
    private static final Set<String> FLOAT_TYPES = Set.of("float32", "float64");
    private static final Set<String> COMPLEX_TYPES = Set.of("complex64", "complex128");
    private static final Set<String> INT32_ALIAS = Set.of("int32", "rune");
    private static final Set<String> UINT8_ALIAS = Set.of("uint8", "byte");
    private static final String DOC_ONLY_ANY_TYPE = "Type";
    private static final String DOC_ONLY_ANY_TYPE_1 = "Type1";
    private static final String DOC_ONLY_INTEGER_TYPE = "IntegerType";
    private static final String DOC_ONLY_FLOAT_TYPE = "FloatType";
    private static final String DOC_ONLY_COMPLEX_TYPE = "ComplexType";
    public static final Set<String> DOC_ONLY_TYPES = Set.of("Type", "Type1", "IntegerType", "FloatType", "ComplexType");
    private static final Set<String> DOC_ONLY_ANY_TYPES = Set.of("Type", "Type1");
    private static final Set<String> DOC_ONLY_NUMERIC_TYPES = Set.of("IntegerType", "FloatType", "ComplexType");
    private static final Map<String, Pair<Long, Long>> INTEGER_LIMITS = Map.ofEntries(Map.entry("uint8", Pair.pair((Object)0L, (Object)255L)), Map.entry("uint16", Pair.pair((Object)0L, (Object)65535L)), Map.entry("uint32", Pair.pair((Object)0L, (Object)0xFFFFFFFFL)), Map.entry("byte", Pair.pair((Object)0L, (Object)255L)), Map.entry("int8", Pair.pair((Object)-128L, (Object)127L)), Map.entry("int16", Pair.pair((Object)-32768L, (Object)32767L)), Map.entry("int32", Pair.pair((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE)), Map.entry("int64", Pair.pair((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE)), Map.entry("rune", Pair.pair((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE)));
    private static final int PROCESS_METHODS_BY_LEVEL_ALLOWED_DEPTH = 100;

    @NotNull
    public static GoTypeCheckResult checkIterable(@Nullable GoType type, @Nullable PsiElement context) {
        if (type == null) {
            return new GoTypesCompatible();
        }
        GoType coreType = GoTypeUtil.getCoreType(type, context);
        if (coreType == null) {
            return new GoRangeExpressionWithoutCoreType();
        }
        boolean isIterable = coreType instanceof GoChannelType || GoTypeUtil.isIterableAndIndexed(coreType, context) || GoTypeUtil.isIntegerType(coreType, context) || GoTypeUtil.isIteratorType(coreType, context) || GoTypeUtil.matchTypeConstraints(coreType, context, (GoType t) -> GoTypeUtil.isIterable(t, context));
        GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(isIterable);
        if (goTypeCheckResult == null) {
            GoTypeUtil.$$$reportNull$$$0(0);
        }
        return goTypeCheckResult;
    }

    @Contract(value="null, _ -> false")
    public static boolean isIterable(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.checkIterable(type, context) instanceof GoTypesCompatible;
    }

    public static boolean isIterableAndIndexed(@Nullable GoType type, @Nullable PsiElement context) {
        GoType goType = type = type != null ? type.getUnderlyingType(context) : null;
        if (type instanceof GoArrayOrSliceType || type instanceof GoMapType) {
            return true;
        }
        if (type instanceof GoPointerType) {
            return GoTypeUtil.isArray(((GoPointerType)type).getType(), context);
        }
        return GoTypeUtil.isString(type, context) || GoTypeUtil.matchTypeConstraints(type, context, (GoType t) -> GoTypeUtil.isIterableAndIndexed(t, context));
    }

    public static boolean isArray(@Nullable GoType type, @Nullable PsiElement context) {
        type = type != null ? type.getUnderlyingType(context) : null;
        return type instanceof GoArrayOrSliceType && ((GoArrayOrSliceType)type).isArray() || GoTypeUtil.matchTypeConstraints(type, context, (GoType t) -> GoTypeUtil.isArray(t, context));
    }

    public static boolean isSlice(@Nullable GoType type, @Nullable PsiElement context) {
        GoArrayOrSliceType arrayOrSliceType = (GoArrayOrSliceType)GoTypeUtil.getArrayOrSliceType(type, context);
        return arrayOrSliceType != null && !arrayOrSliceType.isArray();
    }

    public static boolean isString(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isStringType(type, context) || GoTypeUtil.matchTypeConstraints(type, context, (GoType t) -> GoTypeUtil.isString(t, context));
    }

    private static boolean isStringType(@Nullable GoType type, @Nullable PsiElement context) {
        return type instanceof GoLightType.LightUntypedStringType || GoTypeUtil.isBuiltinType(type, context, "string");
    }

    public static boolean isBoolean(@Nullable GoType type, @Nullable PsiElement context) {
        return type instanceof GoLightType.LightUntypedBoolType || GoTypeUtil.isBuiltinType(type, context, "bool") || GoTypeUtil.matchTypeConstraints(type, context, (GoType t) -> GoTypeUtil.isBoolean(t, context));
    }

    public static boolean isError(@Nullable GoType type, @Nullable PsiElement context) {
        return type != null && !(type instanceof GoCompositeType) && type.textMatches("error") && GoTypeUtil.isBuiltinType(type, context);
    }

    public static boolean isVoid(@Nullable GoType type) {
        return type instanceof GoLightType.LightVoidType;
    }

    @Contract(value="null, _ -> false")
    public static boolean isUnresolvedType(@Nullable GoType type, @Nullable ResolveState resolveState) {
        return GoTypeUtil.isNamedType(type) && !GoTypeUtil.isBasicType(type, null) && type.resolve(resolveState) == null;
    }

    @Contract(value="null, _, _ -> false; _, _, null -> false")
    private static boolean isBuiltinType(@Nullable GoType type, @Nullable PsiElement context, @Nullable String builtinTypeName) {
        if (builtinTypeName == null) {
            return false;
        }
        type = type != null ? type.getUnderlyingType(context) : null;
        return type != null && !(type instanceof GoCompositeType) && type.textMatches(builtinTypeName) && GoPsiImplUtil.builtin(type);
    }

    public static boolean isBuiltinType(@Nullable GoType type, @Nullable PsiElement context) {
        return GoPsiImplUtil.builtin(type != null ? type.getUnderlyingType(context) : null);
    }

    private static boolean isArbitraryType(@Nullable GoType type, @Nullable PsiElement context) {
        if (type instanceof GoSpecType || type instanceof GoTypeList) {
            return false;
        }
        if (type != null && "ArbitraryType".equals(GoTypeUtil.getTypeNameOrText(type))) {
            PsiElement resolve = type.resolve(context);
            return resolve != null && GoPsiImplUtil.isUnsafeFile(resolve.getContainingFile());
        }
        return false;
    }

    public static boolean isUnsafePointerType(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(1);
        }
        return (type = type.getUnderlyingType(context)) instanceof GoPointerType && GoTypeUtil.isArbitraryType(((GoPointerType)type).getType(), context);
    }

    public static boolean isCType(@Nullable GoType type, @Nullable PsiElement context) {
        return type != null && type.getUnderlyingType(context) instanceof GoCType;
    }

    public static boolean isNumericType(@Nullable GoType type, @Nullable PsiElement context) {
        return type != null && NUMERIC_TYPES.contains(GoTypeUtil.getTypeNameOrText(type)) && GoTypeUtil.isBuiltinType(type, context) || GoTypeUtil.isUntypedNumericType(type) || GoTypeUtil.matchTypeConstraints(type, context, (GoType t) -> GoTypeUtil.isNumericType(t, context));
    }

    public static boolean isPlusable(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isNumericType(type, context) || GoTypeUtil.isString(type, context) || GoTypeUtil.matchTypeConstraints(type, context, (GoType t) -> GoTypeUtil.isPlusable(t, context));
    }

    @Contract(value="null, _ -> false")
    public static boolean isBasicType(@Nullable GoType type, @Nullable PsiElement context) {
        return type instanceof GoLightType.LightUntypedType || GoPsiImplUtil.builtin(type) || type instanceof GoPointerType && GoTypeUtil.isArbitraryType(((GoPointerType)type).getType(), context);
    }

    public static boolean isDocOnlyAnyType(@Nullable GoType type, @Nullable PsiElement context) {
        return type != null && DOC_ONLY_ANY_TYPES.contains(GoTypeUtil.getTypeNameOrText(type)) && GoPsiImplUtil.builtin(type);
    }

    private static boolean isDocOnlyNumericType(@Nullable GoType type) {
        return type != null && DOC_ONLY_NUMERIC_TYPES.contains(GoTypeUtil.getTypeNameOrText(type)) && GoPsiImplUtil.builtin(type);
    }

    @Contract(value="null, _ -> false")
    public static boolean isIteratorType(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.getYieldSignatureFromIteratorType(type, context) != null || GoTypeUtil.matchTypeConstraints(type, context, (GoType t) -> GoTypeUtil.isIteratorType(t, context));
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoSignature getYieldSignatureFromIteratorType(@Nullable GoType iteratorType, @Nullable PsiElement context) {
        if (iteratorType == null) {
            return null;
        }
        GoType goType = iteratorType.getUnderlyingType(context);
        if (goType instanceof GoFunctionType) {
            GoType goType2;
            GoFunctionType iteratorFuncType = (GoFunctionType)goType;
            GoSignature iteratorFuncSignature = iteratorFuncType.getSignature();
            if (iteratorFuncSignature == null) {
                return null;
            }
            GoResult iteratorFuncResult = iteratorFuncSignature.getResult();
            if (iteratorFuncResult != null && !iteratorFuncResult.isVoid()) {
                return null;
            }
            GoParameters iteratorParameters = iteratorFuncSignature.getParameters();
            if (iteratorParameters.getParameterCount() != 1) {
                return null;
            }
            GoType yieldType = iteratorParameters.getParameterDeclarationList().get(0).getType();
            if (yieldType != null && (goType2 = yieldType.getUnderlyingType(context)) instanceof GoFunctionType) {
                GoFunctionType yieldFuncType = (GoFunctionType)goType2;
                GoSignature yieldFuncSignature = yieldFuncType.getSignature();
                if (yieldFuncSignature == null) {
                    return null;
                }
                GoResult yieldFuncResult = yieldFuncSignature.getResult();
                if (yieldFuncResult == null || !GoTypeUtil.isBoolean(yieldFuncResult.getType(), context)) {
                    return null;
                }
                return yieldFuncSignature.getParameters().getParameterCount() <= 2 ? yieldFuncSignature : null;
            }
        }
        return GoPsiImplUtil.withContextOnElement(context, state -> {
            GoType iteratorCoreType = GoTypeUtil.getCoreType(iteratorType, state);
            GoAbstractConstraintTerm term = (GoAbstractConstraintTerm)ContainerUtil.getOnlyItem(GoTypeUtil.getConstraintTerms(iteratorCoreType, state));
            if (term == null) {
                return null;
            }
            GoType constraintType = term.getType();
            GoType underlying = constraintType != null ? GoPsiImplUtil.getUnderlyingType(constraintType, state) : null;
            return GoTypeUtil.getYieldSignatureFromIteratorType(underlying, context);
        });
    }

    @Contract(value="null, _ -> false")
    public static boolean isIntegerType(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isUntypedIntegerType(type) || type != null && INTEGER_TYPES.contains(GoTypeUtil.getTypeNameOrText(type)) && GoTypeUtil.isBuiltinType(type, context) || GoTypeUtil.matchTypeConstraints(type, context, (GoType t) -> GoTypeUtil.isIntegerType(t, context));
    }

    public static boolean isIntType(@Nullable GoType type, @Nullable PsiElement context) {
        return type instanceof GoLightType.LightUntypedIntType || type != null && INT.equals(GoTypeUtil.getTypeNameOrText(type)) && GoTypeUtil.isBuiltinType(type, context);
    }

    public static boolean isUntypedIntegerType(@Nullable GoType type) {
        return type instanceof GoLightType.LightUntypedIntType || type instanceof GoLightType.LightUntypedRuneType;
    }

    public static boolean isUntypedFloatType(@Nullable GoType type) {
        return type instanceof GoLightType.LightUntypedFloatType;
    }

    private static boolean isUntypedComplexType(@Nullable GoType type) {
        return type instanceof GoLightType.LightUntypedComplexType;
    }

    public static boolean isUintType(@Nullable GoType type, @Nullable PsiElement context) {
        return type != null && UINT_TYPES.contains(GoTypeUtil.getTypeNameOrText(type)) && GoTypeUtil.isBuiltinType(type, context);
    }

    public static boolean isTypedComplexType(@Nullable GoType type, @Nullable PsiElement context) {
        return type != null && COMPLEX_TYPES.contains(GoTypeUtil.getTypeNameOrText(type)) && GoTypeUtil.isBuiltinType(type, context);
    }

    public static boolean isComplexType(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(2);
        }
        return GoTypeUtil.isTypedComplexType(type, context) || GoTypeUtil.isUntypedComplexType(type);
    }

    @Contract(value="null, _ -> false")
    public static boolean isTypedFloatType(@Nullable GoType type, @Nullable PsiElement context) {
        return type != null && FLOAT_TYPES.contains(GoTypeUtil.getTypeNameOrText(type)) && GoTypeUtil.isBuiltinType(type, context) || GoTypeUtil.matchTypeConstraints(type, context, (GoType t) -> GoTypeUtil.isTypedFloatType(t, context));
    }

    public static boolean isFloatType(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(3);
        }
        return GoTypeUtil.isTypedFloatType(type, context) || GoTypeUtil.isUntypedFloatType(type);
    }

    @Contract(value="null -> false")
    public static boolean isUntypedNumericType(@Nullable GoType type) {
        return type != null && (type instanceof GoLightType.LightUntypedNumericType || GoTypeUtil.isDocOnlyNumericType(type));
    }

    @Contract(value="null, _ -> false")
    public static boolean isUintptr(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type, context, UINTPTR);
    }

    @Contract(value="null, _ -> false")
    public static boolean isFloat32(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type, context, FLOAT32);
    }

    @Contract(value="null, _ -> false")
    public static boolean isFloat64(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type, context, FLOAT64);
    }

    @Contract(value="null, _ -> false")
    public static boolean isComplex64(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type, context, COMPLEX64);
    }

    @Contract(value="null, _ -> false")
    public static boolean isInt64(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type, context, INT64);
    }

    @Contract(value="null, _ -> false")
    public static boolean isUint64(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type, context, UINT64);
    }

    @Contract(value="null, _ -> false")
    public static boolean isComplex128(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type, context, COMPLEX128);
    }

    @Contract(value="null, _ -> false")
    public static boolean isByteType(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type, context, BYTE) || GoTypeUtil.isBuiltinType(type, context, UINT8);
    }

    @Contract(value="null, _ -> false")
    public static boolean isRuneType(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isBuiltinType(type, context, RUNE) || GoTypeUtil.isBuiltinType(type, context, INT32);
    }

    @Nullable
    public static Pair<Long, Long> getIntegerTypeLimits(@NotNull GoType integerType, @Nullable PsiElement context) {
        if (integerType == null) {
            GoTypeUtil.$$$reportNull$$$0(4);
        }
        if (!GoTypeUtil.isIntegerType(integerType, context)) {
            return null;
        }
        return INTEGER_LIMITS.get(GoTypeUtil.getTypeNameOrText(integerType));
    }

    @NotNull
    public static GoExpectedTypes getExpectedTypes(@NotNull GoExpression expression, @NotNull PsiElement context) {
        GoIndexOrSliceExpr indexOrSliceExpr;
        GoConversionExpr conversionExpr;
        GoType type;
        GoRangeClause rangeClause;
        PsiElement parent;
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(6);
        }
        if ((parent = expression.getParent()) == null) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(7);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoCodeFragment) {
            GoCodeFragment codeFragment = (GoCodeFragment)parent;
            GoType type2 = codeFragment.getExpectedType();
            GoExpectedTypes goExpectedTypes = type2 != null ? GoExpectedTypes.create(type2) : GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(8);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoParenthesesExpr) {
            GoParenthesesExpr parenthesesExpr = (GoParenthesesExpr)parent;
            return GoTypeUtil.getExpectedTypes(parenthesesExpr, context);
        }
        if (parent instanceof GoAssignmentStatement) {
            GoAssignmentStatement assignmentStatement = (GoAssignmentStatement)parent;
            return GoTypeUtil.getExpectedTypesFromAssignmentStatement(expression, assignmentStatement, context);
        }
        if (parent instanceof GoRangeClause && expression.equals((rangeClause = (GoRangeClause)parent).getRangeExpression())) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoIterableExpectedType());
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(9);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoRecvStatement) {
            GoRecvStatement recvStatement = (GoRecvStatement)parent;
            return GoTypeUtil.getExpectedTypesFromRecvStatement(recvStatement, context);
        }
        if (parent instanceof GoVarOrConstSpec) {
            GoVarOrConstSpec varOrConstSpec = (GoVarOrConstSpec)parent;
            return GoTypeUtil.getExpectedTypesFromVarOrConstSpec(expression, varOrConstSpec, context);
        }
        if (parent instanceof GoArgumentList) {
            GoType type3;
            GoArgumentList argumentList = (GoArgumentList)parent;
            PsiElement grand = parent.getParent();
            GoType goType = type3 = grand != null ? GoPsiUtil.getTypeIfConversion(GoCompletionUtil.getPhysicalOriginalOrSelf(grand)) : null;
            if (type3 != null) {
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoConversionExpectedType(type3));
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(10);
                }
                return goExpectedTypes;
            }
            if (grand instanceof GoBuiltinCallExpr) {
                GoBuiltinCallExpr newOrMakeCallExpr = (GoBuiltinCallExpr)grand;
                return newOrMakeCallExpr.isTrulyBuiltin() ? GoTypeUtil.getExpectedTypeForNewAndMake(expression, newOrMakeCallExpr, context) : GoTypeUtil.getExpectedTypesFromArgumentList(expression, argumentList, newOrMakeCallExpr, context);
            }
            if (grand instanceof GoCallExpr) {
                GoCallExpr callExpr = (GoCallExpr)grand;
                GoExpectedTypes expectedTypesForBuiltin = GoTypeUtil.getExpectedTypesForBuiltinFunctions(expression, callExpr, context);
                return expectedTypesForBuiltin != null ? expectedTypesForBuiltin : GoTypeUtil.getExpectedTypesFromArgumentList(expression, argumentList, callExpr, context);
            }
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(11);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoUnaryExpr) {
            GoUnaryExpr unaryExpr = (GoUnaryExpr)parent;
            if (unaryExpr.getArrow() != null) {
                GoType type4 = GoTypeUtil.getExpectedTypes(unaryExpr, context).getFirstType();
                String text = GoTypeUtil.getTypeNameOrText(GoTypeUtil.getInterfaceIfNull(type4, context));
                GoType chanType = GoElementFactory.createTypeCheap(parent.getProject(), "chan " + text);
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(chanType);
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(12);
                }
                return goExpectedTypes;
            }
            if (unaryExpr.getBitAnd() != null) {
                GoType[] types = (GoType[])GoTypeUtil.getExpectedTypes(unaryExpr, context).getTypes().stream().map(GoTypeUtil::unwrapPointerAndParTypes).filter(Objects::nonNull).toArray(GoType[]::new);
                GoExpectedTypes goExpectedTypes = types.length == 0 ? GoExpectedTypes.createWithContext(GoTypeUtil.getInterfaceType(parent), context) : GoExpectedTypes.create(types);
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(13);
                }
                return goExpectedTypes;
            }
            if (unaryExpr.getMul() != null) {
                GoType[] types = (GoType[])GoTypeUtil.getExpectedTypes(unaryExpr, context).getTypes().stream().map(GoLightType.LightPointerType::new).toArray(GoType[]::new);
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(types);
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(14);
                }
                return goExpectedTypes;
            }
            return GoTypeUtil.getExpectedTypes(unaryExpr, context);
        }
        if (parent instanceof GoBinaryExpr) {
            GoBinaryExpr binaryExpr = (GoBinaryExpr)parent;
            return GoTypeUtil.getExpectedTypesForBinaryExprOperand(expression, binaryExpr, context);
        }
        if (parent instanceof GoSendStatement) {
            GoSendStatement sendStatement = (GoSendStatement)parent;
            return GoTypeUtil.getExpectedTypesFromGoSendStatement(expression, sendStatement, context);
        }
        if (parent instanceof GoExprCaseClause) {
            GoExprSwitchStatement switchStatement = (GoExprSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, GoExprSwitchStatement.class);
            assert (switchStatement != null);
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoExprCaseClauseExpectedType(switchStatement));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(15);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoReturnStatement) {
            GoReturnStatement returnStatement = (GoReturnStatement)parent;
            return GoTypeUtil.getExpectedTypesFromReturnStatement(returnStatement, expression);
        }
        if (parent instanceof GoKey) {
            GoKey key = (GoKey)parent;
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(GoPsiImplUtil.getKeyType(key), context);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(16);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoValue) {
            GoLiteralValue literalValue;
            GoType literalValueType;
            GoValue value = (GoValue)parent;
            GoElement literalElement = (GoElement)ObjectUtils.tryCast((Object)parent.getParent(), GoElement.class);
            if (literalElement != null && literalElement.getKey() == null && (literalValueType = GoInspectionUtil.getLiteralValueUnderlyingType(literalValue = (GoLiteralValue)ObjectUtils.tryCast((Object)literalElement.getParent(), GoLiteralValue.class))) instanceof GoMapType) {
                GoMapType mapType = (GoMapType)literalValueType;
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(mapType.getKeyType(), context);
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(17);
                }
                return goExpectedTypes;
            }
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(GoPsiImplUtil.getValueType(value), context);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(18);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoForStatement || parent instanceof GoForClause || GoPsiUtil.isIfCondition(expression)) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoConditionExpectedType(context));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(19);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoDeferStatement) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoFunctionExpectedType());
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(20);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoLeftHandExprList) {
            GoLeftHandExprList leftHandExprList = (GoLeftHandExprList)parent;
            return GoTypeUtil.getExpectedTypesFromAssignmentLHS(expression, leftHandExprList, context);
        }
        if (parent instanceof GoConversionExpr && (type = GoPsiUtil.getTypeIfConversion(GoCompletionUtil.getPhysicalOriginalOrSelf(conversionExpr = (GoConversionExpr)parent))) != null) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoConversionExpectedType(type));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(21);
            }
            return goExpectedTypes;
        }
        if (parent instanceof GoIndexOrSliceExpr && (indexOrSliceExpr = (GoIndexOrSliceExpr)parent).getExpressionList().contains(expression)) {
            GoReferenceExpression referenceExpression;
            GoType exprType;
            GoExpression indexedExpr = indexOrSliceExpr.getExpression();
            GoType goType = exprType = indexedExpr != null ? indexedExpr.getGoType(null) : null;
            if (exprType instanceof GoMapType) {
                GoMapType mapType = (GoMapType)exprType;
                GoType keyType = mapType.getKeyType();
                GoExpectedTypes goExpectedTypes = keyType != null ? GoExpectedTypes.create(keyType) : GoExpectedTypes.EMPTY;
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(22);
                }
                return goExpectedTypes;
            }
            if (exprType instanceof GoArrayOrSliceType) {
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoAnyIntegerExpectedType.inSliceExpression(expression));
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(23);
                }
                return goExpectedTypes;
            }
            if (indexedExpr instanceof GoReferenceExpression && (referenceExpression = (GoReferenceExpression)indexedExpr).resolve() == null) {
                if (indexOrSliceExpr.isIndexExpression()) {
                    GoType type5;
                    GoExpression firstIndex = (GoExpression)indexOrSliceExpr.getIndices().first;
                    if (firstIndex != null && (type5 = firstIndex.getGoType(null)) != null) {
                        if (GoTypeUtil.isIntegerType(type5, indexOrSliceExpr)) {
                            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoElementFactory.createTypeCheap(indexOrSliceExpr.getProject(), "[]any"));
                            if (goExpectedTypes == null) {
                                GoTypeUtil.$$$reportNull$$$0(24);
                            }
                            return goExpectedTypes;
                        }
                        String typeText = "map[" + type5.getPresentationText() + "]any";
                        GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoElementFactory.createTypeCheap(indexOrSliceExpr.getProject(), typeText, indexOrSliceExpr));
                        if (goExpectedTypes == null) {
                            GoTypeUtil.$$$reportNull$$$0(25);
                        }
                        return goExpectedTypes;
                    }
                } else {
                    GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoElementFactory.createTypeCheap(indexOrSliceExpr.getProject(), "[]any"));
                    if (goExpectedTypes == null) {
                        GoTypeUtil.$$$reportNull$$$0(26);
                    }
                    return goExpectedTypes;
                }
            }
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(27);
        }
        return goExpectedTypes;
    }

    public static boolean isMapCompositeLiteralElement(@NotNull GoElement literalElement) {
        if (literalElement == null) {
            GoTypeUtil.$$$reportNull$$$0(28);
        }
        GoLiteralValue literalValue = (GoLiteralValue)ObjectUtils.tryCast((Object)literalElement.getParent(), GoLiteralValue.class);
        GoType literalValueType = GoInspectionUtil.getLiteralValueUnderlyingType(literalValue);
        return literalValueType instanceof GoMapType;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromReturnStatement(@NotNull GoReturnStatement returnStatement, @NotNull GoExpression expression) {
        GoSignatureOwner signatureOwner;
        if (returnStatement == null) {
            GoTypeUtil.$$$reportNull$$$0(29);
        }
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(30);
        }
        GoType type = (signatureOwner = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GoSignatureOwner.class)) != null ? signatureOwner.getResultType() : null;
        List<GoType> resultTypes = type instanceof GoTypeList ? ((GoTypeList)type).getTypeList() : ContainerUtil.createMaybeSingletonList((Object)type);
        int resultCount = resultTypes.size();
        List<GoExpression> expressions = returnStatement.getExpressionList();
        int indexOf = expressions.indexOf(expression);
        if (indexOf < 0 || expressions.size() > resultCount) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(31);
            }
            return goExpectedTypes;
        }
        GoExpectedTypes goExpectedTypes = expressions.size() == 1 && resultCount > 1 ? GoExpectedTypes.create(type, (GoType)ContainerUtil.getFirstItem(resultTypes)) : GoExpectedTypes.create(resultTypes.get(indexOf));
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(32);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromGoSendStatement(@NotNull GoExpression expression, @NotNull GoSendStatement statement, @NotNull PsiElement context) {
        GoType chanType;
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(33);
        }
        if (statement == null) {
            GoTypeUtil.$$$reportNull$$$0(34);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(35);
        }
        GoExpression channel = statement.getChannelExpression();
        GoExpression sendExpr = statement.getSendExpression();
        if (expression.isEquivalentTo(sendExpr) && (chanType = channel.getGoType(null)) instanceof GoChannelType) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(((GoChannelType)chanType).getType(), statement);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(36);
            }
            return goExpectedTypes;
        }
        if (expression.isEquivalentTo(channel)) {
            GoType type = sendExpr != null ? sendExpr.getGoType(null) : null;
            String text = GoTypeUtil.getTypeNameOrText(GoTypeUtil.getInterfaceIfNull(type, context));
            GoType chanType2 = GoElementFactory.createTypeCheap(statement.getProject(), "chan " + text);
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(chanType2);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(37);
            }
            return goExpectedTypes;
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(GoTypeUtil.getInterfaceType(statement), statement);
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(38);
        }
        return goExpectedTypes;
    }

    @Nullable
    public static GoSignature getSignatureFromFunctionType(@NotNull GoCallLikeExpr call) {
        GoExpression calledExpression;
        GoType type;
        GoType coreType;
        if (call == null) {
            GoTypeUtil.$$$reportNull$$$0(39);
        }
        GoType goType = coreType = (type = (calledExpression = call.getExpression()).getGoType(null)) != null ? GoTypeUtil.getCoreType(type, call) : null;
        if (coreType instanceof GoFunctionType) {
            return ((GoFunctionType)coreType).getSignature();
        }
        return null;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromArgumentList(@NotNull GoExpression expression, @NotNull GoArgumentList argumentList, @NotNull GoCallLikeExpr call, @NotNull PsiElement context) {
        GoSignature resolvedSignature;
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(40);
        }
        if (argumentList == null) {
            GoTypeUtil.$$$reportNull$$$0(41);
        }
        if (call == null) {
            GoTypeUtil.$$$reportNull$$$0(42);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(43);
        }
        if ((resolvedSignature = call.resolveSignature()) != null) {
            GoParameters parameters = resolvedSignature.getParameters();
            List<GoParameterDeclaration> paramsList = parameters.getParameterDeclarationList();
            if (paramsList.isEmpty()) {
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(44);
                }
                return goExpectedTypes;
            }
            boolean variadic = parameters.isVariadic();
            List<GoExpression> exprList = argumentList.getExpressionList();
            if (exprList.size() == 1) {
                SmartList typeList = new SmartList();
                for (GoParameterDeclaration parameterDecl : paramsList) {
                    for (GoParamDefinition parameter : parameterDecl.getParamDefinitionList()) {
                        GoType type = GoTypeUtil.unwrapVariadicArrayOrSliceType(GoTypeUtil.getGoType(parameter, context), parameter);
                        typeList.add(GoTypeUtil.getInterfaceIfNull(type, context));
                    }
                    if (!parameterDecl.getParamDefinitionList().isEmpty()) continue;
                    typeList.add(GoTypeUtil.getInterfaceIfNull(parameterDecl.getType(), context));
                }
                GoExpectedTypeImpl typeListExpectedType = new GoExpectedTypeImpl(GoTypeUtil.createGoTypeListOrGoType((List<GoType>)typeList, context, context), variadic);
                if (typeList.size() <= 1) {
                    GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(typeListExpectedType);
                    if (goExpectedTypes == null) {
                        GoTypeUtil.$$$reportNull$$$0(45);
                    }
                    return goExpectedTypes;
                }
                assert (paramsList.get(0) != null);
                GoType firstParameterType = GoTypeUtil.getInterfaceIfNull(paramsList.get(0).getType(), context);
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(typeListExpectedType, new GoExpectedTypeImpl(firstParameterType, false));
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(46);
                }
                return goExpectedTypes;
            }
            GoParameterDeclaration lastParameter = (GoParameterDeclaration)ContainerUtil.getLastItem(paramsList);
            int index = exprList.indexOf(expression);
            GoParameterDeclaration decl = parameters.getDeclarationByIndex(index);
            if (decl != null) {
                GoParamDefinition parameter = parameters.getDefinitionByIndex(index);
                GoType parameterType = parameter != null ? parameter.getGoType(null) : parameters.getTypeByIndex(index);
                GoType type = GoTypeUtil.unwrapVariadicArrayOrSliceType(parameterType, parameter);
                boolean isLastParameter = decl.isEquivalentTo(lastParameter);
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(type, context, variadic && isLastParameter);
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(47);
                }
                return goExpectedTypes;
            }
            if (variadic) {
                GoType type = Objects.requireNonNull(lastParameter).getType();
                GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(type, context, false);
                if (goExpectedTypes == null) {
                    GoTypeUtil.$$$reportNull$$$0(48);
                }
                return goExpectedTypes;
            }
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(GoTypeUtil.getInterfaceType(context), context, true);
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(49);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesForBinaryExprOperand(@NotNull GoExpression operand, @NotNull GoBinaryExpr binaryExpression, @NotNull PsiElement context) {
        PsiElement operator;
        if (operand == null) {
            GoTypeUtil.$$$reportNull$$$0(50);
        }
        if (binaryExpression == null) {
            GoTypeUtil.$$$reportNull$$$0(51);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(52);
        }
        if ((operator = binaryExpression.getOperator()) == null) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoTypeUtil.getInterfaceType(context));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(53);
            }
            return goExpectedTypes;
        }
        GoType type = GoTypeUtil.getExpectedOperandTypeFromOtherOperands(operand, binaryExpression, context);
        if (type != null) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(type);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(54);
            }
            return goExpectedTypes;
        }
        IElementType operatorType = operator.getNode().getElementType();
        GoExpectedTypes expectedTypes = GoTypeUtil.getExpectedTypes(binaryExpression, context);
        if (!expectedTypes.areEmpty() && !expectedTypes.areCompatibleWith(GoTypeUtil.getInterfaceType(context), null, false, false, GoPsiImplUtil.createContextOnElement(context))) {
            GoExpectedTypes goExpectedTypes = expectedTypes;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(55);
            }
            return goExpectedTypes;
        }
        if (GoParserDefinition.Lazy.SHIFT_BINARY_OPERATORS.contains(operatorType)) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoLightType.getIntType(operand));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(56);
            }
            return goExpectedTypes;
        }
        if (GoParserDefinition.Lazy.CONDITION_BINARY_OPERATORS.contains(operatorType)) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(new GoConditionExpectedType(context));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(57);
            }
            return goExpectedTypes;
        }
        if (operatorType == GoTypes.PLUS) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoLightType.getIntType(operand), GoLightType.getFloatType(operand), GoLightType.getComplexType(operand), GoLightType.getStringType(operand));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(58);
            }
            return goExpectedTypes;
        }
        if (operatorType == GoTypes.MINUS || operatorType == GoTypes.MUL || operatorType == GoTypes.QUOTIENT) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoLightType.getIntType(operand), GoLightType.getFloatType(operand), GoLightType.getComplexType(operand));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(59);
            }
            return goExpectedTypes;
        }
        if (operatorType == GoTypes.REMAINDER || operatorType == GoTypes.BIT_AND || operatorType == GoTypes.BIT_OR || operatorType == GoTypes.BIT_XOR || operatorType == GoTypes.BIT_CLEAR) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoLightType.getIntType(operand));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(60);
            }
            return goExpectedTypes;
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoTypeUtil.getInterfaceType(context));
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(61);
        }
        return goExpectedTypes;
    }

    @Nullable
    private static GoType getExpectedOperandTypeFromOtherOperands(@NotNull GoExpression operandExpr, @NotNull GoBinaryExpr binaryExpression, @NotNull PsiElement context) {
        PsiElement operator;
        if (operandExpr == null) {
            GoTypeUtil.$$$reportNull$$$0(62);
        }
        if (binaryExpression == null) {
            GoTypeUtil.$$$reportNull$$$0(63);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(64);
        }
        if ((operator = binaryExpression.getOperator()) == null) {
            return null;
        }
        boolean isConditionalExpr = GoParserDefinition.Lazy.CONDITION_BINARY_OPERATORS.contains(GoTypeUtil.getBinaryExprOperatorType(binaryExpression));
        GoType result = null;
        PsiElement operand = GoTypeUtil.findNonShiftExpressionOperand(operandExpr);
        while (operand != null) {
            GoExpression otherOperand;
            GoType otherOperandType;
            GoType type;
            GoBinaryExpr parentExpr = (GoBinaryExpr)operand.getParent();
            if (!isConditionalExpr && GoParserDefinition.Lazy.CONDITION_BINARY_OPERATORS.contains(GoTypeUtil.getBinaryExprOperatorType(parentExpr)) || (type = GoTypeUtil.getBinaryExprOperandTypeFromOtherOperand(result, otherOperandType = (otherOperand = parentExpr.getLeft() == operand ? parentExpr.getRight() : parentExpr.getLeft()) != null ? otherOperand.getGoType(null) : null, context)) == null || !((result = type) instanceof GoLightType.LightUntypedType)) break;
            operand = GoTypeUtil.findNonShiftExpressionOperand(parentExpr);
        }
        return result;
    }

    @Nullable
    private static PsiElement findNonShiftExpressionOperand(@NotNull PsiElement operand) {
        if (operand == null) {
            GoTypeUtil.$$$reportNull$$$0(65);
        }
        operand = GoPsiUtil.skipParens(operand);
        GoBinaryExpr binaryExpr = (GoBinaryExpr)ObjectUtils.tryCast((Object)operand.getParent(), GoBinaryExpr.class);
        while (GoParserDefinition.Lazy.SHIFT_BINARY_OPERATORS.contains(GoTypeUtil.getBinaryExprOperatorType(binaryExpr))) {
            if (binaryExpr.getLeft() == operand) {
                operand = GoPsiUtil.skipParens(binaryExpr);
                binaryExpr = (GoBinaryExpr)ObjectUtils.tryCast((Object)operand.getParent(), GoBinaryExpr.class);
                continue;
            }
            return null;
        }
        return binaryExpr != null ? operand : null;
    }

    @Nullable
    private static GoType getBinaryExprOperandTypeFromOtherOperand(@Nullable GoType operandType, @Nullable GoType otherOperandType, @Nullable PsiElement context) {
        int otherOperandTypeRank;
        int operandTypeRank;
        if (otherOperandType == null) {
            return null;
        }
        if (operandType == null) {
            return otherOperandType;
        }
        if (!GoTypeUtil.isAssignable(operandType, null, otherOperandType, context, true)) {
            return GoTypeUtil.isAssignable(otherOperandType, null, operandType, context, true) ? otherOperandType : null;
        }
        if (operandType instanceof GoLightType.LightUntypedNumericType && otherOperandType instanceof GoLightType.LightUntypedNumericType && (operandTypeRank = GoPsiImplUtil.getUntypedNumericTypeRank((GoLightType.LightUntypedNumericType)operandType)) < (otherOperandTypeRank = GoPsiImplUtil.getUntypedNumericTypeRank((GoLightType.LightUntypedNumericType)otherOperandType))) {
            return otherOperandType;
        }
        return operandType;
    }

    @Contract(value="null -> null")
    @Nullable
    private static IElementType getBinaryExprOperatorType(@Nullable PsiElement element) {
        return GoExpressionUtil.getOperatorType((GoBinaryExpr)ObjectUtils.tryCast((Object)element, GoBinaryExpr.class));
    }

    @Contract(value="!null,_ -> !null")
    private static GoType unwrapVariadicArrayOrSliceType(@Nullable GoType type, @Nullable GoParamDefinition parameter) {
        return GoTypeUtil.unwrapVariadicArrayOrSliceType(type, parameter != null && parameter.isVariadic());
    }

    @Contract(value="!null,_ -> !null")
    public static GoType unwrapVariadicArrayOrSliceType(@Nullable GoType type, boolean isVariadic) {
        if (isVariadic && type instanceof GoArrayOrSliceType) {
            return ((GoArrayOrSliceType)type).getType();
        }
        return type;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypeForNewAndMake(@NotNull GoExpression expression, @NotNull GoBuiltinCallExpr callExpr, @NotNull PsiElement context) {
        boolean textMatches;
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(66);
        }
        if (callExpr == null) {
            GoTypeUtil.$$$reportNull$$$0(67);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(68);
        }
        GoBuiltinArgumentList list = callExpr.getBuiltinArgumentList();
        GoExpression referenceExpression = callExpr.getExpression().unwrapParentheses();
        boolean bl = textMatches = referenceExpression != null && !referenceExpression.textMatches("make");
        if (textMatches || expression != ContainerUtil.getFirstItem(list.getExpressionList())) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(69);
            }
            return goExpectedTypes;
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoAnyIntegerExpectedType.inBuiltinFile(context));
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(70);
        }
        return goExpectedTypes;
    }

    @Nullable
    private static GoExpectedTypes getExpectedTypesForBuiltinFunctions(@NotNull GoExpression expression, @NotNull GoCallExpr callExpr, @NotNull PsiElement context) {
        GoType keyType;
        List<GoExpression> exprList;
        GoExpression first;
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(71);
        }
        if (callExpr == null) {
            GoTypeUtil.$$$reportNull$$$0(72);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(73);
        }
        GoType firstType = (first = (GoExpression)ContainerUtil.getFirstItem(exprList = callExpr.getArgumentList().getExpressionList())) != null ? first.getGoType(null) : null;
        int index = exprList.indexOf(expression);
        if (GoPsiUtil.isBuiltinFunctionCall(callExpr, "append")) {
            if (index == 0) {
                return GoExpectedTypes.create(GoTypedSliceExpectedType.inBuiltinFile());
            }
            GoType elementType = GoTypeUtil.getArrayOrSliceElementType(GoTypeUtil.getArrayOrSliceType(firstType, context));
            if (elementType != null) {
                return GoExpectedTypes.create(elementType, exprList.size() == 2);
            }
        }
        if (GoPsiUtil.isBuiltinFunctionCall(callExpr, "delete") && index == 1 && (keyType = GoTypeUtil.getMapKeyType(firstType, context)) != null) {
            return GoExpectedTypes.create(keyType, false);
        }
        if (GoPsiUtil.isBuiltinFunctionCall(callExpr, "complex")) {
            GoType underlying;
            if (index > 0 && firstType != null && !GoTypeUtil.isTypeParameter(firstType, context) && GoTypeUtil.isTypedFloatType(underlying = firstType.getUnderlyingType(context), context)) {
                return GoExpectedTypes.create(new GoIdenticalExpectedType(firstType), new GoUntypedFloatExpectedType());
            }
            return GoExpectedTypes.create(new GoNotTypeParameterExpectedType(new GoAnyFloatExpectedType()));
        }
        if (GoPsiUtil.isBuiltinFunctionCall(callExpr, "real", "imag")) {
            return GoExpectedTypes.create(new GoNotTypeParameterExpectedType(new GoAnyComplexExpectedType()));
        }
        if (GoPsiUtil.isBuiltinFunctionCall(callExpr, "copy")) {
            if (exprList.size() != 2 || index < 0 || index > 1) {
                return GoTypeUtil.builtinCopyDefaultExpectedTypes(index, context);
            }
            GoExpression second = exprList.get(1);
            if (first == null || second == null) {
                return GoTypeUtil.builtinCopyDefaultExpectedTypes(index, context);
            }
            if (index == 0) {
                GoType srcCoreType;
                if (GoExpressionUtil.isNil(first) && (srcCoreType = GoTypeUtil.getCoreType(second.getGoType(null), context)) != null) {
                    GoArrayOrSliceType byteSliceType;
                    if (GoTypeUtil.isSlice(srcCoreType, context)) {
                        return GoExpectedTypes.create(new GoNotNilExpectedType(new GoCoreIdenticalExpectedType(srcCoreType)));
                    }
                    if (GoTypeUtil.isString(srcCoreType, context) && (byteSliceType = GoTypeUtil.getByteSliceType(context)) != null) {
                        return GoExpectedTypes.create(new GoNotNilExpectedType(new GoCoreIdenticalExpectedType(byteSliceType)));
                    }
                }
                return GoExpectedTypes.create(GoTypedSliceExpectedType.inBuiltinFile());
            }
            GoType dstCoreType = GoTypeUtil.getCoreType(firstType, context);
            if (dstCoreType == null || !GoTypeUtil.isSlice(dstCoreType, context)) {
                return GoTypeUtil.builtinCopyDefaultExpectedTypes(index, context);
            }
            if (GoTypeUtil.isByteSliceStrict(dstCoreType, context)) {
                return GoExpectedTypes.create(new GoNotNilExpectedType(new GoCoreIdenticalExpectedType(dstCoreType)), new GoCoreStringExpectedType());
            }
            return GoExpectedTypes.create(new GoNotNilExpectedType(new GoCoreIdenticalExpectedType(dstCoreType)));
        }
        if (GoPsiUtil.isBuiltinFunctionCall(callExpr, "close")) {
            return GoExpectedTypes.create(new GoAnySendChannelExpectedType());
        }
        if (GoStdlibUtil.isUnsafeFunctionCall(callExpr, "Slice")) {
            if (index == 0) {
                return GoExpectedTypes.create(new GoNotNilExpectedType(new GoAnyPointerExpectedType()));
            }
            if (index == 1) {
                return GoExpectedTypes.create(GoAnyIntegerExpectedType.inUnsafePackage(context));
            }
        }
        if (GoStdlibUtil.isUnsafeFunctionCall(callExpr, "SliceData") && index == 0) {
            return GoExpectedTypes.create(GoTypedSliceExpectedType.inUnsafePackage());
        }
        if (GoStdlibUtil.isUnsafeFunctionCall(callExpr, "Add", "String") && index == 1) {
            return GoExpectedTypes.create(GoAnyIntegerExpectedType.inUnsafePackage(context));
        }
        return null;
    }

    @NotNull
    private static GoExpectedTypes builtinCopyDefaultExpectedTypes(int argumentIndex, @NotNull PsiElement context) {
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(74);
        }
        if (argumentIndex == 0) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoTypedSliceExpectedType.inBuiltinFile());
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(75);
            }
            return goExpectedTypes;
        }
        if (argumentIndex == 1) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoTypedSliceExpectedType.inBuiltinFile(), new GoCoreStringExpectedType());
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(76);
            }
            return goExpectedTypes;
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoTypeUtil.getInterfaceType(context));
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(77);
        }
        return goExpectedTypes;
    }

    public static boolean isByteSlice(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isSliceOfType(type, context, BYTE, UINT8);
    }

    public static boolean isByteSliceStrict(@Nullable GoType type, @Nullable PsiElement context) {
        GoType instantiatedSlice = GoTypeUtil.getArrayOrSliceType(type, context);
        GoArrayOrSliceType slice = (GoArrayOrSliceType)instantiatedSlice;
        if (slice == null || slice.isArray()) {
            return false;
        }
        GoType sliceElementType = GoTypeUtil.getArrayOrSliceElementType(instantiatedSlice);
        return sliceElementType != null && (sliceElementType.textMatches(BYTE) || sliceElementType.textMatches(UINT8)) && GoPsiImplUtil.builtin(sliceElementType.resolve(context));
    }

    public static boolean isRuneSlice(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.isSliceOfType(type, context, RUNE, INT32);
    }

    public static boolean isSliceOfType(@Nullable GoType type, @Nullable PsiElement context, String ... builtinTypes) {
        GoType instantiatedSlice;
        GoArrayOrSliceType slice;
        if (builtinTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(78);
        }
        if ((slice = (GoArrayOrSliceType)(instantiatedSlice = GoTypeUtil.getArrayOrSliceType(type, context))) == null || slice.isArray()) {
            return false;
        }
        GoType sliceType = GoTypeUtil.getArrayOrSliceElementType(instantiatedSlice);
        for (String builtinType : builtinTypes) {
            if (!GoTypeUtil.isBuiltinType(sliceType, context, builtinType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromRecvStatement(@NotNull GoRecvStatement recvStatement, @NotNull PsiElement context) {
        if (recvStatement == null) {
            GoTypeUtil.$$$reportNull$$$0(79);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(80);
        }
        SmartList typeList = new SmartList();
        for (GoExpression expr : recvStatement.getLeftExpressionsList()) {
            typeList.add(GoTypeUtil.getGoType(expr, context));
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(GoTypeUtil.createGoTypeListOrGoType((List<GoType>)typeList, recvStatement, context));
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(81);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromVarOrConstSpec(@NotNull GoExpression expression, @NotNull GoVarOrConstSpec spec, @NotNull PsiElement context) {
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(82);
        }
        if (spec == null) {
            GoTypeUtil.$$$reportNull$$$0(83);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(84);
        }
        GoType type = GoTypeUtil.getInterfaceIfNull(spec.getType(), context);
        if (spec.getRightExpressionsList().size() == 1) {
            int defListSize = spec.getDefinitionList().size();
            return GoTypeUtil.getTypes(expression, type, defListSize, context);
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.create(type);
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(85);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoExpectedTypes getTypes(@NotNull PsiElement expression, @NotNull GoType type, int defListSize, @NotNull PsiElement context) {
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(86);
        }
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(87);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(88);
        }
        SmartList listOfTypes = new SmartList();
        for (int i = 0; i < defListSize; ++i) {
            listOfTypes.add(type);
        }
        GoType typeList = GoTypeUtil.createGoTypeListOrGoType((List<GoType>)listOfTypes, expression, context);
        GoExpectedTypes goExpectedTypes = defListSize > 1 ? GoExpectedTypes.create(typeList, type) : GoExpectedTypes.create(typeList);
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(89);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromAssignmentStatement(@NotNull GoExpression expression, @NotNull GoAssignmentStatement assignment, @NotNull PsiElement context) {
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(90);
        }
        if (assignment == null) {
            GoTypeUtil.$$$reportNull$$$0(91);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(92);
        }
        List<GoExpression> leftExpressions = assignment.getLeftHandExprList().getExpressionList();
        if (assignment.getExpressionList().size() == 1) {
            SmartList typeList = new SmartList();
            for (GoExpression expr : leftExpressions) {
                typeList.add(GoTypeUtil.getInterfaceIfNull(expr.getGoType(null), context));
            }
            GoType expectedType = GoTypeUtil.createGoTypeListOrGoType((List<GoType>)typeList, expression, context);
            GoExpectedTypes goExpectedTypes = leftExpressions.size() <= 1 ? GoExpectedTypes.create(expectedType) : GoExpectedTypes.create(expectedType, GoTypeUtil.getGoType(leftExpressions.get(0), context));
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(93);
            }
            return goExpectedTypes;
        }
        int position = assignment.getExpressionList().indexOf(expression);
        GoType leftExpression = leftExpressions.size() > position ? leftExpressions.get(position).getGoType(null) : null;
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(leftExpression, context);
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(94);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoExpectedTypes getExpectedTypesFromAssignmentLHS(@NotNull GoExpression expression, @NotNull GoLeftHandExprList lhsExprList, @NotNull PsiElement context) {
        GoExpression goExpression;
        GoAssignmentStatement assignment;
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(95);
        }
        if (lhsExprList == null) {
            GoTypeUtil.$$$reportNull$$$0(96);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(97);
        }
        if ((assignment = (GoAssignmentStatement)ObjectUtils.tryCast((Object)lhsExprList.getParent(), GoAssignmentStatement.class)) == null) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(98);
            }
            return goExpectedTypes;
        }
        List<GoExpression> lhsExpressions = lhsExprList.getExpressionList();
        int index = lhsExpressions.indexOf(expression);
        if (index < 0) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(99);
            }
            return goExpectedTypes;
        }
        List<GoExpression> rhsExpressions = assignment.getExpressionList();
        if (rhsExpressions.size() == lhsExpressions.size()) {
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(rhsExpressions.get(index).getGoType(null), context);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(100);
            }
            return goExpectedTypes;
        }
        if (rhsExpressions.size() == 1 && (goExpression = rhsExpressions.get(0)) instanceof GoCallExpr) {
            GoCallExpr call = (GoCallExpr)goExpression;
            GoFunctionType funcType = (GoFunctionType)ObjectUtils.tryCast((Object)call.getExpression().getGoType(null), GoFunctionType.class);
            GoResult result = funcType != null ? funcType.getResult() : null;
            GoParameters params = result != null ? result.getParameters() : null;
            GoExpectedTypes goExpectedTypes = GoExpectedTypes.createWithContext(params != null ? params.getTypeByIndex(index) : null, context);
            if (goExpectedTypes == null) {
                GoTypeUtil.$$$reportNull$$$0(101);
            }
            return goExpectedTypes;
        }
        GoExpectedTypes goExpectedTypes = GoExpectedTypes.EMPTY;
        if (goExpectedTypes == null) {
            GoTypeUtil.$$$reportNull$$$0(102);
        }
        return goExpectedTypes;
    }

    @NotNull
    private static GoType createGoTypeListOrGoType(@NotNull List<GoType> types, @NotNull PsiElement expression, @NotNull PsiElement context) {
        if (types == null) {
            GoTypeUtil.$$$reportNull$$$0(103);
        }
        if (expression == null) {
            GoTypeUtil.$$$reportNull$$$0(104);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(105);
        }
        return types.size() < 2 ? GoTypeUtil.getInterfaceIfNull((GoType)ContainerUtil.getFirstItem(types), context) : new GoLightType.LightTypeList(expression, types);
    }

    @NotNull
    public static GoType getInterfaceIfNull(@Nullable GoType type, @NotNull PsiElement context) {
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(106);
        }
        GoType goType = type == null ? GoTypeUtil.getInterfaceType(context) : type;
        if (goType == null) {
            GoTypeUtil.$$$reportNull$$$0(107);
        }
        return goType;
    }

    @NotNull
    private static GoType getInterfaceType(@NotNull PsiElement context) {
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(108);
        }
        GoType goType = GoElementFactory.createTypeCheap(context.getProject(), "interface{}");
        if (goType == null) {
            GoTypeUtil.$$$reportNull$$$0(109);
        }
        return goType;
    }

    @NotNull
    private static GoType getGoType(@Nullable GoTypeOwner element, @NotNull PsiElement context) {
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(110);
        }
        return GoTypeUtil.getInterfaceIfNull(element != null ? element.getGoType(null) : null, context);
    }

    @Nullable
    public static GoType getDefaultType(@Nullable GoType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof GoLightType.LightUntypedType) {
            return ((GoLightType.LightUntypedType)type).getDefaultType();
        }
        if (GoPsiImplUtil.builtin(type)) {
            String text = GoTypeUtil.getTypeNameOrText(type);
            if (DOC_ONLY_COMPLEX_TYPE.equals(text)) {
                return GoPsiImplUtil.getBuiltinType(COMPLEX128, type);
            }
            if (DOC_ONLY_FLOAT_TYPE.equals(text)) {
                return GoPsiImplUtil.getBuiltinType(FLOAT64, type);
            }
        }
        return type;
    }

    @NotNull
    static String getTypeNameOrText(@NotNull GoType type) {
        GoType baseType;
        String name;
        StubElement parent;
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(111);
        }
        if ((parent = (StubElement)ObjectUtils.doIfNotNull((Object)((GoTypeStub)type.getStub()), StubBase::getParentStub)) != null && !(parent instanceof GoTypeSpecStub)) {
            parent = parent.getParentStub();
        }
        if (parent instanceof GoTypeSpecStub && (name = ((GoTypeSpecStub)parent).getSpecTypeName()) != null) {
            String string = name;
            if (string == null) {
                GoTypeUtil.$$$reportNull$$$0(112);
            }
            return string;
        }
        if (type instanceof GoPointerType && (baseType = ((GoPointerType)type).getType()) != null) {
            String string = "*" + GoTypeUtil.getTypeNameOrText(baseType);
            if (string == null) {
                GoTypeUtil.$$$reportNull$$$0(113);
            }
            return string;
        }
        String string = type.getText();
        if (string == null) {
            GoTypeUtil.$$$reportNull$$$0(114);
        }
        return string;
    }

    public static boolean isAssignable(@Nullable GoType type, @Nullable GoTypeOwner value, boolean strict) {
        return GoTypeUtil.checkAssignable(type, value, strict) instanceof GoTypesCompatible;
    }

    public static boolean isAssignable(@Nullable GoType type, @Nullable GoTypeOwner value, @Nullable GoType valueType, boolean strict) {
        return GoTypeUtil.checkAssignable(type, value, valueType, strict) instanceof GoTypesCompatible;
    }

    public static boolean isAssignable(@Nullable GoType type, @Nullable GoTypeOwner value, @Nullable GoType valueType, @Nullable PsiElement context, boolean strict) {
        return GoTypeUtil.checkAssignable(type, value, valueType, context, strict) instanceof GoTypesCompatible;
    }

    @NotNull
    public static GoTypeCheckResult checkAssignable(@Nullable GoType type, @Nullable GoTypeOwner value, boolean strict) {
        GoType valueType = value != null ? value.getGoType(null) : null;
        return GoTypeUtil.checkAssignable(type, value, valueType, strict);
    }

    @NotNull
    public static GoTypeCheckResult checkAssignable(@Nullable GoType type, @Nullable GoTypeOwner value, @Nullable GoType valueType, boolean strict) {
        PsiElement context = (PsiElement)ObjectUtils.doIfNotNull((Object)value, GoReferenceBase::getSubstitutionContextOrSelf);
        return GoTypeUtil.checkAssignable(type, value, valueType, context, strict);
    }

    @NotNull
    public static GoTypeCheckResult checkAssignable(@Nullable GoType type, @Nullable GoTypeOwner value, @Nullable GoType valueType, @Nullable PsiElement context, boolean strict) {
        GoType valueUnderlyingType;
        GoType underlyingType;
        if (type == null) {
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(!strict);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(115);
            }
            return goTypeCheckResult;
        }
        if (GoExpressionUtil.isNil(value)) {
            if (GoTypeUtil.isTypeParameter(type, context)) {
                return GoTypeUtil.typeSetIs(type, context, (GoType t) -> GoTypeUtil.isAssignable(t, value, valueType, context, strict)) ? new GoTypesCompatible() : new GoCannotBeNil();
            }
            return GoTypeUtil.isAllowedComparingToNil(type, context) ? new GoTypesCompatible() : new GoCannotBeNil();
        }
        if (valueType == null) {
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(!strict);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(116);
            }
            return goTypeCheckResult;
        }
        if (valueType instanceof GoLightType.LightUntypedType && GoTypeUtil.isConstant(value)) {
            ThreeState representable = GoInvalidExpressionConversionInspection.isRepresentable(value, valueType, type, strict, context);
            if (representable == ThreeState.UNSURE) {
                GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(!strict);
                if (goTypeCheckResult == null) {
                    GoTypeUtil.$$$reportNull$$$0(117);
                }
                return goTypeCheckResult;
            }
            return representable.toBoolean() ? new GoTypesCompatible() : new GoNotRepresentable();
        }
        if (GoTypeUtil.isTypeParameter(type, context) && !GoTypeUtil.isNamedType(valueType) && GoTypeUtil.matchTypeConstraints(underlyingType = type.getUnderlyingType(context), context, (GoType t) -> GoTypeUtil.isAssignable(t, value, valueType, context, strict))) {
            return new GoTypesCompatible();
        }
        if (GoTypeUtil.isTypeParameter(valueType, context) && !GoTypeUtil.isNamedType(type) && GoTypeUtil.matchTypeConstraints(valueUnderlyingType = valueType.getUnderlyingType(context), context, (GoType t) -> GoTypeUtil.isAssignable(type, null, t, context, strict))) {
            return new GoTypesCompatible();
        }
        return GoTypeUtil.checkAssignable(type, valueType, context, strict);
    }

    private static boolean isConstant(@Nullable GoTypeOwner value) {
        return value instanceof GoExpression && ((GoExpression)value).isConstant() || value instanceof GoConstDefinition;
    }

    @NotNull
    private static GoTypeCheckResult checkAssignable(@NotNull GoType left, @Nullable GoType right, @Nullable PsiElement context, boolean strict) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(118);
        }
        if (right == null) {
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(!strict);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(119);
            }
            return goTypeCheckResult;
        }
        if (left == right || left.equals(right)) {
            return new GoTypesCompatible();
        }
        if (GoTypeUtil.isDocOnlyAnyType(left, context)) {
            return new GoTypesCompatible();
        }
        if (GoTypeUtil.isArbitraryType(left, context)) {
            return new GoTypesCompatible();
        }
        if (GoTypeUtil.identical(left, right, strict, context)) {
            return new GoTypesCompatible();
        }
        GoType underlyingLeft = left.getUnderlyingType(context);
        if (right instanceof GoLightType.LightUntypedNumericType && GoTypeUtil.isNumericType(underlyingLeft, context)) {
            return new GoTypesCompatible();
        }
        if (right instanceof GoLightType.LightUntypedStringType && GoTypeUtil.isString(underlyingLeft, context)) {
            return new GoTypesCompatible();
        }
        if (right instanceof GoLightType.LightUntypedBoolType && GoTypeUtil.isBoolean(underlyingLeft, context)) {
            return new GoTypesCompatible();
        }
        GoType underlyingRight = right.getUnderlyingType(context);
        if (!(!GoTypeUtil.identical(underlyingLeft, underlyingRight, strict, context) || GoTypeUtil.isDefinedTypeModuloAlias(left, !strict, context) && GoTypeUtil.isDefinedTypeModuloAlias(right, !strict, context))) {
            return new GoTypesCompatible();
        }
        if (underlyingLeft instanceof GoInterfaceType && !GoTypeUtil.isTypeParameter(left, context)) {
            GoTypeCheckResult result = GoTypeUtil.checkImplementsInterface(underlyingLeft, right, strict, context);
            GoTypeCheckResult goTypeCheckResult = GoTypeUtil.addInterfaceProblemInfo(result, left, right);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(120);
            }
            return goTypeCheckResult;
        }
        GoChannelType leftChannel = (GoChannelType)ObjectUtils.tryCast((Object)underlyingLeft, GoChannelType.class);
        if (leftChannel != null) {
            GoChannelType rightChannel = (GoChannelType)ObjectUtils.tryCast((Object)underlyingRight, GoChannelType.class);
            if (rightChannel == null || GoTypeUtil.isDefinedTypeModuloAlias(left, !strict, context) && GoTypeUtil.isDefinedTypeModuloAlias(right, !strict, context)) {
                return new GoTypesNotCompatible();
            }
            GoPsiImplUtil.ChannelDirection rightChannelDirection = rightChannel.getDirection();
            if (rightChannelDirection != GoPsiImplUtil.ChannelDirection.BIDIRECTIONAL && rightChannelDirection != leftChannel.getDirection()) {
                return new GoTypesNotCompatible();
            }
            GoType leftChannelType = leftChannel.getType();
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(GoTypeUtil.isDocOnlyAnyType(leftChannelType, context) || GoTypeUtil.identical(leftChannelType, rightChannel.getType(), strict, context));
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(121);
            }
            return goTypeCheckResult;
        }
        return new GoTypesNotCompatible();
    }

    private static boolean isDefinedTypeModuloAlias(@Nullable GoType type, boolean strict, @Nullable PsiElement context) {
        if (!GoTypeUtil.isNamedType(type)) {
            return false;
        }
        if (GoTypeUtil.isTypeParameter(type, context)) {
            return true;
        }
        GoType aliasedType = GoTypeUtil.unwrapAliasIfNamed(type, context);
        return aliasedType != null ? GoTypeUtil.isNamedType(aliasedType) : !strict;
    }

    @Nullable
    public static GoType unwrapAliasIfNamed(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(122);
        }
        return GoPsiUtil.unwrapAlias(GoTypeUtil.findTypeSpec(type, context));
    }

    @NotNull
    public static GoType unwrapAlias(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(123);
        }
        GoType goType = (GoType)ObjectUtils.notNull((Object)GoTypeUtil.unwrapAliasIfNamed(type, context), (Object)type);
        if (goType == null) {
            GoTypeUtil.$$$reportNull$$$0(124);
        }
        return goType;
    }

    @Contract(value="null, _ -> null")
    public static GoTypeSpec findTypeSpec(@Nullable GoType type, @Nullable PsiElement context) {
        return (GoTypeSpec)ObjectUtils.tryCast((Object)GoTypeUtil.resolveNamedType(type, context), GoTypeSpec.class);
    }

    @Nullable
    public static GoTypeSpec findTypeSpec(@Nullable GoType type, @Nullable PsiElement context, boolean unwrapPointer) {
        GoType unwrapped = unwrapPointer ? GoPsiImplUtil.unwrapPointerIfNeeded(type) : type;
        return GoTypeUtil.findTypeSpec(unwrapped, context);
    }

    @Contract(value="null, _ -> null")
    public static GoNamedElement resolveNamedType(@Nullable GoType type, @Nullable PsiElement context) {
        if (type == null) {
            return null;
        }
        if (type instanceof GoSpecType) {
            GoSpecType specType = (GoSpecType)type;
            return specType.getTypeSpec();
        }
        if (type instanceof GoTypeParameter) {
            GoTypeParameter typeParameter = (GoTypeParameter)type;
            return typeParameter.getTypeParamDefinition();
        }
        GoTypeParamDefinition receiverTypeParam = GoPsiUtil.getReceiverTypeParamDefinition(type);
        if (receiverTypeParam != null) {
            return receiverTypeParam;
        }
        return (GoNamedElement)ObjectUtils.tryCast((Object)type.resolve(context), GoNamedElement.class);
    }

    public static boolean identical(@Nullable GoType left, @Nullable GoType right, @Nullable PsiElement context) {
        return GoTypeUtil.identical(left, right, false, false, context);
    }

    public static boolean identical(@Nullable GoType leftType, @Nullable GoType rightType, boolean strict, @Nullable PsiElement context) {
        return GoTypeUtil.identical(leftType, rightType, strict, false, context);
    }

    public static boolean identical(@Nullable GoType leftType, @Nullable GoType rightType, boolean strict, boolean forceIgnoreStructTags, @Nullable PsiElement context) {
        return GoPsiImplUtil.withContextOnElement(context, state -> {
            GoIdenticalTypesMatcher matcher = new GoIdenticalTypesMatcher(strict, forceIgnoreStructTags, false, (ResolveState)state);
            return matcher.match(leftType, rightType);
        });
    }

    public static boolean sameNamedTypes(@NotNull GoType l, @NotNull GoType r, @Nullable GoNamedElement lResolve, @Nullable GoNamedElement rResolve, boolean strict, @Nullable PsiElement context, @NotNull BiPredicate<GoType, GoType> predicate) {
        if (l == null) {
            GoTypeUtil.$$$reportNull$$$0(125);
        }
        if (r == null) {
            GoTypeUtil.$$$reportNull$$$0(126);
        }
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(127);
        }
        if (!GoTypeUtil.isNamedType(l) || !GoTypeUtil.isNamedType(r)) {
            return false;
        }
        if (lResolve == null || rResolve == null) {
            return !strict;
        }
        if (!lResolve.isEquivalentTo(rResolve) && !GoTypeUtil.areEquivalentTypeParams(lResolve, rResolve, null, context)) {
            return false;
        }
        Map<GoTypeParamDefinition, GoTypeArgument> leftTypeArguments = GoTypeInstantiationKt.getExplicitParamSubstitutionMap(l, context);
        Map<GoTypeParamDefinition, GoTypeArgument> rightTypeArguments = GoTypeInstantiationKt.getExplicitParamSubstitutionMap(r, context);
        return GoTypeUtil.sameTypeArguments(leftTypeArguments, rightTypeArguments, predicate);
    }

    private static boolean sameTypeArguments(@NotNull Map<GoTypeParamDefinition, GoTypeArgument> leftTypeArguments, @NotNull Map<GoTypeParamDefinition, GoTypeArgument> rightTypeArguments, @NotNull BiPredicate<GoType, GoType> predicate) {
        if (leftTypeArguments == null) {
            GoTypeUtil.$$$reportNull$$$0(128);
        }
        if (rightTypeArguments == null) {
            GoTypeUtil.$$$reportNull$$$0(129);
        }
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(130);
        }
        if (leftTypeArguments.size() != rightTypeArguments.size()) {
            return false;
        }
        for (Map.Entry<GoTypeParamDefinition, GoTypeArgument> entry : leftTypeArguments.entrySet()) {
            GoType leftType = entry.getValue().getType();
            GoTypeArgument rightTypeArgument = rightTypeArguments.get(entry.getKey());
            if (rightTypeArgument == null) {
                return false;
            }
            GoType rightType = rightTypeArgument.getType();
            if (predicate.test(leftType, rightType)) continue;
            return false;
        }
        return true;
    }

    public static boolean areEquivalentTypeParams(@NotNull GoNamedElement left, @NotNull GoNamedElement right, @Nullable ResolveState state, @Nullable PsiElement context) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(131);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(132);
        }
        if (!(left instanceof GoTypeParamDefinition) || !(right instanceof GoTypeParamDefinition)) {
            return false;
        }
        GoType lRecvTypeArg = GoPsiUtil.getReceiverTypeArg(left);
        GoTypeParamDefinition leftTypeParam = lRecvTypeArg != null ? GoPsiImplUtil.getReceiverTypeParam(lRecvTypeArg, state, context) : (GoTypeParamDefinition)left;
        GoType rRecvTypeArg = GoPsiUtil.getReceiverTypeArg(right);
        GoTypeParamDefinition rightTypeParam = rRecvTypeArg != null ? GoPsiImplUtil.getReceiverTypeParam(rRecvTypeArg, state, context) : (GoTypeParamDefinition)right;
        return leftTypeParam != null && rightTypeParam != null && leftTypeParam.isEquivalentTo(rightTypeParam);
    }

    public static boolean sameBuiltinIntegerAliases(@NotNull GoType left, @NotNull GoType right, @Nullable PsiElement context) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(133);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(134);
        }
        if (!GoTypeUtil.isBuiltinType(left, context) || !GoTypeUtil.isBuiltinType(right, context)) {
            return false;
        }
        String l = GoTypeUtil.getTypeNameOrText(left);
        String r = GoTypeUtil.getTypeNameOrText(right);
        return INT32_ALIAS.contains(l) && INT32_ALIAS.contains(r) || UINT8_ALIAS.contains(l) && UINT8_ALIAS.contains(r);
    }

    public static boolean sameInterfaces(@NotNull GoInterfaceType left, @NotNull GoInterfaceType right, @Nullable PsiElement context, @NotNull BiPredicate<GoType, GoType> predicate) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(135);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(136);
        }
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(137);
        }
        List leftMethods = ContainerUtil.sorted(left.getAllMethods(context), BY_NAME);
        List rightMethods = ContainerUtil.sorted(right.getAllMethods(context), BY_NAME);
        if (leftMethods.size() != rightMethods.size()) {
            return false;
        }
        NotNullLazyValue<Boolean> samePackages = GoTypeUtil.isSamePackages(left, right);
        for (int i = 0; i < leftMethods.size(); ++i) {
            GoMethodSpec rightMethod;
            GoMethodSpec leftMethod = (GoMethodSpec)leftMethods.get(i);
            if (!GoTypeUtil.sameNames(leftMethod, rightMethod = (GoMethodSpec)rightMethods.get(i), samePackages)) {
                return false;
            }
            if (GoTypeUtil.sameSignatures(leftMethod.getSignature(), rightMethod.getSignature(), predicate)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static NotNullLazyValue<Boolean> isSamePackages(@NotNull PsiElement left, @NotNull PsiElement right) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(138);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(139);
        }
        NotNullLazyValue notNullLazyValue = NotNullLazyValue.createValue(() -> {
            PsiElement leftContext = GoReferenceBase.getSubstitutionContextOrSelf(left);
            PsiElement rightContext = GoReferenceBase.getSubstitutionContextOrSelf(right);
            return GoUtil.inSamePackage(leftContext.getContainingFile(), rightContext.getContainingFile(), true);
        });
        if (notNullLazyValue == null) {
            GoTypeUtil.$$$reportNull$$$0(140);
        }
        return notNullLazyValue;
    }

    private static boolean sameNames(@NotNull GoNamedElement left, @NotNull GoNamedElement right, @NotNull NotNullLazyValue<Boolean> inSamePackages) {
        String name;
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(141);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(142);
        }
        if (inSamePackages == null) {
            GoTypeUtil.$$$reportNull$$$0(143);
        }
        if (!Objects.equals(name = left.getName(), right.getName())) {
            return false;
        }
        if (name == null) {
            return false;
        }
        return left.isPublic() || (Boolean)inSamePackages.getValue() != false;
    }

    public static boolean sameStructs(@NotNull GoStructType left, @NotNull GoStructType right, boolean checkTags, @NotNull BiPredicate<GoType, GoType> predicate) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(144);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(145);
        }
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(146);
        }
        List<GoNamedElement> l = left.getFieldDefinitions();
        List<GoNamedElement> r = right.getFieldDefinitions();
        if (l.size() != r.size()) {
            return false;
        }
        NotNullLazyValue<Boolean> samePackages = GoTypeUtil.isSamePackages(left, right);
        for (int i = 0; i < l.size(); ++i) {
            GoNamedElement s;
            GoNamedElement f = l.get(i);
            if (!GoTypeUtil.sameNames(f, s = r.get(i), samePackages)) {
                return false;
            }
            if (f instanceof GoFieldDefinition && !(s instanceof GoFieldDefinition)) {
                return false;
            }
            if (f instanceof GoAnonymousFieldDefinition && !(s instanceof GoAnonymousFieldDefinition)) {
                return false;
            }
            if (!predicate.test(f.getGoType(null), s.getGoType(null))) {
                return false;
            }
            if (!checkTags || Objects.equals(GoTypeUtil.getTagForFieldDefinition(f), GoTypeUtil.getTagForFieldDefinition(s))) continue;
            return false;
        }
        return true;
    }

    private static String getTagForFieldDefinition(@Nullable GoNamedElement definition) {
        GoFieldDeclaration declaration = (GoFieldDeclaration)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)definition, GoFieldDeclaration.class);
        return GoStringUtil.unescapeStringLiteralText(declaration == null ? null : declaration.getTagText());
    }

    @Contract(value="null -> false")
    public static boolean isNamedType(@Nullable GoType type) {
        return type != null && !(type instanceof GoArrayOrSliceType) && !(type instanceof GoStructType) && !(type instanceof GoPointerType) && !(type instanceof GoFunctionType) && !(type instanceof GoInterfaceType) && !(type instanceof GoMapType) && !(type instanceof GoChannelType) && !(type instanceof GoTypeList) && !(type instanceof GoCType) && !(type instanceof GoLightType.LightVoidType);
    }

    public static boolean isImplementsInterface(@NotNull GoType interfaceType, @NotNull GoType type, boolean strict, @Nullable PsiElement context) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(147);
        }
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(148);
        }
        return GoTypeUtil.isImplementsInterface(interfaceType, type, strict, true, context);
    }

    public static boolean isImplementsInterface(@NotNull GoType interfaceType, @NotNull GoType type, boolean strict, boolean checkPointers, @Nullable PsiElement context) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(149);
        }
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(150);
        }
        return GoTypeUtil.isImplementsInterface(interfaceType, type, strict, checkPointers, false, context);
    }

    public static boolean isImplementsInterface(@NotNull GoType interfaceType, @NotNull GoType type, boolean strict, boolean checkPointers, boolean checkPossibleIdentity, @Nullable PsiElement context) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(151);
        }
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(152);
        }
        return GoTypeUtil.checkImplementsInterface(interfaceType, type, strict, checkPointers, checkPossibleIdentity, context) instanceof GoTypesCompatible;
    }

    @NotNull
    public static GoTypeCheckResult checkImplementsConstraint(@NotNull GoType constraintType, @NotNull GoType valueType, @Nullable PsiElement context, boolean strict) {
        boolean wantComparable;
        GoTypeCheckResult result;
        ResolveState state;
        GoType valueUnderlyingType;
        GoTypeSet valueTypeSet;
        if (constraintType == null) {
            GoTypeUtil.$$$reportNull$$$0(153);
        }
        if (valueType == null) {
            GoTypeUtil.$$$reportNull$$$0(154);
        }
        if ((valueTypeSet = GoTypeSetKt.computeTypeSet(valueUnderlyingType = valueType.getUnderlyingType(state = GoPsiImplUtil.createContextOnElement(context)), state)) == GoTypeSet.Empty.INSTANCE) {
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(true);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(155);
            }
            return goTypeCheckResult;
        }
        GoType constraintUnderlyingType = GoPsiImplUtil.getUnderlyingType(constraintType, state);
        GoInterfaceType constraintInterface = (GoInterfaceType)ObjectUtils.tryCast((Object)constraintUnderlyingType, GoInterfaceType.class);
        if (constraintInterface != null && (result = GoTypeUtil.checkImplementsInterface(constraintUnderlyingType, valueType, strict, context)) instanceof GoTypesNotCompatible) {
            GoTypeCheckResult goTypeCheckResult = GoTypeUtil.addInterfaceProblemInfo(result, constraintType, valueType);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(156);
            }
            return goTypeCheckResult;
        }
        GoTypeSet constraintTypeSet = GoTypeSetKt.computeTypeSet(constraintUnderlyingType, state);
        boolean bl = wantComparable = constraintTypeSet == GoTypeSet.Comparable.INSTANCE || GoTypeUtil.isBuiltinComparable(constraintUnderlyingType, context);
        if (wantComparable) {
            GoTypeCheckResult goTypeCheckResult = GoTypeUtil.addInterfaceProblemInfo(GoTypeUtil.checkSatisfiesComparable(valueType, context, strict), constraintType, valueType);
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(157);
            }
            return goTypeCheckResult;
        }
        if (constraintInterface == null) {
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(GoTypeUtil.identical(constraintType, valueType, strict, context));
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(158);
            }
            return goTypeCheckResult;
        }
        GoTypeCheckResult goTypeCheckResult = GoTypeUtil.addInterfaceProblemInfo(GoTypeUtil.checkConstraintIncludesType(state, constraintTypeSet, valueType, valueUnderlyingType, valueTypeSet, strict), constraintType, valueType);
        if (goTypeCheckResult == null) {
            GoTypeUtil.$$$reportNull$$$0(159);
        }
        return goTypeCheckResult;
    }

    @Contract(value="null, _, _ -> null")
    private static GoTypeCheckResult addInterfaceProblemInfo(@Nullable GoTypeCheckResult result, @Nullable GoType interfaceType, @Nullable GoType valueType) {
        if (result instanceof GoDoesNotImplementInterface) {
            ((GoDoesNotImplementInterface)result).setInterfaceType(interfaceType);
            ((GoDoesNotImplementInterface)result).setType(valueType);
        }
        return result;
    }

    @NotNull
    private static GoTypeCheckResult checkImplementsInterface(@NotNull GoType interfaceType, @NotNull GoType type, boolean strict, @Nullable PsiElement context) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(160);
        }
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(161);
        }
        return GoTypeUtil.checkImplementsInterface(interfaceType, type, strict, true, false, context);
    }

    @NotNull
    private static GoTypeCheckResult checkImplementsInterface(@NotNull GoType interfaceType, @NotNull GoType type, boolean strict, boolean checkPointers, boolean checkPossibleIdentity, @Nullable PsiElement context) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(162);
        }
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(163);
        }
        BiPredicate<GoSignature, GoSignature> signaturesMatcher = GoTypeUtil.getSignaturesMatcher(checkPossibleIdentity, strict, context);
        return GoTypeUtil.checkImplementsInterface(interfaceType, type, checkPointers, context, signaturesMatcher);
    }

    @NotNull
    public static GoTypeCheckResult checkImplementsInterface(@NotNull GoType interfaceType, @NotNull GoType type, boolean checkPointers, @Nullable PsiElement context, @NotNull BiPredicate<GoSignature, GoSignature> signaturesMatcher) {
        boolean bl;
        GoInterfaceType unwrappedInterfaceType;
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(164);
        }
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(165);
        }
        if (signaturesMatcher == null) {
            GoTypeUtil.$$$reportNull$$$0(166);
        }
        if ((unwrappedInterfaceType = (GoInterfaceType)ObjectUtils.tryCast((Object)interfaceType, GoInterfaceType.class)) == null) {
            return new GoTypesNotCompatible();
        }
        List<GoElementWithSubst<GoMethodSpec>> interfaceMethods = GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(unwrappedInterfaceType, interfaceType, context);
        if (interfaceMethods.isEmpty()) {
            return new GoTypesCompatible();
        }
        GoType unwrappedType = GoTypeUtil.unwrapAlias(type, context);
        if (GoTypeUtil.isPointerToInterface(unwrappedType, context)) {
            return new GoTypesNotCompatible();
        }
        boolean ambiguityPossible = false;
        HashMap<GoUniqueIdentifier, Object> implementedMethodsMap = new HashMap<GoUniqueIdentifier, Object>();
        for (GoElementWithSubst<? extends GoNamedSignatureOwner> implementedMethod : GoTypeUtil.findImplementedMethodsWithSubstitutionSource(type, context)) {
            GoUniqueIdentifier goUniqueIdentifier;
            if (!implementedMethod.getElement().isValid() || (goUniqueIdentifier = GoUniqueIdentifier.Companion.of((GoNamedElement)implementedMethod.getElement(), context, true)) == null) continue;
            ambiguityPossible |= implementedMethodsMap.putIfAbsent(goUniqueIdentifier, implementedMethod) != null;
        }
        LinkedHashMap<GoElementWithSubst, GoUniqueIdentifier> interfaceMethodsMap = new LinkedHashMap<GoElementWithSubst, GoUniqueIdentifier>();
        for (GoElementWithSubst goElementWithSubst : interfaceMethods) {
            GoUniqueIdentifier identifier3 = GoUniqueIdentifier.Companion.of((GoNamedElement)goElementWithSubst.getElement(), context, true);
            if (identifier3 == null) {
                return new GoTypesNotCompatible();
            }
            interfaceMethodsMap.put(goElementWithSubst, identifier3);
        }
        SmartList missingMethods = new SmartList();
        for (GoElementWithSubst interfaceMethod : interfaceMethodsMap.keySet()) {
            GoUniqueIdentifier identifier4 = (GoUniqueIdentifier)interfaceMethodsMap.get(interfaceMethod);
            if (implementedMethodsMap.containsKey(identifier4)) continue;
            missingMethods.add((GoMethodSpec)interfaceMethod.getElement());
        }
        if (!missingMethods.isEmpty()) {
            Set implementedMethodNames;
            List list = ContainerUtil.filter((Collection)missingMethods, m -> !m.isPublic());
            if (!list.isEmpty() && ContainerUtil.exists((Iterable)list, arg_0 -> GoTypeUtil.lambda$checkImplementsInterface$20(implementedMethodNames = ContainerUtil.map2Set(implementedMethodsMap.keySet(), GoUniqueIdentifier::getName), arg_0))) {
                return new GoInterfaceWithNonExportedMethodInDifferentPackage();
            }
            return new GoMethodsMissing((List<GoMethodSpec>)missingMethods);
        }
        boolean bl2 = bl = !(unwrappedType instanceof GoPointerType);
        if (ambiguityPossible) {
            HashMap<String, GoElementWithSubst<GoMethodSpec>> interfaceMethodNamesMap = new HashMap<String, GoElementWithSubst<GoMethodSpec>>();
            interfaceMethodsMap.forEach((method, identifier) -> interfaceMethodNamesMap.putIfAbsent(identifier.getName(), (GoElementWithSubst<GoMethodSpec>)method));
            return GoTypeUtil.checkAmbiguousMethods(checkPointers, bl, signaturesMatcher, interfaceType, type, interfaceMethodNamesMap, context);
        }
        for (GoElementWithSubst interfaceMethod : interfaceMethodsMap.keySet()) {
            GoUniqueIdentifier identifier5 = (GoUniqueIdentifier)interfaceMethodsMap.get(interfaceMethod);
            GoElementWithSubst implementedMethod = (GoElementWithSubst)implementedMethodsMap.get(identifier5);
            GoType interfaceSubstitutionSource = (GoType)ObjectUtils.notNull((Object)interfaceMethod.getSubstitutionSource(), (Object)interfaceType);
            GoType implementationSubstitutionSource = (GoType)ObjectUtils.notNull((Object)implementedMethod.getSubstitutionSource(), (Object)type);
            GoTypeCheckResult result = GoTypeUtil.checkMethod(checkPointers, bl, signaturesMatcher, (GoMethodSpec)interfaceMethod.getElement(), interfaceSubstitutionSource, (GoNamedSignatureOwner)implementedMethod.getElement(), implementationSubstitutionSource);
            if (!(result instanceof GoTypesNotCompatible)) continue;
            GoTypeCheckResult goTypeCheckResult = result;
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(167);
            }
            return goTypeCheckResult;
        }
        return new GoTypesCompatible();
    }

    @NotNull
    private static BiPredicate<GoSignature, GoSignature> getSignaturesMatcher(boolean checkPossibleIdentity, boolean strict, @Nullable PsiElement context) {
        if (checkPossibleIdentity) {
            GoPossiblyIdenticalTypesMatcher matcher = new GoPossiblyIdenticalTypesMatcher(strict, GoPsiImplUtil.createContextOnElement(context));
            BiPredicate<GoSignature, GoSignature> biPredicate = (s1, s2) -> GoTypeUtil.sameSignatures(s1, s2, matcher::match);
            if (biPredicate == null) {
                GoTypeUtil.$$$reportNull$$$0(168);
            }
            return biPredicate;
        }
        BiPredicate<GoSignature, GoSignature> biPredicate = (s1, s2) -> GoTypeUtil.sameSignatures(s1, s2, (l, r) -> GoTypeUtil.identical(l, r, strict, false, context));
        if (biPredicate == null) {
            GoTypeUtil.$$$reportNull$$$0(169);
        }
        return biPredicate;
    }

    @NotNull
    private static GoTypeCheckResult checkMethod(boolean checkPointers, boolean isNotPointer, @NotNull BiPredicate<GoSignature, GoSignature> signaturesMatcher, @NotNull GoMethodSpec interfaceMethod, @NotNull GoType interfaceSubstitutionSource, @NotNull GoNamedSignatureOwner implementedMethod, @NotNull GoType implementationSubstitutionSource) {
        if (signaturesMatcher == null) {
            GoTypeUtil.$$$reportNull$$$0(170);
        }
        if (interfaceMethod == null) {
            GoTypeUtil.$$$reportNull$$$0(171);
        }
        if (interfaceSubstitutionSource == null) {
            GoTypeUtil.$$$reportNull$$$0(172);
        }
        if (implementedMethod == null) {
            GoTypeUtil.$$$reportNull$$$0(173);
        }
        if (implementationSubstitutionSource == null) {
            GoTypeUtil.$$$reportNull$$$0(174);
        }
        GoSignature interfaceMethodSignature = interfaceMethod.getSignature(interfaceSubstitutionSource);
        GoSignature implementedMethodSignature = implementedMethod.getSignature(implementationSubstitutionSource);
        if (checkPointers && isNotPointer && GoTypeUtil.cannotCallOnNonPointer(implementedMethod) || !signaturesMatcher.test(interfaceMethodSignature, implementedMethodSignature)) {
            GoMethodDeclaration implementation = (GoMethodDeclaration)ObjectUtils.tryCast((Object)implementedMethod, GoMethodDeclaration.class);
            if (implementation == null) {
                return new GoMethodsMissing(Collections.singletonList(interfaceMethod));
            }
            if (checkPointers && isNotPointer && GoTypeUtil.cannotCallOnNonPointer(implementation)) {
                return new GoCannotUsePointerReceiverMethod(implementation);
            }
            return new GoSignatureDiffers(interfaceMethod, implementation);
        }
        return new GoTypesCompatible();
    }

    private static boolean isPointerToInterface(@NotNull GoType type, @Nullable PsiElement context) {
        GoType pointerType;
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(175);
        }
        if ((pointerType = (GoType)ObjectUtils.tryCast((Object)type, GoPointerType.class)) == null) {
            return false;
        }
        GoType basePointerType = GoTypeUtil.getBasePointerType(type, context);
        GoType underlying = basePointerType != null ? basePointerType.getUnderlyingType(context) : null;
        return underlying instanceof GoInterfaceType;
    }

    private static <T> T processMethodsByLevel(@NotNull GoType initialType, @Nullable PsiElement context, @NotNull ByLevelMethodsProcessor<T> processor2) {
        if (initialType == null) {
            GoTypeUtil.$$$reportNull$$$0(176);
        }
        if (processor2 == null) {
            GoTypeUtil.$$$reportNull$$$0(177);
        }
        T result = null;
        SmartList currentLevelTypes = Collections.singleton(initialType);
        final class GoTypeIdentity {
            final GoType type;
            final /* synthetic */ PsiElement val$context;

            GoTypeIdentity(GoType goType) {
                this.val$context = goType;
                this.type = GoTypeUtil.unwrapPointerAndParTypes(type);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                GoTypeIdentity identity = (GoTypeIdentity)o;
                return GoTypeUtil.identical(this.type, identity.type, this.val$context);
            }

            public int hashCode() {
                GoType goType = this.type;
                if (goType instanceof GoInstantiatedType) {
                    GoInstantiatedType instantiatedType = (GoInstantiatedType)goType;
                    return ((GoType)instantiatedType.getGeneric()).hashCode();
                }
                if (this.type instanceof GoLightType) {
                    return 0;
                }
                assert (this.type instanceof GoTypeImpl);
                return this.type.hashCode();
            }
        }
        HashSet<GoTypeIdentity> visitedTypes = new HashSet<GoTypeIdentity>();
        for (int currentLevel = 0; result == null && !currentLevelTypes.isEmpty() && currentLevel < 100; ++currentLevel) {
            HashSet<GoElementWithSubst<GoNamedSignatureOwner>> currentLevelMethods = new HashSet<GoElementWithSubst<GoNamedSignatureOwner>>();
            SmartList nextLevelTypes = new SmartList();
            for (GoType type : currentLevelTypes) {
                if (!visitedTypes.add(new GoTypeIdentity(type, context))) continue;
                boolean acquirePointerSomehow = type instanceof GoLightType.LightPointerType;
                if (acquirePointerSomehow) {
                    type = ((GoLightType.LightPointerType)type).getType();
                }
                if (type instanceof GoSpecType) {
                    GoType underlyingType;
                    GoSpecType specType = (GoSpecType)type;
                    GoTypeSpec typeSpec = specType.getTypeSpec();
                    if (typeSpec != null) {
                        for (GoMethodDeclaration method : typeSpec.getMethods()) {
                            currentLevelMethods.add(GoElementWithSubst.create(acquirePointerSomehow ? GoLightMethodDeclaration.wrap(method) : method, type));
                        }
                    }
                    if ((underlyingType = type.getUnderlyingType(context)) instanceof GoInterfaceType || underlyingType instanceof GoStructType) {
                        type = underlyingType;
                    }
                }
                ResolveState resolveState = GoPsiImplUtil.createContextOnElement(context);
                if (type instanceof GoInterfaceType) {
                    for (GoMethodSpec methodSpec : ((GoInterfaceType)type).getMethodSpecList()) {
                        GoTypeArguments typeArgsElem;
                        List<Object> typeArgs;
                        GoType underSpecType;
                        GoTypeReferenceExpression reference = methodSpec.getTypeReferenceExpression();
                        if (reference == null) {
                            currentLevelMethods.add(GoElementWithSubst.create(methodSpec, type));
                            continue;
                        }
                        GoSpecType specType = (GoSpecType)ObjectUtils.doIfCast((Object)reference.resolve(resolveState), GoTypeSpec.class, GoTypeSpec::getSpecType);
                        if (specType == null || !((underSpecType = GoTypeInstantiationKt.getInstantiatedSpecType(specType, typeArgs = (typeArgsElem = methodSpec.getTypeArguments()) != null ? typeArgsElem.getTypes() : Collections.emptyList()).getUnderlyingType(context)) instanceof GoInterfaceType)) continue;
                        nextLevelTypes.add(underSpecType);
                    }
                    continue;
                }
                if (!(type instanceof GoStructType)) continue;
                for (GoAnonymousFieldDefinition field : GoPsiImplUtil.getAnonymousFieldDefinitions((GoStructType)type)) {
                    GoTypeReferenceExpression expression = field.getTypeReferenceExpression();
                    if (expression == null) continue;
                    ObjectUtils.doIfCast((Object)expression.resolve(resolveState), GoTypeSpec.class, arg_0 -> GoTypeUtil.lambda$processMethodsByLevel$25(acquirePointerSomehow, field, (Collection)nextLevelTypes, arg_0));
                }
            }
            result = processor2.process(currentLevel, currentLevelMethods);
            currentLevelTypes = nextLevelTypes;
        }
        return result;
    }

    @NotNull
    public static GoTypeCheckResult checkAmbiguousMethods(boolean checkPointers, boolean isNotPointer, BiPredicate<GoSignature, GoSignature> signaturesMatcher, @NotNull GoType interfaceType, @NotNull GoType type, @NotNull Map<String, GoElementWithSubst<GoMethodSpec>> interfaceMethodsMap, @Nullable PsiElement context) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(178);
        }
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(179);
        }
        if (interfaceMethodsMap == null) {
            GoTypeUtil.$$$reportNull$$$0(180);
        }
        HashSet previousLevelsMethodNames = new HashSet();
        PsiFile file = interfaceType.getContainingFile();
        Module module = GoUtil.module(interfaceType);
        GoTypeCheckResult result = GoTypeUtil.processMethodsByLevel(Objects.requireNonNull(GoTypeUtil.findMethodsHolder(type, context)), context, (__, currentLevelMethods) -> {
            MultiMap methods = MultiMap.create();
            for (GoElementWithSubst method : currentLevelMethods) {
                methods.putValue((Object)((GoNamedSignatureOwner)method.getElement()).getName(), (Object)method);
            }
            for (Map.Entry entry : methods.entrySet()) {
                String name = (String)entry.getKey();
                if (!interfaceMethodsMap.containsKey(name) || previousLevelsMethodNames.contains(name)) continue;
                ArrayList allowedMethods = new ArrayList();
                for (GoElementWithSubst method : (Collection)entry.getValue()) {
                    if (!GoPsiImplUtil.allowed((PsiFile)((GoNamedSignatureOwner)method.getElement()).getContainingFile(), file, module)) continue;
                    allowedMethods.add(method);
                }
                if (allowedMethods.size() > 1 && !GoPsiUtil.allowedDuplicateMethodsFromOverlappingInterfaces(allowedMethods, context)) {
                    return new GoAmbiguousMethods(ContainerUtil.map(allowedMethods, it -> (GoNamedSignatureOwner)it.getElement()));
                }
                if (allowedMethods.size() != 1) continue;
                GoElementWithSubst interfaceMethod = (GoElementWithSubst)interfaceMethodsMap.get(name);
                GoElementWithSubst implementedMethod = (GoElementWithSubst)ContainerUtil.getFirstItem(allowedMethods);
                GoTypeCheckResult checkResult = GoTypeUtil.checkMethod(checkPointers, isNotPointer, signaturesMatcher, (GoMethodSpec)interfaceMethod.getElement(), (GoType)ObjectUtils.notNull((Object)interfaceMethod.getSubstitutionSource(), (Object)interfaceType), (GoNamedSignatureOwner)implementedMethod.getElement(), (GoType)ObjectUtils.notNull((Object)implementedMethod.getSubstitutionSource(), (Object)type));
                if (!(checkResult instanceof GoTypesNotCompatible)) continue;
                return checkResult;
            }
            previousLevelsMethodNames.addAll(methods.keySet());
            return null;
        });
        return result != null ? result : new GoTypesCompatible();
    }

    private static boolean cannotCallOnNonPointer(@NotNull GoNamedSignatureOwner method) {
        GoMethodDeclaration declaration;
        if (method == null) {
            GoTypeUtil.$$$reportNull$$$0(181);
        }
        return (declaration = (GoMethodDeclaration)ObjectUtils.tryCast((Object)method, GoMethodDeclaration.class)) != null && declaration.getReceiverType() instanceof GoPointerType && !declaration.isEmbeddedByPointer();
    }

    @NotNull
    public static List<? extends GoNamedSignatureOwner> findImplementedMethods(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(182);
        }
        List list = ContainerUtil.map(GoTypeUtil.findImplementedMethodsWithSubstitutionSource(type, context), it -> (GoNamedSignatureOwner)it.getElement());
        if (list == null) {
            GoTypeUtil.$$$reportNull$$$0(183);
        }
        return list;
    }

    @NotNull
    public static List<GoElementWithSubst<? extends GoNamedSignatureOwner>> findImplementedMethodsWithSubstitutionSource(@Nullable GoType type, @Nullable PsiElement context) {
        if (type == null) {
            List<GoElementWithSubst<? extends GoNamedSignatureOwner>> list = Collections.emptyList();
            if (list == null) {
                GoTypeUtil.$$$reportNull$$$0(184);
            }
            return list;
        }
        GoType methodsHolder = GoTypeUtil.findMethodsHolder(type, context);
        if (methodsHolder instanceof GoSpecType) {
            GoSpecType specType = (GoSpecType)methodsHolder;
            List<GoElementWithSubst<? extends GoNamedSignatureOwner>> list = GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(specType, context);
            if (list == null) {
                GoTypeUtil.$$$reportNull$$$0(185);
            }
            return list;
        }
        if (methodsHolder instanceof GoInterfaceType) {
            GoInterfaceType interfaceType = (GoInterfaceType)methodsHolder;
            List<GoElementWithSubst<? extends GoNamedSignatureOwner>> methodsOfTypeSet = GoGenericsUtilKt.calcAllMethodsOfTypeSet(interfaceType, context);
            List methodSpecs = ContainerUtil.map(GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(interfaceType, methodsHolder, context), it -> GoElementWithSubst.create((GoMethodSpec)it.getElement(), it.getSubstitutionSource()));
            List list = ContainerUtil.concat(methodsOfTypeSet, (List)methodSpecs);
            if (list == null) {
                GoTypeUtil.$$$reportNull$$$0(186);
            }
            return list;
        }
        if (methodsHolder instanceof GoStructType) {
            GoStructType structType = (GoStructType)methodsHolder;
            List<GoElementWithSubst<? extends GoNamedSignatureOwner>> list = GoPsiImplUtil.calcAllMethodsWithSubstitutionSource(structType, context);
            if (list == null) {
                GoTypeUtil.$$$reportNull$$$0(187);
            }
            return list;
        }
        List<GoElementWithSubst<? extends GoNamedSignatureOwner>> list = Collections.emptyList();
        if (list == null) {
            GoTypeUtil.$$$reportNull$$$0(188);
        }
        return list;
    }

    @Nullable
    public static GoType findMethodsHolder(@NotNull GoType type, @Nullable PsiElement context) {
        GoType withoutAlias;
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(189);
        }
        if (GoTypeUtil.isPointerToInterface(type, context)) {
            return null;
        }
        GoType underlyingType = type.getUnderlyingType(context);
        if (underlyingType instanceof GoInterfaceType) {
            return underlyingType;
        }
        if ((type = GoPsiImplUtil.unwrapPointerIfNeeded(type)) instanceof GoStructType) {
            return type;
        }
        GoType goType = withoutAlias = type != null ? GoTypeUtil.unwrapAlias(type, context) : null;
        if (withoutAlias instanceof GoStructType) {
            return withoutAlias;
        }
        if (!GoTypeUtil.isNamedType(type)) {
            return null;
        }
        if (type instanceof GoSpecType) {
            return type;
        }
        PsiElement resolve = type.resolve(context);
        if (resolve instanceof GoTypeSpec) {
            GoSpecType spec = ((GoTypeSpec)resolve).getSpecType();
            return GoTypeInstantiationKt.getInstantiatedSpecType(spec, type);
        }
        return null;
    }

    public static @Unmodifiable List<? extends GoNamedSignatureOwner> getMethodSet(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(190);
        }
        List<? extends GoNamedSignatureOwner> methods = GoTypeUtil.findImplementedMethods(type, context);
        GoType unwrappedType = GoTypeUtil.unwrapAlias(type, context);
        if (unwrappedType instanceof GoPointerType) {
            return methods;
        }
        return ContainerUtil.filter(methods, method -> !GoTypeUtil.cannotCallOnNonPointer(method));
    }

    public static boolean areSignaturesIdentical(@NotNull GoSignatureOwner left, @NotNull GoSignatureOwner right, boolean strict) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(191);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(192);
        }
        return GoTypeUtil.areSignaturesIdentical(left.getSignature(), right.getSignature(), false, strict, null);
    }

    public static boolean areSignaturesIdentical(@Nullable GoSignature left, @Nullable GoSignature right, boolean checkPossibleIdentity, boolean strict, @Nullable PsiElement context) {
        return GoTypeUtil.getSignaturesMatcher(checkPossibleIdentity, strict, context).test(left, right);
    }

    public static boolean sameSignatures(@Nullable GoSignature left, @Nullable GoSignature right, @NotNull BiPredicate<GoType, GoType> predicate) {
        List<GoType> rightResultTypeList;
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(193);
        }
        if (right == null || left == null || right == left) {
            return right == left;
        }
        List<GoType> leftResultTypeList = GoTypeUtil.getListOfTypesFromTypeList(left.getResultType());
        if (!GoTypeUtil.sameTypeLists(leftResultTypeList, rightResultTypeList = GoTypeUtil.getListOfTypesFromTypeList(right.getResultType()), predicate)) {
            return false;
        }
        Pair<List<GoType>, Boolean> leftParamsTypeList = GoTypeUtil.getTypesAndIsVariadicFromParameters(left.getParameters());
        Pair<List<GoType>, Boolean> rightParamsTypeList = GoTypeUtil.getTypesAndIsVariadicFromParameters(right.getParameters());
        return ((Boolean)leftParamsTypeList.second).equals(rightParamsTypeList.second) && GoTypeUtil.sameTypeLists((List)leftParamsTypeList.first, (List)rightParamsTypeList.first, predicate);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NotNull Pair<List<@Nullable GoType>, Boolean> getTypesAndIsVariadicFromParameters(@Nullable GoParameters parameters) {
        @Nullable SmartList result = new SmartList();
        if (parameters == null) {
            Pair pair = Pair.create((Object)result, (Object)false);
            if (pair == null) {
                GoTypeUtil.$$$reportNull$$$0(194);
            }
            return pair;
        }
        for (GoParameterDeclaration parameterDecl : parameters.getParameterDeclarationList()) {
            List<GoParamDefinition> list = parameterDecl.getParamDefinitionList();
            for (GoParamDefinition p : list) {
                result.add(p.findSiblingType());
            }
            if (!list.isEmpty()) continue;
            GoType type = parameterDecl.getType();
            result.add(type);
        }
        Pair pair = Pair.create((Object)result, (Object)parameters.isVariadic());
        if (pair == null) {
            GoTypeUtil.$$$reportNull$$$0(195);
        }
        return pair;
    }

    public static boolean sameTypeLists(@NotNull List<GoType> left, @NotNull List<GoType> right, @NotNull BiPredicate<GoType, GoType> predicate) {
        if (left == null) {
            GoTypeUtil.$$$reportNull$$$0(196);
        }
        if (right == null) {
            GoTypeUtil.$$$reportNull$$$0(197);
        }
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(198);
        }
        if (left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            if (predicate.test(left.get(i), right.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isFunction(@Nullable GoType goType, @Nullable PsiElement context) {
        return goType != null && goType.getUnderlyingType(context) instanceof GoFunctionType;
    }

    @NotNull
    public static @NotNull List<@NotNull GoType> getListOfTypesFromTypeList(@Nullable GoType type) {
        if (type instanceof GoTypeList) {
            List<GoType> list = ((GoTypeList)type).getTypeList();
            if (list == null) {
                GoTypeUtil.$$$reportNull$$$0(199);
            }
            return list;
        }
        if (type instanceof GoLightType.LightVoidType) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GoTypeUtil.$$$reportNull$$$0(200);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)type);
        if (list == null) {
            GoTypeUtil.$$$reportNull$$$0(201);
        }
        return list;
    }

    public static @NotNull List<@Nullable GoType> getTypesOfExpressions(@NotNull List<? extends @Nullable GoTypeOwner> expressions, @Nullable ResolveState state) {
        if (expressions == null) {
            GoTypeUtil.$$$reportNull$$$0(202);
        }
        if (expressions.size() == 1) {
            GoTypeOwner firstExpr = expressions.get(0);
            if (firstExpr == null) {
                List<Object> list = Collections.singletonList(null);
                if (list == null) {
                    GoTypeUtil.$$$reportNull$$$0(203);
                }
                return list;
            }
            GoType firstExprType = firstExpr.getGoType(state);
            if (firstExprType instanceof GoTypeList) {
                List<GoType> list = ((GoTypeList)firstExprType).getTypeList();
                if (list == null) {
                    GoTypeUtil.$$$reportNull$$$0(204);
                }
                return list;
            }
        }
        List list = ContainerUtil.map(expressions, e -> e != null ? e.getGoType(state) : null);
        if (list == null) {
            GoTypeUtil.$$$reportNull$$$0(205);
        }
        return list;
    }

    @Contract(value="null,_,_ -> true")
    public static boolean isComparable(@Nullable GoType type, @Nullable PsiElement context, boolean strict) {
        return GoTypeUtil.isComparable(type, context, strict, true);
    }

    @Contract(value="null,_,_,_ -> true")
    public static boolean isComparable(@Nullable GoType type, @Nullable PsiElement context, boolean strict, boolean dynamic) {
        if (type == null) {
            return true;
        }
        GoType underlying = type.getUnderlyingType(context);
        if (underlying instanceof GoStructType) {
            Boolean areFieldsComparable = (Boolean)RecursionManager.doPreventingRecursion((Object)underlying, (boolean)true, () -> ContainerUtil.and(((GoStructType)underlying).getFieldDefinitions(), e -> GoTypeUtil.isComparable(e.getGoType(null), e, strict, dynamic)));
            return areFieldsComparable != null ? areFieldsComparable : !strict;
        }
        if (underlying instanceof GoArrayOrSliceType) {
            GoArrayOrSliceType arrayOrSliceType = (GoArrayOrSliceType)underlying;
            return arrayOrSliceType.isArray() && GoTypeUtil.isComparable(arrayOrSliceType.getType(), context, strict, dynamic);
        }
        if (underlying instanceof GoInterfaceType) {
            if (dynamic && !GoTypeUtil.isTypeParameter(type, context)) {
                return true;
            }
            GoTypeSet typeSet = GoTypeSetKt.computeTypeSet(underlying, GoPsiImplUtil.createContextOnElement(context));
            if (typeSet == GoTypeSet.Comparable.INSTANCE) {
                return true;
            }
            return typeSet instanceof GoTypeSet.Terms && ContainerUtil.and(((GoTypeSet.Terms)typeSet).getTerms(), it -> GoTypeUtil.isComparable(it.getType(), context, strict, false));
        }
        return !(underlying instanceof GoFunctionType) && !(underlying instanceof GoMapType);
    }

    @Contract(value="null, _ -> true")
    public static boolean isOrderedComparable(@Nullable GoType type, @Nullable PsiElement context) {
        if (type == null) {
            return true;
        }
        return GoTypeUtil.isIntegerType(type = type.getUnderlyingType(context), context) || GoTypeUtil.isTypedFloatType(type, context) || GoTypeUtil.isString(type, context) || GoTypeUtil.isUntypedFloatType(type) || GoTypeUtil.matchTypeConstraints(type, context, (GoType t) -> GoTypeUtil.isOrderedComparable(t, context));
    }

    @Contract(value="null, _ -> true")
    public static boolean isConstantType(@Nullable GoType type, @Nullable PsiElement context) {
        if (type == null || GoTypeUtil.isNamedType(type) && type.resolve(context) == null) {
            return true;
        }
        GoType underlyingType = type.getUnderlyingType(context);
        return GoTypeUtil.isNumericType(underlyingType, context) || GoTypeUtil.isBoolean(underlyingType, context) || GoTypeUtil.isString(underlyingType, context);
    }

    public static boolean isLenCapAvailableTo(@Nullable GoType type, boolean isLen, @Nullable PsiElement context) {
        if (type == null) {
            return false;
        }
        GoType underlyingType = GoPsiImplUtil.getUnderlyingType(type, context);
        GoType baseType = GoTypeUtil.arrayPointerDeref(underlyingType, context);
        if (baseType instanceof GoArrayOrSliceType || baseType instanceof GoChannelType || isLen && baseType instanceof GoMapType || isLen && GoTypeUtil.isStringType(baseType, context)) {
            return true;
        }
        return GoTypeUtil.matchTypeConstraints(baseType, context, (GoType t) -> GoTypeUtil.isLenCapAvailableTo(t, isLen, context));
    }

    @NotNull
    private static GoType arrayPointerDeref(@NotNull GoType type, @Nullable PsiElement context) {
        GoType baseType;
        GoType underlying;
        GoArrayOrSliceType arrayOrSliceType;
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(206);
        }
        if ((arrayOrSliceType = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)(underlying = (baseType = GoTypeUtil.getBasePointerType(type, context)) != null ? GoPsiImplUtil.getUnderlyingType(baseType, context) : null), GoArrayOrSliceType.class)) != null && arrayOrSliceType.isArray()) {
            GoType goType = underlying;
            if (goType == null) {
                GoTypeUtil.$$$reportNull$$$0(207);
            }
            return goType;
        }
        GoType goType = type;
        if (goType == null) {
            GoTypeUtil.$$$reportNull$$$0(208);
        }
        return goType;
    }

    @Nullable
    public static String getReceiverTypeName(@Nullable GoType type) {
        if (type instanceof GoPointerType) {
            GoPointerType pointerType = (GoPointerType)type;
            type = pointerType.getType();
        }
        if (type == null) {
            return null;
        }
        GoTypeReferenceExpression reference = type.getTypeReferenceExpression();
        if (reference == null) {
            return null;
        }
        PsiElement resolve = reference.resolve();
        if (resolve instanceof GoTypeSpec) {
            GoTypeSpec typeSpec = (GoTypeSpec)resolve;
            return typeSpec.getName();
        }
        return type.getPresentationText();
    }

    public static boolean isAllowedComparingToNil(@NotNull GoType type, @Nullable PsiElement context) {
        GoType underlyingType;
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(209);
        }
        return (underlyingType = type.getUnderlyingType(context)) instanceof GoArrayOrSliceType && !((GoArrayOrSliceType)underlyingType).isArray() || underlyingType instanceof GoMapType || underlyingType instanceof GoFunctionType || underlyingType instanceof GoPointerType || underlyingType instanceof GoChannelType || underlyingType instanceof GoInterfaceType || underlyingType instanceof GoCType;
    }

    @Contract(value="null -> null;!null->!null")
    public static GoType unwrapPointerAndParTypes(@Nullable GoType type) {
        if (type == null) {
            return null;
        }
        GoType o = type;
        while (o instanceof GoParType || o instanceof GoPointerType) {
            o = o instanceof GoParType ? ((GoParType)o).getType() : ((GoPointerType)o).getType();
        }
        return (GoType)ObjectUtils.notNull((Object)o, (Object)type);
    }

    public static boolean equalTypes(@Nullable GoType left, @Nullable GoType right, @Nullable PsiElement context, boolean strict) {
        if (left == null || right == null) {
            return !strict;
        }
        if (left instanceof GoLightType.LightVoidType) {
            return right instanceof GoLightType.LightVoidType;
        }
        if (left instanceof GoLightType.LightUntypedType) {
            return right instanceof GoLightType.LightUntypedType && left.getClass().equals(right.getClass());
        }
        if (GoTypeUtil.isCType(left, context) || GoTypeUtil.isCType(right, context)) {
            return true;
        }
        if (GoTypeUtil.isArbitraryType(left, context)) {
            return GoTypeUtil.isArbitraryType(right, context);
        }
        if (left instanceof GoSpecType) {
            return right instanceof GoSpecType && left.isEquivalentTo(right);
        }
        if (left instanceof GoArrayOrSliceType) {
            return right instanceof GoArrayOrSliceType && ((GoArrayOrSliceType)left).getLength() == ((GoArrayOrSliceType)right).getLength() && GoTypeUtil.equalTypes(((GoArrayOrSliceType)left).getType(), ((GoArrayOrSliceType)right).getType(), context, strict);
        }
        if (left instanceof GoStructType) {
            return right instanceof GoStructType && GoTypeUtil.sameStructs((GoStructType)left, (GoStructType)right, true, (l, r) -> GoTypeUtil.equalTypes(l, r, context, strict));
        }
        if (left instanceof GoPointerType) {
            return right instanceof GoPointerType && GoTypeUtil.equalTypes(((GoPointerType)left).getType(), ((GoPointerType)right).getType(), context, strict);
        }
        if (left instanceof GoFunctionType) {
            return right instanceof GoFunctionType && GoTypeUtil.sameSignatures(((GoFunctionType)left).getSignature(), ((GoFunctionType)right).getSignature(), (l, r) -> GoTypeUtil.equalTypes(l, r, context, strict));
        }
        if (left instanceof GoInterfaceType) {
            return right instanceof GoInterfaceType && GoTypeUtil.sameInterfaces((GoInterfaceType)left, (GoInterfaceType)right, context, (l, r) -> GoTypeUtil.equalTypes(l, r, context, strict));
        }
        if (left instanceof GoMapType) {
            return right instanceof GoMapType && GoTypeUtil.equalTypes(((GoMapType)left).getKeyType(), ((GoMapType)right).getKeyType(), context, strict) && GoTypeUtil.equalTypes(((GoMapType)left).getValueType(), ((GoMapType)right).getValueType(), context, strict);
        }
        if (left instanceof GoChannelType) {
            return right instanceof GoChannelType && ((GoChannelType)left).getDirection() == ((GoChannelType)right).getDirection() && GoTypeUtil.equalTypes(((GoChannelType)left).getType(), ((GoChannelType)right).getType(), context, strict);
        }
        if (left instanceof GoTypeList) {
            if (!(right instanceof GoTypeList)) {
                return false;
            }
            List<GoType> leftList = ((GoTypeList)left).getTypeList();
            List<GoType> rightList = ((GoTypeList)right).getTypeList();
            if (leftList.size() != rightList.size()) {
                return false;
            }
            for (int i = 0; i < leftList.size(); ++i) {
                if (GoTypeUtil.equalTypes(leftList.get(i), rightList.get(i), context, strict)) continue;
                return false;
            }
            return true;
        }
        PsiElement leftResolve = left.resolve(context);
        if (leftResolve == null) {
            return !strict;
        }
        PsiElement rightResolve = right.resolve(context);
        if (rightResolve == null) {
            return !strict;
        }
        return leftResolve.isEquivalentTo(rightResolve);
    }

    @Nullable
    public static GoType getExpectedValueType(@NotNull GoCompositeLit o) {
        GoType type;
        if (o == null) {
            GoTypeUtil.$$$reportNull$$$0(210);
        }
        if ((type = o.getType()) instanceof GoArrayOrSliceType) {
            return ((GoArrayOrSliceType)type).getType();
        }
        if (type instanceof GoMapType && ((GoMapType)type).getValueType() != null) {
            return ((GoMapType)type).getValueType();
        }
        return null;
    }

    public static boolean isInterface(@NotNull GoTypeSpec spec) {
        if (spec == null) {
            GoTypeUtil.$$$reportNull$$$0(211);
        }
        return GoTypeUtil.isInterface(spec.getSpecType());
    }

    public static boolean isInterface(@NotNull GoSpecType type) {
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(212);
        }
        return type.getContextlessUnderlyingType() instanceof GoInterfaceType;
    }

    @Nullable
    public static GoType findType(@NotNull Project project, @Nullable String importPath, @NotNull String typeName) {
        if (project == null) {
            GoTypeUtil.$$$reportNull$$$0(213);
        }
        if (typeName == null) {
            GoTypeUtil.$$$reportNull$$$0(214);
        }
        if (StringUtil.isEmpty((String)typeName)) {
            return null;
        }
        Object importString = StringUtil.isNotEmpty((String)importPath) ? "import pkg \"" + importPath + "\"; " : "";
        String qualifier = StringUtil.isNotEmpty((String)importPath) ? "pkg." : "";
        String text = "package main; " + (String)importString + "var a " + qualifier + typeName;
        GoVarDeclaration var = GoElementFactory.createElement(project, text, GoVarDeclaration.class, null);
        GoVarSpec spec = (GoVarSpec)ContainerUtil.getFirstItem(var != null ? var.getVarSpecList() : null);
        return (GoType)ObjectUtils.doIfNotNull((Object)spec, GoVarSpec::getType);
    }

    @Contract(value="null, _, _, _, _ -> false")
    public static boolean isKnownType(@Nullable GoType type, @Nullable PsiElement context, @NotNull @NonNls String importPath, @NotNull @NonNls String typeName, boolean unwrapPointer) {
        GoTypeSpec resolve;
        if (importPath == null) {
            GoTypeUtil.$$$reportNull$$$0(215);
        }
        if (typeName == null) {
            GoTypeUtil.$$$reportNull$$$0(216);
        }
        return (resolve = GoTypeUtil.findTypeSpec(type, context, unwrapPointer)) != null && typeName.equals(resolve.getName()) && importPath.equals(GoUtil.getImportPath(resolve, context));
    }

    @Nullable
    public static GoInterfaceType findInterface(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull String interfaceName) {
        Collection<GoTypeSpec> interfaces;
        GoTypeSpec interfaceSpec;
        if (project == null) {
            GoTypeUtil.$$$reportNull$$$0(217);
        }
        if (scope == null) {
            GoTypeUtil.$$$reportNull$$$0(218);
        }
        if (interfaceName == null) {
            GoTypeUtil.$$$reportNull$$$0(219);
        }
        return (GoInterfaceType)ObjectUtils.tryCast((Object)((interfaceSpec = (GoTypeSpec)ContainerUtil.getFirstItem(interfaces = GoTypesIndex.find(interfaceName, project, scope, GoIdFilter.getProductionFilter(project)))) != null ? interfaceSpec.getSpecType().getType() : null), GoInterfaceType.class);
    }

    public static boolean isNamedUnresolved(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(220);
        }
        return GoTypeUtil.isNamedType(type) && GoTypeUtil.resolveNamedType(type, context) == null;
    }

    public static boolean isEmptyInterface(@NotNull GoInterfaceType interfaceType) {
        if (interfaceType == null) {
            GoTypeUtil.$$$reportNull$$$0(221);
        }
        return interfaceType.getMethodSpecList().isEmpty() && interfaceType.getConstraintElemList().isEmpty();
    }

    public static boolean matchTypeConstraints(@Nullable GoType type, @Nullable PsiElement context, @NotNull @NotNull Predicate<@NotNull GoType> predicate) {
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(222);
        }
        return GoPsiImplUtil.withContextOnElement(context, resolveState -> GoTypeUtil.matchTypeConstraints(type, resolveState, predicate));
    }

    public static boolean matchTypeConstraints(@Nullable GoType type, @Nullable ResolveState resolveState, @NotNull @NotNull Predicate<@NotNull GoType> predicate) {
        List<GoAbstractConstraintTerm> terms;
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(223);
        }
        return !(terms = GoTypeUtil.getConstraintTerms(type, resolveState)).isEmpty() && ContainerUtil.and(terms, it -> GoTypeUtil.checkTerm(it, resolveState, predicate));
    }

    public static boolean typeSetIs(@Nullable GoType type, @Nullable PsiElement context, @NotNull Predicate<GoType> predicate) {
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(224);
        }
        return GoPsiImplUtil.withContextOnElement(context, resolveState -> GoTypeUtil.typeSetIs(type, resolveState, predicate));
    }

    public static boolean typeSetIs(@Nullable GoType type, @Nullable ResolveState resolveState, @NotNull Predicate<GoType> predicate) {
        List<GoAbstractConstraintTerm> terms;
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(225);
        }
        return !(terms = GoTypeUtil.getConstraintTerms(type, resolveState)).isEmpty() && ContainerUtil.and(terms, term -> {
            GoType termType = term.getType();
            return termType != null && predicate.test(termType);
        });
    }

    @NotNull
    private static List<GoAbstractConstraintTerm> getConstraintTerms(@Nullable GoType type, @Nullable ResolveState resolveState) {
        type = type != null ? type.getUnderlyingType(resolveState) : null;
        GoTypeSet typeSet = GoTypeSetKt.computeTypeSet(type, resolveState);
        GoTypeSet.Terms termSet = (GoTypeSet.Terms)ObjectUtils.tryCast((Object)typeSet, GoTypeSet.Terms.class);
        List<GoAbstractConstraintTerm> list = termSet != null ? termSet.getTerms() : Collections.emptyList();
        if (list == null) {
            GoTypeUtil.$$$reportNull$$$0(226);
        }
        return list;
    }

    public static boolean checkTerm(@NotNull GoAbstractConstraintTerm term, @Nullable ResolveState resolveState, @NotNull @NotNull Predicate<@NotNull GoType> predicate) {
        GoType constraintType;
        if (term == null) {
            GoTypeUtil.$$$reportNull$$$0(227);
        }
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(228);
        }
        GoType underlying = (constraintType = term.getType()) != null ? GoPsiImplUtil.getUnderlyingType(constraintType, resolveState) : null;
        return underlying != null && predicate.test(underlying);
    }

    @NotNull
    private static GoTypeCheckResult checkConstraintIncludesType(@NotNull ResolveState resolveState, @Nullable GoTypeSet constraintTypeSet, @NotNull GoType valueType, @Nullable GoType valueUnderlyingType, @Nullable GoTypeSet valueTypeSet, boolean strict) {
        if (resolveState == null) {
            GoTypeUtil.$$$reportNull$$$0(229);
        }
        if (valueType == null) {
            GoTypeUtil.$$$reportNull$$$0(230);
        }
        if (constraintTypeSet == null) {
            return new GoTypesCompatible();
        }
        if (valueUnderlyingType instanceof GoInterfaceType) {
            return GoTypeUtil.checkTypeSetIncludesAnotherTypeSet(constraintTypeSet, valueTypeSet, resolveState);
        }
        if (constraintTypeSet instanceof GoTypeSet.All) {
            return new GoTypesCompatible();
        }
        if (constraintTypeSet instanceof GoTypeSet.Empty) {
            return new GoNotInTypeSet(constraintTypeSet);
        }
        PsiElement context = GoPsiImplUtil.getContextElement(resolveState);
        if (constraintTypeSet instanceof GoTypeSet.Comparable) {
            GoTypeCheckResult goTypeCheckResult = GoTypeCheckResult.of(GoTypeUtil.isComparable(valueType, context, strict, false));
            if (goTypeCheckResult == null) {
                GoTypeUtil.$$$reportNull$$$0(231);
            }
            return goTypeCheckResult;
        }
        GoTypeSet.Terms termSet = (GoTypeSet.Terms)ObjectUtils.tryCast((Object)constraintTypeSet, GoTypeSet.Terms.class);
        if (termSet == null) {
            return new GoTypesCompatible();
        }
        List<GoAbstractConstraintTerm> terms = termSet.getTerms();
        boolean exists = ContainerUtil.or(terms, term -> {
            GoType constraintType = term.getType();
            if (constraintType == null) {
                return false;
            }
            GoType checkedValueType = term.hasTilde() ? valueUnderlyingType : valueType;
            return GoTypeUtil.identical(constraintType, checkedValueType, strict, context);
        });
        return exists ? new GoTypesCompatible() : new GoNotInTypeSet(constraintTypeSet);
    }

    @NotNull
    private static GoTypeCheckResult checkTypeSetIncludesAnotherTypeSet(@NotNull GoTypeSet typeSet, @Nullable GoTypeSet anotherTypeSet, @Nullable ResolveState resolveState) {
        if (typeSet == null) {
            GoTypeUtil.$$$reportNull$$$0(232);
        }
        if (anotherTypeSet == null) {
            return new GoTypesCompatible();
        }
        boolean subset = GoTypeSetKt.isSubsetOf(anotherTypeSet, typeSet, resolveState);
        return subset ? new GoTypesCompatible() : new GoNotInTypeSet(typeSet);
    }

    @NotNull
    private static GoTypeCheckResult checkSatisfiesComparable(@NotNull GoType valueType, @Nullable PsiElement context, boolean strict) {
        if (valueType == null) {
            GoTypeUtil.$$$reportNull$$$0(233);
        }
        if (GoTypeUtil.isComparable(valueType, context, strict, false)) {
            return new GoTypesCompatible();
        }
        if (GoTypeUtil.isComparable(valueType, context, strict, true)) {
            GoSdkUtil.FeatureSupported supported = GoSdkUtil.featureSupported(valueType, false, GoSdkVersion::supportsBasicInterfacesSatisfyingComparable);
            return supported == GoSdkUtil.FeatureSupported.YES ? new GoTypesCompatible() : new GoNonStrictComparabilityUnsupported(supported == GoSdkUtil.FeatureSupported.NEED_VERSION_UPDATE);
        }
        return new GoNotInTypeSet(GoTypeSet.Comparable.INSTANCE);
    }

    public static boolean isBuiltinComparable(@Nullable GoType type, @Nullable PsiElement context) {
        GoType underlying;
        GoType goType = underlying = type != null ? type.getUnderlyingType(context) : null;
        if (underlying instanceof GoInterfaceType) {
            GoTypeSpec typeSpec = (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)underlying, GoTypeSpec.class);
            return typeSpec != null && "comparable".equals(typeSpec.getName()) && GoPsiImplUtil.builtin(underlying);
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean isTypeParameter(@Nullable GoType type, @Nullable PsiElement context) {
        return GoTypeUtil.getTypeParameter(type, context) != null;
    }

    @Nullable
    public static GoTypeParameter getTypeParameter(@Nullable GoType type, @Nullable PsiElement context) {
        if (type instanceof GoTypeParameter) {
            return (GoTypeParameter)type;
        }
        GoTypeParamDefinition receiverTypeParamDefinition = GoPsiUtil.getReceiverTypeParamDefinition(type);
        if (receiverTypeParamDefinition != null) {
            return receiverTypeParamDefinition.getTypeParameter();
        }
        PsiElement resolved = type != null ? type.resolve(context) : null;
        return resolved instanceof GoTypeParamDefinition ? ((GoTypeParamDefinition)resolved).getTypeParameter() : null;
    }

    public static boolean isPointer(@Nullable GoType type, @Nullable PsiElement context) {
        GoType underlying = type != null ? type.getUnderlyingType(context) : null;
        return underlying instanceof GoPointerType || GoTypeUtil.matchTypeConstraints(underlying, context, (GoType t) -> GoTypeUtil.isPointer(t, context));
    }

    @Nullable
    public static GoType getBasePointerType(@Nullable GoType type, @Nullable PsiElement context) {
        return GoPsiImplUtil.withContextOnElement(context, state -> GoTypeUtil.getBasePointerType(type, state));
    }

    @Nullable
    public static GoType getBasePointerType(@Nullable GoType type, @Nullable ResolveState state) {
        GoType basePointerType;
        if (type == null) {
            return null;
        }
        GoType underlying = type.getUnderlyingType(state);
        if (underlying instanceof GoPointerType) {
            return ((GoPointerType)underlying).getType();
        }
        List<GoAbstractConstraintTerm> terms = GoTypeUtil.getConstraintTerms(underlying, state);
        GoAbstractConstraintTerm first = (GoAbstractConstraintTerm)ContainerUtil.getFirstItem(terms);
        GoType firstTermType = first != null ? first.getType() : null;
        GoType goType = basePointerType = firstTermType != null ? (GoType)RecursionManager.doPreventingRecursion((Object)firstTermType, (boolean)false, () -> GoTypeUtil.getBasePointerType(firstTermType, state)) : null;
        if (basePointerType == null) {
            return null;
        }
        for (GoAbstractConstraintTerm term : terms.subList(1, terms.size())) {
            GoType termType = term.getType();
            GoType termBasePointerType = termType != null ? (GoType)RecursionManager.doPreventingRecursion((Object)termType, (boolean)false, () -> GoTypeUtil.getBasePointerType(termType, state)) : null;
            if (GoTypeUtil.identical(basePointerType, termBasePointerType, GoPsiImplUtil.getContextElement(state))) continue;
            return null;
        }
        return basePointerType;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoType getCoreType(@Nullable GoType type, @Nullable PsiElement context) {
        return GoPsiImplUtil.withContextOnElement(context, state -> GoTypeUtil.getCoreType(type, state));
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoType getCoreType(@Nullable GoType type, @Nullable ResolveState state) {
        if (type == null) {
            return null;
        }
        GoType underlyingType = GoPsiImplUtil.getUnderlyingType(type, state);
        if (!GoTypeUtil.isTypeParameter(type, GoPsiImplUtil.getContextElement(state))) {
            return underlyingType;
        }
        Ref coreType = Ref.create();
        boolean success = GoTypeUtil.matchTypeConstraints(underlyingType, state, (GoType termUnderlying) -> {
            if (!coreType.isNull() && (termUnderlying = GoTypeUtil.coreMatch((GoType)coreType.get(), termUnderlying, state)) == null) {
                return false;
            }
            coreType.set(termUnderlying);
            return true;
        });
        return success ? (GoType)coreType.get() : null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoType getCoreStringType(@Nullable GoType type, @Nullable ResolveState state) {
        if (type == null) {
            return null;
        }
        PsiElement context = GoPsiImplUtil.getContextElement(state);
        GoType underlyingType = GoPsiImplUtil.getUnderlyingType(type, state);
        if (!GoTypeUtil.isTypeParameter(type, context)) {
            return underlyingType;
        }
        if (context == null) {
            return null;
        }
        GoArrayOrSliceType byteSlice = GoTypeUtil.getByteSliceType(context);
        Ref coreType = Ref.create();
        Ref hasString = Ref.create((Object)false);
        boolean success = GoTypeUtil.matchTypeConstraints(underlyingType, state, (GoType termUnderlying) -> {
            if (GoTypeUtil.isString(termUnderlying, context)) {
                hasString.set((Object)true);
                GoType goType = termUnderlying = byteSlice != null ? byteSlice : termUnderlying;
            }
            if (!coreType.isNull() && (termUnderlying = GoTypeUtil.coreMatch((GoType)coreType.get(), termUnderlying, state)) == null) {
                return false;
            }
            coreType.set(termUnderlying);
            return true;
        });
        if (!success) {
            return null;
        }
        return (Boolean)hasString.get() != false ? GoPsiImplUtil.getBuiltinType("string", context) : (GoType)coreType.get();
    }

    @Nullable
    private static GoArrayOrSliceType getByteSliceType(@NotNull PsiElement context) {
        GoType byteType;
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(234);
        }
        return (byteType = GoPsiImplUtil.getBuiltinType(BYTE, context)) != null ? new GoLightType.LightSliceType(byteType) : null;
    }

    @Nullable
    private static GoType coreMatch(@NotNull GoType x, @NotNull GoType y, @Nullable ResolveState state) {
        PsiElement context;
        if (x == null) {
            GoTypeUtil.$$$reportNull$$$0(235);
        }
        if (y == null) {
            GoTypeUtil.$$$reportNull$$$0(236);
        }
        if (GoTypeUtil.identical(x, y, context = GoPsiImplUtil.getContextElement(state))) {
            return x;
        }
        GoChannelType xChannel = (GoChannelType)ObjectUtils.tryCast((Object)x, GoChannelType.class);
        GoChannelType yChannel = (GoChannelType)ObjectUtils.tryCast((Object)y, GoChannelType.class);
        if (xChannel != null && yChannel != null && GoTypeUtil.identical(xChannel.getType(), yChannel.getType(), context)) {
            if (xChannel.getDirection() == GoPsiImplUtil.ChannelDirection.BIDIRECTIONAL) {
                return y;
            }
            if (yChannel.getDirection() == GoPsiImplUtil.ChannelDirection.BIDIRECTIONAL) {
                return x;
            }
        }
        return null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoType getArrayOrSliceType(@Nullable GoType type, @Nullable PsiElement context) {
        GoType coreType = GoTypeUtil.getCoreType(type, context);
        return coreType instanceof GoArrayOrSliceType ? coreType : null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static GoType getArrayOrSliceElementType(@Nullable GoType type) {
        return (GoType)ObjectUtils.doIfCast((Object)type, GoArrayOrSliceType.class, it -> it.getType());
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoType getMapKeyType(@Nullable GoType type, @Nullable PsiElement context) {
        if (type == null) {
            return null;
        }
        GoType underlying = GoPsiImplUtil.getUnderlyingType(type, context);
        if (underlying instanceof GoMapType) {
            return ((GoMapType)underlying).getKeyType();
        }
        if (underlying instanceof GoInterfaceType) {
            Ref resultType = Ref.create();
            boolean match = GoTypeUtil.matchTypeConstraints(underlying, context, (GoType term) -> {
                if (!(term instanceof GoMapType)) {
                    return false;
                }
                GoType keyType = ((GoMapType)term).getKeyType();
                if (!resultType.isNull()) {
                    return GoTypeUtil.identical((GoType)resultType.get(), keyType, false, context);
                }
                resultType.set((Object)keyType);
                return true;
            });
            return match ? (GoType)resultType.get() : null;
        }
        return null;
    }

    @Contract(value="null, _, _ -> false")
    public static boolean underlyingTypeIs(@Nullable GoType type, @Nullable PsiElement context, @NotNull Predicate<@Nullable GoType> predicate) {
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(237);
        }
        if (type == null) {
            return false;
        }
        if (GoTypeUtil.isTypeParameter(type, context)) {
            return GoTypeUtil.matchTypeConstraints(type, context, predicate);
        }
        GoType underlying = GoPsiImplUtil.getUnderlyingType(type, context);
        return predicate.test(underlying);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static GoInterfaceType findFirstMatchedInterfaceDfs(@Nullable GoType type, @NotNull Predicate<GoInterfaceType> predicate) {
        if (predicate == null) {
            GoTypeUtil.$$$reportNull$$$0(238);
        }
        if (!(type instanceof GoInterfaceType)) {
            return null;
        }
        HashSet<GoType> seen = new HashSet<GoType>();
        ArrayDeque<GoInterfaceType> stack = new ArrayDeque<GoInterfaceType>();
        seen.add(type);
        stack.push((GoInterfaceType)type);
        while (!stack.isEmpty()) {
            GoInterfaceType t = (GoInterfaceType)stack.pop();
            if (predicate.test(t)) {
                return t;
            }
            for (GoTypeReferenceExpression reference : t.getBaseTypesReferences()) {
                GoSpecType specType;
                GoInterfaceType embeddedInterface;
                GoType resolved = reference.resolveType(ResolveState.initial());
                if (!(resolved instanceof GoSpecType) || (embeddedInterface = (GoInterfaceType)ObjectUtils.tryCast((Object)(specType = (GoSpecType)resolved).getContextlessUnderlyingType(), GoInterfaceType.class)) == null || !seen.add(embeddedInterface)) continue;
                stack.push(embeddedInterface);
            }
        }
        return null;
    }

    public static boolean isBasicInterface(@Nullable GoInterfaceType iface, @Nullable PsiElement context) {
        if (iface == null || !iface.getConstraintElemList().isEmpty() || GoTypeUtil.isBuiltinComparable(iface, context)) {
            return false;
        }
        for (GoTypeReferenceExpression reference : iface.getBaseTypesReferences()) {
            GoSpecType specType = (GoSpecType)ObjectUtils.tryCast((Object)reference.resolveType(ResolveState.initial()), GoSpecType.class);
            if (specType == null || GoTypeUtil.isInterface(specType)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static GoReceiverUtil.ReceiverTypeCheckError checkBaseReceiverType(@NotNull GoType receiverType, @NotNull PsiElement context) {
        GoType flattenedReceiverType;
        GoType baseType;
        if (receiverType == null) {
            GoTypeUtil.$$$reportNull$$$0(239);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(240);
        }
        if ((baseType = GoPsiImplUtil.unwrapPointerIfNeeded(flattenedReceiverType = GoTypeUtil.flattenAliasesAndPointers(receiverType, context))) == null) {
            return null;
        }
        if (!(baseType instanceof GoPointerType) && !GoTypeUtil.isNamedType(baseType)) {
            return new GoReceiverUtil.ReceiverTypeCheckError(GoReceiverUtil.ReceiverTypeErrorCategory.UNNAMED_TYPE, flattenedReceiverType, baseType);
        }
        if (GoTypeUtil.isNonLocalType(baseType, context)) {
            return new GoReceiverUtil.ReceiverTypeCheckError(GoReceiverUtil.ReceiverTypeErrorCategory.NONLOCAL_TYPE, flattenedReceiverType, baseType);
        }
        GoType underlyingType = baseType.getUnderlyingType(context);
        if (underlyingType instanceof GoPointerType) {
            return new GoReceiverUtil.ReceiverTypeCheckError(GoReceiverUtil.ReceiverTypeErrorCategory.POINTER_TYPE, flattenedReceiverType, underlyingType);
        }
        if (underlyingType instanceof GoInterfaceType) {
            return new GoReceiverUtil.ReceiverTypeCheckError(GoReceiverUtil.ReceiverTypeErrorCategory.INTERFACE_TYPE, flattenedReceiverType, baseType);
        }
        return null;
    }

    @NotNull
    private static GoType flattenAliasesAndPointers(@NotNull GoType type, @NotNull PsiElement context) {
        GoPointerType pointerType;
        GoType unwrappedAlias;
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(241);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(242);
        }
        if ((unwrappedAlias = GoTypeUtil.unwrapAliasOnly(type, context)) instanceof GoPointerType && (pointerType = (GoPointerType)unwrappedAlias).getType() != null) {
            return new GoLightType.LightPointerType(GoTypeUtil.flattenAliasesAndPointers(pointerType.getType(), context));
        }
        if (unwrappedAlias == null || unwrappedAlias == type) {
            GoType goType = type;
            if (goType == null) {
                GoTypeUtil.$$$reportNull$$$0(243);
            }
            return goType;
        }
        GoType goType = unwrappedAlias;
        if (goType == null) {
            GoTypeUtil.$$$reportNull$$$0(244);
        }
        return goType;
    }

    private static boolean isNonLocalType(@NotNull GoType type, @NotNull PsiElement context) {
        GoTypeSpec spec;
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(245);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(246);
        }
        return (spec = GoTypeUtil.findTypeSpec(type, context)) != null && !GoUtil.isDirectlyAccessible((PsiFile)spec.getContainingFile(), context.getContainingFile());
    }

    @Nullable
    private static GoType unwrapAliasOnly(@NotNull GoType type, @NotNull PsiElement context) {
        GoTypeSpec spec;
        if (type == null) {
            GoTypeUtil.$$$reportNull$$$0(247);
        }
        if (context == null) {
            GoTypeUtil.$$$reportNull$$$0(248);
        }
        if ((spec = GoTypeUtil.findTypeSpec(type, context)) == null) {
            return type;
        }
        if (!spec.isTypeAlias()) {
            return type;
        }
        return GoPsiUtil.unwrapAlias(spec);
    }

    private static /* synthetic */ Boolean lambda$processMethodsByLevel$25(boolean acquirePointerSomehow, GoAnonymousFieldDefinition field, Collection nextLevelTypes, GoTypeSpec typeSpec) {
        boolean pointer = acquirePointerSomehow || field.getType() instanceof GoPointerType;
        GoType specType = GoTypeInstantiationKt.getInstantiatedSpecType(typeSpec.getSpecType(), field.getType());
        return nextLevelTypes.add(pointer ? new GoLightType.LightPointerType(specType) : specType);
    }

    private static /* synthetic */ boolean lambda$checkImplementsInterface$20(Set implementedMethodNames, GoMethodSpec m) {
        return implementedMethodNames.contains(m.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 28, 29, 30, 33, 34, 35, 39, 40, 41, 42, 43, 50, 51, 52, 62, 63, 64, 65, 66, 67, 68, 71, 72, 73, 74, 78, 79, 80, 82, 83, 84, 86, 87, 88, 90, 91, 92, 95, 96, 97, 103, 104, 105, 106, 108, 110, 111, 118, 122, 123, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 160, 161, 162, 163, 164, 165, 166, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 189, 190, 191, 192, 193, 196, 197, 198, 202, 206, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 227, 228, 229, 230, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 245, 246, 247, 248 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/GoTypeUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 87: 
            case 111: 
            case 122: 
            case 123: 
            case 148: 
            case 150: 
            case 152: 
            case 161: 
            case 163: 
            case 165: 
            case 175: 
            case 179: 
            case 182: 
            case 189: 
            case 190: 
            case 206: 
            case 209: 
            case 212: 
            case 220: 
            case 241: 
            case 245: 
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "integerType";
                break;
            }
            case 5: 
            case 30: 
            case 33: 
            case 40: 
            case 66: 
            case 71: 
            case 82: 
            case 86: 
            case 90: 
            case 95: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 35: 
            case 43: 
            case 52: 
            case 64: 
            case 68: 
            case 73: 
            case 74: 
            case 80: 
            case 84: 
            case 88: 
            case 92: 
            case 97: 
            case 105: 
            case 106: 
            case 108: 
            case 110: 
            case 234: 
            case 240: 
            case 242: 
            case 246: 
            case 248: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalElement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 50: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 51: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandExpr";
                break;
            }
            case 67: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtinTypes";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recvStatement";
                break;
            }
            case 83: 
            case 211: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhsExprList";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 118: 
            case 131: 
            case 133: 
            case 135: 
            case 138: 
            case 141: 
            case 144: 
            case 191: 
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 127: 
            case 130: 
            case 137: 
            case 146: 
            case 193: 
            case 198: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 228: 
            case 237: 
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftTypeArguments";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightTypeArguments";
                break;
            }
            case 132: 
            case 134: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 192: 
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inSamePackages";
                break;
            }
            case 147: 
            case 149: 
            case 151: 
            case 160: 
            case 162: 
            case 164: 
            case 178: 
            case 221: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceType";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintType";
                break;
            }
            case 154: 
            case 230: 
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 166: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signaturesMatcher";
                break;
            }
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceMethod";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceSubstitutionSource";
                break;
            }
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementedMethod";
                break;
            }
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationSubstitutionSource";
                break;
            }
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialType";
                break;
            }
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceMethodsMap";
                break;
            }
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 210: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 213: 
            case 217: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 214: 
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 218: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceName";
                break;
            }
            case 227: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
            case 229: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveState";
                break;
            }
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSet";
                break;
            }
            case 235: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 236: {
                objectArray2 = objectArray3;
                objectArray3[0] = "y";
                break;
            }
            case 239: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "checkIterable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: 
            case 51: 
            case 52: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 110: 
            case 111: 
            case 118: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 196: 
            case 197: 
            case 198: 
            case 202: 
            case 206: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 245: 
            case 246: 
            case 247: 
            case 248: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/GoTypeUtil";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypes";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromReturnStatement";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromGoSendStatement";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromArgumentList";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesForBinaryExprOperand";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeForNewAndMake";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "builtinCopyDefaultExpectedTypes";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromRecvStatement";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromVarOrConstSpec";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromAssignmentStatement";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypesFromAssignmentLHS";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceIfNull";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceType";
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNameOrText";
                break;
            }
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAssignable";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapAlias";
                break;
            }
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "isSamePackages";
                break;
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                objectArray = objectArray2;
                objectArray2[1] = "checkImplementsConstraint";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "checkImplementsInterface";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesMatcher";
                break;
            }
            case 183: {
                objectArray = objectArray2;
                objectArray2[1] = "findImplementedMethods";
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "findImplementedMethodsWithSubstitutionSource";
                break;
            }
            case 194: 
            case 195: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesAndIsVariadicFromParameters";
                break;
            }
            case 199: 
            case 200: 
            case 201: {
                objectArray = objectArray2;
                objectArray2[1] = "getListOfTypesFromTypeList";
                break;
            }
            case 203: 
            case 204: 
            case 205: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesOfExpressions";
                break;
            }
            case 207: 
            case 208: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayPointerDeref";
                break;
            }
            case 226: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraintTerms";
                break;
            }
            case 231: {
                objectArray = objectArray2;
                objectArray2[1] = "checkConstraintIncludesType";
                break;
            }
            case 243: 
            case 244: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenAliasesAndPointers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnsafePointerType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isComplexType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFloatType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIntegerTypeLimits";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isMapCompositeLiteralElement";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromReturnStatement";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromGoSendStatement";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureFromFunctionType";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromArgumentList";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesForBinaryExprOperand";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedOperandTypeFromOtherOperands";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findNonShiftExpressionOperand";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeForNewAndMake";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesForBuiltinFunctions";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "builtinCopyDefaultExpectedTypes";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isSliceOfType";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromRecvStatement";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromVarOrConstSpec";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getTypes";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromAssignmentStatement";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypesFromAssignmentLHS";
                break;
            }
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "createGoTypeListOrGoType";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaceIfNull";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaceType";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getGoType";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getTypeNameOrText";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignable";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAliasIfNamed";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAlias";
                break;
            }
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "sameNamedTypes";
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "sameTypeArguments";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "areEquivalentTypeParams";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "sameBuiltinIntegerAliases";
                break;
            }
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "sameInterfaces";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "isSamePackages";
                break;
            }
            case 141: 
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "sameNames";
                break;
            }
            case 144: 
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "sameStructs";
                break;
            }
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "isImplementsInterface";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "checkImplementsConstraint";
                break;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "checkImplementsInterface";
                break;
            }
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "isPointerToInterface";
                break;
            }
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsByLevel";
                break;
            }
            case 178: 
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "checkAmbiguousMethods";
                break;
            }
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "cannotCallOnNonPointer";
                break;
            }
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "findImplementedMethods";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsHolder";
                break;
            }
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSet";
                break;
            }
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "areSignaturesIdentical";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "sameSignatures";
                break;
            }
            case 196: 
            case 197: 
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "sameTypeLists";
                break;
            }
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "getTypesOfExpressions";
                break;
            }
            case 206: {
                objectArray = objectArray;
                objectArray[2] = "arrayPointerDeref";
                break;
            }
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedComparingToNil";
                break;
            }
            case 210: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedValueType";
                break;
            }
            case 211: 
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "isInterface";
                break;
            }
            case 213: 
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "findType";
                break;
            }
            case 215: 
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "isKnownType";
                break;
            }
            case 217: 
            case 218: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "findInterface";
                break;
            }
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "isNamedUnresolved";
                break;
            }
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyInterface";
                break;
            }
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "matchTypeConstraints";
                break;
            }
            case 224: 
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "typeSetIs";
                break;
            }
            case 227: 
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "checkTerm";
                break;
            }
            case 229: 
            case 230: {
                objectArray = objectArray;
                objectArray[2] = "checkConstraintIncludesType";
                break;
            }
            case 232: {
                objectArray = objectArray;
                objectArray[2] = "checkTypeSetIncludesAnotherTypeSet";
                break;
            }
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "checkSatisfiesComparable";
                break;
            }
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "getByteSliceType";
                break;
            }
            case 235: 
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "coreMatch";
                break;
            }
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "underlyingTypeIs";
                break;
            }
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "findFirstMatchedInterfaceDfs";
                break;
            }
            case 239: 
            case 240: {
                objectArray = objectArray;
                objectArray[2] = "checkBaseReceiverType";
                break;
            }
            case 241: 
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "flattenAliasesAndPointers";
                break;
            }
            case 245: 
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "isNonLocalType";
                break;
            }
            case 247: 
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAliasOnly";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 28, 29, 30, 33, 34, 35, 39, 40, 41, 42, 43, 50, 51, 52, 62, 63, 64, 65, 66, 67, 68, 71, 72, 73, 74, 78, 79, 80, 82, 83, 84, 86, 87, 88, 90, 91, 92, 95, 96, 97, 103, 104, 105, 106, 108, 110, 111, 118, 122, 123, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 160, 161, 162, 163, 164, 165, 166, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 189, 190, 191, 192, 193, 196, 197, 198, 202, 206, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 227, 228, 229, 230, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 245, 246, 247, 248 -> new IllegalArgumentException(string);
        };
    }

    public static interface ByLevelMethodsProcessor<T> {
        @Nullable(value="null to process next level")
        public @Nullable(value="null to process next level") T process(int var1, @NotNull Collection<GoElementWithSubst<GoNamedSignatureOwner>> var2);
    }
}

