/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.GoIcons;
import com.goide.i18n.GoBundle;
import com.goide.psi.impl.GoPackage;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.ui.SimpleListCellRenderer;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoMultiplePackagesQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public static final Key<String> TESTING_PACKAGE_NAME = Key.create((String)"GoMultiplePackagesQuickFix.TESTING_PACKAGE_NAME");
    @FileModifier.SafeFieldForPreview
    private final Collection<String> myPackages;
    private final String myPackageName;
    private final boolean myIsOneTheFly;

    public GoMultiplePackagesQuickFix(@NotNull PsiElement element, @NotNull String packageName, @NotNull Collection<String> packages, boolean isOnTheFly) {
        if (element == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(1);
        }
        if (packages == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(2);
        }
        super(element);
        this.myPackages = packages;
        this.myPackageName = packageName;
        this.myIsOneTheFly = isOnTheFly;
    }

    private void renamePackagesInDirectory(@NotNull Project project, @NotNull PsiDirectory dir, @NotNull String newName) {
        if (project == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(3);
        }
        if (dir == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(5);
        }
        String commandName = GoBundle.message((String)"go.fix.multiple.packages.command.name", (Object[])new Object[]{this.myPackageName});
        WriteCommandAction.runWriteCommandAction((Project)project, (String)commandName, null, () -> {
            for (GoPackage aPackage : GoPackage.in(dir)) {
                aPackage.setName(newName);
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        String testingPackageName;
        if (project == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(6);
        }
        if (file == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            this.renamePackagesInDirectory(project, file.getContainingDirectory(), this.myPackageName);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (testingPackageName = (String)TestModeFlags.get(TESTING_PACKAGE_NAME)) != null) {
            this.renamePackagesInDirectory(project, file.getContainingDirectory(), testingPackageName);
            return;
        }
        ArrayList<String> list = new ArrayList<String>(this.myPackages);
        JBPopupFactory.getInstance().createPopupChooserBuilder(list).setTitle(GoBundle.message((String)"go.fix.choose.package.name", (Object[])new Object[0])).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            label.setIcon(GoIcons.PACKAGE);
            label.setText(value);
        })).setItemChosenCallback(name -> {
            if (name != null) {
                this.renamePackagesInDirectory(project, file.getContainingDirectory(), (String)name);
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(11);
        }
        if (file == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(12);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(13);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    public String getText() {
        String string = this.myIsOneTheFly ? this.getFamilyName() : GoBundle.message((String)"go.fix.multiple.packages.text", (Object[])new Object[]{this.myPackageName});
        if (string == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.fix.multiple.packages.name", (Object[])new Object[0]);
        if (string == null) {
            GoMultiplePackagesQuickFix.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoMultiplePackagesQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoMultiplePackagesQuickFix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renamePackagesInDirectory";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15 -> new IllegalStateException(string);
        };
    }
}

