/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.psi.GoNamedElement;
import com.goide.refactor.ui.GoDeclarationInfoModel;
import com.goide.refactor.ui.GoRenameUsageInfo;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import java.io.IOException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoRefactoringProcessorBase<Model extends GoDeclarationInfoModel>
extends BaseRefactoringProcessor {
    protected final Model myModel;
    protected final boolean myOpenInEditor;

    public GoRefactoringProcessorBase(@NotNull Project project, @NotNull Model model, boolean openInEditor) {
        if (project == null) {
            GoRefactoringProcessorBase.$$$reportNull$$$0(0);
        }
        if (model == null) {
            GoRefactoringProcessorBase.$$$reportNull$$$0(1);
        }
        super(project);
        this.myModel = model;
        this.myOpenInEditor = openInEditor;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            GoRefactoringProcessorBase.$$$reportNull$$$0(2);
        }
        return this.showConflicts(((GoDeclarationInfoModel)((Object)this.myModel)).getConflicts(), (UsageInfo[])refUsages.get());
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            GoRefactoringProcessorBase.$$$reportNull$$$0(3);
        }
        return super.isPreviewUsages(usages) || UsageViewUtil.reportNonRegularUsages((UsageInfo[])usages, (Project)this.myProject);
    }

    @Nullable
    protected GoFile prepareFile() {
        GoFile targetFile;
        PsiDirectory directory = this.findOrCreateDirectory();
        if (directory == null) {
            this.showErrorHint(GoBundle.message((String)"go.refactoring.failed.to.create.directory.error.message", (Object[])new Object[]{((GoDeclarationInfoModel)((Object)this.myModel)).getDirectoryPath()}));
            return null;
        }
        String fileName = ((GoDeclarationInfoModel)((Object)this.myModel)).getFileName() + ".go";
        PsiFile file = directory.findFile(fileName);
        String packageName = ((GoDeclarationInfoModel)((Object)this.myModel)).getPackageName();
        GoFile goFile = file instanceof GoFile ? (GoFile)file : (targetFile = file == null ? GoRefactoringUtil.createFile(directory, ((GoDeclarationInfoModel)((Object)this.myModel)).getFileName() + ".go", packageName, this.myProject) : null);
        if (targetFile == null) {
            this.showErrorHint(GoBundle.message((String)"go.refactoring.failed.to.create.file.for.package.error.message", (Object[])new Object[]{fileName, packageName}));
            return null;
        }
        return targetFile;
    }

    @Nullable
    private PsiDirectory findOrCreateDirectory() {
        String directoryPath = ((GoDeclarationInfoModel)((Object)this.myModel)).getDirectoryPath();
        VirtualFile virtualFile = VirtualFileManager.getInstance().getFileSystem(((GoDeclarationInfoModel)((Object)this.myModel)).getProtocol()).findFileByPath(directoryPath);
        if (virtualFile == null) {
            virtualFile = this.mkdirs();
        }
        if (virtualFile != null) {
            return PsiManager.getInstance((Project)this.myProject).findDirectory(virtualFile);
        }
        return null;
    }

    @Nullable
    private VirtualFile mkdirs() {
        String directoryPath = ((GoDeclarationInfoModel)((Object)this.myModel)).getDirectoryPath();
        int i = directoryPath.indexOf(47);
        if (i >= 0) {
            String rootPath = directoryPath.substring(0, i + 1);
            VirtualFile root = VirtualFileManager.getInstance().getFileSystem(((GoDeclarationInfoModel)((Object)this.myModel)).getProtocol()).findFileByPath(rootPath);
            if (root != null) {
                try {
                    String relativePath = directoryPath.substring(i + 1);
                    return VfsUtil.createDirectoryIfMissing((VirtualFile)root, (String)relativePath);
                }
                catch (IOException e) {
                    this.getLog().warn("Failed to find or create the directory", (Throwable)e);
                }
            }
        }
        return null;
    }

    private void showErrorHint(@NotNull @Nls String message) {
        if (message == null) {
            GoRefactoringProcessorBase.$$$reportNull$$$0(4);
        }
        this.getLog().warn(message);
        CommonRefactoringUtil.showErrorHint((Project)this.myProject, null, (String)message, (String)this.getCommandName(), null);
    }

    protected void changeDeclarationsVisibility(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            GoRefactoringProcessorBase.$$$reportNull$$$0(5);
        }
        for (GoNamedElement goNamedElement : ((GoDeclarationInfoModel)((Object)this.myModel)).getDeclarationsToChangeVisibility()) {
            String oldName = goNamedElement.getName();
            if (oldName == null) continue;
            String newName = goNamedElement.isPublic() ? StringUtil.decapitalize((String)oldName) : StringUtil.capitalize((String)oldName);
            goNamedElement.setName(newName);
        }
        for (GoNamedElement goNamedElement : usages) {
            String newName;
            if (!(goNamedElement instanceof GoRenameUsageInfo) || (newName = ((GoRenameUsageInfo)((Object)goNamedElement)).getDeclaration().getName()) == null) continue;
            RenameUtil.rename((UsageInfo)goNamedElement, (String)newName);
        }
    }

    @NotNull
    protected abstract Logger getLog();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/goide/refactor/GoRefactoringProcessorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPreviewUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorHint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "changeDeclarationsVisibility";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

