/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.changeSignature;

import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoResult;
import com.goide.psi.GoSignature;
import com.goide.psi.GoType;
import com.goide.refactor.changeSignature.GoChangeSignatureDialog;
import com.goide.refactor.changeSignature.GoChangeSignatureUsageProcessor;
import com.goide.refactor.changeSignature.GoMethodChangeInfo;
import com.goide.refactor.changeSignature.GoMethodDescriptor;
import com.goide.refactor.changeSignature.GoParameterInfo;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoChangeSignatureBuilder {
    private final Project myProject;
    private final GoNamedSignatureOwner myMethod;
    private final GoSignature mySignature;
    private String myNewMethodName;
    private List<GoParameterInfo> myParameters;
    private List<GoParameterInfo> myResultParameters;
    private GoCompositeElement myLocationToSkip;
    private int myActiveTabIndex;
    private boolean myRefactorImplementations;
    private boolean myReuseTypes;

    @Contract(pure=true)
    private GoChangeSignatureBuilder(@NotNull GoNamedSignatureOwner method) {
        if (method == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(0);
        }
        this.myProject = method.getProject();
        this.myMethod = method;
        this.mySignature = Objects.requireNonNull(method.getSignature());
        this.myNewMethodName = StringUtil.notNullize((String)method.getName());
        this.myParameters = GoChangeSignatureBuilder.getParameters(this.mySignature);
        this.myResultParameters = GoChangeSignatureBuilder.getResultParameters(this.mySignature);
        this.myReuseTypes = GoChangeSignatureBuilder.reusesTypes(this.mySignature);
    }

    public static boolean reusesTypes(@NotNull GoSignature signature) {
        if (signature == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(1);
        }
        return GoChangeSignatureBuilder.reuseTypes(signature.getParameters()) || GoChangeSignatureBuilder.reuseTypes((GoParameters)ObjectUtils.doIfNotNull((Object)signature.getResult(), GoResult::getParameters));
    }

    private static boolean reuseTypes(@Nullable GoParameters parameters) {
        return parameters != null && StreamEx.of(parameters.getParameterDeclarationList()).map(GoParameterDeclaration::getParamDefinitionList).map(List::size).anyMatch(size -> size > 1);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static GoChangeSignatureBuilder create(@NotNull GoNamedSignatureOwner method) {
        if (method == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(2);
        }
        return new GoChangeSignatureBuilder(method);
    }

    @Contract(value="_ -> this")
    @NotNull
    public GoChangeSignatureBuilder withNewMethodName(@NotNull String newMethodName) {
        if (newMethodName == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(3);
        }
        this.myNewMethodName = newMethodName;
        GoChangeSignatureBuilder goChangeSignatureBuilder = this;
        if (goChangeSignatureBuilder == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(4);
        }
        return goChangeSignatureBuilder;
    }

    @Contract(value="_ -> this")
    @NotNull
    public GoChangeSignatureBuilder withParameters(GoParameterInfo ... parameters) {
        GoChangeSignatureBuilder goChangeSignatureBuilder = this.withParameters((List<GoParameterInfo>)new SmartList((Object[])parameters));
        if (goChangeSignatureBuilder == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(5);
        }
        return goChangeSignatureBuilder;
    }

    @Contract(value="_ -> this")
    @NotNull
    public GoChangeSignatureBuilder withParameters(@NotNull List<GoParameterInfo> parameters) {
        if (parameters == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(6);
        }
        this.myParameters = parameters;
        GoChangeSignatureBuilder goChangeSignatureBuilder = this;
        if (goChangeSignatureBuilder == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(7);
        }
        return goChangeSignatureBuilder;
    }

    @Contract(value="_ -> this")
    @NotNull
    public GoChangeSignatureBuilder withResultParameters(GoParameterInfo ... resultParameters) {
        GoChangeSignatureBuilder goChangeSignatureBuilder = this.withResultParameters((List<GoParameterInfo>)new SmartList((Object[])resultParameters));
        if (goChangeSignatureBuilder == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(8);
        }
        return goChangeSignatureBuilder;
    }

    @Contract(value="_ -> this")
    @NotNull
    public GoChangeSignatureBuilder withResultParameters(@NotNull List<GoParameterInfo> resultParameters) {
        if (resultParameters == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(9);
        }
        this.myResultParameters = resultParameters;
        GoChangeSignatureBuilder goChangeSignatureBuilder = this;
        if (goChangeSignatureBuilder == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(10);
        }
        return goChangeSignatureBuilder;
    }

    @Contract(value="_ -> this")
    @NotNull
    public GoChangeSignatureBuilder withLocationToSkip(@Nullable GoCompositeElement locationToSkip) {
        this.myLocationToSkip = locationToSkip;
        GoChangeSignatureBuilder goChangeSignatureBuilder = this;
        if (goChangeSignatureBuilder == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(11);
        }
        return goChangeSignatureBuilder;
    }

    @Contract(value="_ -> this")
    @NotNull
    public GoChangeSignatureBuilder withActiveTab(int index) {
        this.myActiveTabIndex = index;
        GoChangeSignatureBuilder goChangeSignatureBuilder = this;
        if (goChangeSignatureBuilder == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(12);
        }
        return goChangeSignatureBuilder;
    }

    @Contract(value="_ -> this")
    @NotNull
    public GoChangeSignatureBuilder refactorImplementations(boolean refactorImplementations) {
        this.myRefactorImplementations = refactorImplementations;
        GoChangeSignatureBuilder goChangeSignatureBuilder = this;
        if (goChangeSignatureBuilder == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(13);
        }
        return goChangeSignatureBuilder;
    }

    @Contract(value="_ -> this")
    @NotNull
    public GoChangeSignatureBuilder reuseTypes(boolean reuseTypes) {
        this.myReuseTypes = reuseTypes;
        GoChangeSignatureBuilder goChangeSignatureBuilder = this;
        if (goChangeSignatureBuilder == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(14);
        }
        return goChangeSignatureBuilder;
    }

    @VisibleForTesting
    @NotNull
    @Contract(value="_ -> new")
    GoChangeSignatureDialog dialog(@Nullable Disposable parent) {
        GoChangeSignatureDialog dialog = new GoChangeSignatureDialog(this.createMethodDescriptor());
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)dialog.getDisposable());
        }
        dialog.setNewMethodName(this.myNewMethodName);
        dialog.setActiveTab(this.myActiveTabIndex);
        GoChangeSignatureDialog goChangeSignatureDialog = dialog;
        if (goChangeSignatureDialog == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(15);
        }
        return goChangeSignatureDialog;
    }

    public void show() {
        this.dialog(null).show();
    }

    public void run() {
        GoParameterInfo[] parameters = this.myParameters.toArray(GoParameterInfo.EMPTY_ARRAY);
        GoParameterInfo[] resultParameters = this.myResultParameters.toArray(GoParameterInfo.EMPTY_ARRAY);
        new GoChangeSignatureDialog.GoChangeSignatureProcessor(this.myProject, this.createMethodDescriptor(), this.myNewMethodName, parameters, resultParameters).run();
    }

    public void processPrimaryMethod() {
        GoMethodChangeInfo changeInfo = new GoMethodChangeInfo(this.createMethodDescriptor(), this.myNewMethodName, this.myParameters.toArray(GoParameterInfo.EMPTY_ARRAY), GoChangeSignatureBuilder.getResultParameters(this.mySignature).toArray(GoParameterInfo.EMPTY_ARRAY));
        new GoChangeSignatureUsageProcessor().processPrimaryMethod(changeInfo);
    }

    private GoMethodDescriptor createMethodDescriptor() {
        GoMethodDescriptor descriptor = new GoMethodDescriptor(this.myMethod, this.mySignature, this.myParameters, this.myResultParameters, this.myLocationToSkip, this.myRefactorImplementations, GoChangeSignatureBuilder.reusesTypes(this.mySignature));
        descriptor.setReuseTypes(this.myReuseTypes);
        return descriptor;
    }

    @NotNull
    public static List<GoParameterInfo> getParameters(@NotNull GoSignature signature) {
        if (signature == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(16);
        }
        return GoChangeSignatureBuilder.getInfos(signature.getParameters());
    }

    @NotNull
    public static List<GoParameterInfo> getResultParameters(@NotNull GoSignature signature) {
        GoResult result;
        if (signature == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(17);
        }
        if ((result = signature.getResult()) != null) {
            GoParameters parameters = result.getParameters();
            if (parameters != null) {
                return GoChangeSignatureBuilder.getInfos(parameters);
            }
            GoType type = result.getType();
            if (type != null) {
                return new SmartList((Object)new GoParameterInfo(0, type, false));
            }
        }
        return new SmartList();
    }

    @NotNull
    private static List<GoParameterInfo> getInfos(@NotNull GoParameters parameters) {
        if (parameters == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(18);
        }
        SmartList infos = new SmartList();
        for (GoParameterDeclaration declaration : parameters.getParameterDeclarationList()) {
            List<GoParamDefinition> definitions = declaration.getParamDefinitionList();
            if (definitions.isEmpty()) {
                infos.add(new GoParameterInfo(declaration));
                continue;
            }
            for (GoParamDefinition definition : definitions) {
                infos.add(new GoParameterInfo(definition));
            }
        }
        SmartList smartList = infos;
        if (smartList == null) {
            GoChangeSignatureBuilder.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8, 10, 11, 12, 13, 14, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMethodName";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/changeSignature/GoChangeSignatureBuilder";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/changeSignature/GoChangeSignatureBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withNewMethodName";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withParameters";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withResultParameters";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withLocationToSkip";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withActiveTab";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "refactorImplementations";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "reuseTypes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "dialog";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reusesTypes";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withNewMethodName";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withParameters";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withResultParameters";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getResultParameters";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInfos";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8, 10, 11, 12, 13, 14, 15, 19 -> new IllegalStateException(string);
        };
    }
}

