/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.move;

import com.goide.go.GoGotoUtil;
import com.goide.go.GoSuperMethodSearch;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoDuplicatesSearch;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoConstDeclaration;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoIotaUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.refactor.move.GoMoveUsageInfo;
import com.goide.refactor.ui.GoDeclarationDependencyGraph;
import com.goide.refactor.ui.GoDeclarationInfo;
import com.goide.refactor.util.GoRefactoringUtil;
import com.google.common.base.Predicates;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class GoMoveDeclarationDependencyGraph
extends GoDeclarationDependencyGraph {
    private List<GoCompositeElement> myDeclarationsToMoveRefined;
    private MultiMap<GoNamedElement, GoNamedElement> myDependencies;

    GoMoveDeclarationDependencyGraph(@NotNull List<GoDeclarationInfo> infos) {
        if (infos == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(0);
        }
        super(infos);
    }

    @TestOnly
    GoMoveDeclarationDependencyGraph(@NotNull String protocol, @NotNull List<GoDeclarationInfo> infos) {
        if (protocol == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(1);
        }
        if (infos == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(2);
        }
        super(protocol, infos);
    }

    @Override
    protected UsageInfo @NotNull [] findUsages() {
        HashSet usages = ContainerUtil.newHashSet((Object[])super.findUsages());
        this.getInfosToRefactor().forEach(info -> {
            GoNamedElement declaration = info.getDeclaration();
            if (!(declaration instanceof GoMethodDeclaration) && this.isNotFromTargetPackage(declaration.getContainingFile())) {
                for (PsiReference reference : info.findReferences()) {
                    if (this.willBeMoved(reference.getElement())) continue;
                    usages.add(new GoMoveUsageInfo(reference));
                }
            }
        });
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NotNull MultiMap<PsiElement, @Nls String> getConflictsInternal(@NotNull GoDeclarationInfo info) {
        if (info == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(4);
        }
        @Nls MultiMap conflicts = MultiMap.createLinkedSet();
        GoNamedElement declaration = info.getDeclaration();
        String name = declaration.getName();
        if (info.isToRefactor()) {
            GoConstDeclaration constant;
            List<GoConstSpec> iotaDefinitions;
            Object spec;
            if (declaration instanceof GoFunctionDeclaration) {
                if ("init".equals(name) && !info.isToChangeVisibility()) {
                    conflicts.putValue((Object)declaration, (Object)GoBundle.message((String)"go.refactoring.move.affect.initialization.order.validation.message", (Object[])new Object[]{GoRefactoringUtil.htmlEmphasize(declaration)}));
                }
            } else if (declaration instanceof GoVarDefinition) {
                spec = (GoVarSpec)declaration.getParent();
                List<GoVarDefinition> definitions = spec.getDefinitionList();
                List<GoExpression> expressions = spec.getExpressionList();
                if (definitions.size() != expressions.size() && definitions.stream().anyMatch(Predicates.not(this::willBeMoved))) {
                    for (GoVarDefinition definition2 : definitions) {
                        conflicts.putValue((Object)definition2, (Object)GoBundle.message((String)"go.refactoring.move.break.initialization.validation.message", (Object[])new Object[]{GoRefactoringUtil.htmlEmphasize(declaration), GoRefactoringUtil.htmlEmphasize(definition2)}));
                    }
                }
            } else if (declaration instanceof GoConstDefinition && (iotaDefinitions = GoMoveDeclarationDependencyGraph.collectIotaSpecs(constant = (GoConstDeclaration)(spec = (GoConstSpec)declaration.getParent()).getParent())).contains(spec) && (constant.getSpecList().size() != iotaDefinitions.size() || iotaDefinitions.stream().anyMatch(Predicates.not(this::willBeMoved)))) {
                ((StreamEx)StreamEx.of(iotaDefinitions).skip(1L)).flatCollection(GoConstSpec::getDefinitionList).forEach(definition -> conflicts.putValue(definition, (Object)GoBundle.message((String)"go.refactoring.move.value.will.change.validation.message", (Object[])new Object[]{GoRefactoringUtil.htmlEmphasize(definition), CommonRefactoringUtil.htmlEmphasize((String)"iota")})));
            }
            if (this.isNotFromTargetDirectoryOrPackage(declaration)) {
                if (!info.isExported()) {
                    for (PsiReference reference2 : info.findReferences()) {
                        PsiElement usage = reference2.getElement();
                        if (this.willBeMoved(usage)) continue;
                        this.checkWillBeAccessible((MultiMap<PsiElement, String>)conflicts, declaration, usage);
                    }
                }
                if (declaration instanceof GoVarOrConstDefinition) {
                    GoExpression expression;
                    SmartList additionalUsages = new SmartList();
                    GoType type = ((GoVarOrConstSpec)declaration.getParent()).getType();
                    if (type != null) {
                        ContainerUtil.addIfNotNull((Collection)additionalUsages, (Object)type.getTypeReferenceExpression());
                    }
                    if ((expression = ((GoVarOrConstDefinition)declaration).findExpression()) != null) {
                        additionalUsages.addAll(GoRefactoringUtil.collectReferencesToNamedElements(expression));
                    }
                    Iterator iterator = additionalUsages.iterator();
                    while (iterator.hasNext()) {
                        GoReferenceExpressionBase usage = (GoReferenceExpressionBase)iterator.next();
                        PsiElement usageDeclaration = usage.resolve();
                        if (!(usageDeclaration instanceof GoNamedElement) || this.isExported((GoNamedElement)usageDeclaration) || this.willBeMoved(usageDeclaration)) continue;
                        this.checkWillBeAccessible((MultiMap<PsiElement, String>)conflicts, usageDeclaration, usage, declaration);
                    }
                }
                for (GoReferenceExpressionBase usage : GoRefactoringUtil.collectReferencesToNamedElements(declaration)) {
                    PsiElement usageDeclaration = usage.resolve();
                    if (!(usageDeclaration instanceof GoNamedElement) || this.isExported((GoNamedElement)usageDeclaration) || this.willBeMoved(usageDeclaration)) continue;
                    this.checkWillBeAccessible((MultiMap<PsiElement, String>)conflicts, usageDeclaration, usage);
                }
                if (declaration instanceof GoTypeSpec) {
                    GoTypeSpec typeSpec = (GoTypeSpec)declaration;
                    for (GoNamedSignatureOwner goNamedSignatureOwner : typeSpec.getMethods()) {
                        if (this.willBeMoved(goNamedSignatureOwner)) continue;
                        conflicts.putValue((Object)goNamedSignatureOwner, (Object)GoMoveDeclarationDependencyGraph.getNonLocalMessage(typeSpec, goNamedSignatureOwner));
                    }
                    GoType type = typeSpec.getSpecType().getType();
                    if (type instanceof GoStructType) {
                        for (GoFieldDeclaration fieldDeclaration : ((GoStructType)type).getFieldDeclarationList()) {
                            for (GoFieldDefinition fieldDefinition : fieldDeclaration.getFieldDefinitionList()) {
                                if (this.isExported(fieldDefinition)) continue;
                                GoReferencesSearch.search(fieldDefinition, fieldDefinition.getUseScope()).asIterable().forEach(reference -> {
                                    PsiElement usage = reference.getElement();
                                    if (!this.willBeMoved(usage)) {
                                        this.checkWillBeAccessible((MultiMap<PsiElement, String>)conflicts, fieldDefinition, usage);
                                    }
                                });
                            }
                        }
                    }
                } else if (declaration instanceof GoMethodDeclaration) {
                    GoMethodDeclaration method = (GoMethodDeclaration)declaration;
                    GoTypeSpec typeSpec = method.resolveTypeSpec();
                    if (typeSpec != null && !this.willBeMoved(typeSpec)) {
                        conflicts.putValue((Object)typeSpec, (Object)GoMoveDeclarationDependencyGraph.getNonLocalMessage(typeSpec, method));
                    }
                } else if (declaration instanceof GoFunctionDeclaration && GoPsiUtil.isMainFunction(declaration) && !this.myPackageName.equals("main")) {
                    String main = GoRefactoringUtil.htmlEmphasize(declaration);
                    conflicts.putValue((Object)declaration, (Object)GoBundle.message((String)"go.refactoring.move.function.will.not.start.application.validation.message", (Object[])new Object[]{main, main}));
                }
                if (name != null && !(declaration instanceof GoMethodDeclaration)) {
                    this.findDuplicateConflicts(name, declaration.getManager(), (Processor<? super GoDuplicatesSearch.Duplicate>)((Processor)holder -> {
                        GoNamedElement duplicate = holder.duplicatedElement;
                        conflicts.putValue((Object)duplicate, (Object)GoMoveDeclarationDependencyGraph.getRedeclareMessage(declaration, duplicate));
                        return true;
                    }));
                }
            }
        }
        if (info.isToChangeVisibility()) {
            if (declaration instanceof GoMethodDeclaration) {
                GoMethodDeclaration method = (GoMethodDeclaration)declaration;
                GoTypeSpec typeSpec = method.resolveTypeSpec();
                if (typeSpec != null) {
                    GoSuperMethodSearch.GO_SUPER_METHOD_SEARCH.execute(GoGotoUtil.param(method), methodSpec -> {
                        GoTypeSpec anInterface = (GoTypeSpec)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)methodSpec, GoTypeSpec.class);
                        if (anInterface != null) {
                            conflicts.putValue((Object)anInterface, (Object)GoBundle.message((String)"go.refactoring.move.type.will.not.implement.interface.validation.message", (Object[])new Object[]{GoRefactoringUtil.htmlEmphasize(typeSpec), GoRefactoringUtil.htmlEmphasize(anInterface)}));
                        }
                        return true;
                    });
                }
            } else if (declaration instanceof GoFunctionDeclaration) {
                if (GoPsiUtil.isMainFunction(declaration)) {
                    conflicts.putValue((Object)declaration, (Object)GoBundle.message((String)"go.refactoring.move.exported.function.will.not.start.application.validation.message", (Object[])new Object[]{GoRefactoringUtil.htmlEmphasize(declaration)}));
                } else if (GoPsiUtil.isInitFunction(declaration)) {
                    conflicts.putValue((Object)declaration, (Object)GoBundle.message((String)"go.refactoring.move.exported.function.will.not.perform.initialization.validation.message", (Object[])new Object[]{GoRefactoringUtil.htmlEmphasize(declaration)}));
                }
            }
        }
        MultiMap multiMap = conflicts;
        if (multiMap == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(5);
        }
        return multiMap;
    }

    private static List<GoConstSpec> collectIotaSpecs(GoConstDeclaration constant) {
        List<GoExpression> expressions;
        int i;
        int fromIndex;
        List<GoConstSpec> specs = constant.getSpecList();
        int toIndex = fromIndex = specs.size();
        for (i = 0; i < specs.size(); ++i) {
            GoConstSpec spec = specs.get(i);
            if (!ContainerUtil.exists(spec.getExpressionList(), GoIotaUtil::containsIota)) continue;
            fromIndex = i;
            break;
        }
        i = specs.size() - 1;
        while (i > fromIndex && !(expressions = specs.get(i).getExpressionList()).isEmpty() && !ContainerUtil.exists(expressions, GoIotaUtil::containsIota)) {
            toIndex = i--;
        }
        return fromIndex < toIndex ? specs.subList(fromIndex, toIndex) : Collections.emptyList();
    }

    private boolean willBeMoved(@NotNull PsiElement element) {
        if (element == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(6);
        }
        for (GoCompositeElement declaration : this.getDeclarationsToMoveRefined()) {
            if (PsiTreeUtil.isAncestor((PsiElement)declaration, (PsiElement)element, (boolean)false)) {
                return true;
            }
            if (!(declaration instanceof GoVarOrConstDefinition) || !PsiTreeUtil.isAncestor((PsiElement)((GoVarOrConstDefinition)declaration).findExpression(), (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Nls
    private static String getNonLocalMessage(@NotNull GoTypeSpec typeSpec, @NotNull GoNamedSignatureOwner method) {
        if (typeSpec == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(7);
        }
        if (method == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(8);
        }
        String string = GoBundle.message((String)"go.refactoring.move.type.will.become.non.local.for.method.validation.message", (Object[])new Object[]{GoRefactoringUtil.htmlEmphasize(typeSpec), GoRefactoringUtil.htmlEmphasize(method)});
        if (string == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String getRedeclareMessage(@NotNull GoNamedElement declaration, @NotNull GoNamedElement duplicate) {
        if (declaration == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(10);
        }
        if (duplicate == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(11);
        }
        String type = UsageViewUtil.getType((PsiElement)declaration);
        String name = StringUtil.notNullize((String)declaration.getName());
        String string = GoRefactoringUtil.getRedeclareMessage(type, name, duplicate);
        if (string == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    List<GoCompositeElement> getDeclarationsToMoveRefined() {
        if (this.myDeclarationsToMoveRefined == null) {
            this.myDeclarationsToMoveRefined = new ArrayList<GoCompositeElement>();
            Deque toProcess = (Deque)this.getInfosToRefactor().map(GoDeclarationInfo::getDeclaration).select(GoCompositeElement.class).toCollection(ArrayDeque::new);
            while (!toProcess.isEmpty()) {
                List<Object> specs;
                GoTopLevelDeclaration declaration;
                GoCompositeElement element2 = (GoCompositeElement)toProcess.peek();
                if (element2 instanceof GoVarOrConstDefinition) {
                    GoVarOrConstSpec spec = (GoVarOrConstSpec)element2.getParent();
                    List definitions = spec.getDefinitionList();
                    if (toProcess.containsAll(definitions)) {
                        toProcess.removeAll(definitions);
                        toProcess.add(spec);
                        continue;
                    }
                } else if (element2 instanceof GoVarOrConstSpec) {
                    declaration = (GoVarOrConstDeclaration)element2.getParent();
                    specs = declaration.getSpecList();
                    if (toProcess.containsAll(specs)) {
                        toProcess.removeAll(specs);
                        toProcess.add(declaration);
                        continue;
                    }
                } else if (element2 instanceof GoTypeSpec && toProcess.containsAll(specs = (declaration = (GoTypeDeclaration)element2.getParent()).getTypeSpecList())) {
                    toProcess.removeAll(specs);
                    toProcess.add(declaration);
                    continue;
                }
                toProcess.remove(element2);
                this.myDeclarationsToMoveRefined.add(element2);
            }
            ContainerUtil.sort(this.myDeclarationsToMoveRefined, Comparator.comparing(element -> element.getTextRange().getStartOffset()));
        }
        List<GoCompositeElement> list = this.myDeclarationsToMoveRefined;
        if (list == null) {
            GoMoveDeclarationDependencyGraph.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    public void memberChanged(GoDeclarationInfo info) {
        super.memberChanged(info);
        this.myDeclarationsToMoveRefined = null;
    }

    @Override
    protected synchronized void invalidateCaches() {
        super.invalidateCaches();
        this.myDependencies = null;
    }

    @Override
    public Set<? extends GoNamedElement> getDependent() {
        return this.getDependencies().keySet();
    }

    @Override
    public Set<? extends GoNamedElement> getDependenciesOf(GoNamedElement declaration) {
        return (Set)this.getDependencies().get((Object)declaration);
    }

    private synchronized MultiMap<GoNamedElement, ? extends GoNamedElement> getDependencies() {
        if (this.myDependencies == null) {
            MultiMap dependencies = MultiMap.createLinkedSet();
            for (GoDeclarationInfo info : this.myInfos.values()) {
                if (!info.isToRefactor() && !info.isToChangeVisibility()) continue;
                GoNamedElement declaration = info.getDeclaration();
                block1: for (PsiElement dependent : this.getConflicts(info).keySet()) {
                    PsiReference reference = dependent.getReference();
                    if (reference != null) {
                        PsiElement element = reference.resolve();
                        if (element instanceof GoFieldDefinition) {
                            element = PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, GoTypeSpec.class);
                        }
                        if (element != declaration && element instanceof GoNamedElement && this.myInfos.containsKey(element)) {
                            dependencies.putValue((Object)((GoNamedElement)element), (Object)declaration);
                            continue;
                        }
                    }
                    while (dependent != null && dependent != declaration && !(dependent instanceof GoFile)) {
                        if (dependent instanceof GoNamedElement && this.myInfos.containsKey(dependent)) {
                            dependencies.putValue((Object)((GoNamedElement)dependent), (Object)declaration);
                            continue block1;
                        }
                        dependent = dependent.getParent();
                    }
                }
            }
            this.myDependencies = dependencies;
        }
        return this.myDependencies;
    }

    @Override
    @Nullable
    public String getTooltip(GoDeclarationInfo info) {
        Set<? extends GoNamedElement> dependencies;
        MultiMap<PsiElement, String> conflicts;
        @NlsContexts.Tooltip StringBuilder builder = new StringBuilder();
        if ((info.isToRefactor() || info.isToChangeVisibility()) && !(conflicts = this.getConflicts(info)).isEmpty()) {
            for (String conflict : conflicts.values()) {
                builder.append(conflict).append('\n');
            }
        }
        if (!(dependencies = this.getDependenciesOf(info.getDeclaration())).isEmpty()) {
            builder.append(GoBundle.message((String)"go.refactoring.move.required.by.validation.message", (Object[])new Object[]{StringUtil.join(dependencies, NavigationItem::getName, (String)", ")}));
        }
        return StringUtil.nullize((String)builder.toString().trim());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 9, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/move/GoMoveDeclarationDependencyGraph";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSpec";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/move/GoMoveDeclarationDependencyGraph";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictsInternal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonLocalMessage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedeclareMessage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsToMoveRefined";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConflictsInternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "willBeMoved";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNonLocalMessage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRedeclareMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 9, 12, 13 -> new IllegalStateException(string);
        };
    }
}

