/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.move;

import com.goide.documentation.GoDocumentationProvider;
import com.goide.formatter.GoFormatterUtil;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.refactor.GoRefactoringProcessorBase;
import com.goide.refactor.move.GoMoveDeclarationInfoModel;
import com.goide.refactor.move.GoMoveUsageInfo;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.refactor.util.GoReferenceConverter;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GoMoveDeclarationProcessor
extends GoRefactoringProcessorBase<GoMoveDeclarationInfoModel> {
    private static final Logger LOG = Logger.getInstance(GoMoveDeclarationProcessor.class);

    GoMoveDeclarationProcessor(@NotNull Project project, @NotNull GoMoveDeclarationInfoModel model, boolean openInEditor) {
        if (project == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(1);
        }
        super(project, model, openInEditor);
    }

    protected UsageInfo @NotNull [] findUsages() {
        UsageInfo[] usageInfoArray = ((GoMoveDeclarationInfoModel)this.myModel).findUsages();
        if (usageInfoArray == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(3);
        }
        return new BaseUsageViewDescriptor((PsiElement[])((GoMoveDeclarationInfoModel)this.myModel).getDeclarationsToRefactor());
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        GoFile targetFile;
        if (usages == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(4);
        }
        if ((targetFile = this.prepareFile()) == null) {
            return;
        }
        for (GoCompositeElement declaration : ((GoMoveDeclarationInfoModel)this.myModel).getDeclarationsToMoveRefined()) {
            if (declaration instanceof GoTopLevelDeclaration || declaration instanceof GoTypeSpec || declaration instanceof GoVarSpec || declaration instanceof GoConstSpec || declaration instanceof GoVarDefinition || declaration instanceof GoConstDefinition) continue;
            LOG.error("Unexpected declaration of type " + declaration.getClass().getName());
            return;
        }
        this.changeDeclarationsVisibility(usages);
        this.moveDeclarationsAndOpenInEditor(targetFile, usages);
    }

    private void moveDeclarationsAndOpenInEditor(@NotNull GoFile targetFile, UsageInfo @NotNull [] usages) {
        if (targetFile == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(5);
        }
        if (usages == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(6);
        }
        HashSet filesToOptimizeImports = ContainerUtil.newHashSet((Object[])new GoFile[]{targetFile});
        List<GoCompositeElement> declarations = ((GoMoveDeclarationInfoModel)this.myModel).getDeclarationsToMoveRefined();
        boolean opened = false;
        for (GoCompositeElement declaration : declarations) {
            GoCompositeElement copy = this.copyDeclarationImportingReferences(declaration, targetFile);
            PsiElement addedElement = GoMoveDeclarationProcessor.addWithComments(declaration, copy, targetFile);
            if (!this.myOpenInEditor || opened || !addedElement.isValid()) continue;
            opened = true;
            ApplicationManager.getApplication().invokeLater(() -> EditorHelper.openInEditor((PsiElement)addedElement));
        }
        filesToOptimizeImports.addAll(GoMoveDeclarationProcessor.updateMoveUsages(targetFile, usages));
        for (GoCompositeElement declaration : declarations) {
            filesToOptimizeImports.add((GoFile)declaration.getContainingFile());
            GoMoveDeclarationProcessor.deleteDeclarationWithComments(declaration);
        }
        GoRefactoringUtil.optimizeImports(filesToOptimizeImports);
    }

    @NotNull
    private GoCompositeElement copyDeclarationImportingReferences(@NotNull GoCompositeElement declaration, @NotNull GoFile context) {
        GoCompositeElement copy;
        if (declaration == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(7);
        }
        if (context == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(8);
        }
        List<GoCompositeElement> declarations = ((GoMoveDeclarationInfoModel)this.myModel).getDeclarationsToMoveRefined();
        Object text = GoReferenceConverter.on(declaration, context).withElementsToSkip(declarations).getText();
        if (declaration instanceof GoVarOrConstDefinition) {
            GoExpression expression;
            GoType type = ((GoVarOrConstSpec)declaration.getParent()).getType();
            if (type != null) {
                text = (String)text + " " + GoReferenceConverter.on(type, context).withElementsToSkip(declarations).getText();
            }
            if ((expression = ((GoVarOrConstDefinition)declaration).findExpression()) != null) {
                text = (String)text + " = " + GoReferenceConverter.on(expression, context).withElementsToSkip(declarations).getText();
            }
        }
        if ((copy = declaration instanceof GoVarSpec || declaration instanceof GoVarDefinition ? GoElementFactory.createVarDeclaration(this.myProject, (String)text) : (declaration instanceof GoConstSpec || declaration instanceof GoConstDefinition ? GoElementFactory.createConstDeclaration(this.myProject, (String)text) : (declaration instanceof GoTypeSpec ? (GoCompositeElement)GoElementFactory.createElement(this.myProject, "package main\ntype " + (String)text, GoTypeDeclaration.class) : (GoCompositeElement)GoElementFactory.createElement(this.myProject, "package main\n" + (String)text, declaration.getClass())))) == null) {
            throw new RuntimeExceptionWithAttachments("Unable to re-create element of class " + declaration.getClass().getName() + " after importing references", new Attachment[]{GoInspectionUtil.createAttachment(declaration), new Attachment("fragment.go", (String)text)});
        }
        GoVarDeclaration goVarDeclaration = copy;
        if (goVarDeclaration == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(9);
        }
        return goVarDeclaration;
    }

    private static PsiElement addWithComments(@NotNull GoCompositeElement commentsHolder, @NotNull GoCompositeElement toAdd, @NotNull GoFile file) {
        if (commentsHolder == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(10);
        }
        if (toAdd == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(11);
        }
        if (file == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(12);
        }
        GoMoveDeclarationProcessor.copyBeforeDeclarationSpaces(commentsHolder, file);
        if (commentsHolder instanceof GoTopLevelDeclaration) {
            GoMoveDeclarationProcessor.addCommentsIfNotEmpty(GoDocumentationProvider.getUpperComments(commentsHolder), file);
            file.add(GoElementFactory.createNewLine(commentsHolder.getProject()));
        }
        PsiElement element = file.add(toAdd);
        GoFormatterUtil.reformat(element);
        GoMoveDeclarationProcessor.addCommentsIfNotEmpty(GoDocumentationProvider.getAfterComments(commentsHolder), file);
        GoMoveDeclarationProcessor.copyAfterDeclarationSpaces(commentsHolder, file);
        return element;
    }

    private static void copyBeforeDeclarationSpaces(@NotNull GoCompositeElement commentsHolder, @NotNull GoFile file) {
        PsiElement spaces;
        PsiElement spacesHolder;
        if (commentsHolder == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(13);
        }
        if (file == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(14);
        }
        if (commentsHolder == (spacesHolder = PsiTreeUtil.getNonStrictParentOfType((PsiElement)commentsHolder, (Class[])new Class[]{GoTopLevelDeclaration.class}))) {
            spacesHolder = (PsiElement)ObjectUtils.notNull((Object)((PsiElement)ContainerUtil.getFirstItem(GoDocumentationProvider.getUpperComments(commentsHolder))), (Object)spacesHolder);
        }
        if ((spaces = Objects.requireNonNull(spacesHolder).getPrevSibling()) instanceof PsiWhiteSpace) {
            file.add(spaces.copy());
        }
    }

    private static void addCommentsIfNotEmpty(@NotNull List<PsiComment> comments, @NotNull GoFile file) {
        if (comments == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(15);
        }
        if (file == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(16);
        }
        if (!comments.isEmpty()) {
            file.addRange((PsiElement)ContainerUtil.getFirstItem(comments), (PsiElement)ContainerUtil.getLastItem(comments));
        }
    }

    private static void copyAfterDeclarationSpaces(@NotNull GoCompositeElement commentsHolder, @NotNull GoFile file) {
        PsiElement spaces;
        PsiElement spacesHolder;
        if (commentsHolder == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(17);
        }
        if (file == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(18);
        }
        if (commentsHolder == (spacesHolder = PsiTreeUtil.getNonStrictParentOfType((PsiElement)commentsHolder, (Class[])new Class[]{GoTopLevelDeclaration.class}))) {
            spacesHolder = (PsiElement)ObjectUtils.notNull((Object)((PsiElement)ContainerUtil.getLastItem(GoDocumentationProvider.getAfterComments(commentsHolder))), (Object)spacesHolder);
        }
        if ((spaces = Objects.requireNonNull(spacesHolder).getNextSibling()) instanceof PsiWhiteSpace) {
            file.add(spaces.copy());
        }
    }

    private static Set<GoFile> updateMoveUsages(@NotNull GoFile targetFile, UsageInfo @NotNull [] usages) {
        if (targetFile == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(19);
        }
        if (usages == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(20);
        }
        String targetFileImportPath = GoMoveDeclarationProcessor.getImportPath(targetFile);
        String targetFilePackageName = targetFile.getPackageName();
        if (targetFileImportPath == null || targetFilePackageName == null) {
            return Collections.emptySet();
        }
        HashSet<GoFile> updatedFiles = new HashSet<GoFile>();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof GoMoveUsageInfo)) continue;
            ProgressManager.checkCanceled();
            GoFile file = GoMoveDeclarationProcessor.updateExpression(usage.getElement(), targetFilePackageName, targetFileImportPath);
            ContainerUtil.addIfNotNull(updatedFiles, (Object)((Object)file));
        }
        return updatedFiles;
    }

    @Nullable(value="if expression is not updated")
    static @Nullable(value="if expression is not updated") GoFile updateExpression(@Nullable PsiElement element, @NotNull String targetPackageName, @NotNull String targetImportPath) {
        GoExpression newExpression;
        GoReferenceExpressionBase expression;
        if (targetPackageName == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(21);
        }
        if (targetImportPath == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(22);
        }
        if ((expression = (GoReferenceExpressionBase)ObjectUtils.tryCast((Object)element, GoReferenceExpressionBase.class)) == null) {
            return null;
        }
        GoFile file = (GoFile)((Object)ObjectUtils.tryCast((Object)expression.getContainingFile(), GoFile.class));
        if (file == null) {
            return null;
        }
        String text = GoReferenceConverter.on(expression, file).withPackageNameAndImportPath(targetPackageName, targetImportPath).getText();
        if (expression instanceof GoTypeReferenceExpression) {
            GoType type = GoElementFactory.createType(expression.getProject(), text, null);
            newExpression = Objects.requireNonNull(type.getTypeReferenceExpression());
        } else {
            newExpression = GoElementFactory.createExpression(expression.getProject(), text);
        }
        expression.replace(newExpression);
        return file;
    }

    @Nullable
    private static String getImportPath(@NotNull GoFile file) {
        if (file == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(23);
        }
        return file.getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)file));
    }

    private static void deleteDeclarationWithComments(@NotNull GoCompositeElement toDelete) {
        if (toDelete == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(24);
        }
        if (toDelete instanceof GoVarOrConstDefinition) {
            GoVarOrConstSpec spec = (GoVarOrConstSpec)toDelete.getParent();
            spec.deleteDefinition((GoVarOrConstDefinition)toDelete);
        } else if (toDelete instanceof GoVarOrConstSpec) {
            GoVarOrConstDeclaration declaration = (GoVarOrConstDeclaration)toDelete.getParent();
            declaration.deleteSpec((GoVarOrConstSpec)toDelete);
        } else if (toDelete instanceof GoTypeSpec) {
            GoTypeDeclaration declaration = (GoTypeDeclaration)toDelete.getParent();
            declaration.deleteTypeSpec((GoTypeSpec)toDelete);
        } else {
            GoDocumentationProvider.getCommentsForElement(toDelete).stream().filter(PsiElement::isPhysical).forEach(PsiElement::delete);
            toDelete.delete();
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"move.title");
        if (string == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Override
    @NotNull
    protected Logger getLog() {
        Logger logger = LOG;
        if (logger == null) {
            GoMoveDeclarationProcessor.$$$reportNull$$$0(26);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 9: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/move/GoMoveDeclarationProcessor";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentsHolder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPackageName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetImportPath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/move/GoMoveDeclarationProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDeclarationImportingReferences";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 9: 
            case 25: 
            case 26: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "moveDeclarationsAndOpenInEditor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyDeclarationImportingReferences";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addWithComments";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyBeforeDeclarationSpaces";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addCommentsIfNotEmpty";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyAfterDeclarationSpaces";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateMoveUsages";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateExpression";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getImportPath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "deleteDeclarationWithComments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9, 25, 26 -> new IllegalStateException(string);
        };
    }
}

