/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.rename;

import com.goide.codeInsight.GoCodeInsightSettings;
import com.goide.i18n.GoBundle;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.ThreeState;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public final class GoRenameDirectoryProcessor
extends RenamePsiFileProcessor {
    @VisibleForTesting
    public static final Key<Boolean> TESTING_RENAME_PACKAGE = Key.create((String)"GoRenameDirectoryProcessor.TESTING_RENAME_PACKAGE");

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            GoRenameDirectoryProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PsiDirectory;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        String newPackageName;
        PsiDirectory directory;
        Project project;
        block11: {
            block10: {
                if (element == null) {
                    GoRenameDirectoryProcessor.$$$reportNull$$$0(1);
                }
                if (newName == null) {
                    GoRenameDirectoryProcessor.$$$reportNull$$$0(2);
                }
                if (allRenames == null) {
                    GoRenameDirectoryProcessor.$$$reportNull$$$0(3);
                }
                if (scope == null) {
                    GoRenameDirectoryProcessor.$$$reportNull$$$0(4);
                }
                super.prepareRenaming(element, newName, allRenames, scope);
                project = element.getProject();
                if (!(element instanceof PsiDirectory)) break block10;
                directory = (PsiDirectory)element;
                if (GoSdkService.getInstance(project).isGoModule(GoUtil.module(element))) break block11;
            }
            return;
        }
        String oldName = directory.getName();
        String oldPackageName = GoPsiImplUtil.sanitizePackageName(directory.getName());
        if (GoRenameDirectoryProcessor.shouldAddPackageToRename(directory, oldPackageName, newPackageName = GoPsiImplUtil.sanitizePackageName(newName))) {
            allRenames.put((PsiElement)GoPackage.in(directory, oldPackageName).toPsi(project), newPackageName);
        }
        if ("vendor".equals(newName) || "vendor".equals(oldName)) {
            for (PsiElement file : element.getChildren()) {
                if (!(file instanceof PsiDirectory)) continue;
                allRenames.put(file, ((PsiDirectory)file).getName());
            }
        }
    }

    private static boolean shouldAddPackageToRename(@NotNull PsiDirectory directory, @NotNull String oldPackageName, @NotNull String newPackageName) {
        if (directory == null) {
            GoRenameDirectoryProcessor.$$$reportNull$$$0(5);
        }
        if (oldPackageName == null) {
            GoRenameDirectoryProcessor.$$$reportNull$$$0(6);
        }
        if (newPackageName == null) {
            GoRenameDirectoryProcessor.$$$reportNull$$$0(7);
        }
        if (oldPackageName.equals(newPackageName)) {
            return false;
        }
        if (!GoPackageUtil.getAllPackagesInDirectory(directory, null, true).contains(oldPackageName)) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TestModeFlags.is(TESTING_RENAME_PACKAGE);
        }
        ThreeState renameDirectoryOption = GoCodeInsightSettings.getInstance().getRenamePackageOnDirectoryRenaming();
        if (renameDirectoryOption != ThreeState.UNSURE) {
            return renameDirectoryOption.toBoolean();
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)RefactoringBundle.message((String)"rename.title"), (String)GoBundle.message((String)"go.refactoring.rename.package.title", (Object[])new Object[]{oldPackageName, newPackageName})).doNotAsk((DoNotAskOption)new RenamePackageDoNotAskOption())).icon(Messages.getQuestionIcon())).ask(directory.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPackageName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPackageName";
                break;
            }
        }
        objectArray2[1] = "com/goide/refactor/rename/GoRenameDirectoryProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldAddPackageToRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RenamePackageDoNotAskOption
    extends DoNotAskOption.Adapter {
        private RenamePackageDoNotAskOption() {
        }

        public void rememberChoice(boolean isSelected, int exitCode) {
            if (isSelected) {
                GoCodeInsightSettings.getInstance().setRenamePackageOnDirectoryRenaming(ThreeState.fromBoolean((exitCode == 0 ? 1 : 0) != 0));
            }
        }
    }
}

