/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.rename;

import com.goide.codeInsight.GoCodeInsightSettings;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoPackageClause;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.imports.GoImportPathReference;
import com.goide.refactor.rename.GoRenamePsiElementProcessor;
import com.goide.sdk.GoPackageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class GoRenamePackageProcessor
extends GoRenamePsiElementProcessor {
    @VisibleForTesting
    public static final Key<Boolean> TESTING_RENAME_DIRECTORY = Key.create((String)"GoRenamePackageProcessor.TESTING_RENAME_DIRECTORY");

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof GoPackageClause || GoPackageUtil.isGoPackage(element);
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        GoPackage aPackage;
        if (element == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(4);
        }
        if ((aPackage = GoPackageUtil.unwrapGoPackage(element)) == null) {
            return;
        }
        for (PsiDirectory directory : aPackage.getPsiDirectories()) {
            if (!directory.getName().equals(aPackage.getName()) || !GoRenamePackageProcessor.shouldAddDirectoryToRename(aPackage, directory)) continue;
            allRenames.put((PsiElement)directory, FileUtil.sanitizeFileName((String)newName));
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(6);
        }
        Collection references = super.findReferences(element, searchScope, searchInCommentsAndStrings);
        Collection collection = GoPackageUtil.isGoPackage(element) ? ContainerUtil.filter((Collection)references, r -> !(r instanceof GoImportPathReference)) : references;
        if (collection == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(8);
        }
        if (element instanceof GoPackageClause) {
            PsiDirectory directory = element.getContainingFile().getContainingDirectory();
            String packageName = ((GoPackageClause)element).getName();
            return packageName != null && directory != null && directory.isValid() ? GoPackage.in(directory, packageName).toPsi(element.getProject()) : null;
        }
        return super.substituteElementToRename(element, editor);
    }

    @Override
    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(9);
        }
        return GoCodeInsightSettings.getInstance().isRenameSearchInCommentsForPackage();
    }

    @Override
    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(10);
        }
        GoCodeInsightSettings.getInstance().setRenameSearchInCommentsForPackage(enabled);
    }

    @Override
    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(11);
        }
        return GoCodeInsightSettings.getInstance().isRenameSearchNonCodeForPackage();
    }

    @Override
    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(12);
        }
        GoCodeInsightSettings.getInstance().setRenameSearchNonCodeForPackage(enabled);
    }

    private static boolean shouldAddDirectoryToRename(@NotNull GoPackage aPackage, @NotNull PsiDirectory directory) {
        if (aPackage == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(13);
        }
        if (directory == null) {
            GoRenamePackageProcessor.$$$reportNull$$$0(14);
        }
        String directoryName = directory.getName();
        if (!aPackage.getName().equals(directoryName)) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TestModeFlags.is(TESTING_RENAME_DIRECTORY);
        }
        ThreeState renameDirectoryOption = GoCodeInsightSettings.getInstance().getRenameDirectoryOnPackageRenaming();
        if (renameDirectoryOption != ThreeState.UNSURE) {
            return renameDirectoryOption.toBoolean();
        }
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)RefactoringBundle.message((String)"rename.title"), (String)GoBundle.message((String)"go.refactoring.rename.directory.message", (Object[])new Object[]{directoryName})).doNotAsk((DoNotAskOption)new RenameDirectoryDoNotAskOption())).icon(Messages.getQuestionIcon())).ask(directory.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/rename/GoRenamePackageProcessor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/rename/GoRenamePackageProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddDirectoryToRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private static class RenameDirectoryDoNotAskOption
    extends DoNotAskOption.Adapter {
        private RenameDirectoryDoNotAskOption() {
        }

        public void rememberChoice(boolean isSelected, int exitCode) {
            if (isSelected) {
                GoCodeInsightSettings.getInstance().setRenameDirectoryOnPackageRenaming(ThreeState.fromBoolean((exitCode == 0 ? 1 : 0) != 0));
            }
        }
    }
}

