/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.rename;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.refactor.rename.GoRenamePsiElementProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiElementProcessorBase;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class GoRenameReceiverProcessor
extends GoRenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance(GoRenameReceiverProcessor.class);
    private boolean renameOneReceiver;
    private static String ourTestingRenameMode;

    @TestOnly
    public static void setTestingRenameMode(@NotNull String mode, @NotNull Disposable disposable) {
        if (mode == null) {
            GoRenameReceiverProcessor.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            GoRenameReceiverProcessor.$$$reportNull$$$0(1);
        }
        ourTestingRenameMode = mode;
        Disposer.register((Disposable)disposable, () -> {
            Objects.requireNonNull((GoRenameReceiverProcessor)((Object)((Object)RenamePsiElementProcessorBase.EP_NAME.findExtension(GoRenameReceiverProcessor.class)))).renameOneReceiver = false;
            ourTestingRenameMode = null;
        });
    }

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            GoRenameReceiverProcessor.$$$reportNull$$$0(2);
        }
        return element instanceof GoReceiver;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            GoRenameReceiverProcessor.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            GoRenameReceiverProcessor.$$$reportNull$$$0(4);
        }
        if (allRenames == null) {
            GoRenameReceiverProcessor.$$$reportNull$$$0(5);
        }
        if (this.renameOneReceiver) {
            return;
        }
        GoReceiver receiver = (GoReceiver)ObjectUtils.tryCast((Object)element, GoReceiver.class);
        GoTypeSpec typeSpec = GoPsiImplUtil.getTypeSpecFromReceiver(receiver);
        if (typeSpec == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot rename receiver: type is not found", new Object[]{element.getText(), element.getClass().getSimpleName()});
            }
            return;
        }
        Project project = (Project)ReadAction.compute(() -> ((PsiElement)element).getProject());
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            List<GoMethodDeclaration> methods = typeSpec.getMethods();
            for (GoMethodDeclaration decl : methods) {
                GoReceiver methodReceiver = decl.getReceiver();
                if (methodReceiver == null) continue;
                allRenames.put(methodReceiver, newName);
            }
        }), GoBundle.message((String)"go.refactoring.rename.looking.for.method.usages.progress.title", (Object[])new Object[0]), true, project);
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<? super PsiElement> renameCallback) {
        GoTypeSpec typeSpec;
        if (element == null) {
            GoRenameReceiverProcessor.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            GoRenameReceiverProcessor.$$$reportNull$$$0(7);
        }
        if (renameCallback == null) {
            GoRenameReceiverProcessor.$$$reportNull$$$0(8);
        }
        if ((typeSpec = GoPsiImplUtil.getTypeSpecFromReceiver((GoTypeOwner)ObjectUtils.tryCast((Object)element, GoReceiver.class))) == null || typeSpec.getMethods().size() <= 1) {
            this.renameOneReceiver = true;
            renameCallback.accept((Object)element);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.debug("Rename methods of typeSpec: " + String.valueOf(typeSpec) + "; rename mode: " + ourTestingRenameMode);
            this.renameOneReceiver = GoRenameReceiverProcessor.getRenameOneReceiverMode().equals(ourTestingRenameMode);
            renameCallback.accept((Object)element);
            return;
        }
        if (StartMarkAction.canStart((Editor)editor) != null) {
            renameCallback.accept((Object)element);
            return;
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder(Arrays.asList(GoRenameReceiverProcessor.getRenameAllReceiversMode(), GoRenameReceiverProcessor.getRenameOneReceiverMode())).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(value -> {
            this.renameOneReceiver = GoRenameReceiverProcessor.getRenameOneReceiverMode().equals(value);
            renameCallback.accept((Object)element);
        }).createPopup().showInBestPositionFor(editor);
    }

    @NotNull
    public static String getRenameOneReceiverMode() {
        String string = GoBundle.message((String)"go.refactoring.rename.current.receiver.option", (Object[])new Object[0]);
        if (string == null) {
            GoRenameReceiverProcessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getRenameAllReceiversMode() {
        String string = GoBundle.message((String)"go.refactoring.rename.all.receivers.option", (Object[])new Object[0]);
        if (string == null) {
            GoRenameReceiverProcessor.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/rename/GoRenameReceiverProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/rename/GoRenameReceiverProcessor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenameOneReceiverMode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenameAllReceiversMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTestingRenameMode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }
}

