/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.rename;

import com.goide.inspections.tag.GoTagFieldNameStyle;
import com.goide.inspections.tag.GoTagUtil;
import com.goide.psi.GoTag;
import com.goide.psi.impl.GoElementFactory;
import com.goide.refactor.rename.GoRenameFieldDefinitionProcessorKt;
import com.goide.refactor.rename.GoRenamePsiElementProcessor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.NameUtilCore;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/goide/refactor/rename/GoRenameTagProcessor;", "Lcom/goide/refactor/rename/GoRenamePsiElementProcessor;", "<init>", "()V", "renameElement", "", "element", "Lcom/intellij/psi/PsiElement;", "newName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "canProcessElement", "", "replaceTagValue", "value", "mergeWordsWithCase", "guessedName", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoRenameTagProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoRenameTagProcessor.kt\ncom/goide/refactor/rename/GoRenameTagProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class GoRenameTagProcessor
extends GoRenamePsiElementProcessor {
    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        List list = (List)element.getUserData(GoRenameFieldDefinitionProcessorKt.getTAG_VALUES_TO_REPLACE());
        if (list == null) {
            return;
        }
        List tagValuesToReplace = list;
        if (tagValuesToReplace.isEmpty()) {
            return;
        }
        element.putUserData(GoRenameFieldDefinitionProcessorKt.getTAG_VALUES_TO_REPLACE(), null);
        List<Pair<String, String>> list2 = GoTagUtil.getEntries((GoTag)element);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getEntries(...)");
        String newTagContent = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)" ", null, null, (int)0, null, arg_0 -> GoRenameTagProcessor.renameElement$lambda$1(tagValuesToReplace, this, newName, arg_0), (int)30, null);
        PsiElement p0 = GoElementFactory.createTag(((GoTag)element).getProject(), newTagContent);
        boolean bl = false;
        element.replace(p0);
    }

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof GoTag;
    }

    private final String replaceTagValue(String value, String newName) {
        String string;
        CharSequence charSequence = value;
        Regex regex = GoRenameFieldDefinitionProcessorKt.getTAG_VALUE_NORMALIZATION_REGEX();
        String string2 = "";
        String processedValue = regex.replace(charSequence, string2);
        Object object = GoTagFieldNameStyle.guessStyle(value);
        if (object == null || (object = ((GoTagFieldNameStyle)object).apply(newName)) == null) {
            return null;
        }
        Object guessedName = object;
        if (StringUtil.isUpperCase((CharSequence)processedValue)) {
            String string3 = ((String)guessedName).toUpperCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        } else if (StringUtil.isLowerCase((CharSequence)processedValue)) {
            String string4 = ((String)guessedName).toLowerCase(Locale.ROOT);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = this.mergeWordsWithCase(processedValue, (String)guessedName);
        }
        return string;
    }

    private final String mergeWordsWithCase(String value, String guessedName) {
        Object[] objectArray = NameUtilCore.nameToWords((String)value);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"nameToWords(...)");
        Object[] valueWords = objectArray;
        Object[] objectArray2 = NameUtilCore.nameToWords((String)guessedName);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"nameToWords(...)");
        Object[] guessedNameWords = objectArray2;
        if (valueWords.length != guessedNameWords.length) {
            return guessedName;
        }
        return CollectionsKt.joinToString$default((Iterable)ArraysKt.zip((Object[])valueWords, (Object[])guessedNameWords), (CharSequence)"", null, null, (int)0, null, GoRenameTagProcessor::mergeWordsWithCase$lambda$2, (int)30, null);
    }

    private static final CharSequence renameElement$lambda$1$lambda$0(List $tagValuesToReplace, GoRenameTagProcessor this$0, String $newName, String it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($tagValuesToReplace.contains(it)) {
            String string = this$0.replaceTagValue(it, $newName);
            if (string == null) {
                string = it;
            }
            charSequence = string;
        } else {
            charSequence = it;
        }
        return charSequence;
    }

    private static final CharSequence renameElement$lambda$1(List $tagValuesToReplace, GoRenameTagProcessor this$0, String $newName, Pair entry) {
        String key = (String)entry.first;
        Object object = entry.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        char[] cArray = new char[]{','};
        List value = StringsKt.split$default((CharSequence)StringsKt.removeSurrounding((String)((String)object), (CharSequence)"\""), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String updatedValue = CollectionsKt.joinToString$default((Iterable)value, (CharSequence)",", null, null, (int)0, null, arg_0 -> GoRenameTagProcessor.renameElement$lambda$1$lambda$0($tagValuesToReplace, this$0, $newName, arg_0), (int)30, null);
        return key + ":\"" + updatedValue + "\"";
    }

    private static final CharSequence mergeWordsWithCase$lambda$2(kotlin.Pair pair) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String valueWord = (String)pair.component1();
        String guessedWord = (String)pair.component2();
        if (StringUtil.isUpperCase((CharSequence)valueWord)) {
            Intrinsics.checkNotNull((Object)guessedWord);
            String string = guessedWord.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            charSequence = string;
        } else if (StringUtil.isLowerCase((CharSequence)valueWord)) {
            Intrinsics.checkNotNull((Object)guessedWord);
            String string = guessedWord.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            charSequence = string;
        } else {
            Intrinsics.checkNotNull((Object)guessedWord);
            charSequence = guessedWord;
        }
        return charSequence;
    }
}

