/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.template;

import com.goide.codeInsight.imports.GoImport;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.template.GoTemplate;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0006"}, d2={"setupConstCaseClauses", "", "Lcom/goide/refactor/template/GoTemplate;", "constDefinitions", "", "Lcom/goide/psi/GoConstDefinition;", "intellij.go.impl"})
public final class GoTemplateExtentionsKt {
    public static final void setupConstCaseClauses(@NotNull GoTemplate $this$setupConstCaseClauses, @NotNull List<? extends GoConstDefinition> constDefinitions) {
        Intrinsics.checkNotNullParameter((Object)$this$setupConstCaseClauses, (String)"<this>");
        Intrinsics.checkNotNullParameter(constDefinitions, (String)"constDefinitions");
        Map newImports = new LinkedHashMap();
        Iterator iterator = ((Iterable)constDefinitions).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            GoFile definitionFile;
            int index = n++;
            GoConstDefinition constDefinition = (GoConstDefinition)iterator.next();
            $this$setupConstCaseClauses.getTemplate().addTextSegment("case ");
            Intrinsics.checkNotNullExpressionValue((Object)((Object)constDefinition.getContainingFile()), (String)"getContainingFile(...)");
            if (!GoUtil.isDirectlyAccessible((PsiFile)definitionFile, (PsiFile)$this$setupConstCaseClauses.getFilePointer().getElement())) {
                String string;
                String pkgImportPath;
                GoFile file;
                if (definitionFile.getPackageName() == null || definitionFile.getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)definitionFile)) == null || (GoFile)$this$setupConstCaseClauses.getFilePointer().getElement() == null) continue;
                GoImportSpec importSpec = file.getImportedPackagesMap().get(pkgImportPath);
                if (importSpec == null) {
                    GoImport goImport;
                    String pkgName;
                    if (file.getImportMap().containsKey((Object)pkgName)) {
                        String suggestedName;
                        GoImportSpec newSpec;
                        Intrinsics.checkNotNullExpressionValue((Object)GoElementFactory.createImportSpec((PsiFile)file, pkgImportPath, null), (String)"createImportSpec(...)");
                        LinkedHashSet<String> linkedHashSet = GoNameSuggestionProvider.getSuggestedNames(newSpec, (PsiElement)file);
                        Intrinsics.checkNotNullExpressionValue(linkedHashSet, (String)"getSuggestedNames(...)");
                        if ((String)CollectionsKt.first((Iterable)linkedHashSet) == null) continue;
                        goImport = new GoImport(pkgImportPath, suggestedName);
                    } else {
                        goImport = new GoImport(pkgImportPath);
                    }
                    GoImport goImport2 = goImport;
                    newImports.put(pkgImportPath, goImport2);
                    string = goImport2.getAlias();
                    if (string == null) {
                        string = pkgName;
                    }
                } else {
                    Set<String> set = GoPsiImplUtil.getImportQualifiersToUseInFile(importSpec);
                    Intrinsics.checkNotNullExpressionValue(set, (String)"getImportQualifiersToUseInFile(...)");
                    string = (String)CollectionsKt.firstOrNull((Iterable)set);
                    if (string == null) continue;
                }
                String qualifier = string;
                $this$setupConstCaseClauses.getTemplate().addTextSegment(qualifier + ".");
            }
            $this$setupConstCaseClauses.getTemplate().addTextSegment(constDefinition.getIdentifier().getText());
            $this$setupConstCaseClauses.getTemplate().addTextSegment(":");
            if (index == 0) {
                $this$setupConstCaseClauses.getTemplate().addEndVariable();
            }
            if (index == CollectionsKt.getLastIndex(constDefinitions)) continue;
            $this$setupConstCaseClauses.getTemplate().addTextSegment("\n");
        }
        $this$setupConstCaseClauses.addImports(CollectionsKt.toSet((Iterable)newImports.values()));
    }
}

