/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.download;

import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdk;
import com.goide.sdk.combobox.GoBasedSdkChooserCombo;
import com.goide.sdk.combobox.GoSdkChooserCombo;
import com.goide.sdk.download.GoDownloadSdkAction;
import com.goide.sdk.download.GoDownloadSdkQueryService;
import com.goide.sdk.download.GoDownloadingSdk;
import com.goide.sdk.download.GoSdkDownloaderDialog;
import com.google.gson.JsonSyntaxException;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J*\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00170\u0016H\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/goide/sdk/download/GoDownloadSdkActionFactory;", "", "<init>", "()V", "versionCache", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/goide/sdk/download/GoDownloadSdkActionFactory$Cache;", "kotlin.jvm.PlatformType", "recommendedVersionCache", "createGoSdkDownloadAction", "Lcom/goide/sdk/download/GoDownloadSdkAction;", "Lcom/goide/sdk/GoSdk;", "projectPathSupplier", "Ljava/util/function/Supplier;", "", "combo", "Lcom/goide/sdk/combobox/GoSdkChooserCombo;", "initFromCache", "", "versions", "", "versionsConsumer", "Ljava/util/function/Consumer;", "", "GoDownloadDialog", "Cache", "intellij.go.impl"})
public final class GoDownloadSdkActionFactory {
    @NotNull
    public static final GoDownloadSdkActionFactory INSTANCE = new GoDownloadSdkActionFactory();
    @NotNull
    private static final AtomicReference<Cache> versionCache = new AtomicReference<Cache>(new Cache("", "", SetsKt.emptySet()));
    @NotNull
    private static final AtomicReference<Cache> recommendedVersionCache = new AtomicReference<Cache>(new Cache("", "", SetsKt.emptySet()));

    private GoDownloadSdkActionFactory() {
    }

    @JvmStatic
    @NotNull
    public static final GoDownloadSdkAction<GoSdk> createGoSdkDownloadAction(@NotNull Supplier<String> projectPathSupplier, @NotNull GoSdkChooserCombo combo) {
        Intrinsics.checkNotNullParameter(projectPathSupplier, (String)"projectPathSupplier");
        Intrinsics.checkNotNullParameter((Object)((Object)combo), (String)"combo");
        GoBasedSdkChooserCombo goBasedSdkChooserCombo = combo;
        GoSdkDownloaderDialog goSdkDownloaderDialog = new GoDownloadDialog(combo.getProject());
        Comparator<String> comparator = VersionComparatorUtil.COMPARATOR.reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reversed(...)");
        return new GoDownloadSdkAction<GoSdk>(projectPathSupplier, goBasedSdkChooserCombo, goSdkDownloaderDialog, comparator);
    }

    private final void initFromCache(Set<String> versions, Consumer<Collection<String>> versionsConsumer) {
        if (!versions.isEmpty()) {
            versionsConsumer.accept(versions);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/goide/sdk/download/GoDownloadSdkActionFactory$Cache;", "", "os", "", "arch", "versions", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getOs", "()Ljava/lang/String;", "getArch", "getVersions", "()Ljava/util/Set;", "intellij.go.impl"})
    private static final class Cache {
        @NotNull
        private final String os;
        @NotNull
        private final String arch;
        @NotNull
        private final Set<String> versions;

        public Cache(@NotNull String os, @NotNull String arch, @NotNull Set<String> versions) {
            Intrinsics.checkNotNullParameter((Object)os, (String)"os");
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            Intrinsics.checkNotNullParameter(versions, (String)"versions");
            this.os = os;
            this.arch = arch;
            Set<String> set = Collections.unmodifiableSet(versions);
            Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(...)");
            this.versions = set;
        }

        @NotNull
        public final String getOs() {
            return this.os;
        }

        @NotNull
        public final String getArch() {
            return this.arch;
        }

        @NotNull
        public final Set<String> getVersions() {
            return this.versions;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\f0\t\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J<\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00180\u0017H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/goide/sdk/download/GoDownloadSdkActionFactory$GoDownloadDialog;", "Lcom/goide/sdk/download/GoSdkDownloaderDialog;", "Lcom/goide/sdk/GoSdk;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createDownloadingSdk", "version", "", "path", "getTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "Lcom/intellij/openapi/util/NlsSafe;", "getProgressIconName", "discoverVersions", "", "os", "arch", "includeAll", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "versionsConsumer", "Ljava/util/function/Consumer;", "", "intellij.go.impl"})
    @SourceDebugExtension(value={"SMAP\nGoDownloadSdkActionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDownloadSdkActionFactory.kt\ncom/goide/sdk/download/GoDownloadSdkActionFactory$GoDownloadDialog\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n40#2,3:102\n25#3:105\n*S KotlinDebug\n*F\n+ 1 GoDownloadSdkActionFactory.kt\ncom/goide/sdk/download/GoDownloadSdkActionFactory$GoDownloadDialog\n*L\n71#1:102,3\n86#1:105\n*E\n"})
    private static final class GoDownloadDialog
    implements GoSdkDownloaderDialog<GoSdk> {
        @Nullable
        private final Project project;

        public GoDownloadDialog(@Nullable Project project) {
            this.project = project;
        }

        @Override
        @NotNull
        public GoSdk createDownloadingSdk(@NotNull String version, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new GoDownloadingSdk(version, path);
        }

        @Override
        @NotNull
        public String getTitle() {
            String string = GoBundle.message((String)"go.settings.sdk.download.dialog.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        @NotNull
        public String getProgressIconName() {
            String string = GoBundle.message((String)"go.settings.sdk.download.dialog.progress.versions.status", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        public boolean discoverVersions(@NotNull String os, @NotNull String arch, boolean includeAll, @NotNull ProgressIndicator progressIndicator, @NotNull Consumer<Collection<String>> versionsConsumer) {
            Intrinsics.checkNotNullParameter((Object)os, (String)"os");
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            Intrinsics.checkNotNullParameter(versionsConsumer, (String)"versionsConsumer");
            AtomicReference cache = includeAll ? versionCache : recommendedVersionCache;
            Cache cacheValue = (Cache)cache.get();
            Set versions = new HashSet(cacheValue.getVersions());
            if (Intrinsics.areEqual((Object)cacheValue.getOs(), (Object)os) && Intrinsics.areEqual((Object)cacheValue.getArch(), (Object)arch)) {
                INSTANCE.initFromCache(versions, versionsConsumer);
            }
            try {
                boolean $i$f$service = false;
                Class<GoDownloadSdkQueryService> serviceClass$iv = GoDownloadSdkQueryService.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                Collection<String> queriedVersions = new GoDownloadSdkQueryService.QueryExecutor((GoDownloadSdkQueryService)object, this.project, progressIndicator).getVersionsForPlatform(os, arch, includeAll);
                Set recentlyDiscoveredVersions = new HashSet();
                for (String version : queriedVersions) {
                    progressIndicator.checkCanceled();
                    if (!versions.add(version)) continue;
                    recentlyDiscoveredVersions.add(version);
                }
                versionsConsumer.accept(recentlyDiscoveredVersions);
            }
            catch (Exception ex) {
                Exception exception = ex;
                if (exception instanceof JsonSyntaxException || exception instanceof IOException) {
                    GoDownloadDialog $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(GoDownloadDialog.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info((Throwable)ex);
                    return false;
                }
                throw ex;
            }
            cache.set(new Cache(os, arch, versions));
            return true;
        }
    }
}

