/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.download;

import com.goide.vgo.EnvironmentVariable;
import com.goide.vgo.VgoUtilKt;
import com.goide.vgo.configuration.VgoEnvironmentVariable;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0012\u0010\u0003\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"REGULAR_URL", "", "CHINESE_URL", "getBaseUrl", "project", "Lcom/intellij/openapi/project/Project;", "isInMainlandChina", "", "getFileExtension", "os", "intellij.go.impl"})
public final class GoDownloadSdkQueryServiceKt {
    @NotNull
    private static final String REGULAR_URL = "https://go.dev/dl";
    @NotNull
    private static final String CHINESE_URL = "https://golang.google.cn/dl";

    private static final String getBaseUrl(Project project) {
        return GoDownloadSdkQueryServiceKt.isInMainlandChina(project) ? CHINESE_URL : REGULAR_URL;
    }

    private static final boolean isInMainlandChina(Project project) {
        Regex chineseGoProxyRegex = new Regex("^(https://[^,]+\\.cn)(,direct)?$");
        String string = VgoEnvironmentVariable.GOPROXY.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        EnvironmentVariable goProxy = VgoUtilKt.getVariableFromEnvironment(project, string);
        Object object = goProxy;
        boolean useChineseGoProxy = object != null && (object = ((EnvironmentVariable)object).getValue()) != null ? chineseGoProxyRegex.matches((CharSequence)object) : false;
        return useChineseGoProxy || VgoUtilKt.isMainlandChinaRegion();
    }

    @NotNull
    public static final String getFileExtension(@NotNull String os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        return Intrinsics.areEqual((Object)"windows", (Object)os) ? ".zip" : ".tar.gz";
    }

    public static final /* synthetic */ String access$getBaseUrl(Project project) {
        return GoDownloadSdkQueryServiceKt.getBaseUrl(project);
    }
}

