/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.download;

import com.goide.i18n.GoBundle;
import com.goide.sdk.GoBasedSdk;
import com.goide.sdk.GoSdk;
import com.goide.sdk.combobox.GoSdkList;
import com.goide.sdk.download.GoBasedDownloadingSdk;
import com.goide.sdk.download.GoDownloadSdkQueryService;
import com.goide.sdk.download.GoDownloadingSdk;
import com.goide.sdk.download.GoSdkDownloader;
import com.goide.sdk.download.GoSdkProperties;
import com.goide.sdk.download.MyDownloadUnpackSdkStrings;
import com.google.gson.JsonSyntaxException;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.DigestUtilKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\b\u0001\u0018\u0000 \u001e2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0013H\u0014J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0002H\u0014R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lcom/goide/sdk/download/GoDownloadSdkService;", "Lcom/goide/sdk/download/GoSdkDownloader;", "Lcom/goide/sdk/GoSdk;", "Lcom/goide/sdk/download/GoDownloadingSdk;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "doDownload", "", "project", "Lcom/intellij/openapi/project/Project;", "fileName", "", "downloadedFile", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "verifyChecksum", "", "sdk", "properties", "Lcom/goide/sdk/download/GoSdkProperties;", "silent", "registerDownloadedSdk", "downloadedSdk", "downloadingSdks", "", "getDownloadingSdks", "()Ljava/util/Set;", "Companion", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoDownloadSdkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDownloadSdkService.kt\ncom/goide/sdk/download/GoDownloadSdkService\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,110:1\n40#2,3:111\n40#2,3:114\n*S KotlinDebug\n*F\n+ 1 GoDownloadSdkService.kt\ncom/goide/sdk/download/GoDownloadSdkService\n*L\n32#1:111,3\n46#1:114,3\n*E\n"})
public final class GoDownloadSdkService
extends GoSdkDownloader<GoSdk, GoDownloadingSdk> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public GoDownloadSdkService(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Function1 function1 = 1.INSTANCE;
        GoSdk goSdk = GoSdk.NULL;
        Intrinsics.checkNotNullExpressionValue((Object)goSdk, (String)"NULL");
        super(cs, function1, (GoBasedSdk)goSdk, new MyDownloadUnpackSdkStrings());
    }

    @Override
    protected void doDownload(@NotNull Project project, @NotNull String fileName, @NotNull Path downloadedFile, @NotNull ProgressIndicator indicator) throws IOException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)downloadedFile, (String)"downloadedFile");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        boolean $i$f$service = false;
        Class<GoDownloadSdkQueryService> serviceClass$iv = GoDownloadSdkQueryService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        GoDownloadSdkQueryService.QueryExecutor queryExecutor = (GoDownloadSdkQueryService)object.new GoDownloadSdkQueryService.QueryExecutor(project, indicator);
        File file = downloadedFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        queryExecutor.downloadGoSdkArchive$intellij_go_impl(fileName, file);
    }

    @Override
    protected boolean verifyChecksum(@NotNull Project project, @NotNull GoDownloadingSdk sdk, @NotNull ProgressIndicator indicator, @NotNull GoSdkProperties properties, @NotNull Path downloadedFile, boolean silent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)downloadedFile, (String)"downloadedFile");
        indicator.setText(GoBundle.message((String)"go.settings.sdk.download.progress.verifying.status", (Object[])new Object[0]));
        indicator.setIndeterminate(true);
        try {
            boolean $i$f$service = false;
            Class<GoDownloadSdkQueryService> serviceClass$iv = GoDownloadSdkQueryService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            String expectedChecksum = (GoDownloadSdkQueryService)object.new GoDownloadSdkQueryService.QueryExecutor(project, indicator).getChecksum(properties);
            if (expectedChecksum == null) {
                return false;
            }
            String actualChecksum = DigestUtilKt.sha256Hex((Path)downloadedFile);
            if (!Intrinsics.areEqual((Object)expectedChecksum, (Object)actualChecksum)) {
                if (!silent) {
                    GoBasedDownloadingSdk goBasedDownloadingSdk = sdk;
                    String string = GoBundle.message((String)"go.settings.sdk.download.checksum.of.downloaded.file.mismatched.error", (Object[])new Object[0]);
                    String string2 = "Expected: %s. Actual: %s";
                    Object[] objectArray = new Object[]{expectedChecksum, actualChecksum};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    this.error(project, goBasedDownloadingSdk, string, null, string3);
                }
                return false;
            }
        }
        catch (Exception ex) {
            Exception exception = ex;
            if (exception instanceof IOException || exception instanceof JsonSyntaxException) {
                if (!silent) {
                    Object[] objectArray = new Object[]{((Object)downloadedFile).toString()};
                    this.error(project, (GoBasedDownloadingSdk)sdk, GoBundle.message((String)"go.settings.sdk.download.could.not.get.checksum.error", (Object[])objectArray), ex, null);
                }
                return false;
            }
            throw ex;
        }
        return true;
    }

    @Override
    protected void registerDownloadedSdk(@NotNull GoSdk downloadedSdk2) {
        Intrinsics.checkNotNullParameter((Object)downloadedSdk2, (String)"downloadedSdk");
        GoSdkList.getInstance().addSdk(downloadedSdk2);
    }

    @NotNull
    public final Set<GoDownloadingSdk> getDownloadingSdks() {
        Set<GoDownloadingSdk> set = Collections.unmodifiableSet(this.getMyDownloadingSdks());
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(...)");
        return set;
    }

    @NotNull
    public static final GoDownloadSdkService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/goide/sdk/download/GoDownloadSdkService$Companion;", "", "<init>", "()V", "instance", "Lcom/goide/sdk/download/GoDownloadSdkService;", "getInstance$annotations", "getInstance", "()Lcom/goide/sdk/download/GoDownloadSdkService;", "intellij.go.impl"})
    @SourceDebugExtension(value={"SMAP\nGoDownloadSdkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDownloadSdkService.kt\ncom/goide/sdk/download/GoDownloadSdkService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,110:1\n40#2,3:111\n*S KotlinDebug\n*F\n+ 1 GoDownloadSdkService.kt\ncom/goide/sdk/download/GoDownloadSdkService$Companion\n*L\n88#1:111,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GoDownloadSdkService getInstance() {
            boolean $i$f$service = false;
            Class<GoDownloadSdkService> serviceClass$iv = GoDownloadSdkService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (GoDownloadSdkService)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

