/*
 * Decompiled with CFR 0.152.
 */
package com.goide.terminal;

import com.goide.GoConstants;
import com.goide.GoEnvironmentUtil;
import com.goide.GoOsManager;
import com.goide.execution.GoWslUtil;
import com.goide.execution.extension.GoExecutorExtension;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;

public final class GoLocalTerminalCustomizer
extends LocalTerminalCustomizer {
    private static final Logger LOG = Logger.getInstance(GoLocalTerminalCustomizer.class);
    @NonNls
    private static final String INTELLIJ_FORCE_SET_PREFIX = "_INTELLIJ_FORCE_SET_";
    @NonNls
    private static final String INTELLIJ_FORCE_PREPEND_PREFIX = "_INTELLIJ_FORCE_PREPEND_";

    @Nullable
    protected String getDefaultFolder(@NotNull Project project) {
        VirtualFile[] roots;
        Module module;
        if (project == null) {
            GoLocalTerminalCustomizer.$$$reportNull$$$0(0);
        }
        if ((module = GoLocalTerminalCustomizer.singleModule(project)) != null && (roots = ModuleRootManager.getInstance((Module)module).getContentRoots()).length == 1) {
            return roots[0].getPath();
        }
        return super.getDefaultFolder(project);
    }

    public String[] customizeCommandAndEnvironment(@NotNull Project project, @Nullable String workingDirectory, String[] command, @NotNull Map<String, String> envs) {
        GoSdk sdk;
        WSLDistribution wsl;
        if (project == null) {
            GoLocalTerminalCustomizer.$$$reportNull$$$0(1);
        }
        if (envs == null) {
            GoLocalTerminalCustomizer.$$$reportNull$$$0(2);
        }
        Module module = GoLocalTerminalCustomizer.singleModule(project);
        Map<String, String> goSpecificEnvironment = GoExecutorExtension.getGoSpecificEnvironment(project, module, envs);
        for (Map.Entry<String, String> entry : goSpecificEnvironment.entrySet()) {
            envs.put(entry.getKey(), entry.getValue());
            envs.put(INTELLIJ_FORCE_SET_PREFIX + entry.getKey(), entry.getValue());
        }
        String exe = (String)ArrayUtil.getFirstElement((Object[])command);
        String goPathBinList = GoExecutorExtension.getGoSpecificPathVariable(project, null);
        if (!goPathBinList.isEmpty()) {
            if (GoLocalTerminalCustomizer.isShellIntegrationAvailable(exe)) {
                envs.put("_INTELLIJ_FORCE_PREPEND_PATH", goPathBinList + File.pathSeparator);
            } else {
                Couple<String> goPathBinListSeparatorPath = GoEnvironmentUtil.prependPathEntry(goPathBinList, EnvironmentUtil.getEnvironmentMap());
                envs.put((String)goPathBinListSeparatorPath.first, (String)goPathBinListSeparatorPath.second);
            }
        }
        List updatedCommand = null;
        if (GoOsManager.isWindows() && ("wsl".equals(exe) || "wsl.exe".equals(exe)) && (wsl = GoWslUtil.getWsl(sdk = GoSdkService.getInstance(project).getSdk(module))) != null) {
            String wslPath = wsl.getEnvironmentVariable("PATH");
            if (StringUtil.isNotEmpty((String)wslPath) && !goPathBinList.isEmpty()) {
                WSLCommandLineOptions options = GoLocalTerminalCustomizer.prependGoBinPathsToWslPath(wsl, goPathBinList);
                try {
                    List shellCommand = EnvironmentUtil.buildShellProcessCommand((String)wsl.getShellPath(), (boolean)true, (boolean)false, (boolean)false);
                    GeneralCommandLine commandLine = wsl.patchCommandLine(new GeneralCommandLine(shellCommand), null, options);
                    updatedCommand = commandLine.getCommandLineList(null);
                }
                catch (Exception e) {
                    LOG.warn("Failed to prepend go bin directories to wsl path", (Throwable)e);
                }
            }
            envs.put("WSLENV", GoLocalTerminalCustomizer.getWslEnv(goSpecificEnvironment));
        }
        return updatedCommand != null ? ArrayUtil.toStringArray(updatedCommand) : command;
    }

    @NotNull
    private static WSLCommandLineOptions prependGoBinPathsToWslPath(WSLDistribution wsl, @NotNull String goPathBinList) {
        boolean isFishShell;
        if (goPathBinList == null) {
            GoLocalTerminalCustomizer.$$$reportNull$$$0(3);
        }
        char pathSeparator = (isFishShell = wsl.getShellPath().endsWith("/fish")) ? (char)' ' : (char)Platform.UNIX.pathSeparator;
        String goBinPrefix = StringUtil.split((String)goPathBinList, (String)String.valueOf(Platform.WINDOWS.pathSeparator)).stream().map(it -> wsl.getWslPath(Path.of(it, new String[0]))).filter(Objects::nonNull).map(it -> CommandLineUtil.posixQuote((String)it)).collect(Collectors.joining(String.valueOf(pathSeparator)));
        WSLCommandLineOptions options = new WSLCommandLineOptions();
        if (!goBinPrefix.isEmpty()) {
            String prependPathCommand = isFishShell ? "set --global --export --prepend fish_user_paths " + goBinPrefix : "export PATH=" + goBinPrefix + ":\"$PATH\"";
            options.addInitCommand(prependPathCommand);
        }
        options.setExecuteCommandInInteractiveShell(true);
        options.setLaunchWithWslExe(true);
        WSLCommandLineOptions wSLCommandLineOptions = options;
        if (wSLCommandLineOptions == null) {
            GoLocalTerminalCustomizer.$$$reportNull$$$0(4);
        }
        return wSLCommandLineOptions;
    }

    @Nullable
    private static String getWslEnv(@NotNull Map<String, String> envs) {
        if (envs == null) {
            GoLocalTerminalCustomizer.$$$reportNull$$$0(5);
        }
        ArrayList<Object> wslEnvEntries = new ArrayList<Object>();
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String name = entry.getKey();
            if (name.startsWith(INTELLIJ_FORCE_SET_PREFIX)) continue;
            if (GoConstants.GO_ENV_VARS_WITH_PATH.contains(name)) {
                wslEnvEntries.add(name + "/p");
                continue;
            }
            if ("GOPATH".equals(name)) {
                wslEnvEntries.add(name + "/l");
                continue;
            }
            wslEnvEntries.add(name);
        }
        return StringUtil.nullize((String)StringUtil.join(wslEnvEntries, (String)":"));
    }

    @Nullable
    private static Module singleModule(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            GoLocalTerminalCustomizer.$$$reportNull$$$0(6);
        }
        if ((modules = ModuleManager.getInstance((Project)project).getModules()).length == 1) {
            return modules[0];
        }
        return null;
    }

    private static boolean isShellIntegrationAvailable(@Nullable String shellPath) {
        if (shellPath != null && TerminalOptionsProvider.getInstance().getShellIntegration()) {
            String shellName = new File(shellPath).getName();
            return Set.of("bash", "zsh", "fish", "powershell.exe", "pwsh.exe").contains(shellName) || SystemInfo.isMac && shellName.equals("sh");
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goPathBinList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/terminal/GoLocalTerminalCustomizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/terminal/GoLocalTerminalCustomizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prependGoBinPathsToWslPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFolder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizeCommandAndEnvironment";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prependGoBinPathsToWslPath";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWslEnv";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "singleModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

