/*
 * Decompiled with CFR 0.152.
 */
package com.goide.testing;

import com.goide.testing.GoTestJsonEventsProcessor;
import com.goide.utils.GoStringUtil;
import com.google.gson.annotations.SerializedName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GoTestEvent {
    @SerializedName(value="Action")
    @Nullable
    public String action;
    @SerializedName(value="Package")
    @Nullable
    public String importPath;
    @SerializedName(value="Test")
    @Nullable
    public String testName;
    @SerializedName(value="Elapsed")
    public double elapsed;
    @SerializedName(value="Output")
    @Nullable
    public String output;

    GoTestEvent() {
    }

    @Nullable
    public GoTestJsonEventsProcessor.Action getAction() {
        if ("run".equals(this.action)) {
            return GoTestJsonEventsProcessor.Action.RUN;
        }
        if ("fail".equals(this.action)) {
            return GoTestJsonEventsProcessor.Action.FAIL;
        }
        if ("pass".equals(this.action)) {
            return GoTestJsonEventsProcessor.Action.PASS;
        }
        if ("skip".equals(this.action)) {
            return GoTestJsonEventsProcessor.Action.SKIP;
        }
        if ("output".equals(this.action)) {
            return GoTestJsonEventsProcessor.Action.OUTPUT;
        }
        if ("cont".equals(this.action)) {
            return GoTestJsonEventsProcessor.Action.CONT;
        }
        if ("pause".equals(this.action)) {
            return GoTestJsonEventsProcessor.Action.PAUSE;
        }
        return null;
    }

    @Nullable
    public String getNodeId() {
        return this.isTest() ? GoStringUtil.notNullize(this.importPath) + "#" + this.testName : this.importPath;
    }

    @Nullable
    public String getParentNodeId(@Nullable String parentTestName) {
        if (this.isTest()) {
            if (GoStringUtil.isNotEmpty(parentTestName)) {
                return GoStringUtil.notNullize(this.importPath) + "#" + parentTestName;
            }
            return this.importPath;
        }
        return null;
    }

    public boolean isTest() {
        return this.testName != null;
    }

    @NotNull
    public String getPackageLocationString(@NotNull String defaultImportPath) {
        if (defaultImportPath == null) {
            GoTestEvent.$$$reportNull$$$0(0);
        }
        String string = "gotest://" + GoStringUtil.notNullize(this.importPath, defaultImportPath) + "#";
        if (string == null) {
            GoTestEvent.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getTestLocationString(@NotNull String defaultImportPath) {
        if (defaultImportPath == null) {
            GoTestEvent.$$$reportNull$$$0(2);
        }
        String string = this.getPackageLocationString(defaultImportPath) + GoStringUtil.notNullize(this.testName);
        if (string == null) {
            GoTestEvent.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getName() {
        return this.isTest() ? this.testName : this.importPath;
    }

    @NotNull
    public String getElapsedTime() {
        String string = String.valueOf((int)(this.elapsed * 1000.0));
        if (string == null) {
            GoTestEvent.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isPackage() {
        return this.testName == null && this.importPath != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultImportPath";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/testing/GoTestEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/testing/GoTestEvent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageLocationString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestLocationString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElapsedTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPackageLocationString";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocationString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

