/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.GoConstants;
import com.goide.GoEnvironmentUtil;
import com.goide.GoNotifications;
import com.goide.GoOsManager;
import com.goide.GoPluginDisposable;
import com.goide.execution.DefaultTargetEnvironmentProvider;
import com.goide.execution.GoConsoleFilter;
import com.goide.execution.GoRunUtil;
import com.goide.execution.application.GoNopProcessHandler;
import com.goide.execution.extension.GoExecutorExtension;
import com.goide.execution.target.GoCommandLineSetup;
import com.goide.execution.target.GoLanguageRuntimeConfiguration;
import com.goide.i18n.GoBundle;
import com.goide.project.GoModuleSettings;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.download.GoDownloadingSdk;
import com.goide.util.GoCommandLineParameter;
import com.goide.util.GoHistoryProcessListener;
import com.goide.util.GoLocalEnvironmentRequest;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.target.PtyOptions;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.local.LocalTargetPtyOptions;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.model.SideEffectGuard;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.viewModel.extraction.ToolWindowContentExtractor;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.xml.util.XmlStringUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public final class GoExecutor {
    private static final Logger LOGGER = Logger.getInstance(GoExecutor.class);
    @NlsSafe
    private static final String GO = "go";
    @NotNull
    private final Map<String, String> myExtraEnvironment;
    @NotNull
    private final Map<String, String> myUserDefinedEnvironment;
    @NotNull
    private final List<GoCommandLineParameter> myParameters;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Module myModule;
    @Nullable
    private String myGoRoot;
    @Nullable
    private String myGoPath;
    @Nullable
    private String myEnvPath;
    @Nullable
    private GoCommandLineParameter myWorkDirectory;
    @Nullable
    private TargetEnvironmentRequest myTargetEnvironmentRequest;
    private boolean myWithSudo;
    private boolean myPrintOutputAsStatus;
    private boolean myShowNotificationsOnError;
    private boolean myShowNotificationsOnSuccess;
    private boolean myShowGoEnvVariables;
    private GeneralCommandLine.ParentEnvironmentType myParentEnvironmentType;
    private boolean myPtyEnabled;
    private boolean myConsoleMode;
    private boolean myVerboseLogging;
    @Nullable
    private @Nullable Supplier<? extends @Nullable GoCommandLineParameter> myRootDirectory;
    @Nullable
    private GoCommandLineParameter myExePath;
    @Nullable
    private @NlsContexts.ProgressTitle String myPresentableName;
    @Nullable
    private Runnable myRerunRunnable;
    @Nullable
    private ThrowableRunnable<? extends ExecutionException> myExecutorPatcher;
    @Nullable
    private ThrowableConsumer<? super GeneralCommandLine, ? extends ExecutionException> myCommandLinePatcher;
    private ThrowableConsumer<? super TargetedCommandLineBuilder, ? extends ExecutionException> myTargetedCommandLinePatcher;
    @Nullable
    private Consumer<? super ProcessHandler> myProcessHandlerPatcher;
    private boolean myReuseContentOnRerun;
    private final Collection<ProcessListener> myProcessListeners;
    private static final Key<String> GO_EXECUTOR_KEY = Key.create((String)"GO_EXECUTOR_KEY");

    private GoExecutor(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoExecutor.$$$reportNull$$$0(0);
        }
        this.myExtraEnvironment = new HashMap<String, String>();
        this.myUserDefinedEnvironment = new HashMap<String, String>();
        this.myParameters = new ArrayList<GoCommandLineParameter>();
        this.myShowGoEnvVariables = true;
        this.myParentEnvironmentType = GeneralCommandLine.ParentEnvironmentType.CONSOLE;
        this.myProcessListeners = new ArrayList<ProcessListener>();
        this.myProject = project;
        this.myModule = module;
        this.myPtyEnabled = Registry.is((String)"go.run.processes.with.pty");
    }

    public static GoExecutor in(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoExecutor.$$$reportNull$$$0(1);
        }
        return module != null ? GoExecutor.in(module) : GoExecutor.in(project);
    }

    @NotNull
    private static GoExecutor in(@NotNull Project project) {
        if (project == null) {
            GoExecutor.$$$reportNull$$$0(2);
        }
        return new GoExecutor(project, null).withTargetEnvironmentRequest(GoExecutor.getDefaultTargetEnvironmentRequest(project, null)).withGoRoot(VfsUtilCore.urlToPath((String)GoSdkService.getInstance(project).getSdk(null).getHomeUrl())).withGoPath(GoSdkUtil.retrieveGoPath(project, null)).withEnvPath(GoSdkUtil.retrieveEnvironmentPathForGo(project, null));
    }

    @NotNull
    public static GoExecutor in(@NotNull Module module) {
        if (module == null) {
            GoExecutor.$$$reportNull$$$0(3);
        }
        Project project = module.getProject();
        return new GoExecutor(project, module).withTargetEnvironmentRequest(GoExecutor.getDefaultTargetEnvironmentRequest(project, module)).withGoRoot(VfsUtilCore.urlToPath((String)GoSdkService.getInstance(project).getSdk(module).getHomeUrl())).withGoPath(GoSdkUtil.retrieveGoPath(project, module)).withEnvPath(GoSdkUtil.retrieveEnvironmentPathForGo(project, module));
    }

    @Nullable
    private static TargetEnvironmentRequest getDefaultTargetEnvironmentRequest(@NotNull Project project, @Nullable Module module) {
        TargetEnvironmentConfiguration env;
        if (project == null) {
            GoExecutor.$$$reportNull$$$0(4);
        }
        return (env = DefaultTargetEnvironmentProvider.getDefaultTargetEnvironment(project, module)) != null ? env.createEnvironmentRequest(project) : null;
    }

    @NotNull
    public GoExecutor withPresentableName(@Nullable @NlsContexts.ProgressTitle String presentableName) {
        this.myPresentableName = presentableName;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(5);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withProcessHandlerPatcher(@Nullable Consumer<? super ProcessHandler> processHandlerPatcher) {
        this.myProcessHandlerPatcher = processHandlerPatcher;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(6);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withRootDirectory(@Nullable @Nullable Supplier<? extends @Nullable GoCommandLineParameter> rootDirectory) {
        this.myRootDirectory = rootDirectory;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(7);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withExePath(@NonNls @Nullable String exePath) {
        GoExecutor goExecutor = this.withExePath(exePath == null ? null : GoCommandLineParameter.string(exePath));
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(8);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withExePath(@Nullable GoCommandLineParameter exePath) {
        this.myExePath = exePath;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(9);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withWorkDirectory(@NonNls @Nullable String workDirectory) {
        GoExecutor goExecutor = this.withWorkDirectory(workDirectory == null ? null : GoCommandLineParameter.path(workDirectory));
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(10);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withWorkDirectory(@Nullable GoCommandLineParameter workDirectory) {
        this.myWorkDirectory = workDirectory;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(11);
        }
        return goExecutor;
    }

    @Nullable
    public String getWorkDirectory() {
        return this.myWorkDirectory != null ? this.myWorkDirectory.toPresentableString() : null;
    }

    @NotNull
    public GoExecutor withTargetEnvironmentRequest(@Nullable TargetEnvironmentRequest targetEnvironmentFactory) {
        this.myTargetEnvironmentRequest = targetEnvironmentFactory;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(12);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withPtyEnabled(boolean enabled) {
        this.myPtyEnabled = enabled;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(13);
        }
        return goExecutor;
    }

    @NotNull
    public TargetEnvironmentRequest getTargetEnvironmentRequest() {
        GoLocalEnvironmentRequest goLocalEnvironmentRequest = this.myTargetEnvironmentRequest == null ? this.createLocalTargetEnvironmentRequest() : this.myTargetEnvironmentRequest;
        if (goLocalEnvironmentRequest == null) {
            GoExecutor.$$$reportNull$$$0(14);
        }
        return goLocalEnvironmentRequest;
    }

    @Nullable
    public GoLanguageRuntimeConfiguration getTargetLanguageRuntime() {
        return Optional.ofNullable(this.getTargetEnvironmentRequest().getConfiguration()).map(TargetEnvironmentConfiguration::getRuntimes).map(list -> (GoLanguageRuntimeConfiguration)list.findByType(GoLanguageRuntimeConfiguration.class)).orElse(null);
    }

    @NotNull
    private GoExecutor withGoRoot(@NonNls @Nullable String goRoot) {
        this.myGoRoot = PathUtil.toSystemDependentName((String)goRoot);
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(15);
        }
        return goExecutor;
    }

    @NotNull
    private GoExecutor withGoPath(@NonNls @Nullable String goPath) {
        this.myGoPath = goPath;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(16);
        }
        return goExecutor;
    }

    @NotNull
    private GoExecutor withEnvPath(@NonNls @Nullable String envPath) {
        this.myEnvPath = envPath;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(17);
        }
        return goExecutor;
    }

    public GoExecutor withProcessListener(@NotNull ProcessListener listener2) {
        if (listener2 == null) {
            GoExecutor.$$$reportNull$$$0(18);
        }
        this.myProcessListeners.add(listener2);
        return this;
    }

    @NotNull
    public GoExecutor withExtraEnvironment(@NotNull Map<String, String> environment) {
        if (environment == null) {
            GoExecutor.$$$reportNull$$$0(19);
        }
        this.myExtraEnvironment.putAll(environment);
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(20);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withUserDefinedEnvironment(@NotNull Map<String, String> environment) {
        if (environment == null) {
            GoExecutor.$$$reportNull$$$0(21);
        }
        this.myUserDefinedEnvironment.putAll(environment);
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(22);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withPassParentEnvironment(boolean passParentEnvironment) {
        this.myParentEnvironmentType = passParentEnvironment ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(23);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withParameterString(@NonNls @NotNull String parameterString) {
        if (parameterString == null) {
            GoExecutor.$$$reportNull$$$0(24);
        }
        List parameters = ParametersListUtil.parse((String)parameterString, (boolean)false, (boolean)true);
        this.myParameters.addAll(ContainerUtil.map((Collection)parameters, GoCommandLineParameter.StringParameter::new));
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(25);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withParameters(String ... parameters) {
        if (parameters == null) {
            GoExecutor.$$$reportNull$$$0(26);
        }
        this.myParameters.addAll(ContainerUtil.map((Object[])parameters, GoCommandLineParameter.StringParameter::new));
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(27);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withParameters(GoCommandLineParameter ... parameters) {
        if (parameters == null) {
            GoExecutor.$$$reportNull$$$0(28);
        }
        Collections.addAll(this.myParameters, parameters);
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(29);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withPathParameters(String ... parameters) {
        if (parameters == null) {
            GoExecutor.$$$reportNull$$$0(30);
        }
        this.myParameters.addAll(ContainerUtil.map((Object[])parameters, GoCommandLineParameter::path));
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(31);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withParameters(@NonNls List<@NotNull String> parameters) {
        GoExecutor goExecutor = this.withParameters((Collection<String>)parameters);
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(32);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withParameters(@NonNls Collection<@NotNull String> parameters) {
        this.myParameters.addAll(ContainerUtil.map(parameters, GoCommandLineParameter.StringParameter::new));
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(33);
        }
        return goExecutor;
    }

    @NotNull
    public List<GoCommandLineParameter> getParameters() {
        return new ArrayList<GoCommandLineParameter>(this.myParameters);
    }

    @NotNull
    public GoExecutor withoutParameter(int i) {
        this.myParameters.remove(i);
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(34);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withPrintingOutputAsStatus() {
        this.myPrintOutputAsStatus = true;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(35);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withParametersAtStart(String ... parameters) {
        if (parameters == null) {
            GoExecutor.$$$reportNull$$$0(36);
        }
        for (int i = parameters.length - 1; i >= 0; --i) {
            this.myParameters.add(0, new GoCommandLineParameter.StringParameter(parameters[i]));
        }
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(37);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withParametersAtStart(GoCommandLineParameter ... parameters) {
        if (parameters == null) {
            GoExecutor.$$$reportNull$$$0(38);
        }
        for (int i = parameters.length - 1; i >= 0; --i) {
            this.myParameters.add(0, parameters[i]);
        }
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(39);
        }
        return goExecutor;
    }

    public GoExecutor showGoEnvVariables(boolean show) {
        this.myShowGoEnvVariables = show;
        return this;
    }

    @NotNull
    public GoExecutor withConsoleMode() {
        if (!GoOsManager.isWindows()) {
            LOGGER.warn("console mode should not be used on non-Windows OS");
        }
        this.myConsoleMode = true;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(40);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withSdk(@NotNull GoSdk sdk) {
        VirtualFile sdkRoot;
        if (sdk == null) {
            GoExecutor.$$$reportNull$$$0(41);
        }
        if ((sdkRoot = sdk.getSdkRoot()) != null) {
            this.withGoRoot(sdkRoot.getPath());
            VirtualFile goExecutable = GoSdkUtil.getGoExecutable(sdkRoot);
            if (goExecutable != null) {
                this.withExePath(GoCommandLineParameter.path(goExecutable.getPath()));
            }
        }
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(42);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withVerboseLogging(boolean verboseLogging) {
        this.myVerboseLogging = verboseLogging && Registry.is((String)"go.executor.verbose.logging");
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(43);
        }
        return goExecutor;
    }

    @Deprecated
    @NotNull
    public GoExecutor disablePty() {
        GoExecutor goExecutor = this.withPtyEnabled(false);
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(44);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withSudo() {
        this.myWithSudo = true;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(45);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor showNotifications(boolean onError, boolean onSuccess) {
        this.myShowNotificationsOnError = onError;
        this.myShowNotificationsOnSuccess = onSuccess;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(46);
        }
        return goExecutor;
    }

    @NotNull
    public GoExecutor withRerun(@Nullable Runnable runnable, boolean reuseContent) {
        this.myRerunRunnable = runnable;
        this.myReuseContentOnRerun = reuseContent;
        GoExecutor goExecutor = this;
        if (goExecutor == null) {
            GoExecutor.$$$reportNull$$$0(47);
        }
        return goExecutor;
    }

    public GoExecutor withExecutorPatcher(@Nullable ThrowableRunnable<? extends ExecutionException> executorPatcher) {
        this.myExecutorPatcher = executorPatcher;
        return this;
    }

    @Deprecated
    public GoExecutor withCommandLinePatcher(@Nullable ThrowableConsumer<? super GeneralCommandLine, ? extends ExecutionException> commandLinePatcher) {
        this.myCommandLinePatcher = commandLinePatcher;
        return this;
    }

    public GoExecutor withTargetedCommandLinePatcher(@Nullable ThrowableConsumer<? super TargetedCommandLineBuilder, ? extends ExecutionException> commandLinePatcher) {
        this.myTargetedCommandLinePatcher = commandLinePatcher;
        return this;
    }

    public boolean isShowGoEnvVariables() {
        return this.myShowGoEnvVariables;
    }

    public void executeWithOutput(final @NotNull Consumer<? super ExecutionResult> consumer) {
        if (consumer == null) {
            GoExecutor.$$$reportNull$$$0(48);
        }
        if (this.myExePath == null && GoSdkService.getInstance(this.myProject).getSdk(this.myModule) instanceof GoDownloadingSdk) {
            this.handleNotDownloadedSdk(consumer);
            return;
        }
        final ConcurrentHashMap<String, String> environment = new ConcurrentHashMap<String, String>();
        AtomicReference<String> commandPresentation = new AtomicReference<String>();
        this.createProcess(environment, commandPresentation).onSuccess(process -> ApplicationManager.getApplication().invokeLater(() -> {
            KillableColoredProcessHandler handler = new KillableColoredProcessHandler((Process)process, (String)commandPresentation.get()){

                public void startNotify() {
                    if (GoExecutor.this.myShowGoEnvVariables) {
                        GoRunUtil.printGoEnvVariables(GoExecutor.this.myProject, environment, (ProcessHandler)this);
                    }
                    super.startNotify();
                }

                @NotNull
                protected BaseOutputReader.Options readerOptions() {
                    BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                    if (options == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return options;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/util/GoExecutor$1", "readerOptions"));
                }
            };
            ProcessTerminatedListener.attach((ProcessHandler)handler, (Project)this.myProject);
            if (this.myProcessHandlerPatcher != null) {
                this.myProcessHandlerPatcher.accept((ProcessHandler)handler);
            }
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.processTerminated(event);
                    boolean success = event.getExitCode() == 0;
                    GoExecutor.this.showNotificationIfNeeded(success);
                    consumer.accept(new ExecutionResult(success ? ExecutionResult.Status.SUCCEEDED : ExecutionResult.Status.FAILED, null));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/util/GoExecutor$2", "processTerminated"));
                }
            });
            for (ProcessListener listener2 : this.myProcessListeners) {
                handler.addProcessListener(listener2);
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.createRunContent((ProcessHandler)handler, this.getDefaultRunContentKey()).run();
            } else {
                handler.startNotify();
            }
        })).onError(t -> {
            ExecutionException error = t instanceof ExecutionException ? (ExecutionException)((Object)t) : new ExecutionException(t);
            String debugInfo = (String)commandPresentation.get();
            this.handleExecutionException(error, environment, debugInfo, true, null);
            consumer.accept(new ExecutionResult(ExecutionResult.Status.FAILED, error.getLocalizedMessage()));
        });
    }

    public void executeWithProgress() {
        this.executeWithProgress(t -> {});
    }

    public void executeWithProgress(@NotNull Consumer<? super ExecutionResult> onFinish) {
        if (onFinish == null) {
            GoExecutor.$$$reportNull$$$0(49);
        }
        this.executeWithProgress(true, false, onFinish);
    }

    public void executeWithProgress(boolean startInBackground, boolean showOutputOnError, @NotNull Consumer<? super ExecutionResult> onFinish) {
        if (onFinish == null) {
            GoExecutor.$$$reportNull$$$0(50);
        }
        this.executeWithProgress(startInBackground, showOutputOnError, null, null, onFinish);
    }

    public void executeWithProgress(boolean startInBackground, boolean showOutputOnError, @Nullable GoHistoryProcessListener historyProcessListener, @Nullable String runContentKey, @NotNull Consumer<? super ExecutionResult> onFinish) {
        if (onFinish == null) {
            GoExecutor.$$$reportNull$$$0(51);
        }
        this.executeWithProgress(startInBackground, showOutputOnError, historyProcessListener, runContentKey, null, onFinish);
    }

    public void executeWithProgress(boolean startInBackground, boolean showOutputOnError, @Nullable GoHistoryProcessListener historyProcessListener, @Nullable String runContentKey, @Nullable ProgressIndicatorEx parentIndicator, @NotNull Consumer<? super ExecutionResult> onFinish) {
        Task.Backgroundable task2;
        if (onFinish == null) {
            GoExecutor.$$$reportNull$$$0(52);
        }
        if ((task2 = this.createTask(startInBackground, showOutputOnError, historyProcessListener, runContentKey, parentIndicator, onFinish)) != null) {
            task2.queue();
        }
    }

    @Nullable
    public Task.Backgroundable createTask(final boolean startInBackground, final boolean showOutputOnError, final @Nullable GoHistoryProcessListener historyProcessListener, final @Nullable String runContentKey, final @Nullable ProgressIndicatorEx parentIndicator, final @NotNull Consumer<? super ExecutionResult> onFinish) {
        if (onFinish == null) {
            GoExecutor.$$$reportNull$$$0(53);
        }
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.EXEC);
        if (this.myExePath == null && GoSdkService.getInstance(this.myProject).getSdk(this.myModule) instanceof GoDownloadingSdk) {
            this.handleNotDownloadedSdk(onFinish);
            return null;
        }
        final ClientId clientId = ClientId.getCurrentOrNull();
        return new Task.Backgroundable(this.myProject, this.getPresentableName(), true){
            private CapturingProcessHandler myProcessHandler;
            @Nullable
            private GoHistoryProcessListener myHistoryProcessListener;

            public void run(final @NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((this.myProcessHandler = this.getProcessHandler(indicator)) == null) {
                    return;
                }
                GoExecutor.this.verboseLog("Starting `%s` in %s. Commandline: %s".formatted(GoExecutor.this.getPresentableName(), GoExecutor.this.getWorkDirectory(), this.myProcessHandler.getCommandLineForLog()));
                indicator.setIndeterminate(true);
                if (parentIndicator != null) {
                    new ProgressIndicatorListener(){

                        public void cancelled() {
                            indicator.cancel();
                        }
                    }.installToProgress(parentIndicator);
                }
                if (GoExecutor.this.myPrintOutputAsStatus) {
                    this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                            if (event == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if (outputType == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            if (outputType != ProcessOutputTypes.SYSTEM && !indicator.isCanceled()) {
                                indicator.checkCanceled();
                                indicator.setText(event.getText());
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "outputType";
                                    break;
                                }
                            }
                            objectArray[1] = "com/goide/util/GoExecutor$3$2";
                            objectArray[2] = "onTextAvailable";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
                if (showOutputOnError) {
                    this.myHistoryProcessListener = (GoHistoryProcessListener)((Object)ObjectUtils.notNull((Object)((Object)historyProcessListener), GoHistoryProcessListener::new));
                    this.myProcessHandler.addProcessListener((ProcessListener)this.myHistoryProcessListener);
                }
                this.myProcessHandler.runProcessWithProgressIndicator(indicator);
            }

            @Nullable
            private CapturingProcessHandler getProcessHandler(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(1);
                }
                String commandRepresentation = null;
                Map environmentVariables = null;
                try {
                    TargetEnvironmentRequest request = GoExecutor.this.getTargetEnvironmentRequest();
                    TargetEnvironment environment = GoExecutor.this.prepareRemoteEnvironment(request, indicator);
                    TargetedCommandLineBuilder commandLineBuilder = GoExecutor.this.createCommandLine(request);
                    TargetedCommandLine targetedCommandLine = commandLineBuilder.build();
                    Charset charset = targetedCommandLine.getCharset();
                    final Map finalEnvironmentVariables = environmentVariables = targetedCommandLine.getEnvironmentVariables();
                    commandRepresentation = targetedCommandLine.getCommandPresentation(environment) + " #gosetup";
                    Process process = environment.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
                    CapturingProcessHandler processHandler = new CapturingProcessHandler(process, charset, commandRepresentation){

                        public void startNotify() {
                            if (GoExecutor.this.myShowGoEnvVariables) {
                                GoRunUtil.printGoEnvVariables(GoExecutor.this.myProject, finalEnvironmentVariables, (ProcessHandler)this);
                            }
                            super.startNotify();
                        }

                        @NotNull
                        protected BaseOutputReader.Options readerOptions() {
                            BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                            if (options == null) {
                                3.$$$reportNull$$$0(0);
                            }
                            return options;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/util/GoExecutor$3$3", "readerOptions"));
                        }
                    };
                    if (GoExecutor.this.myProcessHandlerPatcher != null) {
                        GoExecutor.this.myProcessHandlerPatcher.accept((ProcessHandler)processHandler);
                    }
                    for (ProcessListener listener2 : GoExecutor.this.myProcessListeners) {
                        processHandler.addProcessListener(listener2);
                    }
                    return processHandler;
                }
                catch (ExecutionException e) {
                    GoExecutor.this.handleExecutionException(e, environmentVariables, commandRepresentation, showOutputOnError, runContentKey);
                    onFinish.accept(new ExecutionResult(ExecutionResult.Status.FAILED, e.getLocalizedMessage()));
                    return null;
                }
            }

            public boolean shouldStartInBackground() {
                return startInBackground;
            }

            public boolean isConditionalModal() {
                return true;
            }

            public void onFinished() {
                if (this.myProcessHandler == null) {
                    return;
                }
                Integer exitCode = this.myProcessHandler.getExitCode();
                boolean isZeroExitCode = exitCode != null && exitCode == 0;
                boolean success = this.myHistoryProcessListener != null ? this.myHistoryProcessListener.isSuccess(isZeroExitCode) : isZeroExitCode;
                boolean notificationShown = GoExecutor.this.showNotificationIfNeeded(success);
                if (showOutputOnError && this.myProject != null && !this.myProject.isDisposed() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    String key = (String)ObjectUtils.notNull((Object)runContentKey, (Object)this.myProcessHandler.getCommandLine());
                    if (this.myHistoryProcessListener != null && this.myHistoryProcessListener.shouldShowOutput(success)) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (this.myProject.isDisposed()) {
                                return;
                            }
                            try (AccessToken token = ClientId.withClientId((ClientId)clientId);){
                                NopProcessHandler outputHandler = new NopProcessHandler();
                                RunContentExecutor content2 = GoExecutor.this.createRunContent((ProcessHandler)outputHandler, key);
                                GoExecutor.this.setupRunContentRepresentation(content2, success, notificationShown);
                                content2.run();
                                this.myHistoryProcessListener.apply((ProcessHandler)outputHandler);
                                outputHandler.destroyProcess();
                            }
                        });
                    } else {
                        GoExecutor.this.removeOldRunContent(key);
                    }
                }
                GoExecutor.this.verboseLog("Finished `%s` in %s with result: %d. Commandline: %s".formatted(GoExecutor.this.getPresentableName(), GoExecutor.this.getWorkDirectory(), exitCode, this.myProcessHandler.getCommandLineForLog()));
                onFinish.accept(new ExecutionResult(success ? ExecutionResult.Status.SUCCEEDED : ExecutionResult.Status.FAILED, null));
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    3.$$$reportNull$$$0(2);
                }
                super.onThrowable(error);
                onFinish.accept(new ExecutionResult(ExecutionResult.Status.FAILED, error.getLocalizedMessage()));
            }

            public void onCancel() {
                super.onCancel();
                if (GoExecutor.this.myShowNotificationsOnError) {
                    GoExecutor.this.showNotification(GoBundle.message((String)"go.execution.process.interrupted", (Object[])new Object[0]), NotificationType.WARNING);
                }
                onFinish.accept(new ExecutionResult(ExecutionResult.Status.CANCELLED, GoBundle.message((String)"go.execution.process.cancelled", (Object[])new Object[0])));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/util/GoExecutor$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getProcessHandler";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void handleNotDownloadedSdk(@NotNull Consumer<? super ExecutionResult> onFinish) {
        if (onFinish == null) {
            GoExecutor.$$$reportNull$$$0(54);
        }
        if (this.myShowNotificationsOnError) {
            this.showNotification(GoBundle.message((String)"go.execution.go.sdk.is.not.downloaded.yet", (Object[])new Object[0]), NotificationType.WARNING);
        }
        onFinish.accept(new ExecutionResult(ExecutionResult.Status.NOT_STARTED, GoBundle.message((String)"go.execution.go.sdk.is.not.downloaded.yet", (Object[])new Object[0])));
    }

    @NotNull
    public TargetEnvironment prepareRemoteEnvironment(@NotNull TargetEnvironmentRequest request, final @NotNull ProgressIndicator indicator) throws ExecutionException {
        TargetEnvironment targetEnvironment;
        GoCommandLineParameter rootDir;
        if (request == null) {
            GoExecutor.$$$reportNull$$$0(55);
        }
        if (indicator == null) {
            GoExecutor.$$$reportNull$$$0(56);
        }
        if (this.myExecutorPatcher != null) {
            this.myExecutorPatcher.run();
        }
        GoCommandLineSetup setup = new GoCommandLineSetup(request, this.getTargetLanguageRuntime());
        if (this.myRootDirectory != null && (rootDir = this.myRootDirectory.get()) != null) {
            rootDir.prepare(setup);
        }
        if (this.myExePath != null) {
            this.myExePath.prepare(setup);
        }
        if (this.myWorkDirectory != null) {
            this.myWorkDirectory.prepare(setup);
        }
        this.myParameters.forEach(parameter -> parameter.prepare(setup));
        TargetProgressIndicator targetProgressIndicator = new TargetProgressIndicator(){

            public void addText(@Nls @NotNull String text, @NotNull Key<?> key) {
                if (text == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (key == null) {
                    4.$$$reportNull$$$0(1);
                }
                indicator.setText2(text.strip());
            }

            public boolean isCanceled() {
                return indicator.isCanceled();
            }

            public void stop() {
                indicator.cancel();
            }

            public boolean isStopped() {
                return this.isCanceled();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                }
                objectArray[1] = "com/goide/util/GoExecutor$4";
                objectArray[2] = "addText";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        try {
            TargetEnvironment environment = request.prepareEnvironment(targetProgressIndicator);
            setup.provideEnvironment(environment, targetProgressIndicator);
            targetEnvironment = environment;
        }
        catch (ExecutionException | CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutionException(GoBundle.message((String)"go.execution.failed.to.prepare.remote.environment.error", (Object[])new Object[]{e.getLocalizedMessage()}), (Throwable)e);
        }
        if (targetEnvironment == null) {
            GoExecutor.$$$reportNull$$$0(57);
        }
        return targetEnvironment;
    }

    private boolean showNotificationIfNeeded(boolean success) {
        if (success && this.myShowNotificationsOnSuccess || !success && this.myShowNotificationsOnError) {
            this.showNotification(success);
            return true;
        }
        return false;
    }

    private void showNotification(boolean success) {
        if (success) {
            this.showNotification(GoBundle.message((String)"go.execution.process.finished.successfully", (Object[])new Object[0]), NotificationType.INFORMATION);
        } else {
            this.showFailedRunNotification();
        }
    }

    private void showFailedRunNotification() {
        this.showNotification(GoBundle.message((String)"go.execution.process.failed.to.run", (Object[])new Object[0]), NotificationType.ERROR);
    }

    private void removeOldRunContent(String key) {
        RunContentDescriptor oldContent = GoExecutor.findRunContentToClose(this.myProject, key);
        if (oldContent != null) {
            RunContentManager runContentManager = RunContentManager.getInstance((Project)this.myProject);
            runContentManager.removeRunContent(DefaultRunExecutor.getRunExecutorInstance(), oldContent);
        }
    }

    private void verboseLog(@NotNull String message) {
        if (message == null) {
            GoExecutor.$$$reportNull$$$0(58);
        }
        if (this.myVerboseLogging) {
            LOGGER.info(message);
        } else {
            LOGGER.debug(message);
        }
    }

    private void handleExecutionException(@NotNull ExecutionException e, @Nullable Map<String, String> environmentVariables, @Nullable String debugCommandRepresentation, boolean showOutputOnError, @Nullable String runContentKey) {
        if (e == null) {
            GoExecutor.$$$reportNull$$$0(59);
        }
        GoNopProcessHandler outputHandler = new GoNopProcessHandler(126);
        for (ProcessListener listener2 : this.myProcessListeners) {
            outputHandler.addProcessListener(listener2);
        }
        if (showOutputOnError && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                String key = runContentKey != null ? runContentKey : this.getDefaultRunContentKey();
                RunContentExecutor content2 = this.createRunContent(outputHandler, key);
                this.setupRunContentRepresentation(content2, false, this.myShowNotificationsOnError);
                content2.run();
                this.printException(outputHandler, e, environmentVariables);
                outputHandler.destroyProcess();
            });
        } else {
            outputHandler.startNotify();
            this.printException(outputHandler, e, environmentVariables);
            outputHandler.destroyProcess();
        }
        if (this.myShowNotificationsOnError) {
            this.showNotification(StringUtil.notNullize((String)e.getMessage(), (String)GoBundle.message((String)"go.execution.unknown.error", (Object[])new Object[0])), NotificationType.ERROR);
        }
        String commandLineInfo = (String)ObjectUtils.notNull((Object)debugCommandRepresentation, (Object)"<not constructed>");
        String logMessage = "Finished `" + this.getPresentableName() + "` with an exception. Commandline: " + commandLineInfo;
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            LOGGER.error(logMessage, (Throwable)e);
        } else if (this.myVerboseLogging) {
            LOGGER.warn(logMessage, (Throwable)e);
        } else {
            LOGGER.debug(logMessage, (Throwable)e);
        }
    }

    private String getPresentableExePath() {
        return this.myExePath != null ? this.myExePath.toPresentableString() : GO;
    }

    @NotNull
    private String getDefaultRunContentKey() {
        String string = this.getPresentableName() + " " + this.getPresentableExePath() + " " + StringUtil.join(this.myParameters, GoCommandLineParameter::toPresentableString, (String)" ");
        if (string == null) {
            GoExecutor.$$$reportNull$$$0(60);
        }
        return string;
    }

    private void printException(@NotNull GoNopProcessHandler outputHandler, @NotNull ExecutionException e, @Nullable Map<String, String> environmentVariables) {
        if (outputHandler == null) {
            GoExecutor.$$$reportNull$$$0(61);
        }
        if (e == null) {
            GoExecutor.$$$reportNull$$$0(62);
        }
        if (environmentVariables != null && this.myShowGoEnvVariables) {
            GoRunUtil.printGoEnvVariables(this.myProject, environmentVariables, outputHandler);
        }
        outputHandler.notifyTextAvailable(e.getMessage(), ProcessOutputTypes.STDERR);
    }

    private void showNotification(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String message, NotificationType type) {
        if (message == null) {
            GoExecutor.$$$reportNull$$$0(63);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            LOGGER.info(this.getPresentableName() + ": " + message);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                String title = XmlStringUtil.escapeString((String)this.getPresentableName());
                GoRunUtil.showNotification(title, message, type, GoNotifications.getExecutionGroup(), this.myProject);
            });
        }
    }

    private RunContentExecutor createRunContent(@NotNull ProcessHandler processHandler, @NotNull String key) {
        if (processHandler == null) {
            GoExecutor.$$$reportNull$$$0(64);
        }
        if (key == null) {
            GoExecutor.$$$reportNull$$$0(65);
        }
        RunContentExecutor runContentExecutor = new RunContentExecutor(this.myProject, processHandler).withTitle(this.getPresentableName()).withStop(() -> ((ProcessHandler)processHandler).destroyProcess(), () -> !processHandler.isProcessTerminated()).withFilter((Filter)new GoConsoleFilter(this.myProject, this.myModule, (String)ObjectUtils.doIfNotNull((Object)this.getWorkDirectory(), VfsUtilCore::pathToUrl)));
        processHandler.putUserData(GO_EXECUTOR_KEY, (Object)key);
        processHandler.putUserData(ToolWindowContentExtractor.SYNC_TAB_TO_REMOTE_CLIENTS, (Object)true);
        if (this.myRerunRunnable != null) {
            runContentExecutor.withRerun(() -> {
                processHandler.destroyProcess();
                if (!this.myReuseContentOnRerun) {
                    this.removeOldRunContent(key);
                    Disposer.dispose((Disposable)runContentExecutor);
                }
                this.myRerunRunnable.run();
            });
            Disposer.register((Disposable)runContentExecutor, () -> runContentExecutor.withRerun(null));
        }
        Disposer.register((Disposable)GoPluginDisposable.getInstance(this.myProject), (Disposable)runContentExecutor);
        return runContentExecutor;
    }

    private void setupRunContentRepresentation(@NotNull RunContentExecutor content2, boolean success, boolean notificationShown) {
        if (content2 == null) {
            GoExecutor.$$$reportNull$$$0(66);
        }
        content2.withFocusToolWindow(false);
        String activeToolWindowId = ToolWindowManager.getInstance((Project)this.myProject).getActiveToolWindowId();
        if (activeToolWindowId == null) {
            content2.withActivateToolWindow(true);
        } else {
            content2.withActivateToolWindow(false);
            if (!"Run".equals(activeToolWindowId) && !notificationShown) {
                this.showNotification(success);
            }
        }
    }

    private static RunContentDescriptor findRunContentToClose(@NotNull Project project, @NotNull String key) {
        if (project == null) {
            GoExecutor.$$$reportNull$$$0(67);
        }
        if (key == null) {
            GoExecutor.$$$reportNull$$$0(68);
        }
        return (RunContentDescriptor)ContainerUtil.find((Iterable)RunContentManager.getInstance((Project)project).getAllDescriptors(), descriptor -> {
            ProcessHandler processHandler = descriptor.getProcessHandler();
            return processHandler != null && key.equals(processHandler.getUserData(GO_EXECUTOR_KEY));
        });
    }

    @NotNull
    private Promise<Process> createProcess(final @NotNull Map<String, String> targetCommandEnvironment, final @NotNull AtomicReference<String> targetCommandPresentation) {
        if (targetCommandEnvironment == null) {
            GoExecutor.$$$reportNull$$$0(69);
        }
        if (targetCommandPresentation == null) {
            GoExecutor.$$$reportNull$$$0(70);
        }
        final AsyncPromise result = new AsyncPromise();
        new Task.Backgroundable(this.myProject, this.getPresentableName(), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                try {
                    TargetEnvironmentRequest request = GoExecutor.this.getTargetEnvironmentRequest();
                    TargetEnvironment environment = GoExecutor.this.prepareRemoteEnvironment(request, indicator);
                    TargetedCommandLineBuilder commandLineBuilder = GoExecutor.this.createCommandLine(request);
                    TargetedCommandLine targetedCommandLine = commandLineBuilder.build();
                    targetCommandEnvironment.putAll(targetedCommandLine.getEnvironmentVariables());
                    targetCommandPresentation.set(targetedCommandLine.getCommandPresentation(environment));
                    result.setResult((Object)environment.createProcess(targetedCommandLine, indicator));
                }
                catch (ExecutionException e) {
                    result.setError((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/goide/util/GoExecutor$5", "run"));
            }
        }.queue();
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            GoExecutor.$$$reportNull$$$0(71);
        }
        return asyncPromise;
    }

    @NotNull
    private GoLocalEnvironmentRequest createLocalTargetEnvironmentRequest() {
        return new GoLocalEnvironmentRequest(this.myParentEnvironmentType, this.myWithSudo, this.myConsoleMode, this.myCommandLinePatcher);
    }

    @NotNull
    public TargetedCommandLineBuilder createCommandLine(@NotNull TargetEnvironmentRequest request) throws ExecutionException {
        if (request == null) {
            GoExecutor.$$$reportNull$$$0(72);
        }
        if (this.myGoRoot == null) {
            throw new ExecutionException(GoBundle.message((String)"go.execution.sdk.not.set.or.sdk.home.path.empty.for.module.error", (Object[])new Object[0]));
        }
        TargetedCommandLineBuilder commandLine = new TargetedCommandLineBuilder(request);
        Optional<GoLanguageRuntimeConfiguration> runtime = Optional.ofNullable(this.getTargetLanguageRuntime());
        if (this.myExePath != null) {
            commandLine.setExePath(this.myExePath.toValue());
        } else {
            commandLine.setExePath(runtime.map(GoLanguageRuntimeConfiguration::getGoBinaryPath).orElseGet(() -> {
                String defaultExecutable = GoEnvironmentUtil.getBinaryFileNameForPath(GO);
                VirtualFile executable = GoSdkUtil.getGoExecutable(LocalFileSystem.getInstance().findFileByPath(this.myGoRoot));
                return executable != null ? executable.getPath() : defaultExecutable;
            }));
        }
        commandLine.addEnvironmentVariable("GOROOT", runtime.isPresent() ? "" : StringUtil.notNullize((String)this.myGoRoot));
        commandLine.addEnvironmentVariable("GOPATH", runtime.map(GoLanguageRuntimeConfiguration::getGoPath).orElse(StringUtil.notNullize((String)this.myGoPath)));
        ProxyData proxyString = GoExecutor.getProxyData();
        if (proxyString != null) {
            commandLine.addEnvironmentVariable("http_proxy", StringUtil.notNullize((String)proxyString.myProxy));
            commandLine.addEnvironmentVariable("https_proxy", StringUtil.notNullize((String)proxyString.myProxy));
            commandLine.addEnvironmentVariable("no_proxy", StringUtil.notNullize((String)proxyString.myNoProxy));
            commandLine.addEnvironmentVariable("GONOPROXY", StringUtil.notNullize((String)proxyString.myNoProxy));
        }
        commandLine.addEnvironmentVariable("GO15VENDOREXPERIMENT", "1");
        Platform targetPlatform = request.getTargetPlatform().getPlatform();
        if (this.isPtyEnabled()) {
            LocalPtyOptions.Builder builder = LocalPtyOptions.defaults().builder();
            if (request instanceof WslTargetEnvironmentRequest) {
                builder.consoleMode(true);
            }
            commandLine.setPtyOptions((PtyOptions)new LocalTargetPtyOptions(builder.build()));
            if (targetPlatform != Platform.WINDOWS) {
                commandLine.addEnvironmentVariable("TERM", "xterm-256color");
            }
        }
        this.configurePath(request, this.myExtraEnvironment, commandLine);
        commandLine.setCharset(StandardCharsets.UTF_8);
        if (this.myWorkDirectory != null) {
            commandLine.setWorkingDirectory(this.myWorkDirectory.toValue());
        }
        for (GoCommandLineParameter parameter : this.myParameters) {
            if (parameter == null) continue;
            commandLine.addParameter(parameter.toValue());
        }
        if (this.myTargetedCommandLinePatcher != null) {
            this.myTargetedCommandLinePatcher.consume((Object)commandLine);
        }
        HashMap<String, String> environment = new HashMap<String, String>(this.myExtraEnvironment);
        HashMap<String, String> environmentFromExtensions = new HashMap<String, String>();
        for (GoExecutorExtension extension : GoExecutorExtension.EP_NAME.getExtensionList()) {
            environmentFromExtensions.putAll(extension.getExtraEnvironment(this.myProject, this.myModule, environment));
        }
        environment.putAll(environmentFromExtensions);
        GoExecutor.prepareEnvVars(request, environment);
        environment.forEach((name, value) -> commandLine.addEnvironmentVariable(name, value));
        this.myUserDefinedEnvironment.forEach((name, value) -> commandLine.addEnvironmentVariable(name, value));
        this.addEnvGoExperimentsFromBuildSettings(commandLine);
        TargetedCommandLineBuilder targetedCommandLineBuilder = commandLine;
        if (targetedCommandLineBuilder == null) {
            GoExecutor.$$$reportNull$$$0(73);
        }
        return targetedCommandLineBuilder;
    }

    private void addEnvGoExperimentsFromBuildSettings(@NotNull TargetedCommandLineBuilder commandLineBuilder) {
        if (commandLineBuilder == null) {
            GoExecutor.$$$reportNull$$$0(74);
        }
        if (this.myModule == null) {
            return;
        }
        String[] buildTargetExperiments = GoModuleSettings.getInstance((Module)this.myModule).getBuildTargetSettings().experiments;
        if (buildTargetExperiments.length == 0) {
            return;
        }
        TargetValue prevGoExperiment = (TargetValue)ObjectUtils.notNull((Object)commandLineBuilder.getEnvironmentVariable("GOEXPERIMENT"), () -> TargetValue.fixed((Object)""));
        TargetValue newGoExperiment = TargetValue.map((TargetValue)prevGoExperiment, oldValue -> GoExecutor.mergeGoExperiments(oldValue, buildTargetExperiments));
        commandLineBuilder.addEnvironmentVariable("GOEXPERIMENT", newGoExperiment);
    }

    @NotNull
    public static String mergeGoExperiments(@NotNull String envValue, String @NotNull [] experiments) {
        if (envValue == null) {
            GoExecutor.$$$reportNull$$$0(75);
        }
        if (experiments == null) {
            GoExecutor.$$$reportNull$$$0(76);
        }
        HashSet<String> uniqueExperiments = new HashSet<String>(List.of(experiments));
        uniqueExperiments.addAll(StringUtil.split((String)envValue, (String)","));
        String string = String.join((CharSequence)",", ContainerUtil.sorted(uniqueExperiments));
        if (string == null) {
            GoExecutor.$$$reportNull$$$0(77);
        }
        return string;
    }

    public boolean isPtyEnabled() {
        return this.myPtyEnabled;
    }

    @NotNull
    @NlsContexts.ProgressTitle
    private String getPresentableName() {
        String string = (String)ObjectUtils.notNull((Object)this.myPresentableName, (Object)GO);
        if (string == null) {
            GoExecutor.$$$reportNull$$$0(78);
        }
        return string;
    }

    private void configurePath(@NotNull TargetEnvironmentRequest request, @NotNull Map<String, String> extraEnvironment, @NotNull TargetedCommandLineBuilder commandLine) {
        WSLDistribution targetWsl;
        Platform targetPlatform;
        if (request == null) {
            GoExecutor.$$$reportNull$$$0(79);
        }
        if (extraEnvironment == null) {
            GoExecutor.$$$reportNull$$$0(80);
        }
        if (commandLine == null) {
            GoExecutor.$$$reportNull$$$0(81);
        }
        String targetPathName = (targetPlatform = request.getTargetPlatform().getPlatform()) == Platform.WINDOWS ? "Path" : "PATH";
        String targetPathSeparator = String.valueOf(targetPlatform.pathSeparator);
        ArrayList pathEntries = new ArrayList();
        if (request instanceof LocalTargetEnvironmentRequest) {
            Couple<String> pathNameAndValue = GoEnvironmentUtil.getPathEntry(extraEnvironment);
            ContainerUtil.addIfNotNull(pathEntries, (Object)StringUtil.nullize((String)((String)pathNameAndValue.second), (boolean)true));
            ContainerUtil.addIfNotNull(pathEntries, (Object)StringUtil.nullize((String)((String)EnvironmentUtil.getEnvironmentMap().get(pathNameAndValue.first)), (boolean)true));
            ContainerUtil.addIfNotNull(pathEntries, (Object)StringUtil.nullize((String)this.myEnvPath, (boolean)true));
        } else if (request instanceof WslTargetEnvironmentRequest && (targetWsl = ((WslTargetEnvironmentRequest)request).getConfiguration().getDistribution()) != null) {
            ContainerUtil.addIfNotNull(pathEntries, (Object)extraEnvironment.get(targetPathName));
            ContainerUtil.addIfNotNull(pathEntries, (Object)targetWsl.getEnvironmentVariable(targetPathName));
            if (this.myEnvPath != null) {
                for (String pathEntry : StringUtil.split((String)this.myEnvPath, (String)File.pathSeparator)) {
                    ContainerUtil.addIfNotNull(pathEntries, (Object)GoExecutor.getWslPath(targetWsl, pathEntry));
                }
            }
        }
        if (!pathEntries.isEmpty()) {
            commandLine.addEnvironmentVariable(targetPathName, StringUtil.join(pathEntries, (String)targetPathSeparator));
        }
    }

    private static void prepareEnvVars(@NotNull TargetEnvironmentRequest request, @NotNull Map<String, String> env) {
        WSLDistribution targetWsl;
        if (request == null) {
            GoExecutor.$$$reportNull$$$0(82);
        }
        if (env == null) {
            GoExecutor.$$$reportNull$$$0(83);
        }
        WSLDistribution wSLDistribution = targetWsl = request instanceof WslTargetEnvironmentRequest ? ((WslTargetEnvironmentRequest)request).getConfiguration().getDistribution() : null;
        if (targetWsl != null) {
            HashMap<String, String> updatedEntries = new HashMap<String, String>();
            for (Map.Entry<String, String> envVar : env.entrySet()) {
                String wslPath;
                if (!GoConstants.GO_ENV_VARS_WITH_PATH.contains(envVar.getKey()) || (wslPath = GoExecutor.getWslPath(targetWsl, envVar.getValue())) == null) continue;
                updatedEntries.put(envVar.getKey(), wslPath);
            }
            env.putAll(updatedEntries);
        }
    }

    @Nullable
    private static String getWslPath(@NotNull WSLDistribution targetWsl, @NotNull String windowsUncPath) {
        WslPath wslPath;
        if (targetWsl == null) {
            GoExecutor.$$$reportNull$$$0(84);
        }
        if (windowsUncPath == null) {
            GoExecutor.$$$reportNull$$$0(85);
        }
        return (wslPath = WslPath.parseWindowsUncPath((String)windowsUncPath)) != null && wslPath.getDistribution().equals((Object)targetWsl) ? wslPath.getLinuxPath() : null;
    }

    @Nullable
    public WSLDistribution getTargetWsl() {
        TargetEnvironmentRequest targetRequest = this.getTargetEnvironmentRequest();
        return targetRequest instanceof WslTargetEnvironmentRequest ? ((WslTargetEnvironmentRequest)targetRequest).getConfiguration().getDistribution() : null;
    }

    @Nullable
    private static ProxyData getProxyData() {
        HttpConfigurable settings = HttpConfigurable.getInstance();
        if (settings != null && settings.USE_HTTP_PROXY) {
            String scheme = settings.PROXY_TYPE_IS_SOCKS ? "socks5://" : "http://";
            String credentials = settings.PROXY_AUTHENTICATION ? String.format("%s:%s@", settings.getProxyLogin(), settings.getPlainProxyPassword()) : "";
            return new ProxyData(scheme + credentials + String.format("%s:%d", settings.PROXY_HOST, settings.PROXY_PORT), settings.PROXY_EXCEPTIONS);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 22, 23, 25, 27, 29, 31, 32, 33, 34, 35, 37, 39, 40, 42, 43, 44, 45, 46, 47, 57, 60, 71, 73, 77, 78 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 57: 
            case 60: 
            case 71: 
            case 73: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/util/GoExecutor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterString";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFinish";
                break;
            }
            case 55: 
            case 72: 
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 58: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputHandler";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCommandEnvironment";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCommandPresentation";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineBuilder";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envValue";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "experiments";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraEnvironment";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetWsl";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsUncPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/util/GoExecutor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withPresentableName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withProcessHandlerPatcher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withRootDirectory";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withExePath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withWorkDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withTargetEnvironmentRequest";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withPtyEnabled";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetEnvironmentRequest";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "withGoRoot";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "withGoPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnvPath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "withExtraEnvironment";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "withUserDefinedEnvironment";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "withPassParentEnvironment";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "withParameterString";
                break;
            }
            case 27: 
            case 29: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "withParameters";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "withPathParameters";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutParameter";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "withPrintingOutputAsStatus";
                break;
            }
            case 37: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "withParametersAtStart";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "withConsoleMode";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "withSdk";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "withVerboseLogging";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "disablePty";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "withSudo";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "showNotifications";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "withRerun";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRemoteEnvironment";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRunContentKey";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeGoExperiments";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "in";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTargetEnvironmentRequest";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 57: 
            case 60: 
            case 71: 
            case 73: 
            case 77: 
            case 78: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withProcessListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "withExtraEnvironment";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withUserDefinedEnvironment";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "withParameterString";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "withParameters";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "withPathParameters";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "withParametersAtStart";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "withSdk";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "executeWithOutput";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "executeWithProgress";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "handleNotDownloadedSdk";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "prepareRemoteEnvironment";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "verboseLog";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "handleExecutionException";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "printException";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createRunContent";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "setupRunContentRepresentation";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "findRunContentToClose";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "addEnvGoExperimentsFromBuildSettings";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "mergeGoExperiments";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "configurePath";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvVars";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getWslPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 22, 23, 25, 27, 29, 31, 32, 33, 34, 35, 37, 39, 40, 42, 43, 44, 45, 46, 47, 57, 60, 71, 73, 77, 78 -> new IllegalStateException(string);
        };
    }

    public static final class ExecutionResult {
        @NotNull
        public final Status status;
        @Nullable
        @Nls
        public final String message;

        private ExecutionResult(@NotNull Status status, @Nullable @Nls String message) {
            if (status == null) {
                ExecutionResult.$$$reportNull$$$0(0);
            }
            this.status = status;
            this.message = message;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/goide/util/GoExecutor$ExecutionResult", "<init>"));
        }

        public static enum Status {
            SUCCEEDED,
            FAILED,
            CANCELLED,
            NOT_STARTED;

        }
    }

    private static final class ProxyData {
        private final String myProxy;
        private final String myNoProxy;

        private ProxyData(String proxy, String noProxy) {
            this.myProxy = proxy;
            this.myNoProxy = noProxy;
        }
    }
}

