/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.psi.impl;

import com.goide.psi.impl.manipulator.GoStringManipulator;
import com.goide.vgo.mod.psi.VgoGoVersionDirective;
import com.goide.vgo.mod.psi.VgoModuleDirective;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.mod.psi.VgoRetractSpec;
import com.goide.vgo.mod.psi.VgoToolchainDirective;
import com.goide.vgo.mod.psi.VgoTypes;
import com.goide.vgo.mod.psi.VgoVersionRange;
import com.goide.vgo.mod.psi.impl.VgoGoVersionDirectiveImpl;
import com.goide.vgo.mod.psi.impl.VgoModuleDirectiveImpl;
import com.goide.vgo.mod.psi.impl.VgoReferenceSet;
import com.goide.vgo.mod.psi.impl.VgoToolchainDirectiveImpl;
import com.goide.vgo.mod.psi.stub.VgoGoVersionDirectiveStub;
import com.goide.vgo.mod.psi.stub.VgoModuleDirectiveStub;
import com.goide.vgo.mod.psi.stub.VgoToolchainDirectiveStub;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoPsiImplUtil {
    @NotNull
    private static final TokenSet IDENTIFIER_OR_STRING = TokenSet.create((IElementType[])new IElementType[]{VgoTypes.IDENTIFIER, VgoTypes.STRING, VgoTypes.RAW_STRING});
    private static final Pattern INDIRECT_COMMENT_PATTERN = Pattern.compile("//[ \t]*indirect.*");

    private VgoPsiImplUtil() {
    }

    @NotNull
    public static @NotNull FileReference @NotNull [] getReferences(@NotNull VgoModuleSpec moduleSpec) {
        if (moduleSpec == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(0);
        }
        FileReference[] fileReferenceArray = (FileReference[])CachedValuesManager.getCachedValue((PsiElement)moduleSpec, () -> CachedValueProvider.Result.create((Object)VgoReferenceSet.fromModuleSpec(moduleSpec).getAllReferences(), (Object[])new Object[]{moduleSpec}));
        if (fileReferenceArray == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(1);
        }
        return fileReferenceArray;
    }

    @NotNull
    public static PsiElement getIdentifier(@NotNull VgoModuleSpec moduleSpec) {
        if (moduleSpec == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(2);
        }
        ASTNode[] children = moduleSpec.getNode().getChildren(IDENTIFIER_OR_STRING);
        assert (children.length == 1 || children.length == 2);
        PsiElement psiElement = children[0].getPsi();
        if (psiElement == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getModuleVersion(@NotNull VgoModuleSpec moduleSpec) {
        if (moduleSpec == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(4);
        }
        ASTNode[] children = moduleSpec.getNode().getChildren(IDENTIFIER_OR_STRING);
        assert (children.length == 1 || children.length == 2);
        if (children.length == 1) {
            return null;
        }
        return children[1].getPsi();
    }

    public static boolean isIndirect(@NotNull VgoModuleSpec moduleSpec) {
        PsiElement child;
        if (moduleSpec == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(5);
        }
        return (child = moduleSpec.getLastChild()) instanceof PsiComment && INDIRECT_COMMENT_PATTERN.matcher(child.getText()).matches();
    }

    @Nullable
    public static String getName(@NotNull VgoModuleDirective moduleDirective) {
        VgoModuleDirectiveStub stub;
        if (moduleDirective == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(6);
        }
        if ((stub = (VgoModuleDirectiveStub)((VgoModuleDirectiveImpl)moduleDirective).getGreenStub()) != null) {
            return stub.getName();
        }
        PsiElement identifier = moduleDirective.getIdentifierOrString();
        if (identifier == null) {
            return null;
        }
        return GoStringManipulator.unquote(identifier.getText());
    }

    @Nullable
    public static PsiElement getNameIdentifier(@NotNull VgoModuleDirective moduleDirective) {
        if (moduleDirective == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(7);
        }
        return moduleDirective.getIdentifierOrString();
    }

    @Nullable
    public static PsiElement getIdentifierOrString(@NotNull VgoModuleDirective moduleDirective) {
        if (moduleDirective == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(8);
        }
        return (PsiElement)ObjectUtils.coalesce((Object)moduleDirective.getIdentifier(), (Object)moduleDirective.getString(), (Object)moduleDirective.getRawString());
    }

    @Nullable
    public static PsiNamedElement setName(@NotNull VgoModuleDirective moduleDirective, @NotNull String name) {
        PsiElement moduleName;
        if (moduleDirective == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(9);
        }
        if (name == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(10);
        }
        if ((moduleName = moduleDirective.getIdentifierOrString()) == null) {
            return null;
        }
        return (PsiNamedElement)CachingReference.getManipulator((PsiElement)moduleDirective).handleContentChange((PsiElement)moduleDirective, moduleName.getTextRangeInParent(), name);
    }

    public static int getTextOffset(@NotNull VgoModuleDirective moduleDirective) {
        PsiElement moduleName;
        if (moduleDirective == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(11);
        }
        return (moduleName = moduleDirective.getIdentifierOrString()) != null ? moduleName.getTextRange().getStartOffset() : moduleDirective.getTextRange().getEndOffset();
    }

    @NotNull
    public static List<PsiElement> getVersions(@NotNull VgoVersionRange versionRange) {
        if (versionRange == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(12);
        }
        List list = ContainerUtil.map((Object[])versionRange.getNode().getChildren(IDENTIFIER_OR_STRING), ASTNode::getPsi);
        if (list == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    public static String getVersion(@NotNull VgoGoVersionDirective goVersionDirective) {
        VgoGoVersionDirectiveStub stub;
        if (goVersionDirective == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(14);
        }
        if ((stub = (VgoGoVersionDirectiveStub)((VgoGoVersionDirectiveImpl)goVersionDirective).getGreenStub()) != null) {
            return stub.getGoVersion();
        }
        PsiElement goVersion = goVersionDirective.getGoVersion();
        return goVersion != null ? goVersion.getText() : null;
    }

    @Nullable
    public static String getVersion(@NotNull VgoToolchainDirective goVersionDirective) {
        VgoToolchainDirectiveStub stub;
        if (goVersionDirective == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(15);
        }
        if ((stub = (VgoToolchainDirectiveStub)((VgoToolchainDirectiveImpl)goVersionDirective).getGreenStub()) != null) {
            return stub.getToolchainVersion();
        }
        PsiElement defaultVersion = goVersionDirective.getDefault();
        if (defaultVersion != null) {
            return "default";
        }
        PsiElement toolchainVersion = goVersionDirective.getToolchainVersion();
        return toolchainVersion != null ? toolchainVersion.getText() : null;
    }

    @Nullable
    public static PsiElement getVersion(@NotNull VgoRetractSpec retractSpec) {
        if (retractSpec == null) {
            VgoPsiImplUtil.$$$reportNull$$$0(16);
        }
        return (PsiElement)ObjectUtils.coalesce((Object)retractSpec.getIdentifier(), (Object)retractSpec.getString(), (Object)retractSpec.getRawString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSpec";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/mod/psi/impl/VgoPsiImplUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDirective";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionRange";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goVersionDirective";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retractSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/mod/psi/impl/VgoPsiImplUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifier";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifier";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIndirect";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNameIdentifier";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifierOrString";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTextOffset";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVersions";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 13 -> new IllegalStateException(string);
        };
    }
}

