/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.quickfix;

import com.goide.i18n.GoBundle;
import com.goide.psi.impl.GoElementFactory;
import com.goide.util.GoUtil;
import com.goide.vgo.VgoModuleInfoProviderImpl;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.mod.highlighting.VgoAnnotator;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.mod.psi.VgoUseDirective;
import com.goide.vgo.mod.psi.impl.VgoElementFactory;
import com.goide.vgo.mod.quickfix.VgoSyncDependencyFix;
import com.goide.vgo.project.VgoModulesRegistry;
import com.goide.vgo.project.VgoWorkspace;
import com.goide.vgo.wizard.VgoModuleBuilder;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000f\u0010\u0013\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/goide/vgo/mod/quickfix/VgoAddModuleToWorkspaceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "workspaceDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleRoots", "", "addOnCreation", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/Collection;Ljava/util/Collection;)V", "moduleName", "", "getFamilyName", "getName", "getElementToMakeWritable", "Lcom/intellij/psi/PsiElement;", "currentFile", "Lcom/intellij/psi/PsiFile;", "getWorkspaceFile", "Lorg/jetbrains/annotations/Nullable;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "applyFix", "", "descriptor", "readModuleName", "Companion", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nVgoAddModuleToWorkspaceFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VgoAddModuleToWorkspaceFix.kt\ncom/goide/vgo/mod/quickfix/VgoAddModuleToWorkspaceFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1611#2,9:126\n1863#2:135\n1864#2:137\n1620#2:138\n1#3:136\n*S KotlinDebug\n*F\n+ 1 VgoAddModuleToWorkspaceFix.kt\ncom/goide/vgo/mod/quickfix/VgoAddModuleToWorkspaceFix\n*L\n51#1:126,9\n51#1:135\n51#1:137\n51#1:138\n51#1:136\n*E\n"})
public final class VgoAddModuleToWorkspaceFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Module module;
    @NotNull
    private final VirtualFile workspaceDirectory;
    @NotNull
    private final Collection<VirtualFile> moduleRoots;
    @NotNull
    private final Collection<VirtualFile> addOnCreation;
    @Nullable
    private final String moduleName;

    public VgoAddModuleToWorkspaceFix(@NotNull Module module, @NotNull VirtualFile workspaceDirectory, @NotNull Collection<? extends VirtualFile> moduleRoots, @NotNull Collection<? extends VirtualFile> addOnCreation) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)workspaceDirectory, (String)"workspaceDirectory");
        Intrinsics.checkNotNullParameter(moduleRoots, (String)"moduleRoots");
        Intrinsics.checkNotNullParameter(addOnCreation, (String)"addOnCreation");
        this.module = module;
        this.workspaceDirectory = workspaceDirectory;
        this.moduleRoots = moduleRoots;
        this.addOnCreation = addOnCreation;
        this.moduleName = this.readModuleName();
    }

    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"vgo.intention.add.module.to.workspace.fix.family.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getName() {
        String string;
        if (this.moduleRoots.size() > 1) {
            String string2 = GoBundle.message((String)"vgo.intention.add.all.replaced.modules.to.workspace.fix.text", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else if (this.moduleRoots.size() == 1 && this.moduleName != null) {
            Object[] objectArray = new Object[]{this.moduleName};
            String string3 = GoBundle.message((String)"vgo.intention.add.module.to.workspace.fix.text", (Object[])objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else {
            string = this.getFamilyName();
        }
        return string;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        VirtualFile virtualFile = this.getWorkspaceFile();
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            psiFile = currentFile.getManager().findFile(it);
        } else {
            psiFile = null;
        }
        return (PsiElement)psiFile;
    }

    private final VirtualFile getWorkspaceFile() {
        return this.workspaceDirectory.findChild("go.work");
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        VirtualFile workFile = this.getWorkspaceFile();
        Collection addedModules = workFile == null ? (Collection)CollectionsKt.plus(this.addOnCreation, (Iterable)this.moduleRoots) : this.moduleRoots;
        Iterable $this$mapNotNull$iv = addedModules;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (Companion.calcPathToModule(it, this.workspaceDirectory) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List modulesPaths = (List)destination$iv$iv;
        if (workFile == null) {
            VirtualFile createdFile = VgoModuleBuilder.createGoWorkFile(this.module, this.workspaceDirectory, modulesPaths);
            FileEditorManager.getInstance((Project)project).openFile(createdFile, true);
        } else if (!((Collection)modulesPaths).isEmpty()) {
            Collection collection = modulesPaths;
            Project project2 = this.module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            VgoAddModuleToWorkspaceFix.Companion.addModulesToExistingGoWorkFile(collection, workFile, project2, this.module);
        }
    }

    private final String readModuleName() {
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.singleOrNull((Iterable)this.moduleRoots);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile moduleRoot = virtualFile;
        VirtualFile virtualFile2 = moduleRoot.findChild("go.mod");
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile goModFile = virtualFile2;
        return GoUtil.getModuleName(goModFile);
    }

    @JvmStatic
    @Nullable
    public static final VgoAddModuleToWorkspaceFix createFix(@Nullable Module module, @Nullable VirtualFile file) {
        return Companion.createFix(module, file);
    }

    @JvmStatic
    @Nullable
    public static final String calcPathToModule(@NotNull VirtualFile moduleRoot, @NotNull VirtualFile workspaceDirectory) {
        return Companion.calcPathToModule(moduleRoot, workspaceDirectory);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002J.\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0007\u00a8\u0006\u0018"}, d2={"Lcom/goide/vgo/mod/quickfix/VgoAddModuleToWorkspaceFix$Companion;", "", "<init>", "()V", "createFix", "Lcom/goide/vgo/mod/quickfix/VgoAddModuleToWorkspaceFix;", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "workFileHasUseDirectiveForGoModule", "", "workspaceFile", "moduleRoot", "addModulesToExistingGoWorkFile", "", "moduleRootPaths", "", "", "goWorkFile", "project", "Lcom/intellij/openapi/project/Project;", "calcPathToModule", "workspaceDirectory", "intellij.go.impl"})
    @SourceDebugExtension(value={"SMAP\nVgoAddModuleToWorkspaceFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VgoAddModuleToWorkspaceFix.kt\ncom/goide/vgo/mod/quickfix/VgoAddModuleToWorkspaceFix$Companion\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n455#2:126\n455#2:127\n669#3,11:128\n1#4:139\n*S KotlinDebug\n*F\n+ 1 VgoAddModuleToWorkspaceFix.kt\ncom/goide/vgo/mod/quickfix/VgoAddModuleToWorkspaceFix$Companion\n*L\n81#1:126\n97#1:127\n97#1:128,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final VgoAddModuleToWorkspaceFix createFix(@Nullable Module module, @Nullable VirtualFile file) {
            if (module == null || file == null) {
                return null;
            }
            VirtualFile virtualFile = VgoModuleInfoProviderImpl.findWorkspaceFile(file);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile workspaceFile = virtualFile;
            VirtualFile workspaceDirectory = workspaceFile.getParent();
            VirtualFile virtualFile2 = VgoUtil.findModuleRootSkippingVendor(module, file);
            if (virtualFile2 == null) {
                return null;
            }
            VirtualFile moduleRoot = virtualFile2;
            if (!VfsUtilCore.isAncestor((VirtualFile)workspaceDirectory, (VirtualFile)moduleRoot, (boolean)false)) {
                return null;
            }
            if (this.workFileHasUseDirectiveForGoModule(module, workspaceFile, moduleRoot)) {
                return null;
            }
            Intrinsics.checkNotNull((Object)workspaceDirectory);
            return new VgoAddModuleToWorkspaceFix(module, workspaceDirectory, CollectionsKt.listOf((Object)moduleRoot), CollectionsKt.emptyList());
        }

        private final boolean workFileHasUseDirectiveForGoModule(Module module, VirtualFile workspaceFile, VirtualFile moduleRoot) {
            PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(workspaceFile);
            if (psiFile == null) {
                return false;
            }
            PsiFile workspacePsiFile = psiFile;
            PsiElement $this$childrenOfType$iv = (PsiElement)workspacePsiFile;
            boolean $i$f$childrenOfType = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, VgoUseDirective.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            for (VgoUseDirective useDirective : list) {
                for (VgoModuleSpec spec : useDirective.getModuleSpecList()) {
                    PsiFileSystemItem resolved = VgoAnnotator.resolveFileReference(spec);
                    if (!(resolved instanceof PsiDirectory) || !Intrinsics.areEqual((Object)((PsiDirectory)resolved).getVirtualFile(), (Object)moduleRoot)) continue;
                    return true;
                }
            }
            return false;
        }

        private final void addModulesToExistingGoWorkFile(Collection<String> moduleRootPaths, VirtualFile goWorkFile, Project project, Module module) {
            Object v2;
            Object it;
            PsiFile workspacePsiFile;
            block8: {
                Iterator<String> $this$singleOrNull$iv;
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(goWorkFile);
                if (psiFile == null) {
                    return;
                }
                workspacePsiFile = psiFile;
                Object $this$childrenOfType$iv = (PsiElement)workspacePsiFile;
                boolean $i$f$childrenOfType = false;
                List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, VgoUseDirective.class);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                $this$childrenOfType$iv = list;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                Iterator iterator = $this$singleOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    it = (VgoUseDirective)element$iv;
                    boolean bl = false;
                    if (!(it.getLparen() != null)) continue;
                    if (found$iv) {
                        v2 = null;
                        break block8;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            VgoUseDirective existingDirective = v2;
            for (String moduleRootPath : moduleRootPaths) {
                PsiElement psiElement;
                String quotedPath;
                Intrinsics.checkNotNullExpressionValue((Object)VgoElementFactory.quoteModuleSpecIfNeeded(moduleRootPath), (String)"quoteModuleSpecIfNeeded(...)");
                if (existingDirective != null) {
                    PsiElement anchor;
                    List<VgoModuleSpec> list = existingDirective.getModuleSpecList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getModuleSpecList(...)");
                    VgoModuleSpec vgoModuleSpec = (VgoModuleSpec)CollectionsKt.lastOrNull(list);
                    PsiElement psiElement2 = anchor = vgoModuleSpec != null ? (PsiElement)vgoModuleSpec : existingDirective.getLparen();
                    if (VgoElementFactory.createModuleSpec(project, quotedPath) != null) {
                        boolean bl = false;
                        existingDirective.addAfter((PsiElement)it, anchor);
                        psiElement = existingDirective.addAfter(PsiParserFacade.getInstance((Project)project).createWhiteSpaceFromText("\n\t"), anchor);
                        continue;
                    }
                    psiElement = null;
                    continue;
                }
                workspacePsiFile.add(GoElementFactory.createNewLine(project));
                psiElement = workspacePsiFile.add((PsiElement)VgoElementFactory.createUseDirective(project, (Collection<String>)Collections.singleton(quotedPath)));
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(workspacePsiFile);
            if (document != null) {
                Document it2 = document;
                boolean bl = false;
                FileDocumentManager.getInstance().saveDocument(it2);
            }
            VgoWorkspace vgoWorkspace = VgoModulesRegistry.getInstance(project).findWorkspaceByRoot(module, goWorkFile.getParent());
            if (vgoWorkspace == null) {
                return;
            }
            VgoWorkspace workspace = vgoWorkspace;
            VgoSyncDependencyFix.syncModules(project, GoUtil.module((PsiElement)workspacePsiFile), workspace, false, true);
        }

        @JvmStatic
        @Nullable
        public final String calcPathToModule(@NotNull VirtualFile moduleRoot, @NotNull VirtualFile workspaceDirectory) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)moduleRoot, (String)"moduleRoot");
            Intrinsics.checkNotNullParameter((Object)workspaceDirectory, (String)"workspaceDirectory");
            String string = VfsUtilCore.getRelativePath((VirtualFile)moduleRoot, (VirtualFile)workspaceDirectory);
            if (string == null) {
                return null;
            }
            String pathToModule = string;
            CharSequence charSequence2 = pathToModule;
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = ".";
            } else {
                charSequence = charSequence2;
            }
            return (String)charSequence;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

