/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.quickfix;

import com.goide.i18n.GoBundle;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.psi.impl.GoElementFactory;
import com.goide.sdk.GoSdkVersion;
import com.goide.util.GoUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.mod.psi.VgoGoVersionDirective;
import com.goide.vgo.mod.psi.VgoModuleDirective;
import com.goide.vgo.mod.psi.impl.VgoElementFactory;
import com.goide.vgo.project.VgoModule;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\b\u0010\n\u001a\u00020\u0004H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/goide/vgo/mod/quickfix/VgoAddOrUpdateGoVersionFix;", "Lcom/goide/intentions/GoBaseIntentionAction;", "Lcom/intellij/codeInspection/LocalQuickFix;", "goVersion", "", "<init>", "(Ljava/lang/String;)V", "version", "Lcom/goide/sdk/GoSdkVersion;", "(Lcom/goide/sdk/GoSdkVersion;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "getContextFileOrFile", "Lcom/intellij/psi/PsiFile;", "addOrUpdateGoVersion", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.go.impl"})
public final class VgoAddOrUpdateGoVersionFix
extends GoBaseIntentionAction
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String goVersion;

    public VgoAddOrUpdateGoVersionFix(@NotNull String goVersion) {
        Intrinsics.checkNotNullParameter((Object)goVersion, (String)"goVersion");
        this.goVersion = goVersion;
        this.setText(Companion.name(this.goVersion));
    }

    public VgoAddOrUpdateGoVersionFix(@NotNull GoSdkVersion version) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        String string = version.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this(string);
    }

    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"vgo.intention.add.or.update.go.version.fix.family.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        PsiFile psiFile = this.getContextFileOrFile(psiElement);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        Module module = GoUtil.module((PsiElement)psiFile2);
        this.addOrUpdateGoVersion(project, module, file);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = this.getContextFileOrFile(element);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        Module module = GoUtil.module((PsiElement)psiFile2);
        this.addOrUpdateGoVersion(project, module, file);
    }

    private final PsiFile getContextFileOrFile(PsiElement element) {
        PsiElement psiElement = element.getContext();
        if (psiElement == null) {
            psiElement = element;
        }
        return psiElement.getContainingFile();
    }

    private final void addOrUpdateGoVersion(Project project, Module module, VirtualFile file) {
        Object object = VgoUtil.findModuleAndDependencyOfFile(project, module, file);
        if (object == null || (object = (VgoModule)((Pair.NonNull)object).first) == null) {
            return;
        }
        Object vgoModule = object;
        VirtualFile virtualFile = ((VgoModule)vgoModule).getRoot().findChild("go.mod");
        if (virtualFile == null) {
            return;
        }
        VirtualFile goModVirtualFile = virtualFile;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(goModVirtualFile);
        VgoFile vgoFile = psiFile instanceof VgoFile ? (VgoFile)psiFile : null;
        if (vgoFile == null) {
            return;
        }
        VgoFile goMod = vgoFile;
        VgoGoVersionDirective vgoGoVersionDirective = VgoElementFactory.createGoVersionDirective(project, this.goVersion);
        Intrinsics.checkNotNullExpressionValue((Object)vgoGoVersionDirective, (String)"createGoVersionDirective(...)");
        VgoGoVersionDirective newVersionDirective = vgoGoVersionDirective;
        VgoGoVersionDirective versionDirective = (VgoGoVersionDirective)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)goMod), VgoGoVersionDirective.class);
        if (versionDirective != null) {
            v4 = versionDirective.replace(newVersionDirective);
        } else {
            VgoModuleDirective vgoModuleDirective = (VgoModuleDirective)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)goMod), VgoModuleDirective.class);
            if (vgoModuleDirective == null) {
                return;
            }
            VgoModuleDirective anchor = vgoModuleDirective;
            goMod.addAfter(newVersionDirective, anchor);
            PsiElement psiElement = GoElementFactory.createNewLine(project, 2);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createNewLine(...)");
            PsiElement newLines = psiElement;
            v4 = goMod.addAfter(newLines, anchor);
        }
    }

    @JvmStatic
    @IntentionName
    @NotNull
    public static final String name(@NotNull String goVersion) {
        return Companion.name(goVersion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/goide/vgo/mod/quickfix/VgoAddOrUpdateGoVersionFix$Companion;", "", "<init>", "()V", "name", "", "goVersion", "intellij.go.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @IntentionName
        @NotNull
        public final String name(@NotNull String goVersion) {
            Intrinsics.checkNotNullParameter((Object)goVersion, (String)"goVersion");
            Object[] objectArray = new Object[]{goVersion};
            String string = GoBundle.message((String)"vgo.intention.add.or.update.go.version.fix.text", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

