/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.FilesProcessorImpl;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\b'\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001c\u001a\u00020\rH'J\b\u0010\u001d\u001a\u00020\rH'J\b\u0010$\u001a\u00020%H\u0014J\r\u0010&\u001a\u00070'\u00a2\u0006\u0002\b(H\u0002J\r\u0010)\u001a\u00070'\u00a2\u0006\u0002\b(H\u0002J\r\u0010*\u001a\u00070'\u00a2\u0006\u0002\b(H\u0002J\r\u0010+\u001a\u00070'\u00a2\u0006\u0002\b(H\u0002J\b\u0010,\u001a\u00020-H\u0002J\u000f\u0010.\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020%H\u0014J\u0010\u00101\u001a\u00020%2\u0006\u00102\u001a\u00020-H\u0014J\b\u00103\u001a\u00020-H\u0014J\b\u00104\u001a\u00020-H\u0002J\b\u00105\u001a\u00020-H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0012\u0010\u0012\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0012\u0010\u0014\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0012\u0010\u0016\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0016\u0010\u0018\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0012\u0010\u001a\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0018\u0010\u001e\u001a\u0004\u0018\u00010\r8\u0014X\u0095\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000fR\u0016\u0010 \u001a\u00020\r8\u0014X\u0095\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000fR\u0016\u0010\"\u001a\u00020\r8\u0014X\u0095\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000f\u00a8\u00066"}, d2={"Lcom/intellij/openapi/vcs/FilesProcessorWithNotificationImpl;", "Lcom/intellij/openapi/vcs/FilesProcessorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "NOTIFICATION_LOCK", "Ljava/lang/Object;", "notification", "Lcom/intellij/notification/Notification;", "notificationDisplayId", "", "getNotificationDisplayId", "()Ljava/lang/String;", "askedBeforeProperty", "getAskedBeforeProperty", "doForCurrentProjectProperty", "getDoForCurrentProjectProperty", "showActionText", "getShowActionText", "forCurrentProjectActionText", "getForCurrentProjectActionText", "forAllProjectsActionText", "getForAllProjectsActionText", "muteActionText", "getMuteActionText", "notificationTitle", "notificationMessage", "viewFilesDialogTitle", "getViewFilesDialogTitle", "viewFilesDialogOkActionName", "getViewFilesDialogOkActionName", "viewFilesDialogCancelActionName", "getViewFilesDialogCancelActionName", "handleProcessingForCurrentProject", "", "showAction", "Lcom/intellij/notification/NotificationAction;", "Lorg/jetbrains/annotations/NotNull;", "addForCurrentProjectAction", "forAllProjectsAction", "muteAction", "notificationNotPresent", "", "expireNotification", "()Lkotlin/Unit;", "rememberForAllProjects", "setForCurrentProject", "isEnabled", "needDoForCurrentProject", "notAskedBefore", "wasAskedBefore", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFilesProcessorWithNotificationImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilesProcessorWithNotificationImpl.kt\ncom/intellij/openapi/vcs/FilesProcessorWithNotificationImpl\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,127:1\n37#2:128\n36#2,3:129\n*S KotlinDebug\n*F\n+ 1 FilesProcessorWithNotificationImpl.kt\ncom/intellij/openapi/vcs/FilesProcessorWithNotificationImpl\n*L\n59#1:128\n59#1:129,3\n*E\n"})
public abstract class FilesProcessorWithNotificationImpl
extends FilesProcessorImpl {
    @NotNull
    private final Object NOTIFICATION_LOCK;
    @Nullable
    private Notification notification;
    @Nullable
    private final String forAllProjectsActionText;
    @NlsContexts.DialogTitle
    @Nullable
    private final String viewFilesDialogTitle;
    @NlsContexts.Button
    @NotNull
    private final String viewFilesDialogOkActionName;
    @NlsContexts.Button
    @NotNull
    private final String viewFilesDialogCancelActionName;

    public FilesProcessorWithNotificationImpl(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(project, parentDisposable);
        this.NOTIFICATION_LOCK = new Object();
        String string = CommonBundle.getAddButtonText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAddButtonText(...)");
        this.viewFilesDialogOkActionName = string;
        String string2 = CommonBundle.getCancelButtonText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCancelButtonText(...)");
        this.viewFilesDialogCancelActionName = string2;
    }

    @NotNull
    public abstract String getNotificationDisplayId();

    @NotNull
    public abstract String getAskedBeforeProperty();

    @NotNull
    public abstract String getDoForCurrentProjectProperty();

    @NotNull
    public abstract String getShowActionText();

    @NotNull
    public abstract String getForCurrentProjectActionText();

    @Nullable
    public String getForAllProjectsActionText() {
        return this.forAllProjectsActionText;
    }

    @NotNull
    public abstract String getMuteActionText();

    @NlsContexts.NotificationTitle
    @NotNull
    public abstract String notificationTitle();

    @NlsContexts.NotificationContent
    @NotNull
    public abstract String notificationMessage();

    @Nullable
    protected String getViewFilesDialogTitle() {
        return this.viewFilesDialogTitle;
    }

    @NotNull
    protected String getViewFilesDialogOkActionName() {
        return this.viewFilesDialogOkActionName;
    }

    @NotNull
    protected String getViewFilesDialogCancelActionName() {
        return this.viewFilesDialogCancelActionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleProcessingForCurrentProject() {
        Object object = this.NOTIFICATION_LOCK;
        synchronized (object) {
            boolean bl = false;
            if (this.notAskedBefore() && this.notificationNotPresent()) {
                Object object2 = new NotificationAction[]{this.showAction(), this.addForCurrentProjectAction()};
                Object $this$handleProcessingForCurrentProject_u24lambda_u241_u24lambda_u240 = object2 = CollectionsKt.mutableListOf((Object[])object2);
                boolean bl2 = false;
                if (this.getForAllProjectsActionText() != null) {
                    $this$handleProcessingForCurrentProject_u24lambda_u241_u24lambda_u240.add(this.forAllProjectsAction());
                }
                $this$handleProcessingForCurrentProject_u24lambda_u241_u24lambda_u240.add(this.muteAction());
                Object notificationActions = object2;
                Collection $this$toTypedArray$iv = (Collection)notificationActions;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                object2 = thisCollection$iv.toArray(new NotificationAction[0]);
                this.notification = VcsNotifier.getInstance(this.getProject()).notifyMinorInfo(this.getNotificationDisplayId(), true, this.notificationTitle(), this.notificationMessage(), (NotificationAction[])Arrays.copyOf(object2, ((Object)object2).length));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final NotificationAction showAction() {
        NotificationAction notificationAction = NotificationAction.createSimple((String)this.getShowActionText(), () -> FilesProcessorWithNotificationImpl.showAction$lambda$2(this));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimple(...)");
        return notificationAction;
    }

    private final NotificationAction addForCurrentProjectAction() {
        NotificationAction notificationAction = NotificationAction.create((String)this.getForCurrentProjectActionText(), (arg_0, arg_1) -> FilesProcessorWithNotificationImpl.addForCurrentProjectAction$lambda$4((arg_0, arg_1) -> FilesProcessorWithNotificationImpl.addForCurrentProjectAction$lambda$3(this, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"create(...)");
        return notificationAction;
    }

    private final NotificationAction forAllProjectsAction() {
        String string = this.getForAllProjectsActionText();
        Intrinsics.checkNotNull((Object)string);
        NotificationAction notificationAction = NotificationAction.create((String)string, (arg_0, arg_1) -> FilesProcessorWithNotificationImpl.forAllProjectsAction$lambda$6((arg_0, arg_1) -> FilesProcessorWithNotificationImpl.forAllProjectsAction$lambda$5(this, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"create(...)");
        return notificationAction;
    }

    private final NotificationAction muteAction() {
        NotificationAction notificationAction = NotificationAction.create((String)this.getMuteActionText(), (arg_0, arg_1) -> FilesProcessorWithNotificationImpl.muteAction$lambda$8((arg_0, arg_1) -> FilesProcessorWithNotificationImpl.muteAction$lambda$7(this, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"create(...)");
        return notificationAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean notificationNotPresent() {
        boolean bl;
        Object object = this.NOTIFICATION_LOCK;
        synchronized (object) {
            boolean bl2 = false;
            Notification notification = this.notification;
            bl = notification != null ? notification.isExpired() : true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Unit expireNotification() {
        Unit unit;
        Object object = this.NOTIFICATION_LOCK;
        synchronized (object) {
            Unit unit2;
            boolean bl = false;
            Notification notification = this.notification;
            if (notification != null) {
                notification.expire();
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            unit = unit2;
        }
        return unit;
    }

    protected void rememberForAllProjects() {
        throw new UnsupportedOperationException();
    }

    protected void setForCurrentProject(boolean isEnabled) {
        PropertiesComponent.getInstance((Project)this.getProject()).setValue(this.getDoForCurrentProjectProperty(), isEnabled);
    }

    @Override
    protected boolean needDoForCurrentProject() {
        return PropertiesComponent.getInstance((Project)this.getProject()).getBoolean(this.getDoForCurrentProjectProperty(), false);
    }

    private final boolean notAskedBefore() {
        return !this.wasAskedBefore();
    }

    private final boolean wasAskedBefore() {
        return PropertiesComponent.getInstance((Project)this.getProject()).getBoolean(this.getAskedBeforeProperty(), false);
    }

    private static final void showAction$lambda$2(FilesProcessorWithNotificationImpl this$0) {
        List<VirtualFile> allFiles = this$0.selectValidFiles();
        if (!((Collection)allFiles).isEmpty()) {
            SelectFilesDialog selectFilesDialog = SelectFilesDialog.init(this$0.getProject(), allFiles, null, null, true, true, this$0.getViewFilesDialogOkActionName(), this$0.getViewFilesDialogCancelActionName());
            Intrinsics.checkNotNullExpressionValue((Object)((Object)selectFilesDialog), (String)"init(...)");
            SelectFilesDialog dialog = selectFilesDialog;
            dialog.setTitle(this$0.getViewFilesDialogTitle());
            dialog.setSelectedFiles((Collection<VirtualFile>)allFiles);
            if (dialog.showAndGet()) {
                Collection<VirtualFile> userSelectedFiles = dialog.getSelectedFiles();
                Intrinsics.checkNotNull(userSelectedFiles);
                this$0.doActionOnChosenFiles(userSelectedFiles);
                this$0.removeFiles(userSelectedFiles);
                if (this$0.isFilesEmpty()) {
                    this$0.expireNotification();
                }
            }
        }
    }

    private static final Unit addForCurrentProjectAction$lambda$3(FilesProcessorWithNotificationImpl this$0, AnActionEvent anActionEvent, Notification notification) {
        this$0.doActionOnChosenFiles((Collection<? extends VirtualFile>)this$0.acquireValidFiles());
        this$0.setForCurrentProject(true);
        PropertiesComponent.getInstance((Project)this$0.getProject()).setValue(this$0.getAskedBeforeProperty(), true);
        this$0.expireNotification();
        return Unit.INSTANCE;
    }

    private static final void addForCurrentProjectAction$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit forAllProjectsAction$lambda$5(FilesProcessorWithNotificationImpl this$0, AnActionEvent anActionEvent, Notification notification) {
        this$0.doActionOnChosenFiles((Collection<? extends VirtualFile>)this$0.acquireValidFiles());
        this$0.setForCurrentProject(true);
        PropertiesComponent.getInstance((Project)this$0.getProject()).setValue(this$0.getAskedBeforeProperty(), true);
        this$0.rememberForAllProjects();
        this$0.expireNotification();
        return Unit.INSTANCE;
    }

    private static final void forAllProjectsAction$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit muteAction$lambda$7(FilesProcessorWithNotificationImpl this$0, AnActionEvent anActionEvent, Notification notification) {
        this$0.setForCurrentProject(false);
        PropertiesComponent.getInstance((Project)this$0.getProject()).setValue(this$0.getAskedBeforeProperty(), true);
        notification.expire();
        return Unit.INSTANCE;
    }

    private static final void muteAction$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

