/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.moveattributein;

import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.xrp.base.XRPUsageInfo;

class MoveAttributeIn
extends XRPUsageInfo {
    private final XmlTag tag;
    private final String attributeName;
    private final String attributeNamespace;
    private final String tagName;

    MoveAttributeIn(XmlTag tag, String tagName, String attributeName, String attributeNamespace) {
        super((PsiElement)tag);
        this.tag = tag;
        this.attributeName = attributeName;
        this.attributeNamespace = attributeNamespace;
        this.tagName = tagName;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        XmlTag[] tags;
        XmlAttribute attribute = this.tag.getAttribute(this.attributeName, this.attributeNamespace);
        if (attribute == null) {
            return;
        }
        String value = attribute.getValue();
        for (XmlTag childTag : tags = this.tag.getSubTags()) {
            if (!childTag.getName().equals(this.tagName)) continue;
            childTag.setAttribute(this.attributeName, this.attributeNamespace, value);
        }
        attribute.delete();
    }
}

