/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.renametag;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.renametag.RenameTag;
import com.sixrr.xrp.renametag.RenameTagUsageViewDescriptor;
import com.sixrr.xrp.utils.RefactorXBundle;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RenameTagProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final String newTagName;
    private final Context context;

    RenameTagProcessor(XmlTag tag, String newTagName, Context context) {
        super(tag.getProject());
        this.tag = tag;
        this.newTagName = newTagName;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usageInfos) {
        if (usageInfos == null) {
            RenameTagProcessor.$$$reportNull$$$0(0);
        }
        return new RenameTagUsageViewDescriptor(this.tag);
    }

    @Override
    public void findUsages(@NotNull List<? super XRPUsageInfo> usages) {
        if (usages == null) {
            RenameTagProcessor.$$$reportNull$$$0(1);
        }
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            if (xmlTag == null) continue;
            usages.add(new RenameTag(xmlTag, this.newTagName));
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactorXBundle.message("command.name.rename.tag.0", this.tag.getName());
        if (string == null) {
            RenameTagProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/xrp/renametag/RenameTagProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/xrp/renametag/RenameTagProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

