/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.endpoints;

import com.intellij.grpc.endpoints.ProtoUrlTargetInfoKt;
import com.intellij.grpc.model.ProtoRpcModel;
import com.intellij.grpc.model.ProtoServiceModel;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PartiallyKnownString;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/grpc/endpoints/ProtoUrlTargetInfo;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "serviceModel", "Lcom/intellij/grpc/model/ProtoServiceModel;", "endpointModel", "Lcom/intellij/grpc/model/ProtoRpcModel;", "<init>", "(Lcom/intellij/grpc/model/ProtoServiceModel;Lcom/intellij/grpc/model/ProtoRpcModel;)V", "schemes", "", "", "getSchemes", "()Ljava/util/List;", "authorities", "Lcom/intellij/microservices/url/Authority;", "getAuthorities", "path", "Lcom/intellij/microservices/url/UrlPath;", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "resolveToPsiElement", "Lcom/intellij/psi/PsiElement;", "methods", "", "getMethods", "()Ljava/util/Set;", "intellij.grpc"})
public final class ProtoUrlTargetInfo
implements UrlTargetInfo {
    @NotNull
    private final ProtoServiceModel serviceModel;
    @NotNull
    private final ProtoRpcModel endpointModel;

    public ProtoUrlTargetInfo(@NotNull ProtoServiceModel serviceModel, @NotNull ProtoRpcModel endpointModel) {
        Intrinsics.checkNotNullParameter((Object)serviceModel, (String)"serviceModel");
        Intrinsics.checkNotNullParameter((Object)endpointModel, (String)"endpointModel");
        this.serviceModel = serviceModel;
        this.endpointModel = endpointModel;
    }

    @NotNull
    public List<String> getSchemes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<Authority> getAuthorities() {
        return CollectionsKt.listOf((Object)new Authority.Exact("localhost:8080"));
    }

    @NotNull
    public UrlPath getPath() {
        return ProtoUrlTargetInfoKt.access$getUrlPathParser$p().parseUrlPath(new PartiallyKnownString(this.serviceModel.getServiceQualifiedName() + "/" + this.endpointModel.getShortName())).getUrlPath();
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        return (PsiElement)this.endpointModel.getSourcePsi();
    }

    @NotNull
    public Set<String> getMethods() {
        return SetsKt.setOf((Object)"GRPC");
    }
}

