/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.requests.execution;

import com.intellij.grpc.restClient.execution.GrpcRequestIdentity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ConcurrentFactoryMap;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0006H\u0002J$\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00062\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002R/\u0010\u0004\u001a#\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b0\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grpc/requests/execution/GrpcSharedChannelPool;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "channels", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/grpc/restClient/execution/GrpcRequestIdentity;", "kotlin.jvm.PlatformType", "Lio/grpc/ManagedChannel;", "Lorg/jetbrains/annotations/NotNull;", "dispose", "", "getOrCreateChannel", "grpcRequestIdentity", "createChannel", "createWithJdkSslProvider", "channelBuilder", "Lkotlin/Function1;", "disposeChannel", "", "channel", "intellij.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcSharedChannelPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcSharedChannelPool.kt\ncom/intellij/grpc/requests/execution/GrpcSharedChannelPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1782#2,4:66\n25#3:70\n25#3:72\n1#4:71\n*S KotlinDebug\n*F\n+ 1 GrpcSharedChannelPool.kt\ncom/intellij/grpc/requests/execution/GrpcSharedChannelPool\n*L\n17#1:66,4\n18#1:70\n59#1:72\n*E\n"})
public final class GrpcSharedChannelPool
implements Disposable {
    @NotNull
    private final ConcurrentMap<GrpcRequestIdentity, ManagedChannel> channels;

    public GrpcSharedChannelPool() {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> GrpcSharedChannelPool.channels$lambda$0((Function1)new Function1<GrpcRequestIdentity, ManagedChannel>((Object)this){

            public final ManagedChannel invoke(GrpcRequestIdentity p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GrpcSharedChannelPool.access$createChannel((GrpcSharedChannelPool)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.channels = concurrentMap;
    }

    public void dispose() {
        int n;
        Iterable $this$count$iv = this.channels.values();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ManagedChannel p0 = (ManagedChannel)element$iv;
                boolean bl = false;
                if (!this.disposeChannel(p0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int count = n;
        GrpcSharedChannelPool $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(GrpcSharedChannelPool.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn(count + " out of " + this.channels.size() + " channels were shutdown normally");
    }

    @NotNull
    public final ManagedChannel getOrCreateChannel(@NotNull GrpcRequestIdentity grpcRequestIdentity) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)grpcRequestIdentity, (String)"grpcRequestIdentity");
        ManagedChannel cachedChannel = (ManagedChannel)this.channels.get(grpcRequestIdentity);
        boolean bl2 = bl = cachedChannel != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Cached gRPC channel was 'null' but must be 'not null'";
            throw new AssertionError((Object)string);
        }
        ManagedChannel managedChannel = cachedChannel;
        Intrinsics.checkNotNull((Object)managedChannel);
        return managedChannel;
    }

    private final ManagedChannel createChannel(GrpcRequestIdentity grpcRequestIdentity) {
        return this.createWithJdkSslProvider(grpcRequestIdentity, (Function1<? super GrpcRequestIdentity, ? extends ManagedChannel>)((Function1)GrpcSharedChannelPool::createChannel$lambda$3));
    }

    private final ManagedChannel createWithJdkSslProvider(GrpcRequestIdentity grpcRequestIdentity, Function1<? super GrpcRequestIdentity, ? extends ManagedChannel> channelBuilder) {
        ManagedChannel managedChannel;
        boolean openSslAlreadyDisabled;
        String string = System.getProperty("io.grpc.netty.shaded.io.netty.handler.ssl.noOpenSsl");
        boolean bl = openSslAlreadyDisabled = string != null ? Boolean.parseBoolean(string) : false;
        if (!openSslAlreadyDisabled) {
            System.setProperty("io.grpc.netty.shaded.io.netty.handler.ssl.noOpenSsl", "true");
            ManagedChannel channel = (ManagedChannel)channelBuilder.invoke((Object)grpcRequestIdentity);
            System.setProperty("io.grpc.netty.shaded.io.netty.handler.ssl.noOpenSsl", "false");
            managedChannel = channel;
        } else {
            managedChannel = (ManagedChannel)channelBuilder.invoke((Object)grpcRequestIdentity);
        }
        return managedChannel;
    }

    private final boolean disposeChannel(ManagedChannel channel) {
        if (!channel.isShutdown()) {
            channel.shutdown();
        }
        if (!channel.isTerminated()) {
            channel.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        if (!channel.isTerminated()) {
            channel.shutdownNow();
            GrpcSharedChannelPool $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GrpcSharedChannelPool.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Force gRPC channel '" + channel.authority() + "' shutdown");
        }
        return channel.isTerminated();
    }

    private static final ManagedChannel channels$lambda$0(Function1 $tmp0, Object p0) {
        return (ManagedChannel)$tmp0.invoke(p0);
    }

    private static final ManagedChannel createChannel$lambda$3(GrpcRequestIdentity requestIdentity) {
        ManagedChannelBuilder<?> managedChannelBuilder;
        Intrinsics.checkNotNullParameter((Object)requestIdentity, (String)"requestIdentity");
        ManagedChannelBuilder<?> $this$createChannel_u24lambda_u243_u24lambda_u242 = managedChannelBuilder = ManagedChannelBuilder.forAddress(requestIdentity.getHost(), requestIdentity.getPort());
        boolean bl = false;
        Object obj = requestIdentity.getSecureConnection() ? $this$createChannel_u24lambda_u243_u24lambda_u242.useTransportSecurity() : $this$createChannel_u24lambda_u243_u24lambda_u242.usePlaintext();
        ManagedChannel managedChannel = managedChannelBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"build(...)");
        return managedChannel;
    }

    public static final /* synthetic */ ManagedChannel access$createChannel(GrpcSharedChannelPool $this, GrpcRequestIdentity grpcRequestIdentity) {
        return $this.createChannel(grpcRequestIdentity);
    }
}

