/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u0005H\u0014J\b\u0010\u000f\u001a\u00020\u0005H\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0014J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0014R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/javascript/JSStringLiteralLexer;", "Lcom/intellij/lexer/StringLiteralLexer;", "quoteChar", "", "originalLiteralToken", "Lcom/intellij/psi/tree/IElementType;", "additionalValidEscapes", "", "allowOctal", "", "allowUnicodeEscapesWithinBraces", "allowNonEscapesAfterSlash", "<init>", "(CLcom/intellij/psi/tree/IElementType;Ljava/lang/String;ZZZ)V", "getUnicodeEscapeSequenceType", "handleSingleSlashEscapeSequence", "locateHexEscapeSequence", "", "start", "i", "locateUnicodeEscapeSequence", "intellij.javascript.parser"})
public final class JSStringLiteralLexer
extends StringLiteralLexer {
    private final boolean allowUnicodeEscapesWithinBraces;
    private final boolean allowNonEscapesAfterSlash;

    public JSStringLiteralLexer(char quoteChar, @NotNull IElementType originalLiteralToken, @NotNull String additionalValidEscapes, boolean allowOctal, boolean allowUnicodeEscapesWithinBraces, boolean allowNonEscapesAfterSlash) {
        Intrinsics.checkNotNullParameter((Object)originalLiteralToken, (String)"originalLiteralToken");
        Intrinsics.checkNotNullParameter((Object)additionalValidEscapes, (String)"additionalValidEscapes");
        super(quoteChar, originalLiteralToken, true, additionalValidEscapes, allowOctal, true);
        this.allowUnicodeEscapesWithinBraces = allowUnicodeEscapesWithinBraces;
        this.allowNonEscapesAfterSlash = allowNonEscapesAfterSlash;
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        if (this.allowUnicodeEscapesWithinBraces && this.myStart + 2 < this.myEnd && this.myBuffer.charAt(this.myStart + 2) == '{') {
            IElementType iElementType;
            int i = this.myStart + 3;
            boolean foundHex = false;
            boolean hadDigitBefore = false;
            while (i < this.myEnd) {
                char c = this.myBuffer.charAt(i);
                if (hadDigitBefore && c == '_') {
                    ++i;
                    hadDigitBefore = false;
                    continue;
                }
                if (!StringUtil.isHexDigit((char)c)) break;
                foundHex = true;
                hadDigitBefore = true;
                ++i;
            }
            if (foundHex && i < this.myEnd && this.myBuffer.charAt(i) == '}') {
                IElementType iElementType2 = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                iElementType = iElementType2;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"VALID_STRING_ESCAPE_TOKEN");
            } else {
                IElementType iElementType3 = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                iElementType = iElementType3;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"INVALID_UNICODE_ESCAPE_TOKEN");
            }
            return iElementType;
        }
        int digitsCount = 0;
        boolean hadDigitBefore = false;
        int i = this.myStart + 2;
        while (digitsCount < 4) {
            if (i >= this.myEnd) {
                IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"INVALID_UNICODE_ESCAPE_TOKEN");
                return iElementType;
            }
            char c = this.myBuffer.charAt(i);
            if (!StringUtil.isHexDigit((char)c)) {
                if (!hadDigitBefore || c != '_') {
                    IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"INVALID_UNICODE_ESCAPE_TOKEN");
                    return iElementType;
                }
                hadDigitBefore = false;
                ++i;
                continue;
            }
            hadDigitBefore = true;
            ++digitsCount;
            ++i;
        }
        IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"VALID_STRING_ESCAPE_TOKEN");
        return iElementType;
    }

    @NotNull
    protected IElementType handleSingleSlashEscapeSequence() {
        IElementType iElementType;
        if (this.allowNonEscapesAfterSlash) {
            IElementType iElementType2 = this.myOriginalLiteralToken;
            iElementType = iElementType2;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"myOriginalLiteralToken");
        } else {
            IElementType iElementType3 = super.handleSingleSlashEscapeSequence();
            iElementType = iElementType3;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"handleSingleSlashEscapeSequence(...)");
        }
        return iElementType;
    }

    protected int locateHexEscapeSequence(int start, int i) {
        int i2 = i;
        if (!this.allowNonEscapesAfterSlash) {
            return super.locateHexEscapeSequence(start, i2);
        }
        ++i2;
        boolean isValid = true;
        while (i2 < start + 4) {
            if (i2 == this.myBufferEnd) {
                isValid = isValid && i2 == start + 3;
                return !isValid ? start + 1 : i2;
            }
            char c = this.myBuffer.charAt(i2);
            if (!StringUtil.isHexDigit((char)c)) {
                isValid = false;
            }
            if (c == '\n' || this.myBuffer.charAt(i2) == this.myQuoteChar) {
                return !isValid ? start + 1 : i2;
            }
            ++i2;
        }
        return !isValid ? start + 1 : i2;
    }

    protected int locateUnicodeEscapeSequence(int start, int i) {
        int i2 = i;
        if (this.allowUnicodeEscapesWithinBraces && ++i2 < this.myBufferEnd && this.myBuffer.charAt(i2) == '{') {
            ++i2;
            boolean hadDigitBefore = false;
            boolean isValid = true;
            while (i2 < this.myBufferEnd) {
                char c = this.myBuffer.charAt(i2);
                if (!StringUtil.isHexDigit((char)c)) {
                    if (!hadDigitBefore || c != '_') {
                        if (c == '}') break;
                        isValid = false;
                        break;
                    }
                    ++i2;
                    hadDigitBefore = false;
                    continue;
                }
                hadDigitBefore = true;
                ++i2;
            }
            if (i2 < this.myBufferEnd && this.myBuffer.charAt(i2) == '}') {
                ++i2;
            }
            return this.allowNonEscapesAfterSlash && !isValid ? start + 1 : i2;
        }
        int digitsCount = 0;
        boolean isValid = true;
        while (digitsCount < 4) {
            if (i2 == this.myBufferEnd) {
                return this.allowNonEscapesAfterSlash ? start + 1 : i2;
            }
            char c = this.myBuffer.charAt(i2);
            if (c == '\n' || c == this.myQuoteChar) {
                return this.allowNonEscapesAfterSlash && !isValid ? start + 1 : i2;
            }
            if (StringUtil.isHexDigit((char)c)) {
                ++digitsCount;
            } else {
                isValid = false;
            }
            ++i2;
        }
        return this.allowNonEscapesAfterSlash && !isValid ? start + 1 : i2;
    }
}

