/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.wasm.WebAssemblyInstancePrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstance;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstanceObject;

public class WebAssemblyInstancePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WebAssemblyInstancePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new WebAssemblyInstancePrototypeBuiltins();

    protected WebAssemblyInstancePrototypeBuiltins() {
        super(JSWebAssemblyInstance.PROTOTYPE_NAME, WebAssemblyInstancePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, WebAssemblyInstancePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return WebAssemblyInstancePrototypeBuiltinsFactory.WebAssemblyInstanceGetExportsNodeGen.create(context2, builtin, WebAssemblyInstancePrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum WebAssemblyInstancePrototype implements BuiltinEnum<WebAssemblyInstancePrototype>
    {
        exports(0);

        private final int length;

        private WebAssemblyInstancePrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isEnumerable() {
            return true;
        }

        @Override
        public boolean isGetter() {
            return this == exports;
        }
    }

    public static abstract class WebAssemblyInstanceGetExportsNode
    extends JSBuiltinNode {
        public WebAssemblyInstanceGetExportsNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object getExports(JSWebAssemblyInstanceObject instance) {
            return instance.getExports();
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        protected Object doIncompatibleReceiver(Object thisObj) {
            throw Errors.createTypeError("WebAssembly.Instance.exports(): Receiver is not a WebAssembly.Instance", (Node)this);
        }
    }
}

