/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspBundle;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerNotificationsHandler;
import com.intellij.platform.lsp.api.customization.LspIntentionAction;
import com.intellij.platform.lsp.impl.LspDynamicCapabilities;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.LogTraceParams;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ShowDocumentParams;
import org.eclipse.lsp4j.ShowDocumentResult;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.Unregistration;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 >2\u00020\u0001:\u0001>B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\t\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\t\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010\t\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0014\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0\u0007H\u0016J\u001e\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130!0\u00072\u0006\u0010\t\u001a\u00020$H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\t\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020(H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0016J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00072\u0006\u0010\t\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00112\u0006\u0010\t\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00112\u0006\u0010\t\u001a\u000202H\u0016J\u0010\u00104\u001a\u00020\u00112\u0006\u0010\t\u001a\u000205H\u0016J\u0010\u00106\u001a\u0002072\u0006\u0010\t\u001a\u000202H\u0002J:\u00108\u001a\b\u0012\u0004\u0012\u00020/0\u00072\b\b\u0001\u00109\u001a\u00020:2\u0006\u0010;\u001a\u0002072\u0006\u0010<\u001a\u00020:2\u0010\b\u0002\u0010=\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerNotificationsHandlerImpl;", "Lcom/intellij/platform/lsp/api/LspServerNotificationsHandler;", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "LspServerNotificationsHandlerImpl", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;)V", "applyEdit", "Ljava/util/concurrent/CompletableFuture;", "Lorg/eclipse/lsp4j/ApplyWorkspaceEditResponse;", "params", "Lorg/eclipse/lsp4j/ApplyWorkspaceEditParams;", "registerCapability", "Ljava/lang/Void;", "Lorg/eclipse/lsp4j/RegistrationParams;", "unregisterCapability", "Lorg/eclipse/lsp4j/UnregistrationParams;", "telemetryEvent", "", "object", "", "publishDiagnostics", "Lorg/eclipse/lsp4j/PublishDiagnosticsParams;", "showDocument", "Lorg/eclipse/lsp4j/ShowDocumentResult;", "Lorg/eclipse/lsp4j/ShowDocumentParams;", "a", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "focusEditor", "", "selection", "Lorg/eclipse/lsp4j/Range;", "workspaceFolders", "", "Lorg/eclipse/lsp4j/WorkspaceFolder;", "configuration", "Lorg/eclipse/lsp4j/ConfigurationParams;", "createProgress", "Lorg/eclipse/lsp4j/WorkDoneProgressCreateParams;", "notifyProgress", "Lorg/eclipse/lsp4j/ProgressParams;", "refreshSemanticTokens", "refreshCodeLenses", "refreshInlayHints", "refreshInlineValues", "refreshDiagnostics", "showMessageRequest", "Lorg/eclipse/lsp4j/MessageActionItem;", "Lorg/eclipse/lsp4j/ShowMessageRequestParams;", "showMessage", "Lorg/eclipse/lsp4j/MessageParams;", "logMessage", "logTrace", "Lorg/eclipse/lsp4j/LogTraceParams;", "a", "Lcom/intellij/notification/NotificationType;", "a", "message", "", "type", "notificationGroup", "actionItems", "Companion", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspServerNotificationsHandlerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspServerNotificationsHandlerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerNotificationsHandlerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n1863#2,2:246\n1863#2,2:248\n1557#2:254\n1628#2,3:255\n1863#2,2:258\n11158#3:250\n11493#3,3:251\n1#4:260\n*S KotlinDebug\n*F\n+ 1 LspServerNotificationsHandlerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerNotificationsHandlerImpl\n*L\n59#1:246,2\n64#1:248,2\n137#1:254\n137#1:255,3\n210#1:258,2\n129#1:250\n129#1:251,3\n*E\n"})
public final class LspServerNotificationsHandlerImpl
implements LspServerNotificationsHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LspServerImpl lspServer;
    @NotNull
    public static final String SHOW_MESSAGE_NOTIFICATION_GROUP = "LSP window/showMessage";
    @NotNull
    private static final String LOG_ERRORS_WARNINGS_NOTIFICATION_GROUP = "LSP window/logMessage: errors, warnings";
    @NotNull
    private static final String LOG_INFO_TRACE_NOTIFICATION_GROUP = "LSP window/logMessage: info, log; $/logTrace";

    public LspServerNotificationsHandlerImpl(@NotNull LspServerImpl lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        this.lspServer = lspServer;
    }

    @Override
    @NotNull
    public CompletableFuture<ApplyWorkspaceEditResponse> applyEdit(@NotNull ApplyWorkspaceEditParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CompletableFuture<ApplyWorkspaceEditResponse> completableFuture = new CompletableFuture<ApplyWorkspaceEditResponse>();
        ReadAction.nonBlocking(() -> LspServerNotificationsHandlerImpl.a(this, params)).finishOnUiThread(ModalityState.nonModal(), arg_0 -> LspServerNotificationsHandlerImpl.a(arg_0 -> LspServerNotificationsHandlerImpl.a(params, this, completableFuture, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> registerCapability(@NotNull RegistrationParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List list = params.getRegistrations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRegistrations(...)");
        Iterable iterable = list;
        boolean bl = false;
        for (Object t2 : iterable) {
            Registration registration = (Registration)t2;
            boolean bl2 = false;
            LspDynamicCapabilities lspDynamicCapabilities = this.lspServer.getDynamicCapabilities$intellij_platform_lsp_impl();
            Intrinsics.checkNotNull((Object)registration);
            lspDynamicCapabilities.registerCapability(registration);
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> unregisterCapability(@NotNull UnregistrationParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List list = params.getUnregisterations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUnregisterations(...)");
        Iterable iterable = list;
        boolean bl = false;
        for (Object t2 : iterable) {
            Unregistration unregistration = (Unregistration)t2;
            boolean bl2 = false;
            LspDynamicCapabilities lspDynamicCapabilities = this.lspServer.getDynamicCapabilities$intellij_platform_lsp_impl();
            Intrinsics.checkNotNull((Object)unregistration);
            lspDynamicCapabilities.unregisterCapability(unregistration);
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    public void telemetryEvent(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
    }

    @Override
    public void publishDiagnostics(@NotNull PublishDiagnosticsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!this.lspServer.getProject().isDisposed()) {
            this.lspServer.diagnosticsReceived$intellij_platform_lsp_impl(params);
        }
    }

    @Override
    @NotNull
    public CompletableFuture<ShowDocumentResult> showDocument(@NotNull ShowDocumentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = params.getUri();
        Intrinsics.checkNotNull((Object)string);
        if (StringsKt.startsWith$default((String)string, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string, (String)"https://", (boolean)false, (int)2, null)) {
            BrowserUtil.browse((String)string, (Project)this.lspServer.getProject());
            CompletableFuture<ShowDocumentResult> completableFuture = CompletableFuture.completedFuture(new ShowDocumentResult(true));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        VirtualFile virtualFile = this.lspServer.getDescriptor().findFileByUri(string);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            return this.a(virtualFile2, !Intrinsics.areEqual((Object)params.getTakeFocus(), (Object)false), params.getSelection());
        }
        CompletableFuture<ShowDocumentResult> completableFuture = CompletableFuture.completedFuture(new ShowDocumentResult(false));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    private final CompletableFuture<ShowDocumentResult> a(VirtualFile virtualFile, boolean bl, Range range) {
        CompletableFuture<ShowDocumentResult> completableFuture = new CompletableFuture<ShowDocumentResult>();
        ActionsKt.runInEdt$default(null, () -> LspServerNotificationsHandlerImpl.a(virtualFile, this, range, bl, completableFuture), (int)1, null);
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<WorkspaceFolder>> workspaceFolders() {
        if (this.lspServer.getProject().isDisposed()) {
            CompletableFuture<List<WorkspaceFolder>> completableFuture = CompletableFuture.completedFuture(CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        VirtualFile[] virtualFileArray = this.lspServer.getDescriptor().getRoots();
        boolean bl = false;
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        Collection collection = new ArrayList(virtualFileArray.length);
        boolean bl2 = false;
        int n2 = virtualFileArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = virtualFileArray2[i2];
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new WorkspaceFolder(this.lspServer.getDescriptor().getFileUri(virtualFile2), virtualFile2.getName()));
        }
        CompletableFuture<List<WorkspaceFolder>> completableFuture = CompletableFuture.completedFuture((List)collection);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<Object>> configuration(@NotNull ConfigurationParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.lspServer.getProject().isDisposed()) {
            CompletableFuture<List<Object>> completableFuture = CompletableFuture.completedFuture(Collections.emptyList());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        List list = params.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable iterable = list;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            ConfigurationItem configurationItem = (ConfigurationItem)t2;
            Collection collection2 = collection;
            boolean bl3 = false;
            LspServerDescriptor lspServerDescriptor = this.lspServer.getDescriptor();
            Intrinsics.checkNotNull((Object)configurationItem);
            collection2.add(lspServerDescriptor.getWorkspaceConfiguration(configurationItem));
        }
        CompletableFuture<List<Object>> completableFuture = CompletableFuture.completedFuture((List)collection);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> createProgress(@NotNull WorkDoneProgressCreateParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    public void notifyProgress(@NotNull ProgressParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
    }

    @Override
    @NotNull
    public CompletableFuture<Void> refreshSemanticTokens() {
        if (!this.lspServer.getProject().isDisposed()) {
            this.lspServer.refreshSemanticTokens$intellij_platform_lsp_impl();
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> refreshCodeLenses() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> refreshInlayHints() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> refreshInlineValues() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> refreshDiagnostics() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<MessageActionItem> showMessageRequest(@NotNull ShowMessageRequestParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.lspServer.getProject().isDisposed()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        List list = params.getActions();
        this.lspServer.logInfo$intellij_platform_lsp_impl("window/showMessageRequest: " + params.getMessage() + ": " + (list != null ? CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, LspServerNotificationsHandlerImpl::a, (int)31, null) : null));
        String string = params.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        return this.a(string, this.a((MessageParams)params), SHOW_MESSAGE_NOTIFICATION_GROUP, params.getActions());
    }

    @Override
    public void showMessage(@NotNull MessageParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.lspServer.getProject().isDisposed()) {
            return;
        }
        this.lspServer.logInfo$intellij_platform_lsp_impl("window/showMessage: " + params.getMessage());
        String string = params.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        LspServerNotificationsHandlerImpl.doNotify$default(this, string, this.a(params), SHOW_MESSAGE_NOTIFICATION_GROUP, null, 8, null);
    }

    @Override
    public void logMessage(@NotNull MessageParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.lspServer.getProject().isDisposed()) {
            return;
        }
        this.lspServer.logInfo$intellij_platform_lsp_impl("window/logMessage " + params.getType() + ": " + params.getMessage());
        if (params.getType() == MessageType.Error || params.getType() == MessageType.Warning) {
            String string = params.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
            v1 = LspServerNotificationsHandlerImpl.doNotify$default(this, string, this.a(params), LOG_ERRORS_WARNINGS_NOTIFICATION_GROUP, null, 8, null);
        } else {
            String string = params.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
            v1 = LspServerNotificationsHandlerImpl.doNotify$default(this, string, NotificationType.INFORMATION, LOG_INFO_TRACE_NOTIFICATION_GROUP, null, 8, null);
        }
    }

    @Override
    public void logTrace(@NotNull LogTraceParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.lspServer.getProject().isDisposed()) {
            return;
        }
        String string = params.getVerbose() != null ? params.getMessage() + "\n" + params.getVerbose() : params.getMessage();
        Intrinsics.checkNotNull((Object)string);
        LspServerNotificationsHandlerImpl.doNotify$default(this, string, NotificationType.INFORMATION, LOG_INFO_TRACE_NOTIFICATION_GROUP, null, 8, null);
    }

    private final NotificationType a(MessageParams messageParams) {
        MessageType messageType = messageParams.getType();
        Intrinsics.checkNotNull((Object)messageType);
        return switch (WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()]) {
            case 1 -> NotificationType.ERROR;
            case 2 -> NotificationType.WARNING;
            case 3, 4 -> NotificationType.INFORMATION;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final CompletableFuture<MessageActionItem> a(@NlsSafe String string, NotificationType notificationType, String string2, List<? extends MessageActionItem> list) {
        Notification notification;
        CompletableFuture<MessageActionItem> completableFuture = new CompletableFuture<MessageActionItem>();
        String string3 = this.lspServer.getDescriptor().getPresentableName() + ": " + string;
        Notification notification2 = notification = NotificationGroupManager.getInstance().getNotificationGroup(string2).createNotification(string3, notificationType);
        boolean bl = false;
        List<? extends MessageActionItem> list2 = list;
        if (list2 != null) {
            Iterable iterable = list2;
            boolean bl2 = false;
            for (Object t2 : iterable) {
                String string4;
                MessageActionItem messageActionItem = (MessageActionItem)t2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)messageActionItem.getTitle(), (String)"getTitle(...)");
                notification2.addAction(new AnAction(string4, notification2, completableFuture, messageActionItem){
                    final /* synthetic */ Notification $notification;
                    final /* synthetic */ CompletableFuture<MessageActionItem> $result;
                    final /* synthetic */ MessageActionItem $actionItem;
                    {
                        this.$notification = $notification;
                        this.$result = $result;
                        this.$actionItem = $actionItem;
                        super($actionLabel);
                    }

                    public void actionPerformed(AnActionEvent e10) {
                        Intrinsics.checkNotNullParameter((Object)e10, (String)"e");
                        this.$notification.expire();
                        this.$result.complete(this.$actionItem);
                    }
                });
            }
        }
        notification.notify(this.lspServer.getProject());
        return completableFuture;
    }

    static /* synthetic */ CompletableFuture doNotify$default(LspServerNotificationsHandlerImpl lspServerNotificationsHandlerImpl, String string, NotificationType notificationType, String string2, List list, int n2, Object object) {
        if ((n2 & 8) != 0) {
            list = null;
        }
        return lspServerNotificationsHandlerImpl.a(string, notificationType, string2, list);
    }

    private static final LspIntentionAction a(LspServerNotificationsHandlerImpl lspServerNotificationsHandlerImpl, ApplyWorkspaceEditParams applyWorkspaceEditParams) {
        Object object = new CodeAction("workspace/applyEdit");
        CodeAction codeAction = object;
        boolean bl = false;
        codeAction.setEdit(applyWorkspaceEditParams.getEdit());
        CodeAction codeAction2 = object;
        object = new LspIntentionAction(lspServerNotificationsHandlerImpl.lspServer, codeAction2);
        return ((LspIntentionAction)object).isAvailable() ? object : null;
    }

    private static final void a(LspIntentionAction lspIntentionAction) {
        lspIntentionAction.invoke(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit a(ApplyWorkspaceEditParams applyWorkspaceEditParams, LspServerNotificationsHandlerImpl lspServerNotificationsHandlerImpl, CompletableFuture completableFuture, LspIntentionAction lspIntentionAction) {
        try {
            if (lspIntentionAction != null) {
                String string = applyWorkspaceEditParams.getLabel();
                if (string == null) {
                    Object[] objectArray = new Object[]{lspServerNotificationsHandlerImpl.lspServer.getDescriptor().getPresentableName()};
                    string = LspBundle.INSTANCE.message("code.change.from.server", objectArray);
                }
                String string2 = string;
                WriteCommandAction.runWriteCommandAction((Project)lspServerNotificationsHandlerImpl.lspServer.getProject(), (String)string2, null, () -> LspServerNotificationsHandlerImpl.a(lspIntentionAction), (PsiFile[])new PsiFile[0]);
                completableFuture.complete(new ApplyWorkspaceEditResponse(true));
            }
        }
        finally {
            if (!completableFuture.isDone()) {
                completableFuture.complete(new ApplyWorkspaceEditResponse(false));
            }
        }
        return Unit.INSTANCE;
    }

    private static final void a(Function1 function1, Object object) {
        function1.invoke(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit a(VirtualFile virtualFile, LspServerNotificationsHandlerImpl lspServerNotificationsHandlerImpl, Range range, boolean bl, CompletableFuture completableFuture) {
        try {
            if (virtualFile.isValid()) {
                Document document;
                Project project = lspServerNotificationsHandlerImpl.lspServer.getProject();
                if (range != null && (document = FileDocumentManager.getInstance().getDocument(virtualFile)) != null) {
                    Position position = range.getStart();
                    Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
                    Integer n2 = Lsp4jUtilKt.getOffsetInDocument(document, position);
                    Position position2 = range.getEnd();
                    Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getEnd(...)");
                    Integer n3 = Lsp4jUtilKt.getOffsetInDocument(document, position2);
                    if (n2 != null && n3 != null) {
                        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, n2.intValue()), bl);
                        Object object = editor;
                        if (object != null) {
                            Editor editor2;
                            Editor editor3 = editor2 = object;
                            boolean bl2 = false;
                            object = !Intrinsics.areEqual((Object)n2, (Object)n3) ? editor2 : null;
                            if (object != null && (object = object.getSelectionModel()) != null) {
                                object.setSelection(n2.intValue(), n3.intValue());
                            }
                        }
                        completableFuture.complete(new ShowDocumentResult(editor != null));
                        Unit unit = Unit.INSTANCE;
                        return unit;
                    }
                }
                completableFuture.complete(new ShowDocumentResult((document = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile), bl)) != null));
            }
        }
        finally {
            if (!completableFuture.isDone()) {
                completableFuture.complete(new ShowDocumentResult(false));
            }
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence a(MessageActionItem messageActionItem) {
        String string = messageActionItem.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerNotificationsHandlerImpl$Companion;", "", "LspServerNotificationsHandlerImpl$Companion", "()V", "SHOW_MESSAGE_NOTIFICATION_GROUP", "", "LOG_ERRORS_WARNINGS_NOTIFICATION_GROUP", "LOG_INFO_TRACE_NOTIFICATION_GROUP", "intellij.platform.lsp.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageType.values().length];
            try {
                nArray[MessageType.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Info.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Log.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

