/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomFocusTraversalPolicy
extends FocusTraversalPolicy {
    private final Map<Component, DoublyLinkedNode> myNodeByComponentMap;
    private final Container myContainer;
    private int myOrderCount;
    private Component myFirstComponent;
    private Component myLastComponent;
    private Component myPreviouslyAddedComponent;

    private CustomFocusTraversalPolicy(@NotNull Container container2) {
        if (container2 == null) {
            CustomFocusTraversalPolicy.a(0);
        }
        this.myNodeByComponentMap = new IdentityHashMap<Component, DoublyLinkedNode>();
        this.myOrderCount = 0;
        this.myContainer = container2;
    }

    public void addNextComponentInTraversalOrder(@NotNull Component nextComponent) {
        if (nextComponent == null) {
            CustomFocusTraversalPolicy.a(1);
        }
        DoublyLinkedNode doublyLinkedNode = this.a(nextComponent);
        if (this.myPreviouslyAddedComponent != null) {
            ++this.myOrderCount;
            DoublyLinkedNode doublyLinkedNode2 = this.a(this.myPreviouslyAddedComponent);
            doublyLinkedNode2.setNextValue(doublyLinkedNode);
        }
        this.myPreviouslyAddedComponent = nextComponent;
        this.myFirstComponent = null;
        this.myLastComponent = null;
    }

    @NotNull
    private DoublyLinkedNode a(@NotNull Component component) {
        DoublyLinkedNode doublyLinkedNode;
        if (component == null) {
            CustomFocusTraversalPolicy.a(2);
        }
        if ((doublyLinkedNode = this.myNodeByComponentMap.get(component)) == null) {
            doublyLinkedNode = new DoublyLinkedNode(component);
            this.myNodeByComponentMap.put(component, doublyLinkedNode);
        }
        DoublyLinkedNode doublyLinkedNode2 = doublyLinkedNode;
        if (doublyLinkedNode2 == null) {
            CustomFocusTraversalPolicy.a(3);
        }
        return doublyLinkedNode2;
    }

    private boolean a(Container container2) {
        boolean bl;
        boolean bl2 = bl = this.myOrderCount == 0 && this.myNodeByComponentMap.isEmpty() || this.myOrderCount == 1 && this.myNodeByComponentMap.size() == 1 || this.myNodeByComponentMap.size() == this.myOrderCount + 1;
        if (!bl) {
            throw new RuntimeException("Traversal order is not a list");
        }
        return container2 == this.myContainer;
    }

    @Override
    @Nullable
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        DoublyLinkedNode doublyLinkedNode;
        Component component = null;
        if (this.a(aContainer) && (doublyLinkedNode = this.myNodeByComponentMap.get(aComponent)) != null) {
            component = doublyLinkedNode.getNextComponent();
        }
        return component;
    }

    @Override
    @Nullable
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        DoublyLinkedNode doublyLinkedNode;
        Component component = null;
        if (this.a(aContainer) && (doublyLinkedNode = this.myNodeByComponentMap.get(aComponent)) != null) {
            component = doublyLinkedNode.getPrevComponent();
        }
        return component;
    }

    @Override
    @Nullable
    public Component getDefaultComponent(Container aContainer) {
        return this.getFirstComponent(aContainer);
    }

    @Override
    @Nullable
    public Component getLastComponent(Container aContainer) {
        Component component = null;
        if (this.a(aContainer)) {
            DoublyLinkedNode doublyLinkedNode;
            if (this.myLastComponent == null && (doublyLinkedNode = this.a()) != null) {
                this.myLastComponent = doublyLinkedNode.getLastValue();
            }
            component = this.myLastComponent;
        }
        return component;
    }

    @Override
    @Nullable
    public Component getFirstComponent(Container aContainer) {
        Component component = null;
        if (this.a(aContainer)) {
            DoublyLinkedNode doublyLinkedNode;
            if (this.myFirstComponent == null && (doublyLinkedNode = this.a()) != null) {
                this.myFirstComponent = doublyLinkedNode.getFirstValue();
            }
            component = this.myFirstComponent;
        }
        return component;
    }

    @Nullable
    private DoublyLinkedNode a() {
        Iterator<DoublyLinkedNode> iterator = this.myNodeByComponentMap.values().iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @NotNull
    public static CustomFocusTraversalPolicy createAndInstallOn(@NotNull Container container2) {
        if (container2 == null) {
            CustomFocusTraversalPolicy.a(4);
        }
        CustomFocusTraversalPolicy customFocusTraversalPolicy = new CustomFocusTraversalPolicy(container2);
        container2.setFocusTraversalPolicyProvider(true);
        container2.setFocusTraversalPolicy(customFocusTraversalPolicy);
        CustomFocusTraversalPolicy customFocusTraversalPolicy2 = customFocusTraversalPolicy;
        if (customFocusTraversalPolicy2 == null) {
            CustomFocusTraversalPolicy.a(5);
        }
        return customFocusTraversalPolicy2;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/ui/CustomFocusTraversalPolicy";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/ui/CustomFocusTraversalPolicy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDoublyLinkedNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndInstallOn";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addNextComponentInTraversalOrder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDoublyLinkedNode";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAndInstallOn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }

    private static final class DoublyLinkedNode {
        private final Component myComponent;
        private DoublyLinkedNode myPrevNode;
        private DoublyLinkedNode myNextNode;

        private DoublyLinkedNode(@NotNull Component component) {
            if (component == null) {
                DoublyLinkedNode.a(0);
            }
            this.myComponent = component;
        }

        public void setNextValue(@NotNull DoublyLinkedNode nextNode) {
            if (nextNode == null) {
                DoublyLinkedNode.a(1);
            }
            if (this.myNextNode != null) {
                throw new RuntimeException("Next value has been already specified");
            }
            if (nextNode.myPrevNode != null) {
                throw new RuntimeException("Previous value has been already specified");
            }
            this.myNextNode = nextNode;
            nextNode.myPrevNode = this;
        }

        @NotNull
        public Component getFirstValue() {
            DoublyLinkedNode doublyLinkedNode = this;
            while (doublyLinkedNode.myPrevNode != null) {
                doublyLinkedNode = doublyLinkedNode.myPrevNode;
            }
            Component component = doublyLinkedNode.myComponent;
            if (component == null) {
                DoublyLinkedNode.a(2);
            }
            return component;
        }

        @NotNull
        public Component getLastValue() {
            DoublyLinkedNode doublyLinkedNode = this;
            while (doublyLinkedNode.myNextNode != null) {
                doublyLinkedNode = doublyLinkedNode.myNextNode;
            }
            Component component = doublyLinkedNode.myComponent;
            if (component == null) {
                DoublyLinkedNode.a(3);
            }
            return component;
        }

        @Nullable
        public Component getPrevComponent() {
            return this.myPrevNode != null ? this.myPrevNode.myComponent : null;
        }

        @Nullable
        public Component getNextComponent() {
            return this.myNextNode != null ? this.myNextNode.myComponent : null;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nextNode";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/ui/CustomFocusTraversalPolicy$DoublyLinkedNode";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/ui/CustomFocusTraversalPolicy$DoublyLinkedNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirstValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLastValue";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setNextValue";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

