/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.jvm.names;

public final class NameUtils {
    public static String underscoreToCamelCase(String input) {
        return NameUtils.underscoresToCamelCase(input, false);
    }

    public static String underscoreToCapitalizedCamelCase(String input) {
        return NameUtils.underscoresToCamelCase(input, true);
    }

    private static String underscoresToCamelCase(String input, boolean capNextLetter) {
        if (input.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            if ('a' <= input.charAt(i) && input.charAt(i) <= 'z') {
                if (capNextLetter) {
                    result.append((char)(input.charAt(i) + -32));
                } else {
                    result.append(input.charAt(i));
                }
                capNextLetter = false;
                continue;
            }
            if ('A' <= input.charAt(i) && input.charAt(i) <= 'Z') {
                if (i == 0 && !capNextLetter) {
                    result.append((char)(input.charAt(i) + 32));
                } else {
                    result.append(input.charAt(i));
                }
                capNextLetter = false;
                continue;
            }
            if ('0' <= input.charAt(i) && input.charAt(i) <= '9') {
                result.append(input.charAt(i));
                capNextLetter = true;
                continue;
            }
            capNextLetter = true;
        }
        if (input.charAt(input.length() - 1) == '#') {
            result.append('_');
        }
        return result.toString();
    }
}

