/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.intentions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.protobuf.ide.settings.PbLanguageSettingsConfigurable;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.intentions.PbAddImportPathUndoableAction;
import com.intellij.protobuf.lang.intentions.util.ImportPathData;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbImportStatement;
import com.intellij.protobuf.lang.psi.util.PbPsiFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/protobuf/lang/intentions/PbImportIntentionVariant;", "", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "invokeAction", "", "project", "Lcom/intellij/openapi/project/Project;", "ManuallyConfigureImportPathsSettings", "AddImportPathToSettings", "AddImportStatementAndPathToSettings", "Lcom/intellij/protobuf/lang/intentions/PbImportIntentionVariant$AddImportPathToSettings;", "Lcom/intellij/protobuf/lang/intentions/PbImportIntentionVariant$ManuallyConfigureImportPathsSettings;", "intellij.protoeditor.core"})
public abstract class PbImportIntentionVariant {
    private PbImportIntentionVariant() {
    }

    @NotNull
    public abstract Icon getIcon();

    public abstract void invokeAction(@NotNull Project var1);

    public /* synthetic */ PbImportIntentionVariant(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/protobuf/lang/intentions/PbImportIntentionVariant$AddImportPathToSettings;", "Lcom/intellij/protobuf/lang/intentions/PbImportIntentionVariant;", "importPathData", "Lcom/intellij/protobuf/lang/intentions/util/ImportPathData;", "<init>", "(Lcom/intellij/protobuf/lang/intentions/util/ImportPathData;)V", "getImportPathData", "()Lcom/intellij/protobuf/lang/intentions/util/ImportPathData;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "invokeAction", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.protoeditor.core"})
    @SourceDebugExtension(value={"SMAP\nPbImportIntentionVariant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PbImportIntentionVariant.kt\ncom/intellij/protobuf/lang/intentions/PbImportIntentionVariant$AddImportPathToSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
    public static class AddImportPathToSettings
    extends PbImportIntentionVariant {
        @NotNull
        private final ImportPathData importPathData;

        public AddImportPathToSettings(@NotNull ImportPathData importPathData) {
            Intrinsics.checkNotNullParameter((Object)importPathData, (String)"importPathData");
            super(null);
            this.importPathData = importPathData;
        }

        @NotNull
        public final ImportPathData getImportPathData() {
            return this.importPathData;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.Actions.ModuleDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ModuleDirectory");
            return icon;
        }

        @Override
        public void invokeAction(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (IntentionPreviewUtils.isIntentionPreviewActive()) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project, (String)PbLangBundle.message("intention.add.import.path.popup.title", new Object[0]), (String)PbLangBundle.message("intention.fix.import.problems.familyName", new Object[0]), () -> AddImportPathToSettings.invokeAction$lambda$0(project, this), (PsiFile[])new PsiFile[0]);
        }

        /*
         * WARNING - void declaration
         */
        private static final void invokeAction$lambda$0(Project $project, AddImportPathToSettings this$0) {
            void p0;
            PbAddImportPathUndoableAction pbAddImportPathUndoableAction = new PbAddImportPathUndoableAction(this$0.importPathData, $project);
            UndoableAction undoableAction = pbAddImportPathUndoableAction;
            UndoManager undoManager = UndoManager.getInstance((Project)$project);
            boolean bl = false;
            p0.redo();
            undoManager.undoableActionPerformed((UndoableAction)pbAddImportPathUndoableAction);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J2\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/protobuf/lang/intentions/PbImportIntentionVariant$AddImportStatementAndPathToSettings;", "Lcom/intellij/protobuf/lang/intentions/PbImportIntentionVariant$AddImportPathToSettings;", "importPathData", "Lcom/intellij/protobuf/lang/intentions/util/ImportPathData;", "<init>", "(Lcom/intellij/protobuf/lang/intentions/util/ImportPathData;)V", "invokeAction", "", "project", "Lcom/intellij/openapi/project/Project;", "addImportStatement", "", "targetFile", "Lcom/intellij/psi/PsiFile;", "protoFileToImport", "addImportAndNewLineAfter", "importedFile", "anchor", "Lcom/intellij/psi/PsiElement;", "afterAnchor", "intellij.protoeditor.core"})
    @SourceDebugExtension(value={"SMAP\nPbImportIntentionVariant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PbImportIntentionVariant.kt\ncom/intellij/protobuf/lang/intentions/PbImportIntentionVariant$AddImportStatementAndPathToSettings\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,134:1\n25#2:135\n*S KotlinDebug\n*F\n+ 1 PbImportIntentionVariant.kt\ncom/intellij/protobuf/lang/intentions/PbImportIntentionVariant$AddImportStatementAndPathToSettings\n*L\n92#1:135\n*E\n"})
    public static final class AddImportStatementAndPathToSettings
    extends AddImportPathToSettings {
        public AddImportStatementAndPathToSettings(@NotNull ImportPathData importPathData) {
            Intrinsics.checkNotNullParameter((Object)importPathData, (String)"importPathData");
            super(importPathData);
        }

        @Override
        public void invokeAction(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
            PsiManager psiManager2 = psiManager;
            Pair pair = (Pair)ActionsKt.runReadAction(() -> AddImportStatementAndPathToSettings.invokeAction$lambda$0(psiManager2, this));
            if (pair == null) {
                return;
            }
            Pair pair2 = pair;
            PsiFile targetPsiFile = (PsiFile)pair2.component1();
            PsiFile importedPsiFile = (PsiFile)pair2.component2();
            if (IntentionPreviewUtils.isPreviewElement((PsiElement)((PsiElement)targetPsiFile))) {
                this.addImportStatement(project, targetPsiFile, importedPsiFile);
            } else {
                WriteCommandAction.runWriteCommandAction((Project)project, (String)PbLangBundle.message("intention.add.import.path.popup.title", new Object[0]), (String)PbLangBundle.message("intention.fix.import.problems.familyName", new Object[0]), () -> AddImportStatementAndPathToSettings.invokeAction$lambda$1(this, project, targetPsiFile, importedPsiFile), (PsiFile[])new PsiFile[0]);
            }
        }

        private final boolean addImportStatement(Project project, PsiFile targetFile, PsiFile protoFileToImport) {
            if (!(targetFile instanceof PbFile) || !(protoFileToImport instanceof PbFile)) {
                AddImportStatementAndPathToSettings $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(AddImportStatementAndPathToSettings.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Both target and imported files should be PROTO files, got target = '" + targetFile.getFileType() + "' and imported = '" + protoFileToImport.getFileType() + "' instead");
                return false;
            }
            List<PbImportStatement> list = ((PbFile)targetFile).getImportStatements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getImportStatements(...)");
            if (!((Collection)list).isEmpty()) {
                List<PbImportStatement> list2 = ((PbFile)targetFile).getImportStatements();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getImportStatements(...)");
                this.addImportAndNewLineAfter(project, targetFile, protoFileToImport, (PsiElement)CollectionsKt.last(list2), true);
            } else if (((PbFile)targetFile).getImportStatements().isEmpty() && ((PbFile)targetFile).getSyntaxStatement() != null) {
                this.addImportAndNewLineAfter(project, targetFile, protoFileToImport, ((PbFile)targetFile).getSyntaxStatement(), true);
            } else if (((PbFile)targetFile).getFirstChild() != null) {
                this.addImportAndNewLineAfter(project, targetFile, protoFileToImport, ((PbFile)targetFile).getFirstChild(), false);
            } else {
                this.addImportAndNewLineAfter(project, targetFile, protoFileToImport, null, false);
            }
            return true;
        }

        private final void addImportAndNewLineAfter(Project project, PsiFile targetFile, PsiFile importedFile, PsiElement anchor, boolean afterAnchor) {
            String string = importedFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            PbImportStatement importStatement = PbPsiFactory.INSTANCE.createImportStatement(project, string);
            PsiElement newLine = PbPsiFactory.INSTANCE.createNewLine(project);
            PsiElement newImport = afterAnchor ? targetFile.addAfter((PsiElement)importStatement, anchor) : targetFile.addBefore((PsiElement)importStatement, anchor);
            PsiElement psiElement = afterAnchor ? targetFile.addBefore(newLine, newImport) : targetFile.addAfter(newLine, newImport);
        }

        private static final Pair invokeAction$lambda$0(PsiManager $psiManager, AddImportStatementAndPathToSettings this$0) {
            PsiFile psiFile = $psiManager.findFile(this$0.getImportPathData().getOriginalPbVirtualFile());
            if (psiFile == null) {
                return null;
            }
            PsiFile targetPsiFile = psiFile;
            PsiFile psiFile2 = $psiManager.findFile(this$0.getImportPathData().getImportedPbVirtualFile());
            if (psiFile2 == null) {
                return null;
            }
            PsiFile importedPsiFile = psiFile2;
            return TuplesKt.to((Object)targetPsiFile, (Object)importedPsiFile);
        }

        private static final void invokeAction$lambda$1(AddImportStatementAndPathToSettings this$0, Project $project, PsiFile $targetPsiFile, PsiFile $importedPsiFile) {
            if (!this$0.addImportStatement($project, $targetPsiFile, $importedPsiFile)) {
                return;
            }
            super.invokeAction($project);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/protobuf/lang/intentions/PbImportIntentionVariant$ManuallyConfigureImportPathsSettings;", "Lcom/intellij/protobuf/lang/intentions/PbImportIntentionVariant;", "<init>", "()V", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "invokeAction", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.protoeditor.core"})
    public static final class ManuallyConfigureImportPathsSettings
    extends PbImportIntentionVariant {
        @NotNull
        public static final ManuallyConfigureImportPathsSettings INSTANCE = new ManuallyConfigureImportPathsSettings();

        private ManuallyConfigureImportPathsSettings() {
            super(null);
        }

        @NlsSafe
        @NotNull
        public final String getPresentableName() {
            String string = PbLangBundle.message("intention.manually.configure.imports", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.General.Gear;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Gear");
            return icon;
        }

        @Override
        public void invokeAction(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ActionsKt.invokeLater$default(null, () -> ManuallyConfigureImportPathsSettings.invokeAction$lambda$0(project), (int)1, null);
        }

        private static final Unit invokeAction$lambda$0(Project $project) {
            ShowSettingsUtil.getInstance().showSettingsDialog($project, PbLanguageSettingsConfigurable.class);
            return Unit.INSTANCE;
        }
    }
}

