// Copyright 2016-2022 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.goide.completion;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PairProcessor;
import org.jetbrains.annotations.NotNull;

public interface GoImportPathsProvider {
  ExtensionPointName<GoImportPathsProvider> EP_NAME = ExtensionPointName.create("com.goide.importPathsProvider");

  /**
   * Processes imports paths of Go packages within corresponding directories.
   * <p>
   * Implementations also are responsible for filtering out the packages that cannot be used or
   * imported (e.g. package doesn't contain any files or files are not matched to Build Target settings of specified module).
   * <p>
   * Default implementation processes paths (relative to Go sources roots) to all Go files that can be imported.
   */
  void processImportPaths(@NotNull Module module,
                          @NotNull GlobalSearchScope scope,
                          boolean allowMainPackage,
                          boolean vendoringEnabled,
                          @NotNull PairProcessor<? super String, ? super PsiDirectory> processor);
}