/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.JdbcGridColumn;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.util.Case;
import com.intellij.database.util.ColoredDdlBuilder;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GridColumnAlias;
import com.intellij.database.util.GridTablesModel;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.vfs.DatabaseElementSourceVirtualFileImpl;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.cardinality.SqlJoinCardinalityInfo;
import com.intellij.sql.cardinality.SqlJoinCardinalityType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSqlUtil
extends DbSqlUtilCore {
    private DbSqlUtil() {
    }

    public static boolean isSqlFileCoarse(VirtualFile file) {
        if (!DbSqlUtil.isSqlFileValid(file)) {
            return false;
        }
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SqlFileType.INSTANCE);
    }

    private static boolean isSqlFileValid(VirtualFile file) {
        if (file.isDirectory() || !file.isValid()) {
            return false;
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            if (file instanceof DatabaseElementSourceVirtualFileImpl && ((DatabaseElementSourceVirtualFileImpl)file).isBusy()) {
                return false;
            }
            ObjectKind kind = ((DatabaseElementVirtualFileImpl)file).getObjectKind();
            if (kind == ObjectKind.NONE || kind == ObjectKind.DATABASE || kind == ObjectKind.SCHEMA) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Condition<VirtualFile> SQL_FILE_FILTER(@Nullable Project project) {
        if (project == null) {
            Condition condition = Conditions.alwaysFalse();
            if (condition == null) {
                DbSqlUtil.$$$reportNull$$$0(0);
            }
            return condition;
        }
        Condition condition = file -> {
            if (DbSqlUtil.isSqlFileCoarse(file)) {
                return true;
            }
            return DbSqlUtil.isSqlFileValid(file) && LanguageUtil.getLanguageFileType((Language)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) == SqlFileType.INSTANCE;
        };
        if (condition == null) {
            DbSqlUtil.$$$reportNull$$$0(1);
        }
        return condition;
    }

    @NotNull
    public static String sql2Html(@NotNull Project project, @NotNull Language language, @NotNull CharSequence sequence) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(2);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(3);
        }
        if (sequence == null) {
            DbSqlUtil.$$$reportNull$$$0(4);
        }
        ColoredDdlBuilder colored = new ColoredDdlBuilder();
        DatabaseDialectEx dialect = language instanceof SqlLanguageDialect ? (DatabaseDialectEx)((SqlLanguageDialect)language).getDatabaseDialect() : DatabaseDialects.getGenericDialect();
        colored.withDialect(dialect);
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, null);
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start(sequence);
        while (lexer.getTokenType() != null) {
            TextAttributesKey[] keys;
            boolean pushed = false;
            IElementType type = lexer.getTokenType();
            if (type != null && (keys = highlighter.getTokenHighlights(type)).length > 0) {
                pushed = true;
                colored.pushStyle(keys[0]);
            }
            colored.plain(StringUtil.escapeXmlEntities((String)lexer.getTokenText()));
            lexer.advance();
            if (!pushed) continue;
            colored.popStyle();
        }
        String string = colored.getStatement();
        if (string == null) {
            DbSqlUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static GridTablesModel getGridTablesModel(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @Nullable String queryText, @Nullable SqlTableType resultType, @NotNull List<? extends GridColumn> columns) {
        DasTable table2;
        boolean isSqlDialect;
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(6);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(7);
        }
        if (columns == null) {
            DbSqlUtil.$$$reportNull$$$0(8);
        }
        if (!ContainerUtil.all(columns, column2 -> column2 instanceof JdbcGridColumn)) {
            return null;
        }
        Dbms dbms = dataSource == null ? DbSqlUtil.getDbms((Language)language) : dataSource.getDbms();
        boolean bl = isSqlDialect = language instanceof SqlLanguageDialect || !dbms.isMongo();
        if (!isSqlDialect && (table2 = DbSqlUtil.detectTable(project, language, dataSource, searchPath, queryText, resultType, columns)) != null) {
            return new GridTablesModel(table2);
        }
        ColumnWithDasTable[] columnWithDasTables = null;
        HashMap<Integer, DasTable> tableMap = new HashMap<Integer, DasTable>();
        HashSet<String> tablesWithAllowedMerge = new HashSet<String>();
        boolean expressionHasSelfJoinOnTopLevel = false;
        Map<Object, Object> aliasesForColumns = new HashMap();
        if (queryText != null) {
            SqlTableType type;
            if (DbSqlUtil.expressionHasSqlUnion(project, language, queryText, null)) {
                return null;
            }
            expressionHasSelfJoinOnTopLevel = DbSqlUtil.expressionHasSelfJoinOnTopLevel(project, language, queryText, null);
            SqlTableType sqlTableType = type = resultType != null ? resultType : DbSqlUtil.parseQueryTableType(project, language, dataSource, searchPath, queryText, null);
            if (type != null) {
                columnWithDasTables = DbSqlUtil.getDasTablesForColumns(type);
            }
            aliasesForColumns = DbSqlUtil.getAliasesForColumns(columnWithDasTables, type);
            if (dataSource != null && columnWithDasTables != null && language instanceof SqlLanguageDialect) {
                tablesWithAllowedMerge.addAll(DbSqlUtil.getTablesWithMergeAllowed(dataSource, project, language, queryText));
            }
        }
        if (columnWithDasTables != null && columnWithDasTables.length > 0) {
            Map<String, DasTable> tablesByName = Arrays.stream(columnWithDasTables).filter(table -> table.getDasTable() != null).collect(Collectors.toMap(table -> table.getDasTable().getName(), table -> table.getDasTable(), (existing2, replacement) -> existing2));
            boolean hasColumnsWithoutTable = false;
            boolean hasJoinToItself = false;
            boolean isEditSwitchedOff = false;
            for (ColumnWithDasTable columnWithDasTable : columnWithDasTables) {
                if (columnWithDasTable.table == null) {
                    hasColumnsWithoutTable = true;
                    continue;
                }
                tableMap.put(columnWithDasTable.columnNumber, columnWithDasTable.table);
            }
            HashSet tablesSet = new HashSet(tableMap.values());
            if (expressionHasSelfJoinOnTopLevel && tablesSet.size() <= 1) {
                hasJoinToItself = true;
            }
            if (!DatabaseSettings.getSettings().isEnableEditSqlJoins() && tablesSet.size() > 1) {
                isEditSwitchedOff = true;
            }
            Set tablesWithAllowedMergeMap = tablesWithAllowedMerge.stream().map(tablesByName::get).collect(Collectors.toSet());
            return new GridTablesModel(tableMap, tablesWithAllowedMergeMap, aliasesForColumns, hasColumnsWithoutTable || hasJoinToItself || isEditSwitchedOff);
        }
        return null;
    }

    private static HashSet<String> getTablesWithMergeAllowed(DbDataSource dataSource, Project project, Language language, String queryText) {
        SqlJoinCardinalityInfo cardinalityInfo;
        HashSet<String> tablesWithMergeAllowed = new HashSet<String>();
        JBIterable<SqlJoinCardinalityInfo> expressionCardinality = DbSqlUtil.getExpressionCardinalityInfo(dataSource, project, language, queryText, null);
        SqlJoinCardinalityInfo sqlJoinCardinalityInfo = cardinalityInfo = expressionCardinality.size() == 1 ? (SqlJoinCardinalityInfo)expressionCardinality.first() : null;
        if (cardinalityInfo == null) {
            return tablesWithMergeAllowed;
        }
        if (cardinalityInfo.getLeftCardinality() == SqlJoinCardinalityType.ONE2N && cardinalityInfo.getRightCardinality() == SqlJoinCardinalityType.ONE && cardinalityInfo.getRightTable() != null) {
            tablesWithMergeAllowed.add(cardinalityInfo.getRightTable().getName());
        } else if (cardinalityInfo.getLeftCardinality() == SqlJoinCardinalityType.ONE && cardinalityInfo.getRightCardinality() == SqlJoinCardinalityType.ONE2N && cardinalityInfo.getLeftTable() != null) {
            tablesWithMergeAllowed.add(cardinalityInfo.getLeftTable().getName());
        }
        return tablesWithMergeAllowed;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static DasTable detectTable(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @Nullable String queryText, @Nullable SqlTableType resultType, @NotNull List<? extends GridColumn> columns) {
        void var9_15;
        void var9_13;
        boolean checkMetadata;
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(9);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(10);
        }
        if (columns == null) {
            DbSqlUtil.$$$reportNull$$$0(11);
        }
        if (!ContainerUtil.all(columns, column2 -> column2 instanceof JdbcGridColumn)) {
            return null;
        }
        JdbcGridColumn tableColumn = null;
        if (!columns.isEmpty()) {
            for (GridColumn gridColumn : columns) {
                JdbcGridColumn c2 = (JdbcGridColumn)gridColumn;
                if (StringUtil.isNotEmpty((String)c2.getTable()) && (tableColumn == null || Objects.equals(c2.getCatalog(), tableColumn.getCatalog()) && Objects.equals(c2.getSchema(), tableColumn.getSchema()) && Objects.equals(c2.getTable(), tableColumn.getTable()))) {
                    tableColumn = c2;
                    continue;
                }
                tableColumn = null;
                break;
            }
        }
        Dbms dbms = dataSource == null ? DbSqlUtil.getDbms((Language)language) : dataSource.getDbms();
        Object var9_10 = null;
        if (queryText != null) {
            DasTable dasTable;
            SqlTableType type = resultType != null ? resultType : DbSqlUtil.parseQueryTableType(project, language, dataSource, searchPath, queryText, null);
            PsiElement element = type == null ? null : type.getTypeElement();
            DasTable dasTable2 = dasTable = element instanceof DasTable ? (DasTable)element : null;
            if (dasTable == null && language instanceof SqlLanguageDialect && element instanceof SqlReferenceExpression) {
                SqlReferenceExpression ref2 = (SqlReferenceExpression)element;
                String name2 = ref2.getReferencePart(ObjectKind.TABLE);
                String refSchema = ref2.getReferencePart(ObjectKind.SCHEMA);
                String refCatalog = ref2.getReferencePart(ObjectKind.DATABASE);
                String schema = refSchema.isEmpty() && tableColumn != null && tableColumn.getSchema() != null ? tableColumn.getSchema() : refSchema;
                String catalog = refCatalog.isEmpty() && tableColumn != null && tableColumn.getCatalog() != null ? tableColumn.getCatalog() : refCatalog;
                BasicModTable mt = DbSqlUtil.sqlCreateFakeTable(dbms, catalog, schema, name2);
                if (mt != null) {
                    DasTypeSystemBase dtService = DasTypeSystems.getTypeSystem((Dbms)dbms);
                    for (GridColumn gridColumn : columns) {
                        BasicModTableOrViewColumn c3 = (BasicModTableOrViewColumn)mt.getColumns().renewAt((short)gridColumn.getColumnNumber(), gridColumn.getName());
                        String tn = gridColumn.getTypeName();
                        if (tn == null) continue;
                        c3.setStoredType(dtService.createDasType(DataTypeFactory.of((String)tn)));
                    }
                    BasicModTable basicModTable = mt;
                }
            }
        }
        boolean bl = checkMetadata = language instanceof SqlLanguageDialect || !dbms.isMongo();
        if (checkMetadata && tableColumn != null && var9_13 != null && !DbSqlUtil.checkMetadata(dbms, (DasTable)var9_13, tableColumn)) {
            Object var9_14 = null;
        }
        return var9_15;
    }

    private static boolean checkMetadata(Dbms dbms, DasTable table, JdbcGridColumn tableColumn) {
        boolean checkTableName = !dbms.is(Dbms.GREENPLUM) && !dbms.is(Dbms.SQLITE) && !dbms.is(Dbms.MEMSQL) || table.getKind() != ObjectKind.VIEW;
        boolean metadataMayReturnDifferentCase = dbms.in(Dbms.MYSQL_LIKE);
        String schema = DasUtil.getSchema((DasObject)table);
        String catalog = DasUtil.getCatalog((DasObject)table);
        return (!checkTableName || DbSqlUtil.matches(tableColumn.getTable(), table.getName(), metadataMayReturnDifferentCase)) && DbSqlUtil.matches(tableColumn.getSchema(), schema, metadataMayReturnDifferentCase) && (catalog.isEmpty() || DbSqlUtil.matches(tableColumn.getCatalog(), catalog, metadataMayReturnDifferentCase));
    }

    private static Map<Integer, GridColumnAlias> getAliasesForColumns(ColumnWithDasTable[] columnWithDasTables, SqlTableType type) {
        HashMap<Integer, GridColumnAlias> columnIndexWithSynonyms = new HashMap<Integer, GridColumnAlias>();
        if (type == null) {
            return columnIndexWithSynonyms;
        }
        int columnCount = type.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            DasObject dasColumn;
            PsiElement psiElement;
            SqlAsExpression sqlAsExpression;
            SqlExpression childExpression;
            PsiElement columnElement = type.getSourceColumnElement(i);
            if (!(columnElement instanceof SqlAsExpression) || !((childExpression = (sqlAsExpression = (SqlAsExpression)columnElement).getExpression()) instanceof SqlReferenceExpression)) continue;
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)childExpression;
            if (sqlAsExpression.getExpression() == null || !((psiElement = sqlAsExpression.getExpression().getLastChild()) instanceof SqlIdentifier)) continue;
            SqlIdentifier sqlIdentifier = (SqlIdentifier)psiElement;
            String alias = sqlAsExpression.getName() != null ? sqlAsExpression.getName() : "";
            String realName = sqlIdentifier.getName();
            boolean isQuoted = sqlReferenceExpression.isQuoted();
            DasTable dasTable = columnWithDasTables[i].getDasTable();
            if (dasTable == null || (dasColumn = (DasObject)dasTable.getDasChildren(ObjectKind.COLUMN).filter(c2 -> c2.getName().equalsIgnoreCase(realName)).first()) == null) continue;
            columnIndexWithSynonyms.put(i, new GridColumnAlias(i, alias, dasColumn.getName(), isQuoted));
        }
        return columnIndexWithSynonyms;
    }

    /*
     * Unable to fully structure code
     */
    private static ColumnWithDasTable[] getDasTablesForColumns(SqlTableType type) {
        columnCount = type.getColumnCount();
        columnDasTables = new ColumnWithDasTable[columnCount];
        for (i = 0; i < columnCount; ++i) {
            columnElement = type.getSourceColumnElement(i);
            table = null;
            columnName = "";
            if (columnElement == null || !((var10_10 = columnElement.getParent()) instanceof DasTable)) ** GOTO lbl-1000
            dasTable = (DasTable)var10_10;
            if (columnElement instanceof DasColumn) {
                dasColumn = (DasColumn)columnElement;
                columnName = dasColumn.getName();
                table = dasTable;
            } else if (columnElement instanceof SqlAsExpression) {
                sqlAsExpression = (SqlAsExpression)columnElement;
                table = DbSqlUtil.resolveDasTable((SqlExpression)sqlAsExpression);
                columnName = sqlAsExpression.getName();
            }
            columnDasTables[i] = new ColumnWithDasTable(table, i, columnName);
        }
        return columnDasTables;
    }

    private static DasTable resolveDasTable(SqlExpression sqlExpression) {
        if (sqlExpression == null) {
            return null;
        }
        if (sqlExpression instanceof SqlAsExpression) {
            SqlAsExpression asExpression = (SqlAsExpression)sqlExpression;
            SqlExpression expression = asExpression.getExpression();
            return expression != null ? DbSqlUtil.resolveDasTable(expression) : null;
        }
        if (sqlExpression instanceof SqlReferenceExpression) {
            SqlReferenceExpression referenceExpression = (SqlReferenceExpression)sqlExpression;
            PsiElement resolved = referenceExpression.resolve();
            if (resolved == null) {
                return null;
            }
            if (resolved instanceof DasTable) {
                DasTable dasTable = (DasTable)resolved;
                return dasTable;
            }
            PsiElement parent = resolved.getParent();
            if (parent instanceof DasTable) {
                DasTable dasTable = (DasTable)parent;
                return dasTable;
            }
        }
        return null;
    }

    @Nullable
    public static BasicModTable sqlCreateFakeTable(Dbms dbms, String catalog, String schema, String name2) {
        BasicModModel model = ModelFactory.BLACK_HOLE.createModel(dbms);
        Ref res2 = Ref.create();
        model.modify(BasicModRoot.class, r -> {
            BasicModElement db = (BasicModElement)Objects.requireNonNullElse(DbSqlUtil.createChild((BasicModElement)r, ObjectKind.DATABASE, catalog), r);
            String scName = dbms.isMysql() && db.getKind() != ObjectKind.DATABASE ? StringUtil.notNullize((String)StringUtil.nullize((String)schema), (String)catalog) : schema;
            BasicModElement sc = DbSqlUtil.createChild(db, ObjectKind.SCHEMA, scName);
            res2.set((Object)((BasicModTable)ObjectUtils.tryCast((Object)DbSqlUtil.createChild(sc, ObjectKind.TABLE, name2), BasicModTable.class)));
        });
        return (BasicModTable)res2.get();
    }

    @Nullable
    private static BasicModElement createChild(@Nullable BasicModElement p2, @NotNull ObjectKind kind, @Nullable String name2) {
        ModFamily dbf;
        if (kind == null) {
            DbSqlUtil.$$$reportNull$$$0(12);
        }
        ModFamily modFamily = dbf = p2 == null ? null : p2.familyOf(kind);
        if (dbf == null) {
            return null;
        }
        BasicModElement db = dbf.createNewOne();
        if (name2 != null && db instanceof BasicModNamedElement) {
            BasicModNamedElement ne = (BasicModNamedElement)db;
            ne.setName(name2);
        }
        return db;
    }

    private static boolean matches(@Nullable String jdbcName, @Nullable String modelName, boolean metadataMayReturnDifferentCase) {
        return StringUtil.isEmpty((String)jdbcName) || StringUtilRt.equal((CharSequence)modelName, (CharSequence)jdbcName, (!metadataMayReturnDifferentCase ? 1 : 0) != 0);
    }

    @NotNull
    public static List<DataConsumer.Column> createColumnsFromType(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable String catalog, @Nullable String schema, @NotNull String tableName) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(13);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(14);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(15);
        }
        if (tableName == null) {
            DbSqlUtil.$$$reportNull$$$0(16);
        }
        ArrayList<DataConsumer.Column> columns = new ArrayList<DataConsumer.Column>(type.getColumnCount());
        List<String> columnNames = DbSqlUtil.getUnambiguousColumnNames(project, dialect, type, null);
        int count = type.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String name2 = columnNames.get(i);
            String typeName = type.getColumnDasType(i).getDescription();
            columns.add(new DataConsumer.Column(i, name2, 1111, typeName, null, 0, 0, catalog, schema, tableName));
        }
        ArrayList<DataConsumer.Column> arrayList = columns;
        if (arrayList == null) {
            DbSqlUtil.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(18);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(19);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(20);
        }
        List<String> columnNames = DbSqlUtil.getColumnNames(type);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(columnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, type, columnNames, duplicates, forceQualify);
        List<String> list = columnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public static List<String> getUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType partType, @NotNull SqlTableType fullType, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(22);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(23);
        }
        if (partType == null) {
            DbSqlUtil.$$$reportNull$$$0(24);
        }
        if (fullType == null) {
            DbSqlUtil.$$$reportNull$$$0(25);
        }
        List<String> partColumnNames = DbSqlUtil.getColumnNames(partType);
        List<String> fullColumnNames = DbSqlUtil.getColumnNames(fullType);
        Set<String> duplicates = DbSqlUtil.getDuplicateNames(fullColumnNames);
        DbSqlUtil.makeUnambiguousColumnNames(project, dialect, partType, partColumnNames, duplicates, forceQualify);
        List<String> list = partColumnNames;
        if (list == null) {
            DbSqlUtil.$$$reportNull$$$0(26);
        }
        return list;
    }

    private static void makeUnambiguousColumnNames(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull SqlTableType type, @NotNull List<String> columnNames, @NotNull Set<String> duplicates, @Nullable PairFunction<? super SqlTableType, ? super Integer, Boolean> forceQualify) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(27);
        }
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(28);
        }
        if (type == null) {
            DbSqlUtil.$$$reportNull$$$0(29);
        }
        if (columnNames == null) {
            DbSqlUtil.$$$reportNull$$$0(30);
        }
        if (duplicates == null) {
            DbSqlUtil.$$$reportNull$$$0(31);
        }
        DdlBuilder builder = new DdlBuilder(new StringBuilder()).configureBuilder(project, DbSqlUtil.getSqlDialect((DatabaseDialect)dialect)).withDialect(dialect);
        for (int i = 0; i < columnNames.size(); ++i) {
            String name2 = columnNames.get(i);
            String typeAlias = type.getColumnTypeAlias(i);
            if (typeAlias != null && (duplicates.contains(name2) || forceQualify != null && ((Boolean)forceQualify.fun((Object)type, (Object)i)).booleanValue())) {
                builder.suppressQuoteIdentifiers(!type.isColumnTypeAliasQuoted(i));
                builder.columnRef(typeAlias).symbol(".");
            }
            builder.suppressQuoteIdentifiers(!type.isColumnQuoted(i));
            builder.columnRef(name2);
            columnNames.set(i, builder.getStatement());
            builder.clear();
        }
    }

    private static List<String> getColumnNames(SqlTableType type) {
        ArrayList<String> columnNames = new ArrayList<String>(type.getColumnCount());
        for (int i = 0; i < type.getColumnCount(); ++i) {
            columnNames.add(StringUtil.notNullize((String)type.getColumnName(i)));
        }
        return columnNames;
    }

    private static Set<String> getDuplicateNames(List<String> names) {
        Set duplicates = CollectionFactory.createCaseInsensitiveStringSet();
        Set distinctNames = CollectionFactory.createCaseInsensitiveStringSet();
        for (String name2 : names) {
            if (distinctNames.add(name2)) continue;
            duplicates.add(name2);
        }
        return duplicates;
    }

    @Nullable
    public static SqlTableType parseQueryTableType(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String queryText, @Nullable Language hostLanguage) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(32);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(33);
        }
        if (queryText == null) {
            DbSqlUtil.$$$reportNull$$$0(34);
        }
        return ((EvaluationHelper)EvaluationHelper.EP.forLanguage(language)).parseQueryTableType(project, language, dataSource, searchPath, queryText, hostLanguage);
    }

    private static boolean expressionHasSqlUnion(@NotNull Project project, @NotNull Language language, @NotNull String queryText, @Nullable Language hostLanguage) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(35);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(36);
        }
        if (queryText == null) {
            DbSqlUtil.$$$reportNull$$$0(37);
        }
        return ((EvaluationHelper)EvaluationHelper.EP.forLanguage(language)).expressionHasSqlUnion(project, language, queryText, hostLanguage);
    }

    private static boolean expressionHasSelfJoinOnTopLevel(@NotNull Project project, @NotNull Language language, @NotNull String queryText, @Nullable Language hostLanguage) {
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(38);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(39);
        }
        if (queryText == null) {
            DbSqlUtil.$$$reportNull$$$0(40);
        }
        return ((EvaluationHelper)EvaluationHelper.EP.forLanguage(language)).expressionHasSelfJoinOnTopLevel(project, language, queryText, hostLanguage);
    }

    private static JBIterable<SqlJoinCardinalityInfo> getExpressionCardinalityInfo(@NotNull DbDataSource dataSource, @NotNull Project project, @NotNull Language language, @NotNull String queryText, @Nullable Language hostLanguage) {
        if (dataSource == null) {
            DbSqlUtil.$$$reportNull$$$0(41);
        }
        if (project == null) {
            DbSqlUtil.$$$reportNull$$$0(42);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(43);
        }
        if (queryText == null) {
            DbSqlUtil.$$$reportNull$$$0(44);
        }
        return ((EvaluationHelper)EvaluationHelper.EP.forLanguage(language)).getExpressionCardinalityInfo(dataSource, project, language, queryText, hostLanguage);
    }

    @Nullable
    public static SqlTableType parseQueryTableType(@NotNull JdbcConsoleBase console, @NotNull Language language, @NotNull String queryText) {
        if (console == null) {
            DbSqlUtil.$$$reportNull$$$0(45);
        }
        if (language == null) {
            DbSqlUtil.$$$reportNull$$$0(46);
        }
        if (queryText == null) {
            DbSqlUtil.$$$reportNull$$$0(47);
        }
        return DbSqlUtil.parseQueryTableType(console.getProject(), language, DbSqlUtil.getDbDataSource((Project)console.getProject(), (DasDataSource)console.getDataSource()), console.getSearchPath(), queryText, null);
    }

    public static boolean isResultEditable(@Nullable GridDataRequest request2, SqlTableType tableType, DasObject[] detectedTables) {
        DasObject[] tables;
        if (!(request2 instanceof DataRequest.QueryRequest)) {
            return false;
        }
        if (!(request2 instanceof ConsoleDataRequest)) {
            return true;
        }
        if (tableType == null) {
            return false;
        }
        PsiElement element = tableType.getTypeElement();
        if (element instanceof DasObject) {
            DasObject dasObject = (DasObject)element;
            DasObject[] dasObjectArray = new DasObject[1];
            v1 = dasObjectArray;
            dasObjectArray[0] = dasObject;
        } else {
            v1 = tables = detectedTables;
        }
        if ((tables == null || tables.length == 0) && (tables = (DasObject[])Arrays.stream(DbSqlUtil.getDasTablesForColumns(tableType)).map(x -> x.getDasTable()).filter(Objects::nonNull).distinct().toArray(DasObject[]::new)).length == 0) {
            return false;
        }
        boolean resultEditable = true;
        for (DasObject table : tables) {
            resultEditable &= table != null && DbImplUtilCore.isDataTable((ObjectKind)table.getKind());
        }
        return resultEditable;
    }

    @Nullable
    public static IntrospectionScopeUpdater getScopeUpdater(@NotNull SyntaxTraverser<PsiElement> s, @Nullable ObjectPath ns, @NotNull DasModel model) {
        if (s == null) {
            DbSqlUtil.$$$reportNull$$$0(48);
        }
        if (model == null) {
            DbSqlUtil.$$$reportNull$$$0(49);
        }
        IntrospectionScopeUpdater res2 = null;
        ObjectPath db = ns != null ? DbSqlUtil.getCurrentDatabase(ns) : DbSqlUtil.getCurrentDatabase(model);
        for (SqlStatement statement2 : s.filter(SqlStatement.class)) {
            ObjectKind kind;
            SqlDropStatement dropStatement;
            SqlReferenceExpression expression;
            ObjectPath objectName;
            if (statement2 instanceof SqlAlterStatement) {
                for (SqlSynonymDefinition synonymDefinition : SyntaxTraverser.psiApi().children((Object)statement2).filter(SqlSynonymDefinition.class)) {
                    ObjectKind kind2 = synonymDefinition.getKind();
                    if (kind2 != ObjectKind.DATABASE && kind2 != ObjectKind.SCHEMA) continue;
                    SqlNameElement newName = synonymDefinition.getNameElement();
                    SqlReferenceExpression oldName = synonymDefinition.getTargetReference();
                    if (newName == null || oldName == null) continue;
                    if (res2 == null) {
                        res2 = new IntrospectionScopeUpdater();
                    }
                    ObjectPath parent = kind2 == ObjectKind.SCHEMA ? db : null;
                    ObjectPath oldObjectName = ObjectPath.create((String)oldName.getName(), (ObjectKind)kind2, (boolean)oldName.isQuotedIdentifier(), null, (ObjectPath)parent);
                    ObjectPath newObjectName = ObjectPath.create((String)newName.getName(), (ObjectKind)kind2, (boolean)newName.isQuotedIdentifier(), null, (ObjectPath)parent);
                    res2.toRemove(oldObjectName);
                    res2.toAdd(newObjectName);
                }
                continue;
            }
            if (statement2 instanceof SqlCreateStatement) {
                SqlNameElement element;
                SqlCreateStatement createStatement = (SqlCreateStatement)statement2;
                ObjectKind kind3 = createStatement.getKind();
                if (kind3 != ObjectKind.DATABASE && kind3 != ObjectKind.SCHEMA || (element = createStatement.getNameElement()) == null) continue;
                if (res2 == null) {
                    res2 = new IntrospectionScopeUpdater();
                }
                objectName = ObjectPath.create((String)element.getName(), (ObjectKind)kind3, (boolean)element.isQuotedIdentifier(), null, (ObjectPath)(kind3 == ObjectKind.SCHEMA ? db : null));
                res2.toAdd(objectName);
                continue;
            }
            if (!(statement2 instanceof SqlDropStatement) || (expression = (dropStatement = (SqlDropStatement)statement2).getTargetExpression()) == null || (kind = expression.getReferenceElementType().getTargetKind()) != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) continue;
            if (res2 == null) {
                res2 = new IntrospectionScopeUpdater();
            }
            objectName = ObjectPath.create((String)expression.getName(), (ObjectKind)kind, (boolean)expression.isQuotedIdentifier(), null, (ObjectPath)(kind == ObjectKind.SCHEMA ? db : null));
            res2.toRemove(objectName);
        }
        return res2;
    }

    @Nullable
    public static ObjectPath getCurrentDatabase(@NotNull DasModel model) {
        DasNamespace cur;
        if (model == null) {
            DbSqlUtil.$$$reportNull$$$0(50);
        }
        if ((cur = model.getCurrentRootNamespace()) == null) {
            Iterator it = model.getModelRoots().filter(DasNamespace.class).iterator();
            if (!it.hasNext()) {
                return null;
            }
            cur = (DasNamespace)it.next();
            if (it.hasNext()) {
                return null;
            }
        }
        return cur.getKind() == ObjectKind.DATABASE ? ObjectPaths.of((DasObject)cur) : null;
    }

    @Nullable
    private static ObjectPath getCurrentDatabase(@NotNull ObjectPath ns) {
        if (ns == null) {
            DbSqlUtil.$$$reportNull$$$0(51);
        }
        return ns.findParent(ObjectKind.DATABASE, false);
    }

    public static boolean isSqlElement(@NotNull DbElement element) {
        DbDataSource dataSource;
        if (element == null) {
            DbSqlUtil.$$$reportNull$$$0(52);
        }
        return element != (dataSource = element.getDataSource()) && dataSource.getDelegate() instanceof SqlDataSource;
    }

    @Nullable
    public static DasObject getSqlSourceElement(@Nullable DbElement element) {
        DasObject dasObject;
        DasObject dasObject2 = dasObject = element == null ? null : (DasObject)ObjectUtils.tryCast((Object)element.getDelegate(), DasObject.class);
        if (dasObject == null) {
            return null;
        }
        return DbSqlUtil.getSqlSourceElement(element.getDataSource(), dasObject);
    }

    @Nullable
    public static DasObject getSqlSourceElement(@Nullable DbDataSource dataSource, @Nullable DasObject dasObject) {
        if (dataSource == null || dasObject == null) {
            return null;
        }
        SqlDataSource source = (SqlDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), SqlDataSource.class);
        return source == null ? null : source.fromModel(dasObject);
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull DatabaseDialect dialect) {
        SqlLanguageDialect res2;
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(53);
        }
        SqlLanguageDialect sqlLanguageDialect = (res2 = DbSqlUtil.findSqlDialect((DatabaseDialect)dialect)) == null ? SqlDialects.getGenericDialect() : res2;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(54);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static Language getLanguage(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbSqlUtil.$$$reportNull$$$0(55);
        }
        Object object = dbms == Dbms.MONGO ? MongoJSLanguage.INSTANCE : DbSqlUtil.getSqlDialect((Dbms)dbms);
        if (object == null) {
            DbSqlUtil.$$$reportNull$$$0(56);
        }
        return object;
    }

    @NotNull
    public static Language getLanguage(@Nullable DbDataSource dataSource) {
        Language language = dataSource == null ? null : dataSource.getQueryLanguage();
        Object object = language == null ? SqlDialects.getGenericDialect() : language;
        if (object == null) {
            DbSqlUtil.$$$reportNull$$$0(57);
        }
        return object;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DatabaseDriver driver) {
        SqlLanguageDialect dialect = DbSqlUtil.findSqlDialect(driver);
        SqlLanguageDialect sqlLanguageDialect = dialect == null ? SqlDialects.getGenericDialect() : dialect;
        if (sqlLanguageDialect == null) {
            DbSqlUtil.$$$reportNull$$$0(58);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect findSqlDialect(@Nullable DatabaseDriver driver) {
        if (driver == null) {
            return null;
        }
        String dialectId = driver.getSqlDialect();
        SqlLanguageDialect result = StringUtil.isEmpty((String)dialectId) ? null : SqlDialects.findDialectById((String)dialectId);
        return result != null ? result : DbSqlUtil.getSqlDialect((Dbms)DbImplUtilCore.getDbms((DatabaseDriver)driver));
    }

    @Deprecated(forRemoval=true)
    public static boolean areKeywordsLowerCase(@Nullable Project project) {
        SqlCodeStyleSettings codeStyleSettings = SqlCodeStyles.getGeneralSqlSettings((Project)project);
        Case keywordCaseMode = codeStyleSettings.getKeywordCase();
        return keywordCaseMode == Case.LOWER || keywordCaseMode == Case.MIXED;
    }

    public static boolean areKeywordsLowerCase(@Nullable Project project, @NotNull Language dialect) {
        SqlCodeStyleSettings codeStyleSettings;
        Case keywordCaseMode;
        if (dialect == null) {
            DbSqlUtil.$$$reportNull$$$0(59);
        }
        return (keywordCaseMode = (codeStyleSettings = SqlCodeStyles.getSqlSettings((Project)project, (Language)dialect)).getKeywordCase()) == Case.LOWER || keywordCaseMode == Case.MIXED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 22, 23, 24, 25, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 55, 59 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 22: 
            case 27: 
            case 32: 
            case 35: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 33: 
            case 36: 
            case 39: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 14: 
            case 19: 
            case 23: 
            case 28: 
            case 53: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 15: 
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 34: 
            case 37: 
            case 40: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "SQL_FILE_FILTER";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbSqlUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sql2Html";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnsFromType";
                break;
            }
            case 21: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnambiguousColumnNames";
                break;
            }
            case 54: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sql2Html";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGridTablesModel";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "detectTable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createColumnsFromType";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getUnambiguousColumnNames";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "makeUnambiguousColumnNames";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "parseQueryTableType";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "expressionHasSqlUnion";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "expressionHasSelfJoinOnTopLevel";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionCardinalityInfo";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getScopeUpdater";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentDatabase";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isSqlElement";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "areKeywordsLowerCase";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 22, 23, 24, 25, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 55, 59 -> new IllegalArgumentException(string);
        };
    }

    private static class ColumnWithDasTable {
        private final DasTable table;
        private final String columnName;
        private final int columnNumber;

        ColumnWithDasTable(DasTable table, int columnNumber, String columnName) {
            this.table = table;
            this.columnNumber = columnNumber;
            this.columnName = columnName;
        }

        public DasTable getDasTable() {
            return this.table;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }
    }
}

