/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.configuration;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.psi.SqlFile;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlNoDataSourceInspection
extends LocalInspectionTool {
    private static Key<Boolean> inspectionClosedKey = Key.create((String)"NO_DATASOURCE_INSPECTION_CLOSED");

    @NotNull
    public String getShortName() {
        return "SqlNoDataSourceInspection";
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SqlNoDataSourceInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlNoDataSourceInspection.$$$reportNull$$$0(1);
        }
        if (!isOnTheFly || !(file instanceof SqlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (Boolean.TRUE.equals(file.getUserData(inspectionClosedKey))) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        if (topLevelFile.getVirtualFile() instanceof LightVirtualFile) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!DbPsiFacade.getInstance((Project)manager.getProject()).getDataSources().isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        boolean injectedFile = topLevelFile != file;
        ConfigureDatasourceQuickFix setupFix = new ConfigureDatasourceQuickFix();
        LocalQuickFix[] quickFixes = new LocalQuickFix[]{setupFix, new TemporaryCloseQuickFix()};
        AnAction action = ActionManager.getInstance().getAction("ShowIntentionActions");
        String message = SqlBundle.message((String)"inspection.message.no.data.sources.are.configured", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((AnAction)action), injectedFile ? 0 : 1});
        ProblemDescriptor descriptor2 = manager.createProblemDescriptor((PsiElement)file, message, true, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        return new ProblemDescriptor[]{descriptor2};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/configuration/SqlNoDataSourceInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConfigureDatasourceQuickFix
    extends IntentionAndQuickFixAction {
        private ConfigureDatasourceQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                ConfigureDatasourceQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.configure.data.source", (Object[])new Object[0]);
            if (string == null) {
                ConfigureDatasourceQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor2) {
            if (project == null) {
                ConfigureDatasourceQuickFix.$$$reportNull$$$0(2);
            }
            DataSourceManagerDialog.showDialog(project, null, null);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlNoDataSourceInspection$ConfigureDatasourceQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlNoDataSourceInspection$ConfigureDatasourceQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class TemporaryCloseQuickFix
    extends IntentionAndQuickFixAction {
        private TemporaryCloseQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                TemporaryCloseQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"intention.family.name.dismiss", (Object[])new Object[0]);
            if (string == null) {
                TemporaryCloseQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor2) {
            if (project == null) {
                TemporaryCloseQuickFix.$$$reportNull$$$0(2);
            }
            psiFile.putUserData(inspectionClosedKey, (Object)Boolean.TRUE);
            DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlNoDataSourceInspection$TemporaryCloseQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlNoDataSourceInspection$TemporaryCloseQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

