/*
 * Decompiled with CFR 0.152.
 */
package com.goide.ide.welcomeScreen.newFileDialog;

import androidx.compose.runtime.internal.StabilityInferred;
import com.goide.i18n.GoBundle;
import com.goide.ide.welcomeScreen.leftPanel.GoWelcomeScreenFileTemplateOptionProvider;
import com.goide.ide.welcomeScreen.leftPanel.TemplateOption;
import com.goide.ide.welcomeScreen.newFileDialog.GoWelcomeScreenNewFileDialog;
import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\r\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ0\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u0014\u001a\u00020\u0005H\u0002R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/goide/ide/welcomeScreen/newFileDialog/GoWelcomeScreenNewFileHandler;", "", "<init>", "()V", "getDefaultProjectPath", "", "createEmptyFile", "", "project", "Lcom/intellij/openapi/project/Project;", "createHttpRequestFile", "createDockerfile", "KUBERNETES_RESOURCE_TEMPLATE_KEY", "createKubernetesResource", "showDialogAndCreateFile", "dialog", "Lcom/goide/ide/welcomeScreen/newFileDialog/GoWelcomeScreenNewFileDialog;", "templateNameProvider", "Lkotlin/Function1;", "showErrorMessage", "message", "TemplateNames", "intellij.go.ide"})
@StabilityInferred(parameters=1)
public final class GoWelcomeScreenNewFileHandler {
    @NotNull
    public static final GoWelcomeScreenNewFileHandler INSTANCE = new GoWelcomeScreenNewFileHandler();
    @NotNull
    private static final String KUBERNETES_RESOURCE_TEMPLATE_KEY = "kubernetes.resource.template";
    public static final int $stable;

    private GoWelcomeScreenNewFileHandler() {
    }

    @NotNull
    public final String getDefaultProjectPath() {
        String string = FileUtil.findSequentNonexistentFile((File)Path.of(ProjectUtil.getBaseDir(), new String[0]).toFile(), (String)"awesomeProject", (String)"").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    public final void createEmptyFile(@Nullable Project project) {
        GoWelcomeScreenNewFileDialog.Builder dialogBuilder;
        GoWelcomeScreenNewFileDialog.Builder builder;
        if (project == null) {
            return;
        }
        String string = GoBundle.message((String)"go.non.modal.welcome.screen.create.file.dialog.title.file", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GoWelcomeScreenNewFileDialog.Builder $this$createEmptyFile_u24lambda_u240 = builder = (dialogBuilder = new GoWelcomeScreenNewFileDialog.Builder(project, string));
        boolean bl = false;
        $this$createEmptyFile_u24lambda_u240.setDefaultDirectory(INSTANCE.getDefaultProjectPath());
        this.showDialogAndCreateFile(project, dialogBuilder.build(), (Function1<? super String, String>)((Function1)GoWelcomeScreenNewFileHandler::createEmptyFile$lambda$1));
    }

    public final void createHttpRequestFile(@Nullable Project project) {
        GoWelcomeScreenNewFileDialog.Builder dialogBuilder;
        GoWelcomeScreenNewFileDialog.Builder builder;
        if (project == null) {
            return;
        }
        String string = GoBundle.message((String)"go.non.modal.welcome.screen.create.file.dialog.title.http.request", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GoWelcomeScreenNewFileDialog.Builder $this$createHttpRequestFile_u24lambda_u242 = builder = (dialogBuilder = new GoWelcomeScreenNewFileDialog.Builder(project, string));
        boolean bl = false;
        $this$createHttpRequestFile_u24lambda_u242.setFixedExtension("http");
        $this$createHttpRequestFile_u24lambda_u242.setDefaultDirectory(INSTANCE.getDefaultProjectPath());
        this.showDialogAndCreateFile(project, dialogBuilder.build(), (Function1<? super String, String>)((Function1)GoWelcomeScreenNewFileHandler::createHttpRequestFile$lambda$3));
    }

    public final void createDockerfile(@Nullable Project project) {
        GoWelcomeScreenNewFileDialog.Builder dialogBuilder;
        GoWelcomeScreenNewFileDialog.Builder builder;
        if (project == null) {
            return;
        }
        String string = GoBundle.message((String)"go.non.modal.welcome.screen.create.file.dialog.title.dockerfile", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GoWelcomeScreenNewFileDialog.Builder $this$createDockerfile_u24lambda_u244 = builder = (dialogBuilder = new GoWelcomeScreenNewFileDialog.Builder(project, string));
        boolean bl = false;
        $this$createDockerfile_u24lambda_u244.setDefaultFileName("Dockerfile");
        $this$createDockerfile_u24lambda_u244.setDefaultDirectory(INSTANCE.getDefaultProjectPath());
        this.showDialogAndCreateFile(project, dialogBuilder.build(), (Function1<? super String, String>)((Function1)GoWelcomeScreenNewFileHandler::createDockerfile$lambda$5));
    }

    public final void createKubernetesResource(@Nullable Project project) {
        GoWelcomeScreenNewFileDialog.Builder dialogBuilder;
        GoWelcomeScreenNewFileDialog.Builder builder;
        if (project == null) {
            return;
        }
        String string = GoBundle.message((String)"go.non.modal.welcome.screen.create.file.dialog.title.k8s.resource", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GoWelcomeScreenNewFileDialog.Builder $this$createKubernetesResource_u24lambda_u246 = builder = (dialogBuilder = new GoWelcomeScreenNewFileDialog.Builder(project, string));
        boolean bl = false;
        $this$createKubernetesResource_u24lambda_u246.setFixedExtension("yaml");
        $this$createKubernetesResource_u24lambda_u246.setDefaultDirectory(INSTANCE.getDefaultProjectPath());
        Object object = GoWelcomeScreenFileTemplateOptionProvider.Companion.getForTemplateKey(KUBERNETES_RESOURCE_TEMPLATE_KEY);
        if (object == null || (object = ((GoWelcomeScreenFileTemplateOptionProvider)object).getTemplateOptions()) == null) {
            object = CollectionsKt.emptyList();
        }
        $this$createKubernetesResource_u24lambda_u246.setTemplateOptions((List<TemplateOption>)object);
        this.showDialogAndCreateFile(project, dialogBuilder.build(), (Function1<? super String, String>)((Function1)GoWelcomeScreenNewFileHandler::createKubernetesResource$lambda$7));
    }

    private final void showDialogAndCreateFile(Project project, GoWelcomeScreenNewFileDialog dialog, Function1<? super String, String> templateNameProvider) {
        if (!dialog.showAndGet()) {
            return;
        }
        PsiDirectory psiDirectory = dialog.getTargetDirectory();
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory directory = psiDirectory;
        String string = (String)templateNameProvider.invoke((Object)dialog.getSelectedTemplateName());
        if (string == null) {
            return;
        }
        String templateName = string;
        String fileName = dialog.getFileName();
        try {
            CreateFileAction.MkDirs mkdirs = new CreateFileAction.MkDirs(fileName, directory);
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getInternalTemplate(templateName);
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getInternalTemplate(...)");
            FileTemplate template = fileTemplate;
            Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
            Properties templateProperties = properties;
            PsiFile psiFile = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)mkdirs.newName, (Properties)templateProperties, (PsiDirectory)mkdirs.directory).getContainingFile();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null) {
                NonProjectFileWritingAccessProvider.allowWriting((Iterable)CollectionsKt.listOf((Object)virtualFile));
                ApplicationManager.getApplication().invokeLater(() -> GoWelcomeScreenNewFileHandler.showDialogAndCreateFile$lambda$8(template, psiFile, project, virtualFile));
            }
        }
        catch (Exception e) {
            Object[] objectArray = new Object[2];
            objectArray[0] = fileName;
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "Unknown error";
            }
            objectArray[1] = string2;
            String string3 = GoBundle.message((String)"go.non.modal.welcome.screen.error.dialog.message.cannot.create.file", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            this.showErrorMessage(project, string3);
        }
    }

    private final void showErrorMessage(Project project, @NlsContexts.DialogMessage String message) {
        ApplicationManager.getApplication().invokeLater(() -> GoWelcomeScreenNewFileHandler.showErrorMessage$lambda$9(project, message));
    }

    private static final String createEmptyFile$lambda$1(String it) {
        return "Generic Empty File";
    }

    private static final String createHttpRequestFile$lambda$3(String it) {
        return "HTTP Request.http";
    }

    private static final String createDockerfile$lambda$5(String it) {
        return "Dockerfile";
    }

    private static final String createKubernetesResource$lambda$7(String it) {
        return it;
    }

    private static final void showDialogAndCreateFile$lambda$8(FileTemplate $template, PsiFile $psiFile, Project $project, VirtualFile $virtualFile) {
        if ($template.isLiveTemplateEnabled()) {
            CreateFromTemplateManager.startLiveTemplate((PsiFile)$psiFile, (Map)MapsKt.emptyMap());
        } else {
            FileEditorManager.getInstance((Project)$project).openFile($virtualFile, true);
        }
    }

    private static final void showErrorMessage$lambda$9(Project $project, String $message) {
        Messages.showMessageDialog((Project)$project, (String)$message, (String)GoBundle.message((String)"go.non.modal.welcome.screen.error.dialog.title.cannot.create.file", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/goide/ide/welcomeScreen/newFileDialog/GoWelcomeScreenNewFileHandler$TemplateNames;", "", "<init>", "()V", "GENERIC_EMPTY_FILE", "", "HTTP_REQUEST", "DOCKERFILE", "intellij.go.ide"})
    private static final class TemplateNames {
        @NotNull
        public static final TemplateNames INSTANCE = new TemplateNames();
        @NotNull
        public static final String GENERIC_EMPTY_FILE = "Generic Empty File";
        @NotNull
        public static final String HTTP_REQUEST = "HTTP Request.http";
        @NotNull
        public static final String DOCKERFILE = "Dockerfile";

        private TemplateNames() {
        }
    }
}

