/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.gotpl;

import com.goide.template.psi.GoTemplateFile;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.kubernetes.helm.gotpl.HelmFileViewProviderFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLLanguage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/helm/gotpl/HelmTemplateBackspaceHandler;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "<init>", "()V", "stringToDelete", "", "beforeCharDeleted", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "charDeleted", "", "intellij.clouds.kubernetes.charts.gotpl"})
public final class HelmTemplateBackspaceHandler
extends BackspaceHandlerDelegate {
    @Nullable
    private String stringToDelete;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.stringToDelete = null;
        if (c != '{') {
            return;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return;
        }
        FileViewProvider fileViewProvider = file.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
        FileViewProvider viewProvider = fileViewProvider;
        if (!(viewProvider instanceof HelmFileViewProviderFactory.HelmFileViewProvider)) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset < 1) {
            return;
        }
        String whatToDelete = file instanceof GoTemplateFile && ((HelmFileViewProviderFactory.HelmFileViewProvider)viewProvider).findElementAt(editor.getCaretModel().getOffset(), (Language)YAMLLanguage.INSTANCE) == null ? "{}}" : "{}";
        int endOffset = offset + whatToDelete.length() - 1;
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence sequence = charSequence;
        if (sequence.length() >= endOffset && whatToDelete.contentEquals(sequence.subSequence(offset - 1, endOffset))) {
            this.stringToDelete = whatToDelete;
        }
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        String string = this.stringToDelete;
        if (string == null) {
            return false;
        }
        String whatToDelete = string;
        int actualNumberOfCharsToDelete = whatToDelete.length() - 1;
        if (actualNumberOfCharsToDelete < 1) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        int endOffset = offset + actualNumberOfCharsToDelete;
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence sequence = charSequence;
        if (sequence.length() >= endOffset) {
            editor.getDocument().deleteString(offset, endOffset);
            return true;
        }
        return false;
    }
}

