/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.introspector;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceBriefConfig;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.SchemaLevel;
import com.intellij.database.dialects.base.introspector.SchemaPortion;
import com.intellij.database.dialects.mysqlbase.MysqlBaseUtils;
import com.intellij.database.dialects.mysqlbase.MysqlRoutineRetrievalOption;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntroQueries;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$MysqlSchemaRetriever$retrievePartitions$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTableDetails$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector$applySchemas$lambda$7$;
import com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospectorKt;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseArgument;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseCheck;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseCollation;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseConstraint;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseEvent;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseForeignKey;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseGrantsHolder;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseIndex;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseKey;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseLikeColumn;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseLikeTable;
import com.intellij.database.dialects.mysqlbase.model.MysqlBasePartition;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseRoot;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseRoutine;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseSchema;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseSubpartition;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseTable;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseTableColumn;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseTrigger;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseUser;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseView;
import com.intellij.database.dialects.mysqlbase.model.properties.MysqlEventStatus;
import com.intellij.database.dialects.mysqlbase.model.properties.MysqlObjectGrant;
import com.intellij.database.dialects.mysqlbase.model.properties.MysqlObjectGrantController;
import com.intellij.database.dialects.mysqlbase.model.properties.MysqlRoleGrant;
import com.intellij.database.dialects.mysqlbase.model.properties.MysqlRoleGrantKt;
import com.intellij.database.dialects.mysqlbase.model.properties.MysqlSslType;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.FamilyFragment;
import com.intellij.database.introspection.FamilyFragments;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementCache;
import com.intellij.database.model.ElementCacheKt;
import com.intellij.database.model.ElementCacheOptimizersKt;
import com.intellij.database.model.ElementChecker;
import com.intellij.database.model.ElementDataCollector;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ElementSearcher;
import com.intellij.database.model.ElementSearcherNN;
import com.intellij.database.model.FamilySearcher;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ParentFamilySearcher;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModMultiLevelObject;
import com.intellij.database.model.basic.BasicModMultiLevelSchema;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicMultiLevelSchema;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.LevelFun;
import com.intellij.database.model.properties.RoutineSqlAccess;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.core.RowLayout;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Casing;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.Version;
import com.intellij.database.util.common.CalendarFun;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.StringKt;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 w*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005:\u0007vwxyz{|B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0014J\b\u00100\u001a\u00020+H\u0014J\b\u00101\u001a\u00020+H\u0014J\u0015\u00102\u001a\u00020+2\u0006\u00103\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u000206H\u0014J\b\u00107\u001a\u000206H\u0004J\u0010\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020:H\u0014J\b\u0010;\u001a\u00020+H\u0016J\u0010\u0010<\u001a\u00020+2\u0006\u00109\u001a\u00020:H\u0014J(\u0010=\u001a\u00020+2\u0006\u0010>\u001a\u00020:2\u0006\u0010?\u001a\u0002062\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0013H\u0014J\u0016\u0010C\u001a\u00020+2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EH\u0002J&\u0010G\u001a\u00020+2\u0006\u00109\u001a\u00020:2\f\u0010H\u001a\b\u0012\u0004\u0012\u00028\u00010E2\u0006\u0010I\u001a\u00020\u0013H\u0014J\u001e\u0010J\u001a\u00020+2\u0006\u0010>\u001a\u00020:2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020M0LH\u0014J\u0010\u0010N\u001a\u00020+2\u0006\u00109\u001a\u00020:H\u0002J*\u0010O\u001a\u0010\u0012\u0004\u0012\u000206\u0012\u0006\u0012\u0004\u0018\u0001060P2\u0006\u0010Q\u001a\u0002062\n\b\u0002\u0010R\u001a\u0004\u0018\u000106H\u0002J:\u0010S\u001a\u00020+*\b\u0012\u0004\u0012\u00020U0T2\u0006\u0010V\u001a\u0002062\u0006\u0010W\u001a\u00020X2\u0006\u0010Q\u001a\u0002062\u0006\u0010Y\u001a\u0002062\u0006\u0010Z\u001a\u000206H\u0002J\"\u0010S\u001a\u00020+*\b\u0012\u0004\u0012\u00020U0T2\u0006\u0010[\u001a\u00020U2\u0006\u0010Z\u001a\u00020\u0013H\u0002J(\u0010\\\u001a\u00020U2\u0006\u0010V\u001a\u0002062\u0006\u0010W\u001a\u00020X2\u0006\u0010Q\u001a\u0002062\u0006\u0010Y\u001a\u000206H\u0002J\n\u0010]\u001a\u000206*\u000206J\u001d\u0010^\u001a\u00020+2\u0006\u00109\u001a\u00020:2\u0006\u0010_\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010`J3\u0010a\u001a\u0018\u0012\u0004\u0012\u00028\u00000bR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010>\u001a\u00020:2\u0006\u0010c\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010dJ \u0010e\u001a\u00120fR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010>\u001a\u00020:H\u0014JJ\u0010g\u001a(\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010hR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010i2\u0006\u0010>\u001a\u00020:2\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010kH\u0014J5\u0010l\u001a\u001a\u0012\u0006\b\u0001\u0012\u00028\u00000mR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00052\u0006\u0010>\u001a\u00020:2\u0006\u0010c\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010nJ5\u0010o\u001a\u001a\u0012\u0006\b\u0001\u0012\u00028\u00010pR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010>\u001a\u00020:2\u0006\u0010_\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010qJ\u0010\u0010r\u001a\u0002062\u0006\u0010s\u001a\u000206H\u0002J\u0010\u0010t\u001a\u00020\u00132\u0006\u0010_\u001a\u00020uH\u0014R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0016\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0016\"\u0004\b\u001d\u0010\u001aR\u001a\u0010\u001e\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0016\"\u0004\b \u0010\u001aR\u001a\u0010!\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0016\"\u0004\b#\u0010\u001aR\u001a\u0010$\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0016\"\u0004\b&\u0010\u001aR\u001a\u0010'\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0016\"\u0004\b)\u0010\u001a\u00a8\u0006}"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector;", "R", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoot;", "S", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/Dbms;Lcom/intellij/database/model/ModelFactory;)V", "queries", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries;", "value", "", "circumventDbe5060", "getCircumventDbe5060", "()Z", "genFromSrc", "getGenFromSrc", "setGenFromSrc", "(Z)V", "defProperlyQuoted", "getDefProperlyQuoted", "setDefProperlyQuoted", "unescapeGenExpr", "getUnescapeGenExpr", "setUnescapeGenExpr", "parametersTableExists", "getParametersTableExists", "setParametersTableExists", "schedulerEnabled", "getSchedulerEnabled", "setSchedulerEnabled", "hasChecks", "getHasChecks", "setHasChecks", "initSpecificThings", "", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "dsConfig", "Lcom/intellij/database/dataSource/DataSourceBriefConfig;", "initConnectionRelatedState", "initFlags", "introspectSpecificServerInfo", "root", "(Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoot;)V", "tmpStorageEngineVar", "", "storageEngineVar", "introspectNamespacesInTran", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "retrieveAndApplySchemas", "introspectServerObjectsInner", "introspectRootFragments", "transaction", "databaseName", "fragments", "Lcom/intellij/database/introspection/FamilyFragments;", "checkForDroppedObjects", "applySchemas", "newSchemas", "", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Schema;", "introspectSchemasAuto", "schemas", "whole", "introspectElevation", "schemasToElevateLevels", "", "Lcom/intellij/database/dialects/base/introspector/SchemaLevel;", "retrieveCasing", "splitUser", "Lkotlin/Pair;", "grantee", "host", "appendPrivilege", "", "Lcom/intellij/database/dialects/mysqlbase/model/properties/MysqlObjectGrant;", "name", "kind", "Lcom/intellij/database/model/ObjectKind;", "permission", "isGrantable", "priv", "createPrivilege", "unescape", "introspectOneSchema", "schema", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;)V", "createDatabaseRetriever", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlDatabaseRetriever;", "database", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoot;)Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlDatabaseRetriever;", "createServerObjectsRetriever", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlServerObjectsRetriever;", "createLevelOneRetrieverForPortion", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseSchemasRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "portion", "Lcom/intellij/database/dialects/base/introspector/SchemaPortion;", "createNativeRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseNativeRetriever;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoot;)Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseNativeRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlSchemaRetriever;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;)Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlSchemaRetriever;", "quote", "def", "isSchemaSystem", "Lcom/intellij/database/model/basic/BasicSchema;", "Factory", "Companion", "MysqlDatabaseRetriever", "MysqlDatabaseSchemasRetriever", "MysqlServerObjectsRetriever", "MysqlNativeRetriever", "MysqlSchemaRetriever", "intellij.database.dialects.mysqlbase"})
@SourceDebugExtension(value={"SMAP\nMysqlBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlBaseIntrospector.kt\ncom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector\n+ 2 DataSourceBriefConfig.kt\ncom/intellij/database/dataSource/DataSourceBriefConfigs\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 IntrospectionQueryContext.kt\ncom/intellij/database/dialects/base/introspector/IntrospectionQueryContext\n+ 6 StringFun.kt\ncom/intellij/database/util/common/StringFun\n+ 7 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 8 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 9 ElementCache.kt\ncom/intellij/database/model/FamilySearcher\n+ 10 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1600:1\n42#2:1601\n39#2:1602\n1#3:1603\n1#3:1681\n37#4:1604\n36#4,3:1605\n411#5,2:1608\n411#5,2:1610\n148#6:1612\n500#7,18:1613\n500#7,18:1631\n418#8,10:1649\n428#8,9:1669\n437#8:1679\n429#8:1680\n430#8,9:1682\n439#8,3:1692\n431#8:1695\n432#8:1697\n189#9,10:1659\n202#9:1696\n1869#10:1678\n1870#10:1691\n*S KotlinDebug\n*F\n+ 1 MysqlBaseIntrospector.kt\ncom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector\n*L\n104#1:1601\n104#1:1602\n199#1:1681\n187#1:1604\n187#1:1605,3\n209#1:1608,2\n219#1:1610,2\n243#1:1612\n137#1:1613,18\n140#1:1631,18\n199#1:1649,10\n199#1:1669,9\n199#1:1679\n199#1:1680\n199#1:1682,9\n199#1:1692,3\n199#1:1695\n199#1:1697\n199#1:1659,10\n199#1:1696\n199#1:1678\n199#1:1691\n*E\n"})
public class MysqlBaseIntrospector<R extends MysqlBaseRoot, S extends MysqlBaseSchema>
extends BaseSingleDatabaseIntrospector<R, S> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MysqlBaseIntroQueries queries;
    private boolean circumventDbe5060;
    private boolean genFromSrc;
    private boolean defProperlyQuoted;
    private boolean unescapeGenExpr;
    private boolean parametersTableExists;
    private boolean schedulerEnabled;
    private boolean hasChecks;
    private static final boolean supportServerObjects = true;
    private static final boolean supportLevelByLevelIntrospection = true;
    private static final boolean supportFragmentIntrospection = true;
    @NotNull
    private static final Set<ObjectKind> supportFragmentKinds;
    @NotNull
    private static final Set<String> systemSchemaNames;

    public MysqlBaseIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        super(context, Companion, dbms, modelFactory);
        this.queries = new MysqlBaseIntroQueries(this);
        this.circumventDbe5060 = true;
        this.schedulerEnabled = true;
    }

    @NotNull
    protected final MysqlBaseIntroQueries getQueries() {
        return this.queries;
    }

    public final boolean getCircumventDbe5060() {
        return this.circumventDbe5060;
    }

    protected final boolean getGenFromSrc() {
        return this.genFromSrc;
    }

    protected final void setGenFromSrc(boolean bl) {
        this.genFromSrc = bl;
    }

    protected final boolean getDefProperlyQuoted() {
        return this.defProperlyQuoted;
    }

    protected final void setDefProperlyQuoted(boolean bl) {
        this.defProperlyQuoted = bl;
    }

    protected final boolean getUnescapeGenExpr() {
        return this.unescapeGenExpr;
    }

    protected final void setUnescapeGenExpr(boolean bl) {
        this.unescapeGenExpr = bl;
    }

    protected final boolean getParametersTableExists() {
        return this.parametersTableExists;
    }

    protected final void setParametersTableExists(boolean bl) {
        this.parametersTableExists = bl;
    }

    protected final boolean getSchedulerEnabled() {
        return this.schedulerEnabled;
    }

    protected final void setSchedulerEnabled(boolean bl) {
        this.schedulerEnabled = bl;
    }

    protected final boolean getHasChecks() {
        return this.hasChecks;
    }

    protected final void setHasChecks(boolean bl) {
        this.hasChecks = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initSpecificThings(@NotNull BasicModModel model, @NotNull DataSourceBriefConfig dsConfig) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)dsConfig, (String)"dsConfig");
        super.initSpecificThings(model, dsConfig);
        if (!Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.MARIA)) {
            void $this$getBooleanOptionValue$iv;
            DataSourceBriefConfig dataSourceBriefConfig = dsConfig;
            boolean default$iv = true;
            boolean $i$f$getBooleanOptionValue = false;
            void $this$getOptionValue$iv$iv = $this$getBooleanOptionValue$iv;
            boolean $i$f$getOptionValue = false;
            Boolean bl = (Boolean)$this$getOptionValue$iv$iv.getProvidedOptionValue(MysqlRoutineRetrievalOption.class);
            this.circumventDbe5060 = bl != null ? bl : default$iv;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initConnectionRelatedState() {
        void it;
        String schedulerStatus;
        super.initConnectionRelatedState();
        this.initFlags();
        String string = schedulerStatus = (String)this.inTransaction(arg_0 -> MysqlBaseIntrospector.initConnectionRelatedState$lambda$0(this, arg_0));
        MysqlBaseIntrospector mysqlBaseIntrospector = this;
        boolean bl = false;
        boolean bl2 = !Intrinsics.areEqual((Object)it, (Object)"DISABLED");
        mysqlBaseIntrospector.schedulerEnabled = bl2;
    }

    protected void initFlags() {
        if (Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.MEMSQL)) {
            this.genFromSrc = false;
            this.defProperlyQuoted = false;
            this.unescapeGenExpr = false;
            this.hasChecks = false;
        } else {
            Version v = MysqlBaseUtils.getMysqlMatchingVersion(this.dbms, this.getServerVersion());
            this.genFromSrc = false;
            this.defProperlyQuoted = false;
            int[] nArray = new int[]{8};
            this.unescapeGenExpr = v.isOrGreater(nArray);
            nArray = new int[]{8, 0, 16};
            this.hasChecks = v.isOrGreater(nArray);
        }
    }

    @Override
    protected void introspectSpecificServerInfo(@NotNull R root) {
        block0: {
            Intrinsics.checkNotNullParameter(root, (String)"root");
            super.introspectSpecificServerInfo((BasicModRoot)root);
            Ref.ObjectRef engines = new Ref.ObjectRef();
            this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)arg_0 -> MysqlBaseIntrospector.introspectSpecificServerInfo$lambda$4(this, engines, arg_0)));
            String[] stringArray = (String[])engines.element;
            if (stringArray == null) break block0;
            String[] eng = stringArray;
            boolean bl = false;
            int n = eng.length;
            root.setDefaultEngine(n >= 1 ? eng[0] : null);
            root.setDefaultTmpEngine(n >= 2 ? eng[1] : null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected String tmpStorageEngineVar() {
        if (Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.MYSQL)) {
            int[] nArray = new int[]{5, 6, 3};
            if (this.getServerVersion().isOrGreater(nArray)) return "default_tmp_storage_engine";
        }
        if (Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.MYSQL_AURORA)) {
            return "default_tmp_storage_engine";
        }
        String string = this.storageEngineVar();
        return string;
    }

    @NotNull
    protected final String storageEngineVar() {
        int[] nArray = new int[]{5, 5, 3};
        return this.getServerVersion().isOrGreater(nArray) || Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.MYSQL_AURORA) ? "default_storage_engine" : "storage_engine";
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.retrieveCasing(tran);
        List<MysqlBaseIntroQueries.Schema> schemaNames2 = this.queries.retrieveSchemas(tran);
        this.applySchemas(schemaNames2);
    }

    @Override
    public void retrieveAndApplySchemas() {
        List schemaNames2 = (List)this.inTransaction((Function1)new Function1<DBTransaction, List<? extends MysqlBaseIntroQueries.Schema>>((Object)this.queries){

            public final List<MysqlBaseIntroQueries.Schema> invoke(DBTransaction p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((MysqlBaseIntroQueries)this.receiver).retrieveSchemas(p0);
            }
        });
        this.applySchemas(schemaNames2);
    }

    @Override
    protected void introspectServerObjectsInner(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        MysqlServerObjectsRetriever serverObjectsRetriever = this.createServerObjectsRetriever(tran);
        serverObjectsRetriever.setupRegular();
        serverObjectsRetriever.retrieveAuxiliaryObjects();
    }

    @Override
    protected void introspectRootFragments(@NotNull DBTransaction transaction, @NotNull String databaseName, @NotNull FamilyFragments fragments2, boolean checkForDroppedObjects) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)fragments2, (String)"fragments");
        MysqlServerObjectsRetriever serverObjectsRetriever = this.createServerObjectsRetriever(transaction);
        for (FamilyFragment fragment : fragments2) {
            if (Intrinsics.areEqual((Object)fragment.getKind(), (Object)ObjectKind.USER)) {
                Collection $this$toTypedArray$iv = fragment.getNames();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] userNames = thisCollection$iv.toArray(new String[0]);
                serverObjectsRetriever.retrieveUsers$intellij_database_dialects_mysqlbase(userNames);
                continue;
            }
            this.log.warn("Fragment introspection for " + fragment.getKind().getPluralPresentableName() + " is not supported");
        }
    }

    private final void applySchemas(List<MysqlBaseIntroQueries.Schema> newSchemas) {
        this.inModel(arg_0 -> MysqlBaseIntrospector.applySchemas$lambda$7(newSchemas, this, arg_0));
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends S> schemas, boolean whole) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        int schemaCnt = schemas.size();
        IntrospectionQueryContext this_$iv = this;
        boolean $i$f$trace = false;
        if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
            IntrospectionQueryContext introspectionQueryContext = this_$iv;
            boolean bl = false;
            introspectionQueryContext.trace((String)(whole ? "Requested whole data source introspection" : "Requested introspection of the specified " + schemaCnt + " " + StringUtil.pluralize((String)"schema", (int)schemaCnt)));
        }
        this.introspectSchemasByLevels(tran, (BasicModDatabase)this.getRoot(), schemas, whole, null, null);
    }

    @Override
    protected void introspectElevation(@NotNull DBTransaction transaction, @NotNull Collection<SchemaLevel> schemasToElevateLevels) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(schemasToElevateLevels, (String)"schemasToElevateLevels");
        int schemaCnt = schemasToElevateLevels.size();
        IntrospectionQueryContext this_$iv = this;
        boolean $i$f$trace = false;
        if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
            IntrospectionQueryContext introspectionQueryContext = this_$iv;
            boolean bl = false;
            introspectionQueryContext.trace("Requested detail level elevation of the specified " + schemaCnt + " " + StringUtil.pluralize((String)"schema", (int)schemaCnt));
        }
        List schemas = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)schemasToElevateLevels), MysqlBaseIntrospector::introspectElevation$lambda$10));
        this.introspectSchemasByLevels(transaction, (BasicModDatabase)this.getRoot(), schemas, false, schemasToElevateLevels, null);
    }

    private final void retrieveCasing(DBTransaction tran) {
        Integer casing = this.queries.retrieveCasing(tran);
        this.inModel(arg_0 -> MysqlBaseIntrospector.retrieveCasing$lambda$11(casing, arg_0));
    }

    private final Pair<String, String> splitUser(String grantee, String host) {
        String string;
        String string2;
        CharSequence $this$isNotNullOrEmpty$iv = host;
        boolean $i$f$isNotNullOrEmpty = false;
        if ($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) {
            return new Pair((Object)grantee, (Object)host);
        }
        int at = StringsKt.lastIndexOf$default((CharSequence)grantee, (char)'@', (int)0, (boolean)false, (int)6, null);
        String string3 = grantee;
        MysqlBaseIntrospector mysqlBaseIntrospector = this;
        boolean bl = false;
        if (at == -1) {
            string2 = it;
        } else {
            String string4 = it.substring(0, at);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        }
        String userName = mysqlBaseIntrospector.unescape(string2);
        if (at == -1) {
            string = null;
        } else {
            String string5 = grantee.substring(at + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string = this.unescape(string5);
        }
        String hostName = string;
        return new Pair((Object)userName, hostName);
    }

    static /* synthetic */ Pair splitUser$default(MysqlBaseIntrospector mysqlBaseIntrospector, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: splitUser");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return mysqlBaseIntrospector.splitUser(string, string2);
    }

    private final void appendPrivilege(List<MysqlObjectGrant> $this$appendPrivilege, String name2, ObjectKind kind, String grantee, String permission, String isGrantable) {
        this.appendPrivilege($this$appendPrivilege, this.createPrivilege(name2, kind, grantee, permission), StringsKt.equals((String)isGrantable, (String)"yes", (boolean)true));
    }

    private final void appendPrivilege(List<MysqlObjectGrant> $this$appendPrivilege, MysqlObjectGrant priv, boolean isGrantable) {
        if (!StringsKt.equals((String)priv.getPermission(), (String)"usage", (boolean)true)) {
            ((Collection)$this$appendPrivilege).add(priv);
        }
        if (isGrantable) {
            ((Collection)$this$appendPrivilege).add(MysqlObjectGrantController.INSTANCE.withPermission(priv, "grant option", (BitSet)null, Grants.State.GRANT));
        }
    }

    private final MysqlObjectGrant createPrivilege(String name2, ObjectKind kind, String grantee, String permission) {
        Pair pair = MysqlBaseIntrospector.splitUser$default(this, grantee, null, 2, null);
        String user = (String)pair.component1();
        String host = (String)pair.component2();
        String string = host;
        if (string == null) {
            string = "";
        }
        return new MysqlObjectGrant(name2, kind, null, user, string, permission, Grants.State.GRANT);
    }

    @NotNull
    public final String unescape(@NotNull String $this$unescape) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$unescape, (String)"<this>");
        if (StringsKt.startsWith$default((CharSequence)$this$unescape, (char)'\'', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)$this$unescape, (char)'\'', (boolean)false, (int)2, null) && $this$unescape.length() > 2) {
            String string2 = $this$unescape.substring(1, $this$unescape.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = $this$unescape;
        }
        return string;
    }

    private final void introspectOneSchema(DBTransaction tran, S schema) {
        this.handleErrors("Introspect schema " + schema.getName(), (Function0<Unit>)((Function0)() -> MysqlBaseIntrospector.introspectOneSchema$lambda$13(this, tran, schema)));
    }

    @Override
    @NotNull
    protected MysqlDatabaseRetriever<R> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull R database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(database, (String)"database");
        return new MysqlDatabaseRetriever(transaction);
    }

    @Override
    @NotNull
    protected MysqlServerObjectsRetriever createServerObjectsRetriever(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return new MysqlServerObjectsRetriever(transaction);
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseSchemasRetriever<? extends R, ? extends S> createLevelOneRetrieverForPortion(@NotNull DBTransaction transaction, @NotNull SchemaPortion<? extends R, ? extends S> portion) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(portion, (String)"portion");
        return new MysqlDatabaseSchemasRetriever<R, S>(transaction, portion);
    }

    @Override
    @NotNull
    protected BaseSingleDatabaseIntrospector.BaseNativeRetriever<? extends R> createNativeRetriever(@NotNull DBTransaction transaction, @NotNull R database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(database, (String)"database");
        return new MysqlNativeRetriever(transaction);
    }

    @Override
    @NotNull
    protected MysqlSchemaRetriever<? extends S> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull S schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        return new MysqlSchemaRetriever(this, transaction, schema);
    }

    private final String quote(String def) {
        String simpleEscaped = StringsKt.replace$default((String)def, (String)"'", (String)"''", (boolean)false, (int)4, null);
        return StringsKt.replace$default((String)StringsKt.replace$default((String)("'" + StringUtil.escapeStringCharacters((int)simpleEscaped.length(), (String)simpleEscaped, null, (boolean)true, (boolean)false, (StringBuilder)new StringBuilder()) + "'"), (String)"\u001a", (String)"\\Z", (boolean)false, (int)4, null), (String)"\u0000", (String)"\\0", (boolean)false, (int)4, null);
    }

    @Override
    protected boolean isSchemaSystem(@NotNull BasicSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return systemSchemaNames.contains(schema.getName());
    }

    private static final String initConnectionRelatedState$lambda$0(MysqlBaseIntrospector this$0, DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        return this$0.queries.retrieveSchedulerStatus(tran, this$0.dbms);
    }

    private static final Unit introspectSpecificServerInfo$lambda$4(MysqlBaseIntrospector this$0, Ref.ObjectRef $engines, DBTransaction tran) {
        String message$iv;
        boolean bl;
        StringBuilder $this$continueOnDbError_u24lambda_u2417$iv;
        StringBuilder stringBuilder;
        boolean expected$iv;
        BaseNativeIntrospector this_$iv;
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        BaseNativeIntrospector baseNativeIntrospector = this$0;
        CharSequence whatsDoing$iv = "Checking whether the parameters table exists";
        boolean $i$f$continueOnDbError = false;
        try {
            boolean bl2 = false;
            this$0.parametersTableExists = this$0.queries.retrieveParametersTableExists(tran);
        }
        catch (DBException e$iv) {
            expected$iv = BaseNativeIntrospector.access$ignoreThisDbException(this_$iv, e$iv);
            $this$continueOnDbError_u24lambda_u2417$iv = stringBuilder = new StringBuilder();
            bl = false;
            $this$continueOnDbError_u24lambda_u2417$iv.append(expected$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u2417$iv.append(" DB error ").append(e$iv.vendorErrorCode).append(" encountered (and ignored)");
            if (whatsDoing$iv.length() > 0) {
                $this$continueOnDbError_u24lambda_u2417$iv.append(" while: ").append(whatsDoing$iv);
            }
            $this$continueOnDbError_u24lambda_u2417$iv.append(". Exception message: ").append(e$iv.getMessage());
            message$iv = stringBuilder.toString();
            if (expected$iv) {
                this_$iv.trace(message$iv);
            } else {
                IntrospectionQueryContext.logWarn$default(this_$iv, message$iv, null, 2, null);
            }
            this_$iv.getErrorSink().accept(null, e$iv);
        }
        this_$iv = this$0;
        whatsDoing$iv = "Getting default engines";
        $i$f$continueOnDbError = false;
        try {
            boolean bl3 = false;
            $engines.element = this$0.queries.retrieveDefaultEngines(tran, this$0.dbms, this$0.storageEngineVar(), this$0.tmpStorageEngineVar());
        }
        catch (DBException e$iv) {
            expected$iv = BaseNativeIntrospector.access$ignoreThisDbException(this_$iv, e$iv);
            $this$continueOnDbError_u24lambda_u2417$iv = stringBuilder = new StringBuilder();
            bl = false;
            $this$continueOnDbError_u24lambda_u2417$iv.append(expected$iv ? "Expected" : "Unexpected");
            $this$continueOnDbError_u24lambda_u2417$iv.append(" DB error ").append(e$iv.vendorErrorCode).append(" encountered (and ignored)");
            if (whatsDoing$iv.length() > 0) {
                $this$continueOnDbError_u24lambda_u2417$iv.append(" while: ").append(whatsDoing$iv);
            }
            $this$continueOnDbError_u24lambda_u2417$iv.append(". Exception message: ").append(e$iv.getMessage());
            message$iv = stringBuilder.toString();
            if (expected$iv) {
                this_$iv.trace(message$iv);
            } else {
                IntrospectionQueryContext.logWarn$default(this_$iv, message$iv, null, 2, null);
            }
            this_$iv.getErrorSink().accept(null, e$iv);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit applySchemas$lambda$7(List $newSchemas, MysqlBaseIntrospector this$0, MysqlBaseRoot root) {
        void $this$iv$iv$iv;
        void $this$applySchemasNamed$iv$iv;
        void searchCache$iv$iv;
        void $this$applySchemasNamed$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        NamingFamily namingFamily = root.getSchemas();
        Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
        NamingFamily namingFamily2 = namingFamily;
        List scs$iv = $newSchemas;
        boolean $i$f$applySchemasNamed = false;
        void var6_6 = $this$applySchemasNamed$iv;
        ElementSearchCache elementSearchCache = new ElementSearchCache();
        List scs$iv$iv = scs$iv;
        boolean $i$f$applySchemasNamed2 = false;
        FamilySearcher familySearcher = ElementCacheOptimizersKt.byName(ElementCacheKt.searchElement((ElementSearchCache)searchCache$iv$iv), (Function1)new Function1<MysqlBaseIntroQueries.Schema, String>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final String invoke(Object $this$byName) {
                MysqlBaseIntroQueries.Schema p0 = (MysqlBaseIntroQueries.Schema)$this$byName;
                boolean bl = false;
                return p0.schema_name;
            }
        }).inFamily((Family)$this$applySchemasNamed$iv$iv);
        Function2 filler$iv$iv$iv = applySchemas$lambda$7$$inlined$applySchemasNamed$2.INSTANCE;
        boolean $i$f$orCreateBulk = false;
        ArrayList items$iv$iv$iv = new ArrayList();
        ElementSearcherNN searcher$iv$iv$iv = ElementCacheKt.orCreateElement((ElementSearcher)$this$iv$iv$iv, (Function1)new Function1<D, T>((FamilySearcher)$this$iv$iv$iv, filler$iv$iv$iv, items$iv$iv$iv){
            final /* synthetic */ FamilySearcher this$0;
            final /* synthetic */ Function2 $filler;
            final /* synthetic */ ArrayList $items;
            {
                this.this$0 = $receiver;
                this.$filler = $filler;
                this.$items = $items;
            }

            public final T invoke(D it) {
                T t = BasicMetaUtils.getMetaObject(this.this$0.getFamily()).newDataObject();
                Intrinsics.checkNotNullExpressionValue(t, (String)"newDataObject(...)");
                T t2 = t;
                FamilySearcher familySearcher = this.this$0;
                Function2 function2 = this.$filler;
                ArrayList arrayList = this.$items;
                T $this$invoke_u24lambda_u240 = t2;
                boolean bl = false;
                familySearcher.fillImpl($this$invoke_u24lambda_u240, it, function2);
                ((Collection)arrayList).add($this$invoke_u24lambda_u240);
                return t2;
            }
        });
        try {
            void $this$applySchemasImpl$iv$iv$iv;
            ElementSearcherNN schemas$iv$iv = searcher$iv$iv$iv;
            boolean bl = false;
            void var17_18 = $this$applySchemasNamed$iv$iv;
            List scs$iv$iv$iv = scs$iv$iv;
            boolean $i$f$applySchemasImpl = false;
            $this$applySchemasImpl$iv$iv$iv.markChildrenAsSyncPending();
            Iterable $this$forEach$iv$iv$iv$iv = scs$iv$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void s;
                void sc$iv$iv;
                Object element$iv$iv$iv$iv;
                Object sc$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Object t = sc$iv$iv$iv;
                void $this$applySchemasNamed_u24lambda_u2420_u24lambda_u2419$iv$iv = $this$applySchemasImpl$iv$iv$iv;
                boolean bl3 = false;
                BasicModMateNamespace $this$applySchemasNamed_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418$iv$iv = (BasicModMateNamespace)schemas$iv$iv.find(sc$iv$iv);
                boolean bl4 = false;
                MysqlBaseIntroQueries.Schema schema = (MysqlBaseIntroQueries.Schema)sc$iv$iv;
                MysqlBaseSchema $this$applySchemas_u24lambda_u247_u24lambda_u246 = (MysqlBaseSchema)$this$applySchemasNamed_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418$iv$iv;
                boolean bl5 = false;
                $this$applySchemas_u24lambda_u247_u24lambda_u246.setCollationRef(BasicNameReference.create(s.default_collation_name));
                $this$applySchemas_u24lambda_u247_u24lambda_u246.setCurrent(Intrinsics.areEqual((Object)s.schema_name, (Object)((MysqlBaseIntrospector)this$0).getDbConnectionInfo().schemaName));
            }
            $this$applySchemasImpl$iv$iv$iv.removeSyncPendingChildren();
            $this$applySchemasImpl$iv$iv$iv.sort();
        }
        finally {
            Family family = $this$iv$iv$iv.getFamily();
            Intrinsics.checkNotNull(family, (String)"null cannot be cast to non-null type com.intellij.database.model.families.Family<T of com.intellij.database.model.FamilySearcher>");
            BaseModel.createBulk(family, items$iv$iv$iv);
        }
        return Unit.INSTANCE;
    }

    private static final MysqlBaseSchema introspectElevation$lambda$10(SchemaLevel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BasicSchema basicSchema = it.getSchema();
        Intrinsics.checkNotNull((Object)basicSchema, (String)"null cannot be cast to non-null type S of com.intellij.database.dialects.mysqlbase.introspector.MysqlBaseIntrospector");
        return (MysqlBaseSchema)basicSchema;
    }

    private static final Unit retrieveCasing$lambda$11(Integer $casing, MysqlBaseRoot r) {
        Casing casing;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        BasicModRoot basicModRoot = r;
        Integer n2 = n = $casing;
        if (n2 != null && n2 == 0) {
            casing = BasicNamespace.EXACT_CASING;
        } else {
            Integer n3 = n;
            int n4 = 1;
            casing = n3 != null && n3 == n4 ? BasicNamespace.LOWER_CASING : BasicNamespace.MIXED_CASING;
        }
        basicModRoot.setDefaultCasing(casing);
        return Unit.INSTANCE;
    }

    private static final Unit introspectOneSchema$lambda$13(MysqlBaseIntrospector this$0, DBTransaction $tran, MysqlBaseSchema $schema) {
        MysqlSchemaRetriever<MysqlBaseSchema> retriever = this$0.createSchemaRetriever($tran, (Object)$schema);
        retriever.process();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MysqlBaseRoot access$getRoot(MysqlBaseIntrospector $this) {
        return (MysqlBaseRoot)$this.getRoot();
    }

    public static final /* synthetic */ String access$quote(MysqlBaseIntrospector $this, String def) {
        return $this.quote(def);
    }

    static {
        Object[] objectArray = new ObjectKind[]{ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE, ObjectKind.SCHEDULED_EVENT, ObjectKind.USER};
        supportFragmentKinds = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"mysql", "information_schema", "performance_schema", "sys"};
        systemSchemaNames = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$Companion;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "<init>", "()V", "supportServerObjects", "", "getSupportServerObjects", "()Z", "supportLevelByLevelIntrospection", "getSupportLevelByLevelIntrospection", "supportFragmentIntrospection", "getSupportFragmentIntrospection", "supportFragmentKinds", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportFragmentKinds", "()Ljava/util/Set;", "systemSchemaNames", "", "getSystemSchemaNames", "intellij.database.dialects.mysqlbase"})
    public static final class Companion
    implements BaseIntrospector.Nature {
        private Companion() {
        }

        @Override
        public boolean getSupportServerObjects() {
            return supportServerObjects;
        }

        @Override
        public boolean getSupportLevelByLevelIntrospection() {
            return supportLevelByLevelIntrospection;
        }

        @Override
        public boolean getSupportFragmentIntrospection() {
            return supportFragmentIntrospection;
        }

        @Override
        @NotNull
        public Set<ObjectKind> getSupportFragmentKinds() {
            return supportFragmentKinds;
        }

        @NotNull
        public final Set<String> getSystemSchemaNames() {
            return systemSchemaNames;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0019\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "supportsFragmentIntrospection", "getSupportsFragmentIntrospection", "()Z", "supportsMultilevelIntrospection", "getSupportsMultilevelIntrospection", "VERSION", "intellij.database.dialects.mysqlbase"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @NotNull
        private final Dbms dbms;
        private final boolean supportsFragmentIntrospection;
        private final boolean supportsMultilevelIntrospection;

        public Factory(@NotNull Dbms dbms) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            this.dbms = dbms;
            this.supportsFragmentIntrospection = true;
            this.supportsMultilevelIntrospection = true;
        }

        @NotNull
        public final Dbms getDbms() {
            return this.dbms;
        }

        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{5, 1};
            return version.isOrGreater(nArray) || Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.MYSQL_AURORA);
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new MysqlBaseIntrospector(context, dbms, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        public boolean getSupportsFragmentIntrospection() {
            return this.supportsFragmentIntrospection;
        }

        public boolean getSupportsMultilevelIntrospection() {
            return this.supportsMultilevelIntrospection;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.mysqlbase"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u0018\u0012\u0004\u0012\u0002H\u00010\u0003R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlDatabaseRetriever;", "R", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "<init>", "(Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "intellij.database.dialects.mysqlbase"})
    protected final class MysqlDatabaseRetriever<R extends MysqlBaseRoot>
    extends BaseSingleDatabaseIntrospector.BaseDatabaseRetriever<R> {
        public MysqlDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(transaction);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\b\b\u0003\u0010\u0003*\u00020\u00042\u001e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006B%\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\u0016\u0010\u0015\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00030\u0017H\u0002J\u0015\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00028\u0003H\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0012H\u0002J\u0016\u0010\u001c\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00030\u0017H\u0002J\u0014\u0010\u001d\u001a\u00020\u0012*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010\u001d\u001a\u00020\u0012*\u00020!2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlDatabaseSchemasRetriever;", "R", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoot;", "S", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseSchemasRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schemaPortion", "Lcom/intellij/database/dialects/base/introspector/SchemaPortion;", "<init>", "(Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/base/introspector/SchemaPortion;)V", "hasRoutines", "", "introLocalTimestamp", "Ljava/time/Instant;", "process", "", "processInner", "retrieveAllMajorNames", "retrieveMajorNamesForSchemaBunch", "schemas", "", "finalizeLevel1", "schema", "(Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;)V", "retrieveAllMinorNames", "retrieveMinorNamesForSchemaBunch", "applyBriefInfo", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseLikeColumn;", "m", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$OneMinorName;", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseArgument;", "intellij.database.dialects.mysqlbase"})
    @SourceDebugExtension(value={"SMAP\nMysqlBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlBaseIntrospector.kt\ncom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlDatabaseSchemasRetriever\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1600:1\n1#2:1601\n1869#3,2:1602\n1869#3,2:1604\n1869#3,2:1606\n*S KotlinDebug\n*F\n+ 1 MysqlBaseIntrospector.kt\ncom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlDatabaseSchemasRetriever\n*L\n387#1:1602,2\n388#1:1604,2\n389#1:1606,2\n*E\n"})
    protected final class MysqlDatabaseSchemasRetriever<R extends MysqlBaseRoot, S extends MysqlBaseSchema>
    extends BaseSingleDatabaseIntrospector.BaseDatabaseSchemasRetriever<R, S> {
        private boolean hasRoutines;
        private Instant introLocalTimestamp;

        public MysqlDatabaseSchemasRetriever(@NotNull DBTransaction transaction, SchemaPortion<? extends R, ? extends S> schemaPortion) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schemaPortion, (String)"schemaPortion");
            super(transaction, schemaPortion.getSchemas());
        }

        @Override
        public void process() {
            int schemasCnt = this.getSchemas().size();
            String logMessage = "Introspecting database at level 1: " + schemasCnt + " schemas";
            Object[] objectArray = new Object[]{schemasCnt};
            String string = DatabaseBundle.message("introspection.report.database.regular.full", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String statusMessage = string;
            ((MysqlBaseIntrospector)MysqlBaseIntrospector.this).doSectionWithStatus("Introspect.Database.L1.Full", logMessage, true, statusMessage, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    MysqlDatabaseSchemasRetriever.access$processInner((MysqlDatabaseSchemasRetriever)this.receiver);
                }
            }));
        }

        private final void processInner() {
            this.introLocalTimestamp = CalendarFun.currentInstantTruncatedToSeconds();
            this.retrieveAllMajorNames();
            this.retrieveAllMinorNames();
        }

        private final void retrieveAllMajorNames() {
            if (this.getSchemas().isEmpty()) {
                return;
            }
            for (List bunch : CollectionFun.splitIntoChunksOf(this.getSchemas(), 32)) {
                this.retrieveMajorNamesForSchemaBunch(bunch);
            }
        }

        private final void retrieveMajorNamesForSchemaBunch(List<? extends S> schemas) {
            this.inDatabase(arg_0 -> MysqlDatabaseSchemasRetriever.retrieveMajorNamesForSchemaBunch$lambda$3(schemas, this, MysqlBaseIntrospector.this, arg_0));
        }

        private final void finalizeLevel1(S schema) {
            ((BasicModMultiLevelSchema)schema).setLastIntrospectionLevel(Level.L1);
            BasicModSchema basicModSchema = (BasicModSchema)schema;
            Instant instant = this.introLocalTimestamp;
            if (instant == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"introLocalTimestamp");
                instant = null;
            }
            basicModSchema.setLastIntrospectionLocalTimestamp(instant);
        }

        private final void retrieveAllMinorNames() {
            if (this.getAffectedSchemas().isEmpty()) {
                return;
            }
            for (List bunch : CollectionFun.splitIntoChunksOf(CollectionsKt.toList((Iterable)this.getAffectedSchemas()), 10)) {
                this.retrieveMinorNamesForSchemaBunch(bunch);
            }
        }

        private final void retrieveMinorNamesForSchemaBunch(List<? extends S> schemas) {
            this.inDatabase(arg_0 -> MysqlDatabaseSchemasRetriever.retrieveMinorNamesForSchemaBunch$lambda$9(schemas, MysqlBaseIntrospector.this, this, arg_0));
        }

        private final void applyBriefInfo(MysqlBaseLikeColumn $this$applyBriefInfo, MysqlBaseIntroQueries.OneMinorName m) {
            $this$applyBriefInfo.setPosition(m.position);
        }

        private final void applyBriefInfo(MysqlBaseArgument $this$applyBriefInfo, MysqlBaseIntroQueries.OneMinorName m) {
            ArgumentDirection argumentDirection;
            $this$applyBriefInfo.setPosition(m.position);
            if (m.position == 0) {
                argumentDirection = ArgumentDirection.RETURN;
            } else {
                argumentDirection = ArgumentDirection.of(m.direction);
                if (argumentDirection == null) {
                    argumentDirection = ArgumentDirection.IN;
                }
            }
            $this$applyBriefInfo.setArgumentDirection(argumentDirection);
        }

        private static final Unit retrieveMajorNamesForSchemaBunch$lambda$3$lambda$2(Ref.ObjectRef $schema, List $schemas, MysqlDatabaseSchemasRetriever this$0, MysqlBaseIntroQueries.OneMajorName m) {
            BasicModMultiLevelObject obj2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            if (!Intrinsics.areEqual((Object)((MysqlBaseSchema)$schema.element).getName(), (Object)m.schema_name)) {
                Object v0;
                block10: {
                    Iterable iterable = $schemas;
                    Ref.ObjectRef objectRef = $schema;
                    object = iterable;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        MysqlBaseSchema it = (MysqlBaseSchema)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)m.schema_name)) continue;
                        v0 = t;
                        break block10;
                    }
                    v0 = null;
                }
                MysqlBaseSchema mysqlBaseSchema = v0;
                if (mysqlBaseSchema == null) {
                    return Unit.INSTANCE;
                }
                objectRef.element = mysqlBaseSchema;
            }
            ((Collection)this$0.getAffectedSchemas()).add($schema.element);
            BasicModMultiLevelObject basicModMultiLevelObject = obj2 = (switch (m.major_kind) {
                case 'T' -> ((MysqlBaseSchema)$schema.element).getTables().createOrGet(m.major_name);
                case 'V' -> ((MysqlBaseSchema)$schema.element).getViews().createOrGet(m.major_name);
                case 'R' -> {
                    object = ((MysqlBaseSchema)$schema.element).getRoutines().createOrGet(m.major_name);
                    MysqlBaseRoutine $this$retrieveMajorNamesForSchemaBunch_u24lambda_u243_u24lambda_u242_u24lambda_u241 = (MysqlBaseRoutine)object;
                    boolean $i$a$-apply-MysqlBaseIntrospector$MysqlDatabaseSchemasRetriever$retrieveMajorNamesForSchemaBunch$1$1$obj$1 = false;
                    $this$retrieveMajorNamesForSchemaBunch_u24lambda_u243_u24lambda_u242_u24lambda_u241.setRoutineKind(DasRoutine.Kind.byChar(m.routine_kind));
                    yield (BasicModMultiLevelObject)object;
                }
                case 'E' -> ((MysqlBaseSchema)$schema.element).getEvents().createOrGet(m.major_name);
                default -> null;
            });
            if (basicModMultiLevelObject != null) {
                basicModMultiLevelObject.setDetailsLevel(Level.L1);
            }
            this$0.hasRoutines = this$0.hasRoutines || m.major_kind == 'R';
            return Unit.INSTANCE;
        }

        private static final Unit retrieveMajorNamesForSchemaBunch$lambda$3(List $schemas, MysqlDatabaseSchemasRetriever this$0, MysqlBaseIntrospector this$1, MysqlBaseRoot it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            for (MysqlBaseSchema schema : $schemas) {
                this$0.finalizeLevel1(schema);
                schema.getTables().markChildrenAsSyncPending();
                schema.getViews().markChildrenAsSyncPending();
                schema.getRoutines().markChildrenAsSyncPending();
                schema.getEvents().markChildrenAsSyncPending();
            }
            Ref.ObjectRef schema = new Ref.ObjectRef();
            schema.element = CollectionsKt.first((List)$schemas);
            this$1.getQueries().retrieveAllMajorNames(this$0.getTransaction(), ModelFun.namesArray($schemas), (Function1<? super MysqlBaseIntroQueries.OneMajorName, Unit>)((Function1)arg_0 -> MysqlDatabaseSchemasRetriever.retrieveMajorNamesForSchemaBunch$lambda$3$lambda$2(schema, $schemas, this$0, arg_0)));
            for (MysqlBaseSchema schema2 : $schemas) {
                schema2.getEvents().removeSyncPendingChildren();
                schema2.getRoutines().removeSyncPendingChildren();
                schema2.getViews().removeSyncPendingChildren();
                schema2.getTables().removeSyncPendingChildren();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveMinorNamesForSchemaBunch$lambda$9$lambda$8(Ref.ObjectRef $schema, List $schemas, Ref.ObjectRef $major, MysqlDatabaseSchemasRetriever this$0, MysqlBaseIntroQueries.OneMinorName m) {
            BasicMajorObject basicMajorObject;
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            if (!Intrinsics.areEqual((Object)((MysqlBaseSchema)$schema.element).getName(), (Object)m.schema_name)) {
                Object v0;
                block12: {
                    Iterable iterable = $schemas;
                    Ref.ObjectRef objectRef = $schema;
                    Iterable iterable2 = iterable;
                    for (Object t : iterable2) {
                        MysqlBaseSchema it = (MysqlBaseSchema)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)m.schema_name)) continue;
                        v0 = t;
                        break block12;
                    }
                    v0 = null;
                }
                MysqlBaseSchema mysqlBaseSchema = v0;
                if (mysqlBaseSchema == null) {
                    return Unit.INSTANCE;
                }
                objectRef.element = mysqlBaseSchema;
                $major.element = null;
            }
            if ($major.element == null || !Intrinsics.areEqual((Object)((BasicMajorObject)$major.element).getName(), (Object)m.major_name)) {
                switch (m.major_kind) {
                    case 'T': {
                        Object object = (BasicMajorObject)((MysqlBaseSchema)$schema.element).getTables().get(m.major_name);
                        break;
                    }
                    case 'V': {
                        Object object = (BasicMajorObject)((MysqlBaseSchema)$schema.element).getViews().get(m.major_name);
                        break;
                    }
                    case 'R': {
                        Object object = (BasicMajorObject)((MysqlBaseSchema)$schema.element).getRoutines().get(m.major_name);
                        break;
                    }
                    default: {
                        Object object = $major.element = null;
                    }
                }
            }
            if ((basicMajorObject = (BasicMajorObject)$major.element) instanceof MysqlBaseLikeTable) {
                Object e = ((MysqlBaseLikeTable)$major.element).getColumns().createOrGet(m.minor_name);
                Intrinsics.checkNotNullExpressionValue(e, (String)"createOrGet(...)");
                this$0.applyBriefInfo((MysqlBaseLikeColumn)e, m);
            } else if (basicMajorObject instanceof MysqlBaseRoutine) {
                Object e = ((MysqlBaseRoutine)$major.element).getArguments().createOrGet(m.minor_name);
                Intrinsics.checkNotNullExpressionValue(e, (String)"createOrGet(...)");
                this$0.applyBriefInfo((MysqlBaseArgument)e, m);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveMinorNamesForSchemaBunch$lambda$9(List $schemas, MysqlBaseIntrospector this$0, MysqlDatabaseSchemasRetriever this$1, MysqlBaseRoot it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            for (MysqlBaseSchema schema : $schemas) {
                ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                Iterable $this$forEach$iv = modNamingFamily;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MysqlBaseTable table = (MysqlBaseTable)element$iv;
                    boolean bl = false;
                    table.getColumns().markChildrenAsSyncPending();
                }
                ModNamingFamily<? extends MysqlBaseView> modNamingFamily2 = schema.getViews();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getViews(...)");
                $this$forEach$iv = modNamingFamily2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MysqlBaseView view = (MysqlBaseView)element$iv;
                    boolean bl = false;
                    view.getColumns().markChildrenAsSyncPending();
                }
                ModNamingFamily<? extends MysqlBaseRoutine> modNamingFamily3 = schema.getRoutines();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getRoutines(...)");
                $this$forEach$iv = modNamingFamily3;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MysqlBaseRoutine routine2 = (MysqlBaseRoutine)element$iv;
                    boolean bl = false;
                    routine2.getArguments().markChildrenAsSyncPending();
                }
            }
            Ref.ObjectRef schema = new Ref.ObjectRef();
            schema.element = CollectionsKt.first((List)$schemas);
            Ref.ObjectRef major = new Ref.ObjectRef();
            this$0.getQueries().retrieveAllMinorNames(this$1.getTransaction(), ModelFun.namesArray($schemas), this$0.dbms, this$0.getServerVersion(), this$1.hasRoutines, (Function1<? super MysqlBaseIntroQueries.OneMinorName, Unit>)((Function1)arg_0 -> MysqlDatabaseSchemasRetriever.retrieveMinorNamesForSchemaBunch$lambda$9$lambda$8(schema, $schemas, major, this$1, arg_0)));
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$processInner(MysqlDatabaseSchemasRetriever $this) {
            $this.processInner();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\b\u0084\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u0018\u0012\u0004\u0012\u0002H\u00010\u0003R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0015H\u0014R\"\u0010\t\u001a\u0016\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlNativeRetriever;", "R", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseNativeRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "<init>", "(Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "nativeDefinitionColumnNumber", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "", "retrieveNativeDefinitionsFor", "", "kind", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "result", "", "", "", "intellij.database.dialects.mysqlbase"})
    @SourceDebugExtension(value={"SMAP\nMysqlBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlBaseIntrospector.kt\ncom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlNativeRetriever\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1600:1\n1#2:1601\n*E\n"})
    protected final class MysqlNativeRetriever<R extends MysqlBaseRoot>
    extends BaseSingleDatabaseIntrospector.BaseNativeRetriever<R> {
        @NotNull
        private final Map<ObjectKind, Integer> nativeDefinitionColumnNumber;

        public MysqlNativeRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(transaction);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ObjectKind.USER, (Object)1), TuplesKt.to((Object)ObjectKind.SCHEMA, (Object)2), TuplesKt.to((Object)ObjectKind.TABLE, (Object)2), TuplesKt.to((Object)ObjectKind.VIEW, (Object)2), TuplesKt.to((Object)ObjectKind.TRIGGER, (Object)3), TuplesKt.to((Object)ObjectKind.ROUTINE, (Object)3), TuplesKt.to((Object)ObjectKind.SCHEDULED_EVENT, (Object)4)};
            this.nativeDefinitionColumnNumber = MapsKt.mapOf((Pair[])pairArray);
        }

        @Override
        protected void retrieveNativeDefinitionsFor(@NotNull ObjectKind kind, @NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            Integer n = this.nativeDefinitionColumnNumber.get(kind);
            if (n == null) {
                return;
            }
            int k = n;
            for (BasicElement basicElement : elements) {
                String string;
                Object object;
                block17: {
                    block16: {
                        object = basicElement.getSchema();
                        if (object == null || (object = object.getRealName()) == null) break block16;
                        Object it = object;
                        boolean bl = false;
                        String string2 = "`" + (String)it + "`.";
                        object = string2;
                        if (string2 != null) break block17;
                    }
                    object = "";
                }
                Object q = object;
                String n2 = "`" + basicElement.getName() + "`";
                BasicElement basicElement2 = basicElement;
                if (basicElement2 instanceof MysqlBaseUser) {
                    String string3 = ((MysqlBaseUser)basicElement).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    String string4 = MysqlBaseIntrospectorKt.access$getSqlString(string3);
                    String string5 = ((MysqlBaseUser)basicElement).getHost();
                    if (string5 == null) {
                        string5 = "%";
                    }
                    string = "show create user " + string4 + "@" + MysqlBaseIntrospectorKt.access$getSqlString(string5);
                } else if (basicElement2 instanceof MysqlBaseTable) {
                    string = "show create table " + (String)q + n2;
                } else if (basicElement2 instanceof MysqlBaseView) {
                    string = "show create view " + (String)q + n2;
                } else if (basicElement2 instanceof MysqlBaseTrigger) {
                    string = "show create trigger " + (String)q + n2;
                } else if (basicElement2 instanceof MysqlBaseEvent) {
                    string = "show create event " + (String)q + n2;
                } else {
                    if (!(basicElement2 instanceof MysqlBaseRoutine)) continue;
                    string = "show create " + StringUtil.toLowerCase((String)((MysqlBaseRoutine)basicElement).getRoutineKind().name()) + " " + (String)q + n2;
                }
                String query = string;
                IntrospectionQueryContext introspectionQueryContext = this;
                DBTransaction dBTransaction = this.getTransaction();
                ResultLayout resultLayout = Layouts.rowOf((RowLayout)Layouts.arrayOf((int)k, String.class));
                Intrinsics.checkNotNullExpressionValue((Object)resultLayout, (String)"rowOf(...)");
                Map<BasicElement, String[]> map = IntrospectionQueryContext.runQuery$default(introspectionQueryContext, dBTransaction, query, resultLayout, null, 4, null);
                Intrinsics.checkNotNull((Object)map);
                String[] respond = (String[])map;
                if (respond.length < k) continue;
                map = result2;
                BasicElement basicElement22 = basicElement;
                String[] stringArray = new String[]{respond[k - 1]};
                map.put(basicElement22, stringArray);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u0013\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0015\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J#\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u001bH\u0014J\b\u0010\"\u001a\u00020\u001bH\u0014J\b\u0010#\u001a\u00020\u001bH\u0002J\b\u0010$\u001a\u00020\u001bH\u0014J\b\u0010%\u001a\u00020\u001bH\u0002J\u0015\u0010&\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00028\u0002H\u0002\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010'J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J \u0010,\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0014J\u0016\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010/\u001a\u00020\u0015H\u0002J\u0010\u00104\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u001e\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020602H\u0002J\f\u0010=\u001a\u00020\u0015*\u000206H\u0002J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u0015H\u0002J\u0010\u0010A\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J$\u0010B\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020\u00022\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020F0EH\u0002J$\u0010G\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020\u00022\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020I0EH\u0002J\u0018\u0010J\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020I2\u0006\u0010L\u001a\u00020MH\u0014J\u0012\u0010N\u001a\u0004\u0018\u00010\u00022\u0006\u0010O\u001a\u00020\u0015H\u0002J\f\u0010P\u001a\u00020\u0015*\u00020\u0015H\u0002J\u0010\u0010Q\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u001e\u0010R\u001a\u00020\u001b2\u0006\u0010S\u001a\u00020F2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020U02H\u0002J\u001f\u0010V\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\b\u0010W\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010XJ\u0010\u0010Y\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010Z\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010[\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\b\u0010\\\u001a\u00020\u001bH\u0002J\u0018\u0010\\\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\f2\u0006\u0010]\u001a\u00020^H\u0014J\u0010\u0010_\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\fH\u0014J\b\u0010_\u001a\u00020\u0018H\u0014J\u0018\u0010`\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\f2\u0006\u0010]\u001a\u00020^H\u0002J\u0010\u0010a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010b\u001a\u00020c2\u0006\u0010-\u001a\u00020.2\u0006\u0010d\u001a\u00020eH\u0014J\u0014\u0010f\u001a\u0004\u0018\u00010\u00152\b\u0010g\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010h\u001a\u00020i2\b\u0010g\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010j\u001a\u00020\u00182\u0006\u0010d\u001a\u00020eH\u0002J\u001a\u0010k\u001a\u0004\u0018\u00010\u00152\u0006\u0010l\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0002J\u0010\u0010m\u001a\u00020\u00152\u0006\u0010n\u001a\u00020\u0015H\u0002J\f\u0010o\u001a\u00020\u0015*\u00020\u0015H\u0002J\u0010\u0010p\u001a\u00020\u00152\u0006\u0010q\u001a\u00020\u0015H\u0002J\u0010\u0010r\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010s\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u001a\u0010t\u001a\u00020\u001b2\u0006\u0010u\u001a\u00020\u00102\b\u0010v\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010w\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010x\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010y\u001a\u00020\u001b2\u0006\u0010u\u001a\u00020\u0010H\u0002J\u0010\u0010z\u001a\u00020\u001b2\u0006\u0010{\u001a\u00020|H\u0002J$\u0010r\u001a\u0004\u0018\u00010}2\u0006\u0010~\u001a\u00020\u00022\u0007\u0010\u007f\u001a\u00030\u0080\u00012\u0007\u0010\u0081\u0001\u001a\u00020\u0015H\u0002J\u0012\u0010\u0082\u0001\u001a\u00020\u001b2\u0007\u0010\u0083\u0001\u001a\u00020\u0012H\u0002J\u001c\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u00152\u0006\u0010v\u001a\u00020\u00152\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0002J\u001c\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u00152\u0006\u0010v\u001a\u00020\u00152\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0002J\u001c\u0010\u0086\u0001\u001a\u0004\u0018\u00010^2\u0006\u0010v\u001a\u00020\u00152\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0002J\u0011\u0010\u0087\u0001\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\"\u0010\u0088\u0001\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u00022\u000f\u0010\u0089\u0001\u001a\n\u0012\u0005\u0012\u00030\u008b\u00010\u008a\u0001H\u0002J\"\u0010\u008c\u0001\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u00022\u000f\u0010\u0089\u0001\u001a\n\u0012\u0005\u0012\u00030\u008b\u00010\u008a\u0001H\u0002J\u0011\u0010\u008d\u0001\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0015\u0010\u008e\u0001\u001a\u00030\u008f\u00012\t\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u0015H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u0004\u0018\u00010\u0015*\u0002068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006\u0091\u0001"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlSchemaRetriever;", "S", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractMultiLevelSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;)V", "touchedTables", "Ljava/util/HashSet;", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseTable;", "touchedViews", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseView;", "touchedRoutines", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoutine;", "touchedEvents", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseEvent;", "getFragmentNamesOrNull", "", "", "()[Ljava/lang/String;", "isPossibleToIntrospectSchemaIncrementally", "", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;)Z", "process", "", "retrieveNamedFragments", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "fragmentNames", "(Lcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "retrieveMainContent", "processLevel2Imp", "finalizeLevel2", "processLevel3Imp", "finalizeLevel3", "retrieveGrants", "(Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;)V", "retrieveTableDetails", "retrieveTables", "retrievePartitions", "fixTableGrants", "applyTable", "table", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseLikeTable;", "t", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Table;", "parseCreateOptions", "", "Lcom/intellij/database/model/NameValue;", "retrieveIndices", "cleanedUpExpression", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$IndexColumn;", "getCleanedUpExpression", "(Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$IndexColumn;)Ljava/lang/String;", "setUpIdx", "index", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseIndex;", "idxCols", "colName", "asCascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "s", "retrieveTableConstraints", "retrieveForeignKeyDetails", "conSchema", "fks", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseForeignKey;", "retrieveCheckDetails", "chks", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseCheck;", "applyCheck", "check", "ck", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$CheckConstraint;", "getSchema", "conSc", "cleanupCheckPredicate", "retrieveTableConstraintColumns", "setUpConstraint", "con", "cols", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$ConstraintColumn;", "splitColNames", "cn", "(Ljava/lang/String;)[Ljava/lang/String;", "retrieveRoutines", "retrieveRoutineParameters", "retrieveRoutineParametersFromInformationSchema", "retrieveInfoFromTableSrc", "sql", "Lcom/intellij/sql/psi/SqlCreateStatement;", "shouldRetrieveTableSrc", "retrieveColumnGenExprFromTableSrc", "retrieveColumns", "applyColumn", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseLikeColumn;", "c", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Column;", "getOnUpdate", "extra", "getColumnKind", "Lcom/intellij/database/model/properties/ColumnKind;", "isAutoIncrement", "getDefaultExpression", "column", "trimLeadingZeroes", "def", "replaceBin", "unescape", "str", "retrieveViewSources", "retrieveRoutineSources", "retrieveRoutineParametersFromSource", "routine", "src", "retrieveTriggerSources", "retrieveEventSources", "retrieveBuggedRoutineSources", "retrieveBuggedTriggerSources", "trigger", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseTrigger;", "Lcom/intellij/database/model/properties/CompositeText;", "sc", "p", "Lcom/intellij/database/util/ObjectPath;", "name", "retrieveBuggedEventSources", "event", "getViewBody", "getBody", "getCreate", "retrieveTriggers", "retrieveRoutineGrants", "newGrants", "", "Lcom/intellij/database/dialects/mysqlbase/model/properties/MysqlObjectGrant;", "retrieveColumnGrants", "retrieveEvents", "getEventStatus", "Lcom/intellij/database/dialects/mysqlbase/model/properties/MysqlEventStatus;", "status", "intellij.database.dialects.mysqlbase"})
    @SourceDebugExtension(value={"SMAP\nMysqlBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlBaseIntrospector.kt\ncom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlSchemaRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 5 ElementCache.kt\ncom/intellij/database/model/ElementChecker\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 ElementCache.kt\ncom/intellij/database/model/ElementDataCollector\n+ 8 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 9 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 10 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 11 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 12 IntrospectorSqlHelper.kt\ncom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper\n+ 13 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 14 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,1600:1\n355#2:1601\n358#2,6:1604\n301#2,2:1610\n198#2,5:1612\n204#2,5:1636\n303#2,16:1641\n320#2,7:1675\n355#2:1682\n358#2:1685\n359#2,5:1705\n336#2,4:1778\n340#2:1786\n198#2,5:1787\n204#2,5:1813\n341#2:1818\n301#2,2:1832\n198#2,5:1834\n204#2,5:1858\n303#2,24:1863\n336#2,4:1891\n340#2:1899\n198#2,5:1900\n204#2,5:1907\n341#2:1912\n336#2,4:1951\n340#2:1959\n198#2,5:1960\n204#2,5:2003\n341#2:2008\n178#2,5:2051\n183#2,3:2059\n336#2,4:2193\n340#2:2201\n198#2,5:2202\n204#2,5:2229\n341#2:2234\n301#2,2:2273\n198#2,5:2275\n204#2,5:2299\n303#2,24:2304\n1869#3,2:1602\n1869#3,2:1683\n1563#3:1710\n1634#3,2:1711\n1636#3:1714\n1011#3,2:1715\n1563#3:1738\n1634#3,3:1739\n1563#3:1742\n1634#3,3:1743\n1761#3,3:1746\n1563#3:1774\n1634#3,3:1775\n1563#3:1819\n1634#3,3:1820\n1563#3:1823\n1634#3,3:1824\n1563#3:1887\n1634#3,3:1888\n1869#3,2:1905\n1869#3,2:2028\n1869#3,2:2030\n1878#3,3:2056\n1869#3,2:2081\n1563#3:2189\n1634#3,3:2190\n1740#3,3:2226\n669#3,11:2433\n669#3,11:2444\n519#4:1617\n500#4,2:1618\n503#4,15:1621\n500#4,18:1657\n519#4:1686\n500#4,18:1687\n519#4:1717\n500#4,2:1718\n503#4,15:1723\n519#4:1752\n500#4,2:1753\n503#4,15:1759\n519#4:1792\n500#4,2:1793\n503#4,15:1798\n1200#4:1827\n519#4:1839\n500#4,18:1840\n519#4:1913\n500#4,18:1914\n519#4:1932\n500#4,18:1933\n519#4:1965\n500#4,18:1966\n519#4:1984\n500#4,18:1985\n519#4:2009\n500#4,18:2010\n519#4:2032\n500#4,18:2033\n519#4:2062\n500#4,18:2063\n519#4:2083\n500#4,18:2084\n519#4:2102\n500#4,18:2103\n519#4:2121\n500#4,18:2122\n519#4:2140\n500#4,18:2141\n519#4:2159\n500#4,18:2160\n139#4,2:2178\n142#4,8:2181\n519#4:2207\n500#4,18:2208\n519#4:2235\n500#4,18:2236\n519#4:2254\n500#4,18:2255\n519#4:2280\n500#4,18:2281\n398#4:2328\n399#4,2:2334\n398#4:2341\n399#4,2:2347\n398#4:2354\n399#4,2:2360\n398#4:2367\n399#4,2:2373\n398#4:2380\n399#4,2:2386\n398#4:2393\n399#4,2:2399\n398#4:2406\n399#4,2:2412\n30#5:1620\n1#6:1713\n1#6:1828\n114#7,3:1720\n114#7,3:1795\n1163#8,3:1749\n216#9,2:1755\n216#9,2:1757\n37#10:1782\n36#10,3:1783\n37#10:1895\n36#10,3:1896\n37#10:1955\n36#10,3:1956\n37#10:2197\n36#10,3:2198\n13537#11,3:1829\n26#12:2180\n1084#13:2329\n1179#13,2:2330\n1085#13,2:2332\n1089#13:2336\n1184#13,2:2337\n1090#13,2:2339\n1084#13:2342\n1179#13,2:2343\n1085#13,2:2345\n1089#13:2349\n1184#13,2:2350\n1090#13,2:2352\n1084#13:2355\n1179#13,2:2356\n1085#13,2:2358\n1089#13:2362\n1184#13,2:2363\n1090#13,2:2365\n1084#13:2368\n1179#13,2:2369\n1085#13,2:2371\n1089#13:2375\n1184#13,2:2376\n1090#13,2:2378\n1084#13:2381\n1179#13,2:2382\n1085#13,2:2384\n1089#13:2388\n1184#13,2:2389\n1090#13,2:2391\n1084#13:2394\n1179#13,2:2395\n1085#13,2:2397\n1089#13:2401\n1184#13,2:2402\n1090#13,2:2404\n1084#13:2407\n1179#13,2:2408\n1085#13,2:2410\n1089#13:2414\n1184#13,2:2415\n1090#13,2:2417\n382#14,7:2419\n382#14,7:2426\n*S KotlinDebug\n*F\n+ 1 MysqlBaseIntrospector.kt\ncom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlSchemaRetriever\n*L\n736#1:1601\n736#1:1604,6\n747#1:1610,2\n747#1:1612,5\n747#1:1636,5\n747#1:1641,16\n747#1:1675,7\n768#1:1682\n768#1:1685\n768#1:1705,5\n1030#1:1778,4\n1030#1:1786\n1030#1:1787,5\n1030#1:1813,5\n1030#1:1818\n1068#1:1832,2\n1068#1:1834,5\n1068#1:1858,5\n1068#1:1863,24\n1101#1:1891,4\n1101#1:1899\n1101#1:1900,5\n1101#1:1907,5\n1101#1:1912\n1161#1:1951,4\n1161#1:1959\n1161#1:1960,5\n1161#1:2003,5\n1161#1:2008\n1331#1:2051,5\n1331#1:2059,3\n1458#1:2193,4\n1458#1:2201\n1458#1:2202,5\n1458#1:2229,5\n1458#1:2234\n1531#1:2273,2\n1531#1:2275,5\n1531#1:2299,5\n1531#1:2304,24\n736#1:1602,2\n768#1:1683,2\n815#1:1710\n815#1:1711,2\n815#1:1714\n885#1:1715,2\n918#1:1738\n918#1:1739,3\n919#1:1742\n919#1:1743,3\n919#1:1746,3\n1030#1:1774\n1030#1:1775,3\n1056#1:1819\n1056#1:1820,3\n1057#1:1823\n1057#1:1824,3\n1101#1:1887\n1101#1:1888,3\n1102#1:1905,2\n1305#1:2028,2\n1310#1:2030,2\n1333#1:2056,3\n1373#1:2081,2\n1458#1:2189\n1458#1:2190,3\n1475#1:2226,3\n997#1:2433,11\n1008#1:2444,11\n748#1:1617\n748#1:1618,2\n748#1:1621,15\n748#1:1657,18\n769#1:1686\n769#1:1687,18\n891#1:1717\n891#1:1718,2\n891#1:1723,15\n939#1:1752\n939#1:1753,2\n939#1:1759,15\n1031#1:1792\n1031#1:1793,2\n1031#1:1798,15\n1063#1:1827\n1069#1:1839\n1069#1:1840,18\n1112#1:1913\n1112#1:1914,18\n1126#1:1932\n1126#1:1933,18\n1162#1:1965\n1162#1:1966,18\n1173#1:1984\n1173#1:1985,18\n1278#1:2009\n1278#1:2010,18\n1313#1:2032\n1313#1:2033,18\n1351#1:2062\n1351#1:2063,18\n1376#1:2083\n1376#1:2084,18\n1392#1:2102\n1392#1:2103,18\n1402#1:2121\n1402#1:2122,18\n1409#1:2140\n1409#1:2141,18\n1418#1:2159\n1418#1:2160,18\n1447#1:2178,2\n1447#1:2181,8\n1459#1:2207\n1459#1:2208,18\n1483#1:2235\n1483#1:2236,18\n1495#1:2254\n1495#1:2255,18\n1533#1:2280\n1533#1:2281,18\n614#1:2328\n614#1:2334,2\n627#1:2341\n627#1:2347,2\n638#1:2354\n638#1:2360,2\n645#1:2367\n645#1:2373,2\n655#1:2380\n655#1:2386,2\n703#1:2393\n703#1:2399,2\n713#1:2406\n713#1:2412,2\n751#1:1620\n1063#1:1828\n903#1:1720,3\n1040#1:1795,3\n920#1:1749,3\n980#1:1755,2\n985#1:1757,2\n1030#1:1782\n1030#1:1783,3\n1101#1:1895\n1101#1:1896,3\n1161#1:1955\n1161#1:1956,3\n1458#1:2197\n1458#1:2198,3\n1063#1:1829,3\n1447#1:2180\n614#1:2329\n614#1:2330,2\n614#1:2332,2\n614#1:2336\n614#1:2337,2\n614#1:2339,2\n627#1:2342\n627#1:2343,2\n627#1:2345,2\n627#1:2349\n627#1:2350,2\n627#1:2352,2\n638#1:2355\n638#1:2356,2\n638#1:2358,2\n638#1:2362\n638#1:2363,2\n638#1:2365,2\n645#1:2368\n645#1:2369,2\n645#1:2371,2\n645#1:2375\n645#1:2376,2\n645#1:2378,2\n655#1:2381\n655#1:2382,2\n655#1:2384,2\n655#1:2388\n655#1:2389,2\n655#1:2391,2\n703#1:2394\n703#1:2395,2\n703#1:2397,2\n703#1:2401\n703#1:2402,2\n703#1:2404,2\n713#1:2407\n713#1:2408,2\n713#1:2410,2\n713#1:2414\n713#1:2415,2\n713#1:2417,2\n970#1:2419,7\n975#1:2426,7\n*E\n"})
    protected static class MysqlSchemaRetriever<S extends MysqlBaseSchema>
    extends BaseNativeIntrospector.AbstractMultiLevelSchemaRetriever<S> {
        @NotNull
        private final HashSet<MysqlBaseTable> touchedTables;
        @NotNull
        private final HashSet<MysqlBaseView> touchedViews;
        @NotNull
        private final HashSet<MysqlBaseRoutine> touchedRoutines;
        @NotNull
        private final HashSet<MysqlBaseEvent> touchedEvents;
        final /* synthetic */ MysqlBaseIntrospector<R, S> this$0;

        public MysqlSchemaRetriever(@NotNull DBTransaction tran, S schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, tran, (BasicModMultiLevelSchema)schema);
            this.touchedTables = new HashSet();
            this.touchedViews = new HashSet();
            this.touchedRoutines = new HashSet();
            this.touchedEvents = new HashSet();
        }

        private final String[] getFragmentNamesOrNull() {
            return this.getMode() == IntrospectionMode.FRAGMENT ? this.getFragmentNames() : null;
        }

        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull S schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return false;
        }

        @Override
        public void process() {
            this.analyzeBriefInfo();
            super.process();
        }

        @Override
        public void retrieveNamedFragments(@NotNull ObjectKind fragmentKind, @NotNull String[] fragmentNames) {
            Intrinsics.checkNotNullParameter((Object)fragmentKind, (String)"fragmentKind");
            Intrinsics.checkNotNullParameter((Object)fragmentNames, (String)"fragmentNames");
            this.setFragmentKind(fragmentKind);
            this.setFragmentNames(fragmentNames);
            ObjectKind objectKind = fragmentKind;
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                this.inSchema(arg_0 -> MysqlSchemaRetriever.retrieveNamedFragments$lambda$0(this, arg_0));
                if (this.getWithSources()) {
                    this.inSchema(arg_0 -> MysqlSchemaRetriever.retrieveNamedFragments$lambda$2(this, this.this$0, arg_0));
                }
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
                this.inSchema(arg_0 -> MysqlSchemaRetriever.retrieveNamedFragments$lambda$3(this, arg_0));
                if (this.getWithSources()) {
                    this.inSchema(arg_0 -> MysqlSchemaRetriever.retrieveNamedFragments$lambda$5(this.this$0, this, arg_0));
                }
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
                this.inSchema(arg_0 -> MysqlSchemaRetriever.retrieveNamedFragments$lambda$6(this, arg_0));
                if (this.this$0.getParametersTableExists()) {
                    this.retrieveRoutineParameters((MysqlBaseSchema)this.getSchema());
                }
                if (this.getWithSources()) {
                    this.inSchema(arg_0 -> MysqlSchemaRetriever.retrieveNamedFragments$lambda$8(this.this$0, this, arg_0));
                } else if (!this.this$0.getParametersTableExists()) {
                    this.inSchema(arg_0 -> MysqlSchemaRetriever.retrieveNamedFragments$lambda$10(this.this$0, this, arg_0));
                }
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEDULED_EVENT)) {
                this.inSchema(arg_0 -> MysqlSchemaRetriever.retrieveNamedFragments$lambda$11(this, arg_0));
                if (this.getWithSources()) {
                    this.inSchema(arg_0 -> MysqlSchemaRetriever.retrieveNamedFragments$lambda$13(this.this$0, this, arg_0));
                }
            }
        }

        @Override
        protected void retrieveMainContent() {
            Level schemaIntrospectionLevel = ModelFun.effectiveIntrospectionLevel((BasicMultiLevelSchema)this.getSchema());
            if (LevelFun.isGreaterOrEqualsTo(schemaIntrospectionLevel, Level.L2)) {
                this.processLevel2Imp();
            }
            if (LevelFun.isGreaterOrEqualsTo(schemaIntrospectionLevel, Level.L3)) {
                this.processLevel3Imp();
            }
        }

        @Override
        protected void processLevel2Imp() {
            this.inSchema(arg_0 -> MysqlSchemaRetriever.processLevel2Imp$lambda$14(this, arg_0));
            this.inSchema(arg_0 -> MysqlSchemaRetriever.processLevel2Imp$lambda$15(this, arg_0));
            this.inSchema(arg_0 -> MysqlSchemaRetriever.processLevel2Imp$lambda$16(this, arg_0));
            this.inSchema(arg_0 -> MysqlSchemaRetriever.processLevel2Imp$lambda$17(this, arg_0));
            this.inSchema(arg_0 -> MysqlSchemaRetriever.processLevel2Imp$lambda$18(this, arg_0));
            if (this.this$0.getParametersTableExists()) {
                this.inSchema(arg_0 -> MysqlSchemaRetriever.processLevel2Imp$lambda$19(this, arg_0));
            }
            this.finalizeLevel2();
        }

        private final void finalizeLevel2() {
            ((BasicModMultiLevelSchema)this.getSchema()).setLastIntrospectionLevel(Level.L2);
            this.getSchema().setLastIntrospectionLocalTimestamp(this.getIntrospectionBeginLocalTimestamp());
        }

        @Override
        protected void processLevel3Imp() {
            if (this.shouldRetrieveTableSrc()) {
                this.inSchema(arg_0 -> MysqlSchemaRetriever.processLevel3Imp$lambda$20(this, arg_0));
            }
            if (this.getWithSources()) {
                this.inSchema(arg_0 -> MysqlSchemaRetriever.processLevel3Imp$lambda$22(this.this$0, this, arg_0));
            } else if (!this.this$0.getParametersTableExists()) {
                this.inSchema(arg_0 -> MysqlSchemaRetriever.processLevel3Imp$lambda$24(this.this$0, this, arg_0));
            }
            this.finalizeLevel3();
        }

        private final void finalizeLevel3() {
            ((BasicModMultiLevelSchema)this.getSchema()).setLastIntrospectionLevel(Level.L3);
            this.getSchema().setLastIntrospectionLocalTimestamp(this.getIntrospectionBeginLocalTimestamp());
        }

        private final void retrieveGrants(S schema) {
            ArrayList newGrant = new ArrayList();
            this.retrieveRoutineGrants((MysqlBaseSchema)schema, newGrant);
            this.retrieveColumnGrants((MysqlBaseSchema)schema, newGrant);
            ((MysqlBaseGrantsHolder)schema).setGrants(((MysqlBaseGrantsHolder)schema).getGrants().with(newGrant));
        }

        protected void retrieveTableDetails(@NotNull S schema) {
            boolean bl;
            MysqlBaseTable t;
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            if (this.touchedTables.isEmpty()) {
                return;
            }
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Function1 it = MysqlSchemaRetriever$retrieveTableDetails$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
            boolean bl2 = false;
            Iterable $this$forEach$iv = this.touchedTables;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (MysqlBaseTable)element$iv;
                bl = false;
                NamingFamily namingFamily = t.getChecks();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getChecks(...)");
                it.invoke((Object)namingFamily);
                NamingFamily namingFamily2 = t.getKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily2, (String)"getKeys(...)");
                it.invoke((Object)namingFamily2);
                NamingFamily namingFamily3 = t.getForeignKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily3, (String)"getForeignKeys(...)");
                it.invoke((Object)namingFamily3);
                Family family = t.getIndices();
                Intrinsics.checkNotNullExpressionValue((Object)family, (String)"getIndices(...)");
                it.invoke((Object)family);
            }
            boolean bl3 = false;
            this.retrieveIndices((MysqlBaseSchema)schema);
            this.retrieveTableConstraints((MysqlBaseSchema)schema);
            this.retrieveTableConstraintColumns((MysqlBaseSchema)schema);
            it = MysqlSchemaRetriever$retrieveTableDetails$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
            bl2 = false;
            $this$forEach$iv = this.touchedTables;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (MysqlBaseTable)element$iv;
                bl = false;
                NamingFamily namingFamily = t.getChecks();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getChecks(...)");
                it.invoke((Object)namingFamily);
                NamingFamily namingFamily4 = t.getKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily4, (String)"getKeys(...)");
                it.invoke((Object)namingFamily4);
                NamingFamily namingFamily5 = t.getForeignKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily5, (String)"getForeignKeys(...)");
                it.invoke((Object)namingFamily5);
                Family family = t.getIndices();
                Intrinsics.checkNotNullExpressionValue((Object)family, (String)"getIndices(...)");
                it.invoke((Object)family);
            }
            this.retrievePartitions((MysqlBaseSchema)schema);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTables(MysqlBaseSchema schema) {
            void fragments$iv;
            this.this$0.reportRetrieving("tables and views", "introspection.retrieve.tablesViews");
            boolean bl = true;
            ModNamingFamily[] modNamingFamilyArray = new ModNamingFamily[2];
            Intrinsics.checkNotNullExpressionValue(schema.getTables(), (String)"getTables(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getViews(), (String)"getViews(...)");
            String[] stringArray = this.getFragmentNamesOrNull();
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            if (fragments$iv == null) {
                void families$iv$iv;
                void removeUnaffected$iv;
                ModFamily[] modFamilyArray = (ModFamily[])Arrays.copyOf(families$iv, ((void)families$iv).length);
                void removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyFamiliesAndCleanup2 = false;
                for (void f$iv$iv : families$iv$iv) {
                    f$iv$iv.markChildrenAsSyncPending();
                }
                boolean bl2 = false;
                BaseNativeIntrospector this_$iv = mysqlBaseIntrospector;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector baseNativeIntrospector = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    void this_$iv2;
                    boolean bl3 = false;
                    ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveTables$lambda$35$lambda$34$lambda$28);
                    boolean $i$f$prepare = false;
                    void $this$retrieveTables_u24lambda_u2435_u24lambda_u2434_u24lambda_u2432 = this_$iv2;
                    boolean bl4 = false;
                    ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                    ElementSearcherNN tables = $this$retrieveTables_u24lambda_u2435_u24lambda_u2434_u24lambda_u2432.inFamily((Family)modNamingFamily).orCreate(MysqlSchemaRetriever::retrieveTables$lambda$35$lambda$34$lambda$32$lambda$29);
                    ModNamingFamily<? extends MysqlBaseView> modNamingFamily2 = schema.getViews();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getViews(...)");
                    ElementSearcherNN views = $this$retrieveTables_u24lambda_u2435_u24lambda_u2434_u24lambda_u2432.inFamily((Family)modNamingFamily2).orCreate(MysqlSchemaRetriever::retrieveTables$lambda$35$lambda$34$lambda$32$lambda$30);
                    ElementSearcherNN tableSearcher = $this$retrieveTables_u24lambda_u2435_u24lambda_u2434_u24lambda_u2432.chooseNN(arg_0 -> MysqlSchemaRetriever.retrieveTables$lambda$35$lambda$34$lambda$32$lambda$31(views, tables, arg_0));
                    mysqlBaseIntrospector.getQueries().processTablesAndViews(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Table, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveTables$lambda$35$lambda$34$lambda$33(tableSearcher, this, schema, arg_0)));
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl5 = false;
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                for (void f$iv$iv : families$iv$iv) {
                    f$iv$iv.removeSyncPendingChildren();
                    f$iv$iv.sort();
                }
            } else {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])fragments$iv);
                block6: while (iterator.hasNext()) {
                    String fragment$iv = (String)iterator.next();
                    int n = ((void)families$iv).length;
                    for (int $i$f$modifyFamiliesAndCleanup2 = 0; $i$f$modifyFamiliesAndCleanup2 < n; ++$i$f$modifyFamiliesAndCleanup2) {
                        void family$iv = families$iv[$i$f$modifyFamiliesAndCleanup2];
                        BasicModNamedElement o$iv = (BasicModNamedElement)family$iv.get(fragment$iv);
                        if (o$iv == null) continue;
                        o$iv.setSyncPending(true);
                        continue block6;
                    }
                }
                boolean bl6 = false;
                BaseNativeIntrospector this_$iv = mysqlBaseIntrospector;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector this_$iv$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError3 = false;
                try {
                    boolean bl7 = false;
                    ElementChecker this_$iv2 = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveTables$lambda$35$lambda$34$lambda$28);
                    boolean $i$f$prepare = false;
                    ElementChecker $this$retrieveTables_u24lambda_u2435_u24lambda_u2434_u24lambda_u2432 = this_$iv2;
                    boolean bl8 = false;
                    ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                    ElementSearcherNN tables = $this$retrieveTables_u24lambda_u2435_u24lambda_u2434_u24lambda_u2432.inFamily((Family)modNamingFamily).orCreate(MysqlSchemaRetriever::retrieveTables$lambda$35$lambda$34$lambda$32$lambda$29);
                    ModNamingFamily<? extends MysqlBaseView> modNamingFamily3 = schema.getViews();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getViews(...)");
                    ElementSearcherNN views = $this$retrieveTables_u24lambda_u2435_u24lambda_u2434_u24lambda_u2432.inFamily((Family)modNamingFamily3).orCreate(MysqlSchemaRetriever::retrieveTables$lambda$35$lambda$34$lambda$32$lambda$30);
                    ElementSearcherNN tableSearcher = $this$retrieveTables_u24lambda_u2435_u24lambda_u2434_u24lambda_u2432.chooseNN(arg_0 -> MysqlSchemaRetriever.retrieveTables$lambda$35$lambda$34$lambda$32$lambda$31(views, tables, arg_0));
                    mysqlBaseIntrospector.getQueries().processTablesAndViews(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Table, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveTables$lambda$35$lambda$34$lambda$33(tableSearcher, this, schema, arg_0)));
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException(this_$iv$iv, e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl9 = false;
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default(this_$iv$iv, message$iv$iv, null, 2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                for (void family$iv : families$iv) {
                    family$iv.removeSyncPendingChildren();
                    family$iv.sort();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrievePartitions(MysqlBaseSchema schema) {
            Iterator iterator;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            this.this$0.reportRetrieving("partitions", "introspection.retrieve.objects.partition");
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean bl = false;
            Function1 it = MysqlSchemaRetriever$retrievePartitions$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = this.touchedTables;
            boolean $i$f$forEach232 = false;
            for (Object element$iv : $this$forEach$iv2) {
                MysqlBaseTable t = (MysqlBaseTable)element$iv;
                boolean bl22 = false;
                ModPositioningNamingFamily<? extends MysqlBasePartition> modPositioningNamingFamily = t.getPartitions();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getPartitions(...)");
                it.invoke(modPositioningNamingFamily);
                ModPositioningNamingFamily<? extends MysqlBasePartition> modPositioningNamingFamily2 = t.getPartitions();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily2, (String)"getPartitions(...)");
                $this$forEach$iv = modPositioningNamingFamily2;
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv2 = iterator.next();
                    MysqlBasePartition p2 = (MysqlBasePartition)element$iv2;
                    boolean bl3 = false;
                    ModPositioningNamingFamily<? extends MysqlBaseSubpartition> modPositioningNamingFamily3 = p2.getSubpartitions();
                    Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily3, (String)"getSubpartitions(...)");
                    it.invoke(modPositioningNamingFamily3);
                }
            }
            boolean bl4 = false;
            BaseNativeIntrospector this_$iv = mysqlBaseIntrospector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector $i$f$forEach232 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl5 = false;
                ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrievePartitions$lambda$42$lambda$41$lambda$39);
                ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                ElementCache tableCache = elementChecker.inFamily((Family)modNamingFamily).cache();
                mysqlBaseIntrospector.getQueries().processSubpartitions(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Subpartition, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrievePartitions$lambda$42$lambda$41$lambda$40(tableCache, arg_0)));
            }
            catch (DBException e$iv$iv) {
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                Iterator $this$continueOnDbError_u24lambda_u2417$iv$iv = iterator = new StringBuilder();
                boolean bl6 = false;
                ((StringBuilder)((Object)$this$continueOnDbError_u24lambda_u2417$iv$iv)).append(expected$iv$iv ? "Expected" : "Unexpected");
                ((StringBuilder)((Object)$this$continueOnDbError_u24lambda_u2417$iv$iv)).append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                ((StringBuilder)((Object)$this$continueOnDbError_u24lambda_u2417$iv$iv)).append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = ((StringBuilder)((Object)iterator)).toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            it = MysqlSchemaRetriever$retrievePartitions$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
            boolean bl3 = false;
            Iterable $this$forEach$iv3 = this.touchedTables;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                MysqlBaseTable t = (MysqlBaseTable)element$iv;
                boolean bl7 = false;
                ModPositioningNamingFamily<? extends MysqlBasePartition> modPositioningNamingFamily = t.getPartitions();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getPartitions(...)");
                it.invoke(modPositioningNamingFamily);
                ModPositioningNamingFamily<? extends MysqlBasePartition> modPositioningNamingFamily4 = t.getPartitions();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily4, (String)"getPartitions(...)");
                $this$forEach$iv = modPositioningNamingFamily4;
                $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    MysqlBasePartition p3 = (MysqlBasePartition)element$iv2;
                    boolean bl8 = false;
                    ModPositioningNamingFamily<? extends MysqlBaseSubpartition> modPositioningNamingFamily5 = p3.getSubpartitions();
                    Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily5, (String)"getSubpartitions(...)");
                    it.invoke(modPositioningNamingFamily5);
                }
            }
            for (MysqlBaseTable mysqlBaseTable : schema.getTables()) {
                if (!mysqlBaseTable.getPartitions().isEmpty()) continue;
                mysqlBaseTable.setPartitionMethod(null);
                mysqlBaseTable.setSubpartitionMethod(null);
                mysqlBaseTable.setPartitionExpression(null);
                mysqlBaseTable.setSubpartitionExpression(null);
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final void fixTableGrants(MysqlBaseSchema schema) {
            MysqlBaseIntrospector.access$reportRetrieving(this.this$0, "permissions", "introspection.retrieve.objectPermissions");
            ns = NamingServices.getNamingService$default(this.this$0.dbms, null, null, 6, null);
            lexer = MysqlBaseIntrospector.access$getSqlHelper(this.this$0).createLexer();
            v0 = ElementCacheOptimizersKt.byName(this.searchInSchema(), (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, fixTableGrants$lambda$43(com.intellij.database.dialects.mysqlbase.model.properties.MysqlObjectGrant ), (Lcom/intellij/database/dialects/mysqlbase/model/properties/MysqlObjectGrant;)Ljava/lang/String;)());
            var5_4 /* !! */  = new Family[2];
            Intrinsics.checkNotNullExpressionValue(schema.getTables(), (String)"getTables(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getViews(), (String)"getViews(...)");
            cache = v0.inFamilies(var5_4 /* !! */ ).cache();
            v1 = schema.getGrants();
            v2 = schema.getGrants();
            Intrinsics.checkNotNullExpressionValue(v2, (String)"getGrants(...)");
            var5_4 /* !! */  = v2;
            var24_6 = v1;
            var23_7 = schema;
            $i$f$map = false;
            var7_9 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                block7: {
                    var12_14 = (MysqlObjectGrant)item$iv$iv;
                    var25_25 = destination$iv$iv;
                    $i$a$-map-MysqlBaseIntrospector$MysqlSchemaRetriever$fixTableGrants$1 = false;
                    s = Intrinsics.areEqual((Object)g.getKind(), (Object)ObjectKind.NONE) == false || g.isSub() != false ? false : StringsKt.contains$default((CharSequence)g.getPermission(), (char)'(', (boolean)false, (int)2, null);
                    p = null;
                    subs = null;
                    if (s) break block7;
                    p = g.getPermission();
                    subs = null;
                    ** GOTO lbl60
                }
                lexer.start((CharSequence)g.getPermission());
                while (lexer.getTokenType() != null && !Intrinsics.areEqual((Object)lexer.getTokenType(), (Object)SqlTokens.SQL_LEFT_PAREN)) {
                    lexer.advance();
                }
                v3 = g.getPermission().substring(0, lexer.getTokenStart());
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
                p = StringsKt.trim((CharSequence)v3).toString();
                subs = new BitSet();
                Intrinsics.checkNotNull((Object)g);
                if ((MysqlBaseLikeTable)cache.find(g) == null) {
                    v4 = g;
                } else {
                    lexer.advance();
                    prev = lexer.getTokenStart();
                    while (true) {
                        if (Intrinsics.areEqual((Object)(tt = lexer.getTokenType()), (Object)SqlTokens.SQL_COLON) || Intrinsics.areEqual((Object)tt, (Object)SqlTokens.SQL_RIGHT_PAREN) || tt == null) {
                            v5 = g.getPermission().substring(prev, lexer.getTokenStart());
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"substring(...)");
                            name = ns.unquoteIdentifier(StringsKt.trim((CharSequence)v5).toString());
                            v6 = (MysqlBaseLikeColumn)table.getColumns().get(name);
                            if (v6 != null) {
                                it = ((BasicModTableOrViewColumn)v6).getPosition();
                                $i$a$-let-MysqlBaseIntrospector$MysqlSchemaRetriever$fixTableGrants$1$1 = false;
                                subs.set(it);
                            }
                            if (!Intrinsics.areEqual((Object)tt, (Object)SqlTokens.SQL_COLON)) break;
                            prev = lexer.getTokenEnd();
                        }
                        lexer.advance();
                    }
lbl60:
                    // 2 sources

                    v7 = g.getName();
                    v8 = g.getKind();
                    v9 = g.getGrantee();
                    v10 = g.getHost();
                    v11 = StringUtil.toLowerCase((String)p);
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"toLowerCase(...)");
                    v4 = new MysqlObjectGrant(v7, v8, subs, v9, v10, v11, g.getState());
                }
                var25_25.add(v4);
            }
            var25_25 = (List)destination$iv$iv;
            var23_7.setGrants(var24_6.with((Iterable<MysqlObjectGrant>)var25_25));
        }

        /*
         * WARNING - void declaration
         */
        protected void applyTable(@NotNull MysqlBaseSchema schema, @NotNull MysqlBaseLikeTable table, @NotNull MysqlBaseIntroQueries.Table t) {
            String string;
            String string2;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            String type = t.table_type;
            boolean isView = false;
            CompositeText src = null;
            boolean isSystemView = Intrinsics.areEqual((Object)type, (Object)"SYSTEM VIEW");
            if (isSystemView) {
                ObjectPath objectPath = ObjectPaths.of(schema).append(t.table_name, ObjectKind.TABLE);
                Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"append(...)");
                src = this.retrieveViewSources(schema, objectPath, t.table_name);
                boolean bl = isView = src != null;
                if (!isView) {
                    t.table_type = StringsKt.replace$default((String)t.table_type, (String)" VIEW", (String)"", (boolean)false, (int)4, null);
                }
            } else {
                src = null;
                isView = StringsKt.contains$default((CharSequence)type, (CharSequence)"VIEW", (boolean)false, (int)2, null);
            }
            MysqlBaseLikeTable mysqlBaseLikeTable = table;
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            MysqlBaseLikeTable $this$applyTable_u24lambda_u2448 = mysqlBaseLikeTable;
            boolean bl = false;
            $this$applyTable_u24lambda_u2448.setSystem(isSystemView || !StringsKt.equals((String)type, (String)"SYSTEM VERSIONED", (boolean)true) && StringUtil.containsIgnoreCase((String)type, (String)"SYSTEM"));
            MysqlBaseLikeTable mysqlBaseLikeTable2 = $this$applyTable_u24lambda_u2448;
            String string3 = StringKt.nullize$default((String)t.table_comment, (boolean)false, (int)1, null);
            if (string3 != null) {
                void it;
                String string4;
                string2 = string4 = string3;
                MysqlBaseLikeTable mysqlBaseLikeTable3 = mysqlBaseLikeTable2;
                boolean bl2 = false;
                mysqlBaseLikeTable2 = mysqlBaseLikeTable3;
                string = Boolean.valueOf(!isView || !Intrinsics.areEqual((Object)it, (Object)"VIEW")).booleanValue() ? string4 : null;
            } else {
                string = null;
            }
            mysqlBaseLikeTable2.setComment(string);
            if ($this$applyTable_u24lambda_u2448 instanceof MysqlBaseTable) {
                String string5 = t.engine;
                if (string5 == null) {
                    String it = string2 = "memory";
                    boolean bl3 = false;
                    string5 = isSystemView ? string2 : null;
                }
                String engine2 = string5;
                String string6 = engine2;
                ((MysqlBaseTable)$this$applyTable_u24lambda_u2448).setEngine(string6 != null ? mysqlBaseIntrospector.dbIntern(string6) : null);
                ((MysqlBaseTable)$this$applyTable_u24lambda_u2448).setCollationRef(BasicNameReference.create(t.table_collation));
                ((MysqlBaseTable)$this$applyTable_u24lambda_u2448).setOptions(this.parseCreateOptions(t.create_options));
                this.touchedTables.add((MysqlBaseTable)$this$applyTable_u24lambda_u2448);
            }
            if ($this$applyTable_u24lambda_u2448 instanceof MysqlBaseView) {
                String string7 = t.view_definer;
                ((MysqlBaseView)$this$applyTable_u24lambda_u2448).setDefiner(string7 != null ? mysqlBaseIntrospector.dbIntern(string7) : null);
                if (isSystemView) {
                    ((MysqlBaseView)$this$applyTable_u24lambda_u2448).setSourceText(src);
                }
                this.touchedViews.add((MysqlBaseView)$this$applyTable_u24lambda_u2448);
            }
        }

        private final List<NameValue> parseCreateOptions(String t) {
            Object object = new char[]{' '};
            char[] $this$parseCreateOptions_u24lambda_u2452 = object = (Object)SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)StringsKt.splitToSequence$default((CharSequence)t, (char[])object, (boolean)false, (int)0, (int)6, null), MysqlSchemaRetriever::parseCreateOptions$lambda$49), MysqlSchemaRetriever::parseCreateOptions$lambda$50));
            boolean bl = false;
            char[] $this$sortBy$iv = $this$parseCreateOptions_u24lambda_u2452;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        NameValue it = (NameValue)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (NameValue)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                });
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveIndices(MysqlBaseSchema schema) {
            void this_$iv;
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            this.this$0.reportRetrieving(objectKind);
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var5_5 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                void this_$iv2;
                boolean bl = false;
                ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveIndices$lambda$62$lambda$53);
                ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                ParentFamilySearcher idxSearcher = elementChecker.inFamily((Family)modNamingFamily).searchChild(MysqlSchemaRetriever::retrieveIndices$lambda$62$lambda$56, (arg_0, arg_1) -> MysqlSchemaRetriever.retrieveIndices$lambda$62$lambda$58(mysqlBaseIntrospector, arg_0, arg_1));
                ElementDataCollector elementDataCollector = idxSearcher.collector((arg_0, arg_1) -> MysqlSchemaRetriever.retrieveIndices$lambda$62$lambda$59(this, arg_0, arg_1));
                boolean $i$f$collectAll = false;
                void $this$retrieveIndices_u24lambda_u2462_u24lambda_u2461 = this_$iv2;
                boolean bl2 = false;
                mysqlBaseIntrospector.getQueries().processIndices(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.IndexColumn, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveIndices$lambda$62$lambda$61$lambda$60((ElementDataCollector)$this$retrieveIndices_u24lambda_u2462_u24lambda_u2461, arg_0)));
                this_$iv2.finish();
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        private final String getCleanedUpExpression(MysqlBaseIntroQueries.IndexColumn $this$cleanedUpExpression) {
            String string;
            String string2 = $this$cleanedUpExpression.expression;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                string = "(" + StringUtil.unescapeChar((String)it, (char)'\'') + ")";
            } else {
                string = null;
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final void setUpIdx(MysqlBaseIndex index, List<MysqlBaseIntroQueries.IndexColumn> idxCols) {
            void destination$iv;
            void $this$mapTo$iv;
            List list;
            Collection collection;
            void $this$mapTo$iv$iv;
            Sequence $this$map$iv;
            MysqlBaseIndex mysqlBaseIndex;
            MysqlBaseIndex $this$setUpIdx_u24lambda_u2470 = mysqlBaseIndex = index;
            boolean bl = false;
            MysqlBaseIntroQueries.IndexColumn idx = (MysqlBaseIntroQueries.IndexColumn)CollectionsKt.first(idxCols);
            $this$setUpIdx_u24lambda_u2470.setUnique(!idx.non_unique);
            Iterable iterable = idxCols;
            MysqlBaseIndex mysqlBaseIndex2 = $this$setUpIdx_u24lambda_u2470;
            boolean $i$f$map2 = false;
            void var10_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MysqlBaseIntroQueries.IndexColumn indexColumn = (MysqlBaseIntroQueries.IndexColumn)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.colName((MysqlBaseIntroQueries.IndexColumn)it));
            }
            mysqlBaseIndex2.setColNames((List)destination$iv$iv);
            MysqlBaseIndex mysqlBaseIndex3 = $this$setUpIdx_u24lambda_u2470;
            if (Intrinsics.areEqual((Object)idx.index_type, (Object)"SPATIAL")) {
                list = CollectionsKt.emptyList();
            } else {
                boolean bl3;
                List $this$map$iv2;
                block9: {
                    void it;
                    void $this$mapTo$iv$iv2;
                    Iterable $i$f$map2 = idxCols;
                    mysqlBaseIndex2 = mysqlBaseIndex3;
                    boolean $i$f$map222 = false;
                    destination$iv$iv = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it2;
                        MysqlBaseIntroQueries.IndexColumn bl2 = (MysqlBaseIntroQueries.IndexColumn)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl4 = false;
                        Integer n = it2.sub_part;
                        collection.add(n != null ? n : -1);
                    }
                    List $i$f$map222 = $this$map$iv2 = (List)destination$iv$iv2;
                    boolean bl5 = false;
                    Iterable $this$any$iv = (Iterable)it;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            int e = ((Number)element$iv).intValue();
                            boolean bl6 = false;
                            if (!(e != -1)) continue;
                            bl3 = true;
                            break block9;
                        }
                        bl3 = false;
                    }
                }
                mysqlBaseIndex3 = mysqlBaseIndex2;
                list = Boolean.valueOf(bl3) != false ? $this$map$iv2 : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
            }
            mysqlBaseIndex3.setPrefixLengths(list);
            $this$map$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)idxCols), MysqlSchemaRetriever::setUpIdx$lambda$70$lambda$68);
            Collection $this$map$iv2 = new LinkedHashSet();
            mysqlBaseIndex2 = $this$setUpIdx_u24lambda_u2470;
            boolean $i$f$mapTo3 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                MysqlBaseIntroQueries.IndexColumn $i$f$any = (MysqlBaseIntroQueries.IndexColumn)item$iv;
                collection = destination$iv;
                boolean bl7 = false;
                collection.add(this.colName((MysqlBaseIntroQueries.IndexColumn)it));
            }
            mysqlBaseIndex2.setReverseColNames((Set)destination$iv);
            $this$setUpIdx_u24lambda_u2470.setComment(idx.index_comment);
        }

        private final String colName(MysqlBaseIntroQueries.IndexColumn $this$colName) {
            String string = $this$colName.column_name;
            if (string == null) {
                char c2 = '\u001b';
                String string2 = this.getCleanedUpExpression($this$colName);
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string2;
                string = c2 + string3;
            }
            return string;
        }

        /*
         * Unable to fully structure code
         */
        private final CascadeRule asCascadeRule(String s) {
            block8: {
                block6: {
                    block7: {
                        var2_2 = StringUtil.toLowerCase((String)s);
                        if (var2_2 == null) break block6;
                        switch (var2_2.hashCode()) {
                            case 1357211269: {
                                if (!var2_2.equals("set null")) {
                                    ** break;
                                }
                                break block7;
                            }
                            case -890131325: {
                                if (var2_2.equals("set default")) break;
                                ** break;
                            }
                            case 554829492: {
                                if (!var2_2.equals("cascade")) ** break;
                                v0 = CascadeRule.cascade;
                                break block8;
                            }
                        }
                        v0 = CascadeRule.set_default;
                        break block8;
                    }
                    v0 = CascadeRule.set_null;
                    break block8;
                }
                v0 = CascadeRule.no_action;
            }
            return v0;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTableConstraints(MysqlBaseSchema schema) {
            void this_$iv;
            this.this$0.reportRetrieving("constraints", "introspection.retrieve.constraints");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var5_5 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                MysqlBaseSchema it;
                String conSc;
                Map.Entry entry;
                Map.Entry element$iv;
                boolean bl = false;
                LinkedHashMap fkMap = new LinkedHashMap();
                LinkedHashMap ckMap = new LinkedHashMap();
                ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveTableConstraints$lambda$87$lambda$71);
                ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                ParentFamilySearcher conSearcher = elementChecker.inFamily((Family)modNamingFamily).searchChild(MysqlSchemaRetriever::retrieveTableConstraints$lambda$87$lambda$73, MysqlSchemaRetriever::retrieveTableConstraints$lambda$87$lambda$78);
                mysqlBaseIntrospector.getQueries().processConstraints(this.getTransaction(), schema, mysqlBaseIntrospector.getHasChecks(), this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Constraint, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveTableConstraints$lambda$87$lambda$82(conSearcher, fkMap, ckMap, arg_0)));
                Map $this$forEach$iv = fkMap;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    conSc = (String)entry.getKey();
                    MultiMap fks = (MultiMap)entry.getValue();
                    if (this.getSchema(conSc) == null) continue;
                    boolean bl3 = false;
                    this.retrieveForeignKeyDetails(it, (MultiMap<String, MysqlBaseForeignKey>)fks);
                }
                $this$forEach$iv = ckMap;
                $i$f$forEach = false;
                iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = element$iv = iterator.next();
                    boolean bl4 = false;
                    conSc = (String)entry.getKey();
                    MultiMap chks = (MultiMap)entry.getValue();
                    if (this.getSchema(conSc) == null) continue;
                    boolean bl5 = false;
                    this.retrieveCheckDetails(it, (MultiMap<String, MysqlBaseCheck>)chks);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        private final void retrieveForeignKeyDetails(MysqlBaseSchema conSchema, MultiMap<String, MysqlBaseForeignKey> fks) {
            Set set;
            String[] tableNames = this.getFragmentNamesOrNull();
            Set it = set = fks.keySet();
            boolean bl = false;
            Set fkNames = this.getMode() == IntrospectionMode.FRAGMENT ? set : null;
            this.this$0.getQueries().processForeignKeys(this.getTransaction(), conSchema, tableNames, fkNames, (Function1<? super MysqlBaseIntroQueries.ForeignKey, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveForeignKeyDetails$lambda$91(fks, this, arg_0)));
        }

        private final void retrieveCheckDetails(MysqlBaseSchema conSchema, MultiMap<String, MysqlBaseCheck> chks) {
            Set set;
            String[] tableNames = this.getFragmentNamesOrNull();
            Set it = set = chks.keySet();
            boolean bl = false;
            Set checkNames = this.getMode() == IntrospectionMode.FRAGMENT ? set : null;
            this.this$0.getQueries().processCheckConstraints(this.getTransaction(), conSchema, tableNames, checkNames, (Function1<? super MysqlBaseIntroQueries.CheckConstraint, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveCheckDetails$lambda$95(chks, this, arg_0)));
        }

        protected void applyCheck(@NotNull MysqlBaseCheck check, @NotNull MysqlBaseIntroQueries.CheckConstraint ck) {
            Intrinsics.checkNotNullParameter((Object)check, (String)"check");
            Intrinsics.checkNotNullParameter((Object)ck, (String)"ck");
            String string = ck.check_clause;
            check.setPredicate(string != null ? this.cleanupCheckPredicate(string) : null);
        }

        private final MysqlBaseSchema getSchema(String conSc) {
            Object s = this.getSchema();
            MysqlBaseSchema it = (MysqlBaseSchema)s;
            boolean bl = false;
            MysqlBaseSchema mysqlBaseSchema = (MysqlBaseSchema)(Intrinsics.areEqual((Object)it.getName(), (Object)conSc) ? s : null);
            if (mysqlBaseSchema == null) {
                Family family = ((MysqlBaseSchema)this.getSchema()).getParentFamily();
                mysqlBaseSchema = family != null ? (MysqlBaseSchema)family.get(conSc) : null;
            }
            return mysqlBaseSchema;
        }

        private final String cleanupCheckPredicate(String $this$cleanupCheckPredicate) {
            if (!(this.this$0.dbms.in(Dbms.MYSQL.getHSet()) && StringsKt.startsWith$default((CharSequence)$this$cleanupCheckPredicate, (char)'(', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)$this$cleanupCheckPredicate, (char)')', (boolean)false, (int)2, null))) {
                return $this$cleanupCheckPredicate;
            }
            String string = $this$cleanupCheckPredicate.substring(1, StringsKt.getLastIndex((CharSequence)$this$cleanupCheckPredicate));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTableConstraintColumns(MysqlBaseSchema schema) {
            void families$iv$iv;
            void families$iv;
            void $this$mapTo$iv$iv;
            this.this$0.reportRetrieving("constraint columns", "introspection.retrieve.constraintColumns");
            Iterable $this$map$iv = this.touchedTables;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MysqlBaseTable mysqlBaseTable = (MysqlBaseTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getForeignKeys());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = this.this$0;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                void this_$iv2;
                boolean bl2 = false;
                ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$98);
                ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                ParentFamilySearcher conSearcher = elementChecker.inFamily((Family)modNamingFamily).searchChild(MysqlSchemaRetriever::retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$100, MysqlSchemaRetriever::retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$102);
                ElementDataCollector elementDataCollector = conSearcher.collector((arg_0, arg_1) -> MysqlSchemaRetriever.retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$103(this, arg_0, arg_1));
                boolean $i$f$collectAll = false;
                void $this$retrieveTableConstraintColumns_u24lambda_u24107_u24lambda_u24106_u24lambda_u24105 = this_$iv2;
                boolean bl3 = false;
                ((MysqlBaseIntrospector)object).getQueries().processConstraintColumns(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.ConstraintColumn, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$105$lambda$104((ElementDataCollector)$this$retrieveTableConstraintColumns_u24lambda_u24107_u24lambda_u24106_u24lambda_u24105, arg_0)));
                this_$iv2.finish();
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl4 = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final void setUpConstraint(MysqlBaseForeignKey con, List<MysqlBaseIntroQueries.ConstraintColumn> cols) {
            MysqlBaseIntroQueries.ConstraintColumn it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            MysqlBaseIntroQueries.ConstraintColumn f;
            MysqlBaseForeignKey mysqlBaseForeignKey;
            MysqlBaseForeignKey $this$setUpConstraint_u24lambda_u24110 = mysqlBaseForeignKey = con;
            boolean bl = false;
            MysqlBaseIntroQueries.ConstraintColumn constraintColumn = f = (MysqlBaseIntroQueries.ConstraintColumn)CollectionsKt.firstOrNull(cols);
            MysqlBaseIntroQueries.ConstraintColumn constraintColumn2 = f;
            $this$setUpConstraint_u24lambda_u24110.setRefTableRef(BasicParentReference.create(constraintColumn != null ? constraintColumn.referenced_table_schema : null, BasicNameReference.create(constraintColumn2 != null ? constraintColumn2.referenced_table_name : null)));
            Iterable iterable = cols;
            MysqlBaseForeignKey mysqlBaseForeignKey2 = $this$setUpConstraint_u24lambda_u24110;
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                MysqlBaseIntroQueries.ConstraintColumn constraintColumn3 = (MysqlBaseIntroQueries.ConstraintColumn)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.referenced_column_name);
            }
            mysqlBaseForeignKey2.setRefColNames((List)destination$iv$iv);
            $this$map$iv = cols;
            mysqlBaseForeignKey2 = $this$setUpConstraint_u24lambda_u24110;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (MysqlBaseIntroQueries.ConstraintColumn)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.column_name);
            }
            mysqlBaseForeignKey2.setColNames((List)destination$iv$iv);
        }

        /*
         * WARNING - void declaration
         */
        private final String[] splitColNames(String cn) {
            void $this$inplace$iv;
            void var6_6;
            if (cn == null) {
                return new String[0];
            }
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            String[] stringArray = StringUtil.splitByLines((String)cn);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitByLines(...)");
            Object[] objectArray = stringArray;
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$inplace = false;
            void $this$inplace_u24lambda_u2431$iv = var6_6 = $this$inplace$iv;
            boolean bl = false;
            void $this$forEachIndexed$iv$iv = $this$inplace_u24lambda_u2431$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$forEachIndexed$iv$iv) {
                String string;
                String string2;
                void ln;
                void s$iv;
                int n = index$iv$iv++;
                void var15_15 = item$iv$iv;
                int i$iv = n;
                boolean bl2 = false;
                String string3 = (String)s$iv;
                int n2 = i$iv;
                void var22_22 = $this$inplace_u24lambda_u2431$iv;
                boolean bl3 = false;
                if (ln != null) {
                    void it;
                    boolean bl4 = false;
                    String string4 = StringUtil.unescapeStringCharacters((String)it);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"unescapeStringCharacters(...)");
                    string2 = mysqlBaseIntrospector.dbIntern(string4);
                } else {
                    string2 = null;
                }
                var22_22[n2] = string = string2;
            }
            return (String[])var6_6;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutines(MysqlBaseSchema schema) {
            void fragments$iv;
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            this.this$0.reportRetrieving(objectKind);
            boolean bl = true;
            ModNamingFamily[] modNamingFamilyArray = new ModNamingFamily[1];
            Intrinsics.checkNotNullExpressionValue(schema.getRoutines(), (String)"getRoutines(...)");
            String[] stringArray = this.getFragmentNamesOrNull();
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            if (fragments$iv == null) {
                void families$iv$iv;
                void removeUnaffected$iv;
                ModFamily[] modFamilyArray = (ModFamily[])Arrays.copyOf(families$iv, ((void)families$iv).length);
                void removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyFamiliesAndCleanup2 = false;
                for (void f$iv$iv : families$iv$iv) {
                    f$iv$iv.markChildrenAsSyncPending();
                }
                boolean bl2 = false;
                BaseNativeIntrospector this_$iv = mysqlBaseIntrospector;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector baseNativeIntrospector = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl3 = false;
                    ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveRoutines$lambda$119$lambda$118$lambda$113).and(MysqlSchemaRetriever::retrieveRoutines$lambda$119$lambda$118$lambda$114);
                    ModNamingFamily<? extends MysqlBaseRoutine> modNamingFamily = schema.getRoutines();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
                    ElementSearcherNN routineSearcher = elementChecker.inFamily((Family)modNamingFamily).orCreate(MysqlSchemaRetriever::retrieveRoutines$lambda$119$lambda$118$lambda$115);
                    mysqlBaseIntrospector.getQueries().processRoutines(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Routine, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveRoutines$lambda$119$lambda$118$lambda$117(routineSearcher, mysqlBaseIntrospector, this, arg_0)));
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl4 = false;
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                for (void f$iv$iv : families$iv$iv) {
                    f$iv$iv.removeSyncPendingChildren();
                    f$iv$iv.sort();
                }
            } else {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])fragments$iv);
                block6: while (iterator.hasNext()) {
                    String fragment$iv = (String)iterator.next();
                    int n = ((void)families$iv).length;
                    for (int $i$f$modifyFamiliesAndCleanup2 = 0; $i$f$modifyFamiliesAndCleanup2 < n; ++$i$f$modifyFamiliesAndCleanup2) {
                        void family$iv = families$iv[$i$f$modifyFamiliesAndCleanup2];
                        BasicModNamedElement o$iv = (BasicModNamedElement)family$iv.get(fragment$iv);
                        if (o$iv == null) continue;
                        o$iv.setSyncPending(true);
                        continue block6;
                    }
                }
                boolean bl5 = false;
                BaseNativeIntrospector this_$iv = mysqlBaseIntrospector;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector this_$iv$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError3 = false;
                try {
                    boolean bl6 = false;
                    ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveRoutines$lambda$119$lambda$118$lambda$113).and(MysqlSchemaRetriever::retrieveRoutines$lambda$119$lambda$118$lambda$114);
                    ModNamingFamily<? extends MysqlBaseRoutine> modNamingFamily = schema.getRoutines();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
                    ElementSearcherNN routineSearcher = elementChecker.inFamily((Family)modNamingFamily).orCreate(MysqlSchemaRetriever::retrieveRoutines$lambda$119$lambda$118$lambda$115);
                    mysqlBaseIntrospector.getQueries().processRoutines(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Routine, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveRoutines$lambda$119$lambda$118$lambda$117(routineSearcher, mysqlBaseIntrospector, this, arg_0)));
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException(this_$iv$iv, e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl7 = false;
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default(this_$iv$iv, message$iv$iv, null, 2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                for (void family$iv : families$iv) {
                    family$iv.removeSyncPendingChildren();
                    family$iv.sort();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutineParameters(MysqlBaseSchema schema) {
            void families$iv$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.ARGUMENT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ARGUMENT");
            this.this$0.reportRetrieving(objectKind);
            Iterable $this$map$iv = this.touchedRoutines;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MysqlBaseRoutine mysqlBaseRoutine = (MysqlBaseRoutine)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getArguments());
            }
            ModFamily[] families$iv = (ModFamily[])((List)destination$iv$iv);
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            ModFamily[] thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            Iterable $this$forEach$iv = this.touchedRoutines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MysqlBaseRoutine it = (MysqlBaseRoutine)element$iv;
                boolean bl2 = false;
                if (it.getRoutineKind() != DasRoutine.Kind.FUNCTION) continue;
                it.createOrGetReturnArgument();
            }
            this.retrieveRoutineParametersFromInformationSchema(schema);
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutineParametersFromInformationSchema(MysqlBaseSchema schema) {
            void this_$iv;
            ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveRoutineParametersFromInformationSchema$lambda$123);
            ModNamingFamily<? extends MysqlBaseRoutine> modNamingFamily = schema.getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
            ElementCache routineCache = elementChecker.inFamily((Family)modNamingFamily).cache();
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var6_6 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                mysqlBaseIntrospector.getQueries().processRoutineParams(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Parameter, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveRoutineParametersFromInformationSchema$lambda$126$lambda$125(routineCache, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveInfoFromTableSrc() {
            Iterator<MysqlBaseTable> iterator = this.touchedTables.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<MysqlBaseTable> iterator2 = iterator;
            while (iterator2.hasNext()) {
                void this_$iv;
                MysqlBaseTable table;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                if (!this.shouldRetrieveTableSrc(table)) continue;
                BaseNativeIntrospector baseNativeIntrospector = this.this$0;
                MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
                boolean $i$f$continueOnDbError = false;
                void var6_6 = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    SqlCreateStatement sql;
                    SqlCreateStatement sqlCreateStatement;
                    boolean bl = false;
                    if (mysqlBaseIntrospector.getQueries().retrieveOneTableSource(this.getTransaction(), table) != null) {
                        String it;
                        boolean bl2 = false;
                        String string = this.replaceBin(it);
                        ObjectPath objectPath = ObjectPaths.of(table);
                        Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"of(...)");
                        sqlCreateStatement = this.getCreate(string, objectPath);
                    } else {
                        sqlCreateStatement = null;
                    }
                    if ((sql = sqlCreateStatement) == null) continue;
                    this.retrieveInfoFromTableSrc(table, sql);
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
            }
        }

        protected void retrieveInfoFromTableSrc(@NotNull MysqlBaseTable table, @NotNull SqlCreateStatement sql) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            if (this.this$0.getGenFromSrc()) {
                this.retrieveColumnGenExprFromTableSrc(table, sql);
            }
        }

        protected boolean shouldRetrieveTableSrc(@NotNull MysqlBaseTable table) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            return this.this$0.getGenFromSrc() && table.getColumns().find(arg_0 -> MysqlSchemaRetriever.shouldRetrieveTableSrc$lambda$129(shouldRetrieveTableSrc.1.INSTANCE, arg_0)) != null;
        }

        protected boolean shouldRetrieveTableSrc() {
            return this.this$0.getGenFromSrc();
        }

        private final void retrieveColumnGenExprFromTableSrc(MysqlBaseTable table, SqlCreateStatement sql) {
            for (SqlColumnDefinition c2 : sql.getDasChildren(ObjectKind.COLUMN).filter(SqlColumnDefinition.class)) {
                MysqlBaseTableColumn target2;
                if ((MysqlBaseTableColumn)table.getColumns().find(arg_0 -> MysqlSchemaRetriever.retrieveColumnGenExprFromTableSrc$lambda$130(new Function1(c2){
                    final /* synthetic */ SqlColumnDefinition $c;
                    {
                        this.$c = $c;
                    }

                    public final Boolean invoke(MysqlBaseTableColumn it) {
                        return StringsKt.equals((String)it.getName(), (String)this.$c.getName(), (boolean)true);
                    }
                }, arg_0)) == null) continue;
                this.this$0.getSqlHelper().getBuilder().build(target2, c2, this.this$0.getSqlHelper().getBuilderContext());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumns(MysqlBaseSchema schema) {
            BaseNativeIntrospector this_$iv$iv;
            void families$iv$iv;
            void families$iv;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            this.this$0.reportRetrieving(objectKind);
            MysqlBaseRoot mysqlBaseRoot = schema.getRoot();
            Intrinsics.checkNotNull((Object)mysqlBaseRoot);
            MysqlBaseRoot root = mysqlBaseRoot;
            Sequence touchedLikeTables = SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)this.touchedTables), (Sequence)CollectionsKt.asSequence((Iterable)this.touchedViews));
            List touchedColumnFamilies = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)touchedLikeTables, MysqlSchemaRetriever::retrieveColumns$lambda$131));
            Collection collection = touchedColumnFamilies;
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = mysqlBaseIntrospector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveColumns$lambda$141$lambda$135$lambda$132);
                Family[] familyArray = new Family[2];
                Intrinsics.checkNotNullExpressionValue(schema.getTables(), (String)"getTables(...)");
                Intrinsics.checkNotNullExpressionValue(schema.getViews(), (String)"getViews(...)");
                ElementCache tableCache = elementChecker.inFamilies(familyArray).cache();
                mysqlBaseIntrospector.getQueries().processColumns(this.getTransaction(), root, schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Column, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveColumns$lambda$141$lambda$135$lambda$134(tableCache, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException(this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default(this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            this_$iv = mysqlBaseIntrospector;
            $i$f$continueOnDbError = false;
            this_$iv$iv = this_$iv;
            whatsDoing$iv$iv = null;
            $i$f$continueOnDbError2 = false;
            try {
                boolean bl4 = false;
                ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveColumns$lambda$141$lambda$140$lambda$136);
                ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                FamilySearcher tableSearcher = elementChecker.inFamily((Family)modNamingFamily);
                mysqlBaseIntrospector.getQueries().processAutoIncrements(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.AutoIncValue, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveColumns$lambda$141$lambda$140$lambda$139(tableSearcher, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException(this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl5 = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default(this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected MysqlBaseLikeColumn applyColumn(@NotNull MysqlBaseLikeTable table, @NotNull MysqlBaseIntroQueries.Column c2) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            Object e = table.getColumns().renewAt(c2.ordinal_position, c2.column_name);
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            MysqlBaseLikeColumn $this$applyColumn_u24lambda_u24143 = (MysqlBaseLikeColumn)e;
            boolean bl = false;
            $this$applyColumn_u24lambda_u24143.setNotNull(!Intrinsics.areEqual((Object)c2.is_nullable, (Object)"YES"));
            DataType dataType = DataTypeFactory.of(c2.column_type);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            $this$applyColumn_u24lambda_u24143.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            $this$applyColumn_u24lambda_u24143.setComment(StringKt.nullize$default((String)c2.column_comment, (boolean)false, (int)1, null));
            if ($this$applyColumn_u24lambda_u24143 instanceof MysqlBaseTableColumn) {
                BigInteger bigInteger;
                String string;
                ((MysqlBaseTableColumn)$this$applyColumn_u24lambda_u24143).setColumnKind(this.getColumnKind(c2.extra));
                String string2 = this.getOnUpdate(c2.extra);
                ((MysqlBaseTableColumn)$this$applyColumn_u24lambda_u24143).setOnUpdate(string2 != null ? mysqlBaseIntrospector.dbIntern(string2) : null);
                MysqlBaseTable mysqlBaseTable = ((MysqlBaseTableColumn)$this$applyColumn_u24lambda_u24143).getParent();
                Intrinsics.checkNotNull((Object)mysqlBaseTable);
                BasicReference basicReference = mysqlBaseTable.getCollationRef();
                if (basicReference == null) {
                    MysqlBaseTable mysqlBaseTable2 = ((MysqlBaseTableColumn)$this$applyColumn_u24lambda_u24143).getParent();
                    Intrinsics.checkNotNull((Object)mysqlBaseTable2);
                    MysqlBaseSchema mysqlBaseSchema = mysqlBaseTable2.getSchema();
                    Intrinsics.checkNotNull((Object)mysqlBaseSchema);
                    basicReference = mysqlBaseSchema.getCollationRef();
                }
                String defaultCollation = basicReference != null ? basicReference.getName() : null;
                MysqlBaseTableColumn mysqlBaseTableColumn = (MysqlBaseTableColumn)$this$applyColumn_u24lambda_u24143;
                String string3 = c2.collation_name;
                if (string3 != null) {
                    void it;
                    String string4;
                    String string5 = string4 = string3;
                    MysqlBaseTableColumn mysqlBaseTableColumn2 = mysqlBaseTableColumn;
                    boolean bl2 = false;
                    mysqlBaseTableColumn = mysqlBaseTableColumn2;
                    string = Boolean.valueOf(!Intrinsics.areEqual((Object)it, (Object)defaultCollation)).booleanValue() ? string4 : null;
                } else {
                    string = null;
                }
                mysqlBaseTableColumn.setCollationRef(BasicNameReference.create(string));
                ((MysqlBaseTableColumn)$this$applyColumn_u24lambda_u24143).setDefaultExpression(this.getDefaultExpression($this$applyColumn_u24lambda_u24143, c2));
                MysqlBaseTableColumn mysqlBaseTableColumn3 = (MysqlBaseTableColumn)$this$applyColumn_u24lambda_u24143;
                if (this.isAutoIncrement(c2)) {
                    bigInteger = ((MysqlBaseTableColumn)$this$applyColumn_u24lambda_u24143).getAutoIncrement();
                    if (bigInteger == null) {
                        bigInteger = BigInteger.ONE;
                    }
                } else {
                    bigInteger = null;
                }
                mysqlBaseTableColumn3.setAutoIncrement(bigInteger);
                String string6 = c2.extra;
                ((MysqlBaseTableColumn)$this$applyColumn_u24lambda_u24143).setHidden(string6 != null ? StringsKt.contains((CharSequence)string6, (CharSequence)"invisible", (boolean)true) : false);
            }
            Object e2 = e;
            Intrinsics.checkNotNullExpressionValue(e2, (String)"apply(...)");
            return (MysqlBaseLikeColumn)e2;
        }

        private final String getOnUpdate(String extra) {
            if (extra == null) {
                return null;
            }
            Matcher matcher = MysqlBaseIntrospectorKt.access$getON_UPDATE$p().matcher(extra);
            if (!matcher.find()) {
                return null;
            }
            return matcher.group(1);
        }

        private final ColumnKind getColumnKind(String extra) {
            if (extra == null) {
                return ColumnKind.NORMAL;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"VIRTUAL GENERATED", (boolean)false, (int)2, null)) {
                return ColumnKind.GENERATED_VIRTUAL;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"STORED GENERATED", (boolean)false, (int)2, null)) {
                return ColumnKind.GENERATED_STORED;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"VIRTUAL", (boolean)false, (int)2, null)) {
                return ColumnKind.GENERATED_VIRTUAL;
            }
            return ColumnKind.NORMAL;
        }

        private final boolean isAutoIncrement(MysqlBaseIntroQueries.Column c2) {
            return StringsKt.equals((String)c2.extra, (String)"auto_increment", (boolean)true);
        }

        /*
         * Unable to fully structure code
         */
        private final String getDefaultExpression(MysqlBaseLikeColumn column, MysqlBaseIntroQueries.Column c) {
            block9: {
                v0 = c.generation_expression;
                if (v0 != null && (v0 = this.replaceBin((String)v0)) != null && (v0 = StringKt.nullize$default((String)v0, (boolean)false, (int)1, null)) != null) break block9;
                var7_3 = c.column_default;
                if (var7_3 == null) ** GOTO lbl-1000
                it = var9_5 = var7_3;
                $i$a$-takeIf-MysqlBaseIntrospector$MysqlSchemaRetriever$getDefaultExpression$gen$1 = false;
                if (StringUtil.startsWithIgnoreCase((String)it, (String)"CURRENT_TIMESTAMP")) ** GOTO lbl-1000
                v1 = c.extra;
                if (v1 == null) {
                    v1 = "";
                }
                if (StringsKt.contains$default((CharSequence)v1, (CharSequence)"DEFAULT_GENERATED", (boolean)false, (int)2, null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                v3 = var8_9 = v2 != false ? var9_5 : null;
                if (var8_9 != null && (var9_5 = StringKt.nullize$default((String)var8_9, (boolean)false, (int)1, null)) != null) {
                    it = var9_5;
                    $i$a$-let-MysqlBaseIntrospector$MysqlSchemaRetriever$getDefaultExpression$gen$2 = false;
                    v0 = "(" + it + ")";
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
            }
            if ((gen = v0) != null) {
                return this.this$0.getUnescapeGenExpr() != false ? this.unescape(gen) : gen;
            }
            def = c.column_default;
            if (this.this$0.getDefProperlyQuoted() || def == null) {
                if (Intrinsics.areEqual((Object)def, (Object)"NULL")) {
                    return null;
                }
                v4 = def;
                return v4 != null ? this.replaceBin(v4) : null;
            }
            if (!(column instanceof MysqlBaseTableColumn)) {
                return null;
            }
            v5 = ((MysqlBaseTableColumn)column).getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getDasType(...)");
            typeName = DasTypeUtilsKt.getTypeName(v5);
            isInt = StringsKt.endsWith$default((String)typeName, (String)"int", (boolean)false, (int)2, null);
            noQuote = isInt != false || ((MysqlBaseTableColumn)column).isComputed() != false || Intrinsics.areEqual((Object)typeName, (Object)"bit") != false || Intrinsics.areEqual((Object)typeName, (Object)"double") != false || Intrinsics.areEqual((Object)typeName, (Object)"float") != false || Intrinsics.areEqual((Object)typeName, (Object)"decimal") != false || StringsKt.endsWith$default((String)typeName, (String)"binary", (boolean)false, (int)2, null) != false || StringUtil.startsWithIgnoreCase((String)def, (String)"CURRENT_TIMESTAMP") != false && (StringsKt.startsWith$default((String)typeName, (String)"datetime", (boolean)false, (int)2, null) != false || StringsKt.startsWith$default((String)typeName, (String)"timestamp", (boolean)false, (int)2, null) != false);
            return isInt != false ? this.trimLeadingZeroes(def) : (noQuote == false ? MysqlBaseIntrospector.access$quote(this.this$0, def) : def);
        }

        private final String trimLeadingZeroes(String def) {
            Matcher it = MysqlBaseIntrospectorKt.access$getTRIM_ZEROES$p().matcher(def);
            boolean bl = false;
            String string = it.matches() ? it.group(1) : def;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"let(...)");
            return string;
        }

        private final String replaceBin(String $this$replaceBin) {
            Object[] objectArray = new String[]{"\b", "\u001a", "\u0000"};
            List list = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new String[]{"\\b", "\\Z", "\\0"};
            String string = StringUtil.replace((String)$this$replaceBin, (List)list, (List)CollectionsKt.listOf((Object[])objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
            return string;
        }

        private final String unescape(String str) {
            StringBuilder buf = new StringBuilder();
            int last = str.length() - 1;
            for (int i2 = 0; i2 <= last; ++i2) {
                char ch = str.charAt(i2);
                if (ch == '\\' && i2 != last && (ch = str.charAt(++i2)) != '\'' && ch != '\\') {
                    buf.append('\\');
                }
                buf.append(ch);
            }
            String string = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveViewSources(MysqlBaseSchema schema) {
            void this_$iv;
            this.this$0.reportRetrieving("view sources", "introspection.retrieve.view.sources");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var5_5 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                ArrayList bugged = new ArrayList();
                ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveViewSources$lambda$150$lambda$147);
                ModNamingFamily<? extends MysqlBaseView> modNamingFamily = schema.getViews();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getViews(...)");
                FamilySearcher viewSearcher = elementChecker.inFamily((Family)modNamingFamily);
                mysqlBaseIntrospector.getQueries().processViews(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.View, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveViewSources$lambda$150$lambda$149(viewSearcher, bugged, arg_0)));
                Iterator iterator = bugged.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    MysqlBaseView view = (MysqlBaseView)e;
                    ObjectPath objectPath = ObjectPaths.of(view);
                    Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"of(...)");
                    String string = view.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    view.setSourceText(this.retrieveViewSources(schema, objectPath, string));
                    view.setDetailsLevel(Level.L3);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutineSources(MysqlBaseSchema schema) {
            this.this$0.reportRetrieving("routine sources", "introspection.retrieve.routine.sources");
            if (!this.this$0.getParametersTableExists()) {
                Iterable $this$forEach$iv = this.touchedRoutines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MysqlBaseRoutine it = (MysqlBaseRoutine)element$iv;
                    boolean bl = false;
                    this.retrieveBuggedRoutineSources(it);
                }
            } else if (this.this$0.getCircumventDbe5060()) {
                this.this$0.reportRetrieving("routine sources (circumventing MySQL bugs)", "introspection.retrieve.routine.sources");
                Iterable $this$forEach$iv = this.touchedRoutines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MysqlBaseRoutine it = (MysqlBaseRoutine)element$iv;
                    boolean bl = false;
                    this.retrieveBuggedRoutineSources(it);
                }
            } else {
                void this_$iv;
                BaseNativeIntrospector $this$forEach$iv = this.this$0;
                MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
                boolean $i$f$continueOnDbError = false;
                void element$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl = false;
                    ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveRoutineSources$lambda$156$lambda$153);
                    ModNamingFamily<? extends MysqlBaseRoutine> modNamingFamily = schema.getRoutines();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
                    FamilySearcher routineSearcher = elementChecker.inFamily((Family)modNamingFamily);
                    mysqlBaseIntrospector.getQueries().processRoutineSources(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Routine, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveRoutineSources$lambda$156$lambda$155(routineSearcher, arg_0)));
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutineParametersFromSource(MysqlBaseRoutine routine2, String src) {
            Object object;
            void $this$modifyAndCleanup_u24default$iv;
            SqlCreateProcedureStatement sqlCreateProcedureStatement;
            String string = src;
            if (string != null) {
                String it = string;
                boolean bl = false;
                ObjectPath objectPath = ObjectPaths.of(routine2);
                Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"of(...)");
                SqlCreateStatement sqlCreateStatement = this.getCreate(it, objectPath);
                sqlCreateProcedureStatement = sqlCreateStatement instanceof SqlCreateProcedureStatement ? (SqlCreateProcedureStatement)sqlCreateStatement : null;
            } else {
                sqlCreateProcedureStatement = null;
            }
            SqlCreateProcedureStatement stmt = sqlCreateProcedureStatement;
            ModFamily modFamily = (ModFamily)((Object)routine2.getArguments());
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModPositioningNamingFamily it = (ModPositioningNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            if (routine2.getRoutineKind() == DasRoutine.Kind.FUNCTION) {
                routine2.createOrGetReturnArgument();
            }
            if ((object = stmt) != null && (object = object.getArguments()) != null) {
                Object $this$forEachIndexed$iv = object;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                Iterator iterator = $this$forEachIndexed$iv.iterator();
                while (iterator.hasNext()) {
                    void a;
                    int n;
                    Object item$iv = iterator.next();
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    SqlParameterDefinition sqlParameterDefinition = (SqlParameterDefinition)item$iv;
                    int i2 = n;
                    boolean bl2 = false;
                    mysqlBaseIntrospector.getSqlHelper().getBuilder().build((BasicModElement)routine2.getArguments().renewAt((short)(i2 + 1), a.getName()), (DasObject)a, mysqlBaseIntrospector.getSqlHelper().getBuilderContext());
                }
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTriggerSources(MysqlBaseSchema schema) {
            this.this$0.reportRetrieving("trigger sources", "introspection.retrieve.trigger.sources");
            if (this.this$0.getCircumventDbe5060()) {
                this.this$0.reportRetrieving("trigger sources (circumventing MySQL bugs)", "introspection.retrieve.trigger.sources");
                Iterator<MysqlBaseTable> iterator = this.touchedTables.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<MysqlBaseTable> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    MysqlBaseTable table;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                    for (MysqlBaseTrigger mysqlBaseTrigger : table.getTriggers()) {
                        Intrinsics.checkNotNull((Object)mysqlBaseTrigger);
                        this.retrieveBuggedTriggerSources(mysqlBaseTrigger);
                    }
                    table.setDetailsLevel(Level.L3);
                }
            } else {
                void this_$iv;
                BaseNativeIntrospector baseNativeIntrospector = this.this$0;
                MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
                boolean $i$f$continueOnDbError = false;
                void var5_9 = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl = false;
                    ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveTriggerSources$lambda$163$lambda$160);
                    ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                    ElementCache tableCache = elementChecker.inFamily((Family)modNamingFamily).cache();
                    mysqlBaseIntrospector.getQueries().processTriggerSources(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Trigger, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveTriggerSources$lambda$163$lambda$162(tableCache, arg_0)));
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)var5_9, e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        var5_9.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)var5_9, message$iv$iv, null, 2, null);
                    }
                    var5_9.getErrorSink().accept(null, e$iv$iv);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveEventSources(MysqlBaseSchema schema) {
            this.this$0.reportRetrieving("event sources", "introspection.retrieve.event.sources");
            if (this.this$0.getCircumventDbe5060()) {
                this.this$0.reportRetrieving("event sources (circumventing MySQL bugs)", "introspection.retrieve.event.sources");
                Iterable $this$forEach$iv = this.touchedEvents;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MysqlBaseEvent it = (MysqlBaseEvent)element$iv;
                    boolean bl = false;
                    this.retrieveBuggedEventSources(it);
                }
            } else {
                void this_$iv;
                BaseNativeIntrospector $this$forEach$iv = this.this$0;
                MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
                boolean $i$f$continueOnDbError = false;
                void element$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl = false;
                    ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveEventSources$lambda$168$lambda$165);
                    ModNamingFamily<? extends MysqlBaseEvent> modNamingFamily = schema.getEvents();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getEvents(...)");
                    FamilySearcher eventsSearcher = elementChecker.inFamily((Family)modNamingFamily);
                    mysqlBaseIntrospector.getQueries().processEventSources(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Event, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveEventSources$lambda$168$lambda$167(eventsSearcher, arg_0)));
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveBuggedRoutineSources(MysqlBaseRoutine routine2) {
            void this_$iv;
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var5_5 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                String src;
                String stmt;
                boolean bl = false;
                String string = stmt = mysqlBaseIntrospector.getQueries().retrieveOneRoutineSource(this.getTransaction(), routine2);
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    ObjectPath objectPath = ObjectPaths.of(routine2);
                    Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"of(...)");
                    v2 = this.getBody(it, objectPath);
                } else {
                    v2 = src = null;
                }
                if (!mysqlBaseIntrospector.getParametersTableExists()) {
                    this.retrieveRoutineParametersFromSource(routine2, stmt);
                }
                String string2 = src;
                routine2.setSourceText(string2 != null ? BaseIntrospectionFunctions.toCompositeText(string2, CompositeText.Kind.ORIGINAL_TEXT) : null);
                routine2.setDetailsLevel(Level.L3);
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveBuggedTriggerSources(MysqlBaseTrigger trigger2) {
            void this_$iv;
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var5_5 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                String src;
                String string;
                boolean bl = false;
                String string2 = mysqlBaseIntrospector.getQueries().retrieveOneTriggerSource(this.getTransaction(), trigger2);
                if (string2 != null) {
                    String it = string2;
                    boolean bl2 = false;
                    ObjectPath objectPath = ObjectPaths.of(trigger2);
                    Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"of(...)");
                    string = this.getBody(it, objectPath);
                } else {
                    string = null;
                }
                String string3 = src = string;
                trigger2.setSourceText(string3 != null ? BaseIntrospectionFunctions.toCompositeText(string3, CompositeText.Kind.ORIGINAL_TEXT) : null);
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final CompositeText retrieveViewSources(MysqlBaseSchema sc, ObjectPath p2, String name2) {
            void this_$iv;
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var7_7 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                SimpleCompositeText simpleCompositeText;
                boolean bl = false;
                String string = mysqlBaseIntrospector.getQueries().retrieveOneViewSource(this.getTransaction(), sc, name2, true);
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    String string2 = this.getViewBody(it, p2);
                    if (string2 != null) {
                        simpleCompositeText = BaseIntrospectionFunctions.toCompositeText(string2, CompositeText.Kind.DECOMPILED_TEXT);
                        return simpleCompositeText;
                    }
                }
                simpleCompositeText = null;
                return simpleCompositeText;
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveBuggedEventSources(MysqlBaseEvent event) {
            void this_$iv;
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var5_5 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                String src;
                String string;
                boolean bl = false;
                String string2 = mysqlBaseIntrospector.getQueries().retrieveOneEventSource(this.getTransaction(), event);
                if (string2 != null) {
                    String it = string2;
                    boolean bl2 = false;
                    ObjectPath objectPath = ObjectPaths.of(event);
                    Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"of(...)");
                    string = this.getBody(it, objectPath);
                } else {
                    string = null;
                }
                String string3 = src = string;
                event.setSourceText(string3 != null ? BaseIntrospectionFunctions.toCompositeText(string3, CompositeText.Kind.ORIGINAL_TEXT) : null);
                event.setDetailsLevel(Level.L3);
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        private final String getViewBody(String src, ObjectPath p2) {
            SqlCreateStatement sqlCreateStatement = this.getCreate(src, p2);
            SqlCreateViewStatement sqlCreateViewStatement = sqlCreateStatement instanceof SqlCreateViewStatement ? (SqlCreateViewStatement)sqlCreateStatement : null;
            if (sqlCreateViewStatement == null) {
                return null;
            }
            SqlCreateViewStatement createStatement = sqlCreateViewStatement;
            SqlExpression body = createStatement.getQueryExpression();
            if (body == null) {
                this.log.warn("No body found for " + p2.getDisplayName());
                return null;
            }
            return body.getText();
        }

        private final String getBody(String src, ObjectPath p2) {
            SqlCreateStatement createStatement = this.getCreate(src, p2);
            TextRange def = this.this$0.getSqlHelper().getBuilder().getCompactDefinition(p2, BaseIntrospectionFunctions.toCompositeText(src, CompositeText.Kind.PLAIN_TEXT), createStatement);
            if (def == null || def.isEmpty()) {
                this.log.warn("No body found for " + p2.getDisplayName());
                return null;
            }
            return def.substring(src);
        }

        /*
         * WARNING - void declaration
         */
        private final SqlCreateStatement getCreate(String src, ObjectPath p2) {
            Object object;
            void this_$iv;
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            String src$iv = src;
            boolean $i$f$parseStatement = false;
            try {
                void this_$iv$iv;
                object = BaseNativeIntrospector.access$getSqlHelper((BaseNativeIntrospector)this_$iv);
                String src$iv$iv = src$iv;
                boolean $i$f$statements = false;
                object = this_$iv$iv.statements(src$iv$iv, SqlCreateStatement.class).first();
            }
            catch (ProcessCanceledException pce$iv) {
                throw pce$iv;
            }
            catch (Exception e$iv) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this_$iv.log.error((Throwable)e$iv);
                }
                this_$iv.log.warn("Failed to parse sources", (Throwable)e$iv);
                object = null;
            }
            SqlCreateStatement createStatement = (SqlCreateStatement)object;
            if (createStatement == null) {
                this.log.warn("No create found for " + p2.getDisplayName());
                return null;
            }
            return createStatement;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTriggers(MysqlBaseSchema schema) {
            void families$iv$iv;
            void families$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.TRIGGER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TRIGGER");
            this.this$0.reportRetrieving(objectKind);
            Iterable $this$map$iv = this.touchedTables;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MysqlBaseTable mysqlBaseTable = (MysqlBaseTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTriggers());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = this.this$0;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveTriggers$lambda$187$lambda$185$lambda$178);
                ModNamingFamily<? extends MysqlBaseTable> modNamingFamily = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                ParentFamilySearcher triggerSearcher = elementChecker.inFamily((Family)modNamingFamily).searchChild(MysqlSchemaRetriever::retrieveTriggers$lambda$187$lambda$185$lambda$180, MysqlSchemaRetriever::retrieveTriggers$lambda$187$lambda$185$lambda$182);
                ((MysqlBaseIntrospector)object).getQueries().processTriggers(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Trigger, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveTriggers$lambda$187$lambda$185$lambda$184(triggerSearcher, (MysqlBaseIntrospector)object, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            Iterator<MysqlBaseTable> iterator = this.touchedTables.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<MysqlBaseTable> iterator2 = iterator;
            while (iterator2.hasNext()) {
                boolean bl4;
                MysqlBaseTable table;
                block11: {
                    Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                    ModNamingFamily<? extends MysqlBaseTrigger> modNamingFamily = table.getTriggers();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTriggers(...)");
                    Iterable $this$all$iv = modNamingFamily;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl4 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            MysqlBaseTrigger t = (MysqlBaseTrigger)element$iv;
                            boolean bl5 = false;
                            if (t.getSourceText() != null) continue;
                            bl4 = false;
                            break block11;
                        }
                        bl4 = true;
                    }
                }
                if (!bl4) continue;
                table.setDetailsLevel(Level.L3);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutineGrants(MysqlBaseSchema schema, List<MysqlObjectGrant> newGrants) {
            void this_$iv;
            this.this$0.reportRetrieving("routine permissions", "introspection.retrieve.objectPermissions");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var6_6 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                mysqlBaseIntrospector.getQueries().processRoutineGrants(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.RoutineGrant, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveRoutineGrants$lambda$189$lambda$188(mysqlBaseIntrospector, newGrants, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumnGrants(MysqlBaseSchema schema, List<MysqlObjectGrant> newGrants) {
            void this_$iv;
            this.this$0.reportRetrieving("column permissions", "introspection.retrieve.objectPermissions");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            void var6_6 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                Ref.ObjectRef key2 = new Ref.ObjectRef();
                key2.element = CollectionsKt.listOf((Object)"");
                Ref.ObjectRef priv = new Ref.ObjectRef();
                Ref.BooleanRef isGrantable = new Ref.BooleanRef();
                BitSet cols = new BitSet();
                ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveColumnGrants$lambda$194$lambda$190);
                Family[] familyArray = new Family[2];
                Intrinsics.checkNotNullExpressionValue(schema.getTables(), (String)"getTables(...)");
                Intrinsics.checkNotNullExpressionValue(schema.getViews(), (String)"getViews(...)");
                ElementCache tab = elementChecker.inFamilies(familyArray).cache();
                mysqlBaseIntrospector.getQueries().processColumnGrants(this.getTransaction(), schema, (Function1<? super MysqlBaseIntroQueries.ColumnGrant, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveColumnGrants$lambda$194$lambda$193(key2, priv, mysqlBaseIntrospector, newGrants, cols, isGrantable, tab, arg_0)));
                if (priv.element != null) {
                    Object object = priv.element;
                    Intrinsics.checkNotNull((Object)object);
                    MysqlObjectGrant mysqlObjectGrant = (MysqlObjectGrant)object;
                    Object object2 = priv.element;
                    Intrinsics.checkNotNull((Object)object2);
                    mysqlBaseIntrospector.appendPrivilege(newGrants, MysqlObjectGrantController.INSTANCE.withPermission(mysqlObjectGrant, ((MysqlObjectGrant)object2).getPermission(), cols, Grants.State.GRANT), isGrantable.element);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveEvents(MysqlBaseSchema schema) {
            void fragments$iv;
            ObjectKind objectKind = ObjectKind.SCHEDULED_EVENT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SCHEDULED_EVENT");
            this.this$0.reportRetrieving(objectKind);
            boolean bl = true;
            ModNamingFamily[] modNamingFamilyArray = new ModNamingFamily[1];
            Intrinsics.checkNotNullExpressionValue(schema.getEvents(), (String)"getEvents(...)");
            String[] stringArray = this.getFragmentNamesOrNull();
            MysqlBaseIntrospector mysqlBaseIntrospector = this.this$0;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            if (fragments$iv == null) {
                void families$iv$iv;
                void removeUnaffected$iv;
                ModFamily[] modFamilyArray = (ModFamily[])Arrays.copyOf(families$iv, ((void)families$iv).length);
                void removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyFamiliesAndCleanup2 = false;
                for (void f$iv$iv : families$iv$iv) {
                    f$iv$iv.markChildrenAsSyncPending();
                }
                boolean bl2 = false;
                if (mysqlBaseIntrospector.getSchedulerEnabled()) {
                    BaseNativeIntrospector this_$iv = mysqlBaseIntrospector;
                    boolean $i$f$continueOnDbError = false;
                    BaseNativeIntrospector baseNativeIntrospector = this_$iv;
                    Object whatsDoing$iv$iv = null;
                    boolean $i$f$continueOnDbError2 = false;
                    try {
                        boolean bl3 = false;
                        ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveEvents$lambda$202$lambda$201$lambda$195);
                        ModNamingFamily<? extends MysqlBaseEvent> modNamingFamily = schema.getEvents();
                        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getEvents(...)");
                        ElementSearcherNN eventSearcher = elementChecker.inFamily((Family)modNamingFamily).orCreate(MysqlSchemaRetriever::retrieveEvents$lambda$202$lambda$201$lambda$196);
                        mysqlBaseIntrospector.getQueries().processEvents(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Event, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveEvents$lambda$202$lambda$201$lambda$200(eventSearcher, mysqlBaseIntrospector, this, arg_0)));
                    }
                    catch (DBException e$iv$iv) {
                        StringBuilder stringBuilder;
                        void this_$iv$iv;
                        boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                        StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                        boolean bl4 = false;
                        $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                        $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                        $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                        String message$iv$iv = stringBuilder.toString();
                        if (expected$iv$iv) {
                            this_$iv$iv.trace(message$iv$iv);
                        } else {
                            IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                        }
                        this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                    }
                }
                for (void f$iv$iv : families$iv$iv) {
                    f$iv$iv.removeSyncPendingChildren();
                    f$iv$iv.sort();
                }
            } else {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])fragments$iv);
                block6: while (iterator.hasNext()) {
                    String fragment$iv = (String)iterator.next();
                    int n = ((void)families$iv).length;
                    for (int $i$f$modifyFamiliesAndCleanup2 = 0; $i$f$modifyFamiliesAndCleanup2 < n; ++$i$f$modifyFamiliesAndCleanup2) {
                        void family$iv = families$iv[$i$f$modifyFamiliesAndCleanup2];
                        BasicModNamedElement o$iv = (BasicModNamedElement)family$iv.get(fragment$iv);
                        if (o$iv == null) continue;
                        o$iv.setSyncPending(true);
                        continue block6;
                    }
                }
                boolean bl5 = false;
                if (mysqlBaseIntrospector.getSchedulerEnabled()) {
                    BaseNativeIntrospector this_$iv = mysqlBaseIntrospector;
                    boolean $i$f$continueOnDbError = false;
                    BaseNativeIntrospector this_$iv$iv = this_$iv;
                    Object whatsDoing$iv$iv = null;
                    boolean $i$f$continueOnDbError3 = false;
                    try {
                        boolean bl6 = false;
                        ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this.searchInSchema(), MysqlSchemaRetriever::retrieveEvents$lambda$202$lambda$201$lambda$195);
                        ModNamingFamily<? extends MysqlBaseEvent> modNamingFamily = schema.getEvents();
                        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getEvents(...)");
                        ElementSearcherNN eventSearcher = elementChecker.inFamily((Family)modNamingFamily).orCreate(MysqlSchemaRetriever::retrieveEvents$lambda$202$lambda$201$lambda$196);
                        mysqlBaseIntrospector.getQueries().processEvents(this.getTransaction(), schema, this.getFragmentNamesOrNull(), (Function1<? super MysqlBaseIntroQueries.Event, Unit>)((Function1)arg_0 -> MysqlSchemaRetriever.retrieveEvents$lambda$202$lambda$201$lambda$200(eventSearcher, mysqlBaseIntrospector, this, arg_0)));
                    }
                    catch (DBException e$iv$iv) {
                        StringBuilder stringBuilder;
                        boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException(this_$iv$iv, e$iv$iv);
                        StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                        boolean bl7 = false;
                        $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                        $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                        $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                        String message$iv$iv = stringBuilder.toString();
                        if (expected$iv$iv) {
                            this_$iv$iv.trace(message$iv$iv);
                        } else {
                            IntrospectionQueryContext.logWarn$default(this_$iv$iv, message$iv$iv, null, 2, null);
                        }
                        this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                    }
                }
                for (void family$iv : families$iv) {
                    family$iv.removeSyncPendingChildren();
                    family$iv.sort();
                }
            }
        }

        private final MysqlEventStatus getEventStatus(String status) {
            return StringsKt.equals((String)status, (String)"ENABLED", (boolean)false) ? MysqlEventStatus.ENABLED : (StringsKt.equals((String)status, (String)"DISABLED", (boolean)false) ? MysqlEventStatus.DISABLED : (StringsKt.equals((String)status, (String)"SLAVESIDE_DISABLED", (boolean)false) ? MysqlEventStatus.SLAVESIDE_DISABLED : MysqlEventStatus.ENABLED));
        }

        private static final Unit retrieveNamedFragments$lambda$0(MysqlSchemaRetriever this$0, MysqlBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveTables(schema);
            this$0.retrieveColumns(schema);
            this$0.retrieveTableDetails(schema);
            this$0.retrieveTriggers(schema);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final Unit retrieveNamedFragments$lambda$2(MysqlSchemaRetriever this$0, MysqlBaseIntrospector this$1, MysqlBaseSchema schema) {
            void this_$iv$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv$iv;
            void $this$iv$iv$iv;
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            if (this$0.shouldRetrieveTableSrc()) {
                this$0.retrieveInfoFromTableSrc();
            }
            BaseNativeIntrospector this_$iv = this$1;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            void var8_8 = this_$iv$iv;
            String name$iv$iv$iv = name$iv$iv;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this$0, schema){
                    final /* synthetic */ MysqlSchemaRetriever this$0;
                    final /* synthetic */ MysqlBaseSchema $schema$inlined;
                    {
                        this.this$0 = mysqlSchemaRetriever;
                        this.$schema$inlined = mysqlBaseSchema;
                    }

                    public final void run() {
                        boolean bl = false;
                        MysqlSchemaRetriever.access$retrieveTriggerSources(this.this$0, this.$schema$inlined);
                    }
                });
                $this$iv$iv$iv = this_$iv$iv;
                sectionReference$iv$iv$iv = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv == null) return Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                void this_$iv$iv$iv2;
                sectionReference$iv$iv$iv = this_$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, sectionReference$iv$iv$iv2, null, 2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return Unit.INSTANCE;
            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder3, sectionReference$iv$iv$iv, null, 2, null);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveNamedFragments$lambda$3(MysqlSchemaRetriever this$0, MysqlBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveTables(schema);
            this$0.retrieveColumns(schema);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final Unit retrieveNamedFragments$lambda$5(MysqlBaseIntrospector this$0, MysqlSchemaRetriever this$1, MysqlBaseSchema schema) {
            void this_$iv$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv$iv;
            void $this$iv$iv$iv;
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            void var8_8 = this_$iv$iv;
            String name$iv$iv$iv = name$iv$iv;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this$1, schema){
                    final /* synthetic */ MysqlSchemaRetriever this$0;
                    final /* synthetic */ MysqlBaseSchema $schema$inlined;
                    {
                        this.this$0 = mysqlSchemaRetriever;
                        this.$schema$inlined = mysqlBaseSchema;
                    }

                    public final void run() {
                        boolean bl = false;
                        MysqlSchemaRetriever.access$retrieveViewSources(this.this$0, this.$schema$inlined);
                    }
                });
                $this$iv$iv$iv = this_$iv$iv;
                sectionReference$iv$iv$iv = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv == null) return Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                void this_$iv$iv$iv2;
                sectionReference$iv$iv$iv = this_$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, sectionReference$iv$iv$iv2, null, 2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return Unit.INSTANCE;
            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder3, sectionReference$iv$iv$iv, null, 2, null);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveNamedFragments$lambda$6(MysqlSchemaRetriever this$0, MysqlBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveRoutines(schema);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final Unit retrieveNamedFragments$lambda$8(MysqlBaseIntrospector this$0, MysqlSchemaRetriever this$1, MysqlBaseSchema schema) {
            void this_$iv$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv$iv;
            void $this$iv$iv$iv;
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            void var8_8 = this_$iv$iv;
            String name$iv$iv$iv = name$iv$iv;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this$1, schema){
                    final /* synthetic */ MysqlSchemaRetriever this$0;
                    final /* synthetic */ MysqlBaseSchema $schema$inlined;
                    {
                        this.this$0 = mysqlSchemaRetriever;
                        this.$schema$inlined = mysqlBaseSchema;
                    }

                    public final void run() {
                        boolean bl = false;
                        MysqlSchemaRetriever.access$retrieveRoutineSources(this.this$0, this.$schema$inlined);
                    }
                });
                $this$iv$iv$iv = this_$iv$iv;
                sectionReference$iv$iv$iv = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv == null) return Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                void this_$iv$iv$iv2;
                sectionReference$iv$iv$iv = this_$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, sectionReference$iv$iv$iv2, null, 2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return Unit.INSTANCE;
            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder3, sectionReference$iv$iv$iv, null, 2, null);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final Unit retrieveNamedFragments$lambda$10(MysqlBaseIntrospector this$0, MysqlSchemaRetriever this$1, MysqlBaseSchema schema) {
            void this_$iv$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv$iv;
            void $this$iv$iv$iv;
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            void var8_8 = this_$iv$iv;
            String name$iv$iv$iv = name$iv$iv;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this$1, schema){
                    final /* synthetic */ MysqlSchemaRetriever this$0;
                    final /* synthetic */ MysqlBaseSchema $schema$inlined;
                    {
                        this.this$0 = mysqlSchemaRetriever;
                        this.$schema$inlined = mysqlBaseSchema;
                    }

                    public final void run() {
                        boolean bl = false;
                        MysqlSchemaRetriever.access$retrieveRoutineSources(this.this$0, this.$schema$inlined);
                    }
                });
                $this$iv$iv$iv = this_$iv$iv;
                sectionReference$iv$iv$iv = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv == null) return Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                void this_$iv$iv$iv2;
                sectionReference$iv$iv$iv = this_$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, sectionReference$iv$iv$iv2, null, 2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return Unit.INSTANCE;
            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder3, sectionReference$iv$iv$iv, null, 2, null);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveNamedFragments$lambda$11(MysqlSchemaRetriever this$0, MysqlBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveEvents(schema);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final Unit retrieveNamedFragments$lambda$13(MysqlBaseIntrospector this$0, MysqlSchemaRetriever this$1, MysqlBaseSchema schema) {
            void this_$iv$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv$iv;
            void $this$iv$iv$iv;
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            void var8_8 = this_$iv$iv;
            String name$iv$iv$iv = name$iv$iv;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this$1, schema){
                    final /* synthetic */ MysqlSchemaRetriever this$0;
                    final /* synthetic */ MysqlBaseSchema $schema$inlined;
                    {
                        this.this$0 = mysqlSchemaRetriever;
                        this.$schema$inlined = mysqlBaseSchema;
                    }

                    public final void run() {
                        boolean bl = false;
                        MysqlSchemaRetriever.access$retrieveEventSources(this.this$0, this.$schema$inlined);
                    }
                });
                $this$iv$iv$iv = this_$iv$iv;
                sectionReference$iv$iv$iv = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv == null) return Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                void this_$iv$iv$iv2;
                sectionReference$iv$iv$iv = this_$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, sectionReference$iv$iv$iv2, null, 2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return Unit.INSTANCE;
            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder3, sectionReference$iv$iv$iv, null, 2, null);
            return Unit.INSTANCE;
        }

        private static final Unit processLevel2Imp$lambda$14(MysqlSchemaRetriever this$0, MysqlBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveTables(schema);
            return Unit.INSTANCE;
        }

        private static final Unit processLevel2Imp$lambda$15(MysqlSchemaRetriever this$0, MysqlBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveColumns(schema);
            return Unit.INSTANCE;
        }

        private static final Unit processLevel2Imp$lambda$16(MysqlSchemaRetriever this$0, MysqlBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveTableDetails(schema);
            return Unit.INSTANCE;
        }

        private static final Unit processLevel2Imp$lambda$17(MysqlSchemaRetriever this$0, MysqlBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveTriggers(schema);
            this$0.retrieveEvents(schema);
            this$0.retrieveRoutines(schema);
            return Unit.INSTANCE;
        }

        private static final Unit processLevel2Imp$lambda$18(MysqlSchemaRetriever this$0, MysqlBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveGrants(schema);
            return Unit.INSTANCE;
        }

        private static final Unit processLevel2Imp$lambda$19(MysqlSchemaRetriever this$0, MysqlBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveRoutineParameters(schema);
            return Unit.INSTANCE;
        }

        private static final Unit processLevel3Imp$lambda$20(MysqlSchemaRetriever this$0, MysqlBaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveInfoFromTableSrc();
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final Unit processLevel3Imp$lambda$22(MysqlBaseIntrospector this$0, MysqlSchemaRetriever this$1, MysqlBaseSchema schema) {
            void this_$iv$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv$iv;
            void $this$iv$iv$iv;
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            void var8_8 = this_$iv$iv;
            String name$iv$iv$iv = name$iv$iv;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this$1, schema){
                    final /* synthetic */ MysqlSchemaRetriever this$0;
                    final /* synthetic */ MysqlBaseSchema $schema$inlined;
                    {
                        this.this$0 = mysqlSchemaRetriever;
                        this.$schema$inlined = mysqlBaseSchema;
                    }

                    public final void run() {
                        boolean bl = false;
                        MysqlSchemaRetriever.access$retrieveViewSources(this.this$0, this.$schema$inlined);
                        MysqlSchemaRetriever.access$retrieveRoutineSources(this.this$0, this.$schema$inlined);
                        MysqlSchemaRetriever.access$retrieveTriggerSources(this.this$0, this.$schema$inlined);
                        MysqlSchemaRetriever.access$retrieveEventSources(this.this$0, this.$schema$inlined);
                    }
                });
                $this$iv$iv$iv = this_$iv$iv;
                sectionReference$iv$iv$iv = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv == null) return Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                void this_$iv$iv$iv2;
                sectionReference$iv$iv$iv = this_$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, sectionReference$iv$iv$iv2, null, 2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return Unit.INSTANCE;
            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder3, sectionReference$iv$iv$iv, null, 2, null);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final Unit processLevel3Imp$lambda$24(MysqlBaseIntrospector this$0, MysqlSchemaRetriever this$1, MysqlBaseSchema schema) {
            void this_$iv$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv$iv;
            void $this$iv$iv$iv;
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            void var8_8 = this_$iv$iv;
            String name$iv$iv$iv = name$iv$iv;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this$1, schema){
                    final /* synthetic */ MysqlSchemaRetriever this$0;
                    final /* synthetic */ MysqlBaseSchema $schema$inlined;
                    {
                        this.this$0 = mysqlSchemaRetriever;
                        this.$schema$inlined = mysqlBaseSchema;
                    }

                    public final void run() {
                        boolean bl = false;
                        MysqlSchemaRetriever.access$retrieveRoutineSources(this.this$0, this.$schema$inlined);
                    }
                });
                $this$iv$iv$iv = this_$iv$iv;
                sectionReference$iv$iv$iv = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv == null) return Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                void this_$iv$iv$iv2;
                sectionReference$iv$iv$iv = this_$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder2, sectionReference$iv$iv$iv2, null, 2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return Unit.INSTANCE;
            DataSourceDiagnosticRecorder.recordSectionEnd$default(dataSourceDiagnosticRecorder3, sectionReference$iv$iv$iv, null, 2, null);
            return Unit.INSTANCE;
        }

        private static final String retrieveTables$lambda$35$lambda$34$lambda$28(MysqlBaseIntroQueries.Table $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.table_name;
        }

        private static final Unit retrieveTables$lambda$35$lambda$34$lambda$32$lambda$29(MysqlBaseLikeTable $this$orCreate, MysqlBaseIntroQueries.Table it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTables$lambda$35$lambda$34$lambda$32$lambda$30(MysqlBaseLikeTable $this$orCreate, MysqlBaseIntroQueries.Table it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final ElementSearcherNN retrieveTables$lambda$35$lambda$34$lambda$32$lambda$31(ElementSearcherNN $views, ElementSearcherNN $tables, MysqlBaseIntroQueries.Table $this$chooseNN) {
            Intrinsics.checkNotNullParameter((Object)$this$chooseNN, (String)"$this$chooseNN");
            return StringsKt.contains$default((CharSequence)$this$chooseNN.table_type, (CharSequence)"VIEW", (boolean)false, (int)2, null) ? $views : $tables;
        }

        private static final Unit retrieveTables$lambda$35$lambda$34$lambda$33(ElementSearcherNN $tableSearcher, MysqlSchemaRetriever this$0, MysqlBaseSchema $schema, MysqlBaseIntroQueries.Table t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            MysqlBaseLikeTable table = (MysqlBaseLikeTable)$tableSearcher.find(t);
            this$0.applyTable($schema, table, t);
            table.setDetailsLevel(Level.L2);
            return Unit.INSTANCE;
        }

        private static final String retrievePartitions$lambda$42$lambda$41$lambda$39(MysqlBaseIntroQueries.Subpartition $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.table_name;
        }

        private static final Unit retrievePartitions$lambda$42$lambda$41$lambda$40(ElementCache $tableCache, MysqlBaseIntroQueries.Subpartition p2) {
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p");
            MysqlBaseTable mysqlBaseTable = (MysqlBaseTable)$tableCache.find(p2);
            if (mysqlBaseTable == null) {
                return Unit.INSTANCE;
            }
            MysqlBaseTable table = mysqlBaseTable;
            table.setPartitionMethod(p2.partition_method);
            table.setPartitionExpression(p2.partition_expression);
            table.setSubpartitionMethod(p2.subpartition_method);
            table.setSubpartitionExpression(p2.subpartition_expression);
            MysqlBasePartition partition = table.getPartitions().renewAt(p2.partition_ordinal_position, p2.partition_name);
            partition.setValue(p2.partition_description);
            partition.setNameSurrogate(Intrinsics.areEqual((Object)p2.partition_name, (Object)("p" + (p2.partition_ordinal_position - 1))));
            if (p2.subpartition_ordinal_position != 0) {
                MysqlBaseSubpartition subpartition = partition.getSubpartitions().renewAt(p2.subpartition_ordinal_position, p2.subpartition_name);
                subpartition.setComment(p2.partition_comment);
                subpartition.setNameSurrogate(Intrinsics.areEqual((Object)p2.subpartition_name, (Object)(p2.partition_name + "sp" + (p2.subpartition_ordinal_position - 1))));
                partition.setComment(null);
            } else {
                partition.setComment(p2.partition_comment);
            }
            return Unit.INSTANCE;
        }

        private static final String fixTableGrants$lambda$43(MysqlObjectGrant $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.getName();
        }

        private static final boolean parseCreateOptions$lambda$49(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ((CharSequence)it).length() > 0 && !StringsKt.equals((String)it, (String)"partitioned", (boolean)true);
        }

        private static final NameValue parseCreateOptions$lambda$50(String it) {
            NameValue nameValue;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            int sep = StringsKt.indexOf$default((CharSequence)it, (char)'=', (int)0, (boolean)false, (int)6, null);
            if (sep == -1) {
                nameValue = new NameValue(it, "");
            } else {
                String string = it.substring(0, sep);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                String string3 = it.substring(sep + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                nameValue = new NameValue(string2, ((Object)StringsKt.trim((CharSequence)string3)).toString());
            }
            return nameValue;
        }

        private static final String retrieveIndices$lambda$62$lambda$53(MysqlBaseIntroQueries.IndexColumn $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.table_name;
        }

        private static final String retrieveIndices$lambda$62$lambda$56$lambda$54(MysqlBaseIntroQueries.IndexColumn $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.index_name;
        }

        private static final boolean retrieveIndices$lambda$62$lambda$56$lambda$55(MysqlBaseIndex e, MysqlBaseIntroQueries.IndexColumn data) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return StringsKt.equals((String)e.getType(), (String)data.index_type, (boolean)true);
        }

        private static final ElementChecker retrieveIndices$lambda$62$lambda$56(ElementChecker $this$searchChild) {
            Intrinsics.checkNotNullParameter((Object)$this$searchChild, (String)"$this$searchChild");
            return ElementCacheOptimizersKt.byName($this$searchChild, MysqlSchemaRetriever::retrieveIndices$lambda$62$lambda$56$lambda$54).and(MysqlSchemaRetriever::retrieveIndices$lambda$62$lambda$56$lambda$55);
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveIndices$lambda$62$lambda$58$lambda$57(MysqlBaseIntrospector this$0, MysqlBaseIndex $this$orCreate, MysqlBaseIntroQueries.IndexColumn it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            v0 = $this$orCreate;
            v1 = it.index_type;
            if (v1 == null) ** GOTO lbl-1000
            var3_3 = v1;
            var5_4 = v0;
            $i$a$-let-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveIndices$1$idxSearcher$3$1$1 = false;
            v2 = StringUtil.toLowerCase((String)p0);
            v0 = var5_4;
            v1 = v2;
            if (v2 != null) {
                v3 = MysqlBaseIntrospector.access$dbIntern(this$0, v1);
            } else lbl-1000:
            // 2 sources

            {
                v3 = null;
            }
            v0.setType(v3);
            return Unit.INSTANCE;
        }

        private static final ElementSearcher retrieveIndices$lambda$62$lambda$58(MysqlBaseIntrospector this$0, ElementChecker $this$searchChild, MysqlBaseTable t) {
            Intrinsics.checkNotNullParameter((Object)$this$searchChild, (String)"$this$searchChild");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Family family = t.getIndices();
            Intrinsics.checkNotNullExpressionValue((Object)family, (String)"getIndices(...)");
            return $this$searchChild.inFamily(family).orCreate((arg_0, arg_1) -> MysqlSchemaRetriever.retrieveIndices$lambda$62$lambda$58$lambda$57(this$0, arg_0, arg_1));
        }

        private static final Unit retrieveIndices$lambda$62$lambda$59(MysqlSchemaRetriever this$0, MysqlBaseIndex idx, List cols) {
            Intrinsics.checkNotNullParameter((Object)idx, (String)"idx");
            Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
            this$0.setUpIdx(idx, cols);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveIndices$lambda$62$lambda$61$lambda$60(ElementDataCollector $this_collectAll, MysqlBaseIntroQueries.IndexColumn c2) {
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            $this_collectAll.collect(c2);
            return Unit.INSTANCE;
        }

        private static final boolean setUpIdx$lambda$70$lambda$68(MysqlBaseIntroQueries.IndexColumn it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return StringsKt.equals((String)it.collation, (String)"D", (boolean)true);
        }

        private static final String retrieveTableConstraints$lambda$87$lambda$71(MysqlBaseIntroQueries.Constraint $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.table_name;
        }

        private static final String retrieveTableConstraints$lambda$87$lambda$73$lambda$72(MysqlBaseIntroQueries.Constraint $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.constraint_name;
        }

        private static final ElementChecker retrieveTableConstraints$lambda$87$lambda$73(ElementChecker $this$searchChild) {
            Intrinsics.checkNotNullParameter((Object)$this$searchChild, (String)"$this$searchChild");
            return ElementCacheOptimizersKt.byName($this$searchChild, MysqlSchemaRetriever::retrieveTableConstraints$lambda$87$lambda$73$lambda$72);
        }

        private static final Unit retrieveTableConstraints$lambda$87$lambda$78$lambda$74(MysqlBaseConstraint $this$orCreate, MysqlBaseIntroQueries.Constraint it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTableConstraints$lambda$87$lambda$78$lambda$75(MysqlBaseConstraint $this$orCreate, MysqlBaseIntroQueries.Constraint it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTableConstraints$lambda$87$lambda$78$lambda$76(MysqlBaseConstraint $this$orCreate, MysqlBaseIntroQueries.Constraint it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final ElementSearcher retrieveTableConstraints$lambda$87$lambda$78$lambda$77(ElementSearcherNN $keys, ElementSearcherNN $foreignKeys, ElementSearcherNN $checks, MysqlBaseIntroQueries.Constraint $this$choose) {
            Intrinsics.checkNotNullParameter((Object)$this$choose, (String)"$this$choose");
            return switch ($this$choose.constraint_type) {
                case "PRIMARY KEY", "UNIQUE" -> $keys;
                case "FOREIGN KEY" -> $foreignKeys;
                case "CHECK" -> $checks;
                default -> null;
            };
        }

        private static final ElementSearcher retrieveTableConstraints$lambda$87$lambda$78(ElementChecker $this$searchChild, MysqlBaseTable t) {
            Intrinsics.checkNotNullParameter((Object)$this$searchChild, (String)"$this$searchChild");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            NamingFamily namingFamily = t.getKeys();
            Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getKeys(...)");
            ElementSearcherNN keys = $this$searchChild.inFamily(namingFamily).orCreate(MysqlSchemaRetriever::retrieveTableConstraints$lambda$87$lambda$78$lambda$74);
            NamingFamily namingFamily2 = t.getForeignKeys();
            Intrinsics.checkNotNullExpressionValue((Object)namingFamily2, (String)"getForeignKeys(...)");
            ElementSearcherNN foreignKeys = $this$searchChild.inFamily(namingFamily2).orCreate(MysqlSchemaRetriever::retrieveTableConstraints$lambda$87$lambda$78$lambda$75);
            NamingFamily namingFamily3 = t.getChecks();
            Intrinsics.checkNotNullExpressionValue((Object)namingFamily3, (String)"getChecks(...)");
            ElementSearcherNN checks2 = $this$searchChild.inFamily(namingFamily3).orCreate(MysqlSchemaRetriever::retrieveTableConstraints$lambda$87$lambda$78$lambda$76);
            return $this$searchChild.choose(arg_0 -> MysqlSchemaRetriever.retrieveTableConstraints$lambda$87$lambda$78$lambda$77(keys, foreignKeys, checks2, arg_0));
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static final Unit retrieveTableConstraints$lambda$87$lambda$82(ParentFamilySearcher $conSearcher, LinkedHashMap $fkMap, LinkedHashMap $ckMap, MysqlBaseIntroQueries.Constraint c) {
            block7: {
                block9: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                        if (((CharSequence)c.constraint_name).length() == 0) {
                            return Unit.INSTANCE;
                        }
                        v0 = (MysqlBaseConstraint)$conSearcher.find(c);
                        if (v0 == null) break block7;
                        $this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481 = var4_4 = v0;
                        $i$a$-apply-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTableConstraints$1$1$1 = false;
                        var7_7 = $this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481;
                        if (!(var7_7 instanceof MysqlBaseKey)) break block8;
                        isPk = Intrinsics.areEqual((Object)((MysqlBaseKey)$this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481).getName(), (Object)"PRIMARY");
                        ((MysqlBaseKey)$this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481).setPrimary(isPk != false || Intrinsics.areEqual((Object)c.constraint_type, (Object)"PRIMARY KEY") != false);
                        ((MysqlBaseKey)$this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481).setNameSurrogate(isPk);
                        ((MysqlBaseKey)$this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481).setUnderlyingIndexRef(BasicNameReference.create(((MysqlBaseKey)$this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481).getName()));
                        break block7;
                    }
                    if (!(var7_7 instanceof MysqlBaseForeignKey)) break block9;
                    isPk = $fkMap;
                    key$iv = c.constraint_schema;
                    $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        $i$a$-getOrPut-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTableConstraints$1$1$1$1 = false;
                        v1 = MultiMap.createLinked();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"createLinked(...)");
                        answer$iv = v1;
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        v2 /* !! */  = answer$iv;
                    } else {
                        v2 /* !! */  = value$iv;
                    }
                    ((MultiMap)v2 /* !! */ ).putValue((Object)((MysqlBaseForeignKey)$this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481).getName(), (Object)$this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481);
                    break block7;
                }
                if (!(var7_7 instanceof MysqlBaseCheck)) break block7;
                v3 = (MysqlBaseCheck)$this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481;
                $this$getOrPut$iv = ((MysqlBaseCheck)$this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481).getName();
                Intrinsics.checkNotNullExpressionValue((Object)$this$getOrPut$iv, (String)"getName(...)");
                if (StringsKt.startsWith$default((String)$this$getOrPut$iv, (String)"CONSTRAINT_", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                $this$getOrPut$iv = ((MysqlBaseCheck)$this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481).getName();
                Intrinsics.checkNotNullExpressionValue((Object)$this$getOrPut$iv, (String)"getName(...)");
                if (StringsKt.startsWith$default((String)$this$getOrPut$iv, (String)(c.table_name + "_chk_"), (boolean)false, (int)2, null)) lbl-1000:
                // 2 sources

                {
                    v4 = true;
                } else {
                    v4 = false;
                }
                v3.setNameSurrogate(v4);
                ((MysqlBaseCheck)$this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481).setDisabled(c.enforced == false);
                $this$getOrPut$iv = $ckMap;
                key$iv = c.constraint_schema;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    $i$a$-getOrPut-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveTableConstraints$1$1$1$2 = false;
                    v5 = MultiMap.createLinked();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"createLinked(...)");
                    answer$iv = v5;
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    v6 /* !! */  = answer$iv;
                } else {
                    v6 /* !! */  = value$iv;
                }
                ((MultiMap)v6 /* !! */ ).putValue((Object)((MysqlBaseCheck)$this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481).getName(), (Object)$this$retrieveTableConstraints_u24lambda_u2487_u24lambda_u2482_u24lambda_u2481);
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveForeignKeyDetails$lambda$91(MultiMap $fks, MysqlSchemaRetriever this$0, MysqlBaseIntroQueries.ForeignKey fk) {
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)fk, (String)"fk");
                    v0 = $fks.get((Object)fk.constraint_name);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(...)");
                    $this$singleOrNull$iv = v0;
                    $i$f$singleOrNull = false;
                    single$iv = null;
                    found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        it = (MysqlBaseForeignKey)element$iv;
                        $i$a$-singleOrNull-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveForeignKeyDetails$1$1 = false;
                        if (((CharSequence)fk.table_name).length() == 0) ** GOTO lbl-1000
                        v1 = it.getTable();
                        if (Intrinsics.areEqual((Object)fk.table_name, (Object)(v1 != null ? v1.getName() : null))) lbl-1000:
                        // 2 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        if (!v2) continue;
                        if (found$iv) {
                            v3 = null;
                            break block4;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v3 = found$iv == false ? null : single$iv;
                }
                v4 = v3;
                if (v4 == null) break block5;
                $this$retrieveForeignKeyDetails_u24lambda_u2491_u24lambda_u2490 = var3_3 = v4;
                $i$a$-apply-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveForeignKeyDetails$1$2 = false;
                $this$retrieveForeignKeyDetails_u24lambda_u2491_u24lambda_u2490.setOnUpdate(this$0.asCascadeRule(fk.update_rule));
                $this$retrieveForeignKeyDetails_u24lambda_u2491_u24lambda_u2490.setOnDelete(this$0.asCascadeRule(fk.delete_rule));
            }
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveCheckDetails$lambda$95(MultiMap $chks, MysqlSchemaRetriever this$0, MysqlBaseIntroQueries.CheckConstraint ck) {
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)ck, (String)"ck");
                    v0 = $chks.get((Object)ck.constraint_name);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(...)");
                    $this$singleOrNull$iv = v0;
                    $i$f$singleOrNull = false;
                    single$iv = null;
                    found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        it = (MysqlBaseCheck)element$iv;
                        $i$a$-singleOrNull-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveCheckDetails$1$1 = false;
                        if (((CharSequence)ck.table_name).length() == 0) ** GOTO lbl-1000
                        v1 = it.getTable();
                        if (Intrinsics.areEqual((Object)ck.table_name, (Object)(v1 != null ? v1.getName() : null))) lbl-1000:
                        // 2 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        if (!v2) continue;
                        if (found$iv) {
                            v3 = null;
                            break block4;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v3 = found$iv == false ? null : single$iv;
                }
                v4 = v3;
                if (v4 == null) break block5;
                it = var3_3 = v4;
                $i$a$-also-MysqlBaseIntrospector$MysqlSchemaRetriever$retrieveCheckDetails$1$2 = false;
                this$0.applyCheck(it, ck);
            }
            return Unit.INSTANCE;
        }

        private static final String retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$98(MysqlBaseIntroQueries.ConstraintColumn $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.table_name;
        }

        private static final String retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$100$lambda$99(MysqlBaseIntroQueries.ConstraintColumn $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.constraint_name;
        }

        private static final ElementChecker retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$100(ElementChecker $this$searchChild) {
            Intrinsics.checkNotNullParameter((Object)$this$searchChild, (String)"$this$searchChild");
            return ElementCacheOptimizersKt.byName($this$searchChild, MysqlSchemaRetriever::retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$100$lambda$99);
        }

        private static final Unit retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$102$lambda$101(MysqlBaseForeignKey $this$orCreate, MysqlBaseIntroQueries.ConstraintColumn it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final ElementSearcher retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$102(ElementChecker $this$searchChild, MysqlBaseTable t) {
            Intrinsics.checkNotNullParameter((Object)$this$searchChild, (String)"$this$searchChild");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            NamingFamily namingFamily = t.getForeignKeys();
            Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getForeignKeys(...)");
            return $this$searchChild.inFamily(namingFamily).orCreate(MysqlSchemaRetriever::retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$102$lambda$101);
        }

        private static final Unit retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$103(MysqlSchemaRetriever this$0, MysqlBaseForeignKey con, List cols) {
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
            this$0.setUpConstraint(con, cols);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTableConstraintColumns$lambda$107$lambda$106$lambda$105$lambda$104(ElementDataCollector $this_collectAll, MysqlBaseIntroQueries.ConstraintColumn c2) {
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            $this_collectAll.collect(c2);
            return Unit.INSTANCE;
        }

        private static final String retrieveRoutines$lambda$119$lambda$118$lambda$113(MysqlBaseIntroQueries.Routine $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.routine_name;
        }

        private static final boolean retrieveRoutines$lambda$119$lambda$118$lambda$114(MysqlBaseRoutine e, MysqlBaseIntroQueries.Routine data) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return e.getRoutineKind() == MysqlBaseIntrospectorKt.access$getType(data.routine_type);
        }

        private static final Unit retrieveRoutines$lambda$119$lambda$118$lambda$115(MysqlBaseRoutine $this$orCreate, MysqlBaseIntroQueries.Routine it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this$orCreate.setRoutineKind(MysqlBaseIntrospectorKt.access$getType(it.routine_type));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoutines$lambda$119$lambda$118$lambda$117(ElementSearcherNN $routineSearcher, MysqlBaseIntrospector this$0, MysqlSchemaRetriever this$1, MysqlBaseIntroQueries.Routine r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Object t = $routineSearcher.find(r);
            MysqlBaseRoutine $this$retrieveRoutines_u24lambda_u24119_u24lambda_u24118_u24lambda_u24117_u24lambda_u24116 = (MysqlBaseRoutine)t;
            boolean bl = false;
            if (MysqlBaseIntrospectorKt.access$getType(r.routine_type) == DasRoutine.Kind.FUNCTION) {
                BasicModArgument basicModArgument = $this$retrieveRoutines_u24lambda_u24119_u24lambda_u24118_u24lambda_u24117_u24lambda_u24116.createOrGetReturnArgument();
                Intrinsics.checkNotNullExpressionValue((Object)basicModArgument, (String)"createOrGetReturnArgument(...)");
                BasicModArgument returnArgument2 = basicModArgument;
                DataType dataType = DataTypeFactory.of(r.dtd_identifier);
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                returnArgument2.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            }
            $this$retrieveRoutines_u24lambda_u24119_u24lambda_u24118_u24lambda_u24117_u24lambda_u24116.setComment(StringKt.nullize$default((String)r.routine_comment, (boolean)false, (int)1, null));
            String string = r.definer;
            $this$retrieveRoutines_u24lambda_u24119_u24lambda_u24118_u24lambda_u24117_u24lambda_u24116.setDefiner(string != null ? this$0.dbIntern(string) : null);
            $this$retrieveRoutines_u24lambda_u24119_u24lambda_u24118_u24lambda_u24117_u24lambda_u24116.setDeterministic(r.is_deterministic);
            $this$retrieveRoutines_u24lambda_u24119_u24lambda_u24118_u24lambda_u24117_u24lambda_u24116.setSecurityDefiner(CharsKt.equals((char)r.security_type, (char)'D', (boolean)true));
            $this$retrieveRoutines_u24lambda_u24119_u24lambda_u24118_u24lambda_u24117_u24lambda_u24116.setSqlAccess(switch (r.sql_data_access) {
                case 'C' -> RoutineSqlAccess.CONTAINS_SQL;
                case 'R' -> RoutineSqlAccess.READS_SQL_DATA;
                case 'M' -> RoutineSqlAccess.MODIFIES_SQL_DATA;
                default -> RoutineSqlAccess.NO_SQL;
            });
            $this$retrieveRoutines_u24lambda_u24119_u24lambda_u24118_u24lambda_u24117_u24lambda_u24116.setDetailsLevel(Level.L2);
            this$1.touchedRoutines.add($this$retrieveRoutines_u24lambda_u24119_u24lambda_u24118_u24lambda_u24117_u24lambda_u24116);
            return Unit.INSTANCE;
        }

        private static final String retrieveRoutineParametersFromInformationSchema$lambda$123(MysqlBaseIntroQueries.Parameter $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.specific_name;
        }

        private static final Unit retrieveRoutineParametersFromInformationSchema$lambda$126$lambda$125(ElementCache $routineCache, MysqlBaseIntroQueries.Parameter p2) {
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p");
            MysqlBaseRoutine mysqlBaseRoutine = (MysqlBaseRoutine)$routineCache.find(p2);
            if (mysqlBaseRoutine == null) {
                return Unit.INSTANCE;
            }
            MysqlBaseRoutine routine2 = mysqlBaseRoutine;
            Object e = routine2.getArguments().renewAt(p2.ordinal_position, p2.parameter_name);
            MysqlBaseArgument $this$retrieveRoutineParametersFromInformationSchema_u24lambda_u24126_u24lambda_u24125_u24lambda_u24124 = (MysqlBaseArgument)e;
            boolean bl = false;
            DataType dataType = DataTypeFactory.of(p2.dtd_identifier);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            $this$retrieveRoutineParametersFromInformationSchema_u24lambda_u24126_u24lambda_u24125_u24lambda_u24124.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            $this$retrieveRoutineParametersFromInformationSchema_u24lambda_u24126_u24lambda_u24125_u24lambda_u24124.setArgumentDirection(MysqlBaseIntrospectorKt.access$getDirection(p2.parameter_mode));
            return Unit.INSTANCE;
        }

        private static final boolean shouldRetrieveTableSrc$lambda$129(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean retrieveColumnGenExprFromTableSrc$lambda$130(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final ModPositioningNamingFamily retrieveColumns$lambda$131(MysqlBaseLikeTable it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getColumns();
        }

        private static final String retrieveColumns$lambda$141$lambda$135$lambda$132(MysqlBaseIntroQueries.Column $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.table_name;
        }

        private static final Unit retrieveColumns$lambda$141$lambda$135$lambda$134(ElementCache $tableCache, MysqlSchemaRetriever this$0, MysqlBaseIntroQueries.Column c2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
                MysqlBaseLikeTable mysqlBaseLikeTable = (MysqlBaseLikeTable)$tableCache.find(c2);
                if (mysqlBaseLikeTable == null) break block0;
                MysqlBaseLikeTable table = mysqlBaseLikeTable;
                boolean bl = false;
                this$0.applyColumn(table, c2);
            }
            return Unit.INSTANCE;
        }

        private static final String retrieveColumns$lambda$141$lambda$140$lambda$136(MysqlBaseIntroQueries.AutoIncValue $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.table_name;
        }

        private static final boolean retrieveColumns$lambda$141$lambda$140$lambda$139$lambda$138$lambda$137(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Unit retrieveColumns$lambda$141$lambda$140$lambda$139(FamilySearcher $tableSearcher, MysqlBaseIntroQueries.AutoIncValue ai) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)ai, (String)"ai");
                MysqlBaseTable mysqlBaseTable = (MysqlBaseTable)$tableSearcher.find(ai);
                if (mysqlBaseTable == null) break block1;
                MysqlBaseTable table = mysqlBaseTable;
                boolean bl = false;
                MysqlBaseTableColumn mysqlBaseTableColumn = (MysqlBaseTableColumn)table.getColumns().find(arg_0 -> MysqlSchemaRetriever.retrieveColumns$lambda$141$lambda$140$lambda$139$lambda$138$lambda$137(retrieveColumns.1.2.1.1.1.INSTANCE, arg_0));
                if (mysqlBaseTableColumn != null) {
                    mysqlBaseTableColumn.setAutoIncrement(ai.auto_increment.toBigInteger());
                }
            }
            return Unit.INSTANCE;
        }

        private static final String retrieveViewSources$lambda$150$lambda$147(MysqlBaseIntroQueries.View $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.table_name;
        }

        private static final Unit retrieveViewSources$lambda$150$lambda$149(FamilySearcher $viewSearcher, ArrayList $bugged, MysqlBaseIntroQueries.View t) {
            block2: {
                MysqlBaseView mysqlBaseView;
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                MysqlBaseView mysqlBaseView2 = (MysqlBaseView)$viewSearcher.find(t);
                if (mysqlBaseView2 == null) break block2;
                MysqlBaseView $this$retrieveViewSources_u24lambda_u24150_u24lambda_u24149_u24lambda_u24148 = mysqlBaseView = mysqlBaseView2;
                boolean bl = false;
                String viewText = StringKt.nullize((String)t.view_definition, (boolean)true);
                if (viewText != null) {
                    $this$retrieveViewSources_u24lambda_u24150_u24lambda_u24149_u24lambda_u24148.setSourceText(BaseIntrospectionFunctions.toCompositeText(viewText, CompositeText.Kind.DECOMPILED_TEXT));
                    $this$retrieveViewSources_u24lambda_u24150_u24lambda_u24149_u24lambda_u24148.setDetailsLevel(Level.L3);
                } else {
                    ((Collection)$bugged).add($this$retrieveViewSources_u24lambda_u24150_u24lambda_u24149_u24lambda_u24148);
                }
            }
            return Unit.INSTANCE;
        }

        private static final String retrieveRoutineSources$lambda$156$lambda$153(MysqlBaseIntroQueries.Routine $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.routine_name;
        }

        private static final Unit retrieveRoutineSources$lambda$156$lambda$155(FamilySearcher $routineSearcher, MysqlBaseIntroQueries.Routine r) {
            block0: {
                String routineText;
                MysqlBaseRoutine mysqlBaseRoutine;
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                MysqlBaseRoutine mysqlBaseRoutine2 = (MysqlBaseRoutine)$routineSearcher.find(r);
                if (mysqlBaseRoutine2 == null) break block0;
                MysqlBaseRoutine $this$retrieveRoutineSources_u24lambda_u24156_u24lambda_u24155_u24lambda_u24154 = mysqlBaseRoutine = mysqlBaseRoutine2;
                boolean bl = false;
                String string = routineText = StringKt.nullize((String)r.routine_definition, (boolean)true);
                $this$retrieveRoutineSources_u24lambda_u24156_u24lambda_u24155_u24lambda_u24154.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT) : null);
                $this$retrieveRoutineSources_u24lambda_u24156_u24lambda_u24155_u24lambda_u24154.setDetailsLevel(Level.L3);
            }
            return Unit.INSTANCE;
        }

        private static final String retrieveTriggerSources$lambda$163$lambda$160(MysqlBaseIntroQueries.Trigger $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.event_object_table;
        }

        private static final Unit retrieveTriggerSources$lambda$163$lambda$162(ElementCache $tableCache, MysqlBaseIntroQueries.Trigger t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            MysqlBaseTable mysqlBaseTable = (MysqlBaseTable)$tableCache.find(t);
            if (mysqlBaseTable == null) {
                return Unit.INSTANCE;
            }
            MysqlBaseTable table = mysqlBaseTable;
            MysqlBaseTrigger mysqlBaseTrigger = (MysqlBaseTrigger)table.getTriggers().get(t.trigger_name);
            if (mysqlBaseTrigger != null) {
                String triggerText;
                MysqlBaseTrigger mysqlBaseTrigger2;
                MysqlBaseTrigger $this$retrieveTriggerSources_u24lambda_u24163_u24lambda_u24162_u24lambda_u24161 = mysqlBaseTrigger2 = mysqlBaseTrigger;
                boolean bl = false;
                String string = triggerText = StringKt.nullize((String)t.action_statement, (boolean)true);
                $this$retrieveTriggerSources_u24lambda_u24163_u24lambda_u24162_u24lambda_u24161.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT) : null);
            }
            table.setDetailsLevel(Level.L3);
            return Unit.INSTANCE;
        }

        private static final String retrieveEventSources$lambda$168$lambda$165(MysqlBaseIntroQueries.Event $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.event_name;
        }

        private static final Unit retrieveEventSources$lambda$168$lambda$167(FamilySearcher $eventsSearcher, MysqlBaseIntroQueries.Event e) {
            block0: {
                String eventText;
                MysqlBaseEvent mysqlBaseEvent;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MysqlBaseEvent mysqlBaseEvent2 = (MysqlBaseEvent)$eventsSearcher.find(e);
                if (mysqlBaseEvent2 == null) break block0;
                MysqlBaseEvent $this$retrieveEventSources_u24lambda_u24168_u24lambda_u24167_u24lambda_u24166 = mysqlBaseEvent = mysqlBaseEvent2;
                boolean bl = false;
                String string = eventText = StringKt.nullize((String)e.event_definition, (boolean)true);
                $this$retrieveEventSources_u24lambda_u24168_u24lambda_u24167_u24lambda_u24166.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT) : null);
                $this$retrieveEventSources_u24lambda_u24168_u24lambda_u24167_u24lambda_u24166.setDetailsLevel(Level.L3);
            }
            return Unit.INSTANCE;
        }

        private static final String retrieveTriggers$lambda$187$lambda$185$lambda$178(MysqlBaseIntroQueries.Trigger $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.event_object_table;
        }

        private static final String retrieveTriggers$lambda$187$lambda$185$lambda$180$lambda$179(MysqlBaseIntroQueries.Trigger $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.trigger_name;
        }

        private static final ElementChecker retrieveTriggers$lambda$187$lambda$185$lambda$180(ElementChecker $this$searchChild) {
            Intrinsics.checkNotNullParameter((Object)$this$searchChild, (String)"$this$searchChild");
            return ElementCacheOptimizersKt.byName($this$searchChild, MysqlSchemaRetriever::retrieveTriggers$lambda$187$lambda$185$lambda$180$lambda$179);
        }

        private static final Unit retrieveTriggers$lambda$187$lambda$185$lambda$182$lambda$181(MysqlBaseTrigger $this$orCreate, MysqlBaseIntroQueries.Trigger it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final ElementSearcher retrieveTriggers$lambda$187$lambda$185$lambda$182(ElementChecker $this$searchChild, MysqlBaseTable t) {
            Intrinsics.checkNotNullParameter((Object)$this$searchChild, (String)"$this$searchChild");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            ModNamingFamily<? extends MysqlBaseTrigger> modNamingFamily = t.getTriggers();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTriggers(...)");
            return $this$searchChild.inFamily((Family)modNamingFamily).orCreate(MysqlSchemaRetriever::retrieveTriggers$lambda$187$lambda$185$lambda$182$lambda$181);
        }

        private static final Unit retrieveTriggers$lambda$187$lambda$185$lambda$184(ParentFamilySearcher $triggerSearcher, MysqlBaseIntrospector this$0, MysqlBaseIntroQueries.Trigger t) {
            block0: {
                MysqlBaseTrigger mysqlBaseTrigger;
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                MysqlBaseTrigger mysqlBaseTrigger2 = (MysqlBaseTrigger)$triggerSearcher.find(t);
                if (mysqlBaseTrigger2 == null) break block0;
                MysqlBaseTrigger $this$retrieveTriggers_u24lambda_u24187_u24lambda_u24185_u24lambda_u24184_u24lambda_u24183 = mysqlBaseTrigger = mysqlBaseTrigger2;
                boolean bl = false;
                $this$retrieveTriggers_u24lambda_u24187_u24lambda_u24185_u24lambda_u24184_u24lambda_u24183.setTurn(StringsKt.equals((String)t.action_timing, (String)"before", (boolean)true) ? TrigTurn.BEFORE_ROW : TrigTurn.AFTER_ROW);
                $this$retrieveTriggers_u24lambda_u24187_u24lambda_u24185_u24lambda_u24184_u24lambda_u24183.setEvents(SetsKt.setOf((Object)((Object)MysqlBaseIntrospectorKt.access$getEvent(t.event_manipulation))));
                String string = t.definer;
                $this$retrieveTriggers_u24lambda_u24187_u24lambda_u24185_u24lambda_u24184_u24lambda_u24183.setDefiner(string != null ? this$0.dbIntern(string) : null);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoutineGrants$lambda$189$lambda$188(MysqlBaseIntrospector this$0, List $newGrants, MysqlBaseIntroQueries.RoutineGrant g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            ObjectKind kind = MysqlObjectGrantController.INSTANCE.asObjectKind(g.is_proc ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.FUNCTION);
            this$0.appendPrivilege($newGrants, new MysqlObjectGrant(g.Routine_name, kind, null, g.User, g.Host, g.Proc_priv, Grants.State.GRANT), false);
            return Unit.INSTANCE;
        }

        private static final String retrieveColumnGrants$lambda$194$lambda$190(MysqlBaseIntroQueries.ColumnGrant $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.table_name;
        }

        private static final Unit retrieveColumnGrants$lambda$194$lambda$193(Ref.ObjectRef $key, Ref.ObjectRef $priv, MysqlBaseIntrospector this$0, List $newGrants, BitSet $cols, Ref.BooleanRef $isGrantable, ElementCache $tab, MysqlBaseIntroQueries.ColumnGrant g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Object[] objectArray = new String[]{g.table_name, g.grantee, g.privilege_type};
            List newKey = CollectionsKt.listOf((Object[])objectArray);
            if (!Intrinsics.areEqual((Object)newKey, (Object)$key.element) && $priv.element != null) {
                Object object = $priv.element;
                Intrinsics.checkNotNull((Object)object);
                MysqlObjectGrant mysqlObjectGrant = (MysqlObjectGrant)object;
                Object object2 = $priv.element;
                Intrinsics.checkNotNull((Object)object2);
                this$0.appendPrivilege($newGrants, MysqlObjectGrantController.INSTANCE.withPermission(mysqlObjectGrant, ((MysqlObjectGrant)object2).getPermission(), $cols, Grants.State.GRANT), $isGrantable.element);
                $priv.element = null;
                $cols.clear();
                $isGrantable.element = false;
                $key.element = newKey;
            }
            if ($priv.element == null) {
                String string = g.table_name;
                ObjectKind objectKind = ObjectKind.NONE;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"NONE");
                $priv.element = this$0.createPrivilege(string, objectKind, g.grantee, g.privilege_type);
            }
            MysqlBaseLikeTable mysqlBaseLikeTable = (MysqlBaseLikeTable)$tab.find(g);
            if (mysqlBaseLikeTable != null) {
                MysqlBaseLikeTable mysqlBaseLikeTable2;
                MysqlBaseLikeTable $this$retrieveColumnGrants_u24lambda_u24194_u24lambda_u24193_u24lambda_u24192 = mysqlBaseLikeTable2 = mysqlBaseLikeTable;
                boolean bl = false;
                MysqlBaseLikeColumn mysqlBaseLikeColumn = (MysqlBaseLikeColumn)$this$retrieveColumnGrants_u24lambda_u24194_u24lambda_u24193_u24lambda_u24192.getColumns().get(g.column_name);
                if (mysqlBaseLikeColumn != null) {
                    short it = ((BasicModTableOrViewColumn)mysqlBaseLikeColumn).getPosition();
                    boolean bl2 = false;
                    $cols.set(it);
                }
            }
            $isGrantable.element = $isGrantable.element || StringsKt.equals((String)g.is_grantable, (String)"yes", (boolean)true);
            return Unit.INSTANCE;
        }

        private static final String retrieveEvents$lambda$202$lambda$201$lambda$195(MysqlBaseIntroQueries.Event $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.event_name;
        }

        private static final Unit retrieveEvents$lambda$202$lambda$201$lambda$196(MysqlBaseEvent $this$orCreate, MysqlBaseIntroQueries.Event it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveEvents$lambda$202$lambda$201$lambda$200(ElementSearcherNN $eventSearcher, MysqlBaseIntrospector this$0, MysqlSchemaRetriever this$1, MysqlBaseIntroQueries.Event e) {
            String string;
            MysqlBaseEvent mysqlBaseEvent;
            MysqlBaseEvent $this$retrieveEvents_u24lambda_u24202_u24lambda_u24201_u24lambda_u24200_u24lambda_u24199;
            block10: {
                block7: {
                    Object object;
                    MysqlBaseEvent mysqlBaseEvent2;
                    block9: {
                        void it;
                        block8: {
                            String string2;
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            Object t = $eventSearcher.find(e);
                            $this$retrieveEvents_u24lambda_u24202_u24lambda_u24201_u24lambda_u24200_u24lambda_u24199 = (MysqlBaseEvent)t;
                            boolean bl = false;
                            $this$retrieveEvents_u24lambda_u24202_u24lambda_u24201_u24lambda_u24200_u24lambda_u24199.setComment(e.event_comment);
                            String string3 = e.definer;
                            $this$retrieveEvents_u24lambda_u24202_u24lambda_u24201_u24lambda_u24200_u24lambda_u24199.setDefiner(string3 != null ? this$0.dbIntern(string3) : null);
                            if (e.recurring) {
                                string2 = e.interval_value;
                                if (string2 == null || (string2 = MysqlBaseIntrospectorKt.access$getSqlString(string2)) == null) {
                                    string2 = "";
                                }
                            } else {
                                string2 = null;
                            }
                            String ivl = string2;
                            mysqlBaseEvent = $this$retrieveEvents_u24lambda_u24202_u24lambda_u24201_u24lambda_u24200_u24lambda_u24199;
                            String string4 = ivl;
                            if (string4 == null) break block7;
                            String string5 = string4;
                            mysqlBaseEvent2 = mysqlBaseEvent;
                            boolean bl2 = false;
                            object = e.interval_field;
                            if (object == null) break block8;
                            String f = object;
                            boolean bl3 = false;
                            String string6 = (String)it + " " + f;
                            object = string6;
                            if (string6 != null) break block9;
                        }
                        object = it;
                    }
                    string = object;
                    mysqlBaseEvent = mysqlBaseEvent2;
                    break block10;
                }
                string = null;
            }
            mysqlBaseEvent.setInterval(string);
            String string7 = e.starts;
            $this$retrieveEvents_u24lambda_u24202_u24lambda_u24201_u24lambda_u24200_u24lambda_u24199.setStarts(string7 != null ? MysqlBaseIntrospectorKt.access$getSqlString(string7) : null);
            String string8 = e.ends;
            $this$retrieveEvents_u24lambda_u24202_u24lambda_u24201_u24lambda_u24200_u24lambda_u24199.setEnds(string8 != null ? MysqlBaseIntrospectorKt.access$getSqlString(string8) : null);
            $this$retrieveEvents_u24lambda_u24202_u24lambda_u24201_u24lambda_u24200_u24lambda_u24199.setPreserve(Intrinsics.areEqual((Object)e.preserve, (Object)true));
            $this$retrieveEvents_u24lambda_u24202_u24lambda_u24201_u24lambda_u24200_u24lambda_u24199.setStatus(this$1.getEventStatus(e.status));
            $this$retrieveEvents_u24lambda_u24202_u24lambda_u24201_u24lambda_u24200_u24lambda_u24199.setLastExecuted(e.last_executed);
            $this$retrieveEvents_u24lambda_u24202_u24lambda_u24201_u24lambda_u24200_u24lambda_u24199.setDetailsLevel(Level.L2);
            this$1.touchedEvents.add($this$retrieveEvents_u24lambda_u24202_u24lambda_u24201_u24lambda_u24200_u24lambda_u24199);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$retrieveTriggerSources(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveTriggerSources(schema);
        }

        public static final /* synthetic */ void access$retrieveViewSources(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveViewSources(schema);
        }

        public static final /* synthetic */ void access$retrieveRoutineSources(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveRoutineSources(schema);
        }

        public static final /* synthetic */ void access$retrieveEventSources(MysqlSchemaRetriever $this, MysqlBaseSchema schema) {
            $this.retrieveEventSources(schema);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\b\u0084\u0004\u0018\u00002\u00120\u0001R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0002J!\u0010\n\u001a\u00020\b2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlServerObjectsRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseServerObjectsRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "<init>", "(Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;)V", "retrieveAuxiliaryObjects", "", "retrieveCollations", "retrieveUsers", "userNames", "", "", "retrieveUsers$intellij_database_dialects_mysqlbase", "([Ljava/lang/String;)V", "retrieveUsersAndGrants", "tran", "r", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoot;)V", "retrieveRoleGrants", "intellij.database.dialects.mysqlbase"})
    @SourceDebugExtension(value={"SMAP\nMysqlBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlBaseIntrospector.kt\ncom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlServerObjectsRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ElementCache.kt\ncom/intellij/database/model/ElementDataCollector\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1600:1\n178#2,8:1601\n301#2,2:1609\n198#2,5:1611\n204#2,5:1635\n303#2,24:1640\n178#2,5:1725\n183#2,3:1749\n519#3:1616\n500#3,18:1617\n519#3:1664\n500#3,18:1665\n519#3:1683\n500#3,18:1684\n519#3:1704\n500#3,2:1705\n503#3,15:1710\n519#3:1730\n500#3,18:1731\n1869#4,2:1702\n1563#4:1753\n1634#4,3:1754\n114#5,3:1707\n1#6:1752\n*S KotlinDebug\n*F\n+ 1 MysqlBaseIntrospector.kt\ncom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntrospector$MysqlServerObjectsRetriever\n*L\n438#1:1601,8\n464#1:1609,2\n464#1:1611,5\n464#1:1635,5\n464#1:1640,24\n446#1:1725,5\n446#1:1749,3\n466#1:1616\n466#1:1617,18\n497#1:1664\n497#1:1665,18\n508#1:1683\n508#1:1684,18\n519#1:1704\n519#1:1705,2\n519#1:1710,15\n451#1:1730\n451#1:1731,18\n517#1:1702,2\n525#1:1753\n525#1:1754,3\n530#1:1707,3\n*E\n"})
    protected final class MysqlServerObjectsRetriever
    extends BaseSingleDatabaseIntrospector.BaseServerObjectsRetriever {
        public MysqlServerObjectsRetriever(DBTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            super(transaction);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void retrieveAuxiliaryObjects() {
            void $this$modifyAndCleanup_u24default$iv;
            this.retrieveCollations();
            MysqlServerObjectsRetriever.retrieveUsers$intellij_database_dialects_mysqlbase$default(this, null, 1, null);
            ModFamily modFamily = MysqlBaseIntrospector.access$getRoot(MysqlBaseIntrospector.this).getUsers();
            MysqlBaseIntrospector mysqlBaseIntrospector = MysqlBaseIntrospector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily users = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            this.retrieveUsersAndGrants(this.getTransaction(), MysqlBaseIntrospector.access$getRoot(mysqlBaseIntrospector));
            this.retrieveRoleGrants(this.getTransaction(), MysqlBaseIntrospector.access$getRoot(mysqlBaseIntrospector));
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        private final void retrieveCollations() {
            MysqlBaseIntrospector.this.inModel(arg_0 -> MysqlServerObjectsRetriever.retrieveCollations$lambda$7(MysqlBaseIntrospector.this, this, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        public final void retrieveUsers$intellij_database_dialects_mysqlbase(@Nullable String[] userNames) {
            void fragments$iv;
            boolean bl = true;
            ModNamingFamily[] modNamingFamilyArray = new ModNamingFamily[1];
            Intrinsics.checkNotNullExpressionValue(MysqlBaseIntrospector.access$getRoot(MysqlBaseIntrospector.this).getUsers(), (String)"getUsers(...)");
            String[] stringArray = userNames;
            MysqlBaseIntrospector mysqlBaseIntrospector = MysqlBaseIntrospector.this;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            if (fragments$iv == null) {
                void families$iv$iv;
                void removeUnaffected$iv;
                ModFamily[] modFamilyArray = (ModFamily[])Arrays.copyOf(families$iv, ((void)families$iv).length);
                void removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyFamiliesAndCleanup2 = false;
                for (void f$iv$iv : families$iv$iv) {
                    f$iv$iv.markChildrenAsSyncPending();
                }
                boolean bl2 = false;
                ModNamingFamily<? extends MysqlBaseUser> modNamingFamily = MysqlBaseIntrospector.access$getRoot(mysqlBaseIntrospector).getUsers();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getUsers(...)");
                ModNamingFamily<? extends MysqlBaseUser> users = modNamingFamily;
                BaseNativeIntrospector this_$iv = mysqlBaseIntrospector;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector baseNativeIntrospector = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError2 = false;
                try {
                    boolean bl3 = false;
                    ElementSearcherNN userSearcher = ElementCacheOptimizersKt.byName(mysqlBaseIntrospector.searchInRoot(), MysqlServerObjectsRetriever::retrieveUsers$lambda$16$lambda$15$lambda$8).and(MysqlServerObjectsRetriever::retrieveUsers$lambda$16$lambda$15$lambda$9).inFamily((Family)users).orCreate(MysqlServerObjectsRetriever::retrieveUsers$lambda$16$lambda$15$lambda$10);
                    mysqlBaseIntrospector.getQueries().processUsers(this.getTransaction(), MysqlBaseIntrospector.access$getRoot(mysqlBaseIntrospector), userNames, (Function1<? super MysqlBaseIntroQueries.User, Unit>)((Function1)arg_0 -> MysqlServerObjectsRetriever.retrieveUsers$lambda$16$lambda$15$lambda$14(userSearcher, arg_0)));
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    void this_$iv$iv;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl4 = false;
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                for (void f$iv$iv : families$iv$iv) {
                    f$iv$iv.removeSyncPendingChildren();
                    f$iv$iv.sort();
                }
            } else {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])fragments$iv);
                block6: while (iterator.hasNext()) {
                    String fragment$iv = (String)iterator.next();
                    int n = ((void)families$iv).length;
                    for (int $i$f$modifyFamiliesAndCleanup2 = 0; $i$f$modifyFamiliesAndCleanup2 < n; ++$i$f$modifyFamiliesAndCleanup2) {
                        void family$iv = families$iv[$i$f$modifyFamiliesAndCleanup2];
                        BasicModNamedElement o$iv = (BasicModNamedElement)family$iv.get(fragment$iv);
                        if (o$iv == null) continue;
                        o$iv.setSyncPending(true);
                        continue block6;
                    }
                }
                boolean bl5 = false;
                ModNamingFamily<? extends MysqlBaseUser> modNamingFamily = MysqlBaseIntrospector.access$getRoot(mysqlBaseIntrospector).getUsers();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getUsers(...)");
                ModNamingFamily<? extends MysqlBaseUser> users = modNamingFamily;
                BaseNativeIntrospector this_$iv = mysqlBaseIntrospector;
                boolean $i$f$continueOnDbError = false;
                BaseNativeIntrospector this_$iv$iv = this_$iv;
                Object whatsDoing$iv$iv = null;
                boolean $i$f$continueOnDbError3 = false;
                try {
                    boolean bl6 = false;
                    ElementSearcherNN userSearcher = ElementCacheOptimizersKt.byName(mysqlBaseIntrospector.searchInRoot(), MysqlServerObjectsRetriever::retrieveUsers$lambda$16$lambda$15$lambda$8).and(MysqlServerObjectsRetriever::retrieveUsers$lambda$16$lambda$15$lambda$9).inFamily((Family)users).orCreate(MysqlServerObjectsRetriever::retrieveUsers$lambda$16$lambda$15$lambda$10);
                    mysqlBaseIntrospector.getQueries().processUsers(this.getTransaction(), MysqlBaseIntrospector.access$getRoot(mysqlBaseIntrospector), userNames, (Function1<? super MysqlBaseIntroQueries.User, Unit>)((Function1)arg_0 -> MysqlServerObjectsRetriever.retrieveUsers$lambda$16$lambda$15$lambda$14(userSearcher, arg_0)));
                }
                catch (DBException e$iv$iv) {
                    StringBuilder stringBuilder;
                    boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException(this_$iv$iv, e$iv$iv);
                    StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                    boolean bl7 = false;
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                    $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                    String message$iv$iv = stringBuilder.toString();
                    if (expected$iv$iv) {
                        this_$iv$iv.trace(message$iv$iv);
                    } else {
                        IntrospectionQueryContext.logWarn$default(this_$iv$iv, message$iv$iv, null, 2, null);
                    }
                    this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
                }
                for (void family$iv : families$iv) {
                    family$iv.removeSyncPendingChildren();
                    family$iv.sort();
                }
            }
        }

        public static /* synthetic */ void retrieveUsers$intellij_database_dialects_mysqlbase$default(MysqlServerObjectsRetriever mysqlServerObjectsRetriever, String[] stringArray, int n, Object object) {
            if ((n & 1) != 0) {
                stringArray = null;
            }
            mysqlServerObjectsRetriever.retrieveUsers$intellij_database_dialects_mysqlbase(stringArray);
        }

        private final void retrieveUsersAndGrants(DBTransaction tran, R r) {
            BaseNativeIntrospector this_$iv$iv;
            BaseNativeIntrospector this_$iv;
            ArrayList newGrants = new ArrayList();
            BaseNativeIntrospector baseNativeIntrospector = MysqlBaseIntrospector.this;
            MysqlBaseIntrospector mysqlBaseIntrospector = MysqlBaseIntrospector.this;
            boolean $i$f$continueOnDbError = false;
            void var7_7 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                ElementChecker elementChecker = ElementCacheOptimizersKt.byName(mysqlBaseIntrospector.searchInRoot(), MysqlServerObjectsRetriever::retrieveUsersAndGrants$lambda$21$lambda$17).and(MysqlServerObjectsRetriever::retrieveUsersAndGrants$lambda$21$lambda$18);
                ModNamingFamily<? extends MysqlBaseUser> modNamingFamily = r.getUsers();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getUsers(...)");
                ElementSearcherNN userSearcher = elementChecker.inFamily((Family)modNamingFamily).orCreate(MysqlServerObjectsRetriever::retrieveUsersAndGrants$lambda$21$lambda$19);
                mysqlBaseIntrospector.getQueries().processServerGrants(tran, (Function1<? super MysqlBaseIntroQueries.SchemaGrant, Unit>)((Function1)arg_0 -> MysqlServerObjectsRetriever.retrieveUsersAndGrants$lambda$21$lambda$20(mysqlBaseIntrospector, userSearcher, newGrants, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException(this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default(this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            this_$iv = MysqlBaseIntrospector.this;
            mysqlBaseIntrospector = MysqlBaseIntrospector.this;
            $i$f$continueOnDbError = false;
            this_$iv$iv = this_$iv;
            whatsDoing$iv$iv = null;
            $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                mysqlBaseIntrospector.getQueries().processSchemaGrants(tran, (Function1<? super MysqlBaseIntroQueries.SchemaGrant, Unit>)((Function1)arg_0 -> MysqlServerObjectsRetriever.retrieveUsersAndGrants$lambda$23$lambda$22(mysqlBaseIntrospector, newGrants, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException(this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default(this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            ((MysqlBaseGrantsHolder)r).setGrants(((MysqlBaseGrantsHolder)r).getGrants().with(newGrants));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoleGrants(DBTransaction tran, R r) {
            void this_$iv;
            int[] nArray;
            Object element$iv;
            ModNamingFamily<? extends MysqlBaseUser> modNamingFamily = r.getUsers();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getUsers(...)");
            Object $this$forEach$iv = modNamingFamily;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                MysqlBaseUser it = (MysqlBaseUser)element$iv;
                boolean bl = false;
                it.setRoleGrants(CollectionsKt.emptyList());
            }
            Version version = MysqlBaseUtils.getMysqlMatchingVersion(MysqlBaseIntrospector.this.dbms, ((BasicRoot)r).getServerVersion());
            if (!(version != null ? version.isOrGreater(nArray = new int[]{8}) : false)) {
                return;
            }
            $this$forEach$iv = MysqlBaseIntrospector.this;
            MysqlBaseIntrospector mysqlBaseIntrospector = MysqlBaseIntrospector.this;
            boolean $i$f$continueOnDbError = false;
            element$iv = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                void this_$iv2;
                boolean bl = false;
                ElementChecker elementChecker = ElementCacheOptimizersKt.byName(mysqlBaseIntrospector.searchInRoot(), MysqlServerObjectsRetriever::retrieveRoleGrants$lambda$33$lambda$25).and(MysqlServerObjectsRetriever::retrieveRoleGrants$lambda$33$lambda$26);
                ModNamingFamily<? extends MysqlBaseUser> modNamingFamily2 = r.getUsers();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getUsers(...)");
                ElementSearcherNN userSearcher = elementChecker.inFamily((Family)modNamingFamily2).orCreate(MysqlServerObjectsRetriever::retrieveRoleGrants$lambda$33$lambda$27);
                ElementDataCollector elementDataCollector = userSearcher.adapt(arg_0 -> MysqlServerObjectsRetriever.retrieveRoleGrants$lambda$33$lambda$28(mysqlBaseIntrospector, arg_0)).collector((arg_0, arg_1) -> MysqlServerObjectsRetriever.retrieveRoleGrants$lambda$33$lambda$30(mysqlBaseIntrospector, userSearcher, arg_0, arg_1));
                boolean $i$f$collectAll = false;
                void $this$retrieveRoleGrants_u24lambda_u2433_u24lambda_u2432 = this_$iv2;
                boolean bl2 = false;
                mysqlBaseIntrospector.getQueries().processRoleGrants(tran, (MysqlBaseRoot)r, (Function1<? super MysqlBaseIntroQueries.RoleGrant, Unit>)((Function1)arg_0 -> MysqlServerObjectsRetriever.retrieveRoleGrants$lambda$33$lambda$32$lambda$31((ElementDataCollector)$this$retrieveRoleGrants_u24lambda_u2433_u24lambda_u2432, arg_0)));
                this_$iv2.finish();
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        private static final String retrieveCollations$lambda$7$lambda$6$lambda$1(MysqlBaseIntroQueries.Collation $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.collation_name;
        }

        private static final Unit retrieveCollations$lambda$7$lambda$6$lambda$2(MysqlBaseCollation $this$orCreate, MysqlBaseIntroQueries.Collation it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final Unit retrieveCollations$lambda$7$lambda$6$lambda$5$lambda$4(ElementSearcherNN $collationSearcher, MysqlBaseIntrospector this$0, MysqlBaseIntroQueries.Collation c2) {
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            Object t = $collationSearcher.find(c2);
            MysqlBaseCollation $this$retrieveCollations_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243 = (MysqlBaseCollation)t;
            boolean bl = false;
            String string = c2.character_set_name;
            $this$retrieveCollations_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243.setCharset(string != null ? this$0.dbIntern(string) : null);
            $this$retrieveCollations_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244_u24lambda_u243.setDefaultForCharset(c2.is_default);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveCollations$lambda$7(MysqlBaseIntrospector this$0, MysqlServerObjectsRetriever this$1, MysqlBaseRoot root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            ModFamily $this$modifyAndCleanup_u24default$iv = root.getCollations();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily collations = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            ElementChecker elementChecker = ElementCacheOptimizersKt.byName(this$0.searchInRoot(), MysqlServerObjectsRetriever::retrieveCollations$lambda$7$lambda$6$lambda$1);
            Intrinsics.checkNotNull((Object)collations);
            ElementSearcherNN collationSearcher = elementChecker.inFamily(collations).orCreate(MysqlServerObjectsRetriever::retrieveCollations$lambda$7$lambda$6$lambda$2);
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                this$0.getQueries().processCollations(this$1.getTransaction(), (Function1<? super MysqlBaseIntroQueries.Collation, Unit>)((Function1)arg_0 -> MysqlServerObjectsRetriever.retrieveCollations$lambda$7$lambda$6$lambda$5$lambda$4(collationSearcher, this$0, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }

        private static final String retrieveUsers$lambda$16$lambda$15$lambda$8(MysqlBaseIntroQueries.User $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return $this$byName.User;
        }

        private static final boolean retrieveUsers$lambda$16$lambda$15$lambda$9(MysqlBaseUser e, MysqlBaseIntroQueries.User data) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return Intrinsics.areEqual((Object)e.getHost(), (Object)MysqlRoleGrantKt.nullizeHost(data.Host));
        }

        private static final Unit retrieveUsers$lambda$16$lambda$15$lambda$10(MysqlBaseUser $this$orCreate, MysqlBaseIntroQueries.User it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this$orCreate.setHost(MysqlRoleGrantKt.nullizeHost(it.Host));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveUsers$lambda$16$lambda$15$lambda$14(ElementSearcherNN $userSearcher, MysqlBaseIntroQueries.User u) {
            String string;
            String it;
            Intrinsics.checkNotNullParameter((Object)u, (String)"u");
            Object t = $userSearcher.find(u);
            MysqlBaseUser $this$retrieveUsers_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413 = (MysqlBaseUser)t;
            boolean bl = false;
            $this$retrieveUsers_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setSslCipher(StringKt.nullize$default((String)u.ssl_cipher, (boolean)false, (int)1, null));
            String string2 = StringKt.nullize$default((String)u.ssl_type, (boolean)false, (int)1, null);
            MysqlBaseUser mysqlBaseUser = $this$retrieveUsers_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413;
            boolean bl2 = false;
            mysqlBaseUser.setSslType(it == null ? MysqlSslType.NONE : (StringsKt.equals((String)it, (String)"x509", (boolean)true) ? MysqlSslType.X509 : MysqlSslType.SSL));
            $this$retrieveUsers_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setX509Issuer(StringKt.nullize$default((String)u.x509_issuer, (boolean)false, (int)1, null));
            $this$retrieveUsers_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setX509Subject(StringKt.nullize$default((String)u.x509_subject, (boolean)false, (int)1, null));
            $this$retrieveUsers_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setCanLogin(!Intrinsics.areEqual((Object)u.is_role, (Object)"Y"));
            it = string = u.plugin;
            mysqlBaseUser = $this$retrieveUsers_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413;
            boolean bl3 = false;
            mysqlBaseUser.setPlugin(Boolean.valueOf(!Intrinsics.areEqual((Object)it, (Object)"mysql_native_password")) != false ? string : null);
            Integer n = StringsKt.toIntOrNull((String)u.max_connections);
            $this$retrieveUsers_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setMaxConnections(n != null ? n : 0);
            Integer n2 = StringsKt.toIntOrNull((String)u.max_questions);
            $this$retrieveUsers_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setMaxQuestions(n2 != null ? n2 : 0);
            Integer n3 = StringsKt.toIntOrNull((String)u.max_updates);
            $this$retrieveUsers_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setMaxUpdates(n3 != null ? n3 : 0);
            Integer n4 = StringsKt.toIntOrNull((String)u.max_user_connections);
            $this$retrieveUsers_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setMaxUserConnections(n4 != null ? n4 : 0);
            return Unit.INSTANCE;
        }

        private static final String retrieveUsersAndGrants$lambda$21$lambda$17(Pair $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return (String)$this$byName.getFirst();
        }

        private static final boolean retrieveUsersAndGrants$lambda$21$lambda$18(MysqlBaseUser e, Pair data) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return Intrinsics.areEqual((Object)e.getHost(), (Object)MysqlRoleGrantKt.nullizeHost((String)data.getSecond()));
        }

        private static final Unit retrieveUsersAndGrants$lambda$21$lambda$19(MysqlBaseUser $this$orCreate, Pair it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this$orCreate.setHost(MysqlRoleGrantKt.nullizeHost((String)it.getSecond()));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveUsersAndGrants$lambda$21$lambda$20(MysqlBaseIntrospector this$0, ElementSearcherNN $userSearcher, ArrayList $newGrants, MysqlBaseIntroQueries.SchemaGrant g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Pair gh = MysqlBaseIntrospector.splitUser$default(this$0, g.grantee, null, 2, null);
            $userSearcher.find(gh);
            List list = $newGrants;
            ObjectKind objectKind = ObjectKind.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROOT");
            this$0.appendPrivilege(list, "", objectKind, g.grantee, g.privilege_type, g.is_grantable);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveUsersAndGrants$lambda$23$lambda$22(MysqlBaseIntrospector this$0, ArrayList $newGrants, MysqlBaseIntroQueries.SchemaGrant g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            List list = $newGrants;
            String string = g.table_schema;
            ObjectKind objectKind = ObjectKind.SCHEMA;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SCHEMA");
            this$0.appendPrivilege(list, string, objectKind, g.grantee, g.privilege_type, g.is_grantable);
            return Unit.INSTANCE;
        }

        private static final String retrieveRoleGrants$lambda$33$lambda$25(Pair $this$byName) {
            Intrinsics.checkNotNullParameter((Object)$this$byName, (String)"$this$byName");
            return (String)$this$byName.getFirst();
        }

        private static final boolean retrieveRoleGrants$lambda$33$lambda$26(MysqlBaseUser e, Pair data) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return Intrinsics.areEqual((Object)e.getHost(), (Object)MysqlRoleGrantKt.nullizeHost((String)data.getSecond()));
        }

        private static final Unit retrieveRoleGrants$lambda$33$lambda$27(MysqlBaseUser $this$orCreate, Pair it) {
            Intrinsics.checkNotNullParameter((Object)$this$orCreate, (String)"$this$orCreate");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $this$orCreate.setHost(MysqlRoleGrantKt.nullizeHost((String)it.getSecond()));
            return Unit.INSTANCE;
        }

        private static final Pair retrieveRoleGrants$lambda$33$lambda$28(MysqlBaseIntrospector this$0, MysqlBaseIntroQueries.RoleGrant $this$adapt) {
            Intrinsics.checkNotNullParameter((Object)$this$adapt, (String)"$this$adapt");
            return this$0.splitUser($this$adapt.to_user, $this$adapt.to_host);
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveRoleGrants$lambda$33$lambda$30(MysqlBaseIntrospector this$0, ElementSearcherNN $userSearcher, MysqlBaseUser grantee, List grants) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)grantee, (String)"grantee");
            Intrinsics.checkNotNullParameter((Object)grants, (String)"grants");
            Iterable iterable = grants;
            MysqlBaseUser mysqlBaseUser = grantee;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void g;
                MysqlBaseIntroQueries.RoleGrant roleGrant = (MysqlBaseIntroQueries.RoleGrant)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Pair rNh = this$0.splitUser(g.from_user, g.from_host);
                $userSearcher.find(rNh);
                collection.add(new MysqlRoleGrant((String)rNh.getFirst(), (String)rNh.getSecond(), Intrinsics.areEqual((Object)g.with_admin_option, (Object)"Y")));
            }
            mysqlBaseUser.setRoleGrants((List)destination$iv$iv);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoleGrants$lambda$33$lambda$32$lambda$31(ElementDataCollector $this_collectAll, MysqlBaseIntroQueries.RoleGrant u) {
            Intrinsics.checkNotNullParameter((Object)u, (String)"u");
            $this_collectAll.collect(u);
            return Unit.INSTANCE;
        }
    }
}

