/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis;

import com.intellij.database.util.common.StringFun;
import com.intellij.database.util.common.TextTable;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0014\u0018\u0000 @*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0002@AB\u007f\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\b\u00128\u0010\t\u001a4\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00028\u00000\n\u0012\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000.J\u0015\u0010/\u001a\u0004\u0018\u00018\u00002\u0006\u00100\u001a\u00028\u0000\u00a2\u0006\u0002\u00101J\u0015\u0010/\u001a\u0004\u0018\u00018\u00002\u0006\u00102\u001a\u00020\u0006\u00a2\u0006\u0002\u00103J\u0015\u00104\u001a\u0004\u0018\u00018\u00002\u0006\u00102\u001a\u00020\u001a\u00a2\u0006\u0002\u00105J\u0013\u00106\u001a\u00020\"2\u0006\u00100\u001a\u00028\u0000\u00a2\u0006\u0002\u00107J\u000e\u00106\u001a\u00020\"2\u0006\u00102\u001a\u00020\u0006J\u0019\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000.2\u0006\u00100\u001a\u00028\u0000\u00a2\u0006\u0002\u00109J\u0013\u0010:\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0007\u00a2\u0006\u0002\u0010;J\u0013\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0007\u00a2\u0006\u0002\u0010=J\b\u0010>\u001a\u00020\u0006H\u0007J\b\u0010?\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u0011\u0010'\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R\u0011\u0010)\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010$R\u0011\u0010+\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010$\u00a8\u0006B"}, d2={"Lcom/intellij/database/dialects/redis/RedisTree;", "N", "", "inputNodes", "", "delimiter", "", "getPath", "Lkotlin/Function1;", "makeErsatz", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "parentNode", "newNodePath", "makeEmptyArray", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/Iterable;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;)V", "getDelimiter", "()Ljava/lang/String;", "getGetPath", "()Lkotlin/jvm/functions/Function1;", "paths", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "", "nodes", "[Ljava/lang/Object;", "nodeLevels", "", "nodeBushes", "nodeSiblings", "depth", "", "getDepth", "()I", "ersatzNodesCount", "getErsatzNodesCount", "topCount", "getTopCount", "size", "getSize", "delimiterLen", "getDelimiterLen", "getTopNodes", "", "getNodeParent", "node", "(Ljava/lang/Object;)Ljava/lang/Object;", "path", "(Ljava/lang/String;)Ljava/lang/Object;", "getNode", "(Ljava/lang/CharSequence;)Ljava/lang/Object;", "getNodeChildrenCount", "(Ljava/lang/Object;)I", "getNodeChildren", "(Ljava/lang/Object;)Ljava/util/List;", "getNodes", "()[Ljava/lang/Object;", "getPaths", "()[Ljava/lang/String;", "dump", "toString", "Companion", "PathComparator", "intellij.database.dialects.redis"})
@SourceDebugExtension(value={"SMAP\nRedisTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisTree.kt\ncom/intellij/database/dialects/redis/RedisTree\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,340:1\n1#2:341\n*E\n"})
public final class RedisTree<N> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String delimiter;
    @NotNull
    private final Function1<N, String> getPath;
    @NotNull
    private final Object2IntOpenHashMap<CharSequence> paths;
    @NotNull
    private final N[] nodes;
    @NotNull
    private final int[] nodeLevels;
    @NotNull
    private final int[] nodeBushes;
    @NotNull
    private final int[] nodeSiblings;
    private final int depth;
    private final int ersatzNodesCount;
    private final int topCount;
    private final int delimiterLen;
    public static final char PD = '\u0000';
    @NotNull
    public static final String PDStr = "\u0000";

    /*
     * WARNING - void declaration
     */
    public RedisTree(@NotNull Iterable<? extends N> inputNodes, @NotNull String delimiter, @NotNull Function1<? super N, String> getPath, @NotNull Function2<? super N, ? super String, ? extends N> makeErsatz, @NotNull Function0<N[]> makeEmptyArray) {
        boolean node2;
        String nodePath;
        void $this$paths_u24lambda_u240;
        Object2IntOpenHashMap object2IntOpenHashMap;
        Intrinsics.checkNotNullParameter(inputNodes, (String)"inputNodes");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        Intrinsics.checkNotNullParameter(getPath, (String)"getPath");
        Intrinsics.checkNotNullParameter(makeErsatz, (String)"makeErsatz");
        Intrinsics.checkNotNullParameter(makeEmptyArray, (String)"makeEmptyArray");
        this.delimiter = delimiter;
        this.getPath = getPath;
        Object2IntOpenHashMap object2IntOpenHashMap2 = object2IntOpenHashMap = new Object2IntOpenHashMap();
        RedisTree redisTree = this;
        boolean bl = false;
        $this$paths_u24lambda_u240.defaultReturnValue(Integer.MIN_VALUE);
        redisTree.paths = object2IntOpenHashMap;
        this.delimiterLen = this.delimiter.length();
        if (this.delimiterLen == 0) {
            throw new IllegalArgumentException("Delimiter cannot be empty");
        }
        ArrayList readyNodes = new ArrayList();
        Ref.ObjectRef lastPath = new Ref.ObjectRef();
        lastPath.element = PDStr;
        Ref.ObjectRef lastNode = new Ref.ObjectRef();
        Ref.IntRef counter = new Ref.IntRef();
        Ref.IntRef ersatzCounter = new Ref.IntRef();
        int depth = 0;
        int topCount = 0;
        ArrayList sortedRealNodes = new ArrayList();
        CollectionsKt.addAll((Collection)sortedRealNodes, inputNodes);
        PathComparator<N> comparator = new PathComparator<N>(this.delimiter, this.getPath);
        CollectionsKt.sortWith((List)sortedRealNodes, (Comparator)comparator);
        int inputCount = sortedRealNodes.size();
        int expectedCount = inputCount + (inputCount >> 1);
        this.paths.ensureCapacity(expectedCount);
        readyNodes.ensureCapacity(expectedCount);
        Iterator iterator = sortedRealNodes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object node2;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
            nodePath = (String)this.getPath.invoke(node2);
            RedisTree._init_$ensureParent(this, (Ref.ObjectRef<String>)lastPath, lastNode, makeErsatz, ersatzCounter, readyNodes, counter, nodePath);
            RedisTree._init_$storeNode(counter, (Ref.ObjectRef<String>)lastPath, lastNode, readyNodes, this, node2, nodePath);
        }
        int count = readyNodes.size();
        boolean bl2 = node2 = count == counter.element;
        if (_Assertions.ENABLED && !node2) {
            nodePath = "Assertion failed";
            throw new AssertionError((Object)nodePath);
        }
        Object[] objectArray = readyNodes.toArray((Object[])makeEmptyArray.invoke());
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
        this.nodes = objectArray;
        this.nodeLevels = new int[count];
        this.nodeBushes = new int[count];
        this.nodeSiblings = new int[count];
        Int2IntOpenHashMap pastLevels = new Int2IntOpenHashMap();
        int handledLevel = 0;
        int lastTop = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            int level;
            N node3 = this.nodes[i2];
            String path = (String)this.getPath.invoke(node3);
            this.nodeLevels[i2] = level = Companion.countLevel(path, this.delimiter);
            if (depth < level) {
                depth = level;
            }
            if (i2 == 0) {
                topCount = 1;
            } else if (level == 1) {
                this.nodeSiblings[lastTop] = i2;
                ++topCount;
                pastLevels.clear();
                lastTop = i2;
            } else if (handledLevel < level) {
                int[] nArray = this.nodeBushes;
                int n = i2 - 1;
                var27_35 = nArray[n];
                nArray[n] = var27_35 + 1;
            } else {
                int parentIndex = pastLevels.get(level - 1);
                int[] nArray = this.nodeBushes;
                var27_35 = nArray[parentIndex];
                nArray[parentIndex] = var27_35 + 1;
                int priorSiblingIndex = pastLevels.get(level);
                this.nodeSiblings[priorSiblingIndex] = i2;
            }
            ((Map)pastLevels).put(level, i2);
            handledLevel = level;
        }
        this.ersatzNodesCount = ersatzCounter.element;
        this.depth = depth;
        this.topCount = topCount;
    }

    @NotNull
    public final String getDelimiter() {
        return this.delimiter;
    }

    @NotNull
    public final Function1<N, String> getGetPath() {
        return this.getPath;
    }

    public final int getDepth() {
        return this.depth;
    }

    public final int getErsatzNodesCount() {
        return this.ersatzNodesCount;
    }

    public final int getTopCount() {
        return this.topCount;
    }

    public final int getSize() {
        return this.nodes.length;
    }

    public final int getDelimiterLen() {
        return this.delimiterLen;
    }

    @NotNull
    public final List<N> getTopNodes() {
        if (this.getSize() == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<N> a = new ArrayList<N>(this.topCount);
        int i2 = 0;
        while (i2 < this.getSize()) {
            N n = this.nodes[i2];
            a.add(n);
            if ((i2 = this.nodeSiblings[i2]) != 0) continue;
            break;
        }
        return a;
    }

    @Nullable
    public final N getNodeParent(@NotNull N node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        String path = (String)this.getPath.invoke(node);
        return this.getNodeParent(path);
    }

    @Nullable
    public final N getNodeParent(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CharSequence parentPath = Companion.extractParentPath(path, this.delimiter);
        return this.getNode(parentPath);
    }

    @Nullable
    public final N getNode(@NotNull CharSequence path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.length() == 0) {
            return null;
        }
        int index = this.paths.getInt((Object)path);
        if (index < 0) {
            return null;
        }
        return this.nodes[index];
    }

    public final int getNodeChildrenCount(@NotNull N node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        String path = (String)this.getPath.invoke(node);
        return this.getNodeChildrenCount(path);
    }

    public final int getNodeChildrenCount(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int index = this.paths.getInt((Object)path);
        if (index < 0) {
            return 0;
        }
        return this.nodeBushes[index];
    }

    @NotNull
    public final List<N> getNodeChildren(@NotNull N node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        String path = (String)this.getPath.invoke(node);
        int index = this.paths.getInt((Object)path);
        if (index < 0) {
            return CollectionsKt.emptyList();
        }
        int childrenCount = this.nodeBushes[index];
        if (childrenCount <= 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList children2 = new ArrayList(childrenCount);
        int n = this.nodes.length;
        int k = index + 1;
        while (true) {
            boolean bl = 1 <= k ? k < n : false;
            if (!bl) break;
            ((Collection)children2).add(this.nodes[k]);
            k = this.nodeSiblings[k];
        }
        return children2;
    }

    @ApiStatus.Internal
    @TestOnly
    @NotNull
    public final N[] getNodes() {
        return (Object[])this.nodes.clone();
    }

    @ApiStatus.Internal
    @TestOnly
    @NotNull
    public final String[] getPaths() {
        int n = 0;
        int n2 = this.nodes.length;
        String[] stringArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            stringArray[n3] = this.getPath.invoke(this.nodes[n3]);
        }
        return stringArray;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public final String dump() {
        TextTable.Column[] columnArray = new TextTable.Column[]{new TextTable.Column("Index", TextTable.Align.RIGHT, RedisTree::dump$lambda$1), new TextTable.Column("Level", TextTable.Align.RIGHT, arg_0 -> RedisTree.dump$lambda$2(this, arg_0)), new TextTable.Column("Bush", TextTable.Align.RIGHT, arg_0 -> RedisTree.dump$lambda$3(this, arg_0)), new TextTable.Column("Sibl", TextTable.Align.RIGHT, arg_0 -> RedisTree.dump$lambda$4(this, arg_0)), new TextTable.Column("Path", TextTable.Align.LEFT, arg_0 -> RedisTree.dump$lambda$5(this, arg_0)), new TextTable.Column("Class", TextTable.Align.LEFT, arg_0 -> RedisTree.dump$lambda$6(this, arg_0))};
        return ((Object)new TextTable(columnArray).processContent((Iterable)RangesKt.until((int)0, (int)this.getSize()))).toString();
    }

    @NotNull
    public String toString() {
        return this.dump();
    }

    private static final <N> void _init_$storeNode(Ref.IntRef counter, Ref.ObjectRef<String> lastPath, Ref.ObjectRef<N> lastNode, ArrayList<N> readyNodes, RedisTree<N> this$0, N node, String path) {
        int n = counter.element;
        counter.element = n + 1;
        int index = n;
        lastPath.element = path;
        lastNode.element = node;
        readyNodes.add(node);
        this$0.paths.put((Object)path, index);
        int n2 = n = readyNodes.get(index) == node ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    private static final <N> N _init_$peekNodeByPath(RedisTree<N> this$0, ArrayList<N> readyNodes, CharSequence path) {
        int index = this$0.paths.getInt((Object)path);
        return index >= 0 ? (N)readyNodes.get(index) : null;
    }

    private static final <N> N _init_$ensureParent(RedisTree<N> this$0, Ref.ObjectRef<String> lastPath, Ref.ObjectRef<N> lastNode, Function2<? super N, ? super String, ? extends N> $makeErsatz, Ref.IntRef ersatzCounter, ArrayList<N> readyNodes, Ref.IntRef counter, CharSequence path) {
        CharSequence parentPath = Companion.extractParentPath(path, this$0.delimiter);
        if (parentPath.length() == 0) {
            return null;
        }
        if (Intrinsics.areEqual((Object)lastPath.element, (Object)parentPath)) {
            return (N)lastNode.element;
        }
        if (StringsKt.startsWith$default((CharSequence)((CharSequence)lastPath.element), (CharSequence)parentPath, (boolean)false, (int)2, null)) {
            return RedisTree._init_$peekNodeByPath(this$0, readyNodes, parentPath);
        }
        String parentPathStr = ((Object)parentPath).toString();
        N grannyNode = RedisTree._init_$ensureParent(this$0, lastPath, lastNode, $makeErsatz, ersatzCounter, readyNodes, counter, parentPathStr);
        Object newErsatz = $makeErsatz.invoke(grannyNode, (Object)parentPathStr);
        int n = ersatzCounter.element;
        ersatzCounter.element = n + 1;
        RedisTree._init_$storeNode(counter, lastPath, lastNode, readyNodes, this$0, newErsatz, parentPathStr);
        return (N)newErsatz;
    }

    private static final CharSequence dump$lambda$1(int it) {
        return String.valueOf(it);
    }

    private static final CharSequence dump$lambda$2(RedisTree this$0, int it) {
        return String.valueOf(this$0.nodeLevels[it]);
    }

    private static final CharSequence dump$lambda$3(RedisTree this$0, int it) {
        return String.valueOf(this$0.nodeBushes[it]);
    }

    private static final CharSequence dump$lambda$4(RedisTree this$0, int it) {
        return String.valueOf(this$0.nodeSiblings[it]);
    }

    private static final CharSequence dump$lambda$5(RedisTree this$0, int it) {
        return StringFun.replicate$default("   ", Math.max(this$0.nodeLevels[it] - 1, 0), null, null, 6, null) + this$0.getPath.invoke(this$0.nodes[it]);
    }

    private static final CharSequence dump$lambda$6(RedisTree this$0, int it) {
        return this$0.nodes[it].getClass().getSimpleName();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007J\u0012\u0010\u000f\u001a\u00020\u000e*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/redis/RedisTree$Companion;", "", "<init>", "()V", "PD", "", "PDStr", "", "extractParentPath", "", "path", "delimiter", "extractName", "countLevel", "", "countOf", "substring", "intellij.database.dialects.redis"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CharSequence extractParentPath(@NotNull CharSequence path, @NotNull String delimiter) {
            int d;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
            int delimiterLen = delimiter.length();
            CharSequence thePath = path;
            if (StringsKt.endsWith$default((CharSequence)path, (CharSequence)delimiter, (boolean)false, (int)2, null)) {
                thePath = path.subSequence(0, path.length() - delimiterLen);
            }
            return (d = StringsKt.lastIndexOf$default((CharSequence)thePath, (String)delimiter, (int)0, (boolean)false, (int)6, null)) >= 0 ? thePath.subSequence(0, d + delimiterLen) : (CharSequence)"";
        }

        @NotNull
        public final CharSequence extractName(@NotNull CharSequence path, @NotNull String delimiter) {
            int d;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
            int delimiterLen = delimiter.length();
            CharSequence thePath = path;
            if (StringsKt.endsWith$default((CharSequence)path, (CharSequence)delimiter, (boolean)false, (int)2, null)) {
                thePath = path.subSequence(0, path.length() - delimiterLen);
            }
            return (d = StringsKt.lastIndexOf$default((CharSequence)thePath, (String)delimiter, (int)0, (boolean)false, (int)6, null)) < 0 ? thePath : thePath.subSequence(d + delimiterLen, thePath.length());
        }

        public final int countLevel(@NotNull String path, @NotNull String delimiter) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
            if (((CharSequence)path).length() == 0) {
                return 0;
            }
            CharSequence s = StringsKt.endsWith$default((String)path, (String)delimiter, (boolean)false, (int)2, null) ? path.subSequence(0, path.length() - delimiter.length()) : (CharSequence)path;
            return this.countOf(s, delimiter) + 1;
        }

        public final int countOf(@NotNull CharSequence $this$countOf, @NotNull String substring) {
            Intrinsics.checkNotNullParameter((Object)$this$countOf, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
            int m = substring.length();
            if (m == 0) {
                throw new IllegalArgumentException("substring must not be empty");
            }
            if ($this$countOf.length() < m) {
                return 0;
            }
            int k = 0;
            int i2 = StringsKt.indexOf$default((CharSequence)$this$countOf, (String)substring, (int)0, (boolean)false, (int)6, null);
            while (i2 >= 0) {
                ++k;
                i2 = StringsKt.indexOf$default((CharSequence)$this$countOf, (String)substring, (int)(i2 + m), (boolean)false, (int)4, null);
            }
            return k;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u0012\u0012\u0004\u0012\u0002H\u00010\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00018\u00012\b\u0010\u0015\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/redis/RedisTree$PathComparator;", "N", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "delimiter", "", "doGetPath", "Lkotlin/Function1;", "", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getDelimiter", "()Ljava/lang/String;", "getDoGetPath", "()Lkotlin/jvm/functions/Function1;", "d1", "", "dl", "", "compare", "o1", "o2", "(Ljava/lang/Object;Ljava/lang/Object;)I", "comparePaths", "path1", "path2", "getComparableChar", "s", "index", "intellij.database.dialects.redis"})
    private static final class PathComparator<N>
    implements Comparator<N> {
        @NotNull
        private final String delimiter;
        @NotNull
        private final Function1<N, CharSequence> doGetPath;
        private final char d1;
        private final int dl;

        public PathComparator(@NotNull String delimiter, @NotNull Function1<? super N, ? extends CharSequence> doGetPath) {
            Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
            Intrinsics.checkNotNullParameter(doGetPath, (String)"doGetPath");
            this.delimiter = delimiter;
            this.doGetPath = doGetPath;
            this.dl = this.delimiter.length();
            if (this.dl == 0) {
                throw new IllegalArgumentException("Delimiter must be non-empty");
            }
            this.d1 = this.delimiter.charAt(0);
        }

        @NotNull
        public final String getDelimiter() {
            return this.delimiter;
        }

        @NotNull
        public final Function1<N, CharSequence> getDoGetPath() {
            return this.doGetPath;
        }

        @Override
        public int compare(@Nullable N o1, @Nullable N o2) {
            return o1 == o2 ? 0 : (o1 != null && o2 != null ? this.comparePaths((CharSequence)this.doGetPath.invoke(o1), (CharSequence)this.doGetPath.invoke(o2)) : (o1 != null ? -1 : (o2 != null ? 1 : 0)));
        }

        private final int comparePaths(CharSequence path1, CharSequence path2) {
            int n = Math.min(path1.length(), path2.length());
            for (int i2 = 0; i2 < n; ++i2) {
                char c2;
                char c1 = this.getComparableChar(path1, i2);
                int z = Intrinsics.compare((int)c1, (int)(c2 = this.getComparableChar(path2, i2)));
                if (z == 0) continue;
                return z;
            }
            return Intrinsics.compare((int)path1.length(), (int)path2.length());
        }

        private final char getComparableChar(CharSequence s, int index) {
            char c2 = s.charAt(index);
            if (c2 == this.d1 && index + this.dl <= s.length() && StringsKt.contentEquals((CharSequence)s.subSequence(index, index + this.dl), (CharSequence)this.delimiter)) {
                c2 = '\u0000';
            }
            return c2;
        }
    }
}

