/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.portForwarding.processWatcher;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ListeningPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ListeningPortHandler;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortListeningOptions;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.processWatcher.LinuxPortForwardingProcessWatcher;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.processWatcher.MacPortForwardingProcessWatcher;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.processWatcher.WindowsPortForwardingProcessWatcher;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.selects.OnTimeoutKt;
import kotlinx.coroutines.selects.SelectBuilder;
import kotlinx.coroutines.selects.SelectImplementation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 .2\u00020\u0001:\u0001.B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0018\u001a\u00020\u0014J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eH$J\u0016\u0010$\u001a\u00020\u00142\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0#H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\u0006\u0010'\u001a\u00020\u0003H\u0002J0\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\u0006\u0010)\u001a\u00020\u00032\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00110+H\u0002J\u001a\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030-0\u0011H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/PortForwardingProcessWatcher;", "", "pid", "", "handler", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPortHandler;", "options", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortListeningOptions;", "<init>", "(JLcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPortHandler;Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortListeningOptions;)V", "getPid", "()J", "getHandler", "()Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPortHandler;", "getOptions", "()Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortListeningOptions;", "exponentialBackoffCounters", "", "resetCounterChannel", "Lkotlinx/coroutines/channels/Channel;", "", "isProcessWatchForListeningPortsEnabled", "", "()Z", "resetDelay", "isWatchStarted", "startWatch", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "scanPortsOnce", "", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPort;", "getPortsOfPids", "pids", "currentState", "", "updateState", "newState", "getPidsTreeForPpid", "parentPid", "getAllChildPids", "ppid", "pidsMap", "", "getPPidToPidMapping", "Lkotlin/Pair;", "Companion", "intellij.platform.split"})
@ApiStatus.Experimental
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPortForwardingProcessWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortForwardingProcessWatcher.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/PortForwardingProcessWatcher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,219:1\n61#2,5:220\n61#2,5:225\n68#2,4:230\n68#2,4:234\n61#2,5:256\n68#2,4:266\n14#2:270\n1869#3,2:238\n1869#3,2:240\n1504#3:242\n1534#3,3:243\n1537#3,3:253\n1460#3,5:261\n382#4,7:246\n*S KotlinDebug\n*F\n+ 1 PortForwardingProcessWatcher.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/PortForwardingProcessWatcher\n*L\n64#1:220,5\n69#1:225,5\n150#1:230,4\n156#1:234,4\n190#1:256,5\n58#1:266,4\n34#1:270\n163#1:238,2\n167#1:240,2\n177#1:242\n177#1:243,3\n177#1:253,3\n197#1:261,5\n177#1:246,7\n*E\n"})
public abstract class PortForwardingProcessWatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long pid;
    @NotNull
    private final ListeningPortHandler handler;
    @NotNull
    private final PortListeningOptions options;
    @NotNull
    private final List<Long> exponentialBackoffCounters;
    @NotNull
    private final Channel<Unit> resetCounterChannel;
    private boolean isWatchStarted;
    @NotNull
    private Set<ListeningPort> currentState;
    @NotNull
    private static final Logger logger;

    public PortForwardingProcessWatcher(long pid, @NotNull ListeningPortHandler handler, @NotNull PortListeningOptions options) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        this.pid = pid;
        this.handler = handler;
        this.options = options;
        Object[] objectArray = new Long[]{0L, 0L, 2000L, 2000L, 4000L, 7000L, 14000L, 30000L, 60000L};
        this.exponentialBackoffCounters = CollectionsKt.listOf((Object[])objectArray);
        this.resetCounterChannel = ChannelKt.Channel$default((int)-1, null, PortForwardingProcessWatcher::resetCounterChannel$lambda$1, (int)2, null);
        this.currentState = SetsKt.emptySet();
    }

    protected final long getPid() {
        return this.pid;
    }

    @NotNull
    protected final ListeningPortHandler getHandler() {
        return this.handler;
    }

    @NotNull
    protected final PortListeningOptions getOptions() {
        return this.options;
    }

    public final boolean isProcessWatchForListeningPortsEnabled() {
        boolean isProcessWatchEnabled = Registry.Companion.is("rdct.portForwarding.processWatch.enabled", true);
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Process watch for listening ports enabled: " + isProcessWatchEnabled, e$iv);
        }
        return isProcessWatchEnabled;
    }

    public final void resetDelay() {
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Reset delay", e$iv);
        }
        this.resetCounterChannel.trySend-JP2dKIU((Object)Unit.INSTANCE);
    }

    public final void startWatch(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (!this.isProcessWatchForListeningPortsEnabled()) {
            logger.info("Port Forwarding process watcher is disabled. Skip.");
            return;
        }
        logger.info("Port Forwarding Process Watcher. Start watching for processes: <" + this.pid + ">, options: <" + this.options + ">");
        if (this.isWatchStarted) {
            logger.info("Port Forwarding Process Watcher is already started. Skip.");
            return;
        }
        this.isWatchStarted = true;
        lifetime.onTermination(() -> PortForwardingProcessWatcher.startWatch$lambda$4(this));
        LifetimeCoroutineUtilKt.launch$default((Lifetime)lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, lifetime, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ PortForwardingProcessWatcher this$0;
            final /* synthetic */ Lifetime $lifetime;
            {
                this.this$0 = $receiver;
                this.$lifetime = $lifetime;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        countersIterator = new Ref.ObjectRef();
                        countersIterator.element = PortForwardingProcessWatcher.access$getExponentialBackoffCounters$p(this.this$0).iterator();
                        currentBackoff = new Ref.LongRef();
                        currentBackoff.element = ((Number)((Iterator)countersIterator.element).next()).longValue();
lbl9:
                        // 3 sources

                        while (RLifetimeKt.isAlive((Lifetime)this.$lifetime)) {
                            $this$trace$iv /* !! */  = PortForwardingProcessWatcher.getLogger();
                            $i$f$trace = false;
                            if ($this$trace$iv /* !! */ .isTraceEnabled()) {
                                var11_14 = $this$trace$iv /* !! */ ;
                                $i$a$-trace-PortForwardingProcessWatcher$startWatch$2$1 = false;
                                var11_14.trace("Port Forwarding Process Watcher is going to suspend in select");
                            }
                            $this$trace$iv /* !! */  = this.this$0;
                            $i$f$select = 0;
                            $this$select_u24lambda_u240$iv = new SelectImplementation(this.getContext());
                            $i$a$-run-SelectKt$select$2$iv = 0;
                            $this$invokeSuspend_u24lambda_u241 = (SelectBuilder)$this$select_u24lambda_u240$iv;
                            $i$a$-select-PortForwardingProcessWatcher$startWatch$2$2 = false;
                            $this$invokeSuspend_u24lambda_u241.invoke(PortForwardingProcessWatcher.access$getResetCounterChannel$p((PortForwardingProcessWatcher)$this$trace$iv /* !! */ ).getOnReceive(), (Function2)new Function2<Unit, Continuation<? super Unit>, Object>((Ref.ObjectRef<Iterator<Long>>)countersIterator, (PortForwardingProcessWatcher)$this$trace$iv /* !! */ , currentBackoff, null){
                                int label;
                                final /* synthetic */ Ref.ObjectRef<Iterator<Long>> $countersIterator;
                                final /* synthetic */ PortForwardingProcessWatcher this$0;
                                final /* synthetic */ Ref.LongRef $currentBackoff;
                                {
                                    this.$countersIterator = $countersIterator;
                                    this.this$0 = $receiver;
                                    this.$currentBackoff = $currentBackoff;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Logger $this$trace$iv = PortForwardingProcessWatcher.getLogger();
                                            boolean $i$f$trace = false;
                                            if ($this$trace$iv.isTraceEnabled()) {
                                                Logger logger = $this$trace$iv;
                                                boolean bl = false;
                                                logger.trace("Port Forwarding Process Watcher received counter reset in select");
                                            }
                                            this.$countersIterator.element = PortForwardingProcessWatcher.access$getExponentialBackoffCounters$p(this.this$0).iterator();
                                            this.$currentBackoff.element = ((Number)((Iterator)this.$countersIterator.element).next()).longValue();
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            });
                            OnTimeoutKt.onTimeout((SelectBuilder)$this$invokeSuspend_u24lambda_u241, (long)currentBackoff.element, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>((Ref.ObjectRef<Iterator<Long>>)countersIterator, currentBackoff, null){
                                int label;
                                final /* synthetic */ Ref.ObjectRef<Iterator<Long>> $countersIterator;
                                final /* synthetic */ Ref.LongRef $currentBackoff;
                                {
                                    this.$countersIterator = $countersIterator;
                                    this.$currentBackoff = $currentBackoff;
                                    super(1, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Logger $this$trace$iv = PortForwardingProcessWatcher.getLogger();
                                            boolean $i$f$trace = false;
                                            if ($this$trace$iv.isTraceEnabled()) {
                                                Logger logger = $this$trace$iv;
                                                boolean bl = false;
                                                logger.trace("Port Forwarding Process Watcher received timeout in select");
                                            }
                                            if (((Iterator)this.$countersIterator.element).hasNext()) {
                                                this.$currentBackoff.element = ((Number)((Iterator)this.$countersIterator.element).next()).longValue();
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(Continuation<? super Unit> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }
                            }));
                            this.L$0 = countersIterator;
                            this.L$1 = currentBackoff;
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$select_u24lambda_u240$iv);
                            this.I$0 = $i$f$select;
                            this.I$1 = $i$a$-run-SelectKt$select$2$iv;
                            this.label = 1;
                            v0 = $this$select_u24lambda_u240$iv.doSelect((Continuation)this);
                            if (v0 == var12_2) {
                                return var12_2;
                            }
                            ** GOTO lbl49
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-run-SelectKt$select$2$iv = this.I$1;
                        $i$f$select = this.I$0;
                        $this$select_u24lambda_u240$iv = (SelectImplementation)this.L$2;
                        currentBackoff = (Ref.LongRef)this.L$1;
                        countersIterator = (Ref.ObjectRef)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl49:
                        // 2 sources

                        newState = this.this$0.scanPortsOnce();
                        PortForwardingProcessWatcher.access$updateState(this.this$0, newState);
                        $this$trace$iv = PortForwardingProcessWatcher.getLogger();
                        $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            var11_14 = $this$trace$iv;
                            $i$a$-trace-PortForwardingProcessWatcher$startWatch$2$3 = false;
                            var11_14.trace("Port Forwarding Process Watcher going to suspend in unconditional delay in 1 second");
                        }
                        this.L$0 = countersIterator;
                        this.L$1 = currentBackoff;
                        this.L$2 = SpillingKt.nullOutSpilledVariable(newState);
                        this.label = 2;
                        v1 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                        if (v1 != var12_2) ** GOTO lbl9
                        return var12_2;
                    }
                    case 2: {
                        newState = (Set<ListeningPort>)this.L$2;
                        currentBackoff = (Ref.LongRef)this.L$1;
                        countersIterator = (Ref.ObjectRef)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl9
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public final Set<ListeningPort> scanPortsOnce() {
        Set pids;
        ThreadingAssertions.assertBackgroundThread();
        if (this.options.includesChildren()) {
            v0 = this.getPidsTreeForPpid(this.pid);
        } else {
            Object[] objectArray = new Long[]{this.pid};
            v0 = pids = SetsKt.mutableSetOf((Object[])objectArray);
        }
        if (!this.options.includesSelf()) {
            pids.remove(this.pid);
        }
        if (pids.isEmpty()) {
            return new LinkedHashSet();
        }
        return this.getPortsOfPids(pids);
    }

    @NotNull
    protected abstract Set<ListeningPort> getPortsOfPids(@NotNull Set<Long> var1);

    private final void updateState(Set<ListeningPort> newState) {
        ListeningPort it;
        Logger logger;
        Set stoppedPorts = SetsKt.minus(this.currentState, (Iterable)newState);
        Logger $this$trace$iv = PortForwardingProcessWatcher.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Port Forwarding Process Watcher received stopped listening ports:\n" + CollectionsKt.joinToString$default((Iterable)stoppedPorts, (CharSequence)"\n", null, null, (int)0, null, PortForwardingProcessWatcher::updateState$lambda$6$lambda$5, (int)30, null));
        }
        Set newPorts = SetsKt.minus(newState, (Iterable)this.currentState);
        Logger $this$trace$iv2 = PortForwardingProcessWatcher.logger;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            logger.trace("Port Forwarding Process Watcher received new listening ports:\n" + CollectionsKt.joinToString$default((Iterable)newPorts, (CharSequence)"\n", null, null, (int)0, null, PortForwardingProcessWatcher::updateState$lambda$8$lambda$7, (int)30, null));
        }
        this.currentState = newState;
        Iterable $this$forEach$iv = newPorts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ListeningPort)element$iv;
            boolean bl = false;
            this.handler.onPortListeningStarted(it);
        }
        $this$forEach$iv = stoppedPorts;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ListeningPort)element$iv;
            boolean bl = false;
            this.handler.onPortListeningEnded(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Long> getPidsTreeForPpid(long parentPid) {
        void $this$groupByTo$iv$iv;
        List<Pair<Long, Long>> ppidToPid = this.getPPidToPidMapping();
        Iterable $this$groupBy$iv = ppidToPid;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-PortForwardingProcessWatcher$getPidsTreeForPpid$pidsMap$32 = false;
            Long key$iv$iv = ((Number)it2.getFirst()).longValue();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-PortForwardingProcessWatcher$getPidsTreeForPpid$pidsMap$32 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add(((Number)it.getSecond()).longValue());
        }
        Map pidsMap = destination$iv$iv;
        Set<Long> resultPids = this.getAllChildPids(parentPid, pidsMap);
        if (this.options.includesSelf()) {
            resultPids.add(parentPid);
        }
        return resultPids;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Long> getAllChildPids(long ppid, Map<Long, ? extends List<Long>> pidsMap) {
        void $this$flatMapTo$iv;
        Set result2 = new LinkedHashSet();
        List<Long> children = pidsMap.get(ppid);
        Object $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Port Forwarding Process Watcher got children of " + ppid + " are: " + children, e$iv);
        }
        if (children == null) {
            return result2;
        }
        result2.addAll((Collection)children);
        $this$debug_u24default$iv = children;
        Collection destination$iv = result2;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            long childPid = ((Number)element$iv).longValue();
            boolean bl = false;
            Iterable list$iv = this.getAllChildPids(childPid, pidsMap);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return result2;
    }

    @NotNull
    protected List<Pair<Long, Long>> getPPidToPidMapping() {
        Stream<ProcessHandle> stream = ProcessHandle.allProcesses();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"allProcesses(...)");
        Sequence pidTree = SequencesKt.mapNotNull((Sequence)StreamsKt.asSequence(stream), PortForwardingProcessWatcher::getPPidToPidMapping$lambda$15);
        return SequencesKt.toList((Sequence)pidTree);
    }

    private static final Unit resetCounterChannel$lambda$1(Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("signal was not delivered");
        }
        return Unit.INSTANCE;
    }

    private static final Unit startWatch$lambda$4(PortForwardingProcessWatcher this$0) {
        this$0.isWatchStarted = false;
        return Unit.INSTANCE;
    }

    private static final CharSequence updateState$lambda$6$lambda$5(ListeningPort it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return " # pid: " + it.getPid() + ", port: " + it.getSocketAddress() + ", type: " + it.getPortType().name();
    }

    private static final CharSequence updateState$lambda$8$lambda$7(ListeningPort it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return " # pid: " + it.getPid() + ", port: " + it.getSocketAddress() + ", type: " + it.getPortType().name();
    }

    private static final Pair getPPidToPidMapping$lambda$15(ProcessHandle process) {
        Optional<ProcessHandle> parent = process.parent();
        if (parent.isEmpty()) {
            return null;
        }
        long ppid = parent.get().pid();
        long pid = process.pid();
        return TuplesKt.to((Object)ppid, (Object)pid);
    }

    @NotNull
    protected static final Logger getLogger() {
        return Companion.getLogger();
    }

    public static final /* synthetic */ List access$getExponentialBackoffCounters$p(PortForwardingProcessWatcher $this) {
        return $this.exponentialBackoffCounters;
    }

    public static final /* synthetic */ void access$updateState(PortForwardingProcessWatcher $this, Set newState) {
        $this.updateState(newState);
    }

    public static final /* synthetic */ Channel access$getResetCounterChannel$p(PortForwardingProcessWatcher $this) {
        return $this.resetCounterChannel;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PortForwardingProcessWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PortForwardingProcessWatcher.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010R\u001c\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/PortForwardingProcessWatcher$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/processWatcher/PortForwardingProcessWatcher;", "pid", "", "handler", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ListeningPortHandler;", "options", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortListeningOptions;", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        protected static /* synthetic */ void getLogger$annotations() {
        }

        @NotNull
        public final PortForwardingProcessWatcher create(long pid, @NotNull ListeningPortHandler handler, @NotNull PortListeningOptions options) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
            if (SystemInfoRt.isMac) {
                return new MacPortForwardingProcessWatcher(pid, handler, options);
            }
            if (SystemInfoRt.isLinux) {
                return new LinuxPortForwardingProcessWatcher(pid, handler, options);
            }
            if (SystemInfoRt.isWindows) {
                return new WindowsPortForwardingProcessWatcher(pid, handler, options);
            }
            throw new IllegalStateException((SystemInfoRt.OS_NAME + " is not supported").toString());
        }

        public static /* synthetic */ PortForwardingProcessWatcher create$default(Companion companion, long l, ListeningPortHandler listeningPortHandler, PortListeningOptions portListeningOptions, int n, Object object) {
            if ((n & 4) != 0) {
                portListeningOptions = PortListeningOptions.INCLUDE_SELF_AND_CHILDREN;
            }
            return companion.create(l, listeningPortHandler, portListeningOptions);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

