/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.trigger;

import com.intellij.codeInsight.inline.completion.InlineCompletionEvent;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionLogsContainer;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.DoubleEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.FloatEventField;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectListEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.trigger.NanAndEmptyStringCleaner;
import com.intellij.ml.inline.completion.trigger.TriggerModel;
import com.intellij.openapi.editor.Editor;
import com.jetbrains.ml.api.feature.Feature;
import com.jetbrains.ml.api.feature.FeatureDeclaration;
import com.jetbrains.ml.api.feature.FeatureSet;
import com.jetbrains.ml.api.feature.FeatureSignature;
import com.jetbrains.ml.api.feature.InNamespaceUtil;
import com.jetbrains.ml.api.feature.preprocessor.FeaturePreprocessor;
import com.jetbrains.ml.tools.model.MLModel;
import com.jetbrains.ml.tools.model.catboost.prediction.CatBoostClassesProbabilities;
import com.jetbrains.ml.tools.model.pipeline.ModelPipeline;
import com.jetbrains.ml.tools.model.pipeline.ModelPipelineLoader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rJ$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J(\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rH\u0002J\u001e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u0010*\u0006\u0012\u0002\b\u00030\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/inline/completion/trigger/TriggerModel;", "", "modelStream", "Ljava/io/InputStream;", "<init>", "(Ljava/io/InputStream;)V", "state", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$TriggerModelState;", "loadModel", "", "predict", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response;", "features", "", "Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionLogsContainer$Phase;", "", "Lcom/jetbrains/ml/api/feature/Feature;", "flattenFeatures", "", "phase", "run", "event", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEvent;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/codeInsight/inline/completion/InlineCompletionEvent;Lcom/intellij/openapi/editor/Editor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toFeature", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "Response", "TriggerModelState", "intellij.fullLine.core.completion.trigger"})
@SourceDebugExtension(value={"SMAP\nTriggerModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TriggerModel.kt\ncom/intellij/ml/inline/completion/trigger/TriggerModel\n+ 2 ModelPipeline.kt\ncom/jetbrains/ml/tools/model/pipeline/ModelPipeline\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n55#2,5:145\n77#3:150\n97#3,5:151\n463#4:156\n413#4:157\n1252#5,2:158\n1617#5,9:160\n1869#5:169\n1870#5:171\n1626#5:172\n1255#5:173\n1#6:170\n*S KotlinDebug\n*F\n+ 1 TriggerModel.kt\ncom/intellij/ml/inline/completion/trigger/TriggerModel\n*L\n45#1:145,5\n92#1:150\n92#1:151,5\n101#1:156\n101#1:157\n101#1:158,2\n101#1:160,9\n101#1:169\n101#1:171\n101#1:172\n101#1:173\n101#1:170\n*E\n"})
public final class TriggerModel {
    @NotNull
    private TriggerModelState state;

    public TriggerModel(@NotNull InputStream modelStream) {
        Intrinsics.checkNotNullParameter((Object)modelStream, (String)"modelStream");
        this.state = TriggerModelState.NotLoaded.INSTANCE;
        this.loadModel(modelStream);
    }

    private final void loadModel(InputStream modelStream) {
        try {
            ModelPipeline<MLModel<Object>, Object> this_$iv = ModelPipelineLoader.INSTANCE.loadBlocking(modelStream);
            boolean $i$f$predicting = false;
            if (!CatBoostClassesProbabilities.class.isAssignableFrom(this_$iv.getBaseModel().getPredictedType())) {
                boolean bl = false;
                String string = "ML model predicts " + this_$iv.getBaseModel().getPredictedType().getName() + ", which is not a kind of " + CatBoostClassesProbabilities.class.getName();
                throw new IllegalArgumentException(string.toString());
            }
            FeaturePreprocessor featurePreprocessor = this_$iv.getPreprocessing();
            MLModel<Object> mLModel = this_$iv.getBaseModel();
            Intrinsics.checkNotNull(mLModel, (String)"null cannot be cast to non-null type com.jetbrains.ml.tools.model.MLModel<T of com.jetbrains.ml.tools.model.pipeline.ModelPipeline.predicting>");
            ModelPipeline<MLModel<CatBoostClassesProbabilities>, CatBoostClassesProbabilities> model = new ModelPipeline<MLModel<CatBoostClassesProbabilities>, CatBoostClassesProbabilities>(featurePreprocessor, mLModel, this_$iv.getInfo());
            this.state = new TriggerModelState.Loaded(model);
        }
        catch (Throwable e) {
            this.state = new TriggerModelState.FailedToLoad(e);
        }
    }

    @NotNull
    public final Response predict(@NotNull Map<InlineCompletionLogsContainer.Phase, ? extends Collection<? extends Feature>> features) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        TriggerModelState currentState = this.state;
        if (currentState instanceof TriggerModelState.FailedToLoad) {
            return new Response.Unavailable.FailedToLoad(((TriggerModelState.FailedToLoad)currentState).getException());
        }
        if (Intrinsics.areEqual((Object)currentState, (Object)TriggerModelState.NotLoaded.INSTANCE)) {
            return Response.Unavailable.Loading.INSTANCE;
        }
        if (!(currentState instanceof TriggerModelState.Loaded)) {
            throw new NoWhenBranchMatchedException();
        }
        ModelPipeline<MLModel<CatBoostClassesProbabilities>, CatBoostClassesProbabilities> model = ((TriggerModelState.Loaded)currentState).getModel();
        ModelPipeline pipeline = new ModelPipeline(NanAndEmptyStringCleaner.INSTANCE, model, MapsKt.emptyMap());
        CatBoostClassesProbabilities probabilities = (CatBoostClassesProbabilities)pipeline.predict(pipeline.getInputFeatures().selectFeatures((Collection<? extends Feature>)this.flattenFeatures(features)));
        Double d = probabilities.getProbabilities().get("true");
        Intrinsics.checkNotNull((Object)d);
        double scoreTrue = ((Number)d).doubleValue();
        Double d2 = (Double)model.getInfo().get("threshold");
        double threshold = d2 != null ? d2 : 0.0;
        Object versionAny = model.getInfo().getOrDefault("version", 0L);
        long version = versionAny instanceof Integer ? ((Integer)versionAny).longValue() : (versionAny instanceof Long ? ((Number)versionAny).longValue() : 0L);
        return new Response.Available(scoreTrue, threshold, scoreTrue < threshold, version);
    }

    private final List<Feature> flattenFeatures(InlineCompletionLogsContainer.Phase phase, Collection<? extends Feature> features) {
        var provider2 = new InNamespaceUtil(phase, features){
            private final String namespace;
            private final char namespaceSeparator;
            final /* synthetic */ Collection<Feature> $features;
            {
                this.$features = $features;
                String string = $phase.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                this.namespace = string;
                this.namespaceSeparator = (char)46;
            }

            public String getNamespace() {
                return this.namespace;
            }

            public char getNamespaceSeparator() {
                return this.namespaceSeparator;
            }

            /*
             * WARNING - void declaration
             */
            public final List<Feature> getFeatures() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$features;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Feature feature = (Feature)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.toGlobal((Feature)it));
                }
                return (List)destination$iv$iv;
            }

            public Feature toGlobal(Feature $this$toGlobal) {
                return InNamespaceUtil.DefaultImpls.toGlobal((InNamespaceUtil)this, $this$toGlobal);
            }

            public <T> FeatureDeclaration<T> toGlobal(FeatureDeclaration<T> $this$toGlobal) {
                return InNamespaceUtil.DefaultImpls.toGlobal((InNamespaceUtil)this, $this$toGlobal);
            }

            public String toGlobalName(String $this$toGlobalName) {
                return InNamespaceUtil.DefaultImpls.toGlobalName(this, $this$toGlobalName);
            }

            public FeatureSignature toGlobalSignature(FeatureSignature $this$toGlobalSignature) {
                return InNamespaceUtil.DefaultImpls.toGlobalSignature(this, $this$toGlobalSignature);
            }

            public FeatureSet toLocal(FeatureSet $this$toLocal) {
                return InNamespaceUtil.DefaultImpls.toLocal(this, $this$toLocal);
            }

            public String toLocalName(String $this$toLocalName) {
                return InNamespaceUtil.DefaultImpls.toLocalName(this, $this$toLocalName);
            }

            public FeatureSignature toLocalSignature(FeatureSignature $this$toLocalSignature) {
                return InNamespaceUtil.DefaultImpls.toLocalSignature(this, $this$toLocalSignature);
            }
        };
        return provider2.getFeatures();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Feature> flattenFeatures(Map<InlineCompletionLogsContainer.Phase, ? extends Collection<? extends Feature>> features) {
        void $this$flatMapTo$iv$iv;
        Map<InlineCompletionLogsContainer.Phase, ? extends Collection<? extends Feature>> $this$flatMap$iv = features;
        boolean $i$f$flatMap = false;
        Map<InlineCompletionLogsContainer.Phase, ? extends Collection<? extends Feature>> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            InlineCompletionLogsContainer.Phase phase = (InlineCompletionLogsContainer.Phase)entry.getKey();
            Collection features2 = (Collection)entry.getValue();
            Iterable list$iv$iv = this.flattenFeatures(phase, features2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object run(@NotNull InlineCompletionEvent event, @NotNull Editor editor, @NotNull Continuation<? super Response> $completion) {
        if (!($completion instanceof run.1)) ** GOTO lbl-1000
        var39_4 = $completion;
        if ((var39_4.label & -2147483648) != 0) {
            var39_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ TriggerModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.run(null, null, (Continuation<? super Response>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var40_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (event instanceof InlineCompletionEvent.DirectCall) {
                    return Response.Unavailable.DirectCall.INSTANCE;
                }
                var5_7 = InlineCompletionLogsContainer.Companion.get(editor);
                if (var5_7 == null) ** GOTO lbl29
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)editor);
                $continuation.label = 1;
                v0 = var5_7.awaitAndGetCurrentLogsPhased((Continuation)$continuation);
                if (v0 == var40_6) {
                    return var40_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                editor = (Editor)$continuation.L$1;
                event = (InlineCompletionEvent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if ((var6_8 = (Map)v0) != null) ** GOTO lbl30
lbl29:
                // 2 sources

                return Response.Unavailable.UnavailableFeatures.INSTANCE;
lbl30:
                // 1 sources

                $this$mapValues$iv = eventFields = var6_8;
                $i$f$mapValues = false;
                var8_11 = $this$mapValues$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                $i$f$mapValuesTo = false;
                $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    var15_18 = (Map.Entry)element$iv$iv$iv;
                    var16_19 = destination$iv$iv;
                    $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
                    var18_21 = (Map.Entry)element$iv$iv$iv;
                    var36_39 = it$iv$iv.getKey();
                    var35_38 = var16_19;
                    $i$a$-mapValues-TriggerModel$run$features$1 = false;
                    $this$mapNotNull$iv = (Iterable)it.getValue();
                    $i$f$mapNotNull = false;
                    var22_25 = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    var27_30 = $this$forEach$iv$iv$iv.iterator();
                    while (var27_30.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = var27_30.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        it = (EventPair)element$iv$iv;
                        $i$a$-mapNotNull-TriggerModel$run$features$1$1 = false;
                        if (this.toFeature(it) == null) continue;
                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    var37_40 = (List)destination$iv$iv;
                    var35_38.put(var36_39, var37_40);
                }
                features = destination$iv$iv;
                return this.predict(features);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Feature toFeature(EventPair<?> $this$toFeature) {
        EventField field = $this$toFeature.getField();
        if (field instanceof IntEventField) {
            FeatureDeclaration featureDeclaration = FeatureDeclaration.Companion.int$default(FeatureDeclaration.Companion, ((IntEventField)field).getName(), null, null, 6, null);
            Object object = $this$toFeature.getData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            v2 = featureDeclaration.with((Integer)object);
            return v2;
        } else if (field instanceof LongEventField) {
            FeatureDeclaration featureDeclaration = FeatureDeclaration.Companion.long$default(FeatureDeclaration.Companion, ((LongEventField)field).getName(), null, null, 6, null);
            Object object = $this$toFeature.getData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            v2 = featureDeclaration.with((Long)object);
            return v2;
        } else if (field instanceof FloatEventField) {
            FeatureDeclaration featureDeclaration = FeatureDeclaration.Companion.float$default(FeatureDeclaration.Companion, ((FloatEventField)field).getName(), null, null, 6, null);
            Object object = $this$toFeature.getData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
            v2 = featureDeclaration.with((Float)object);
            return v2;
        } else if (field instanceof DoubleEventField) {
            FeatureDeclaration featureDeclaration = FeatureDeclaration.Companion.double$default(FeatureDeclaration.Companion, ((DoubleEventField)field).getName(), null, null, 6, null);
            Object object = $this$toFeature.getData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            v2 = featureDeclaration.with((Double)object);
            return v2;
        } else if (field instanceof ClassEventField) {
            FeatureDeclaration featureDeclaration = FeatureDeclaration.Companion.string$default(FeatureDeclaration.Companion, ((ClassEventField)field).getName(), null, null, 6, null);
            Object object = $this$toFeature.getData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            String string = ((Class)object).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            v2 = featureDeclaration.with(string);
            return v2;
        } else if (field instanceof EnumEventField) {
            FeatureDeclaration featureDeclaration = FeatureDeclaration.Companion.string$default(FeatureDeclaration.Companion, ((EnumEventField)field).getName(), null, null, 6, null);
            Object object = $this$toFeature.getData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Enum<*>");
            v2 = featureDeclaration.with(((Enum)object).name());
            return v2;
        } else if (field instanceof BooleanEventField) {
            FeatureDeclaration featureDeclaration = FeatureDeclaration.Companion.boolean$default(FeatureDeclaration.Companion, ((BooleanEventField)field).getName(), null, null, 6, null);
            Object object = $this$toFeature.getData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            v2 = featureDeclaration.with((Boolean)object);
            return v2;
        } else if (field instanceof PrimitiveEventField) {
            String string = (String)CollectionsKt.firstOrNull((List)((PrimitiveEventField)field).getValidationRule());
            if (Intrinsics.areEqual((Object)string, (Object)"{regexp#version}")) {
                v2 = FeatureDeclaration.Companion.string$default(FeatureDeclaration.Companion, ((PrimitiveEventField)field).getName(), null, null, 6, null).with(String.valueOf((String)$this$toFeature.getData()));
                return v2;
            } else {
                if (!Intrinsics.areEqual((Object)string, (Object)"{util#lang}")) throw new IllegalArgumentException("Field " + ((PrimitiveEventField)field).getName() + " has unsupported validation rule: " + ((PrimitiveEventField)field).getValidationRule());
                FeatureDeclaration featureDeclaration = FeatureDeclaration.Companion.string$default(FeatureDeclaration.Companion, ((PrimitiveEventField)field).getName(), null, null, 6, null);
                Object object = $this$toFeature.getData();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.lang.Language");
                String string2 = ((Language)object).getID();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getID(...)");
                v2 = featureDeclaration.with(string2);
            }
            return v2;
        } else {
            if (!(field instanceof ObjectListEventField)) throw new IllegalArgumentException("Field " + field.getName() + " has unsupported field type: " + field.getClass().getName());
            String string = ((ObjectListEventField)field).getName();
            if (Intrinsics.areEqual((Object)string, (Object)"analyzed_triggered_filters")) {
                return null;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"raw_triggered_filters")) throw new IllegalArgumentException("Field " + ((ObjectListEventField)field).getName() + " is an object and should be handeled manually");
            return null;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0006\u0004\u0005\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response;", "", "Unavailable", "Available", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Available;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Unavailable;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Unavailable$DirectCall;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Unavailable$Loading;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Unavailable$UnavailableFeatures;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Unavailable$UnavailableLanguage;", "intellij.fullLine.core.completion.trigger"})
    public static interface Response {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Available;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response;", "score", "", "threshold", "skip", "", "version", "", "<init>", "(DDZJ)V", "getScore", "()D", "getThreshold", "getSkip", "()Z", "getVersion", "()J", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.fullLine.core.completion.trigger"})
        public static final class Available
        implements Response {
            private final double score;
            private final double threshold;
            private final boolean skip;
            private final long version;

            public Available(double score, double threshold, boolean skip, long version) {
                this.score = score;
                this.threshold = threshold;
                this.skip = skip;
                this.version = version;
            }

            public final double getScore() {
                return this.score;
            }

            public final double getThreshold() {
                return this.threshold;
            }

            public final boolean getSkip() {
                return this.skip;
            }

            public final long getVersion() {
                return this.version;
            }

            public final double component1() {
                return this.score;
            }

            public final double component2() {
                return this.threshold;
            }

            public final boolean component3() {
                return this.skip;
            }

            public final long component4() {
                return this.version;
            }

            @NotNull
            public final Available copy(double score, double threshold, boolean skip, long version) {
                return new Available(score, threshold, skip, version);
            }

            public static /* synthetic */ Available copy$default(Available available, double d, double d2, boolean bl, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    d = available.score;
                }
                if ((n & 2) != 0) {
                    d2 = available.threshold;
                }
                if ((n & 4) != 0) {
                    bl = available.skip;
                }
                if ((n & 8) != 0) {
                    l = available.version;
                }
                return available.copy(d, d2, bl, l);
            }

            @NotNull
            public String toString() {
                return "Available(score=" + this.score + ", threshold=" + this.threshold + ", skip=" + this.skip + ", version=" + this.version + ")";
            }

            public int hashCode() {
                int result = Double.hashCode(this.score);
                result = result * 31 + Double.hashCode(this.threshold);
                result = result * 31 + Boolean.hashCode(this.skip);
                result = result * 31 + Long.hashCode(this.version);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Available)) {
                    return false;
                }
                Available available = (Available)other;
                if (Double.compare(this.score, available.score) != 0) {
                    return false;
                }
                if (Double.compare(this.threshold, available.threshold) != 0) {
                    return false;
                }
                if (this.skip != available.skip) {
                    return false;
                }
                return this.version == available.version;
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0005\u0002\u0003\u0004\u0005\u0006\u0082\u0001\u0001\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Unavailable;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response;", "Loading", "UnavailableFeatures", "UnavailableLanguage", "DirectCall", "FailedToLoad", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Unavailable$FailedToLoad;", "intellij.fullLine.core.completion.trigger"})
        public static interface Unavailable
        extends Response {

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Unavailable$DirectCall;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.fullLine.core.completion.trigger"})
            public static final class DirectCall
            implements Response {
                @NotNull
                public static final DirectCall INSTANCE = new DirectCall();

                private DirectCall() {
                }

                @NotNull
                public String toString() {
                    return "DirectCall";
                }

                public int hashCode() {
                    return 884272813;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof DirectCall)) {
                        return false;
                    }
                    DirectCall cfr_ignored_0 = (DirectCall)other;
                    return true;
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Unavailable$FailedToLoad;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Unavailable;", "exception", "", "<init>", "(Ljava/lang/Throwable;)V", "getException", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.fullLine.core.completion.trigger"})
            public static final class FailedToLoad
            implements Unavailable {
                @NotNull
                private final Throwable exception;

                public FailedToLoad(@NotNull Throwable exception) {
                    Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                    this.exception = exception;
                }

                @NotNull
                public final Throwable getException() {
                    return this.exception;
                }

                @NotNull
                public final Throwable component1() {
                    return this.exception;
                }

                @NotNull
                public final FailedToLoad copy(@NotNull Throwable exception) {
                    Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                    return new FailedToLoad(exception);
                }

                public static /* synthetic */ FailedToLoad copy$default(FailedToLoad failedToLoad, Throwable throwable, int n, Object object) {
                    if ((n & 1) != 0) {
                        throwable = failedToLoad.exception;
                    }
                    return failedToLoad.copy(throwable);
                }

                @NotNull
                public String toString() {
                    return "FailedToLoad(exception=" + this.exception + ")";
                }

                public int hashCode() {
                    return this.exception.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof FailedToLoad)) {
                        return false;
                    }
                    FailedToLoad failedToLoad = (FailedToLoad)other;
                    return Intrinsics.areEqual((Object)this.exception, (Object)failedToLoad.exception);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Unavailable$Loading;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.fullLine.core.completion.trigger"})
            public static final class Loading
            implements Response {
                @NotNull
                public static final Loading INSTANCE = new Loading();

                private Loading() {
                }

                @NotNull
                public String toString() {
                    return "Loading";
                }

                public int hashCode() {
                    return -385186250;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Loading)) {
                        return false;
                    }
                    Loading cfr_ignored_0 = (Loading)other;
                    return true;
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Unavailable$UnavailableFeatures;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.fullLine.core.completion.trigger"})
            public static final class UnavailableFeatures
            implements Response {
                @NotNull
                public static final UnavailableFeatures INSTANCE = new UnavailableFeatures();

                private UnavailableFeatures() {
                }

                @NotNull
                public String toString() {
                    return "UnavailableFeatures";
                }

                public int hashCode() {
                    return -1132474713;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof UnavailableFeatures)) {
                        return false;
                    }
                    UnavailableFeatures cfr_ignored_0 = (UnavailableFeatures)other;
                    return true;
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response$Unavailable$UnavailableLanguage;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$Response;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.fullLine.core.completion.trigger"})
            public static final class UnavailableLanguage
            implements Response {
                @NotNull
                public static final UnavailableLanguage INSTANCE = new UnavailableLanguage();

                private UnavailableLanguage() {
                }

                @NotNull
                public String toString() {
                    return "UnavailableLanguage";
                }

                public int hashCode() {
                    return 1839562178;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof UnavailableLanguage)) {
                        return false;
                    }
                    UnavailableLanguage cfr_ignored_0 = (UnavailableLanguage)other;
                    return true;
                }
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/inline/completion/trigger/TriggerModel$TriggerModelState;", "", "NotLoaded", "FailedToLoad", "Loaded", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$TriggerModelState$FailedToLoad;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$TriggerModelState$Loaded;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$TriggerModelState$NotLoaded;", "intellij.fullLine.core.completion.trigger"})
    private static interface TriggerModelState {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/inline/completion/trigger/TriggerModel$TriggerModelState$FailedToLoad;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$TriggerModelState;", "exception", "", "<init>", "(Ljava/lang/Throwable;)V", "getException", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.fullLine.core.completion.trigger"})
        public static final class FailedToLoad
        implements TriggerModelState {
            @NotNull
            private final Throwable exception;

            public FailedToLoad(@NotNull Throwable exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.exception = exception;
            }

            @NotNull
            public final Throwable getException() {
                return this.exception;
            }

            @NotNull
            public final Throwable component1() {
                return this.exception;
            }

            @NotNull
            public final FailedToLoad copy(@NotNull Throwable exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new FailedToLoad(exception);
            }

            public static /* synthetic */ FailedToLoad copy$default(FailedToLoad failedToLoad, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    throwable = failedToLoad.exception;
                }
                return failedToLoad.copy(throwable);
            }

            @NotNull
            public String toString() {
                return "FailedToLoad(exception=" + this.exception + ")";
            }

            public int hashCode() {
                return this.exception.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FailedToLoad)) {
                    return false;
                }
                FailedToLoad failedToLoad = (FailedToLoad)other;
                return Intrinsics.areEqual((Object)this.exception, (Object)failedToLoad.exception);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J%\u0010\u000b\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/inline/completion/trigger/TriggerModel$TriggerModelState$Loaded;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$TriggerModelState;", "model", "Lcom/jetbrains/ml/tools/model/pipeline/ModelPipeline;", "Lcom/jetbrains/ml/tools/model/MLModel;", "Lcom/jetbrains/ml/tools/model/catboost/prediction/CatBoostClassesProbabilities;", "<init>", "(Lcom/jetbrains/ml/tools/model/pipeline/ModelPipeline;)V", "getModel", "()Lcom/jetbrains/ml/tools/model/pipeline/ModelPipeline;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.fullLine.core.completion.trigger"})
        public static final class Loaded
        implements TriggerModelState {
            @NotNull
            private final ModelPipeline<MLModel<CatBoostClassesProbabilities>, CatBoostClassesProbabilities> model;

            public Loaded(@NotNull ModelPipeline<MLModel<CatBoostClassesProbabilities>, CatBoostClassesProbabilities> model) {
                Intrinsics.checkNotNullParameter(model, (String)"model");
                this.model = model;
            }

            @NotNull
            public final ModelPipeline<MLModel<CatBoostClassesProbabilities>, CatBoostClassesProbabilities> getModel() {
                return this.model;
            }

            @NotNull
            public final ModelPipeline<MLModel<CatBoostClassesProbabilities>, CatBoostClassesProbabilities> component1() {
                return this.model;
            }

            @NotNull
            public final Loaded copy(@NotNull ModelPipeline<MLModel<CatBoostClassesProbabilities>, CatBoostClassesProbabilities> model) {
                Intrinsics.checkNotNullParameter(model, (String)"model");
                return new Loaded(model);
            }

            public static /* synthetic */ Loaded copy$default(Loaded loaded, ModelPipeline modelPipeline, int n, Object object) {
                if ((n & 1) != 0) {
                    modelPipeline = loaded.model;
                }
                return loaded.copy(modelPipeline);
            }

            @NotNull
            public String toString() {
                return "Loaded(model=" + this.model + ")";
            }

            public int hashCode() {
                return this.model.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Loaded)) {
                    return false;
                }
                Loaded loaded = (Loaded)other;
                return Intrinsics.areEqual(this.model, loaded.model);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/inline/completion/trigger/TriggerModel$TriggerModelState$NotLoaded;", "Lcom/intellij/ml/inline/completion/trigger/TriggerModel$TriggerModelState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.fullLine.core.completion.trigger"})
        public static final class NotLoaded
        implements TriggerModelState {
            @NotNull
            public static final NotLoaded INSTANCE = new NotLoaded();

            private NotLoaded() {
            }

            @NotNull
            public String toString() {
                return "NotLoaded";
            }

            public int hashCode() {
                return 953410629;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NotLoaded)) {
                    return false;
                }
                NotLoaded cfr_ignored_0 = (NotLoaded)other;
                return true;
            }
        }
    }
}

