/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.fus;

import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadUtil;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreter;
import com.intellij.javascript.nodejs.interpreter.fus.LocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.fus.NvmrcStatus;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.npm.WorkingDirectoryDependentNpmPackageVersionManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.util.text.SemVer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a&\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\tH\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u0001*\u0004\u0018\u00010\u0007H\u0000\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0005*\u00020\u0007H\u0000\u001a\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u0004\u0018\u00010\u0005H\u0000\u001a\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0002\"\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"getPackageManagerName", "", "packageManagerRef", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "getPackageManagerVersion", "Lcom/intellij/util/text/SemVer;", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "packageManagerPkg", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "project", "Lcom/intellij/openapi/project/Project;", "guessPackageManagerName", "pkg", "PACKAGE_MANAGERS", "", "getPACKAGE_MANAGERS", "()Ljava/util/List;", "getTypeId", "getVersionSync", "toVersion", "Lcom/intellij/openapi/util/Version;", "getNvmrcStatus", "Lcom/intellij/javascript/nodejs/interpreter/fus/NvmrcStatus;", "nvmrcFileInfo", "Lcom/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager$NodeVersionFileInfo;", "interpreterVersion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNodeInterpreterAndPackageManagerStateUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeInterpreterAndPackageManagerStateUsagesCollector.kt\ncom/intellij/javascript/nodejs/interpreter/fus/NodeInterpreterAndPackageManagerStateUsagesCollectorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
public final class NodeInterpreterAndPackageManagerStateUsagesCollectorKt {
    @NotNull
    private static final List<String> PACKAGE_MANAGERS;

    @Nullable
    public static final String getPackageManagerName(@NotNull NodePackageRef packageManagerRef) {
        String string;
        Intrinsics.checkNotNullParameter((Object)packageManagerRef, (String)"packageManagerRef");
        if (packageManagerRef.isConstant()) {
            NodePackage nodePackage = packageManagerRef.getConstantPackage();
            Intrinsics.checkNotNull((Object)nodePackage);
            string = NodeInterpreterAndPackageManagerStateUsagesCollectorKt.guessPackageManagerName(nodePackage);
        } else {
            String string2 = packageManagerRef.getReferenceName();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        return string;
    }

    private static final SemVer getPackageManagerVersion(NodeJsInterpreter interpreter2, NodePackage packageManagerPkg, Project project) {
        Promise promise;
        if (packageManagerPkg == null) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new SemVer("1.0.0", 1, 0, 0);
        }
        CompletableFuture versionFuture = new CompletableFuture();
        if (packageManagerPkg instanceof NpmNodePackage && interpreter2 != null) {
            WorkingDirectoryDependentNpmPackageVersionManager.getInstance(project).fetchVersion(interpreter2, packageManagerPkg, arg_0 -> NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getPackageManagerVersion$lambda$0(versionFuture, arg_0));
        } else {
            promise = packageManagerPkg.getVersionPromise(project).onSuccess(arg_0 -> NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getPackageManagerVersion$lambda$2(arg_0 -> NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getPackageManagerVersion$lambda$1(versionFuture, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)promise);
        }
        try {
            promise = (SemVer)versionFuture.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            promise = null;
        }
        return promise;
    }

    private static final String guessPackageManagerName(NodePackage pkg) {
        return NpmUtil.isYarnAlikePackage(pkg) ? "yarn" : (NpmUtil.isPnpmPackage(pkg) ? "pnpm" : (NpmUtil.isBunPackage(pkg) ? "bun" : (StringsKt.contains((CharSequence)pkg.getSystemIndependentPath(), (CharSequence)"npm", (boolean)true) ? "npm" : null)));
    }

    @NotNull
    public static final List<String> getPACKAGE_MANAGERS() {
        return PACKAGE_MANAGERS;
    }

    @NotNull
    public static final String getTypeId(@Nullable NodeJsInterpreter $this$getTypeId) {
        if ($this$getTypeId == null) {
            return "unresolved";
        }
        try {
            TargetEnvironmentType<?> targetEnvironmentType = $this$getTypeId.getTargetEnvironmentType();
            if (targetEnvironmentType != null) {
                TargetEnvironmentType<?> it = targetEnvironmentType;
                boolean bl = false;
                return it.getId();
            }
        }
        catch (IllegalStateException illegalStateException) {
            return "unresolved";
        }
        if ($this$getTypeId instanceof NodeJsDownloadableInterpreter) {
            return LocalInterpreterType.DOWNLOADED.id();
        }
        NodeJsLocalInterpreter nodeJsLocalInterpreter = $this$getTypeId instanceof NodeJsLocalInterpreter ? (NodeJsLocalInterpreter)$this$getTypeId : null;
        if (nodeJsLocalInterpreter == null) {
            return "other";
        }
        NodeJsLocalInterpreter localInterpreter = nodeJsLocalInterpreter;
        String string = localInterpreter.getInterpreterSystemIndependentPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInterpreterSystemIndependentPath(...)");
        String interpreterPath = string;
        LocalInterpreterType localType = NodeDownloadUtil.INSTANCE.isDownloaded(localInterpreter) ? LocalInterpreterType.DOWNLOADED : (StringsKt.contains$default((CharSequence)interpreterPath, (CharSequence)"/.nvm/", (boolean)false, (int)2, null) ? LocalInterpreterType.NVM : (StringsKt.contains$default((CharSequence)interpreterPath, (CharSequence)"/.volta/", (boolean)false, (int)2, null) ? LocalInterpreterType.VOLTA : (StringsKt.contains$default((CharSequence)interpreterPath, (CharSequence)"/.asdf/", (boolean)false, (int)2, null) ? LocalInterpreterType.ASDF : (StringsKt.startsWith$default((String)interpreterPath, (String)"/usr/bin/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)interpreterPath, (String)"/usr/local/bin/", (boolean)false, (int)2, null) ? LocalInterpreterType.SYSTEM : LocalInterpreterType.OTHER))));
        return localType.id();
    }

    @Nullable
    public static final SemVer getVersionSync(@NotNull NodeJsInterpreter $this$getVersionSync) {
        SemVer semVer;
        Intrinsics.checkNotNullParameter((Object)$this$getVersionSync, (String)"<this>");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new SemVer("21.0.0", 21, 0, 0);
        }
        try {
            semVer = (SemVer)$this$getVersionSync.provideCachedVersionOrFetch().blockingGet(500);
        }
        catch (Exception exception) {
            semVer = null;
        }
        return semVer;
    }

    @Nullable
    public static final Version toVersion(@Nullable SemVer $this$toVersion) {
        Version version2;
        SemVer semVer = $this$toVersion;
        if (semVer != null) {
            SemVer it = semVer;
            boolean bl = false;
            version2 = new Version(it.getMajor(), it.getMinor(), it.getPatch());
        } else {
            version2 = null;
        }
        return version2;
    }

    private static final NvmrcStatus getNvmrcStatus(NodeJsLocalInterpreterManager.NodeVersionFileInfo nvmrcFileInfo, SemVer interpreterVersion) {
        NodeJsLocalInterpreter nvmrcInterpreter;
        NodeJsLocalInterpreter nodeJsLocalInterpreter = nvmrcInterpreter = NodeJsLocalInterpreterManager.resolveNvmRcInterpreter(nvmrcFileInfo.getFileContent(), 0);
        SemVer nvmrcInterpreterVersion = nodeJsLocalInterpreter != null ? NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getVersionSync(nodeJsLocalInterpreter) : null;
        return new NvmrcStatus(interpreterVersion != null && Intrinsics.areEqual((Object)interpreterVersion, (Object)nvmrcInterpreterVersion), nvmrcInterpreter != null);
    }

    private static final void getPackageManagerVersion$lambda$0(CompletableFuture $versionFuture, SemVer it) {
        $versionFuture.complete(it);
    }

    private static final Unit getPackageManagerVersion$lambda$1(CompletableFuture $versionFuture, SemVer it) {
        $versionFuture.complete(it);
        return Unit.INSTANCE;
    }

    private static final void getPackageManagerVersion$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ NvmrcStatus access$getNvmrcStatus(NodeJsLocalInterpreterManager.NodeVersionFileInfo nvmrcFileInfo, SemVer interpreterVersion) {
        return NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getNvmrcStatus(nvmrcFileInfo, interpreterVersion);
    }

    public static final /* synthetic */ SemVer access$getPackageManagerVersion(NodeJsInterpreter interpreter2, NodePackage packageManagerPkg, Project project) {
        return NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getPackageManagerVersion(interpreter2, packageManagerPkg, project);
    }

    static {
        Object[] objectArray = new String[]{"npm", "yarn", "pnpm", "bun"};
        PACKAGE_MANAGERS = CollectionsKt.listOf((Object[])objectArray);
    }
}

