/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupContext;
import com.intellij.lang.javascript.completion.JSLookupElementInfo;
import com.intellij.lang.javascript.completion.JSLookupElementInfoImpl;
import com.intellij.lang.javascript.completion.JSLookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptLiteralType;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLookupElementMerger {
    @NotNull
    private final MergeFilter myFilter;
    protected final int myLimit;
    @Nullable
    protected final PsiElement myPlace;
    private final boolean myFirstOverloadOnly;
    @NotNull
    protected final MultiMap<String, JSLookupElementInfo> myResults;

    public JSLookupElementMerger(@Nullable PsiElement place, @NotNull MergeFilter filter, int limit, boolean firstOverloadOnly) {
        if (filter == null) {
            JSLookupElementMerger.$$$reportNull$$$0(0);
        }
        this.myResults = MultiMap.create();
        this.myFilter = filter;
        this.myLimit = limit;
        this.myPlace = place;
        this.myFirstOverloadOnly = firstOverloadOnly;
    }

    protected final boolean checkLimit() {
        return this.myResults.size() <= this.myLimit;
    }

    @NotNull
    public final Collection<LookupElement> merge(@NotNull String name, @NotNull Collection<JSLookupElementInfo> infos, boolean firstOverloadOnly) {
        InsertHandler<LookupElement> insertHandler;
        boolean noParams;
        if (name == null) {
            JSLookupElementMerger.$$$reportNull$$$0(1);
        }
        if (infos == null) {
            JSLookupElementMerger.$$$reportNull$$$0(2);
        }
        if (infos.isEmpty()) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                JSLookupElementMerger.$$$reportNull$$$0(3);
            }
            return list;
        }
        Collection<JSLookupElementInfo> collection = infos = firstOverloadOnly ? TypeScriptPsiUtil.removeDuplicates(infos, el -> el.getElement(), this.myPlace) : infos;
        if (infos.size() == 1) {
            JSLookupElementInfo info = (JSLookupElementInfo)ContainerUtil.getFirstItem(infos);
            List list = ContainerUtil.createMaybeSingletonList((Object)info.toLookupElement());
            if (list == null) {
                JSLookupElementMerger.$$$reportNull$$$0(4);
            }
            return list;
        }
        JSLookupElementInfo.FunctionType type2 = JSLookupElementMerger.getFunctionType(infos);
        if (this.areOverloads(infos, type2)) {
            Collection<LookupElement> collection2 = this.mergeOverloads(name, infos, firstOverloadOnly);
            if (collection2 == null) {
                JSLookupElementMerger.$$$reportNull$$$0(5);
            }
            return collection2;
        }
        boolean areFunctions = type2 != JSLookupElementInfo.FunctionType.NOT_FUNCTION;
        List pointers = Collections.emptyList();
        if (infos.size() < 5) {
            pointers = ContainerUtil.mapNotNull(infos, it -> {
                PsiElement element2 = it.getElement();
                if (element2 != null) {
                    return SmartPointerManager.createPointer((PsiElement)element2);
                }
                return null;
            });
        }
        LookupElementBuilder lookupItem = !pointers.isEmpty() ? LookupElementBuilder.create((Object)pointers, (String)name) : LookupElementBuilder.create((String)name);
        lookupItem = lookupItem.withTypeText("");
        boolean bl = noParams = type2 == JSLookupElementInfo.FunctionType.FUNCTION_NO_ARGS;
        String postfix = areFunctions ? (noParams ? "()" : "(...)") : "";
        JSLookupPriority priority = JSLookupElementMerger.getPriority(infos);
        JSLookupContext lookupContext = JSLookupContext.Companion.fromLocation(this.myPlace);
        lookupItem = new JSLookupElementRenderer(name, priority, JSLookupElementMerger.isPartial(infos), JSLookupUtilImpl.SEVERAL_DEFINITIONS_ICON, postfix, lookupContext, false).applyToBuilder(lookupItem);
        Object object = JSInsertHandler.isIndexer(name) ? JSInsertHandler.DEFAULT_AS_INDEXER : (insertHandler = areFunctions ? JSInsertHandler.DEFAULT : null);
        if (areFunctions) {
            JSInsertHandler.ForcedCompleteFunctionType completeFunctionType = noParams ? JSInsertHandler.ForcedCompleteFunctionType.EMPTY_PARAMETERS : JSInsertHandler.ForcedCompleteFunctionType.WITH_PARAMETERS;
            lookupItem.putUserData(JSInsertHandler.FORCED_COMPLETE_FUNCTION, (Object)completeFunctionType);
        }
        if (insertHandler != null) {
            lookupItem = lookupItem.withInsertHandler(insertHandler);
        }
        Set<LookupElement> set = Collections.singleton(JSCompletionUtil.withJSLookupPriority((LookupElement)lookupItem, priority));
        if (set == null) {
            JSLookupElementMerger.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    protected Collection<LookupElement> mergeOverloads(@NotNull String name, @NotNull Collection<JSLookupElementInfo> infos, boolean firstOverloadOnly) {
        if (name == null) {
            JSLookupElementMerger.$$$reportNull$$$0(7);
        }
        if (infos == null) {
            JSLookupElementMerger.$$$reportNull$$$0(8);
        }
        if (firstOverloadOnly) {
            JSLookupElementInfo info = JSLookupElementMerger.getPreferableOverload(infos);
            LookupElement element2 = JSLookupElementMerger.unwrapPriority(info.toLookupElement());
            if (element2 == null) {
                List<LookupElement> list = Collections.emptyList();
                if (list == null) {
                    JSLookupElementMerger.$$$reportNull$$$0(9);
                }
                return list;
            }
            if (element2 instanceof LookupElementBuilder) {
                LookupElementRenderer renderer = ((LookupElementBuilder)element2).getRenderer();
                element2 = renderer instanceof JSLookupElementRenderer ? ((JSLookupElementRenderer)renderer).applyToBuilderWithIcon((LookupElementBuilder)element2, JSLookupUtilImpl.SEVERAL_DEFINITIONS_ICON) : ((LookupElementBuilder)element2).withIcon(JSLookupUtilImpl.SEVERAL_DEFINITIONS_ICON);
            }
            JSLookupPriority priority = info.getPriority();
            if (this.isInsertAsIndexer(name)) {
                priority = JSLookupUtilImpl.getIndexerPriority(priority);
            }
            Set<LookupElement> set = Collections.singleton(JSCompletionUtil.withJSLookupPriority(element2, priority));
            if (set == null) {
                JSLookupElementMerger.$$$reportNull$$$0(10);
            }
            return set;
        }
        List list = StreamEx.of(infos).map(JSLookupElementInfo::toLookupElement).nonNull().toList();
        if (list == null) {
            JSLookupElementMerger.$$$reportNull$$$0(11);
        }
        return list;
    }

    private boolean isInsertAsIndexer(@NotNull String name) {
        if (name == null) {
            JSLookupElementMerger.$$$reportNull$$$0(12);
        }
        return JSLookupUtilImpl.isExoticName(name) && !(this.myPlace instanceof JSIndexedPropertyAccessExpression);
    }

    @Contract(value="!null->!null")
    public static LookupElement unwrapPriority(@Nullable LookupElement element2) {
        if (element2 instanceof LookupElementDecorator) {
            return ((LookupElementDecorator)element2).getDelegate();
        }
        return element2;
    }

    @NotNull
    private static JSLookupElementInfo getPreferableOverload(@NotNull Collection<JSLookupElementInfo> infos) {
        if (infos == null) {
            JSLookupElementMerger.$$$reportNull$$$0(13);
        }
        Comparator<JSLookupElementInfo> comparator = Comparator.comparing(el -> {
            PsiElement element2 = el.getElement();
            return element2 instanceof JSFunction ? ((JSFunction)element2).getParameters().length : 0;
        }).thenComparing(el -> {
            PsiElement element2 = el.getElement();
            if (!(element2 instanceof JSFunction)) {
                return 0;
            }
            return (int)((StreamEx)StreamEx.of((Object[])((JSFunction)element2).getParameters()).filter(cur -> cur.getTypeElement() instanceof TypeScriptLiteralType)).count();
        });
        JSLookupElementInfo jSLookupElementInfo = infos.stream().min(comparator).orElse((JSLookupElementInfo)ContainerUtil.getFirstItem(infos));
        if (jSLookupElementInfo == null) {
            JSLookupElementMerger.$$$reportNull$$$0(14);
        }
        return jSLookupElementInfo;
    }

    protected boolean areOverloads(@NotNull Collection<JSLookupElementInfo> infos, @NotNull JSLookupElementInfo.FunctionType type2) {
        JSLookupElementInfo item;
        if (infos == null) {
            JSLookupElementMerger.$$$reportNull$$$0(15);
        }
        if (type2 == null) {
            JSLookupElementMerger.$$$reportNull$$$0(16);
        }
        if ((item = (JSLookupElementInfo)ContainerUtil.getFirstItem(infos)).isPartial()) {
            return false;
        }
        if (type2 == JSLookupElementInfo.FunctionType.NOT_FUNCTION) {
            return false;
        }
        for (JSLookupElementInfo info : infos) {
            PsiElement current = info.getElement();
            if (current != null && DialectDetector.isTypeScript(current)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final List<LookupElement> values() {
        ArrayList<LookupElement> results = new ArrayList<LookupElement>();
        for (Map.Entry entry : this.myResults.entrySet()) {
            ProgressManager.checkCanceled();
            String name = (String)entry.getKey();
            Collection value = (Collection)entry.getValue();
            results.addAll(this.merge(name, value, this.myFirstOverloadOnly));
        }
        ArrayList<LookupElement> arrayList = results;
        if (arrayList == null) {
            JSLookupElementMerger.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    public static JSLookupElementInfo.FunctionType getFunctionType(@NotNull Collection<JSLookupElementInfo> infos) {
        if (infos == null) {
            JSLookupElementMerger.$$$reportNull$$$0(18);
        }
        JSLookupElementInfo.FunctionType prev = null;
        for (JSLookupElementInfo info : infos) {
            JSLookupElementInfo.FunctionType type2 = info.getFunctionType();
            if (type2 == JSLookupElementInfo.FunctionType.NOT_FUNCTION) {
                return JSLookupElementInfo.FunctionType.NOT_FUNCTION;
            }
            if (prev == null) {
                prev = type2;
                continue;
            }
            if (prev == JSLookupElementInfo.FunctionType.FUNCTION_NO_ARGS || type2 != JSLookupElementInfo.FunctionType.FUNCTION_NO_ARGS) continue;
            prev = type2;
        }
        return prev;
    }

    @Nullable
    public static PsiElement mergeOverloads(@NotNull Collection<PsiElement> elements, @NotNull PsiElement first) {
        if (elements == null) {
            JSLookupElementMerger.$$$reportNull$$$0(19);
        }
        if (first == null) {
            JSLookupElementMerger.$$$reportNull$$$0(20);
        }
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return first;
        }
        if (first instanceof TypeScriptFunction) {
            Collection<TypeScriptFunction> overloads = TypeScriptPsiUtil.getAllOverloadsWithImplementation((TypeScriptFunction)first);
            if (elements.size() == overloads.size()) {
                return first;
            }
        }
        return null;
    }

    @NotNull
    public static JSLookupPriority getPriority(@NotNull Collection<JSLookupElementInfo> infos) {
        if (infos == null) {
            JSLookupElementMerger.$$$reportNull$$$0(21);
        }
        JSLookupPriority jSLookupPriority = ((JSLookupElementInfo)ContainerUtil.getFirstItem(infos)).getPriority();
        if (jSLookupPriority == null) {
            JSLookupElementMerger.$$$reportNull$$$0(22);
        }
        return jSLookupPriority;
    }

    public static boolean isPartial(@NotNull Collection<JSLookupElementInfo> infos) {
        if (infos == null) {
            JSLookupElementMerger.$$$reportNull$$$0(23);
        }
        return ((JSLookupElementInfo)ContainerUtil.getFirstItem(infos)).isPartial();
    }

    public boolean addResult(@Nullable PsiElement element2, @NotNull String name, @NotNull JSLookupPriority priority, @NotNull BaseJSSymbolProcessor.MatchType matchType, @Nullable JSTypeSubstitutor typeSubstitutor) {
        PsiElement originalElement;
        if (name == null) {
            JSLookupElementMerger.$$$reportNull$$$0(24);
        }
        if (priority == null) {
            JSLookupElementMerger.$$$reportNull$$$0(25);
        }
        if (matchType == null) {
            JSLookupElementMerger.$$$reportNull$$$0(26);
        }
        PsiElement psiElement = originalElement = element2 != null ? CompletionUtil.getOriginalElement((PsiElement)element2) : null;
        if (originalElement != null) {
            element2 = originalElement;
        }
        if (!this.myFilter.accept(element2, priority)) {
            return true;
        }
        Collection infos = this.myResults.get((Object)name);
        if (infos.isEmpty()) {
            this.myResults.putValue((Object)name, (Object)this.createMergeInfo(element2, name, priority, matchType, typeSubstitutor));
            return this.checkLimit();
        }
        JSLookupElementInfo item = (JSLookupElementInfo)ContainerUtil.getFirstItem((Collection)infos);
        int compareResult = item.compareTo(element2, priority, matchType, this.myPlace);
        if (compareResult > 0) {
            return true;
        }
        JSLookupElementInfoImpl newInfo = this.createMergeInfo(element2, name, priority, matchType, typeSubstitutor);
        if (compareResult < 0) {
            this.myResults.remove((Object)name);
        }
        this.myResults.putValue((Object)name, (Object)newInfo);
        return this.checkLimit();
    }

    @NotNull
    protected JSLookupElementInfoImpl createMergeInfo(@Nullable PsiElement element2, @NotNull String name, @NotNull JSLookupPriority priority, @NotNull BaseJSSymbolProcessor.MatchType matchType, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (name == null) {
            JSLookupElementMerger.$$$reportNull$$$0(27);
        }
        if (priority == null) {
            JSLookupElementMerger.$$$reportNull$$$0(28);
        }
        if (matchType == null) {
            JSLookupElementMerger.$$$reportNull$$$0(29);
        }
        return new JSLookupElementInfoImpl(element2, name, priority, matchType, new JSLookupContext(this.myPlace, typeSubstitutor));
    }

    @Nullable
    public static Icon getIcon(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            JSLookupElementMerger.$$$reportNull$$$0(30);
        }
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
        Icon icon = JSLookupUtilImpl.getLookupElementIcon(item);
        for (PsiElement psiElement : elements) {
            Icon current;
            if (psiElement == item || Objects.equals(icon, current = JSLookupUtilImpl.getLookupElementIcon(item))) continue;
            return JSLookupUtilImpl.SEVERAL_DEFINITIONS_ICON;
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 9, 10, 11, 14, 17, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 8: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSLookupElementMerger";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSLookupElementMerger";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeOverloads";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferableOverload";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 22: {
                break;
            }
            case 7: 
            case 8: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "mergeOverloads";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInsertAsIndexer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableOverload";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "areOverloads";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPriority";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isPartial";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addResult";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createMergeInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 9, 10, 11, 14, 17, 22 -> new IllegalStateException(string);
        };
    }

    public static interface MergeFilter {
        public boolean accept(@Nullable PsiElement var1, @NotNull JSLookupPriority var2);
    }
}

