/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules.resolver;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.frameworks.modules.JSModuleMapping;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSSimpleFileReferenceRootsProviderKt;
import com.intellij.lang.javascript.modules.JSFileResolveRootsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\nH\u0004J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0004J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\nH\u0004J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSSimpleFileReferenceRootsProvider;", "Lcom/intellij/lang/javascript/modules/JSFileResolveRootsProvider;", "resolveContext", "Lcom/intellij/lang/javascript/config/JSImportResolveContext;", "<init>", "(Lcom/intellij/lang/javascript/config/JSImportResolveContext;)V", "getResolveContext", "()Lcom/intellij/lang/javascript/config/JSImportResolveContext;", "getDefaultRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "moduleName", "", "contextFile", "collectNodeResolverRoots", "containingDirectory", "getNodeModulesTypesDirectories", "nodeModules", "getNodeModulesContexts", "toSearchDir", "fillPathMappingConfigRoots", "", "altResolveModules", "", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSSimpleFileReferenceRootsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSSimpleFileReferenceRootsProvider.kt\ncom/intellij/lang/javascript/frameworks/modules/resolver/JSSimpleFileReferenceRootsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1#2:169\n1#2:180\n1#2:193\n1617#3,9:170\n1869#3:179\n1870#3:181\n1626#3:182\n1617#3,9:183\n1869#3:192\n1870#3:194\n1626#3:195\n*S KotlinDebug\n*F\n+ 1 JSSimpleFileReferenceRootsProvider.kt\ncom/intellij/lang/javascript/frameworks/modules/resolver/JSSimpleFileReferenceRootsProvider\n*L\n60#1:180\n94#1:193\n60#1:170,9\n60#1:179\n60#1:181\n60#1:182\n94#1:183,9\n94#1:192\n94#1:194\n94#1:195\n*E\n"})
public class JSSimpleFileReferenceRootsProvider
implements JSFileResolveRootsProvider {
    @NotNull
    private final JSImportResolveContext resolveContext;

    public JSSimpleFileReferenceRootsProvider(@NotNull JSImportResolveContext resolveContext) {
        Intrinsics.checkNotNullParameter((Object)resolveContext, (String)"resolveContext");
        this.resolveContext = resolveContext;
    }

    @NotNull
    protected final JSImportResolveContext getResolveContext() {
        return this.resolveContext;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDefaultRoots(@NotNull Project project, @NotNull String moduleName, @NotNull VirtualFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        VirtualFile virtualFile = contextFile.getParent();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile containingDirectory = virtualFile;
        if (JSSimpleFileReferenceRootsProviderKt.isExternalModuleNameRelative(moduleName)) {
            return CollectionsKt.listOf((Object)containingDirectory);
        }
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        result2.addAll(this.collectNodeResolverRoots(project, moduleName, containingDirectory));
        return result2;
    }

    @NotNull
    protected final Collection<VirtualFile> collectNodeResolverRoots(@NotNull Project project, @NotNull String moduleName, @NotNull VirtualFile containingDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)containingDirectory, (String)"containingDirectory");
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        VirtualFile virtualFile = this.resolveContext.baseUrl();
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            result2.add(it);
        }
        Collection<VirtualFile> nodeModules = this.getNodeModulesContexts(project, containingDirectory);
        result2.addAll(this.getNodeModulesTypesDirectories(nodeModules));
        result2.addAll(nodeModules);
        result2.addAll(JSSimpleFileReferenceRootsProviderKt.getYarnPnpContexts(project, containingDirectory, moduleName));
        if (this.resolveContext.hasParentDirectoryContext()) {
            result2.add(containingDirectory);
        }
        if (StringsKt.startsWith$default((String)moduleName, (String)"/", (boolean)false, (int)2, null) && FileUtil.isAbsolute((String)moduleName)) {
            VirtualFile virtualFile2 = containingDirectory.getFileSystem().findFileByPath("/");
            if (virtualFile2 != null) {
                VirtualFile it = virtualFile2;
                boolean bl = false;
                result2.add(it);
            }
        }
        this.fillPathMappingConfigRoots(containingDirectory, (Collection<VirtualFile>)result2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Collection<VirtualFile> getNodeModulesTypesDirectories(@NotNull Collection<? extends VirtualFile> nodeModules) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(nodeModules, (String)"nodeModules");
        Iterable $this$mapNotNull$iv = nodeModules;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (it.findChild("@types") == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final Collection<VirtualFile> getNodeModulesContexts(@NotNull Project project, @NotNull VirtualFile toSearchDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toSearchDir, (String)"toSearchDir");
        Collection collection = ((ConcurrentHashMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> JSSimpleFileReferenceRootsProvider.getNodeModulesContexts$lambda$3(project))).computeIfAbsent(toSearchDir, arg_0 -> JSSimpleFileReferenceRootsProvider.getNodeModulesContexts$lambda$9(arg_0 -> JSSimpleFileReferenceRootsProvider.getNodeModulesContexts$lambda$8(toSearchDir, project, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"computeIfAbsent(...)");
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final void fillPathMappingConfigRoots(VirtualFile containingDirectory, Collection<VirtualFile> altResolveModules) {
        VirtualFile url = this.resolveContext.baseUrl();
        if (url == null) {
            return;
        }
        JSModulePathMappings<? extends JSModulePathSubstitution> jSModulePathMappings = this.resolveContext.pathsMappings();
        Intrinsics.checkNotNullExpressionValue(jSModulePathMappings, (String)"pathsMappings(...)");
        JSModulePathMappings<? extends JSModulePathSubstitution> pathsMappings = jSModulePathMappings;
        for (JSModulePathSubstitution jSModulePathSubstitution : pathsMappings.findByMappedName("*")) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            List<String> paths;
            Collection<JSModuleMapping> mappings;
            Intrinsics.checkNotNullExpressionValue(JSPathMappingsUtil.getMappings(jSModulePathSubstitution, new JSModuleMapping(""), false), (String)"getMappings(...)");
            Intrinsics.checkNotNullExpressionValue(JSPathMappingsUtil.getPathForExactReferences(url, new JSModuleMapping(""), mappings), (String)"getPathForExactReferences(...)");
            Intrinsics.checkNotNullExpressionValue((Object)containingDirectory.getFileSystem(), (String)"getFileSystem(...)");
            Iterable iterable = paths;
            Collection<VirtualFile> collection = altResolveModules;
            boolean $i$f$mapNotNull = false;
            void var12_12 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile it$iv$iv;
                VirtualFileSystem system;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (system.findFileByPath(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            collection.addAll((List)destination$iv$iv);
        }
    }

    private static final CachedValueProvider.Result getNodeModulesContexts$lambda$3(Project $project) {
        Object[] objectArray = new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootManager.getInstance((Project)$project)};
        return CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])objectArray);
    }

    private static final boolean getNodeModulesContexts$lambda$8$lambda$6(SmartList $nodeModules, VirtualFile it) {
        boolean it2 = $nodeModules.add((Object)it);
        boolean bl = false;
        return true;
    }

    private static final boolean getNodeModulesContexts$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Collection getNodeModulesContexts$lambda$8(VirtualFile $toSearchDir, Project $project, VirtualFile it) {
        VirtualFile parent;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SmartList nodeModules = new SmartList();
        VirtualFile virtualFile = parent = NodeModuleSearchUtil.findAncestorNodeModulesDir($toSearchDir);
        if (virtualFile != null) {
            VirtualFile it2 = virtualFile;
            boolean bl = false;
            nodeModules.add((Object)it2);
        }
        NodeModuleSearchUtil.processUpNodeModulesDirs($project, $toSearchDir, (Processor<? super VirtualFile>)((Processor)arg_0 -> JSSimpleFileReferenceRootsProvider.getNodeModulesContexts$lambda$8$lambda$7(arg_0 -> JSSimpleFileReferenceRootsProvider.getNodeModulesContexts$lambda$8$lambda$6(nodeModules, arg_0), arg_0)));
        return (Collection)nodeModules;
    }

    private static final Collection getNodeModulesContexts$lambda$9(Function1 $tmp0, Object p0) {
        return (Collection)$tmp0.invoke(p0);
    }
}

