/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules.resolver;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpDependency;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.typings.TypeScriptDefinitionsUtils;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolverImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007\u001a0\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a*\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0007\u00a8\u0006\u0014"}, d2={"getYarnPnpContexts", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "requestor", "requiredModuleName", "", "getTypingDependencyName", "dependencyName", "findYarnPnpDependency", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;", "pnpManager", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpManager;", "directDependenciesOnly", "", "findYarnPnpDependencyContext", "requester", "isExternalModuleNameRelative", "moduleName", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSSimpleFileReferenceRootsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSSimpleFileReferenceRootsProvider.kt\ncom/intellij/lang/javascript/frameworks/modules/resolver/JSSimpleFileReferenceRootsProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1#2:169\n*E\n"})
public final class JSSimpleFileReferenceRootsProviderKt {
    @NotNull
    public static final Collection<VirtualFile> getYarnPnpContexts(@NotNull Project project, @Nullable VirtualFile requestor, @NotNull String requiredModuleName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requiredModuleName, (String)"requiredModuleName");
        if (requestor == null) {
            return CollectionsKt.emptyList();
        }
        YarnPnpManager yarnPnpManager = YarnPnpManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)yarnPnpManager, (String)"getInstance(...)");
        YarnPnpManager pnpManager = yarnPnpManager;
        if (pnpManager.hasPnpFiles()) {
            String string = NodeModuleSearchUtil.extractDependencyName(requiredModuleName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractDependencyName(...)");
            String dependencyName = string;
            VirtualFile contextRoot = JSSimpleFileReferenceRootsProviderKt.findYarnPnpDependencyContext(project, requestor, dependencyName, pnpManager);
            SmartList result2 = new SmartList();
            String typingDependencyName = JSSimpleFileReferenceRootsProviderKt.getTypingDependencyName(dependencyName);
            VirtualFile typingContextRoot = JSSimpleFileReferenceRootsProviderKt.findYarnPnpDependencyContext(project, requestor, typingDependencyName, pnpManager);
            if (typingContextRoot != null) {
                ContainerUtil.addIfNotNull((Collection)((Collection)result2), (Object)typingContextRoot.findChild("@types"));
            }
            ContainerUtil.addIfNotNull((Collection)((Collection)result2), (Object)contextRoot);
            return (Collection)result2;
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final String getTypingDependencyName(@NotNull String dependencyName) {
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        String depNameWithoutTypingScope = dependencyName;
        if (NodeModuleSearchUtil.isScopedPackageName(dependencyName)) {
            depNameWithoutTypingScope = TypeScriptFileImportsResolverImpl.Companion.convertToTypesDirectory(dependencyName);
        }
        return TypeScriptDefinitionsUtils.getTypingsPackageName(depNameWithoutTypingScope);
    }

    @Nullable
    public static final YarnPnpDependency findYarnPnpDependency(@NotNull Project project, @NotNull VirtualFile requestor, @NotNull String dependencyName, @NotNull YarnPnpManager pnpManager, boolean directDependenciesOnly) {
        YarnPnpDependency dependency;
        VirtualFile packageJsonWithDependency;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        Intrinsics.checkNotNullParameter((Object)pnpManager, (String)"pnpManager");
        if (StringsKt.isBlank((CharSequence)dependencyName)) {
            return null;
        }
        VirtualFile virtualFile = packageJsonWithDependency = (VirtualFile)PackageJsonUtil.processUpPackageJsonFilesAndFindFirst(project, requestor, arg_0 -> JSSimpleFileReferenceRootsProviderKt.findYarnPnpDependency$lambda$1(arg_0 -> JSSimpleFileReferenceRootsProviderKt.findYarnPnpDependency$lambda$0(dependencyName, arg_0), arg_0));
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            v1 = pnpManager.findDependency(it, dependencyName);
        } else {
            v1 = dependency = null;
        }
        if (dependency == null && !directDependenciesOnly) {
            YarnPnpDependency requestorDependency;
            YarnPnpDependency yarnPnpDependency = requestorDependency = pnpManager.findDependencyByFileOrDirectory(requestor);
            return yarnPnpDependency != null ? yarnPnpDependency.findChildDependencyByName(dependencyName) : null;
        }
        return dependency;
    }

    private static final VirtualFile findYarnPnpDependencyContext(Project project, VirtualFile requester, String dependencyName, YarnPnpManager pnpManager) {
        Object object;
        VirtualFile dependencyRoot;
        YarnPnpDependency dependency;
        YarnPnpDependency yarnPnpDependency = dependency = JSSimpleFileReferenceRootsProviderKt.findYarnPnpDependency(project, requester, dependencyName, pnpManager, false);
        Object object2 = dependencyRoot = yarnPnpDependency != null ? yarnPnpDependency.resolveLocation() : null;
        if (dependencyRoot != null) {
            if (NodeModuleSearchUtil.isScopedPackageName(dependencyName)) {
                VirtualFile parent;
                VirtualFile virtualFile = parent = dependencyRoot.getParent();
                object = virtualFile != null ? virtualFile.getParent() : null;
            } else {
                object = dependencyRoot.getParent();
            }
        } else {
            object = null;
        }
        return object;
    }

    public static final boolean isExternalModuleNameRelative(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        String string = FileUtil.toSystemIndependentName((String)moduleName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String path2 = string;
        return Intrinsics.areEqual((Object)path2, (Object)".") || Intrinsics.areEqual((Object)path2, (Object)"..") || StringsKt.startsWith$default((String)path2, (String)"./", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path2, (String)"../", (boolean)false, (int)2, null) || FileUtil.isAbsolute((String)moduleName);
    }

    private static final VirtualFile findYarnPnpDependency$lambda$0(String $dependencyName, VirtualFile it) {
        return PackageJsonData.getOrCreate(it).isDependencyOfAnyType($dependencyName) ? it : null;
    }

    private static final VirtualFile findYarnPnpDependency$lambda$1(Function1 $tmp0, Object p0) {
        return (VirtualFile)$tmp0.invoke(p0);
    }
}

