/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.library.JSPredefinedLibrariesData;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class JSPredefinedLibraryManager
implements Disposable {
    private final Project myProject;
    private final AtomicReference<JSPredefinedLibrariesData> myCachedDataRef;

    @NotNull
    public static JSPredefinedLibraryManager getPredefinedLibraryManager(@NotNull Project project) {
        if (project == null) {
            JSPredefinedLibraryManager.$$$reportNull$$$0(0);
        }
        JSPredefinedLibraryManager jSPredefinedLibraryManager = (JSPredefinedLibraryManager)project.getService(JSPredefinedLibraryManager.class);
        if (jSPredefinedLibraryManager == null) {
            JSPredefinedLibraryManager.$$$reportNull$$$0(1);
        }
        return jSPredefinedLibraryManager;
    }

    public JSPredefinedLibraryManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            JSPredefinedLibraryManager.$$$reportNull$$$0(2);
        }
        if (coroutineScope == null) {
            JSPredefinedLibraryManager.$$$reportNull$$$0(3);
        }
        this.myCachedDataRef = new AtomicReference();
        this.myProject = project;
        JSPredefinedLibraryProvider.EP_NAME.addChangeListener(coroutineScope, () -> this.invalidatePredefinedLibrariesCache());
    }

    @NotNull
    private JSPredefinedLibrariesData getData() {
        JSPredefinedLibrariesData data2 = this.myCachedDataRef.get();
        if (data2 == null) {
            data2 = JSPredefinedLibrariesData.create(this.myProject);
            this.myCachedDataRef.set(data2);
        }
        JSPredefinedLibrariesData jSPredefinedLibrariesData = data2;
        if (jSPredefinedLibrariesData == null) {
            JSPredefinedLibraryManager.$$$reportNull$$$0(4);
        }
        return jSPredefinedLibrariesData;
    }

    public void dispose() {
    }

    public void invalidatePredefinedLibrariesCache() {
        this.myCachedDataRef.set(null);
    }

    @NotNull
    public Set<VirtualFile> getLibraryFiles() {
        Set<VirtualFile> set = this.getData().getLibraryFiles();
        if (set == null) {
            JSPredefinedLibraryManager.$$$reportNull$$$0(5);
        }
        return set;
    }

    public boolean isPredefinedFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return this.getData().isPredefinedFile(file);
    }

    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesForResolve(@NotNull JSLanguageLevel level) {
        if (level == null) {
            JSPredefinedLibraryManager.$$$reportNull$$$0(6);
        }
        JSPredefinedLibrariesData data2 = this.getData();
        Set<VirtualFile> set = level.isES6Compatible() ? data2.getRequiredLibraryFilesForResolve() : data2.getRequiredLibraryFilesForResolveES5();
        if (set == null) {
            JSPredefinedLibraryManager.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public Set<ScriptingLibraryModel> getLibraryModels() {
        Set<ScriptingLibraryModel> set = this.getData().getLibraryModels();
        if (set == null) {
            JSPredefinedLibraryManager.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getLibraryFilesForResolve() {
        Set<VirtualFile> set = this.getData().getLibraryFilesForResolve();
        if (set == null) {
            JSPredefinedLibraryManager.$$$reportNull$$$0(9);
        }
        return set;
    }

    @Nullable
    public VirtualFile findPredefinedFileByName(String name) {
        return this.getData().findPredefinedFileByName(name);
    }

    @NotNull
    public Set<VirtualFile> getPredefinedLibraryFilesForResolve() {
        Set<VirtualFile> files = this.getLibraryFilesForResolve();
        if (VfsUtilCore.hasInvalidFiles(files)) {
            this.invalidatePredefinedLibrariesCache();
            files = this.getLibraryFilesForResolve();
        }
        Set<VirtualFile> set = files;
        if (set == null) {
            JSPredefinedLibraryManager.$$$reportNull$$$0(10);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSPredefinedLibraryManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSPredefinedLibraryManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraryManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesForResolve";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryModels";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryFilesForResolve";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraryFilesForResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraryManager";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredLibraryFilesForResolve";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

