/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.javascript.JSBuiltInTypeEngineEvaluation;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptImplicitMemberForComputedProperty;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSReferenceUtil {
    public static boolean isPossibleReferenceName(@Nullable String referenceName, @NotNull PsiElement _element) {
        String elementName;
        if (_element == null) {
            JSReferenceUtil.$$$reportNull$$$0(0);
        }
        if (_element instanceof TypeScriptImplicitMemberForComputedProperty) {
            return true;
        }
        if (_element instanceof TypeScriptProxyImplicitElement) {
            TypeScriptProxyImplicitElement implicitElement = (TypeScriptProxyImplicitElement)_element;
            PsiElement explicitElement = implicitElement.getExplicitElement();
            return JSReferenceUtil.isPossibleReferenceName(referenceName, explicitElement);
        }
        if (_element instanceof JSImplicitElement) {
            elementName = ((JSImplicitElement)_element).getName();
        } else if (_element instanceof ES6ExportDefaultAssignment) {
            elementName = "default";
        } else if (_element instanceof JSNamedElement) {
            elementName = ((PsiNamedElement)_element).getName();
        } else if (_element instanceof XmlAttributeValue) {
            elementName = ((XmlAttributeValue)_element).getValue();
        } else if (_element instanceof PsiFile) {
            VirtualFile file = ((PsiFile)_element).getVirtualFile();
            elementName = file != null ? file.getNameWithoutExtension() : null;
        } else if (_element instanceof PsiDirectoryContainer) {
            elementName = ((PsiNamedElement)_element).getName();
        } else if (_element instanceof JSNamedElementBase) {
            elementName = ((JSNamedElementBase)_element).getName();
        } else if (_element instanceof CssClass) {
            String className = ((CssClass)_element).getName();
            elementName = className != null ? CssClass.kebabToCamelCase((String)className) : className;
        } else if (_element instanceof JsonProperty) {
            elementName = ((JsonProperty)_element).getName();
        } else {
            return false;
        }
        return Comparing.equal((String)referenceName, (String)elementName, (boolean)true);
    }

    public static boolean isReferenceTo(@NotNull PsiPolyVariantReference reference, @Nullable String referencedName, @NotNull PsiElement _element) {
        TypeScriptConfigService configService;
        TypeScriptConfig locationConfig;
        if (reference == null) {
            JSReferenceUtil.$$$reportNull$$$0(1);
        }
        if (_element == null) {
            JSReferenceUtil.$$$reportNull$$$0(2);
        }
        PsiElement referenceElement = reference.getElement();
        VirtualFile locationFile = PsiUtilCore.getVirtualFile((PsiElement)referenceElement);
        VirtualFile targetFile = PsiUtilCore.getVirtualFile((PsiElement)_element);
        if (targetFile != null && locationFile != null && TypeScriptUtil.isTypeScriptFile(targetFile) && TypeScriptUtil.isTypeScriptFile(locationFile) && (locationConfig = (configService = TypeScriptConfigService.Provider.get(referenceElement.getProject())).getPreferableConfig(locationFile)) != null && !configService.configGraphIncludesFile(targetFile, locationConfig)) {
            return false;
        }
        return (Boolean)JSBuiltInTypeEngineEvaluation.forceBuiltInTypeEngineIfNeeded(referenceElement, _element, () -> JSReferenceUtil.isReferenceToImpl(reference, referencedName, _element));
    }

    public static boolean isReferenceToImpl(@NotNull PsiPolyVariantReference reference, @Nullable String referencedName, @NotNull PsiElement _element) {
        if (reference == null) {
            JSReferenceUtil.$$$reportNull$$$0(3);
        }
        if (_element == null) {
            JSReferenceUtil.$$$reportNull$$$0(4);
        }
        if (_element instanceof TypeScriptImplicitMemberForComputedProperty) {
            TypeScriptImplicitMemberForComputedProperty _prop = (TypeScriptImplicitMemberForComputedProperty)_element;
            Object[] resolveResults = reference.multiResolve(false);
            return ContainerUtil.exists((Object[])resolveResults, resolveResult -> {
                TypeScriptImplicitMemberForComputedProperty element2;
                PsiElement patt5951$temp = resolveResult.getElement();
                return patt5951$temp instanceof TypeScriptImplicitMemberForComputedProperty && Objects.equals((element2 = (TypeScriptImplicitMemberForComputedProperty)patt5951$temp).getName(), _prop.getName()) && element2.getExplicitElement() == _prop.getExplicitElement();
            });
        }
        if (_element instanceof TypeScriptProxyImplicitElement) {
            TypeScriptProxyImplicitElement implicitElement = (TypeScriptProxyImplicitElement)_element;
            PsiElement explicitElement = implicitElement.getExplicitElement();
            return JSReferenceUtil.isReferenceTo(reference, referencedName, explicitElement);
        }
        if (!JSReferenceUtil.isPossibleReferenceName(referencedName, _element)) {
            return false;
        }
        ResolveResult[] resolveResults = reference.multiResolve(false);
        if (JSResolveResult.isTooManyCandidatesResult(resolveResults)) {
            if (reference instanceof JSReferenceExpressionImpl) {
                JSReferenceExpressionImpl referenceExpression = (JSReferenceExpressionImpl)reference;
                ResolveCache.PolyVariantResolver<JSReferenceExpressionImpl> resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)referenceExpression).createReferenceExpressionResolver(referenceExpression, true);
                if (resolver instanceof JSReferenceExpressionResolver) {
                    ((JSReferenceExpressionResolver)resolver).setLimitingScopeFile(_element.getContainingFile());
                }
                resolveResults = resolver.resolve((PsiPolyVariantReference)referenceExpression, false);
            } else {
                return false;
            }
        }
        return JSReferenceUtil.isReferenceTo(reference, _element, resolveResults);
    }

    private static boolean isReferenceTo(@NotNull PsiPolyVariantReference reference, @NotNull PsiElement _element, ResolveResult @NotNull [] resolveResults) {
        ProjectFileIndex index;
        PsiFile containingFile;
        if (reference == null) {
            JSReferenceUtil.$$$reportNull$$$0(5);
        }
        if (_element == null) {
            JSReferenceUtil.$$$reportNull$$$0(6);
        }
        if (resolveResults == null) {
            JSReferenceUtil.$$$reportNull$$$0(7);
        }
        boolean processingSourceRefFromLibrary = false;
        if (_element instanceof JSNamedElement && (containingFile = _element.getContainingFile()) != null && containingFile.getVirtualFile() != null && !DialectDetector.isTypeScript(_element) && (index = ProjectRootManager.getInstance((Project)containingFile.getProject()).getFileIndex()).isInLibrarySource(containingFile.getVirtualFile())) {
            processingSourceRefFromLibrary = true;
        }
        if (_element instanceof JSImplicitElement) {
            return JSReferenceUtil.checkImplicitElement((JSImplicitElement)_element, resolveResults);
        }
        boolean skipDynamicResults = false;
        boolean skipAnyResults = false;
        boolean skipDynamicResultsCalculated = false;
        for (ResolveResult r : resolveResults) {
            PsiElement resolvedElement;
            if ((!skipDynamicResultsCalculated || skipDynamicResults || skipAnyResults) && reference instanceof JSReferenceExpression) {
                if (!skipDynamicResultsCalculated) {
                    PsiFile containingFile2 = reference.getElement().getContainingFile();
                    if (containingFile2.getLanguage() == FlexSupportLoader.ECMA_SCRIPT_L4) {
                        JSAttributeList attributeList;
                        JSExpression qualifier = ((JSReferenceExpression)reference).getQualifier();
                        JSClass jsClass = null;
                        if (qualifier != null) {
                            PsiElement qName;
                            String expressionType = ActionScriptResolveUtil.getQualifiedExpressionType(qualifier, containingFile2);
                            if ("*".equals(expressionType)) {
                                skipAnyResults = true;
                            } else if (expressionType != null && (qName = JSClassResolver.findClassFromNamespace(expressionType, (PsiElement)containingFile2)) instanceof JSClass) {
                                jsClass = (JSClass)qName;
                            }
                        } else {
                            jsClass = JSResolveUtil.getClassOfContext(reference.getElement());
                        }
                        if (jsClass != null && (attributeList = jsClass.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC)) {
                            skipDynamicResults = true;
                        }
                    }
                    skipDynamicResultsCalculated = true;
                }
                if (!r.isValidResult() && skipDynamicResults || skipAnyResults) continue;
            }
            if ((resolvedElement = r.getElement()) instanceof TypeScriptProxyImplicitElement) {
                resolvedElement = ((TypeScriptProxyImplicitElement)resolvedElement).getExplicitElement();
            }
            if (resolvedElement != null && JSReferenceUtil.checkElementsAreEquialent(_element, resolvedElement)) {
                return true;
            }
            if (resolvedElement instanceof JSLocalImplicitElementImpl) {
                resolvedElement = resolvedElement.getParent();
            }
            if ((resolvedElement = JSReferenceUtil.resolveDestructuring(resolvedElement)) instanceof JSOffsetBasedImplicitElement) {
                resolvedElement = ((JSOffsetBasedImplicitElement)resolvedElement).getElementAtOffset();
            }
            if (resolvedElement == null) continue;
            if (processingSourceRefFromLibrary) {
                resolvedElement = resolvedElement.getNavigationElement();
            }
            if (JSReferenceUtil.checkElementsAreEquialent(_element, resolvedElement)) {
                return true;
            }
            if (resolvedElement instanceof JSFunctionExpression) {
                ASTNode treeParent;
                ASTNode nameIdentifier = ((JSFunctionExpression)resolvedElement).findNameIdentifier();
                if (nameIdentifier != null && ((treeParent = nameIdentifier.getTreeParent()).getPsi() == _element || treeParent.getTreeParent().getPsi() == _element)) {
                    return true;
                }
            } else if (JSClassUtils.isPossibleHierarchyMember(resolvedElement)) {
                if (JSResolveUtil.isConstructorFunction(resolvedElement) && _element instanceof JSClass && _element.isEquivalentTo((PsiElement)JSUtils.getMemberContainingClass(resolvedElement)) && !JSResolveUtil.isSelfReference(reference.getElement())) {
                    return true;
                }
                if (JSClassUtils.isPossibleHierarchyMember(_element)) {
                    JSClass resolvedElementParent = JSUtils.getMemberContainingClass(resolvedElement);
                    JSClass elementParent = JSUtils.getMemberContainingClass(_element);
                    if (elementParent != null && resolvedElementParent != null && !JSResolveUtil.isSelfReference(reference.getElement()) && JSInheritanceUtil.checkMemberHierarchyIncludeClass((JSPsiElementBase)resolvedElement, elementParent)) {
                        return true;
                    }
                }
            }
            if (TypeScriptPsiUtil.isImplementationAndOverloadFunction(_element, resolvedElement)) {
                return true;
            }
            if (!(resolvedElement instanceof JSClass) && !(resolvedElement instanceof JSNamespaceDeclaration) && !(resolvedElement instanceof JSFunction) && !(resolvedElement instanceof JSVariable) || (!(_element instanceof XmlFile) || resolvedElement.getParent().getContainingFile() != _element) && (!(_element instanceof JSFile) || reference.getElement().getParent() == resolvedElement || !JSReferenceUtil.isPublicEntityReferenceToJSFile(resolvedElement, _element))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement resolveDestructuring(@Nullable PsiElement resolvedElement) {
        ResolveResult[] results;
        PsiReference variableReference;
        JSVariable variable;
        PsiElement parent;
        if (resolvedElement instanceof JSVariable && (parent = (variable = (JSVariable)resolvedElement).getParent()) instanceof JSDestructuringShorthandedProperty && (variableReference = parent.getReference()) instanceof JSDestructuringPropertyReference && (results = ((JSDestructuringPropertyReference)variableReference).multiResolve(false)).length > 0) {
            PsiElement finalResolveElement = resolvedElement;
            List<PsiElement> filteredResult = Arrays.stream(results).filter(result2 -> result2 != null && result2.isValidResult()).map(ResolveResult::getElement).filter(psiElementResult -> psiElementResult != null && psiElementResult != finalResolveElement).toList();
            if (filteredResult.size() == 1) {
                resolvedElement = (PsiElement)ContainerUtil.getFirstItem(filteredResult);
            }
        }
        return resolvedElement;
    }

    private static boolean checkElementsAreEquialent(@NotNull PsiElement _element, @NotNull PsiElement resolvedElement) {
        if (_element == null) {
            JSReferenceUtil.$$$reportNull$$$0(8);
        }
        if (resolvedElement == null) {
            JSReferenceUtil.$$$reportNull$$$0(9);
        }
        return resolvedElement.isEquivalentTo(_element) || _element.isEquivalentTo(resolvedElement) || (_element instanceof JSProperty || _element instanceof XmlAttributeValue) && resolvedElement.getParent() == _element || _element instanceof JSExpression && JSPsiImplUtils.getInitializedElement((JSExpression)_element) == resolvedElement;
    }

    private static boolean isPublicEntityReferenceToJSFile(PsiElement resolvedElement, PsiElement element2) {
        PsiElement parent = resolvedElement.getParent();
        if (parent instanceof JSVarStatement) {
            parent = parent.getParent();
        }
        return parent instanceof JSPackageStatement && parent.getParent() == element2;
    }

    private static boolean checkImplicitElement(JSImplicitElement _element, ResolveResult[] resolveResults) {
        for (ResolveResult resolveResult : resolveResults) {
            PsiElement resolved = resolveResult.getElement();
            if (_element.isEquivalentTo(resolved)) {
                return true;
            }
            if (resolved instanceof JSImplicitElement && Objects.equals(_element.getName(), ((JSImplicitElement)resolved).getName()) && PsiTreeUtil.getContextOfType((PsiElement)_element, (Class[])new Class[]{JSImplicitElementProvider.class}) != null && Objects.equals(PsiTreeUtil.getContextOfType((PsiElement)_element, (Class[])new Class[]{JSImplicitElementProvider.class}), PsiTreeUtil.getContextOfType((PsiElement)resolved, (Class[])new Class[]{JSImplicitElementProvider.class}))) {
                return true;
            }
            PsiElement destructuringResolved = JSReferenceUtil.resolveDestructuring(resolved);
            if (destructuringResolved != resolved && destructuringResolved != null && JSReferenceUtil.checkElementsAreEquialent((PsiElement)_element, destructuringResolved)) {
                return true;
            }
            if (!(resolved instanceof TypeScriptProxyImplicitElement) || !_element.isEquivalentTo(((TypeScriptProxyImplicitElement)resolved).getExplicitElement())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasValidResolveResult(@NotNull PsiReference reference) {
        if (reference == null) {
            JSReferenceUtil.$$$reportNull$$$0(10);
        }
        if (reference instanceof PsiMultiReference) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ((PsiMultiReference)reference).multiResolve(false)) {
                if (!result2.isValidResult()) continue;
                return true;
            }
            return false;
        }
        return reference.resolve() != null;
    }

    @NotNull
    public static TextRange getRangeWithoutQuotes(@NotNull PsiElement quoted) {
        if (quoted == null) {
            JSReferenceUtil.$$$reportNull$$$0(11);
        }
        return new TextRange(1, quoted.getTextLength() - 1);
    }

    @NotNull
    public static List<String> getReferenceComponents(@NotNull JSReferenceExpression expression, int maxCount) {
        ArrayList<String> result2;
        if (expression == null) {
            JSReferenceUtil.$$$reportNull$$$0(12);
        }
        ArrayList<String> arrayList = result2 = maxCount > 0 ? new ArrayList<String>(maxCount) : new ArrayList();
        while (expression != null) {
            if (maxCount >= 0 && result2.size() >= maxCount) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    JSReferenceUtil.$$$reportNull$$$0(13);
                }
                return list;
            }
            String name = expression.getReferenceName();
            if (name == null) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    JSReferenceUtil.$$$reportNull$$$0(14);
                }
                return list;
            }
            result2.add(name);
            JSExpression qualifier = expression.getQualifier();
            if (qualifier != null && !(qualifier instanceof JSReferenceExpression)) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    JSReferenceUtil.$$$reportNull$$$0(15);
                }
                return list;
            }
            expression = (JSReferenceExpression)qualifier;
        }
        Collections.reverse(result2);
        ArrayList<String> arrayList2 = result2;
        if (arrayList2 == null) {
            JSReferenceUtil.$$$reportNull$$$0(16);
        }
        return arrayList2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoted";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSReferenceUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSReferenceUtil";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleReferenceName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkElementsAreEquialent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasValidResolveResult";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRangeWithoutQuotes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceComponents";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

