/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCopyWithStrictTransformer;
import com.intellij.lang.javascript.psi.JSDocTextStringBuilder;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSPresentableTypeTextStringBuilder;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeAssignableErrorMessage;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSExternalGenericId;
import com.intellij.lang.javascript.psi.types.JSForInStringType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNotARecordType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.recordImpl.ComputedPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.IndexSignatureImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class JSRecordTypeImpl
extends JSTypeBaseImpl
implements JSRecordType {
    @NotNull
    protected final List<JSRecordType.TypeMember> myAllTypeMembers;
    @NotNull
    protected final List<JSRecordType.CallSignature> myCallSignatures;
    protected final List<JSRecordType.IndexSignature> myIndexSignatures;
    @NotNull
    protected final Map<String, JSRecordType.PropertySignature> myProperties;
    protected final Map<String, JSRecordType.PropertySignature> myPrivateProperties;
    protected final boolean myIsWeakType;
    protected final List<JSRecordType.PropertySignature> myComputedProperties;

    protected JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(0);
        }
        if (inputStream == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(1);
        }
        this(source, JSTypeSerializer.TYPE_MEMBERS_SERIALIZER.read(source, inputStream));
    }

    public JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull List<? extends JSRecordType.TypeMember> typeMembers) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(2);
        }
        if (typeMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(3);
        }
        super(source);
        LinkedHashMap<String, JSRecordType.PropertySignature> classicPropertySignatures = new LinkedHashMap<String, JSRecordType.PropertySignature>();
        Object2IntOpenHashMap classicPropertyIndices = new Object2IntOpenHashMap();
        LinkedHashMap<String, JSRecordType.PropertySignature> privatePropertySignatures = null;
        Object2IntOpenHashMap privatePropertyIndices = null;
        ArrayList<JSRecordType.TypeMember> allMembers = new ArrayList<JSRecordType.TypeMember>(typeMembers.size());
        SmartList indexSignatures = new SmartList();
        ArrayList<JSRecordType.CallSignature> callSignatures = null;
        ArrayList<ComputedPropertySignatureImpl> computedProperties = null;
        boolean isPossiblyWeak = true;
        int positionInAllMembers = -1;
        for (JSRecordType.TypeMember typeMember : typeMembers) {
            if (typeMember instanceof JSRecordType.PropertySignature) {
                JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)typeMember;
                if (!propertySignature.isOptional()) {
                    isPossiblyWeak = false;
                }
                if (propertySignature instanceof ComputedPropertySignatureImpl) {
                    if (computedProperties == null) {
                        computedProperties = new ArrayList<ComputedPropertySignatureImpl>();
                    }
                    computedProperties.add((ComputedPropertySignatureImpl)propertySignature);
                    ++positionInAllMembers;
                    allMembers.add(propertySignature);
                    continue;
                }
                String name = propertySignature.getMemberName();
                boolean privateName = propertySignature.isPrivateName();
                if (privateName) {
                    if (privatePropertySignatures == null) {
                        privatePropertySignatures = new LinkedHashMap<String, JSRecordType.PropertySignature>();
                        privatePropertyIndices = new Object2IntOpenHashMap();
                    }
                    String uniqueName = name + "~" + propertySignature.getPrivateNameDepth();
                    positionInAllMembers = JSRecordTypeImpl.handlePropertySignature(uniqueName, propertySignature, source, privatePropertySignatures, (Object2IntMap<String>)privatePropertyIndices, allMembers, positionInAllMembers);
                    continue;
                }
                positionInAllMembers = JSRecordTypeImpl.handlePropertySignature(name, propertySignature, source, classicPropertySignatures, (Object2IntMap<String>)classicPropertyIndices, allMembers, positionInAllMembers);
                continue;
            }
            isPossiblyWeak = false;
            if (typeMember instanceof JSRecordType.IndexSignature) {
                Collection<JSRecordType.IndexSignature> newIndexSignatures = JSRecordTypeImpl.normalizeIndexSignatures((JSRecordType.IndexSignature)typeMember);
                indexSignatures.addAll(newIndexSignatures);
                positionInAllMembers += newIndexSignatures.size();
                allMembers.addAll(newIndexSignatures);
                continue;
            }
            if (typeMember instanceof JSRecordType.CallSignature) {
                if (callSignatures == null) {
                    callSignatures = new ArrayList<JSRecordType.CallSignature>();
                }
                callSignatures.add((JSRecordType.CallSignature)typeMember);
            }
            ++positionInAllMembers;
            allMembers.add(typeMember);
        }
        this.myIsWeakType = isPossiblyWeak && !allMembers.isEmpty();
        this.myIndexSignatures = indexSignatures;
        this.myCallSignatures = callSignatures == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(callSignatures);
        this.myAllTypeMembers = Collections.unmodifiableList(allMembers);
        this.myProperties = Collections.unmodifiableMap(classicPropertySignatures);
        this.myPrivateProperties = privatePropertySignatures != null ? Collections.unmodifiableMap(privatePropertySignatures) : JSRecordType.PropertySignature.EMPTY_MAP;
        this.myComputedProperties = computedProperties == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(computedProperties);
    }

    protected JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> allTypeMembers, @NotNull List<JSRecordType.CallSignature> callSignatures, @NotNull List<JSRecordType.IndexSignature> indexSignatures, @NotNull Map<String, JSRecordType.PropertySignature> properties2, @NotNull Map<String, JSRecordType.PropertySignature> privateProperties, @NotNull List<JSRecordType.PropertySignature> computedProperties, boolean isWeakType) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(4);
        }
        if (allTypeMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(5);
        }
        if (callSignatures == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(6);
        }
        if (indexSignatures == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(7);
        }
        if (properties2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(8);
        }
        if (privateProperties == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(9);
        }
        if (computedProperties == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(10);
        }
        super(source);
        this.myAllTypeMembers = allTypeMembers;
        this.myCallSignatures = callSignatures;
        this.myProperties = properties2;
        this.myPrivateProperties = privateProperties;
        this.myIndexSignatures = indexSignatures;
        this.myComputedProperties = computedProperties;
        this.myIsWeakType = isWeakType;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(11);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_MEMBERS_SERIALIZER.write(this.myAllTypeMembers, outputStream);
    }

    private static int handlePropertySignature(String uniqueName, JSRecordType.PropertySignature propertySignature, JSTypeSource source, Map<String, JSRecordType.PropertySignature> propertySignatures, Object2IntMap<String> propertyIndices, List<JSRecordType.TypeMember> allMembers, int positionInAllMembers) {
        JSRecordType.PropertySignature storedSignature = propertySignatures.get(uniqueName);
        if (storedSignature != null) {
            JSRecordType.PropertySignature mergedSignature = JSRecordTypeImpl.mergeSignatures(propertySignature, storedSignature, source);
            int index = propertyIndices.getInt((Object)uniqueName);
            allMembers.set(index, mergedSignature);
            propertySignatures.put(uniqueName, mergedSignature);
        } else {
            propertySignatures.put(uniqueName, propertySignature);
            propertyIndices.put((Object)uniqueName, positionInAllMembers + 1);
            ++positionInAllMembers;
            allMembers.add(propertySignature);
        }
        return positionInAllMembers;
    }

    @NotNull
    private static JSRecordType.PropertySignature mergeSignatures(@NotNull JSRecordType.PropertySignature newSignature, @NotNull JSRecordType.PropertySignature stored, @NotNull JSTypeSource source) {
        if (newSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(12);
        }
        if (stored == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(13);
        }
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(14);
        }
        boolean isOptional = newSignature.isOptional() && stored.isOptional();
        boolean isReadonly = newSignature.isConst() && stored.isConst();
        String name = stored.getMemberName();
        boolean privateName = stored.isPrivateName();
        int privateNameDepth = stored.getPrivateNameDepth();
        if (stored instanceof JSCompositeFunctionPropertySignatureImpl) {
            return JSRecordTypeImpl.addPropertyToCompositeFunctions((JSCompositeFunctionPropertySignatureImpl)stored, newSignature, source, isOptional, isReadonly);
        }
        if (newSignature instanceof JSCompositeFunctionPropertySignatureImpl) {
            return JSRecordTypeImpl.addPropertyToCompositeFunctions((JSCompositeFunctionPropertySignatureImpl)newSignature, stored, source, isOptional, isReadonly);
        }
        JSFunctionItem storedFun = JSRecordTypeImpl.getFunctionItem(stored);
        JSFunctionItem newSignatureFun = JSRecordTypeImpl.getFunctionItem(newSignature);
        if (storedFun != null && newSignatureFun != null) {
            if (storedFun.isGetProperty() && newSignatureFun.isSetProperty()) {
                return JSRecordTypeImpl.mergeAccessors(stored, newSignature);
            }
            if (storedFun.isSetProperty() && newSignatureFun.isGetProperty()) {
                return JSRecordTypeImpl.mergeAccessors(newSignature, stored);
            }
        }
        if (!(stored.getJSType() instanceof JSFunctionTypeImpl)) {
            JSRecordType.PropertySignature propertySignature = stored;
            if (propertySignature == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(15);
            }
            return propertySignature;
        }
        return new JSCompositeFunctionPropertySignatureImpl(name, privateName, privateNameDepth, List.of(stored, newSignature), isOptional, isReadonly, source);
    }

    @Nullable
    private static JSFunctionItem getFunctionItem(@NotNull JSRecordType.PropertySignature signature) {
        PsiElement psiElement;
        if (signature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(16);
        }
        if (signature instanceof JSFunctionItem) {
            return (JSFunctionItem)((Object)signature);
        }
        List<PsiElement> source = signature.getMemberSource().getAllSourceElements();
        if (source.size() == 1 && (psiElement = source.get(0)) instanceof JSFunctionItem) {
            JSFunctionItem result2 = (JSFunctionItem)psiElement;
            return result2;
        }
        return null;
    }

    @NotNull
    private static JSRecordType.PropertySignature mergeAccessors(JSRecordType.PropertySignature getter, JSRecordType.PropertySignature setter) {
        JSRecordType.MemberSource source = JSRecordMemberSourceFactory.createSource(ContainerUtil.concat(getter.getMemberSource().getAllSourceElements(), setter.getMemberSource().getAllSourceElements()), JSRecordType.MemberSourceKind.MergedAccessor, true);
        return new com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl(getter.getMemberName(), getter.isPrivateName(), getter.getPrivateNameDepth(), false, getter.getJSType(), null, setter.getJSType(), getter.isOptional() && setter.isOptional(), getter.isNumericKey(), source);
    }

    @NotNull
    private static JSRecordType.PropertySignature addPropertyToCompositeFunctions(@NotNull JSCompositeFunctionPropertySignatureImpl composite, @NotNull JSRecordType.PropertySignature newProperty, @NotNull JSTypeSource source, boolean isOptional, boolean isReadonly) {
        if (composite == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(17);
        }
        if (newProperty == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(18);
        }
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(19);
        }
        List<JSRecordType.PropertySignature> members = composite.getMembers();
        ArrayList<JSRecordType.PropertySignature> list = new ArrayList<JSRecordType.PropertySignature>(members.size() + 1);
        list.addAll(members);
        if (newProperty instanceof JSCompositeFunctionPropertySignatureImpl) {
            list.addAll(((JSCompositeFunctionPropertySignatureImpl)newProperty).getMembers());
        } else {
            list.add(newProperty);
        }
        return new JSCompositeFunctionPropertySignatureImpl(composite.getMemberName(), composite.isPrivateName(), composite.getPrivateNameDepth(), list, isOptional, isReadonly, source);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(20);
        }
        if (builder2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(21);
        }
        builder2.append("{");
        boolean useTypeScriptRecordTypeFormat = format == JSType.TypeTextFormat.CODE && this.isTypeScript() && !(builder2 instanceof JSDocTextStringBuilder);
        String prefix = "";
        String nextPrefix = useTypeScriptRecordTypeFormat ? "; " : ", ";
        String separator = this.getTypeSeparator(format);
        char quote = this.getQuote();
        int membersLimit = JSPresentableTypeTextStringBuilder.getMembersLimit(builder2);
        String placeholder = JSPresentableTypeTextStringBuilder.getPlaceholder(builder2);
        for (int i = 0; i < this.myAllTypeMembers.size(); ++i) {
            JSRecordType.TypeMember typeMember = this.myAllTypeMembers.get(i);
            builder2.append(prefix);
            if (i > membersLimit && format == JSType.TypeTextFormat.PRESENTABLE) {
                builder2.append(placeholder);
                builder2.append("}");
                return;
            }
            typeMember.appendMemberPresentation(format, builder2, separator, quote);
            prefix = nextPrefix;
        }
        builder2.append("}");
    }

    protected char getQuote() {
        String quote = JSSymbolPresentationProvider.getDefaultQuote(this.getSource().getSourceElement());
        return quote.charAt(0);
    }

    @Override
    protected final boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(22);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(23);
        }
        if (this.isTypeScript() && this.hasIndexers() && elementType instanceof JSPrimitiveType && ((JSPrimitiveType)elementType).isPrimitive()) {
            return false;
        }
        if (JSRecordTypeImpl.canSubstitute(elementType)) {
            JSType substitute = elementType.substitute(JSRecordTypeImpl.createSubstitutionContextForAssignability(processingContext));
            if (elementType != substitute) {
                return this.isDirectlyAssignableType(substitute, processingContext);
            }
            elementType = JSRecordTypeImpl.convertToRecordTypeIfPossible(elementType, (PsiElement)processingContext.get(JSTypeComparingContextService.LOCATION));
        }
        if (elementType instanceof JSArrayType) {
            elementType = JSRecordTypeImpl.convertToRecordTypeIfPossible(((JSArrayType)elementType).asGenericType(), (PsiElement)processingContext.get(JSTypeComparingContextService.LOCATION));
        }
        if (elementType instanceof JSRecordType) {
            return this.isDirectlyAssignableRecordType((JSRecordType)elementType, processingContext);
        }
        if (elementType instanceof JSObjectType) {
            return true;
        }
        if (!this.hasMembers() && elementType.isJavaScript()) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @NotNull
    private static JSType convertToRecordTypeIfPossible(@NotNull JSType elementType, @Nullable PsiElement evaluationLocation) {
        JSRecordType recordTypeCandidate;
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(24);
        }
        JSType jSType = (recordTypeCandidate = elementType.asRecordType(evaluationLocation)) instanceof JSNotARecordType ? elementType : recordTypeCandidate;
        if (jSType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    protected static boolean canSubstitute(@NotNull JSType elementType) {
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(26);
        }
        if (elementType instanceof JSFunctionTypeImpl) {
            return true;
        }
        return elementType instanceof JSNamedType || elementType instanceof JSGenericTypeImpl || elementType instanceof JSAliasTypeImpl || elementType instanceof JSUnionOrIntersectionType;
    }

    private static boolean isObject(@NotNull JSRecordType recordType) {
        PsiElement sourceElement;
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(27);
        }
        return (sourceElement = recordType.getSource().getSourceElement()) instanceof TypeScriptInterface && "Object".equals(((TypeScriptInterface)sourceElement).getQualifiedName());
    }

    private boolean isDirectlyAssignableRecordType(@NotNull JSRecordType sourceType, @NotNull ProcessingContext processingContext) {
        boolean rTypeWithCallSignatures;
        if (sourceType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(28);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(29);
        }
        List<JSRecordType.CallSignature> rTypeCallSignatures = sourceType.getCallSignatures();
        boolean hasMembers = sourceType.hasMembers();
        boolean bl = rTypeWithCallSignatures = !rTypeCallSignatures.isEmpty();
        if (!this.checkWeakTypeCondition(sourceType, hasMembers)) {
            return false;
        }
        if (!this.checkCallSignatureExistence(rTypeWithCallSignatures, processingContext)) {
            return false;
        }
        if (!this.checkIndexSignatures(sourceType, processingContext)) {
            return false;
        }
        if (!this.checkPropertyTypes(sourceType, rTypeWithCallSignatures, processingContext)) {
            return false;
        }
        if (!this.checkCallSignatureTypes(processingContext, rTypeCallSignatures)) {
            return false;
        }
        return this.checkObjectLiteralProperties(sourceType, processingContext);
    }

    private boolean checkObjectLiteralProperties(@NotNull JSRecordType sourceType, @NotNull ProcessingContext processingContext) {
        if (sourceType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(30);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(31);
        }
        if (!JSRecordTypeImpl.isObjectLiteralType(this) || !JSRecordTypeImpl.isObjectType(sourceType) || processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) == null) {
            return true;
        }
        for (JSRecordType.PropertySignature property : sourceType.getProperties()) {
            JSType type2;
            if (this.hasProperty(property.getMemberName()) || (type2 = property.getJSType()) instanceof JSUndefinedType) continue;
            return false;
        }
        return true;
    }

    private boolean checkWeakTypeCondition(@NotNull JSRecordType recordType, boolean hasMembers) {
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(32);
        }
        if (this.myIsWeakType && hasMembers && !JSRecordTypeImpl.isObject(recordType)) {
            Set<String> rNames = recordType.getPropertyNames();
            HashSet<String> lNames = new HashSet<String>(this.getPropertyNames());
            lNames.retainAll(rNames);
            if (lNames.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private boolean checkCallSignatureExistence(boolean rTypeWithCallSignatures, @NotNull ProcessingContext processingContext) {
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(33);
        }
        if (!this.myCallSignatures.isEmpty() && !rTypeWithCallSignatures) {
            JSTypeAssignableErrorMessage.addMessageToContext(processingContext, "javascript.no.call.signatures", new String[0]);
            return false;
        }
        return true;
    }

    private boolean checkPropertyTypes(@NotNull JSRecordType sourceType, boolean hasCallSignatures, @NotNull ProcessingContext processingContext) {
        if (sourceType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(34);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(35);
        }
        boolean subtyping = processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) != null && !JSRecordTypeImpl.isExpressionBasedType(sourceType);
        JSUndefinedType undefinedType = null;
        JSRecordType additionalMembers = null;
        ArrayList<PropertyTypeChecker> toCheck = null;
        Collection<JSRecordType.PropertySignature> properties2 = this.getProperties();
        for (JSRecordType.PropertySignature lProperty : properties2) {
            String lPropName = lProperty.getMemberName();
            JSRecordType.PropertySignature rProperty = sourceType.findPropertySignature(lPropName);
            if (rProperty == lProperty) continue;
            if (rProperty != null && rProperty.isOptional() && !lProperty.isOptional() && this.isTypeScript()) {
                return false;
            }
            if (rProperty == null && (!lProperty.isOptional() || subtyping)) {
                if (this.isJavaScript() && sourceType.isJavaScript()) {
                    if (undefinedType == null) {
                        undefinedType = JSNamedTypeFactory.createUndefinedType(sourceType.getSource());
                    }
                    if (JSRecordTypeImpl.isUndefinedProperty(lProperty, undefinedType, processingContext)) continue;
                }
                if (hasCallSignatures) {
                    if (additionalMembers == null) {
                        additionalMembers = TypeScriptUtil.getFunctionTypeMembers(this.getSource().getSourceElement());
                    }
                    if (additionalMembers != null && JSRecordTypeImpl.checkFunctionInterfaceProperties(processingContext, additionalMembers, lProperty)) continue;
                }
                return false;
            }
            if (rProperty == null) continue;
            JSType rType = rProperty.getJSType();
            JSType lType = lProperty.getJSType();
            if (rType instanceof JSPrimitiveType && lType instanceof JSPrimitiveType) {
                if (JSRecordTypeImpl.checkPropertySignatureAssignable(lProperty, rProperty, processingContext)) continue;
                return false;
            }
            if (toCheck == null) {
                toCheck = new ArrayList<PropertyTypeChecker>(properties2.size());
            }
            toCheck.add(context2 -> JSRecordTypeImpl.checkPropertySignatureAssignable(lProperty, rProperty, context2));
        }
        if (toCheck != null) {
            for (PropertyTypeChecker checker : toCheck) {
                if (checker.check(processingContext)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkCallSignatureTypes(@NotNull ProcessingContext processingContext, @NotNull List<JSRecordType.CallSignature> callSignatures) {
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(36);
        }
        if (callSignatures == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(37);
        }
        for (JSRecordType.CallSignature lCallSignature : this.myCallSignatures) {
            if (JSRecordTypeImpl.checkCallSignaturesAssignable(lCallSignature, callSignatures, processingContext)) continue;
            return false;
        }
        return true;
    }

    private boolean checkIndexSignatures(@NotNull JSRecordType sourceType, @NotNull ProcessingContext processingContext) {
        if (sourceType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(38);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(39);
        }
        boolean hasStringIndexer = this.findIndexer(JSStringType.class) != null;
        boolean sourceIsPrimitive = TypeScriptTypeRelations.isPrimitiveType(sourceType);
        for (JSRecordType.IndexSignature indexSignature : this.myIndexSignatures) {
            boolean isAssignable = !sourceIsPrimitive && hasStringIndexer && indexSignature.getMemberType() instanceof JSAnyType || this.checkIndexSignature(sourceType, indexSignature, processingContext);
            if (isAssignable) continue;
            return false;
        }
        return true;
    }

    private boolean checkIndexSignature(@NotNull JSRecordType sourceType, @NotNull JSRecordType.IndexSignature indexSignature, @NotNull ProcessingContext processingContext) {
        JSRecordType.IndexSignature numericIndexSignature;
        if (sourceType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(40);
        }
        if (indexSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(41);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(42);
        }
        JSType parameterType = indexSignature.getMemberParameterType();
        JSType memberType = indexSignature.getMemberType();
        JSRecordType.IndexSignature applicableIndexer = JSRecordTypeImpl.findApplicableIndexer(sourceType, parameterType);
        if (applicableIndexer != null) {
            return memberType.isDirectlyAssignableType(applicableIndexer.getMemberType(), processingContext);
        }
        if (JSTypeComparingContextService.isSubtyping(processingContext) && parameterType instanceof JSStringType && (numericIndexSignature = sourceType.findIndexer(JSNumberType.class)) != null && numericIndexSignature.getMemberType().isDirectlyAssignableType(memberType, processingContext)) {
            return true;
        }
        if (TypeScriptTypeRelations.isObjectTypeWithInferableIndex(sourceType)) {
            return this.membersAssignableToIndexInfo(sourceType, indexSignature, processingContext);
        }
        return false;
    }

    private boolean membersAssignableToIndexInfo(@NotNull JSRecordType sourceType, @NotNull JSRecordType.IndexSignature indexSignature, @NotNull ProcessingContext processingContext) {
        JSType memberType;
        JSType parameterType;
        boolean propertiesAreAssignable;
        if (sourceType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(43);
        }
        if (indexSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(44);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(45);
        }
        if (!(propertiesAreAssignable = JSTypeCastUtil.executeJoinInferredGenerics((Processor<? super ProcessingContext>)((Processor)arg_0 -> JSRecordTypeImpl.lambda$membersAssignableToIndexInfo$1(sourceType, parameterType = indexSignature.getMemberParameterType(), memberType = indexSignature.getMemberType(), arg_0)), processingContext, this.getSource(), false))) {
            return false;
        }
        for (JSRecordType.IndexSignature signature : sourceType.getIndexSignatures()) {
            if (!JSRecordTypeImpl.isApplicableIndexType(signature.getMemberParameterType(), parameterType) || memberType.isDirectlyAssignableType(signature.getMemberType(), processingContext)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static JSType getLiteralTypeFromPropertyName(@NotNull JSRecordType.PropertySignature property) {
        if (property == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(46);
        }
        if (property instanceof JSRecordType.ComputedMember) {
            return ((JSRecordType.ComputedMember)((Object)property)).getTypeForComputedName();
        }
        PsiElement element2 = property.getMemberSource().getSingleElement();
        if (element2 == null) {
            return null;
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(element2, true);
        return new JSStringLiteralTypeImpl(property.getMemberName(), false, source);
    }

    private static boolean isNumericallyNamedString(@NotNull String s) {
        if (s == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(47);
        }
        return JSStringUtil.isNumericValueStart(s, false) && JSNumberParser.tryParseNumericValue(s, false) != null;
    }

    private static boolean isExpressionBasedType(@NotNull JSRecordType type2) {
        PsiElement sourceElement;
        if (type2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(48);
        }
        return (sourceElement = type2.getSourceElement()) instanceof JSObjectLiteralExpression || sourceElement instanceof JSArrayLiteralExpression;
    }

    public static boolean isObjectType(@NotNull JSRecordType type2) {
        TypeScriptTypeAlias alias;
        PsiElement aliasedSource;
        PsiElement sourceElement;
        if (type2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(49);
        }
        if ((sourceElement = type2.getSourceElement()) instanceof TypeScriptTypeAlias && (aliasedSource = (PsiElement)ObjectUtils.doIfNotNull((Object)(alias = (TypeScriptTypeAlias)sourceElement).getParsedTypeDeclaration(), JSType::getSourceElement)) != null) {
            sourceElement = aliasedSource;
        }
        return sourceElement instanceof JSObjectLiteralExpression || sourceElement instanceof TypeScriptObjectType || sourceElement instanceof TypeScriptEnum || sourceElement instanceof TypeScriptMappedType;
    }

    private static boolean isObjectLiteralType(@NotNull JSRecordType type2) {
        if (type2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(50);
        }
        return type2.getSourceElement() instanceof JSObjectLiteralExpression;
    }

    private static boolean isUndefinedProperty(@NotNull JSRecordType.PropertySignature typeMember, @NotNull JSType undefinedType, @Nullable ProcessingContext processingContext) {
        JSType propertyType;
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(51);
        }
        if (undefinedType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(52);
        }
        return (propertyType = typeMember.getJSType()) == null || undefinedType.isDirectlyAssignableType(propertyType, processingContext);
    }

    private static boolean checkPropertySignatureAssignable(@NotNull JSRecordType.PropertySignature signature, @NotNull JSRecordType.PropertySignature otherSignature, @Nullable ProcessingContext processingContext) {
        if (signature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(53);
        }
        if (otherSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(54);
        }
        if (signature.isEquivalentTo(otherSignature, processingContext, true)) {
            return true;
        }
        JSType type2 = signature.getJSTypeWithOptionality();
        JSType otherType = otherSignature.getJSTypeWithOptionality();
        return type2 == null || type2.isDirectlyAssignableType(otherType, processingContext);
    }

    private static boolean checkCallSignaturesAssignable(@NotNull JSRecordType.CallSignature currentSignature, @NotNull List<JSRecordType.CallSignature> callSignatures, @Nullable ProcessingContext processingContext) {
        if (currentSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(55);
        }
        if (callSignatures == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(56);
        }
        for (JSRecordType.CallSignature callSignature : callSignatures) {
            if (!currentSignature.isEquivalentTo(callSignature, processingContext, true)) continue;
            return true;
        }
        if (JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext) || callSignatures.size() == 1) {
            return JSRecordTypeImpl.simpleCheckCallSignatureAssignable(currentSignature, callSignatures, processingContext);
        }
        int size = currentSignature.getParameterTypeDecorators().size();
        SmartList rest = new SmartList();
        for (JSRecordType.CallSignature signature : callSignatures) {
            List<JSParameterTypeDecorator> params = signature.getParameterTypeDecorators();
            if (params.size() != size) {
                rest.add(signature);
                continue;
            }
            if (!JSRecordTypeImpl.checkAssignableForCallSignatures(currentSignature, processingContext, signature)) continue;
            return true;
        }
        return JSRecordTypeImpl.simpleCheckCallSignatureAssignable(currentSignature, (List<JSRecordType.CallSignature>)rest, processingContext);
    }

    private static boolean simpleCheckCallSignatureAssignable(@NotNull JSRecordType.CallSignature currentSignature, @NotNull List<JSRecordType.CallSignature> rest, @Nullable ProcessingContext processingContext) {
        if (currentSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(57);
        }
        if (rest == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(58);
        }
        for (JSRecordType.CallSignature callSignature : rest) {
            if (!JSRecordTypeImpl.checkAssignableForCallSignatures(currentSignature, processingContext, callSignature)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkAssignableForCallSignatures(@NotNull JSRecordType.CallSignature typeMember, @Nullable ProcessingContext processingContext, @NotNull JSRecordType.CallSignature callSignature) {
        JSFunctionType otherFunctionType;
        JSFunctionType functionType;
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(59);
        }
        if (callSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(60);
        }
        return typeMember.hasNew() == callSignature.hasNew() && JSRecordTypeImpl.checkFunctionsArgumentsAndReturnType(functionType = typeMember.getFunctionType(), otherFunctionType = callSignature.getFunctionType(), processingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFunctionsArgumentsAndReturnType(@NotNull JSFunctionType functionType, @NotNull JSFunctionType otherFunctionType, @Nullable ProcessingContext processingContext) {
        if (functionType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(61);
        }
        if (otherFunctionType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(62);
        }
        boolean oldCallEnv = false;
        if (processingContext != null) {
            oldCallEnv = processingContext.get(JSTypeBaseImpl.CALL_ENV_KEY) == Boolean.TRUE;
            JSTypeComparingContextService.setCallEnvironment(processingContext, true);
        }
        try {
            if (!JSTypeUtils.areArgumentsAssignable(functionType.getParameters(), otherFunctionType.getParameters(), processingContext, true, !functionType.isTypeScript(), functionType.isTypeScript())) {
                boolean bl = false;
                return bl;
            }
            JSType returnType2 = functionType.getReturnType();
            JSType otherReturnType = otherFunctionType.getReturnType();
            if (returnType2 == null || returnType2 instanceof JSVoidType) {
                boolean bl = true;
                return bl;
            }
            boolean bl = returnType2.isDirectlyAssignableType(otherReturnType, processingContext);
            return bl;
        }
        finally {
            if (processingContext != null) {
                MultiMap<JSTypeGenericId, JSType> mapping;
                List<TypeScriptGenericDeclarationTypeImpl> declarations;
                JSGenericMappings mappings = (JSGenericMappings)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
                if (mappings != null && otherFunctionType instanceof TypeScriptJSFunctionTypeImpl && !(declarations = ((TypeScriptJSFunctionTypeImpl)otherFunctionType).getGenericDeclarations()).isEmpty() && !(mapping = mappings.getMapping()).containsKey((Object)JSExternalGenericId.INSTANCE)) {
                    mapping.putValue((Object)JSExternalGenericId.INSTANCE, (Object)JSCompositeTypeFactory.createUnionType(otherFunctionType.getSource(), declarations));
                }
                JSTypeComparingContextService.setCallEnvironment(processingContext, oldCallEnv);
            }
        }
    }

    private static boolean checkFunctionInterfaceProperties(@NotNull ProcessingContext processingContext, @NotNull JSRecordType functionRecord, @NotNull JSRecordType.PropertySignature typeMember) {
        JSRecordType.PropertySignature signature;
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(63);
        }
        if (functionRecord == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(64);
        }
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(65);
        }
        if ((signature = functionRecord.findPropertySignature(typeMember.getMemberName())) == null) {
            return false;
        }
        if (JSRecordTypeImpl.checkSources(typeMember, signature, processingContext)) {
            return true;
        }
        return JSRecordTypeImpl.checkPropertySignatureAssignable(typeMember, signature, processingContext);
    }

    private static boolean checkSources(@NotNull JSRecordType.PropertySignature typeMember, @NotNull JSRecordType.TypeMember member, @NotNull ProcessingContext processingContext) {
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(66);
        }
        if (member == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(67);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(68);
        }
        JSRecordType.MemberSource source = member.getMemberSource();
        PsiElement memberSource = source.getSingleElement();
        JSRecordType.MemberSource typeMemberSource = typeMember.getMemberSource();
        return memberSource != null && memberSource.isEquivalentTo(typeMemberSource.getSingleElement()) || typeMember.isEquivalentTo(member, processingContext, true);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type2, ProcessingContext processingContext, boolean allowResolve) {
        if (type2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(69);
        }
        JSRecordType otherType = (JSRecordType)type2;
        List<JSRecordType.TypeMember> otherMembers = otherType.getTypeMembers();
        List<JSRecordType.TypeMember> members = this.getTypeMembers();
        return JSRecordTypeImpl.areMembersEqual(otherMembers, members, processingContext, allowResolve);
    }

    protected static boolean areMembersEqual(@NotNull List<? extends JSRecordType.TypeMember> otherMembers, @NotNull List<? extends JSRecordType.TypeMember> members, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (otherMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(70);
        }
        if (members == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(71);
        }
        if (otherMembers.size() != members.size()) {
            return false;
        }
        for (int i = 0; i < members.size(); ++i) {
            ProgressManager.checkCanceled();
            JSRecordType.TypeMember otherMember = otherMembers.get(i);
            JSRecordType.TypeMember member = members.get(i);
            if (otherMember.isEquivalentTo(member, processingContext, allowResolve)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public List<JSRecordType.TypeMember> getTypeMembers() {
        List<JSRecordType.TypeMember> list = this.myAllTypeMembers;
        if (list == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(72);
        }
        return list;
    }

    @Override
    public final boolean hasProperty(@NotNull String name) {
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(73);
        }
        if (this.myProperties.containsKey(name)) {
            return true;
        }
        return ContainerUtil.exists(this.myComputedProperties, p -> name.equals(p.getMemberName()));
    }

    @Override
    public final boolean hasIndexers() {
        return !this.myIndexSignatures.isEmpty();
    }

    @Override
    @NotNull
    public List<JSRecordType.IndexSignature> getIndexSignatures() {
        List<JSRecordType.IndexSignature> list = this.myIndexSignatures;
        if (list == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(74);
        }
        return list;
    }

    @Override
    @NotNull
    public final List<JSRecordType.CallSignature> getCallSignatures() {
        List<JSRecordType.CallSignature> list = this.myCallSignatures;
        if (list == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(75);
        }
        return list;
    }

    @Override
    @NotNull
    public final Set<String> getPropertyNames() {
        Set<String> keys = this.myProperties.keySet();
        if (this.myComputedProperties.isEmpty()) {
            Set<String> set = keys;
            if (set == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(76);
            }
            return set;
        }
        Set set = ContainerUtil.union((Set)ContainerUtil.map2Set(this.myComputedProperties, p -> p.getMemberName()), keys);
        if (set == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(77);
        }
        return set;
    }

    @Override
    public final @Unmodifiable @NotNull Collection<JSRecordType.PropertySignature> getProperties() {
        Collection<JSRecordType.PropertySignature> props = this.myProperties.values();
        if (this.myComputedProperties.isEmpty()) {
            Collection<JSRecordType.PropertySignature> collection = props;
            if (collection == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(78);
            }
            return collection;
        }
        ArrayList<JSRecordType.PropertySignature> result2 = new ArrayList<JSRecordType.PropertySignature>(props.size() + this.myComputedProperties.size());
        result2.addAll(props);
        result2.addAll(this.myComputedProperties);
        ArrayList<JSRecordType.PropertySignature> arrayList = result2;
        if (arrayList == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(79);
        }
        return arrayList;
    }

    @Override
    public final boolean hasMembers() {
        return !this.myAllTypeMembers.isEmpty();
    }

    @Override
    public final boolean hasProperties() {
        return !this.myProperties.isEmpty() || !this.myComputedProperties.isEmpty();
    }

    @Override
    @Nullable
    public final JSRecordType.PropertySignature findPropertySignature(@NotNull String name) {
        JSRecordType.PropertySignature signature;
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(80);
        }
        if ((signature = this.myProperties.get(name)) != null || this.myComputedProperties.isEmpty()) {
            return signature;
        }
        for (JSRecordType.PropertySignature property : this.myComputedProperties) {
            if (!name.equals(property.getMemberName())) continue;
            return property;
        }
        return null;
    }

    @Override
    @Nullable
    public JSRecordType.PropertySignature findComputedPropertySignatureByKeyType(@NotNull JSType jsType) {
        if (jsType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(81);
        }
        for (JSRecordType.PropertySignature property : this.myComputedProperties) {
            JSRecordType.ComputedMember computedMember;
            if (!(property instanceof JSRecordType.ComputedMember) || !jsType.equals((computedMember = (JSRecordType.ComputedMember)((Object)property)).getTypeForComputedName())) continue;
            return property;
        }
        return null;
    }

    @Override
    @Nullable
    public final JSRecordType.PropertySignature findPrivatePropertySignature(@NotNull String name, int depth) {
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(82);
        }
        return this.myPrivateProperties.get(name + "~" + depth);
    }

    @Override
    public final void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(83);
        }
        for (JSRecordType.TypeMember typeMember : this.myAllTypeMembers) {
            typeMember.acceptChildren(visitor);
        }
    }

    @Override
    @NotNull
    protected final JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        if (childTransform == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(84);
        }
        if (newSource == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(85);
        }
        List<JSRecordType.TypeMember> oldMembers = this.getTypeMembers();
        ArrayList<JSRecordType.TypeMember> newMembers = new ArrayList<JSRecordType.TypeMember>(oldMembers.size());
        for (JSRecordType.TypeMember member : oldMembers) {
            newMembers.add(member.copyTypeHierarchy(childTransform));
        }
        if (ContainerUtil.equalsIdentity(oldMembers, newMembers)) {
            JSRecordTypeImpl jSRecordTypeImpl = this;
            if (jSRecordTypeImpl == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(86);
            }
            return jSRecordTypeImpl;
        }
        JSRecordTypeImpl jSRecordTypeImpl = this.createInstance(newSource, newMembers, true, childTransform instanceof JSCopyWithStrictTransformer);
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(87);
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    protected JSRecordTypeImpl createInstance(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> newMembers, boolean membersChanged, boolean strictnessOnly) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(88);
        }
        if (newMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(89);
        }
        return membersChanged ? new JSRecordTypeImpl(source, newMembers) : new JSRecordTypeImpl(source, this.myAllTypeMembers, this.myCallSignatures, this.myIndexSignatures, this.myProperties, this.myPrivateProperties, this.myComputedProperties, this.myIsWeakType);
    }

    @Override
    @NotNull
    protected final JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(90);
        }
        JSRecordTypeImpl jSRecordTypeImpl = this.createInstance(source, this.myAllTypeMembers, false, false);
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(91);
        }
        return jSRecordTypeImpl;
    }

    @Override
    @Nullable
    public final JSRecordType.IndexSignature findIndexer(@NotNull JSRecordType.IndexSignatureKind kind) {
        if (kind == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(92);
        }
        return switch (kind) {
            case JSRecordType.IndexSignatureKind.STRING -> this.findIndexer(JSStringType.class);
            case JSRecordType.IndexSignatureKind.NUMERIC -> this.findIndexer(JSNumberType.class);
            default -> null;
        };
    }

    @Override
    @Nullable
    public JSRecordType.IndexSignature findIndexer(@NotNull Class<? extends JSType> parameterTypeClass) {
        if (parameterTypeClass == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(93);
        }
        for (JSRecordType.IndexSignature indexSignature : this.myIndexSignatures) {
            JSType parameterType = indexSignature.getMemberParameterType();
            if (!parameterTypeClass.isInstance(parameterType)) continue;
            return indexSignature;
        }
        return null;
    }

    @Nullable
    public static JSRecordType.IndexSignature findApplicableIndexer(@NotNull JSRecordType sourceType, @NotNull JSType keyType2) {
        if (sourceType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(94);
        }
        if (keyType2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(95);
        }
        JSRecordType.IndexSignature stringIndexer = null;
        SmartList applicableIndexers = new SmartList();
        for (JSRecordType.IndexSignature indexSignature : sourceType.getIndexSignatures()) {
            JSType parameterType = indexSignature.getMemberParameterType();
            if (parameterType instanceof JSStringType) {
                stringIndexer = indexSignature;
                continue;
            }
            if (!JSRecordTypeImpl.isApplicableIndexType(keyType2, parameterType)) continue;
            applicableIndexers.add(indexSignature);
        }
        if (applicableIndexers.size() > 1) {
            ArrayList<PsiElement> sourceElements = new ArrayList<PsiElement>();
            ArrayList<JSType> memberTypes = new ArrayList<JSType>();
            for (JSRecordType.IndexSignature indexer : applicableIndexers) {
                sourceElements.addAll(indexer.getMemberSource().getAllSourceElements());
                memberTypes.add(indexer.getMemberType());
            }
            JSType memberType = JSCompositeTypeFactory.createIntersectionType(memberTypes, sourceType.getSource());
            JSRecordType.MemberSource memberSource = JSRecordMemberSourceFactory.createSource(sourceElements, JSRecordType.MemberSourceKind.Intersection, true);
            return new IndexSignatureImpl((JSType)JSUnknownType.TS_INSTANCE, memberType, memberSource, false);
        }
        if (applicableIndexers.size() == 1) {
            return (JSRecordType.IndexSignature)applicableIndexers.get(0);
        }
        if (stringIndexer != null && JSRecordTypeImpl.isApplicableIndexType(keyType2, JSStringType.STRING_EMPTY_EXPLICIT_TYPE)) {
            return stringIndexer;
        }
        return null;
    }

    public static boolean isPropNameApplicableToIndexType(@NotNull String name, @NotNull JSType target2, @Nullable PsiElement context2) {
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(96);
        }
        if (target2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(97);
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(context2, true);
        JSStringLiteralTypeImpl literalType = new JSStringLiteralTypeImpl(name, false, source);
        return JSRecordTypeImpl.isApplicableIndexType(literalType, target2);
    }

    public static boolean isApplicableIndexType(@NotNull JSType source, @NotNull JSType target2) {
        ProcessingContext processingContext;
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(98);
        }
        if (target2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(99);
        }
        if (target2.isDirectlyAssignableType(source, processingContext = JSTypeComparingContextService.createProcessingContextWithCache(target2.getSourceElement()))) {
            return true;
        }
        if (target2 instanceof JSStringType && JSNumberType.NUMBER_EMPTY_EXPLICIT_TYPE.isDirectlyAssignableType(source, processingContext)) {
            return true;
        }
        return target2 instanceof JSNumberType && (source instanceof JSForInStringType || source instanceof JSStringLiteralTypeImpl && JSRecordTypeImpl.isNumericallyNamedString(((JSStringLiteralTypeImpl)source).getLiteral()));
    }

    public static boolean isValidIndexerParameterType(@Nullable JSType type2) {
        if (type2 instanceof JSLiteralType) {
            return false;
        }
        if (type2 instanceof JSIntersectionType) {
            return ContainerUtil.exists(((JSIntersectionType)type2).getTypes(), t -> JSRecordTypeImpl.isValidIndexerParameterType(t));
        }
        return type2 instanceof JSStringType || type2 instanceof JSNumberType || type2 instanceof JSSymbolType || TypeScriptTypeRelations.isPatternLiteralType(type2);
    }

    @NotNull
    private static Collection<JSRecordType.IndexSignature> normalizeIndexSignatures(@NotNull JSRecordType.IndexSignature indexSignature) {
        JSType parameterType;
        if (indexSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(100);
        }
        if ((parameterType = indexSignature.getMemberParameterType()) instanceof JSUnionType) {
            JSType memberType = indexSignature.getMemberType();
            JSRecordType.MemberSource memberSource = indexSignature.getMemberSource();
            List list = ContainerUtil.mapNotNull(((JSUnionType)parameterType).getTypes(), t -> new IndexSignatureImpl((JSType)t, memberType, memberSource, false));
            if (list == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(101);
            }
            return list;
        }
        List<JSRecordType.IndexSignature> list = Collections.singletonList(indexSignature);
        if (list == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(102);
        }
        return list;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordTypeImpl jSRecordTypeImpl = this;
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(103);
        }
        return jSRecordTypeImpl;
    }

    @Override
    @NotNull
    protected Stream<JSType> getFunctionTypesImpl(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(104);
        }
        Stream<JSType> stream = this.getCallSignatures().stream().filter(typeMember -> typeMember.hasNew() == newCallSignatures).map(JSRecordType.CallSignature::getFunctionType);
        if (stream == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(105);
        }
        return stream;
    }

    @Override
    protected int hashCodeImpl() {
        return JSTypeHashCodeUtil.getMembersHashCode(this.getTypeMembers());
    }

    @Override
    public final boolean isWeak() {
        return this.myIsWeakType;
    }

    @NotNull
    public static JSRecordType.MemberSource getUpdatedTypeMemberSource(@NotNull JSRecordType.MemberSource oldMemberSource, @NotNull Function<? super JSType, ? extends JSType> childTransform) {
        if (oldMemberSource == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(106);
        }
        if (childTransform == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(107);
        }
        if (childTransform instanceof JSTypeBaseImpl.SourceTransformer && ((JSTypeBaseImpl.SourceTransformer)childTransform).isNullizeRecordMemberSource()) {
            JSRecordType.MemberSource memberSource = JSRecordMemberSourceFactory.createSource(null, oldMemberSource.getSourceKind());
            if (memberSource == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(108);
            }
            return memberSource;
        }
        JSRecordType.MemberSource memberSource = oldMemberSource;
        if (memberSource == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(109);
        }
        return memberSource;
    }

    private static /* synthetic */ boolean lambda$membersAssignableToIndexInfo$1(JSRecordType sourceType, JSType parameterType, JSType memberType, ProcessingContext genericsProcessingContext) {
        for (JSRecordType.PropertySignature property : sourceType.getProperties()) {
            JSType type2;
            JSType propertyNameType = JSRecordTypeImpl.getLiteralTypeFromPropertyName(property);
            if (propertyNameType == null || !JSRecordTypeImpl.isApplicableIndexType(propertyNameType, parameterType) || (type2 = property.getJSType()) == null || memberType.isDirectlyAssignableType(type2, genericsProcessingContext)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 25, 72, 74, 75, 76, 77, 78, 79, 86, 87, 91, 101, 102, 103, 105, 108, 109 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMembers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allTypeMembers";
                break;
            }
            case 6: 
            case 37: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSignatures";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSignatures";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "privateProperties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computedProperties";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSignature";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stored";
                break;
            }
            case 15: 
            case 25: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 86: 
            case 87: 
            case 91: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 108: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl";
                break;
            }
            case 16: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composite";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProperty";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 45: 
            case 63: 
            case 68: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 28: 
            case 30: 
            case 34: 
            case 38: 
            case 40: 
            case 43: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 41: 
            case 44: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSignature";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 51: 
            case 59: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undefinedType";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherSignature";
                break;
            }
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSignature";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rest";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSignature";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherFunctionType";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionRecord";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherMembers";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 73: 
            case 80: 
            case 82: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 84: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMembers";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypeClass";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 97: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMemberSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSignatures";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRecordTypeIfPossible";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMembers";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexSignatures";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallSignatures";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeIndexSignatures";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypesImpl";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedTypeMemberSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mergeSignatures";
                break;
            }
            case 15: 
            case 25: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 86: 
            case 87: 
            case 91: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 108: 
            case 109: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionItem";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyToCompositeFunctions";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "convertToRecordTypeIfPossible";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "canSubstitute";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isObject";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableRecordType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkObjectLiteralProperties";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkWeakTypeCondition";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkCallSignatureExistence";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertyTypes";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "checkCallSignatureTypes";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkIndexSignatures";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkIndexSignature";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "membersAssignableToIndexInfo";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralTypeFromPropertyName";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isNumericallyNamedString";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isExpressionBasedType";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isObjectType";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isObjectLiteralType";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isUndefinedProperty";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertySignatureAssignable";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "checkCallSignaturesAssignable";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "simpleCheckCallSignatureAssignable";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignableForCallSignatures";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionsArgumentsAndReturnType";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionInterfaceProperties";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "checkSources";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "areMembersEqual";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "hasProperty";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "findPropertySignature";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "findComputedPropertySignatureByKeyType";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "findPrivatePropertySignature";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "findIndexer";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "findApplicableIndexer";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isPropNameApplicableToIndexType";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableIndexType";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "normalizeIndexSignatures";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesImpl";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedTypeMemberSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 25, 72, 74, 75, 76, 77, 78, 79, 86, 87, 91, 101, 102, 103, 105, 108, 109 -> new IllegalStateException(string);
        };
    }

    private static interface PropertyTypeChecker {
        public boolean check(@NotNull ProcessingContext var1);
    }

    @Deprecated
    public static class PropertySignatureImpl
    extends com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl {
        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type2, boolean optional, boolean isReadonly, @Nullable PsiElement singleSource) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(0);
            }
            super(name, type2, optional, isReadonly, singleSource);
        }

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type2, boolean optional, boolean isReadonly) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(1);
            }
            super(name, type2, optional, isReadonly);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl", "<init>"));
        }
    }
}

